/* MSA spectrum analyzer
 * Copyright (C) 2000 Michal Kunikowski <kunik@poczta.onet.pl>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include "msa.h"
#include "msa_config.h"
#include "msa_skin.h"

#include "debug.h"

#define _( x ) (x)

static GtkWidget *msa_config_win = NULL;

struct skinnode {
	gchar *path;
	gchar *name;
};

static GtkWidget *vbox1;
static GtkWidget *notebook_main;
static GtkWidget *vbox2;
static GtkWidget *frame1;
static GtkWidget *hbox3;
static GtkWidget *checkbutton_reversed;
static GtkWidget *checkbutton_mirrored;
static GtkWidget *frame2;
static GtkWidget *hbox2;
static GtkWidget *radiobutton_none;
static GtkWidget *radiobutton_normal;
static GtkWidget *radiobutton_away;
static GtkWidget *frame3;
static GtkWidget *table1;
static GtkWidget *label11;
static GtkWidget *label12;
static GtkWidget *hscale_barfalloff;
static GtkWidget *hscale_peakdelay;
static GtkWidget *hscale_peakfalloff;
static GtkWidget *label10;
static GtkWidget *label_main;
static GtkWidget *scrolledwindow1;
static GtkWidget *clist_skinlist;
static GtkWidget *label8;
static GtkWidget *label9;
static GtkWidget *label_skin;
static GtkWidget *colorselection;
static GtkWidget *label_color;
static GtkWidget *hbox1;
static GtkWidget *button_close;
static GtkWidget *button_save;

static GtkObject *adjustment_barfalloff;
static GtkObject *adjustment_peakfalloff;
static GtkObject *adjustment_peakdelay;

void msaconfig_update_checkbutton_reversed()
{
	if (!msa_config_win) return;
	if (msacfg.reverse_mode == GTK_TOGGLE_BUTTON(checkbutton_reversed)->active) return;
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton_reversed), msacfg.reverse_mode);
}

void msaconfig_update_checkbutton_mirrored()
{
	if (!msa_config_win) return;
	if (msacfg.mirror_mode == GTK_TOGGLE_BUTTON(checkbutton_mirrored)->active) return;
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton_mirrored), msacfg.mirror_mode);
}

void msaconfig_update_peakmodebtn()
{
	if (!msa_config_win) return;
	if ( (msacfg.peak_mode==0 && GTK_TOGGLE_BUTTON(radiobutton_none)->active) ||
	     (msacfg.peak_mode==1 && GTK_TOGGLE_BUTTON(radiobutton_normal)->active) ||
	     (msacfg.peak_mode==2 && GTK_TOGGLE_BUTTON(radiobutton_away)->active) ) return;
	if      (msacfg.peak_mode==0) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobutton_none), TRUE);
	else if (msacfg.peak_mode==1) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobutton_normal), TRUE);
	else if (msacfg.peak_mode==2) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobutton_away), TRUE);
}

void msaconfig_update_barfalloffsc()
{
	if (!msa_config_win) return;
	gtk_adjustment_set_value(GTK_ADJUSTMENT(adjustment_barfalloff), msacfg.bar_falloff);
}

void msaconfig_update_peakfalloffsc()
{
	if (!msa_config_win) return;
	gtk_adjustment_set_value(GTK_ADJUSTMENT(adjustment_peakfalloff), msacfg.peak_falloff);
}

void msaconfig_update_peakdelaysc()
{
	if (!msa_config_win) return;
	gtk_adjustment_set_value(GTK_ADJUSTMENT(adjustment_peakdelay), msacfg.peak_delay);
}


/*
 * SKIN
 */

static void cb_skinselected(GtkCList *clist, gint row, gint column, GdkEventButton *event, gpointer user_data)
{
	gchar *path;
	
//	path = gtk_clist_get_row_data(clist, row);
	gtk_clist_get_text(clist, row, 1, &path);

	DPRINT(1, "xmms plugin: config: skin select: row %d: %s\n", row, path);
	
	if (strcmp(msacfg.skindir, path)==0) return;

	strcpy(msacfg.skindir, path);
	setskin(TRUE);
}

static void destroylistelem(gpointer data)
{
	DPRINT(1, "About to destroy %s\n", (char *)data);
	g_free(data);
}

static void addskin(char *name, char *path)
{
	int rownum;
	char *column[2];
	column[0] = name;
	column[1] = path;
	rownum = gtk_clist_append(GTK_CLIST(clist_skinlist), column);
//	gtk_clist_set_row_data_full(GTK_CLIST(clist_skinlist), rownum, pbuf, destroylistelem);
}

static void scanskindir(char *path)
{
	DIR *dir;
	struct dirent *de;
	struct stat statbuf;
	char *file;

	DPRINT(1, "scanskindir(%s)\n", path);
	
	if ((dir=opendir(path))) {
		while ((de=readdir(dir))) {
			if (strcmp(de->d_name, ".")!=0 && strcmp(de->d_name, "..")!=0) {
				file = g_strdup_printf("%s/%s", path, de->d_name);
				if (!lstat(file, &statbuf) && S_ISDIR(statbuf.st_mode)) addskin(de->d_name, file);
				g_free(file);
			}
		}
		closedir(dir);
	}
}

static void scanskins()
{
	int i;
	char *path;
	
	gtk_clist_freeze(GTK_CLIST(clist_skinlist));
	gtk_clist_clear(GTK_CLIST(clist_skinlist));
	
	scanskindir("/usr/share/xmms/MSASkins");
	path = g_strconcat(g_get_home_dir(), "/.xmms/MSASkins", NULL);
	scanskindir(path);
	g_free(path);

	addskin("Default (green)", "[" GREEN_SKIN_COLOR "]");
	addskin("Default (blue)",  "[" BLUE_SKIN_COLOR "]");
	addskin("Default (amber)", "[" AMBER_SKIN_COLOR "]");
	addskin("(default)", "");
	
	// sort list
	gtk_clist_set_sort_column( GTK_CLIST(clist_skinlist), 0 );
	gtk_clist_set_sort_type( GTK_CLIST(clist_skinlist), GTK_SORT_ASCENDING );
	gtk_clist_sort( GTK_CLIST(clist_skinlist) );

	// select row
	gtk_clist_select_row(GTK_CLIST(clist_skinlist), 0, 0);
	gtk_clist_moveto(GTK_CLIST(clist_skinlist), 0, 0, 0.5, 0.5);
	for (i=0; gtk_clist_get_text(GTK_CLIST(clist_skinlist), i, 1, &path); i++) {
		if (strcmp(msacfg.skindir, path) == 0) {
			gtk_clist_select_row(GTK_CLIST(clist_skinlist), i, 0);
			gtk_clist_moveto(GTK_CLIST(clist_skinlist), i, 0, 0.5, 0.5);
			break;
		}
	}

	gtk_clist_thaw(GTK_CLIST(clist_skinlist));
}
/*
 * SKIN
 */


static void cb_reverse_mode(GtkWidget *wid, char *data)
{
	DPRINT(1, "msa_config [cb_reverse_mode]: turned %s\n",GTK_TOGGLE_BUTTON(wid)->active?"on":"off");

	set_reverse_mode(GTK_TOGGLE_BUTTON(wid)->active);
}

static void cb_mirror_mode(GtkWidget *wid, char *data)
{
	DPRINT(1, "msa_config [cb_mirror_mode]: turned %s\n",GTK_TOGGLE_BUTTON(wid)->active?"on":"off");

	set_mirror_mode(GTK_TOGGLE_BUTTON(wid)->active);
}

static void cb_peakmode(GtkWidget *wid, char *data)
{
	DPRINT(1, "peakmode: %d turned %s\n",data[0]-48,GTK_TOGGLE_BUTTON(wid)->active?"on":"off");

	if (GTK_TOGGLE_BUTTON(wid)->active) msacfg.peak_mode = data[0] - 48;
}

static void cb_scale(GtkAdjustment *adj, gint *data)
{
	DPRINT(1, "cb_scale: %d\n",(gint)adj->value);

	*data=(gint)adj->value;
}

static void cb_cbutton(GtkWidget *wid, gint *data)
{
	DPRINT(1, "cb_button: %s\n",GTK_TOGGLE_BUTTON(wid)->active?"on":"off");

	*data = GTK_TOGGLE_BUTTON(wid)->active?1:0;
}

static void cb_button_save_config(GtkWidget *widget, GtkWidget *entry)
{
	DPRINT(1, "xmms plugin: saving config\n");

	save_msa_config();
}

void callback_color_changed(GtkColorSelection *colorselection, gpointer user_data)
{
	gdouble floatcolor[4];
	int i;
	
	DPRINT(1, "callback_color_changed\n");
	
	gtk_color_selection_get_color(colorselection, floatcolor);
	for (i=0; i<4; i++) msacfg.color[3][i] = (gint)(floatcolor[i]*255*1.00);
	for (i=0; i<4; i++) msacfg.color[2][i] = (gint)(floatcolor[i]*255*0.49);
	for (i=0; i<4; i++) msacfg.color[1][i] = (gint)(floatcolor[i]*255*0.21);
	for (i=0; i<4; i++) msacfg.color[0][i] = (gint)(floatcolor[i]*255*0.00);
	
	if (strcmp(msacfg.skindir, "") != 0) return;
	setskin(FALSE);
}


void msa_config(void)
{
	gdouble floatcolor[4];
	int i;
	
	if (msa_config_win) return;
	msa_config_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(msa_config_win), MSA_VERSION_STRING " Config");
	gtk_window_set_policy(GTK_WINDOW(msa_config_win), FALSE, FALSE, FALSE);
	gtk_window_set_position(GTK_WINDOW(msa_config_win), GTK_WIN_POS_MOUSE);
	gtk_container_border_width(GTK_CONTAINER(msa_config_win), 10);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (msa_config_win), vbox1);
	
	notebook_main = gtk_notebook_new ();
	gtk_box_pack_start (GTK_BOX (vbox1), notebook_main, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (notebook_main), 5);
	
	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (notebook_main), vbox2);
	gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);
	
	frame1 = gtk_frame_new (_("Analyzer Mode"));
	gtk_box_pack_start (GTK_BOX (vbox2), frame1, FALSE, TRUE, 0);
	
	hbox3 = gtk_hbox_new (TRUE, 0);
	gtk_container_add (GTK_CONTAINER (frame1), hbox3);
	gtk_container_set_border_width (GTK_CONTAINER (hbox3), 5);
	
	checkbutton_reversed = gtk_check_button_new_with_label (_("Reversed"));
	gtk_box_pack_start (GTK_BOX (hbox3), checkbutton_reversed, FALSE, FALSE, 0);
	
	checkbutton_mirrored = gtk_check_button_new_with_label (_("Mirrored"));
	gtk_box_pack_start (GTK_BOX (hbox3), checkbutton_mirrored, FALSE, FALSE, 0);
	
	frame2 = gtk_frame_new (_("Peak Mode"));
	gtk_box_pack_start (GTK_BOX (vbox2), frame2, TRUE, TRUE, 0);
	
	hbox2 = gtk_hbox_new (TRUE, 0);
	gtk_container_add (GTK_CONTAINER (frame2), hbox2);
	gtk_container_set_border_width (GTK_CONTAINER (hbox2), 5);
	
	radiobutton_none   = gtk_radio_button_new_with_label(NULL, "None");
	radiobutton_normal = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radiobutton_none)), "Normal");
	radiobutton_away   = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radiobutton_normal)), "Away");
	gtk_box_pack_start (GTK_BOX (hbox2), radiobutton_none, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox2), radiobutton_normal, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox2), radiobutton_away, FALSE, FALSE, 0);
	
	frame3 = gtk_frame_new (_("Speed"));
	gtk_box_pack_start (GTK_BOX (vbox2), frame3, FALSE, TRUE, 0);
	
	table1 = gtk_table_new (3, 2, FALSE);
	gtk_container_add (GTK_CONTAINER (frame3), table1);
	gtk_container_set_border_width (GTK_CONTAINER (table1), 5);
	
	label11 = gtk_label_new (_("Peak falloff"));
	gtk_table_attach (GTK_TABLE (table1), label11, 0, 1, 1, 2,
	                  (GtkAttachOptions) (0),
	                  (GtkAttachOptions) (0), 0, 0);
	
	label12 = gtk_label_new (_("Peak delay"));
	gtk_table_attach (GTK_TABLE (table1), label12, 0, 1, 2, 3,
	                  (GtkAttachOptions) (0),
	                  (GtkAttachOptions) (0), 0, 0);
	
	adjustment_barfalloff = gtk_adjustment_new (2, 1, 10, 0, 0, 0);
	hscale_barfalloff = gtk_hscale_new (GTK_ADJUSTMENT (adjustment_barfalloff));
	gtk_table_attach (GTK_TABLE (table1), hscale_barfalloff, 1, 2, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_scale_set_digits (GTK_SCALE (hscale_barfalloff), 0);
	
	adjustment_peakdelay = gtk_adjustment_new (20, 0, 50, 0, 0, 0);
	hscale_peakdelay = gtk_hscale_new (GTK_ADJUSTMENT (adjustment_peakdelay));
	gtk_table_attach (GTK_TABLE (table1), hscale_peakdelay, 1, 2, 2, 3,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_scale_set_digits (GTK_SCALE (hscale_peakdelay), 0);
	
	adjustment_peakfalloff = gtk_adjustment_new (2, 1, 10, 0, 0, 0);
	hscale_peakfalloff = gtk_hscale_new (GTK_ADJUSTMENT(adjustment_peakfalloff));
	gtk_table_attach (GTK_TABLE (table1), hscale_peakfalloff, 1, 2, 1, 2,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_scale_set_digits (GTK_SCALE (hscale_peakfalloff), 0);
	
	label10 = gtk_label_new (_("Bar falloff"));
	gtk_table_attach (GTK_TABLE (table1), label10, 0, 1, 0, 1,
	                  (GtkAttachOptions) (0),
	                  (GtkAttachOptions) (0), 0, 0);
	
	label_main = gtk_label_new (_("Main"));
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook_main), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook_main), 0), label_main);
	gtk_misc_set_padding (GTK_MISC (label_main), 10, 0);
	
	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_add (GTK_CONTAINER (notebook_main), scrolledwindow1);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	
	clist_skinlist = gtk_clist_new (2);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), clist_skinlist);
	gtk_clist_set_column_width (GTK_CLIST (clist_skinlist), 0, 132);
	gtk_clist_set_column_width (GTK_CLIST (clist_skinlist), 1, 80);
	gtk_clist_set_selection_mode (GTK_CLIST (clist_skinlist), GTK_SELECTION_BROWSE);
	gtk_clist_column_titles_show (GTK_CLIST (clist_skinlist));
	
	label8 = gtk_label_new (_("Name"));
	gtk_clist_set_column_widget (GTK_CLIST (clist_skinlist), 0, label8);
	
	label9 = gtk_label_new (_("Path"));
	gtk_clist_set_column_widget (GTK_CLIST (clist_skinlist), 1, label9);
	
	label_skin = gtk_label_new (_("Skin"));
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook_main), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook_main), 1), label_skin);
	gtk_misc_set_padding (GTK_MISC (label_skin), 10, 0);
	
	colorselection = gtk_color_selection_new ();
	gtk_color_selection_set_update_policy (GTK_COLOR_SELECTION(colorselection), GTK_UPDATE_DELAYED);
	gtk_container_add (GTK_CONTAINER (notebook_main), colorselection);
	gtk_widget_set_usize (colorselection, 444, -2);
	
	label_color = gtk_label_new (_("Color"));
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook_main), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook_main), 2), label_color);
	
	hbox1 = gtk_hbox_new (TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 5);
	gtk_container_set_border_width (GTK_CONTAINER (hbox1), 1);
	
	button_close = gtk_button_new_with_label (_("Close"));
	gtk_box_pack_start (GTK_BOX (hbox1), button_close, FALSE, TRUE, 15);
	GTK_WIDGET_SET_FLAGS (button_close, GTK_CAN_DEFAULT);
	
	button_save = gtk_button_new_with_label (_("Save"));
	gtk_box_pack_start (GTK_BOX (hbox1), button_save, FALSE, TRUE, 15);
	GTK_WIDGET_SET_FLAGS (button_save, GTK_CAN_DEFAULT);
	
	gtk_widget_grab_default (button_close);

	/*
	 * Set values
	 */
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton_reversed), (gboolean)msacfg.reverse_mode);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton_mirrored), (gboolean)msacfg.mirror_mode);
	
	if      (msacfg.peak_mode==0) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobutton_none), TRUE);
	else if (msacfg.peak_mode==1) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobutton_normal), TRUE);
	else if (msacfg.peak_mode==2) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobutton_away), TRUE);

	gtk_adjustment_set_value(GTK_ADJUSTMENT(adjustment_barfalloff), msacfg.bar_falloff);
	gtk_adjustment_set_value(GTK_ADJUSTMENT(adjustment_peakfalloff), msacfg.peak_falloff);
	gtk_adjustment_set_value(GTK_ADJUSTMENT(adjustment_peakdelay), msacfg.peak_delay);
	
	for (i=0; i<4; i++) floatcolor[i] = (gdouble)msacfg.color[3][i]/255;
	gtk_color_selection_set_color(GTK_COLOR_SELECTION(colorselection), floatcolor);
		
	scanskins();
	
	/*
	 * Set callbacks
	 */
	gtk_signal_connect(GTK_OBJECT(msa_config_win), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &msa_config_win);
	
	gtk_signal_connect(GTK_OBJECT(checkbutton_reversed), "toggled", GTK_SIGNAL_FUNC(cb_reverse_mode), NULL);
	gtk_signal_connect(GTK_OBJECT(checkbutton_mirrored), "toggled", GTK_SIGNAL_FUNC(cb_mirror_mode), NULL);
	
	gtk_signal_connect(GTK_OBJECT(radiobutton_none),   "toggled", GTK_SIGNAL_FUNC(cb_peakmode), (gpointer)"0");
	gtk_signal_connect(GTK_OBJECT(radiobutton_normal), "toggled", GTK_SIGNAL_FUNC(cb_peakmode), (gpointer)"1");
	gtk_signal_connect(GTK_OBJECT(radiobutton_away),   "toggled", GTK_SIGNAL_FUNC(cb_peakmode), (gpointer)"2");
	
	gtk_signal_connect(GTK_OBJECT(adjustment_barfalloff),  "value_changed", GTK_SIGNAL_FUNC(cb_scale), &msacfg.bar_falloff);
	gtk_signal_connect(GTK_OBJECT(adjustment_peakfalloff), "value_changed", GTK_SIGNAL_FUNC(cb_scale), &msacfg.peak_falloff);
	gtk_signal_connect(GTK_OBJECT(adjustment_peakdelay),   "value_changed", GTK_SIGNAL_FUNC(cb_scale), &msacfg.peak_delay);

	gtk_signal_connect_object(GTK_OBJECT(button_close), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(msa_config_win));
	gtk_signal_connect_object(GTK_OBJECT(button_save),  "clicked", GTK_SIGNAL_FUNC(cb_button_save_config), NULL);
	gtk_signal_connect_object(GTK_OBJECT(button_save),  "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(msa_config_win));

	gtk_signal_connect(GTK_OBJECT(clist_skinlist), "select-row", GTK_SIGNAL_FUNC(cb_skinselected), NULL);

	gtk_signal_connect(GTK_OBJECT(colorselection), "color-changed", GTK_SIGNAL_FUNC(callback_color_changed), NULL);
	
	
//	gtk_widget_set_sensitive(GTK_WIDGET(colorselection), FALSE);
//	gtk_widget_set_sensitive(GTK_WIDGET(label_color), FALSE);
	
	gtk_widget_show_all( msa_config_win );
}
