// InteropEchoProxy.h - xmlrpc-c C++ proxy class
// Auto-generated by xml-rpc-api2cpp.

#ifndef _InteropEchoProxy_H_
#define _InteropEchoProxy_H_ 1

#include <XmlRpcCpp.h>

class InteropEchoProxy {
    XmlRpcClient mClient;

public:
    InteropEchoProxy (const XmlRpcClient& client)
        : mClient(client) {}
    InteropEchoProxy (const string& server_url)
        : mClient(XmlRpcClient(server_url)) {}
    InteropEchoProxy (const InteropEchoProxy& o)
        : mClient(o.mClient) {}

    InteropEchoProxy& operator= (const InteropEchoProxy& o) {
        if (this != &o) mClient = o.mClient;
        return *this;
    }

    /* Echo an arbitrary XML-RPC string. */
    string echoString (string string1);

    /* Echo an arbitrary XML-RPC integer. */
    XmlRpcValue::int32 echoInteger (XmlRpcValue::int32 int1);

    /* Echo an arbitrary XML-RPC float. */
    double echoFloat (double double1);

    /* Echo an arbitrary XML-RPC struct. */
    XmlRpcValue /*struct*/ echoStruct (XmlRpcValue /*struct*/ struct1);

    /* Echo an array of arbitrary XML-RPC strings. */
    XmlRpcValue /*array*/ echoStringArray (XmlRpcValue /*array*/ array1);

    /* Echo an array of arbitrary XML-RPC integers. */
    XmlRpcValue /*array*/ echoIntegerArray (XmlRpcValue /*array*/ array1);

    /* Echo an array of arbitrary XML-RPC floats. */
    XmlRpcValue /*array*/ echoFloatArray (XmlRpcValue /*array*/ array1);

    /* Echo an array of arbitrary XML-RPC structs. */
    XmlRpcValue /*array*/ echoStructArray (XmlRpcValue /*array*/ array1);
};

#endif /* _InteropEchoProxy_H_ */

// InteropEchoProxy.cc - xmlrpc-c C++ proxy class
// Auto-generated by xml-rpc-api2cpp.

#include <XmlRpcCpp.h>
#include "InteropEchoProxy.h"

string InteropEchoProxy::echoString (string string1) {
    XmlRpcValue params = XmlRpcValue::makeArray();
    params.arrayAppendItem(XmlRpcValue::makeString(string1));
    XmlRpcValue result = this->mClient.call("interopEchoTests.echoString", params);
    return result.getString();
}

XmlRpcValue::int32 InteropEchoProxy::echoInteger (XmlRpcValue::int32 int1) {
    XmlRpcValue params = XmlRpcValue::makeArray();
    params.arrayAppendItem(XmlRpcValue::makeInt(int1));
    XmlRpcValue result = this->mClient.call("interopEchoTests.echoInteger", params);
    return result.getInt();
}

double InteropEchoProxy::echoFloat (double double1) {
    XmlRpcValue params = XmlRpcValue::makeArray();
    params.arrayAppendItem(XmlRpcValue::makeDouble(double1));
    XmlRpcValue result = this->mClient.call("interopEchoTests.echoFloat", params);
    return result.getDouble();
}

XmlRpcValue /*struct*/ InteropEchoProxy::echoStruct (XmlRpcValue /*struct*/ struct1) {
    XmlRpcValue params = XmlRpcValue::makeArray();
    params.arrayAppendItem(struct1);
    XmlRpcValue result = this->mClient.call("interopEchoTests.echoStruct", params);
    return result;
}

XmlRpcValue /*array*/ InteropEchoProxy::echoStringArray (XmlRpcValue /*array*/ array1) {
    XmlRpcValue params = XmlRpcValue::makeArray();
    params.arrayAppendItem(array1);
    XmlRpcValue result = this->mClient.call("interopEchoTests.echoStringArray", params);
    return result;
}

XmlRpcValue /*array*/ InteropEchoProxy::echoIntegerArray (XmlRpcValue /*array*/ array1) {
    XmlRpcValue params = XmlRpcValue::makeArray();
    params.arrayAppendItem(array1);
    XmlRpcValue result = this->mClient.call("interopEchoTests.echoIntegerArray", params);
    return result;
}

XmlRpcValue /*array*/ InteropEchoProxy::echoFloatArray (XmlRpcValue /*array*/ array1) {
    XmlRpcValue params = XmlRpcValue::makeArray();
    params.arrayAppendItem(array1);
    XmlRpcValue result = this->mClient.call("interopEchoTests.echoFloatArray", params);
    return result;
}

XmlRpcValue /*array*/ InteropEchoProxy::echoStructArray (XmlRpcValue /*array*/ array1) {
    XmlRpcValue params = XmlRpcValue::makeArray();
    params.arrayAppendItem(array1);
    XmlRpcValue result = this->mClient.call("interopEchoTests.echoStructArray", params);
    return result;
}
