/*
 * Decompiled with CFR 0.152.
 */
package de.zeigermann.xml.simpleImporter;

import java.util.Collection;
import java.util.Iterator;

public class SimplePath {
    protected String path;

    public static final String stripEndingSlash(String path) {
        if (path != null && path.length() > 0 && path.charAt(path.length() - 1) == '/') {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public boolean matchsAny(Collection paths) {
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            SimplePath matchPath = (SimplePath)it.next();
            if (!this.matches(matchPath)) continue;
            return true;
        }
        return false;
    }

    public boolean matchsAny(String[] paths) {
        int i = 0;
        while (i < paths.length) {
            if (this.matches(paths[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public SimplePath(String path) {
        this.path = SimplePath.stripEndingSlash(path);
    }

    public SimplePath(SimplePath path) {
        this.path = SimplePath.stripEndingSlash(path.toString());
    }

    public boolean matches(SimplePath matchPath) {
        return this.matches(matchPath.toString());
    }

    public boolean matches(String matchPath) {
        String matchString = SimplePath.stripEndingSlash(matchPath);
        if (matchString != null && matchString.length() > 0 && matchString.charAt(0) != '/') {
            return this.path.endsWith(matchString);
        }
        return this.path.equals(matchString);
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (o instanceof String) {
            return this.path.equals(o);
        }
        if (o instanceof SimplePath) {
            return this.path.equals(((SimplePath)o).toString());
        }
        return false;
    }
}

