/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_arg.h 1507 2007-08-15 09:47:34Z paultcochrane $
*/

/*! @file xmds_arg.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_ARG_H
#define XMDS_ARG_H

#include <xmds_argv.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsArg
// *****************************************************************************
// *****************************************************************************

//! xmds arg class
/*!
  The class that handles individual arguments for the simulation command line.
  More specifically, it handles the name, type and default value of arguments
  to be used on the command line.
*/
class xmdsArg {

  public :

    //! Constructor for xmdsArg object
    xmdsArg(
      const xmdsArgv *const yourArgv);

  //! Destructor
  virtual ~xmdsArg();

  //! grabs the argument name
  const XMLString* name() const;

  //! Sets the argument name
  void setName(
               const XMLString& yourName);

 protected:

  //! Obtains an instance of the xmdsArgv object
  const xmdsArgv* argv() const;

  private :

    const xmdsArgv *const myArgv;  //!< The "vector" of arguments
  XMLString             myName;  //!< The name of the argument

};

#endif // XMDS_ARG_H

