#ifndef IMPORT_H
#define IMPORT_H
/*

  "libimport.a" include file for the Xlogmaster
  
  The libimport.a is basically consists of several functions that I had to grab out
  of the GNU C library because they don't exist on all systems.

  For clean separation between the "real" Xlogmaster source and the imported
  functions I created this directory where the libimport.a is built that is linked
  to the Xlogmaster in the end.

  Currently this supplies the following functions the Xlogmaster uses:

  - getopt_long_only()

  - all REGEXP functions from the GNU rx-1.9a


*/

/*
  first include the data from the configuration package if not done
  so already... we need this to assure the flag NEED_LIBIMPORT is
  being set properly.
*/
#include "../config.h"


#if NEED_IMPORT
/* 
   include file for proper GNUish commandline parsing 
*/
#include "getopt.h"

#else
/* 
   include file for proper GNUish commandline parsing 
*/
#include <getopt.h>

#endif /* NEED_IMPORT */

/*
  Here we include the REGEX things... due to lots of different
  implementations for these functions we need to have a certain
  complexity...
*/

#if NEED_OWN_REGEX_H

/*
  Take our own include file...
*/
#include "rx/regex.h"         

#else

#if HAVE_RXPOSIX_H
/*
  Do we have a system wide "rxposix.h" file ?
*/
#include <rxposix.h>

#else 
#if HAVE_RX_RX_H
/*
  ...otherwise: do we have a system wide "rx/rx.h" ?
*/
#include <rx/rx.h>
#else 
#if HAVE_RX_H
/*
  ...otherwise: do we have a system wide "rx.h" ?
*/
#include <rx.h>
#else
#if HAVE_REGEX_H
/*
  ..otherwise: do we have a system wide "regex.h" file ?
*/
#include <regex.h>

#endif /* HAVE_REGEX_H */
#endif /* HAVE_RX_H */
#endif /* HAVE_RX_RX_H */
#endif /* HAVE_RXPOSIX_H */


/*     +++---+++---+++    */
#endif /* NEED_OWN_REGEX_H */


#endif /* IMPORT_H */
