/*

   xlog - GTK+ logging program for amateur radio operators
   Copyright (C) 2001 - 2007 Joop Stakenborg <pg4i@amsat.org>

   This file is part of xlog.

   Xlog is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   Xlog is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with xlog.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * xlog_enum.c - enumeration functions
 */

#include <gtk/gtk.h>
#include <stdlib.h>

#include "xlog_enum.h"

/* translate enumerated band to a meaningful string */
gchar *band_enum2char (guint band_enum)
{
	switch (band_enum)
	{
		case BAND_2190: return g_strdup ("0.136");
  		case BAND_160: return g_strdup ("1.8");
		case BAND_80: return g_strdup ("3.5");
		case BAND_60: return g_strdup ("5.2");
		case BAND_40: return g_strdup ("7");
		case BAND_30: return g_strdup ("10");
		case BAND_20: return g_strdup ("14");
		case BAND_17: return g_strdup ("18");
		case BAND_15: return g_strdup ("21");
		case BAND_12: return g_strdup ("24");
		case BAND_10: return g_strdup ("28");
		case BAND_6: return g_strdup ("50");
		case BAND_4: return g_strdup ("70");
		case BAND_2: return g_strdup ("144");
		case BAND_125CM: return g_strdup ("222");
		case BAND_70CM: return g_strdup ("420");
		case BAND_33CM: return g_strdup ("902");
		case BAND_23CM: return g_strdup ("1240");
		case BAND_13CM: return g_strdup ("2300");
		case BAND_9CM: return g_strdup ("3300");
		case BAND_6CM: return g_strdup ("5650");
		case BAND_3CM: return g_strdup ("10000");
		case BAND_12HMM: return g_strdup ("24000");
		case BAND_6MM: return g_strdup ("47000");
		case BAND_4MM: return g_strdup ("75500");
		case BAND_2HMM: return g_strdup ("120000");
		case BAND_2MM: return g_strdup ("142000");
		case BAND_1MM: return g_strdup ("241000");
		case BAND_SUBMM: return g_strdup ("300000");
	}
	return NULL;
}

/* return band as enum from a given string */
gint
freq2enum (gchar * str)
{
	gchar *p, *temp;
	guint fr;

	temp = g_strdup (str);
	p = g_strrstr (temp, ".");
	if (p)
	{
		*p = '\0';
		fr = atoi (temp);
	}
	else
		fr = atoi (temp);
	g_free (temp);

	switch (fr)
	{
		case 0: return BAND_2190;
		case 1: return BAND_160;
		case 3: return BAND_80;
		case 5: return BAND_60;
		case 7: return BAND_40;
		case 10: return BAND_30;
		case 14: return BAND_20;
		case 18: return BAND_17;
		case 21: return BAND_15;
		case 24: return BAND_12;
		case 28 ... 29: return BAND_10;
		case 50 ... 54: return BAND_6;
		case 70 ... 71: return BAND_4;
		case 144 ... 148: return BAND_2;
		case 222 ... 225: return BAND_125CM;
		case 420 ... 450: return BAND_70CM;
		case 902 ... 928: return BAND_33CM;
		case 1240 ... 1325: return BAND_23CM;
		case 2300 ... 2450: return BAND_13CM;
		case 3300 ... 3500: return BAND_9CM;
		case 5650 ... 5925: return BAND_6CM;
		case 10000 ... 10500: return BAND_3CM;
		case 24000 ... 24250: return BAND_12HMM;
		case 47000 ... 47200: return BAND_6MM;
		case 75500 ... 81000: return BAND_4MM;
		case 119980 ... 120020: return BAND_2HMM;
		case 142000 ... 149000: return BAND_2MM;
		case 241000 ... 250000: return BAND_1MM;
		case 300000 ... 999999: return BAND_SUBMM;
	}
	return -1;
}

/* translate enumerated mode to a meaningful string */
gchar *mode_enum2char (guint mode_enum)
{
	switch (mode_enum)
	{
		case MODE_SSB: return g_strdup("SSB");
		case MODE_CW: return g_strdup("CW");
		case MODE_FM: return g_strdup("FM");
		case MODE_AM: return g_strdup("AM");
		case MODE_ASCI: return g_strdup("ASCI");
		case MODE_ATV: return g_strdup("ATV");
		case MODE_CLO: return g_strdup("CLO");
		case MODE_FAX: return g_strdup("FAX");
		case MODE_GTOR: return g_strdup("GTOR");
		case MODE_HELL: return g_strdup("HELL");
		case MODE_HFSK: return g_strdup("HFSK");
		case MODE_JT44: return g_strdup("JT44");
		case MODE_JT6M: return g_strdup("JT6M");
		case MODE_MFSK8: return g_strdup("MFSK8");
		case MODE_MFSK16: return g_strdup("MFSK16");
		case MODE_MTTY: return g_strdup("MTTY");
		case MODE_MT63: return g_strdup("MT63");
		case MODE_OLIVIA: return g_strdup("OLIVIA");
		case MODE_PAC: return g_strdup("PAC");
		case MODE_PAC2: return g_strdup("PAC2");
		case MODE_PAC3: return g_strdup("PAC3");
		case MODE_PCW: return g_strdup("PCW");
		case MODE_PKT: return g_strdup("");
		case MODE_PSK31: return g_strdup("PSK31");
		case MODE_PSK63: return g_strdup("PSK63");
		case MODE_PSK125: return g_strdup("PSK125");
		case MODE_Q15: return g_strdup("Q15");
		case MODE_RTTY: return g_strdup("RTTY");
		case MODE_SSTV: return g_strdup("SSTV");
		case MODE_THRB: return g_strdup("THRB");
		case MODE_TOR: return g_strdup("TOR");
	}
	return NULL;
}

/* return mode as enum from a given string */
gint mode2enum (gchar * str)
{
	if
	(
		!g_ascii_strcasecmp (str, "CW") ||
		!g_ascii_strncasecmp (str, "A1", 2) ||
		!g_ascii_strncasecmp (str, "A2", 2)
	)
	return MODE_CW;
	if
	(
		!g_ascii_strcasecmp (str, "SSB") ||
		!g_ascii_strcasecmp (str, "USB") ||
		!g_ascii_strcasecmp (str, "LSB") ||
		!g_ascii_strcasecmp (str, "J3E") ||
		!g_ascii_strcasecmp (str, "A3J") ||
		!g_ascii_strcasecmp (str, "R3E") ||
		!g_ascii_strcasecmp (str, "H3E") ||
		!g_ascii_strcasecmp (str, "A3R") ||
		!g_ascii_strcasecmp (str, "A3H")
	)
	return MODE_SSB;
	if
	(
		!g_ascii_strcasecmp (str, "RTTY") ||
		!g_ascii_strncasecmp (str, "F1", 2) ||
		!g_ascii_strncasecmp (str, "F2", 2)
	)
	return MODE_RTTY;
	if
	(
		!g_ascii_strcasecmp (str, "PSK31") ||
		!g_ascii_strcasecmp (str, "PSK") ||
		!g_ascii_strcasecmp (str, "BPSK") ||
		!g_ascii_strcasecmp (str, "BPSK31") ||
		!g_ascii_strcasecmp (str, "QPSK")
	)
	return MODE_PSK31;
	if
	(
		!g_ascii_strcasecmp (str, "SSTV")
	)
	return MODE_SSTV;
	if
	(
		!g_ascii_strcasecmp (str, "MFSK8")
	)
	return MODE_MFSK8;
	if
	(
		!g_ascii_strcasecmp (str, "MFSK16")
	)
	return MODE_MFSK16;
	if
	(
		!g_ascii_strncasecmp (str, "PSK63", 5) ||
		!g_ascii_strcasecmp (str, "BPSK63")
	)
	return MODE_PSK63;
	if
	(
		!g_ascii_strncasecmp (str, "PSK125", 6)
	)
	return MODE_PSK125;
	if
	(
		!g_ascii_strcasecmp (str, "FM") ||
		!g_ascii_strncasecmp (str, "F3", 2) ||
		!g_ascii_strcasecmp (str, "20K0F3E")
	)
	return MODE_FM;
	if
	(
		!g_ascii_strcasecmp (str, "AM") ||
		!g_ascii_strcasecmp (str, "A3E") ||
		!g_ascii_strcasecmp (str, "A3")
	)
	return MODE_AM;
	if
	(
		!g_ascii_strcasecmp (str, "ASCI") ||
		!g_ascii_strcasecmp (str, "ASCII")
	)
	return MODE_ASCI;
	if
	(
		!g_ascii_strcasecmp (str, "ATV") ||
		!g_ascii_strcasecmp (str, "A5") ||
		!g_ascii_strcasecmp (str, "C3F")
	)
	return MODE_ATV;
	if
	(
		!g_ascii_strncasecmp (str, "CLO", 3)
	)
	return MODE_CLO;
	if
	(
		!g_ascii_strcasecmp (str, "FAX")
	)
	return MODE_FAX;
	if
	(
		!g_ascii_strcasecmp (str, "GTOR")
	)
	return MODE_GTOR;
	if
	(
		!g_ascii_strcasecmp (str, "HELL") ||
		!g_ascii_strcasecmp (str, "FELDHELL") ||
		!g_ascii_strcasecmp (str, "FM-HELL") ||
		!g_ascii_strcasecmp (str, "HELLSCHREIBER") ||
		!g_ascii_strcasecmp (str, "PSK-HELL")
	)
	return MODE_HELL;
	if
	(
		!g_ascii_strcasecmp (str, "HFSK")
	)
	return MODE_HFSK;
	if
	(
		!g_ascii_strcasecmp (str, "JT44") ||
		!g_ascii_strcasecmp (str, "FSK441")
	)
	return MODE_JT44;
	if
	(
		!g_ascii_strcasecmp (str, "JT6M")
	)
	return MODE_JT6M;
	if
	(
		!g_ascii_strcasecmp (str, "MTTY")
	)
	return MODE_MTTY;
	if
	(
		!g_ascii_strcasecmp (str, "MT63")
	)
	return MODE_MT63;
	if
	(
		!g_ascii_strcasecmp (str, "OLIVIA")
	)
	return MODE_OLIVIA;
	if
	(
		!g_ascii_strcasecmp (str, "PAC") ||
		!g_ascii_strcasecmp (str, "PACTOR")
	)
	return MODE_PAC;
	if
	(
		!g_ascii_strcasecmp (str, "PAC2") ||
		!g_ascii_strcasecmp (str, "PACTOR II") ||
		!g_ascii_strcasecmp (str, "PACTORII") ||
		!g_ascii_strcasecmp (str, "PACTOR 2") ||
		!g_ascii_strcasecmp (str, "PACTOR2")
	)
	return MODE_PAC2;
	if
	(
		!g_ascii_strcasecmp (str, "PAC3") ||
		!g_ascii_strcasecmp (str, "PACTOR III") ||
		!g_ascii_strcasecmp (str, "PACTORIII") ||
		!g_ascii_strcasecmp (str, "PACTOR 3") ||
		!g_ascii_strcasecmp (str, "PACTOR3")
	)
	return MODE_PAC3;
	if
	(
		!g_ascii_strcasecmp (str, "PCW")
	)
	return MODE_PCW;
	if
	(
		!g_ascii_strcasecmp (str, "PKT") ||
		!g_ascii_strcasecmp (str, "PACKET")
	)
	return MODE_PKT;
	if
	(
		!g_ascii_strncasecmp (str, "Q15", 3)
	)
	return MODE_Q15;
	if
	(
		!g_ascii_strcasecmp (str, "THRB") ||
		!g_ascii_strcasecmp (str, "THROB")
	)
	return MODE_THRB;
	if
	(
		!g_ascii_strcasecmp (str, "TOR") ||
		!g_ascii_strcasecmp (str, "AMTOR")
	)
	return MODE_TOR;

	return -1;
}
