/*

   xlog - GTK+ logging program for amateur radio operators
   Copyright (C) 2001 - 2007 Joop Stakenborg <pg4i@amsat.org>

   This file is part of xlog.

   Xlog is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   Xlog is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with xlog.  If not, see <http://www.gnu.org/licenses/>.

*/

/* gui_scorewindow.c - creation of the scorelist
 *
 */

#include <gtk/gtk.h>
#include "support.h"
#include "preferences.h"
#include "gui_scorewindow.h"
#include "xlog_enum.h"
#include "dxcc.h"

extern GtkWidget *mainwindow;
extern GtkUIManager *ui_manager;
extern preferencestype preferences;

GtkWidget *scorewindow;

static gboolean
on_scorewindow_delete_event (GtkWidget * widget, GdkEvent * event,	gpointer user_data)
{
	GtkWidget *score;

	score = gtk_ui_manager_get_widget (ui_manager, "/MainMenu/OptionMenu/Scoring");
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM(score), FALSE);
	gtk_window_get_size (GTK_WINDOW(widget), &preferences.scorewidth, &preferences.scoreheight);
	gtk_window_get_position (GTK_WINDOW(widget), &preferences.scorex, &preferences.scorey);
	gtk_widget_hide (widget);
	return TRUE;		/* do not destroy */
}

static void
notebook_append_dxccpage (GtkWidget *scorewindow, GtkWidget *awardsnotebook)
{
	GtkWidget *tablabel, *dxcctreeview, *scrolledwindow;
	GtkListStore *dxccmodel;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	GtkTreeIter dxcciter;

	scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	/* one extra field for 'all' (bands) in last column */
	dxccmodel = gtk_list_store_new (MAX_BANDS + 1,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING);
	dxcctreeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL(dxccmodel));
	g_object_unref (G_OBJECT (dxccmodel));
	gtk_container_add (GTK_CONTAINER (scrolledwindow), dxcctreeview);

	renderer = gtk_cell_renderer_text_new ();

	column = gtk_tree_view_column_new_with_attributes
		("0.136", renderer, "text", BAND_2190, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_2190] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("1.8", renderer, "text", BAND_160, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_160] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("3.5", renderer, "text", BAND_80, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_80] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("5.2", renderer, "text", BAND_60, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_60] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("7", renderer, "text", BAND_40, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_40] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("10", renderer, "text", BAND_30, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_30] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("14", renderer, "text", BAND_20, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_20] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("18", renderer, "text", BAND_17, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_17] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("21", renderer, "text", BAND_15, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_15] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("24", renderer, "text", BAND_12, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_12] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("28", renderer, "text", BAND_10, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_10] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("50", renderer, "text", BAND_6, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_6] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("70", renderer, "text", BAND_4, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_4] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("144", renderer, "text", BAND_2, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_2] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("222", renderer, "text", BAND_125CM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_125CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("420", renderer, "text", BAND_70CM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_70CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("902", renderer, "text", BAND_33CM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_33CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("1240", renderer, "text", BAND_23CM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_23CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("2300", renderer, "text", BAND_13CM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_13CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("3300", renderer, "text", BAND_9CM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_9CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("5650", renderer, "text", BAND_6CM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_6CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("10000", renderer, "text", BAND_3CM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_3CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("24000", renderer, "text", BAND_12HMM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_12HMM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("47000", renderer, "text", BAND_6MM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_6MM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("75500", renderer, "text", BAND_4MM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_4MM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("120000", renderer, "text", BAND_2HMM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_2HMM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("142000", renderer, "text", BAND_2MM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_2MM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("241000", renderer, "text", BAND_1MM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_1MM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("300000", renderer, "text", BAND_SUBMM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_SUBMM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("All", renderer, "text", MAX_BANDS, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (dxcctreeview), column);

	gtk_list_store_append (GTK_LIST_STORE (dxccmodel), &dxcciter);
	gtk_tree_selection_set_mode
		(gtk_tree_view_get_selection (GTK_TREE_VIEW (dxcctreeview)),
		GTK_SELECTION_NONE );
	tablabel = gtk_label_new ("DXCC");
	gtk_notebook_append_page
		(GTK_NOTEBOOK(awardsnotebook), scrolledwindow, tablabel);

	GLADE_HOOKUP_OBJECT (scorewindow, dxcctreeview, "dxcctreeview");
}

void
notebook_append_wacpage (GtkWidget *scorewindow, GtkWidget *awardsnotebook)
{
	GtkWidget *tablabel, *wactreeview, *scrolledwindow2;
	GtkListStore *wacmodel;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	GtkTreeIter waciter;

	scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	wacmodel = gtk_list_store_new (MAX_BANDS + 1,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING);
	wactreeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL(wacmodel));
	g_object_unref (G_OBJECT (wacmodel));
	gtk_container_add (GTK_CONTAINER (scrolledwindow2), wactreeview);

	renderer = gtk_cell_renderer_text_new ();

	column = gtk_tree_view_column_new_with_attributes
		("0.136", renderer, "text", BAND_2190, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_2190] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("1.8", renderer, "text", BAND_160, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_160] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("3.5", renderer, "text", BAND_80, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_80] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("5.2", renderer, "text", BAND_60, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_60] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("7", renderer, "text", BAND_40, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_40] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("10", renderer, "text", BAND_30, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_30] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("14", renderer, "text", BAND_20, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_20] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("18", renderer, "text", BAND_17, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_17] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("21", renderer, "text", BAND_15, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_15] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("24", renderer, "text", BAND_12, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_12] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("28", renderer, "text", BAND_10, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_10] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("50", renderer, "text", BAND_6, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_6] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("70", renderer, "text", BAND_4, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_4] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("144", renderer, "text", BAND_2, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_2] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("222", renderer, "text", BAND_125CM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_125CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("420", renderer, "text", BAND_70CM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_70CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("902", renderer, "text", BAND_33CM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_33CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("1240", renderer, "text", BAND_23CM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_23CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("2300", renderer, "text", BAND_13CM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_13CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("3300", renderer, "text", BAND_9CM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_9CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("5650", renderer, "text", BAND_6CM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_6CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("10000", renderer, "text", BAND_3CM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_3CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("24000", renderer, "text", BAND_12HMM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_12HMM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("47000", renderer, "text", BAND_6MM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_6MM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("75500", renderer, "text", BAND_4MM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_4MM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("120000", renderer, "text", BAND_2HMM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_2HMM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("142000", renderer, "text", BAND_2MM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_2MM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("241000", renderer, "text", BAND_1MM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_1MM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("300000", renderer, "text", BAND_SUBMM, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_SUBMM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("All", renderer, "text", MAX_BANDS, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (wactreeview), column);

	gtk_list_store_append (GTK_LIST_STORE (wacmodel), &waciter);
	gtk_tree_selection_set_mode
		(gtk_tree_view_get_selection (GTK_TREE_VIEW (wactreeview)),
		GTK_SELECTION_NONE );
	tablabel = gtk_label_new ("WAC");
	gtk_notebook_append_page
		(GTK_NOTEBOOK(awardsnotebook), scrolledwindow2, tablabel);

	gtk_widget_show_all (scrolledwindow2);
	GLADE_HOOKUP_OBJECT (scorewindow, wactreeview, "wactreeview");
	GLADE_HOOKUP_OBJECT (scorewindow, scrolledwindow2, "scrolledwindow2");
}

GtkWidget *
create_scorewindow (void)
{
	GdkPixbuf *scorewindow_icon_pixbuf;
	GtkWidget *hbox, *vboxleft, *locatorframe, *locatorvbox,
		*locatorframelabel, *locatorlabel, *dxccframe, *dxccvbox, *dxcchbox,
		*dxcclabel1, *dxcclabel3, *dxcclabel4, *dxcclabel5,
		*dxccframelabel, *contlabel, *itulabel, *cqlabel,
		*vboxright, *rightframe, *framevbox, *scrolledwindow, *countrytreeview,
		*rightsep, *awardsnotebook;
	GtkListStore *model;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	GtkTreeIter iter;
	gchar *temp;

	scorewindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_accept_focus (GTK_WINDOW(scorewindow), FALSE);
	gtk_window_set_title (GTK_WINDOW (scorewindow), _("xlog - scoring"));
	scorewindow_icon_pixbuf = create_pixbuf ("xlog-scoring.png");
	if (scorewindow_icon_pixbuf)
	{
		gtk_window_set_icon (GTK_WINDOW (scorewindow), scorewindow_icon_pixbuf);
		g_object_unref (scorewindow_icon_pixbuf);
	}
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (scorewindow), hbox);
	vboxleft = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), vboxleft, FALSE, FALSE, 0);

	/* locator information frame */
	locatorframe = gtk_frame_new (NULL);
	gtk_box_pack_start (GTK_BOX (vboxleft), locatorframe, TRUE, TRUE, 0);
	locatorvbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (locatorframe), locatorvbox);
	locatorlabel = gtk_label_new ("");
	gtk_box_pack_start (GTK_BOX (locatorvbox), locatorlabel, FALSE, FALSE, 0);
	temp = g_strdup_printf ("<b>%s</b>", _("Locator"));
	locatorframelabel = gtk_label_new (NULL);
	gtk_label_set_markup (GTK_LABEL (locatorframelabel), temp);
	gtk_frame_set_label_widget (GTK_FRAME (locatorframe), locatorframelabel);

	/* dxcc information frame */
	dxccframe = gtk_frame_new (NULL);
	gtk_box_pack_start (GTK_BOX (vboxleft), dxccframe, TRUE, TRUE, 0);
	dxccvbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (dxccframe), dxccvbox);
	dxcclabel1 = gtk_label_new ("");
	gtk_box_pack_start (GTK_BOX (dxccvbox), dxcclabel1, FALSE, FALSE, 0);

	dxcchbox = gtk_hbox_new (TRUE, 0);
	gtk_box_pack_start (GTK_BOX (dxccvbox), dxcchbox, FALSE, FALSE, 0);
	contlabel = gtk_label_new ("");
	gtk_box_pack_start (GTK_BOX (dxcchbox), contlabel, FALSE, FALSE, 0);
	itulabel = gtk_label_new ("");
	gtk_box_pack_start (GTK_BOX (dxcchbox), itulabel, FALSE, FALSE, 0);
	cqlabel = gtk_label_new ("");
	gtk_box_pack_start (GTK_BOX (dxcchbox), cqlabel, FALSE, FALSE, 0);

	dxcclabel3 = gtk_label_new ("");
	gtk_box_pack_start (GTK_BOX (dxccvbox), dxcclabel3, FALSE, FALSE, 0);
	dxcclabel4 = gtk_label_new ("");
	gtk_box_pack_start (GTK_BOX (dxccvbox), dxcclabel4, FALSE, FALSE, 0);
	dxcclabel5 = gtk_label_new ("");
	gtk_box_pack_start (GTK_BOX (dxccvbox), dxcclabel5, FALSE, FALSE, 0);
	dxccframelabel = gtk_label_new (NULL);
	gtk_label_set_markup (GTK_LABEL (dxccframelabel), "<b>DXCC</b>");
	gtk_frame_set_label_widget (GTK_FRAME (dxccframe), dxccframelabel);
	gtk_label_set_line_wrap (GTK_LABEL (dxcclabel1), TRUE);
	gtk_widget_set_size_request (dxcclabel1, 200, 60);
	gtk_label_set_justify (GTK_LABEL (dxcclabel1), GTK_JUSTIFY_CENTER);

	/* top */
	vboxright = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), vboxright, TRUE, TRUE, 0);
	rightframe = gtk_frame_new ("");
	gtk_box_pack_start (GTK_BOX (vboxright), rightframe, TRUE, TRUE, 0);
	framevbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (rightframe), framevbox);
	scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_add (GTK_CONTAINER (framevbox), scrolledwindow);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	/* one extra field for official prefix in first column */
	model = gtk_list_store_new (MAX_BANDS + 1,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING);
	countrytreeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL(model));
	g_object_unref (G_OBJECT (model));
	gtk_container_add (GTK_CONTAINER (scrolledwindow), countrytreeview);
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes
		("", renderer, "text", 0, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (column, 80);

	column = gtk_tree_view_column_new_with_attributes
		("0.136", renderer, "text", BAND_2190 + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_2190] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("1.8", renderer, "text", BAND_160 + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_160] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("3.5", renderer, "text", BAND_80 + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_80] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("5.2", renderer, "text", BAND_60 + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_60] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("7", renderer, "text", BAND_40 + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_40] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("10", renderer, "text", BAND_30 + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_30] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("14", renderer, "text", BAND_20 + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_20] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("18", renderer, "text", BAND_17 + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_17] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("21", renderer, "text", BAND_15 + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_15] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("24", renderer, "text", BAND_12 + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_12] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("28", renderer, "text", BAND_10 + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_10] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("50", renderer, "text", BAND_6 + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_6] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("70", renderer, "text", BAND_4 + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_4] - 48);

	gtk_tree_view_column_set_visible (column, FALSE);
	column = gtk_tree_view_column_new_with_attributes
		("144", renderer, "text", BAND_2 + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_2] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("222", renderer, "text", BAND_125CM + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_125CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("420", renderer, "text", BAND_70CM + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_70CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("902", renderer, "text", BAND_33CM + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_33CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("1240", renderer, "text", BAND_23CM + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_23CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("2300", renderer, "text", BAND_13CM + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_13CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("3300", renderer, "text", BAND_9CM + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_9CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("5650", renderer, "text", BAND_6CM + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_6CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("10000", renderer, "text", BAND_3CM + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_3CM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("24000", renderer, "text", BAND_12HMM + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_12HMM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("47000", renderer, "text", BAND_6MM + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_6MM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("75500", renderer, "text", BAND_4MM + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_4MM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("120000", renderer, "text", BAND_2HMM + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_2HMM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("142000", renderer, "text", BAND_2MM + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_2MM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("241000", renderer, "text", BAND_1MM + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_1MM] - 48);

	column = gtk_tree_view_column_new_with_attributes
		("300000", renderer, "text", BAND_SUBMM + 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (countrytreeview), column);
	gtk_tree_view_column_set_visible
		(column, preferences.scoringbands[BAND_SUBMM] - 48);

	gtk_list_store_append (GTK_LIST_STORE (model), &iter);
	gtk_list_store_append (GTK_LIST_STORE (model), &iter);

	gtk_tree_selection_set_mode
		(gtk_tree_view_get_selection (GTK_TREE_VIEW (countrytreeview)),
		GTK_SELECTION_NONE );
	rightsep = gtk_hseparator_new ();
	gtk_box_pack_start (GTK_BOX (framevbox), rightsep, FALSE, FALSE, 0);

	/* bottom */
	awardsnotebook = gtk_notebook_new ();
	gtk_box_pack_start (GTK_BOX (framevbox), awardsnotebook, TRUE, TRUE, 0);

	notebook_append_dxccpage (scorewindow, awardsnotebook);

	if (preferences.awardswac == 1)
		notebook_append_wacpage (scorewindow, awardsnotebook);

	GLADE_HOOKUP_OBJECT (scorewindow, dxccframe, "dxccframe");
	GLADE_HOOKUP_OBJECT (scorewindow, dxcclabel1, "dxcclabel1");
	GLADE_HOOKUP_OBJECT (scorewindow, contlabel, "contlabel");
	GLADE_HOOKUP_OBJECT (scorewindow, itulabel, "itulabel");
	GLADE_HOOKUP_OBJECT (scorewindow, cqlabel, "cqlabel");
	GLADE_HOOKUP_OBJECT (scorewindow, dxcclabel3, "dxcclabel3");
	GLADE_HOOKUP_OBJECT (scorewindow, dxcclabel4, "dxcclabel4");
	GLADE_HOOKUP_OBJECT (scorewindow, dxcclabel5, "dxcclabel5");
	GLADE_HOOKUP_OBJECT (scorewindow, locatorframe, "locatorframe");
	GLADE_HOOKUP_OBJECT (scorewindow, locatorlabel, "locatorlabel");
	GLADE_HOOKUP_OBJECT (scorewindow, awardsnotebook, "awardsnotebook");
	GLADE_HOOKUP_OBJECT (scorewindow, countrytreeview, "countrytreeview");

	g_signal_connect ((gpointer) scorewindow, "delete_event",
		G_CALLBACK (on_scorewindow_delete_event), NULL);

	gtk_widget_show_all (hbox);
	return scorewindow;
}

void
on_scoring_activate (GtkAction *action, gpointer user_data)
{
	gboolean status;

	status = gtk_toggle_action_get_active (GTK_TOGGLE_ACTION (action));
	if (status)
	{
		fill_scoring_arrays ();
		update_dxccscoring ();
		if (preferences.awardswac == 1)
			update_wacscoring ();
		gtk_widget_show (scorewindow);
		gdk_window_move_resize (scorewindow->window,
			preferences.scorex, preferences.scorey, preferences.scorewidth, preferences.scoreheight);
	}
	else
	{
		gtk_window_get_size (GTK_WINDOW(scorewindow), &preferences.scorewidth, &preferences.scoreheight);
		gtk_window_get_position (GTK_WINDOW(scorewindow), &preferences.scorex, &preferences.scorey);
		gtk_widget_hide (scorewindow);
	}

}
