#include "fifo.h"

#include <stdio.h>
#include <stdlib.h>

fifo_item * fifo_push(fifo_item* head, void * data)
{
	// the new item is the new head.
	fifo_item * pitem = (fifo_item*)malloc(sizeof(fifo_item));
	if ( !pitem )
	{
		fprintf(stderr, "fifo_push() failed (malloc() == NULL)!\n");
		return head;
	}
	if ( !head )
	{
		pitem->next = pitem;
		pitem->prev = pitem;
	}
	else
	{
		pitem->prev = head->prev;
		((fifo_item*)head->prev)->next = pitem;
		head->prev = pitem;
		pitem->next = head;
	}
	pitem->data = data;
	return pitem;
}

fifo_item * fifo_pop(fifo_item* head, void ** data)
{
	if ( !head )
	{
		#ifdef DEBUG
			fprintf(stderr, "fifo_pop(): fifo empty.\n");
		#endif
		*data = NULL;
		return NULL;
	}
	// return head->prev->data and remove/free head->prev
	if ( head->prev == head )
	{
		*data = head->data;
		free(head);
		return NULL;
	}
	else
	{
		fifo_item * pitem = (fifo_item*)head->prev;
		head->prev = pitem->prev;
		((fifo_item*)pitem->prev)->next = head;
		*data = pitem->data;
		free(pitem);
		return head;
	}
}

void * fifo_inspect(fifo_item* head)
{
	if ( !head )
	{
		#ifdef DEBUG
			fprintf(stderr, "fifo_inspect(): fifo empty.\n");
		#endif
		return NULL;
	}
	return ((fifo_item*)head->prev)->data;
}
