// *************************************************************************
// * Xgsm - mobile phone manager
// *
// * File:    xgsm_send_sms.h
// *
// * Purpose: Send SMS dialog
// *
// * Author:  Peter Hofmann (software@pxh.de)
// *
// * Created: 5.9.2000
// *************************************************************************

#ifndef XGSM_SEND_SMS_H
#define XGSM_SEND_SMS_H

#include "xgsm_dialogs.h"

#include <gtk--/widget.h>
#include <gtk--/button.h>
#include <gtk--/entry.h>
#include <gtk--/text.h>
#include <gnome--/entry.h>

namespace Xgsm
{
  // Send SMS class
  class SendSMS : public Gtk::Widget, public DeviceHelper,
                  public ToplevelHelper
  {
    int _maxTextLength;         // maximum SMS text length
    int _colorRefreshPosition;  // position after which to refresh colors

    // status while sending SMS
    unsigned int _nextMessageIndex;// index into _textEntry:
    unsigned int _messageCount; // counter for sent messages
    unsigned int _countSMS;     // # of SMS to send (set by updateCounters())

    // widget
    Gnome::Entry *_numberEntry;
    Gtk::Text *_textEntry;
    Gtk::Button *_sendButton;
    Gtk::Label *_charsLeftLabel, *_numberOfMessages;

    // send next SMS message
    void sendNextMessage();

    // update count labels
    void updateCounters();

    // inherited by DeviceHelper
    void onClose() {closeDevice();}
    void sensitive(bool deviceIdle);
    
    // device callbacks
    void onSendDone(ResponseRef response);
    
  public:
    SendSMS();

    // GUI callbacks
    void onPhonebookButton();
    void onSendButton();
    void onCancelButton();
    void onHelpButton();
    void onDestroy();
    int onDelete(GdkEventAny *ev);


    void onTextChanged();
    void onInsertNumber(const gchar *text, gint textLen, gint *position);
    gint onConfigureEvent(GdkEventConfigure* event);
    void onInsertText(const gchar *text, gint textLen, gint *position);
    void onDeleteText(const gint startPos, const gint endPos);
    gint onButtonPress(GdkEventButton*);
    gint onKeyPress(GdkEventKey*);
  };
};

#endif // XGSM_SEND_SMS_H
