// *************************************************************************
// * Xgsm - mobile phone manager
// *
// * File:    xgsm_main.h
// *
// * Purpose: Main windows GUI class
// *
// * Author:  Peter Hofmann (software@pxh.de)
// *
// * Created: 8.3.2000
// *************************************************************************

#ifndef XGSM_MAIN_H
#define XGSM_MAIN_H

#include "xgsm_device.h"
#include "xgsm_multi_editor.h"

#include <gtk--/widget.h>
#include <gtk--/menu.h>
#include <gtk--/text.h>
#include <gtk--/fileselection.h>
#include <gtk--/progressbar.h>
#include <gnome--/client.h>
#include <gnome--/appbar.h>
#include <pthread.h>
#include <deque>

namespace Xgsm
{
  class Main : public Gtk::Widget
  {
    Gnome::Client *_client;
    Gtk::Menu *_stopMenu;
    Gtk::ProgressBar *_closeDialogProgressBar;
    gfloat _closeDialogProgressIncrement;

    bool _waitingForClose;      // waiting for devices to close

    // status and progress state
    Gnome::AppBar *_appbar;
    int _nextProgressId;
    pthread_mutex_t _appbarMtx;
    string _lastIdleStatusMessage;
    gfloat _lastIdleProgress;
    struct AppbarState
    {
      string _statusMessage;
      gfloat _progress;
      int _progressId;
    };
    deque<AppbarState> _stateQueue;

    // message queue
    struct Message
    {
      bool _warning;
      string _message;
    };
    vector<Message> _messages;
    pthread_mutex_t _messagesMtx;
    Gtk::Text *_messageWindow;

    // main windows callbacks
    void onPhonebook();
    void onDefaultPhonebook();
    void onSMSStore();
    void onDefaultSMSStore();
    void onSendNewSMS();
    void onCallForwarding();
    void onStatus();
    void onPreferences();
    void onAbout();
    void onDestroy();
    void onStop();
    void onCloseDialogAbort();
    gint onConfigureEvent(GdkEventConfigure* event);

    gint idle();

    // session callbacks
    void sessionDie();

    gint saveSession(gint phase, 
                     GnomeSaveStyle saveStyle,
                     gint isShutdown, GnomeInteractStyle interactStyle,
                     gint isFast);

  public:
    Main();

    // show main window
    void showAll(bool configError);

    // init progress bar, return unique ID
    int initProgress(string statusMessage);
    
    // update progress bar
    void updateProgress(int progressId, gfloat percentage);
    
    // finish with progress bar
    void finishProgress(int progressId);

    // device callbacks
    void onEditDone(ResponseRef response);

    // for the stop button:
    // register device when busy
    void registerBusyDevice(string deviceName);

    // unregister when idle again
    void unregisterBusyDevice(string deviceName);

    // display message
    void message(string message, bool isWarning = false);

    // open default phonebook window and return the editor object
    MultiEditor *openDefaultPhonebook();

    // open default SMS store window and return the editor object
    MultiEditor *openDefaultSMSStore();
  };

  extern Main *mainWindow;
};

#endif // XGSM_MAIN_H
