// *************************************************************************
// * Xgsm - mobile phone manager
// *
// * File:    xgsm_dialogs.h
// *
// * Purpose: Various dialogs and dialog utilities
// *
// * Author:  Peter Hofmann (software@pxh.de)
// *
// * Created: 12.7.2000
// *************************************************************************

#ifndef XGSM_DIALOGS_H
#define XGSM_DIALOGS_H

#include "xgsm_device.h"

#include <string>
#include <sigc++/signal_system.h>
#include <gsmlib/gsm_util.h>
#include <gdk--/color.h>
#include <gtk--/colorselection.h>

namespace Xgsm
{
  // run file selection dialog and return the selected file
  // if returnDeviceName == true insist on a device
  extern string runFileSelectionDialog(string title);

  // run device selection dialog and return the selected file
  // and baudrate
  extern string runDeviceSelectionDialog(string title,
                                         string &baudRate,
                                         string &initString,
                                         bool &swHandshake);

  // run color selection dialog and return the selected color as a string
  extern string runColorSelectionDialog(string title, string oldColor);

  // helper class for dialogs that deal with Xgsm::Device objects
  // all such dialogs must inherit from it so that common housekeeping
  // functions are performed (such as waiting for device activity to finish
  // before terminating the program)

  class DeviceHelper : public SigC::Object, public gsmlib::RefBase
  {
    SigC::Connection _idle;     // connection to the idle() function
    RequestRef _openRequest;    // pending open request
    
    // idle function, used to wait for device to finish
    gint idle();

    // execute generic actions for device closing and call close()
    void doClose();

  protected:
    bool _waitingForOpen;       // true if waiting for ! _dev->busy()
    string _sourceName;         // currently edited file or device name
    SigC::Connection _eventConnection; // event callback connection
    SigC::Connection _completionConnection; // called after request is handled
    bool _destroyed;            // true if the associated widget is destroyed
    string _messageText; // text for error messages (ie. "Left Phonebook")
    DeviceRef _dev;             // my device

    DeviceHelper(string messageText);

    // handle openRequest, wait for busy device if necessary
    void open(RequestRef openRequest, bool printBusyMessage);

    // open the default device
    void openDefaultDevice();

    // device callbacks:

    // standard device event handler
    virtual void onDeviceEvent(EventType event);
    
    // standard open response handler
    virtual void onOpenDone(ResponseRef response);

    // standard close event handler
    virtual void onClose() {closeDevice();}

    // methods to be overridden:

    // set or reset sensitivity of buttons and entry fields
    // depending on parameter
    virtual void sensitive(bool deviceIdle) {}

    // close device
    void closeDevice();

    virtual ~DeviceHelper();
  };

  // helper class for all toplevel dialogs, handles registration
  // (needed to close all dialogs when program is terminated)

  class ToplevelHelper
  {
    static vector<Gtk::Widget*> _openDialogs;
    
    Gtk::Widget *_dialog;       // top-level dialog

  public:
    // register top-level dialog
    ToplevelHelper(Gtk::Widget *dialog);

    // unregister top-level dialog
    virtual ~ToplevelHelper();

    // close all dialogs, should only be called upon program termination
    static void closeAllDialogs();
  };
};

#endif // XGSM_DIALOGS_H
