#!/usr/bin/perl
#
# lib_ttfdir.pl - ttf directory handling (used in ttf* tools)
#
#	2002/2, by 1@2ch
#	* public domain *
#

# ttf_readdir_from_ttf(): read a ttf directory from a file opened
# ttf_cat_type($type): dump a specified table in ttf file
# ttf_calc_sum($file): calc the sum of a table

# GLOBAL VARIABLES:
#  $ttf_font_type
#  $ttf_num_tables
#  $ttf_fontdir_types[]
#  $ttf_fontdir_sum{$type}
#  $ttf_fontdir_offset{$type}
#  $ttf_fontdir_length{$type}


require 'lib_util.pl';

# ttf_readdir_from_ttf()
sub ttf_readdir_from_ttf() {
    # read header
    $ttf_font_type = rstr32();
    $ttf_num_tables = ruint16();
    @ttf_fontdir_types = ();
    %ttf_fontdir_sum = ();
    %ttf_fontdir_offset = ();
    %ttf_fontdir_length = ();
    ruint16();	# searchRange
    ruint16();	# entrySelector
    ruint16();	# rangeShift

    # read directory
    for(my $i = 0; $i < $ttf_num_tables; $i++) {
	my $t = rstr32();
	push(@ttf_fontdir_types, $t);
	$ttf_fontdir_sum{$t}    = ruint32();
	$ttf_fontdir_offset{$t} = ruint32();
	$ttf_fontdir_length{$t} = ruint32();
    }
}

# ttf_cat_type($type)
sub ttf_cat_type($) {
    my $t = $_[0];
    if (! $ttf_fontdir_offset{$t}) { 
	err("not found: $t"); 
	return;
    }
    rgoto($ttf_fontdir_offset{$t});
    my $len = $ttf_fontdir_length{$t};
    while(0 < $len) {
	my $x = rstrn(($BUFSIZ < $len) ? $BUFSIZ : $len);
	$len -= length($x);
	wstrn($x);
    }
}

# ttf_calc_sum($file)
sub calc_sum($) {
    my $s = 0;
    my $x = $_[0];
    my $len = length($x);
    # padding to make the data length multiple of 4
    $x .= "\000" x (4-($len % 4)) if ($len % 4);
    for(my $i = 0; $i < length($x); $i += 4) {
	$s = addint($s, unpack('N', substr($x, $i, 4)));
    }
    $s;
}
sub ttf_calc_sum($) {
    ropen($_[0]);
    my $s = 0;
    while(my $x = rstrn($BUFSIZ)) {
	$s = addint($s, calc_sum($x));
    }
    rclose();
    $s;
}

1;
