/* $Id: addrbook.h,v 1.5 2004/01/02 03:54:01 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of a library used by the Archimedes email client     * 
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2004 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU Library General Public License as published *
 *   by the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU Library General Public License for more details.                      *
 *                                                                             *
 *   You should have received a copy of the GNU Library General Public License *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 ******************************************************************************/

#ifndef __ADDRBOOK_H__
#define __ADDRBOOK_H__

#include "addrbookentry.h"


class AddressBook : public list<AddressBookEntry *> {
  public:
	AddressBook() : flags(0) { }
	AddressBook(string n) : name(n), flags(0) { }
	AddressBook(const AddressBook &addrbook);
	~AddressBook();

	void SetFlags(int f) { flags = f; }
	void SetName(string n) { name = n; }

	string GetName() const { return name; }
	int GetFlags() const { return flags; }

	void AddEntry(AddressBookEntry *entry);
	bool DeleteEntry(AddressBookEntry *entry);

	AddressBookEntry *FindEntry(const char *addr);
	AddressBookEntry *FindEntry(struct _mail_addr *addr);

	bool Load(const char *configdir);
	bool LoadFromFile(const char *fname);

	bool Save(const char *configdir);
	bool SaveToFile(const char *fname);

	int Size() const { return list<AddressBookEntry *>::size(); }

	iterator Begin() { return list<AddressBookEntry *>::begin(); }
	iterator End() { return list<AddressBookEntry *>::end(); }
	const_iterator Begin() const { return list<AddressBookEntry *>::begin(); }
	const_iterator End() const { return list<AddressBookEntry *>::end(); }


	/* to remain compatible with STL naming conventions */
	iterator begin() { return Begin(); }
	iterator end() { return End(); }
	const_iterator begin() const { return Begin(); }
	const_iterator end() const { return End(); }


	bool operator<(const AddressBook &addrbook);
	bool operator>(const AddressBook &addrbook);
	bool operator==(const AddressBook &addrbook);

	AddressBook &operator=(const AddressBook &addrbook);

  private:
	string name;
	int flags;

	void clearbook();

	bool load(FILE *fp);
	bool save(FILE *fp);
};


/* Compare by pointers */
/*bool operator<(const AddressBook *addrbook1, const AddressBook *addrbook2);
bool operator>(const AddressBook *addrbook1, const AddressBook *addrbook2);
bool operator==(const AddressBook *addrbook1, const AddressBook *addrbook2);
*/

#endif /* __ADDRBOOK_H__ */
