dnl Checks for the --with-dmalloc option on ./configure, if given it sets the 
dnl DMALLOC_CFLAGS and DMALLOC_LIBS accordingly.  It does not AC_SUBST those variables.

AC_DEFUN([DMALLOC], [
AC_MSG_CHECKING(whether to dmalloc library)
AC_ARG_WITH(dmalloc,
[  --with-dmalloc[=ARG]    Compile with dmalloc library],
if test "$withval" = "" -o "$withval" = "yes"; then
    ac_cv_dmalloc="/usr"
else
    ac_cv_dmalloc="$withval"
fi
AC_MSG_RESULT(yes)
DMALLOC_CFLAGS="-DDMALLOC -DDMALLOC_FUNC_CHECK -I$ac_cv_dmalloc/include"
DMALLOC_LIBS="-L$ac_cv_dmalloc/lib -ldmalloc"
,AC_MSG_RESULT(no)
DMALLOC_CFLAGS=""
DMALLOC_LIBS=""
)
AC_SUBST(DMALLOC_CFLAGS)
AC_SUBST(DMALLOC_LIBS)
])
