/* gui.h
 * Copyright (C) 2006 Gauvain Pocentek <gauvainpocentek@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

enum combo_enum
{
	DESC = 0,
	NOM,
	COMBO_NUM
};

enum tree_enum
{
	LAYOUTS = 0,
	VARIANTS,
	TREE_NUM
};

enum enumeration
{
	AVAIL_LAYOUT_TREE_COL_DESCRIPTION = 0,
	AVAIL_LAYOUT_TREE_COL_ID,
	NUM
};

typedef struct _xfkcDialog
{
	GtkWidget * dialog;
	
	GtkWidget * global_vbox;
	GtkWidget * kbd_model_combo;
	GtkListStore * combo_store;
	
	GtkWidget * layout_tree_view;
	GtkListStore * layout_store;

	GtkWidget * add_btn;
	GtkWidget * rm_btn;
    GtkWidget * edit_btn;
	GtkWidget * use_X_check_btn;

	guint layouts_nb;
	guint max_layouts_nb;

} xfkcDialog;

xfkcDialog * xfkc_gui;

GtkTreeIter iter, child;
GtkTreeModel *model;
GtkTreeSelection *selection;
GtkTreePath *path;

char * xci_desc_to_utf8 (XklConfigItem * ci);
gchar * layout_dialog_run ();
static void add_layout (GtkWidget *widget, gpointer data);
static void check_button_toggled (GtkToggleButton *btn, gpointer data);
static void rm_layout (GtkWidget *widget, gpointer data);
static void dialog_response (GtkWidget *widget, gint response, gpointer data);
static void destroy (GtkWidget *widget, gpointer data);
static void show_hide_buttons ();
static void edit_btn_show (GtkTreeView *tree_view, gpointer user_data);
static void edit_layout (GtkWidget *widget, gpointer data);
