/*
 * FIG : Facility for Interactive Generation of figures
 * Copyright (c) 1985-1988 by Supoj Sutanthavibul
 * Parts Copyright (c) 1989-2007 by Brian V. Smith
 * Parts Copyright (c) 1991 by Paul King
 *
 * Any party obtaining a copy of these files is granted, free of charge, a
 * full and unrestricted irrevocable, world-wide, paid up, royalty-free,
 * nonexclusive right and license to deal in this software and documentation
 * files (the "Software"), including without limitation the rights to use,
 * copy, modify, merge, publish distribute, sublicense and/or sell copies of
 * the Software, and to permit persons who receive copies from any such
 * party to do so, with the only requirement being that the above copyright
 * and this permission notice remain intact.
 *
 */

#include "fig.h"
#include "resources.h"
#include "w_icons.h"

/*********** icons for mode panel *****************/


#define addpt_width_small 22
#define addpt_height_small 22
static unsigned char addpt_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x1f,0x00,0x00,0x11,0x00,0x00,0x11,0x00,
0x80,0x20,0x00,0x80,0x20,0x00,0x40,0x44,0x00,0x40,0x4e,0x00,
0x20,0x95,0x00,0x20,0x84,0x00,0x10,0x04,0x01,0x10,0x04,0x01,
0x08,0x04,0x02,0x08,0x00,0x02,0x04,0x00,0x04,0x54,0x55,0x05,
0x00,0x00,0x00,0x00,0x00,0x00};
#define align_width_small 22
#define align_height_small 22
static unsigned char align_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8f,0x03,0x10,0x49,0x04,
0x10,0x29,0x08,0x28,0x29,0x08,0x28,0x29,0x08,0x44,0x49,0x04,
0x7c,0x8f,0x03,0xa8,0xaa,0x0a,0x00,0x00,0x00,0x98,0x00,0x00,
0xa4,0x00,0x00,0xa4,0x02,0x00,0xa4,0x30,0x07,0xbc,0x4a,0x09,
0xa4,0x4a,0x09,0xa4,0x72,0x09,0xa4,0x42,0x09,0x00,0x38,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define arc_width_small 22
#define arc_height_small 22
static unsigned char arc_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x03,0x00,0x90,0x0d,0x00,
0x10,0x10,0x00,0x10,0x20,0x00,0x00,0x20,0x00,0x00,0x40,0x00,
0x00,0x80,0x0c,0x00,0x80,0x08,0x00,0x80,0x0d,0x00,0x80,0x05,
0x00,0x80,0x0c,0x00,0x80,0x00,0x00,0x40,0x00,0x18,0x20,0x00,
0x10,0x20,0x00,0x08,0x10,0x00,0x90,0x0d,0x00,0x98,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define arc_box_width_small 22
#define arc_box_height_small 22
static unsigned char arc_box_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xe0,0xff,0x01,0x10,0x00,0x02,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x10,0x00,0x02,0xe0,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define autoarrow_width_small 22
#define autoarrow_height_small 22
static unsigned char autoarrow_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x0a,0x00,0x00,0x0a,0x00,0x00,0x11,0x00,0x00,0x11,0x00,
0x80,0x20,0x00,0x80,0x20,0x00,0x40,0x40,0x00,0x40,0x40,0x00,
0xc0,0x7f,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define box_width_small 22
#define box_height_small 22
static unsigned char box_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0xff,0x07,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0xf8,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define break_width_small 22
#define break_height_small 22
static unsigned char break_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x55,0x05,0x00,0x00,0x08,
0xe4,0xe0,0x00,0x10,0x11,0x09,0x34,0x08,0x02,0xc0,0x08,0x0a,
0x14,0x11,0x01,0xe0,0xe0,0x08,0x04,0x00,0x00,0x00,0x00,0x09,
0x04,0x7c,0x02,0xf0,0x11,0x0a,0x14,0x11,0x02,0x10,0x11,0x0a,
0xf4,0x11,0x01,0x00,0x90,0x08,0x04,0x00,0x00,0xa8,0xaa,0x0a,
0x00,0x00,0x00,0x00,0x00,0x00};
#define open_comp_width_small 22
#define open_comp_height_small 22
static unsigned char open_comp_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x1f,0x00,0x04,0x10,0x00,
0xf4,0x10,0x00,0x54,0x10,0x00,0x34,0x10,0x00,0x94,0x17,0x00,
0x84,0x14,0x00,0x84,0x17,0x00,0x04,0x10,0x00,0xfc,0x1f,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0x00,0x50,0x00,0x00,0x30,0x00,
0x00,0x90,0x07,0x00,0x80,0x04,0x00,0x80,0x07,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define join_split_width_small 22
#define join_split_height_small 22
static unsigned char join_split_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x08,0x00,0x04,0x14,0x00,
0x88,0x23,0x08,0x88,0x43,0x04,0x90,0x83,0x02,0x50,0x00,0x01,
0x20,0x00,0x00,0x80,0x00,0x00,0xc0,0x01,0x00,0xa0,0x02,0x00,
0x80,0x00,0x00,0x84,0x00,0x00,0xa4,0x12,0x00,0xc8,0x21,0x08,
0x88,0x40,0x04,0x10,0x80,0x02,0x10,0x00,0x01,0x20,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define chop_width_small 22
#define chop_height_small 22
static unsigned char chop_bits_small[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x08, 0x00,
   0x00, 0x1c, 0x00, 0xc0, 0x13, 0x00, 0x30, 0x14, 0x00, 0x10, 0x2a, 0x00,
   0x90, 0x65, 0x00, 0x50, 0x64, 0x00, 0x30, 0x92, 0x00, 0x60, 0x89, 0x00,
   0xc0, 0x05, 0x01, 0x00, 0x03, 0x01, 0x04, 0x00, 0x02, 0x08, 0x00, 0x02,
   0x08, 0x00, 0x04, 0x11, 0x04, 0x04, 0x06, 0x03, 0x08, 0x88, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define c_intspl_width_small 22
#define c_intspl_height_small 22
static unsigned char c_intspl_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x10,0x00,
0xc0,0x1f,0x00,0xa0,0x18,0x00,0x10,0x20,0x00,0x10,0x24,0x00,
0x20,0x1c,0x00,0x40,0x0e,0x00,0x80,0x41,0x00,0x68,0x7e,0x00,
0x18,0xe0,0x00,0x18,0x00,0x01,0x08,0x00,0x02,0x08,0x00,0x02,
0x08,0x00,0x03,0x28,0x10,0x07,0x30,0xf0,0x00,0xf0,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define c_spl_width_small 22
#define c_spl_height_small 22
static unsigned char c_spl_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0x00,
0x20,0x10,0x00,0x10,0x20,0x00,0x10,0x20,0x00,0x20,0x18,0x00,
0x40,0x06,0x00,0x80,0x01,0x00,0x60,0x3e,0x00,0x10,0xc0,0x00,
0x08,0x00,0x01,0x08,0x00,0x02,0x08,0x00,0x02,0x08,0x00,0x02,
0x08,0x00,0x01,0x10,0xe0,0x00,0xe0,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define cirdia_width_small 22
#define cirdia_height_small 22
static unsigned char cirdia_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0xc0,0x60,0x00,0x30,0x80,0x01,0x10,0x00,0x01,0x08,0x00,0x02,
0x08,0x00,0x02,0x04,0x00,0x04,0x04,0x04,0x04,0xac,0xae,0x06,
0x04,0x04,0x04,0x04,0x00,0x04,0x08,0x00,0x02,0x08,0x00,0x02,
0x10,0x00,0x01,0x30,0x80,0x01,0xc0,0x60,0x00,0x00,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define cirrad_width_small 22
#define cirrad_height_small 22
static unsigned char cirrad_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0xc0,0x60,0x00,0x30,0x80,0x01,0x10,0x00,0x01,0x08,0x00,0x02,
0x08,0x00,0x02,0x04,0x00,0x04,0x04,0x04,0x04,0x04,0x56,0x05,
0x04,0x04,0x04,0x04,0x00,0x04,0x08,0x00,0x02,0x08,0x00,0x02,
0x10,0x00,0x01,0x30,0x80,0x01,0xc0,0x60,0x00,0x00,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define convert_width_small 22
#define convert_height_small 22
static unsigned char convert_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x40,0x00,0x40,0x80,0x00,
0x40,0x22,0x01,0x40,0x7f,0x02,0x20,0x22,0x04,0x30,0x00,0x02,
0x08,0x00,0x01,0x08,0x80,0x00,0x08,0x00,0x01,0x70,0x00,0x02,
0x00,0x00,0x00,0xfc,0xe3,0x07,0x04,0x12,0x08,0x44,0x92,0x08,
0xe4,0xff,0x09,0x44,0x92,0x08,0x04,0x12,0x08,0xfc,0xe3,0x07,
0x00,0x00,0x00,0x00,0x00,0x00};
#define copy_width_small 22
#define copy_height_small 22
static unsigned char copy_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x80,0x03,0xe8,0x80,0x0e,
0x8c,0xc0,0x08,0x84,0x48,0x08,0x84,0x5e,0x08,0x84,0x48,0x08,
0x8c,0xc0,0x08,0x98,0x80,0x09,0xf0,0x00,0x0f,0x60,0x00,0x06,
0x00,0x00,0x00,0x38,0x00,0x00,0x44,0x00,0x00,0x04,0x32,0x05,
0x04,0x55,0x05,0x44,0x35,0x07,0x38,0x12,0x04,0x00,0x10,0x03,
0x00,0x00,0x00,0x00,0x00,0x00};
#define delete_width_small 22
#define delete_height_small 22
static unsigned char delete_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x80,0x3f,0x00,
0x80,0x3f,0x00,0xc0,0x64,0x00,0xc0,0x7f,0x00,0x80,0x3f,0x00,
0x00,0x0e,0x00,0x00,0x0a,0x00,0x10,0x00,0x02,0xf8,0xe0,0x07,
0x00,0x1f,0x00,0xf8,0xe0,0x07,0x10,0x00,0x02,0x00,0x00,0x00,
0x46,0x92,0x08,0xaa,0xaa,0x15,0x6a,0x9a,0x0c,0xc6,0xb2,0x18,
0x00,0x00,0x00,0x00,0x00,0x00};
#define deletept_width_small 22
#define deletept_height_small 22
static unsigned char deletept_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x70,0x00,0x00,
0xe0,0x00,0x00,0xd8,0x01,0x07,0x98,0x83,0x0f,0x20,0x87,0x08,
0xac,0xff,0x08,0x58,0xff,0x0f,0x40,0x30,0x07,0x88,0x70,0x00,
0x88,0xd0,0x00,0x08,0x91,0x01,0x08,0x11,0x03,0x08,0x62,0x03,
0x08,0xc2,0x01,0x08,0x04,0x00,0x08,0x04,0x00,0x08,0x08,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define edit_width_small 22
#define edit_height_small 22
static unsigned char edit_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf4,0x0f,0x80,0x10,0x08,
0x38,0x50,0x0b,0x28,0x10,0x08,0x64,0xd0,0x0b,0x4c,0x10,0x08,
0x68,0xd0,0x08,0x38,0x10,0x08,0x80,0xd0,0x08,0x00,0x14,0x08,
0x00,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xa8,0x00,
0x20,0x88,0x01,0x60,0xae,0x00,0x20,0xaa,0x00,0xe0,0x2e,0x01,
0x00,0x00,0x00,0x00,0x00,0x00};
#define elldia_width_small 22
#define elldia_height_small 22
static unsigned char elldia_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1f,0x00,0xe0,0xe0,0x00,0x10,0x00,0x01,
0x08,0x00,0x02,0x08,0x00,0x02,0x04,0x04,0x04,0xac,0xae,0x06,
0x04,0x04,0x04,0x08,0x00,0x02,0x08,0x00,0x02,0x10,0x00,0x01,
0xe0,0xe0,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define ellrad_width_small 22
#define ellrad_height_small 22
static unsigned char ellrad_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1f,0x00,0xe0,0xe0,0x00,0x10,0x00,0x01,
0x08,0x00,0x02,0x08,0x00,0x02,0x04,0x04,0x04,0x04,0xae,0x06,
0x04,0x04,0x04,0x08,0x00,0x02,0x08,0x00,0x02,0x10,0x00,0x01,
0xe0,0xe0,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define flip_x_width_small 22
#define flip_x_height_small 22
static unsigned char flip_x_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xe4,0x00,
0x10,0x11,0x01,0x10,0x15,0x01,0x10,0x11,0x01,0xe0,0xe4,0x00,
0x40,0x40,0x00,0x48,0x44,0x02,0xb8,0xbb,0x03,0xa0,0xa4,0x00,
0x10,0x11,0x01,0x10,0x15,0x01,0xf8,0xfb,0x03,0xa0,0xa4,0x00,
0xa0,0xa0,0x00,0xa0,0xa4,0x00,0xb0,0xb1,0x01,0x00,0x04,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define flip_y_width_small 22
#define flip_y_height_small 22
static unsigned char flip_y_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,
0x00,0x0c,0x00,0x00,0x12,0x00,0x00,0x12,0x00,0x00,0x21,0x00,
0x00,0x21,0x00,0x80,0x7f,0x00,0x00,0x00,0x00,0xf8,0xff,0x07,
0x00,0x00,0x00,0x80,0x7f,0x00,0x00,0x21,0x00,0x00,0x21,0x00,
0x00,0x12,0x00,0x00,0x12,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define glue_width_small 22
#define glue_height_small 22
static unsigned char glue_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x0f,0x0c,0x00,0x0c,
0xe4,0xe0,0x08,0x14,0x11,0x09,0x34,0x08,0x0a,0xc4,0x08,0x0a,
0x14,0x11,0x09,0xe4,0xe0,0x08,0x04,0x00,0x08,0x04,0x00,0x09,
0x04,0x7c,0x0a,0xf4,0x11,0x0a,0x14,0x11,0x0a,0x14,0x11,0x0a,
0xf4,0x11,0x09,0x04,0x90,0x08,0x0c,0x00,0x0c,0xfc,0xff,0x0f,
0x00,0x00,0x00,0x00,0x00,0x00};
#define intspl_width_small 22
#define intspl_height_small 22
static unsigned char intspl_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0xc0,0x1f,0x00,
0xe0,0x30,0x00,0x10,0x30,0x00,0x10,0x00,0x00,0x20,0x00,0x00,
0x40,0x00,0x00,0x80,0x01,0x00,0x00,0x7e,0x00,0x00,0xe0,0x00,
0x00,0x60,0x01,0x00,0x00,0x02,0x00,0x00,0x02,0x00,0x00,0x07,
0x00,0x00,0x07,0x30,0xf0,0x00,0xf0,0x3f,0x00,0x30,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define line_width_small 22
#define line_height_small 22
static unsigned char line_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x04,
0x80,0x00,0x04,0x40,0x01,0x04,0x40,0x01,0x02,0x20,0x01,0x02,
0x20,0x02,0x02,0x20,0x02,0x02,0x10,0x04,0x02,0x10,0x04,0x01,
0x08,0x04,0x01,0x08,0x08,0x01,0x00,0x08,0x01,0x00,0x04,0x01,
0x00,0x84,0x01,0x00,0x7a,0x00,0x00,0x06,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define move_width_small 22
#define move_height_small 22
static unsigned char move_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x80,0x03,0x40,0x80,0x0e,
0x88,0xc0,0x08,0x00,0x48,0x08,0x84,0x5e,0x08,0x00,0x48,0x08,
0x84,0xc0,0x08,0x08,0x80,0x09,0xa0,0x00,0x0f,0x40,0x00,0x06,
0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x00,0x00,0x6c,0x00,0x00,
0x54,0x52,0x03,0x44,0x55,0x05,0x44,0x55,0x03,0x44,0x22,0x06,
0x00,0x00,0x00,0x00,0x00,0x00};
#define movept_width_small 22
#define movept_height_small 22
static unsigned char movept_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x1c,0x10,0x0e,
0x1c,0x3f,0x0e,0x3c,0x10,0x0e,0x00,0x08,0x05,0x88,0x80,0x04,
0x08,0x40,0x04,0x00,0x22,0x04,0x08,0x10,0x04,0x08,0x08,0x04,
0x00,0x08,0x04,0x08,0x04,0x04,0x08,0x22,0x04,0x00,0x01,0x04,
0x88,0x80,0x04,0x48,0x00,0x04,0x20,0x00,0x06,0x18,0x00,0x04,
0x00,0x00,0x00,0x00,0x00,0x00};
#define picobj_width_small 22
#define picobj_height_small 22
static unsigned char picobj_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0xc0,0x45,0x00,
0x20,0x42,0x00,0x20,0x7e,0x00,0x20,0x87,0x00,0xc0,0x8f,0x00,
0x20,0xf2,0x00,0x20,0x13,0x00,0xc0,0x12,0x00,0x00,0x0c,0x00,
0x1c,0x00,0x00,0x14,0x02,0x00,0x1c,0x07,0x00,0x84,0x52,0x0b,
0x54,0x52,0x15,0x54,0x52,0x0d,0x94,0x74,0x19,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define library_width_small 45
#define library_height_small 22
static unsigned char library_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xde,0x03,0x00,
0x00,0x9e,0x1c,0x52,0x02,0x00,0x00,0x92,0xf7,0x52,0x0e,0x00,
0x80,0x93,0x94,0x53,0x0a,0x00,0x80,0x92,0x94,0x52,0x7a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0xe0,0xff,0xff,0xff,0xff,0x01,0x20,0x00,0x00,0x00,0x00,0x01,
0xe0,0xff,0xff,0xff,0xff,0x01,0x80,0x01,0x00,0x00,0x60,0x00,
0x80,0x01,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define polygon_width_small 22
#define polygon_height_small 22
static unsigned char polygon_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0x00,
0x10,0x40,0x00,0x10,0x80,0x00,0x10,0x00,0x01,0x10,0x00,0x01,
0x10,0x00,0x01,0x10,0x80,0x00,0x10,0x40,0x00,0x10,0x3e,0x00,
0x10,0x02,0x00,0x10,0x02,0x00,0x10,0x02,0x00,0x10,0x02,0x00,
0x10,0x02,0x00,0x10,0x02,0x00,0xf0,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define regpoly_width_small 22
#define regpoly_height_small 22
static unsigned char regpoly_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x00,0x20,0x00,0x01,
0x20,0x00,0x01,0x10,0x00,0x02,0x10,0x00,0x02,0x08,0x01,0x04,
0x08,0x01,0x04,0x04,0x0d,0x08,0x04,0x0d,0x08,0x08,0x00,0x04,
0x08,0x00,0x04,0x10,0x00,0x02,0x10,0x00,0x02,0x20,0x00,0x01,
0x20,0x80,0x0d,0xc0,0xff,0x09,0x00,0x00,0x04,0x00,0x00,0x0c,
0x00,0x00,0x00,0x00,0x00,0x00};
#define rotCCW_width_small 22
#define rotCCW_height_small 22
static unsigned char rotCCW_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0xc0,0x00,0x00,
0xa0,0x3f,0x00,0x10,0x40,0x00,0x10,0x80,0x00,0xa0,0x1f,0x01,
0xc0,0x20,0x01,0x80,0x40,0x02,0x00,0x40,0x02,0x00,0x40,0x02,
0x00,0x40,0x02,0x60,0x40,0x02,0x90,0x20,0x01,0x10,0x1f,0x01,
0x20,0x80,0x00,0xc0,0x60,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define rotCW_width_small 22
#define rotCW_height_small 22
static unsigned char rotCW_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0xc0,0x00,
0x00,0x7f,0x01,0x80,0x00,0x02,0x40,0x00,0x02,0x20,0x7e,0x01,
0x20,0xc1,0x00,0x90,0x40,0x00,0x90,0x00,0x00,0x90,0x00,0x00,
0x90,0x00,0x00,0x90,0x80,0x01,0x20,0x41,0x02,0x20,0x3e,0x02,
0x40,0x00,0x01,0x80,0xc1,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define scale_width_small 22
#define scale_height_small 22
static unsigned char scale_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0a,0x01,0x10,0x11,0x01,
0x90,0xbf,0x02,0x28,0x91,0x02,0x28,0x4a,0x04,0x7c,0x40,0x04,
0x00,0xe0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x80,0x00,
0x24,0x80,0x00,0x04,0x80,0x00,0x08,0x9b,0x04,0xb0,0xa0,0x0a,
0xa0,0xb8,0x0e,0xa4,0xa8,0x02,0x18,0xb3,0x0c,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define spl_width_small 22
#define spl_height_small 22
static unsigned char spl_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0x00,
0x20,0x10,0x00,0x10,0x20,0x00,0x10,0x00,0x00,0x20,0x00,0x00,
0x40,0x00,0x00,0x80,0x01,0x00,0x00,0x3e,0x00,0x00,0xc0,0x00,
0x00,0x00,0x01,0x00,0x00,0x02,0x00,0x00,0x02,0x00,0x00,0x02,
0x00,0x00,0x03,0x10,0xe0,0x00,0xe0,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define text_width_small 22
#define text_height_small 22
static unsigned char text_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x07,
0xfc,0xff,0x07,0x0c,0x1f,0x06,0x04,0x0e,0x04,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x3f,0x00,0xe0,0xff,0x01,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define update_width_small 22
#define update_height_small 22
static unsigned char update_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x48,0x00,0x00,
0x48,0x00,0x00,0x48,0x00,0x00,0x48,0x07,0x00,0x48,0xe5,0x00,
0x78,0x07,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x40,0x23,0x00,0x70,0x64,0x02,0x48,0x27,0x05,
0x48,0x25,0x03,0x70,0x4b,0x06,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define tangent_width_small 22
#define tangent_height_small 22
static unsigned char tangent_bits_small[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x0f,0x00,0x03,0x02,
 0x00,0x0c,0x02,0x24,0x10,0x02,0x2c,0x20,0x00,0x34,0x20,0x00,
 0x24,0x40,0x00,0x00,0x40,0x00,0xfe,0xff,0x03,0x00,0x40,0x00,
 0x00,0x40,0x00,0x00,0x20,0x00,0x00,0x20,0x00,0x00,0x10,0x00,
 0x00,0x0c,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,};
#define anglemeas_width_small 22
#define anglemeas_height_small 22
static unsigned char anglemeas_bits_small[] = {
 0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0x36,0x00,0xc0,0x74,0x00,0xc0,
 0x84,0x01,0xc0,0x0e,0x02,0xc0,0x00,0x0c,0xc0,0x00,0x38,0xc0,0x00,0xc4,0xc8,
 0x00,0x84,0xd3,0x00,0x84,0xcb,0x00,0x68,0xd8,0x00,0x18,0xc0,0x06,0x06,0xc0,
 0x84,0x01,0xc0,0x66,0x00,0xc0,0x34,0x00,0xc0,0x36,0x00,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x00,0x00,0xc0};
#define lenmeas_width_small 22
#define lenmeas_height_small 22
static unsigned char lenmeas_bits_small[] = {
 0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0xf0,0x00,0xc0,0x8c,0xc0,0xcc,
 0x84,0xb0,0xc8,0x82,0x10,0xc9,0xc2,0x10,0xc9,0x60,0x08,0xc9,0x18,0x0c,0xcf,
 0x08,0x02,0xc0,0xf0,0x01,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x24,0x49,0xd2,0xfc,0xff,0xdf,0x00,0x00,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x00,0x00,0xc0};
#define areameas_width_small 22
#define areameas_height_small 22
static unsigned char areameas_bits_small[] = {
 0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0x80,0x01,0xc0,0xc0,0x03,0xc0,
 0x60,0x05,0xc0,0x50,0x0d,0xc0,0x58,0x15,0xc0,0x54,0x15,0xc0,0x56,0x35,0xc0,
 0x56,0x35,0xcc,0x56,0xf5,0xd7,0x56,0x55,0xd5,0x56,0x55,0xd5,0xdc,0x57,0xd5,
 0x78,0x5c,0xcd,0x18,0x58,0xc7,0x00,0xf8,0xc1,0x00,0x20,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x00,0x00,0xc0};


/****** NORMAL SIZE ICONS ******/

#define regpoly_width_big 36
#define regpoly_height_big 32
static unsigned char regpoly_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x00,0x00,0x00,0x04,
0x00,0x01,0x00,0x00,0x04,0x00,0x01,0x00,0x00,0x02,0x00,
0x02,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,
0x00,0x80,0x00,0x00,0x08,0x00,0x80,0x00,0x00,0x08,0x00,
0x40,0x10,0x00,0x10,0x00,0x20,0x18,0x00,0x20,0x00,0x20,
0x10,0x07,0x20,0x00,0x10,0x10,0x07,0x40,0x00,0x20,0x10,
0x07,0x20,0x00,0x20,0x10,0x00,0x20,0x00,0x40,0x38,0x00,
0x10,0x00,0x80,0x00,0x00,0x08,0x00,0x80,0x00,0x00,0x08,
0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,
0x00,0x02,0x00,0x62,0x00,0x00,0x04,0x00,0x91,0x00,0x00,
0x04,0xc0,0x81,0x00,0x00,0xf8,0xff,0x41,0x00,0x00,0x00,
0xc0,0x21,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define addpt_width_big 36
#define addpt_height_big 32
static unsigned char addpt_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0x80,0x1f,
0x00,0x00,0x00,0x80,0x19,0x00,0x00,0x00,0x80,0x19,0x00,
0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0xc0,0x3f,0x00,0x00,
0x00,0x60,0x60,0x00,0x00,0x00,0x30,0xc0,0x00,0x00,0x00,
0x18,0x80,0x01,0x00,0x00,0x0c,0x02,0x03,0x00,0x00,0x06,
0x07,0x06,0x00,0x00,0x83,0x0a,0x0c,0x00,0x80,0x01,0x02,
0x18,0x00,0xc0,0x00,0x02,0x30,0x00,0x60,0x00,0x02,0x60,
0x00,0x30,0x00,0x02,0xc0,0x00,0x18,0x00,0x02,0x80,0x01,
0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xa8,0xaa,0xaa,0xaa,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define align_width_big 36
#define align_height_big 32
static unsigned char align_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0xc0,0x60,
0x00,0x00,0x00,0x20,0x80,0x00,0x00,0x00,0x20,0x80,0x00,0x00,
0x00,0x10,0x00,0x01,0x00,0x01,0x10,0x00,0x01,0x00,0xc1,0x13,
0x00,0x01,0x80,0x42,0x12,0x00,0x01,0x80,0x42,0x12,0x00,0x01,
0x40,0x44,0x22,0x80,0x00,0x40,0x44,0x22,0x80,0x00,0x20,0x48,
0xc2,0x60,0x00,0xe0,0xcf,0x03,0x1f,0x00,0x54,0x55,0x55,0x55,
0x01,0x00,0x00,0x00,0x00,0x00,0x80,0x31,0x00,0x00,0x00,0x40,
0x22,0x02,0x00,0x00,0x20,0x24,0x00,0x00,0x00,0x20,0x24,0x63,
0x35,0x00,0x20,0x24,0x92,0x4c,0x00,0xe0,0x27,0x92,0x44,0x00,
0x20,0x24,0x62,0x44,0x00,0x20,0x24,0x12,0x44,0x00,0x20,0x74,
0xe7,0x44,0x00,0x00,0x00,0x10,0x01,0x00,0x00,0x00,0xe0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define arc_width_big 36
#define arc_height_big 32
static unsigned char arc_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x38,0x00,0x00,0x00,0xc0,0xf8,
0x00,0x00,0x00,0x80,0x38,0x03,0x00,0x00,0x80,0x00,0x0c,
0x00,0x00,0x80,0x00,0x10,0x00,0x00,0x80,0x00,0x20,0x00,
0x00,0xc0,0x01,0x20,0x00,0x00,0x00,0x00,0x40,0x00,0x00,
0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x80,0x30,0x00,0x00,
0x00,0x80,0x48,0x00,0x00,0x00,0xc0,0x41,0x00,0x00,0x00,
0xc0,0x21,0x00,0x00,0x00,0xc0,0x11,0x00,0x00,0x00,0x80,
0x08,0x00,0x00,0x00,0x80,0x78,0x00,0x00,0x00,0x40,0x00,
0x00,0x00,0x00,0x40,0x00,0x00,0xc0,0x00,0x20,0x00,0x00,
0x20,0x01,0x20,0x00,0x00,0x00,0x01,0x10,0x00,0x00,0xc0,
0x00,0x0c,0x00,0x00,0x00,0x39,0x03,0x00,0x00,0x20,0xf9,
0x00,0x00,0x00,0xc0,0x38,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define autoarrow_width_big 36
#define autoarrow_height_big 32
static unsigned char autoarrow_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x02,
0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x0e,0x08,0x87,0x00,0x00,
0x0a,0x10,0x45,0x00,0x00,0x0a,0x10,0x45,0x00,0x00,0x11,0xa0,
0x28,0x00,0x00,0x11,0xa0,0x28,0x00,0x00,0x11,0xc0,0x18,0x00,
0x80,0x20,0xc0,0x18,0x00,0x80,0x20,0xc0,0x18,0x00,0x80,0x20,
0x40,0x15,0x00,0x40,0x40,0x20,0x22,0x00,0x40,0x40,0x20,0x25,
0x00,0x40,0x40,0x20,0x25,0x00,0xe0,0xff,0xf0,0x7f,0x00,0x00,
0x04,0x40,0x12,0x00,0x00,0x04,0x40,0x12,0x00,0x00,0x04,0x20,
0x22,0x00,0x00,0x04,0x20,0x22,0x00,0x00,0x04,0x10,0x42,0x00,
0x00,0x04,0x10,0x42,0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x04,
0x00,0x02,0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define box_width_big 36
#define box_height_big 32
static unsigned char box_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0x1f,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,
0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,
0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,
0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x80,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define arc_box_width_big 36
#define arc_box_height_big 32
static unsigned char arc_box_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfc,0xff,0x03,0x00,0x00,0x03,0x00,0x0c,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,
0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,
0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,
0x00,0x40,0x00,0x00,0x20,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x00,0x03,0x00,0x0c,0x00,0x00,
0xfc,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define cirdia_width_big 36
#define cirdia_height_big 32
static unsigned char cirdia_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x78,0xc0,0x03,
0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,
0x01,0x00,0x10,0x00,0x80,0x01,0x00,0x30,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,
0x60,0x00,0x00,0xc0,0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,
0x04,0x80,0x00,0x60,0x55,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,0x00,0x80,0x00,0x40,
0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,
0x40,0x00,0x80,0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,
0x00,0x01,0x00,0x10,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,0x08,
0x00,0x02,0x00,0x00,0x70,0xc0,0x01,0x00,0x00,0x80,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define cirrad_width_big 36
#define cirrad_height_big 32
static unsigned char cirrad_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x78,0xc0,0x03,
0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,
0x01,0x00,0x10,0x00,0x80,0x01,0x00,0x30,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,
0x60,0x00,0x00,0xc0,0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,
0x04,0x80,0x00,0x20,0x00,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,0x00,0x80,0x00,0x40,
0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,
0x40,0x00,0x80,0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,
0x00,0x01,0x00,0x10,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,0x08,
0x00,0x02,0x00,0x00,0x70,0xc0,0x01,0x00,0x00,0x80,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define convert_width_big 36
#define convert_height_big 32
static unsigned char convert_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xe0,0x00,0x00,0x80,0x00,0x10,0x00,0x00,0x40,
0x00,0x08,0x00,0x00,0x20,0x00,0x08,0x00,0x00,0x10,0x00,0x08,
0x00,0x00,0x08,0x00,0x10,0x10,0x40,0x04,0x00,0x60,0x08,0x80,
0x08,0x00,0x80,0xfc,0xff,0x11,0x00,0x00,0x09,0x80,0x20,0x00,
0x00,0x11,0x40,0x40,0x00,0x00,0x01,0x00,0x20,0x00,0x80,0x00,
0x00,0x10,0x00,0x70,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x7f,0x80,0x7f,0x00,0x08,
0x40,0x40,0x80,0x00,0x08,0x48,0x20,0x01,0x01,0x08,0x44,0x20,
0x02,0x01,0x08,0xfe,0xff,0x07,0x01,0x08,0x44,0x20,0x02,0x01,
0x08,0x48,0x20,0x01,0x01,0x08,0x40,0x20,0x00,0x01,0x08,0x40,
0x40,0x80,0x00,0xf8,0x7f,0x80,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define c_spl_width_big 36
#define c_spl_height_big 32
static unsigned char c_spl_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x1c,0x60,0x00,0x00,0x00,0x02,0x80,
0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x01,0x00,0x01,
0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
0x00,0x02,0x30,0x00,0x00,0x00,0x3c,0x0c,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x30,0x80,0x07,0x00,0x00,0x0c,
0x00,0x08,0x00,0x00,0x03,0x00,0x10,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,
0x00,0x20,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x20,0x00,
0x20,0x00,0x00,0x10,0x00,0x40,0x00,0x00,0x08,0x00,0x40,
0x00,0x00,0x04,0x00,0x80,0x00,0x00,0x03,0x00,0x00,0x07,
0xf0,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define copy_width_big 36
#define copy_height_big 32
static unsigned char copy_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,
0x00,0x1c,0x00,0xc0,0x07,0x00,0x3e,0x00,0x60,0x0c,0x00,0x63,
0x00,0x30,0x0c,0x80,0x61,0x00,0x30,0x0c,0x80,0x61,0x00,0x30,
0x0c,0x80,0x61,0x00,0x30,0x18,0x88,0xc1,0x00,0x30,0x18,0x90,
0xc1,0x00,0x30,0xd8,0xbf,0xc1,0x00,0x30,0x18,0x90,0xc1,0x00,
0x30,0x18,0x88,0xc1,0x00,0x30,0x0c,0x80,0x61,0x00,0x60,0x0c,
0x00,0x63,0x00,0xc0,0x0c,0x00,0x66,0x00,0x80,0x0f,0x00,0x7c,
0x00,0x00,0x07,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
0x03,0x00,0x00,0x00,0x40,0x04,0x00,0x00,0x00,0x40,0x00,0x00,
0x00,0x00,0x40,0xe0,0x34,0x11,0x00,0x40,0x10,0x4d,0x11,0x00,
0x40,0x10,0x45,0x11,0x00,0x40,0x14,0x4d,0x19,0x00,0x80,0xe3,
0x34,0x16,0x00,0x00,0x00,0x04,0x10,0x00,0x00,0x00,0x04,0x0f,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define glue_width_big 36
#define glue_height_big 32
static unsigned char glue_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x38,0x00,0x00,0xe0,0x00,0xf8,0xff,
0xff,0xff,0x00,0x38,0x00,0x00,0xe0,0x00,0x10,0x00,0xe0,
0x40,0x00,0x10,0x3c,0x18,0x43,0x00,0x10,0x42,0x04,0x44,
0x00,0x10,0x81,0x04,0x44,0x00,0x10,0x01,0x04,0x44,0x00,
0x10,0x02,0x18,0x43,0x00,0x10,0x3c,0xe0,0x40,0x00,0x10,
0x40,0x00,0x40,0x00,0x10,0x80,0x00,0x40,0x00,0x10,0x81,
0x00,0x41,0x00,0x10,0x42,0x00,0x42,0x00,0x10,0x3c,0x00,
0x44,0x00,0x10,0x00,0xfe,0x48,0x00,0x10,0x00,0x10,0x48,
0x00,0x10,0x00,0x10,0x48,0x00,0x10,0xff,0x10,0x48,0x00,
0x10,0x81,0x10,0x48,0x00,0x10,0x81,0x10,0x44,0x00,0x10,
0x81,0x10,0x42,0x00,0x10,0xff,0x10,0x41,0x00,0x10,0x00,
0x00,0x40,0x00,0x38,0x00,0x00,0xe0,0x00,0xf8,0xff,0xff,
0xff,0x00,0x38,0x00,0x00,0xe0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define break_width_big 36
#define break_height_big 32
static unsigned char break_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x55,
0x55,0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0xe0,
0x40,0x00,0x00,0x3c,0x18,0x03,0x00,0x10,0x42,0x04,0x44,
0x00,0x00,0x81,0x04,0x04,0x00,0x10,0x01,0x04,0x44,0x00,
0x00,0x02,0x18,0x03,0x00,0x10,0x3c,0xe0,0x40,0x00,0x00,
0x40,0x00,0x00,0x00,0x10,0x80,0x00,0x40,0x00,0x00,0x81,
0x00,0x01,0x00,0x10,0x42,0x00,0x42,0x00,0x00,0x3c,0x00,
0x04,0x00,0x10,0x00,0xfe,0x48,0x00,0x00,0x00,0x10,0x08,
0x00,0x10,0x00,0x10,0x48,0x00,0x00,0xff,0x10,0x08,0x00,
0x10,0x81,0x10,0x48,0x00,0x00,0x81,0x10,0x04,0x00,0x10,
0x81,0x10,0x42,0x00,0x00,0xff,0x10,0x01,0x00,0x10,0x00,
0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x55,0x55,
0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define open_comp_width_big 36
#define open_comp_height_big 32
static unsigned char open_comp_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x0c,0x00,0x00,0xf8,0xff,0x0f,0x00,0x00,0x10,
0x00,0x04,0x00,0x00,0x10,0x00,0x04,0x00,0x00,0x90,0x01,0x04,
0x00,0x00,0x50,0x02,0x04,0x00,0x00,0x50,0x82,0x04,0x00,0x00,
0x90,0xe1,0x04,0x00,0x00,0x10,0x98,0x04,0x00,0x00,0x10,0x8c,
0x04,0x00,0x00,0x10,0xb0,0x04,0x00,0x00,0x10,0xc0,0x04,0x00,
0x00,0x10,0x00,0x04,0x00,0x00,0xf8,0xff,0x0f,0x00,0x00,0x18,
0x00,0x0c,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x20,
0x01,0x00,0x00,0x00,0x20,0x41,0x00,0x00,0x00,0xc0,0x70,0x00,
0x00,0x00,0x00,0x4c,0x00,0x00,0x00,0x00,0x46,0x00,0x00,0x00,
0x00,0x58,0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define join_split_width_big 36
#define join_split_height_big 32
static unsigned char join_split_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x08,0x80,0x00,0x00,0x01,0x10,0x40,0x03,0x00,
0x01,0x10,0x40,0x04,0x80,0x00,0x20,0x78,0x18,0x80,0x00,0x40,
0x78,0x20,0x40,0x00,0x40,0x78,0x40,0x20,0x00,0x80,0x78,0x80,
0x21,0x00,0x00,0x0d,0x04,0x12,0x00,0x00,0x05,0x0e,0x0c,0x00,
0x00,0x02,0x15,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,
0x04,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x15,0x00,
0x00,0x00,0x00,0x0e,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x08,
0x00,0x00,0x00,0x00,0x10,0x80,0x00,0x00,0x01,0x10,0x00,0x03,
0x00,0x01,0x20,0x00,0x04,0x80,0x00,0x40,0x00,0x18,0x80,0x00,
0x40,0x00,0x20,0x40,0x00,0x80,0x00,0x40,0x20,0x00,0x00,0x01,
0x80,0x21,0x00,0x00,0x01,0x00,0x12,0x00,0x00,0x00,0x00,0x0c,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define chop_width_big 36
#define chop_height_big 32
static unsigned char chop_bits_big[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x0c, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00,
   0x00, 0x00, 0xc0, 0x73, 0x00, 0x00, 0x00, 0x3c, 0xf0, 0x00, 0x00, 0x80,
   0x03, 0xe6, 0x00, 0x00, 0x80, 0x80, 0xe1, 0x01, 0x00, 0x80, 0x70, 0xc0,
   0x01, 0x00, 0x80, 0x0c, 0xd2, 0x03, 0x00, 0x80, 0x00, 0x89, 0x03, 0x00,
   0x80, 0xc0, 0xc8, 0x01, 0x00, 0x80, 0x21, 0x24, 0x03, 0x00, 0x00, 0x13,
   0x12, 0x03, 0x00, 0x00, 0x02, 0x09, 0x06, 0x00, 0x00, 0x06, 0x09, 0x06,
   0x00, 0x00, 0x8c, 0x04, 0x0c, 0x00, 0x00, 0x18, 0x02, 0x0c, 0x00, 0x00,
   0x60, 0x01, 0x18, 0x00, 0x20, 0xc0, 0x00, 0x18, 0x00, 0x40, 0x00, 0x00,
   0x30, 0x00, 0x40, 0x00, 0x00, 0x30, 0x00, 0x80, 0x00, 0x00, 0x60, 0x00,
   0x00, 0x01, 0x00, 0x60, 0x00, 0x00, 0x02, 0x40, 0xc0, 0x00, 0x08, 0x02,
   0x30, 0xc0, 0x00, 0x30, 0x04, 0x0c, 0x80, 0x01, 0xc0, 0x00, 0x03, 0x80,
   0x01, 0x00, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00};


#define delete_width_big 36
#define delete_height_big 32
static unsigned char delete_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0xc0,
0x0f,0x00,0x00,0x00,0xe0,0x1f,0x00,0x00,0x00,0x30,0x33,
0x00,0x00,0x00,0x30,0x33,0x00,0x00,0x00,0xe0,0x1f,0x00,
0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0x80,0x07,0x00,0x00,
0x00,0x84,0x87,0x00,0x00,0x00,0x84,0x87,0x01,0x00,0x00,
0x08,0x43,0x00,0x00,0x00,0x70,0x38,0x00,0x00,0x00,0x80,
0x07,0x00,0x00,0x00,0xe0,0x1f,0x01,0x00,0x00,0x3c,0xf0,
0x01,0x00,0x00,0x04,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0xc0,0x00,0x02,0x00,
0x48,0x80,0x00,0x07,0x00,0x48,0x8e,0x38,0xc2,0x01,0x48,
0x91,0x44,0x22,0x02,0x48,0x9f,0x7c,0xe2,0x03,0x48,0x81,
0x04,0x22,0x00,0x48,0x91,0x44,0x2a,0x02,0x3c,0xce,0x39,
0xc4,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define deletept_width_big 36
#define deletept_height_big 32
static unsigned char deletept_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x00,0x00,0x40,0x01,0x00,
0x00,0x00,0xc0,0x01,0x00,0x00,0x80,0xc7,0x00,0x00,0x00,0x00,
0xa9,0x00,0x00,0x00,0x00,0xb2,0x00,0x00,0x00,0x00,0xa4,0x00,
0x00,0x00,0x00,0xc8,0x00,0x00,0x00,0x10,0x98,0x00,0x00,0x00,
0x70,0x28,0x01,0x00,0x00,0x90,0x45,0x02,0x00,0x00,0x30,0x86,
0x04,0x00,0x00,0xc0,0x9a,0x09,0x00,0x00,0x00,0xe3,0x12,0x00,
0x00,0x00,0x8d,0x25,0x00,0x00,0x00,0xb1,0x4e,0x00,0x00,0x80,
0xc0,0x58,0x38,0x00,0x80,0x80,0xe3,0x7c,0x00,0x40,0x80,0xfe,
0xcf,0x00,0x20,0x80,0x80,0x9d,0x00,0x20,0x80,0xc0,0xf3,0x00,
0x10,0x80,0xc0,0x66,0x00,0x10,0x80,0xc0,0x0c,0x00,0x00,0x80,
0x80,0x09,0x00,0x00,0x80,0x00,0x0b,0x00,0x00,0x80,0x00,0x0e,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define elldia_width_big 36
#define elldia_height_big 32
static unsigned char elldia_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,
0x70,0xc4,0x01,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x01,0x00,0x10,0x00,0x80,0x00,0x04,0x20,0x00,
0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x04,0x40,0x00,0x20,0x00,
0x04,0x80,0x00,0x60,0x55,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x40,0x00,0x04,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x80,
0x00,0x04,0x20,0x00,0x00,0x01,0x00,0x10,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x70,0xc4,0x01,0x00,
0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define ellrad_width_big 36
#define ellrad_height_big 32
static unsigned char ellrad_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,
0x70,0xc4,0x01,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x01,0x00,0x10,0x00,0x80,0x00,0x04,0x20,0x00,
0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x04,0x40,0x00,0x20,0x00,
0x04,0x80,0x00,0x20,0x00,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x40,0x00,0x04,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x80,
0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,0x00,0x02,0x00,
0x08,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x70,0xc0,0x01,0x00,
0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define flip_x_width_big 36
#define flip_x_height_big 32
static unsigned char flip_x_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x02,0x00,0x00,0x00,0x1c,0xc0,0x01,0x00,0x00,0x22,
0x22,0x02,0x00,0x00,0x41,0x10,0x04,0x00,0x00,0x41,0x12,
0x04,0x00,0x00,0x41,0x10,0x04,0x00,0x00,0x22,0x22,0x02,
0x00,0x00,0x14,0x40,0x01,0x00,0x00,0x14,0x42,0x01,0x00,
0x80,0xe3,0x38,0x0e,0x00,0x40,0x00,0x07,0x10,0x00,0x20,
0xc3,0x18,0x24,0x00,0x90,0x22,0x27,0x4a,0x00,0x50,0x22,
0x22,0x52,0x00,0x30,0x41,0x10,0x64,0x00,0x00,0x41,0x12,
0x04,0x00,0x80,0x80,0x08,0x08,0x00,0x80,0x80,0x0a,0x08,
0x00,0x40,0x00,0x05,0x10,0x00,0xc0,0xeb,0xbf,0x1e,0x00,
0x00,0x2a,0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,
0x2a,0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,0x2a,
0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,0x3e,0xe0,
0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define flip_y_width_big 36
#define flip_y_height_big 32
static unsigned char flip_y_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,
0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0xa0,0x00,
0x00,0x00,0x00,0xa0,0x00,0x04,0x00,0x00,0x10,0x01,0x02,
0x00,0x00,0x10,0x01,0x0f,0x00,0x00,0x08,0x02,0x32,0x00,
0x00,0x08,0x02,0x44,0x00,0x00,0x04,0x04,0x40,0x00,0x00,
0xfc,0x07,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x50,0x55,
0x55,0x81,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0xfc,0x07,
0x80,0x00,0x00,0x04,0x04,0x40,0x00,0x00,0x08,0x02,0x44,
0x00,0x00,0x08,0x02,0x32,0x00,0x00,0x10,0x01,0x0f,0x00,
0x00,0x10,0x01,0x02,0x00,0x00,0xa0,0x00,0x04,0x00,0x00,
0xa0,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x40,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define intspl_width_big 36
#define intspl_height_big 32
static unsigned char intspl_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x1c,0xe7,0x03,0x00,0x00,0x02,0x80,
0x03,0x00,0x00,0x01,0x80,0x03,0x00,0x80,0x03,0x00,0x00,
0x00,0x80,0x03,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,
0x00,0x02,0x00,0x00,0x00,0x00,0x3c,0x0e,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x00,0x8e,0x07,0x00,0x00,0x00,
0x00,0x08,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
0x20,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x70,
0x00,0xe0,0x00,0x00,0x70,0x00,0xe0,0x00,0x00,0x20,0x00,
0xe0,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x0c,0x00,0x00,
0x01,0x00,0x03,0x00,0x00,0x8e,0xe3,0x00,0x00,0x00,0xf0,
0x1f,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define c_intspl_width_big 36
#define c_intspl_height_big 32
static unsigned char c_intspl_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x9c,0x63,0x00,0x00,0x00,0x02,0xc0,
0x01,0x00,0x80,0x03,0xc0,0x01,0x00,0x80,0x03,0xc0,0x01,
0x00,0x80,0x03,0x80,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
0x00,0x02,0x30,0x00,0x00,0x00,0x3c,0x1c,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x30,0x9c,0x07,0x00,0x00,0x0c,
0x00,0x08,0x00,0x00,0x03,0x00,0x10,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x70,0x00,0x40,0x00,0x00,0x70,
0x00,0xe0,0x00,0x00,0x70,0x00,0xe0,0x00,0x00,0x20,0x00,
0xe0,0x00,0x00,0x10,0x00,0x40,0x00,0x00,0x08,0x00,0x40,
0x00,0x00,0x04,0x00,0x80,0x00,0x00,0x03,0x00,0x00,0xc7,
0xf1,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define line_width_big 36
#define line_height_big 32
static unsigned char line_bits_big[]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x20,0x00,0x04,0x00,0x00,0x30,0x00,
0x0c,0x00,0x00,0x50,0x00,0x0c,0x00,0x00,0x48,0x00,0x14,
0x00,0x00,0x88,0x00,0x14,0x00,0x00,0x84,0x00,0x14,0x00,
0x00,0x04,0x01,0x22,0x00,0x00,0x02,0x01,0x22,0x00,0x00,
0x02,0x02,0x22,0x00,0x00,0x01,0x02,0x42,0x00,0x00,0x01,
0x04,0x42,0x00,0x80,0x00,0x04,0x42,0x00,0x80,0x00,0x02,
0x01,0x00,0x40,0x00,0x01,0x01,0x00,0x40,0x80,0x00,0x01,
0x00,0x20,0x40,0x00,0x01,0x00,0x20,0x20,0x00,0x01,0x00,
0x00,0x10,0x00,0x01,0x00,0x00,0x08,0x80,0x00,0x00,0x00,
0x30,0x40,0x00,0x00,0x00,0xc0,0x20,0x00,0x00,0x00,0x00,
0x13,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define library_width_big 73
#define library_height_big 32
static unsigned char library_bits_big[]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xb0,0x01,0x00,
0x00,0x00,0x00,0x00,0xf8,0x07,0x00,0x5f,0x1f,0x00,0x00,0x00,
0x00,0x00,0xa8,0x04,0xe0,0xb9,0x13,0x00,0x00,0x00,0x00,0x00,
0x98,0x04,0xa0,0x59,0x13,0x00,0x00,0x00,0x00,0xc0,0xcf,0x04,
0x7f,0xb9,0x13,0x00,0x00,0x00,0x00,0xc0,0xae,0x04,0x3b,0xb9,
0x13,0x00,0x00,0x00,0x00,0x40,0x9d,0xfc,0xb5,0x59,0xf3,0x03,
0x00,0x00,0x00,0xc0,0xce,0xdc,0x7b,0xb9,0x73,0x03,0x00,0x00,
0x00,0x40,0xad,0xac,0x35,0x59,0xb3,0x02,0x00,0x00,0x00,0xc0,
0x9e,0xdc,0xbb,0xb9,0x73,0x03,0x00,0x00,0x00,0x60,0xcd,0xac,
0x75,0xb9,0xb3,0x0e,0x00,0x00,0x00,0xe0,0xae,0xdc,0x3b,0x59,
0x73,0x0f,0x00,0x00,0x00,0x60,0x9d,0xac,0xb5,0xb9,0xb3,0x0e,
0x00,0x00,0x00,0xe0,0xce,0xdc,0x7b,0x59,0x73,0x0f,0x00,0x00,
0x00,0x60,0xad,0xac,0x35,0xb9,0xb3,0x0e,0x00,0x00,0x00,0xe0,
0x9e,0xdc,0xbb,0xb9,0x73,0x0f,0x00,0x00,0x00,0x78,0xcd,0xac,
0x75,0x59,0xb3,0x0e,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,
0xff,0x3f,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x3f,
0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0x00,0x00,0x80,
0x02,0x00,0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x80,0x02,0x00,
0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x80,0x02,0x00,0x00,0x00,
0x40,0x01,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define move_width_big 36
#define move_height_big 32
static unsigned char move_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x02,0x00,0x1c,0x00,0x20,0x00,
0x00,0x3e,0x00,0x10,0x04,0x00,0x63,0x00,0x00,0x00,0x80,
0x61,0x00,0x10,0x04,0x80,0x61,0x00,0x00,0x08,0x80,0x61,
0x00,0x10,0x00,0x88,0xc1,0x00,0x00,0x08,0x90,0xc1,0x00,
0x10,0xc0,0xbf,0xc1,0x00,0x00,0x08,0x90,0xc1,0x00,0x10,
0x00,0x88,0xc1,0x00,0x00,0x04,0x80,0x61,0x00,0x20,0x00,
0x00,0x63,0x00,0x00,0x04,0x00,0x66,0x00,0x80,0x02,0x00,
0x7c,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x04,0x00,0x00,0x00,
0xc0,0x06,0x00,0x00,0x00,0xc0,0xc6,0x89,0x1c,0x00,0x40,
0x25,0x8a,0x22,0x00,0x40,0x25,0x8a,0x3e,0x00,0x40,0x24,
0x52,0x02,0x00,0x40,0x24,0x52,0x22,0x00,0x40,0xc4,0x21,
0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define movept_width_big 36
#define movept_height_big 32
static unsigned char movept_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0xa0,0x02,
0x08,0x7e,0x00,0x00,0x00,0x10,0x66,0x00,0x20,0xe2,0x3f,
0x66,0x00,0x00,0x00,0x10,0x7e,0x00,0xa0,0x02,0x08,0x7e,
0x00,0x00,0x00,0x00,0x1c,0x00,0x80,0x02,0x00,0x1e,0x00,
0x00,0x00,0x00,0x1b,0x00,0x80,0x08,0x80,0x19,0x00,0x00,
0x00,0xc0,0x18,0x00,0x80,0x20,0x60,0x18,0x00,0x00,0x00,
0x30,0x18,0x00,0x80,0x80,0x18,0x18,0x00,0x00,0x00,0x0c,
0x18,0x00,0x80,0x00,0x06,0x18,0x00,0x00,0x00,0x03,0x18,
0x00,0x80,0x80,0x09,0x18,0x00,0x00,0xc0,0x00,0x18,0x00,
0x80,0x60,0x20,0x18,0x00,0x00,0x30,0x00,0x18,0x00,0x80,
0x18,0x80,0x18,0x00,0x00,0x0c,0x00,0x18,0x00,0x80,0x06,
0x00,0x1a,0x00,0x00,0x03,0x00,0x18,0x00,0x80,0x01,0x00,
0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define polygon_width_big 36
#define polygon_height_big 32
static unsigned char polygon_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
0x7f,0x00,0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x01,0x00,
0x01,0x00,0x00,0x01,0x00,0x02,0x00,0x00,0x01,0x00,0x04,
0x00,0x00,0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x08,0x00,
0x00,0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x08,0x00,0x00,
0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,
0x00,0x02,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x01,0x80,
0x00,0x00,0x00,0x01,0x7f,0x00,0x00,0x00,0x01,0x01,0x00,
0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,
0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,
0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,
0x01,0x00,0x00,0x00,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define scale_width_big 36
#define scale_height_big 32
static unsigned char scale_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x00,0x0a,0x00,0x40,0x20,0x04,
0x0a,0x00,0x40,0x10,0x08,0x11,0x00,0xa0,0xf8,0x1f,0x11,
0x00,0xa0,0x10,0x88,0x20,0x00,0x10,0x21,0x84,0x20,0x00,
0xf0,0x01,0x40,0x40,0x00,0x00,0x00,0x40,0x40,0x00,0x00,
0x00,0x20,0x80,0x00,0x00,0x00,0x20,0x80,0x00,0x00,0x00,
0x10,0x00,0x01,0x00,0x00,0xf0,0xff,0x01,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xe0,0x00,0xc0,0x00,0x00,0x10,0x01,0x80,0x00,0x00,
0x10,0x00,0x80,0x00,0x00,0x10,0x38,0x8e,0x38,0x00,0xe0,
0x44,0x90,0x44,0x00,0x00,0x05,0x9e,0x7c,0x00,0x00,0x05,
0x91,0x04,0x00,0x10,0x45,0x99,0x44,0x00,0xe0,0x38,0xd6,
0x39,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define spl_width_big 36
#define spl_height_big 32
static unsigned char spl_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,
0x0f,0x00,0x00,0x00,0x0e,0x70,0x00,0x00,0x00,0x01,0x80,
0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,
0x00,0x01,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x00,
0xe0,0x3f,0x00,0x00,0x00,0x00,0xc0,0x03,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
0x10,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x10,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x08,0x00,
0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x02,0x00,0x00,
0x02,0x80,0x01,0x00,0x00,0x1c,0x78,0x00,0x00,0x00,0xe0,
0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define text_width_big 36
#define text_height_big 32
static unsigned char text_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,
0x1f,0x00,0x80,0x83,0x1f,0x1c,0x00,0x80,0x01,0x0f,0x18,
0x00,0x80,0x00,0x0f,0x10,0x00,0x00,0x00,0x0f,0x00,0x00,
0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,
0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,
0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,
0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,
0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
0x80,0x1f,0x00,0x00,0x00,0xe0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define picobj_width_big 36
#define picobj_height_big 32
static unsigned char picobj_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,0x7f,0x00,
0x00,0xe0,0x9b,0xff,0x3c,0x00,0xe0,0xdb,0xff,0x3d,0x00,0xe0,
0xff,0xff,0x7f,0x00,0x30,0x00,0x00,0xc0,0x00,0xf0,0xff,0xbe,
0xff,0x00,0xf0,0xff,0xff,0xff,0x00,0xf0,0xff,0xc1,0xff,0x00,
0xf0,0xff,0x9c,0xff,0x00,0xf0,0x7f,0x22,0xff,0x00,0xf0,0x7f,
0x41,0xff,0x00,0xf0,0x7f,0x41,0xff,0x00,0xf0,0x7f,0x22,0xff,
0x00,0xf0,0xff,0x9c,0xff,0x00,0xf0,0xff,0xc1,0xff,0x00,0xf0,
0xff,0xff,0xff,0x00,0xf0,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
0x00,0x00,0x78,0x04,0x00,0x00,0x00,0x90,0x00,0x02,0x00,0x00,
0x90,0x66,0x97,0x9a,0x01,0x70,0x14,0x92,0x44,0x01,0x10,0x14,
0x92,0xc4,0x00,0x10,0x14,0x92,0x44,0x00,0x38,0x64,0x64,0x8e,
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define rotCCW_width_big 36
#define rotCCW_height_big 32
static unsigned char rotCCW_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x02,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x80,0x02,0x00,
0x00,0x00,0x40,0x1e,0x00,0x00,0x00,0x20,0x60,0x00,0x00,0x00,
0x20,0x80,0x00,0x00,0x00,0x40,0x1e,0x01,0x00,0x00,0x80,0x22,
0x01,0x00,0x00,0x00,0x43,0x02,0x00,0x00,0x00,0x42,0x02,0x00,
0x00,0x78,0x40,0x02,0x00,0x00,0x48,0x40,0x02,0x00,0x00,0x48,
0x40,0x02,0x00,0x00,0x90,0x20,0x01,0x00,0x00,0x10,0x1f,0x01,
0x00,0x00,0x20,0x80,0x00,0x00,0x00,0xc0,0x60,0x00,0x00,0x00,
0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x80,0x00,
0x02,0x00,0x88,0x80,0x00,0x02,0x00,0x88,0xcc,0x31,0xc7,0x00,
0x88,0x92,0x40,0x22,0x01,0x78,0x92,0x78,0xe2,0x01,0x88,0x92,
0x48,0x22,0x00,0x88,0x92,0x4a,0x2a,0x01,0x88,0x0c,0x71,0xc4,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define rotCW_width_big 36
#define rotCW_height_big 32
static unsigned char rotCW_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x08,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x28,0x00,
0x00,0x00,0x00,0x4f,0x00,0x00,0x00,0xc0,0x80,0x00,0x00,0x00,
0x20,0x80,0x00,0x00,0x00,0x10,0x4f,0x00,0x00,0x00,0x90,0x28,
0x00,0x00,0x00,0x48,0x18,0x00,0x00,0x00,0x48,0x08,0x00,0x00,
0x00,0x48,0xc0,0x03,0x00,0x00,0x48,0x40,0x02,0x00,0x00,0x48,
0x40,0x02,0x00,0x00,0x90,0x20,0x01,0x00,0x00,0x10,0x1f,0x01,
0x00,0x00,0x20,0x80,0x00,0x00,0x00,0xc0,0x60,0x00,0x00,0x00,
0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x80,0x00,
0x02,0x00,0x88,0x80,0x00,0x02,0x00,0x88,0xcc,0x31,0xc7,0x00,
0x88,0x92,0x40,0x22,0x01,0x78,0x92,0x78,0xe2,0x01,0x88,0x92,
0x48,0x22,0x00,0x88,0x92,0x4a,0x2a,0x01,0x88,0x0c,0x71,0xc4,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define update_width_big 36
#define update_height_big 32
static unsigned char update_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xc0,0x07,0xff,0xff,0x01,0x60,0x0d,0x01,0x00,
0x01,0xb0,0x1a,0x01,0x3e,0x01,0x50,0x35,0x3d,0x2a,0x01,0xb0,
0x2a,0x01,0x36,0x01,0x50,0x35,0x7d,0x2a,0x01,0xb0,0x2a,0x01,
0x3e,0x01,0x60,0x35,0x01,0x00,0x01,0xc0,0x1f,0xff,0xff,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x80,0x03,
0x80,0x03,0x00,0x40,0x05,0x40,0x05,0x00,0x00,0x01,0x00,0x01,
0x00,0x00,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x48,
0x00,0x02,0x02,0x00,0x48,0x00,0x02,0x02,0x00,0x48,0x8d,0x32,
0xc7,0x00,0x48,0x53,0x43,0x22,0x01,0x48,0x51,0x7a,0xe2,0x01,
0x48,0x53,0x4a,0x22,0x00,0x48,0x4d,0x4b,0x2a,0x01,0x30,0x81,
0x72,0xc4,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define edit_width_big 36
#define edit_height_big 32
static unsigned char edit_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xa7,
0xaa,0xff,0x00,0x60,0x0c,0x80,0x80,0x00,0x20,0x18,0x80,
0x8e,0x00,0x30,0x30,0x80,0x80,0x00,0x10,0x20,0x80,0x9e,
0x00,0x30,0x20,0x80,0x80,0x00,0x60,0x30,0x80,0x86,0x00,
0xc0,0x18,0x80,0x80,0x00,0x80,0x0f,0x80,0xbe,0x00,0x00,
0x20,0x80,0x80,0x00,0x00,0x80,0x80,0xbe,0x00,0x00,0x00,
0x82,0x80,0x00,0x00,0x00,0x88,0x80,0x00,0x00,0x00,0xa0,
0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1f,0x04,0x00,0x00,0x00,0x01,0x44,0x04,0x00,
0x00,0x01,0x04,0x04,0x00,0x00,0x81,0x65,0x0e,0x00,0x00,
0x4f,0x46,0x04,0x00,0x00,0x41,0x44,0x04,0x00,0x00,0x41,
0x44,0x04,0x00,0x00,0x41,0x46,0x14,0x00,0x00,0x9f,0xe5,
0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define areameas_width_big 36
#define areameas_height_big 32
static unsigned char areameas_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0xee,0x00,0x00,0x00,0x00,0x27,0x01,0x00,0x00,0x80,
0x25,0x03,0x00,0x00,0xc0,0x24,0x05,0x00,0x00,0xe0,0x24,0x09,
0x00,0x00,0xa0,0x24,0x09,0x00,0x00,0xb0,0x24,0x19,0x00,0x00,
0xb0,0x24,0x19,0x00,0x00,0x98,0x24,0x39,0x00,0x00,0x98,0x24,
0x29,0x00,0x00,0x98,0x24,0x29,0x60,0x00,0x98,0x24,0xe9,0xdc,
0x00,0x98,0x24,0xc9,0x97,0x01,0x98,0x24,0x49,0x92,0x01,0x98,
0x24,0x49,0x92,0x01,0x90,0x24,0x49,0x92,0x01,0xb0,0xfc,0x49,
0x92,0x01,0xb0,0x0e,0x4b,0x92,0x00,0xe0,0x03,0x4e,0xd2,0x00,
0xc0,0x00,0x4c,0x72,0x00,0x00,0x00,0x4c,0x3a,0x00,0x00,0x00,
0xdc,0x07,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};
#define tangent_width_big 36
#define tangent_height_big 32
static unsigned char tangent_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x7d,0x00,0x00,0xe0,0x00,0x11,
0x00,0x00,0x00,0x03,0x11,0x00,0x00,0x00,0x0c,0x11,0x00,0x00,
0x00,0x10,0x11,0x00,0x00,0x00,0x20,0x01,0x00,0x10,0x01,0x20,
0x01,0x00,0x30,0x01,0x40,0x01,0x00,0x50,0x01,0x40,0x01,0x00,
0x90,0x01,0x80,0x01,0x00,0x10,0x01,0x80,0x01,0x00,0x00,0x00,
0xc0,0x01,0x00,0xf8,0xff,0xff,0x3f,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x80,0x01,0x00,0x00,
0x00,0x40,0x01,0x00,0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x20,
0x01,0x00,0x00,0x00,0x20,0x01,0x00,0x00,0x00,0x10,0x01,0x00,
0x00,0x00,0x0c,0x01,0x00,0x00,0x00,0x03,0x01,0x00,0x00,0xe0,
0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};
#define anglemeas_width_big 36
#define anglemeas_height_big 32
static unsigned char anglemeas_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x07,0x00,0x00,
0x00,0x30,0x07,0x00,0x00,0x00,0x20,0x0f,0x00,0x00,0x00,0x20,
0x30,0x00,0x00,0x00,0x20,0x40,0x00,0x00,0x00,0x20,0x80,0x01,
0x00,0x00,0x70,0x00,0x06,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,
0x00,0x00,0x21,0xc0,0x00,0x00,0x80,0xc0,0x20,0x01,0x00,0x80,
0x00,0x0f,0x01,0x00,0x80,0x00,0x8e,0x00,0x00,0x80,0x00,0x4f,
0x00,0x00,0x80,0xc0,0x20,0x00,0x00,0x00,0x21,0xe0,0x01,0x00,
0x00,0x1a,0x00,0x00,0x30,0x00,0x06,0x00,0x00,0x48,0x80,0x01,
0x00,0x00,0x40,0x40,0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00,
0x40,0x0f,0x00,0x00,0x00,0x48,0x07,0x00,0x00,0x00,0x30,0x07,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define lenmeas_width_big 36
#define lenmeas_height_big 32
static unsigned char lenmeas_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x80,0x13,0x00,0x40,
0x00,0x70,0x10,0x80,0xc1,0x00,0x18,0x10,0xe0,0x83,0x01,0x08,
0x10,0x30,0x06,0x01,0x0c,0x10,0x10,0x0c,0x01,0x04,0x18,0x18,
0x08,0x01,0x04,0x08,0x08,0x0c,0x01,0x04,0x04,0x08,0x04,0x01,
0x00,0x03,0x0c,0x84,0x01,0xc0,0x00,0x06,0xdc,0x00,0x60,0x00,
0x03,0x70,0x00,0x60,0xc0,0x00,0x00,0x00,0xc0,0x3f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x21,0x84,0x10,0x02,
0x08,0x21,0x84,0x10,0x02,0x08,0x21,0x84,0x10,0x02,0xf8,0xff,
0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};


/********* special icon for X-Splines used in popup edit panel */

#define c_xspl_width 36
#define c_xspl_height 32
static unsigned char    c_xspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf8,0x0f,0x00,0xfe,0x03,0x10,0x08,
0x00,0x02,0x01,0x10,0x08,0x00,0x81,0x00,0x20,0x08,0x80,
0x40,0x00,0x40,0x10,0x40,0x20,0x00,0x40,0x20,0x40,0x20,
0x00,0x80,0x20,0x20,0x10,0x00,0x80,0x40,0x10,0x08,0x00,
0x80,0x80,0x08,0x08,0x00,0x00,0x01,0x07,0x04,0x00,0x00,
0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,
0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,
0x08,0x00,0x00,0x01,0x07,0x08,0x00,0x80,0x80,0x08,0x08,
0x00,0x80,0x40,0x10,0x10,0x00,0x40,0x40,0x20,0x10,0x00,
0x40,0x20,0x20,0x20,0x00,0x20,0x20,0x40,0x40,0x00,0x20,
0x10,0x40,0x80,0x00,0x10,0x08,0x80,0x00,0x01,0x08,0x08,
0x80,0x00,0x02,0xf8,0x0f,0x00,0xff,0x03,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define xspl_width 36
#define xspl_height 32
static unsigned char    xspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x08,0x00,
0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,
0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,
0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
0xf8,0x0f,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,
0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,
0x00,0x00,0x00,0x01,0x00,0x00,0x04,0x80,0x00,0x00,0x00,
0x38,0x40,0x00,0x00,0x00,0xc0,0x31,0x00,0x00,0x00,0x00,
0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

/********* icons for indicator panel **********/

#define open_arc_width 32
#define open_arc_height 32
static unsigned char open_arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x06,0x00,
0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x18,0x00,
0x00,0x00,0x18,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,
0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x60,0x00,
0x00,0x00,0x60,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x60,0x00,
0x00,0x00,0x60,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,
0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x18,0x00,
0x00,0x00,0x18,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,
0x00,0x00,0x06,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define pie_wedge_arc_width 32
#define pie_wedge_arc_height 32
static unsigned char pie_wedge_arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x03,0x00,0x00,0x80,0x07,0x00,0x00,0xc0,0x0c,0x00,
0x00,0x60,0x18,0x00,0x00,0x30,0x18,0x00,0x00,0x18,0x30,0x00,
0x00,0x0c,0x30,0x00,0x00,0x06,0x60,0x00,0x00,0x03,0x60,0x00,
0x80,0x01,0x60,0x00,0xc0,0x00,0x60,0x00,0x60,0x00,0xc0,0x00,
0x30,0x00,0xc0,0x00,0x18,0x00,0xc0,0x00,0x30,0x00,0xc0,0x00,
0x60,0x00,0xc0,0x00,0xc0,0x00,0x60,0x00,0x80,0x01,0x60,0x00,
0x00,0x03,0x60,0x00,0x00,0x06,0x60,0x00,0x00,0x0c,0x30,0x00,
0x00,0x18,0x30,0x00,0x00,0x30,0x18,0x00,0x00,0x60,0x18,0x00,
0x00,0xc0,0x0c,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartoff_width 32
#define smartoff_height 32
static unsigned char smartoff_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0xc0,0x3f,0x00,0x00,0x00,0x40,0x40,
0x08,0x00,0x00,0x00,0x08,0x00,0x40,0x55,0x08,0x00,0x00,
0x00,0x08,0x00,0xc0,0x7f,0x08,0x00,0x40,0x40,0x2a,0x00,
0x40,0x40,0x1c,0x00,0x40,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x80,0xe3,0xf3,0x01,0x40,0x24,0x10,0x00,0x40,0xe4,
0x70,0x00,0x40,0x24,0x10,0x00,0x80,0x23,0x10,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartmove_width 32
#define smartmove_height 32
static unsigned char smartmove_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0x40,0x15,0x00,0x00,0x40,0x40,0x40,
0x08,0x80,0x00,0x00,0x08,0x00,0x41,0x55,0x08,0x00,0x02,
0x00,0x08,0x00,0xc4,0x7f,0x08,0x00,0x48,0x40,0x2a,0x00,
0x50,0x40,0x1c,0x00,0x60,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x88,0x38,0x22,0x1f,0xd8,0x44,0x22,0x01,0xa8,0x44,
0x22,0x07,0x88,0x44,0x14,0x01,0x88,0x38,0x08,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartslide_width 32
#define smartslide_height 32
static unsigned char smartslide_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0x40,0x15,0x00,0x00,0x40,0x40,0x40,
0x08,0x40,0x00,0x00,0x08,0x40,0x40,0x55,0x08,0x40,0x00,
0x00,0x08,0x40,0xc0,0x7f,0x08,0x40,0x40,0x40,0x2a,0x40,
0x40,0x40,0x1c,0xc0,0x7f,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x70,0x82,0x73,0x1e,0x08,0x02,0x91,0x02,0x70,0x02,
0x91,0x0e,0x80,0x02,0x91,0x02,0x70,0x9e,0x73,0x1e,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinmiter_width 32
#define joinmiter_height 32
static unsigned char joinmiter_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x03,0xf0,0xff,0xff,0x00,
0xf0,0xff,0x3f,0x00,0x00,0xf8,0x0f,0x00,0x00,0xfe,0x03,0x00,
0x80,0xff,0x00,0x00,0xe0,0x3f,0x00,0x00,0xf0,0x0f,0x00,0x00,
0xf0,0x03,0x00,0x00,0xf0,0x00,0x00,0x00,0x20,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinround_width 32
#define joinround_height 32
static unsigned char joinround_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x0f,
0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x07,0x00,0x80,0xff,0x03,
0x00,0xe0,0xff,0x00,0x00,0xf8,0x3f,0x00,0x00,0xfe,0x0f,0x00,
0x80,0xff,0x03,0x00,0xe0,0xff,0x00,0x00,0xc0,0x3f,0x00,0x00,
0xc0,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinbevel_width 32
#define joinbevel_height 32
static unsigned char joinbevel_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0x00,0x80,0xff,0x03,
0x00,0xe0,0xff,0x00,0x00,0xf8,0x3f,0x00,0x00,0xfe,0x0f,0x00,
0x80,0xff,0x03,0x00,0xe0,0xff,0x00,0x00,0xc0,0x3f,0x00,0x00,
0xc0,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capbutt_width 32
#define capbutt_height 32
static unsigned char capbutt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,
0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capround_width 32
#define capround_height 32
static unsigned char capround_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xf0,0xff,0xff,0x07,0xf8,0xff,0xff,0x0f,0xf8,0xff,0xff,0x0f,
0xf8,0xff,0xff,0x0f,0xf0,0xff,0xff,0x07,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capproject_width 32
#define capproject_height 32
static unsigned char capproject_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define solidline_width 32
#define solidline_height 32
static unsigned char solidline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dashline_width 32
#define dashline_height 32
static unsigned char dashline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x7c,0x7c,0x7c,0x7c,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dottedline_width 32
#define dottedline_height 32
static unsigned char dottedline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x08,0x21,0x84,0x10,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dashdotline_width 32
#define dashdotline_height 32
static unsigned char dashdotline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0xe2,0x47,0xfc,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dash2dotsline_width 32
#define dash2dotsline_height 32
static unsigned char dash2dotsline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x12,0x3f,0x12,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dash3dotsline_width 32
#define dash3dotsline_height 32
static unsigned char dash3dotsline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x92,0xf8,0x91,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

/* fine grid (only used for point positioning) */

#define fine_grid_width 32
#define fine_grid_height 32
static unsigned char fine_grid_bits[]={
0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09};

#define grid1_width 32
#define grid1_height 32
static unsigned char grid1_bits[] = {
0x00,0x00,0x00,0x00,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define grid2_width 32
#define grid2_height 32
static unsigned char	grid2_bits[] = {
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10};

#define grid3_width 32
#define grid3_height 32
static unsigned char	grid3_bits[] = {
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0xff,0xff,0xff,0xff,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0xff,0xff,0xff,0xff,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0xff,0xff,0xff,0xff,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02};

#define grid4_width 32
#define grid4_height 32
static unsigned char	grid4_bits[] = {
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0xff,0xff,0xff,0xff,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0xff,0xff,0xff,0xff,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04};

#define grid_iso1_width 32					// isometric grid
#define grid_iso1_height 32
static unsigned char grid_iso1_bits[] = {
0x00,0x00,0x00,0x00,0xc8,0x27,0x9f,0x7c,0x3e,0xf9,0xe4,0x13,
0x08,0x21,0x84,0x10,0x3e,0xf9,0xe4,0x13,0xc8,0x27,0x9f,0x7c,
0x08,0x21,0x84,0x10,0xc8,0x27,0x9f,0x7c,0x3e,0xf9,0xe4,0x13,
0x08,0x21,0x84,0x10,0x3e,0xf9,0xe4,0x13,0xc8,0x27,0x9f,0x7c,
0x08,0x21,0x84,0x10,0xc8,0x27,0x9f,0x7c,0x3e,0xf9,0xe4,0x13,
0x08,0x21,0x84,0x10,0x3e,0xf9,0xe4,0x13,0xc8,0x27,0x9f,0x7c,
0x08,0x21,0x84,0x10,0xc8,0x27,0x9f,0x7c,0x3e,0xf9,0xe4,0x13,
0x08,0x21,0x84,0x10,0x3e,0xf9,0xe4,0x13,0xc8,0x27,0x9f,0x7c,
0x08,0x21,0x84,0x10,0xc8,0x27,0x9f,0x7c,0x3e,0xf9,0xe4,0x13,
0x08,0x21,0x84,0x10,0x3e,0xf9,0xe4,0x13,0xc8,0x27,0x9f,0x7c,
0x08,0x21,0x84,0x10,0x00,0x00,0x00,0x00};

#define grid_iso2_width 32
#define grid_iso2_height 32
static unsigned char grid_iso2_bits[] = {
0x00,0x00,0x00,0x00,0x20,0x7c,0x08,0x1f,0x26,0x93,0xc9,0x64,
0xf8,0x10,0x3e,0x04,0x20,0x10,0x08,0x04,0xf8,0x10,0x3e,0x04,
0x26,0x93,0xc9,0x64,0x20,0x7c,0x08,0x1f,0x20,0x10,0x08,0x04,
0x20,0x7c,0x08,0x1f,0x26,0x93,0xc9,0x64,0xf8,0x10,0x3e,0x04,
0x20,0x10,0x08,0x04,0xf8,0x10,0x3e,0x04,0x26,0x93,0xc9,0x64,
0x20,0x7c,0x08,0x1f,0x20,0x10,0x08,0x04,0x20,0x7c,0x08,0x1f,
0x26,0x93,0xc9,0x64,0xf8,0x10,0x3e,0x04,0x20,0x10,0x08,0x04,
0xf8,0x10,0x3e,0x04,0x26,0x93,0xc9,0x64,0x20,0x7c,0x08,0x1f,
0x20,0x10,0x08,0x04,0x20,0x7c,0x08,0x1f,0x26,0x93,0xc9,0x64,
0xf8,0x10,0x3e,0x04,0x20,0x10,0x08,0x04,0xf8,0x10,0x3e,0x04,
0x26,0x93,0xc9,0x64,0x00,0x00,0x00,0x00};

#define grid_iso3_width 32
#define grid_iso3_height 32
static unsigned char grid_iso3_bits[] = {
0x00,0x00,0x00,0x00,0x40,0xe0,0x03,0x01,0x42,0x98,0x0c,0x61,
0x4c,0x86,0x30,0x19,0xf0,0x81,0xc0,0x07,0x40,0x80,0x00,0x01,
0xf0,0x81,0xc0,0x07,0x4c,0x86,0x30,0x19,0x42,0x98,0x0c,0x61,
0x40,0xe0,0x03,0x01,0x40,0x80,0x00,0x01,0x40,0xe0,0x03,0x01,
0x42,0x98,0x0c,0x61,0x4c,0x86,0x30,0x19,0xf0,0x81,0xc0,0x07,
0x40,0x80,0x00,0x01,0xf0,0x81,0xc0,0x07,0x4c,0x86,0x30,0x19,
0x42,0x98,0x0c,0x61,0x40,0xe0,0x03,0x01,0x40,0x80,0x00,0x01,
0x40,0xe0,0x03,0x01,0x42,0x98,0x0c,0x61,0x4c,0x86,0x30,0x19,
0xf0,0x81,0xc0,0x07,0x40,0x80,0x00,0x01,0xf0,0x81,0xc0,0x07,
0x4c,0x86,0x30,0x19,0x42,0x98,0x0c,0x61,0x40,0xe0,0x03,0x01,
0x40,0x80,0x00,0x01,0x00,0x00,0x00,0x00};

#define grid_iso4_width 32
#define grid_iso4_height 32
static unsigned char grid_iso4_bits[] = {
0x00,0x00,0x00,0x00,0x06,0x02,0x43,0x18,0x18,0xc2,0x40,0x60,
0x60,0x32,0x40,0x00,0x80,0x0f,0x40,0x00,0x00,0x02,0x40,0x00,
0x80,0x0f,0x40,0x00,0x60,0x32,0x40,0x00,0x18,0xc2,0x40,0x60,
0x06,0x02,0x43,0x18,0x00,0x02,0x4c,0x06,0x00,0x02,0xf0,0x01,
0x00,0x02,0x40,0x00,0x00,0x02,0xf0,0x01,0x00,0x02,0x4c,0x06,
0x06,0x02,0x43,0x18,0x18,0xc2,0x40,0x60,0x60,0x32,0x40,0x00,
0x80,0x0f,0x40,0x00,0x00,0x02,0x40,0x00,0x80,0x0f,0x40,0x00,
0x60,0x32,0x40,0x00,0x18,0xc2,0x40,0x60,0x06,0x02,0x43,0x18,
0x00,0x02,0x4c,0x06,0x00,0x02,0xf0,0x01,0x00,0x02,0x40,0x00,
0x00,0x02,0xf0,0x01,0x00,0x02,0x4c,0x06,0x06,0x02,0x43,0x18,
0x18,0xc2,0x40,0x60,0x00,0x00,0x00,0x00};


#define unconstrained_width 32
#define unconstrained_height 32
static unsigned char unconstrained_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xa0,0xfa,0x01,0x00,0x08,0xf4,0x01,0x00,0x02,
0xe0,0x01,0x00,0x00,0xc4,0x02,0x80,0x00,0x00,0x06,0x00,
0x00,0x02,0x08,0x20,0x00,0x00,0x0c,0x00,0x00,0x02,0x16,
0x10,0x00,0x80,0x13,0x00,0x00,0xe2,0x10,0x08,0x00,0x70,
0x20,0x00,0x00,0x19,0xf8,0x08,0x00,0x0e,0x70,0x00,0x00,
0x03,0x70,0x08,0x00,0x14,0x70,0x00,0x00,0x42,0x20,0x08,
0x00,0x00,0x21,0x00,0x00,0x08,0x04,0x10,0x00,0x00,0x10,
0x00,0x00,0x10,0x00,0x20,0x00,0x00,0x08,0x00,0x00,0x20,
0x00,0x80,0x00,0x00,0x02,0x00,0x00,0x40,0x00,0x00,0x02,
0x80,0x00,0x00,0x08,0x20,0x00,0x00,0xa0,0x0a,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define latexline_width 32
#define latexline_height 32
static unsigned char latexline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,
0x00,0x00,0xf8,0x01,0x00,0x00,0x0f,0x00,0x00,0x80,0xf7,
0x03,0x00,0x80,0x09,0xfc,0x00,0x40,0x31,0x00,0x0f,0x20,
0xc1,0x00,0x00,0x10,0x01,0x01,0x00,0x10,0x01,0x06,0x00,
0x08,0x01,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x18,0xf0,0x83,0x61,0x18,0xf3,0x03,0x33,0x98,
0xc4,0x00,0x33,0x98,0xc4,0x00,0x1e,0x98,0xc7,0x3e,0x0c,
0x98,0xc4,0x06,0x0c,0x98,0xc4,0x06,0x1e,0x18,0xc0,0x06,
0x33,0xf8,0xc1,0x1e,0x33,0xf8,0xc1,0x86,0x61,0x00,0x00,
0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x3e,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define latexarrow_width 32
#define latexarrow_height 32
static unsigned char latexarrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x1f,
0x00,0x00,0xf8,0x0c,0x00,0x00,0x0f,0x00,0x00,0x80,0xf7,
0x03,0x00,0x80,0x09,0xfc,0x06,0x40,0x31,0x00,0x0f,0x20,
0xc1,0x02,0x1f,0x98,0x03,0x03,0x00,0xb8,0x03,0x07,0x00,
0x18,0x01,0x0f,0x00,0x08,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x18,0xf0,0x83,0x61,0x18,0xf3,0x03,0x33,0x98,
0xc4,0x00,0x33,0x98,0xc4,0x00,0x1e,0x98,0xc7,0x3e,0x0c,
0x98,0xc4,0x06,0x0c,0x98,0xc4,0x06,0x1e,0x18,0xc0,0x06,
0x33,0xf8,0xc1,0x1e,0x33,0xf8,0xc1,0x86,0x61,0x00,0x00,
0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x3e,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define mounthattan_width 32
#define mounthattan_height 32
static unsigned char mounthattan_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,
0x98,0x01,0x00,0x00,0x98,0x01,0x02,0x00,0x98,0x01,0x07,
0x00,0x98,0x81,0x0d,0x00,0x9c,0xc3,0x18,0x80,0x9c,0x63,
0x30,0xc0,0x0d,0x33,0x20,0x60,0x0f,0x1b,0x00,0x30,0x0e,
0x0f,0x00,0x18,0x0c,0x07,0x00,0x0c,0x0c,0x03,0x00,0x04,
0x0c,0x03,0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,0x1f,0x00,
0x00,0x0c,0x1f,0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define manhattan_width 32
#define manhattan_height 32
static unsigned char manhattan_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,
0xf8,0x01,0x00,0x00,0x98,0x01,0x00,0x00,0x98,0x01,0x00,
0x00,0x98,0x01,0x00,0x00,0x9c,0x03,0x00,0x00,0x9c,0x03,
0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,
0x03,0x00,0x7c,0x0c,0xf3,0x01,0x7c,0x0c,0xf3,0x01,0x60,
0x0c,0xb3,0x01,0x60,0x0c,0xbf,0x01,0x60,0x0c,0xbf,0x01,
0xe0,0x0f,0x80,0x01,0xe0,0x0f,0x80,0x01,0x00,0x00,0x80,
0x3f,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define mountain_width 32
#define mountain_height 32
static unsigned char mountain_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,
0x00,0x00,0x00,0x70,0x00,0x00,0x00,0xd8,0x00,0x00,0x00,
0x8c,0x01,0x00,0x00,0x04,0x03,0x00,0x00,0x00,0x06,0x00,
0x00,0x00,0x0c,0x00,0x04,0x00,0x18,0x00,0x0e,0x00,0x30,
0x00,0x1b,0x00,0x60,0x80,0x31,0x00,0xc0,0xc0,0x20,0x00,
0x80,0x61,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x1e,0x00,
0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignl_width 32
#define halignl_height 32
static unsigned char halignl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,
0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,
0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x68,0x00,
0x00,0x00,0x88,0x01,0x00,0x00,0x08,0x06,0x00,0x00,0x88,
0x01,0x00,0x00,0x68,0x00,0x00,0x00,0x18,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,
0x00,0x08,0x00,0x80,0x00,0x08,0x00,0x80,0x00,0x08,0x00,
0x80,0x00,0xf8,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignr_width 32
#define halignr_height 32
static unsigned char halignr_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfe,0x1f,0x00,0x00,0x02,0x10,0x00,0x00,
0x02,0x10,0x00,0x00,0x02,0x10,0x00,0x00,0x02,0x10,0x00,
0x00,0x02,0x10,0x00,0x00,0x02,0x10,0x00,0x00,0x02,0x10,
0x00,0x00,0x02,0x10,0x00,0x00,0xfe,0x1f,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,
0x00,0x16,0x00,0x00,0x80,0x11,0x00,0x00,0x60,0x10,0x00,
0x00,0x80,0x11,0x00,0x00,0x00,0x16,0x00,0x00,0x00,0x18,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0x01,0x00,0x10,0x00,0x01,0x00,0x10,0x00,0x01,
0x00,0x10,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignc_width 32
#define halignc_height 32
static unsigned char halignc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xfc,0x3f,0x00,0x00,0x04,0x20,0x00,0x00,0x04,
0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,0x00,
0x04,0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,
0x00,0x04,0x20,0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x80,
0x02,0x00,0x00,0x80,0x02,0x00,0x00,0x40,0x04,0x00,0x00,
0x40,0x04,0x00,0x00,0x20,0x08,0x00,0x00,0xe0,0x0f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,
0x07,0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,
0x00,0x04,0xe0,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define haligndc_width 32
#define haligndc_height 32
static unsigned char haligndc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x1f,0x00,0x00,0x08,0x10,0x00,0x00,0x08,0x10,
0x00,0x00,0x08,0x10,0x00,0x00,0x88,0x11,0x00,0x00,0x88,
0x11,0x00,0x00,0x08,0x10,0x00,0x00,0x08,0x10,0x00,0x00,
0x08,0x10,0x00,0x00,0xf8,0x1f,0x00,0x1f,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x01,0x11,0x00,0x80,
0x02,0x11,0x00,0x40,0x04,0x11,0x00,0x20,0x09,0x11,0x00,
0x10,0x10,0x15,0x00,0xf8,0x3f,0x15,0x00,0x00,0x00,0x15,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignde_width 32
#define halignde_height 32
static unsigned char halignde_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x1f,0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,
0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00,0x00,0x18,
0x18,0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00,0x00,
0x18,0x18,0x00,0x00,0xf8,0x1f,0x02,0x1f,0x00,0x00,0x02,
0x1b,0x00,0x00,0x07,0x1b,0x00,0x00,0x05,0x1b,0x00,0x80,
0x0d,0x1b,0x00,0x80,0x08,0x1b,0x00,0xc0,0x18,0x1b,0x00,
0xc0,0x18,0x1b,0x00,0xc0,0x1f,0x1b,0x00,0x00,0x00,0x1b,
0x00,0x00,0x00,0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,0x00,
0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,
0x00,0x1b,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define haligna_width 32
#define haligna_height 32
static unsigned char haligna_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x0a,0x00,
0x00,0x00,0x0a,0x00,0xf8,0x1f,0x11,0x1f,0x08,0x10,0x11,
0x11,0x08,0x90,0x20,0x11,0x08,0x90,0x20,0x11,0x08,0x50,
0x40,0x11,0x08,0x50,0x40,0x11,0x08,0x30,0x80,0x11,0x08,
0xf0,0xff,0x11,0x08,0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignt_width 32
#define valignt_height 32
static unsigned char valignt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x9f,0x3f,0x1f,0x08,0x90,0x20,0x11,0x08,0x10,
0x11,0x11,0x08,0x10,0x11,0x11,0x08,0x10,0x0a,0x11,0x08,
0x10,0x0a,0x11,0x08,0x10,0x04,0x11,0x08,0x10,0x04,0x11,
0x08,0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,
0x00,0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignb_width 32
#define valignb_height 32
static unsigned char valignb_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0xf8,
0x1f,0x00,0x11,0x08,0x10,0x00,0x11,0x08,0x10,0x00,0x11,
0x08,0x10,0x04,0x11,0x08,0x10,0x0a,0x11,0x08,0x10,0x0a,
0x11,0x08,0x10,0x11,0x11,0x08,0x10,0x11,0x11,0x08,0x90,
0x20,0x11,0xf8,0x9f,0x3f,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignc_width 32
#define valignc_height 32
static unsigned char valignc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,
0xf8,0x1f,0x00,0x11,0x08,0x10,0x30,0x11,0x08,0x10,0x2c,
0x11,0x08,0x10,0x23,0x11,0x08,0x90,0x20,0x11,0x08,0x10,
0x23,0x11,0x08,0x10,0x2c,0x11,0x08,0x10,0x30,0x11,0x08,
0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,0x00,0x00,0x00,0x11,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valigndc_width 32
#define valigndc_height 32
static unsigned char valigndc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x43,0x00,0x00,0x08,
0x43,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,
0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x80,
0x08,0x00,0x00,0x40,0x12,0x00,0x00,0x20,0x20,0x00,0x00,
0xf0,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0x01,0x00,0x10,0x00,0x01,0x0e,0x10,0x00,0x01,
0x00,0x10,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignde_width 32
#define valignde_height 32
static unsigned char valignde_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,
0x40,0x00,0x00,0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,
0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
0x07,0x00,0x00,0x80,0x08,0x00,0x00,0x40,0x10,0x00,0x00,
0xe0,0x3f,0x00,0x00,0xf0,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0xff,0xff,0x1f,0x00,0x01,0x00,0x10,0x00,0xff,
0xff,0x1f,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valigna_width 32
#define valigna_height 32
static unsigned char valigna_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0xff,0x03,0x00,0x40,0x00,0x02,0x00,0x40,0x00,
0x02,0x00,0x40,0x00,0x02,0x00,0x40,0x00,0x02,0x00,0x40,
0x00,0x02,0x00,0x40,0x00,0x02,0x00,0x40,0x00,0x02,0x00,
0x40,0x00,0x02,0x00,0xc0,0xff,0x03,0x00,0x00,0x02,0x00,
0x00,0x00,0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x05,
0x00,0x00,0x80,0x08,0x00,0x00,0x80,0x08,0x00,0x00,0x40,
0x10,0x00,0x00,0x40,0x10,0x00,0x00,0xe0,0x3f,0x00,0x00,
0x00,0xfe,0xff,0x3f,0x00,0x02,0x00,0x20,0x00,0x02,0x00,
0x20,0x00,0x02,0x00,0x20,0x00,0xfe,0xff,0x3f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define any_width 32
#define any_height 32
static unsigned char any_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x1f,0x08,0x00,
0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,
0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,
0x08,0x21,0x12,0x11,0x88,0x22,0x12,0x11,0x48,0x64,0xa2,
0x10,0x48,0x64,0xa2,0x10,0x48,0xa4,0x42,0x10,0xc8,0xa7,
0x42,0x10,0x48,0x24,0x43,0x10,0x48,0x24,0x43,0x10,0x48,
0x24,0x42,0x10,0x48,0x24,0x42,0x10,0x08,0x00,0x00,0x10,
0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,
0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0xf8,0xff,
0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define none_width 32
#define none_height 32
static unsigned char none_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x1f,0x08,0x00,
0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,
0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,
0x28,0x32,0xd1,0x17,0x28,0x4a,0x51,0x10,0x68,0x4a,0x53,
0x10,0x68,0x4a,0x53,0x10,0xa8,0x4a,0xd5,0x11,0xa8,0x4a,
0x55,0x10,0x28,0x4b,0x59,0x10,0x28,0x4b,0x59,0x10,0x28,
0x4a,0x51,0x10,0x28,0x32,0xd1,0x17,0x08,0x00,0x00,0x10,
0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,
0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0xf8,0xff,
0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define fill_width 32
#define fill_height 32
static unsigned char fill_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,
0x03,0x00,0x00,0xac,0x06,0x00,0x00,0x54,0x0d,0x00,0x00,
0xae,0x1a,0x00,0x00,0x56,0x35,0x00,0x00,0xab,0x6a,0x00,
0x00,0x55,0xd5,0x00,0x00,0xab,0xaa,0x01,0x00,0x55,0x55,
0x01,0x00,0xab,0xaa,0x01,0x80,0x55,0x55,0x01,0x80,0xaa,
0xaa,0x01,0x80,0x55,0x55,0x03,0x80,0xaa,0xaa,0x02,0x80,
0x55,0x55,0x03,0x00,0xab,0xaa,0x02,0x00,0x5e,0x55,0x03,
0x00,0xb0,0xaa,0x02,0x00,0x60,0x55,0x03,0x00,0xc0,0xaa,
0x02,0x00,0x40,0x55,0x01,0x00,0x80,0xff,0x01,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define blank_width 32
#define blank_height 32
static unsigned char blank_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textL_width 32
#define textL_height 32
static unsigned char	textL_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textC_width 32
#define textC_height 32
static unsigned char	textC_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0x07,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textR_width 32
#define textR_height 32
static unsigned char	textR_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x80,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x1f,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0xff,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfc,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define noarrows_width 32
#define noarrows_height 32
static unsigned char noarrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define farrows_width 32
#define farrows_height 32
static unsigned char farrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x80,
0x03,0x00,0x00,0x80,0x0f,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x80,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define barrows_width 32
#define barrows_height 32
static unsigned char barrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0xe0,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0xf8,0x00,
0x00,0x00,0xe0,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define fbarrows_width 32
#define fbarrows_height 32
static unsigned char fbarrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0xe0,0x00,0x80,
0x03,0xf8,0x00,0x80,0x0f,0xfc,0xff,0xff,0x1f,0xf8,0x00,
0x80,0x0f,0xe0,0x00,0x80,0x03,0x80,0x00,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};


/* Define structs for icons with two size variations */
icon_struct	regpoly_ic;
icon_struct	addpt_ic;
icon_struct	align_ic;
icon_struct	arc_ic;
icon_struct	autoarrow_ic;
icon_struct	box_ic;
icon_struct	arc_box_ic;
icon_struct	cirrad_ic;
icon_struct	cirdia_ic;
icon_struct	c_spl_ic;
icon_struct	intspl_ic;
icon_struct	c_intspl_ic;
icon_struct	copy_ic;
icon_struct	glue_ic;
icon_struct	break_ic;
icon_struct	open_comp_ic;
icon_struct	join_split_ic;
icon_struct	chop_ic;
icon_struct	deletept_ic;
icon_struct	ellrad_ic;
icon_struct	elldia_ic;
icon_struct	flip_x_ic;
icon_struct	flip_y_ic;
icon_struct	line_ic;
icon_struct	library_ic;
icon_struct	move_ic;
icon_struct	movept_ic;
icon_struct	polygon_ic;
icon_struct	delete_ic;
icon_struct	rotCCW_ic;
icon_struct	scale_ic;
icon_struct	convert_ic;
icon_struct	spl_ic;
icon_struct	text_ic;
icon_struct	picobj_ic;
icon_struct	rotCW_ic;
icon_struct	update_ic;
icon_struct	edit_ic;
icon_struct	tangent_ic;
icon_struct	anglemeas_ic;
icon_struct	lenmeas_ic;
icon_struct	areameas_ic;



void populate_icons_big()
{
	icon_struct	regpoly_ic_ = { regpoly_width_big, regpoly_height_big, (char*)regpoly_bits_big };
	icon_struct	addpt_ic_ = { addpt_width_big, addpt_height_big, (char*)addpt_bits_big };
	icon_struct	align_ic_ = { align_width_big, align_height_big, (char*)align_bits_big };
	icon_struct	arc_ic_ = { arc_width_big, arc_height_big, (char*)arc_bits_big };
	icon_struct	autoarrow_ic_ = { autoarrow_width_big, autoarrow_height_big, (char*)autoarrow_bits_big };
	icon_struct	box_ic_ = { box_width_big, box_height_big, (char*)box_bits_big };
	icon_struct	arc_box_ic_ = { arc_box_width_big, arc_box_height_big, (char*)arc_box_bits_big };
	icon_struct	cirrad_ic_ = { cirrad_width_big, cirrad_height_big, (char*)cirrad_bits_big };
	icon_struct	cirdia_ic_ = { cirdia_width_big, cirdia_height_big, (char*)cirdia_bits_big };
	icon_struct	c_spl_ic_ = { c_spl_width_big, c_spl_height_big, (char*)c_spl_bits_big };
	icon_struct	intspl_ic_ = { intspl_width_big, intspl_height_big, (char*)intspl_bits_big };
	icon_struct	c_intspl_ic_ = { c_intspl_width_big, c_intspl_height_big, (char*)c_intspl_bits_big };
	icon_struct	copy_ic_ = { copy_width_big, copy_height_big, (char*)copy_bits_big };
	icon_struct	glue_ic_ = { glue_width_big, glue_height_big, (char*)glue_bits_big };
	icon_struct	break_ic_ = { break_width_big, break_height_big, (char*)break_bits_big };
	icon_struct	open_comp_ic_ = { open_comp_width_big, open_comp_height_big, (char*)open_comp_bits_big };
	icon_struct	join_split_ic_ = { join_split_width_big, join_split_height_big, (char*)join_split_bits_big };
	icon_struct	chop_ic_ = { chop_width_big, chop_height_big, (char*)chop_bits_big };
	icon_struct	deletept_ic_ = { deletept_width_big, deletept_height_big, (char*)deletept_bits_big };
	icon_struct	ellrad_ic_ = { ellrad_width_big, ellrad_height_big, (char*)ellrad_bits_big };
	icon_struct	elldia_ic_ = { elldia_width_big, elldia_height_big, (char*)elldia_bits_big };
	icon_struct	flip_x_ic_ = { flip_x_width_big, flip_x_height_big, (char*)flip_x_bits_big };
	icon_struct	flip_y_ic_ = { flip_y_width_big, flip_y_height_big, (char*)flip_y_bits_big };
	icon_struct	line_ic_ = { line_width_big, line_height_big, (char*)line_bits_big };
	icon_struct	library_ic_ = {library_width_big, library_height_big, (char*)library_bits_big };
	icon_struct	move_ic_ = { move_width_big, move_height_big, (char*)move_bits_big };
	icon_struct	movept_ic_ = { movept_width_big, movept_height_big, (char*)movept_bits_big };
	icon_struct	polygon_ic_ = { polygon_width_big, polygon_height_big, (char*)polygon_bits_big };
	icon_struct	delete_ic_ = { delete_width_big, delete_height_big, (char*)delete_bits_big };
	icon_struct	rotCCW_ic_ = { rotCCW_width_big, rotCCW_height_big, (char*)rotCCW_bits_big };
	icon_struct	scale_ic_ = { scale_width_big, scale_height_big, (char*)scale_bits_big };
	icon_struct	convert_ic_ = { convert_width_big, convert_height_big, (char*)convert_bits_big };
	icon_struct	spl_ic_ = { spl_width_big, spl_height_big, (char*)spl_bits_big };
	icon_struct	text_ic_ = { text_width_big, text_height_big, (char*)text_bits_big };
	icon_struct	picobj_ic_ = { picobj_width_big, picobj_height_big, (char*)picobj_bits_big };
	icon_struct	rotCW_ic_ = { rotCW_width_big, rotCW_height_big, (char*)rotCW_bits_big };
	icon_struct	update_ic_ = { update_width_big, update_height_big, (char*)update_bits_big };
	icon_struct	edit_ic_ = { edit_width_big, edit_height_big, (char*)edit_bits_big };
	icon_struct	tangent_ic_ = { tangent_width_big, tangent_height_big, (char*)tangent_bits_big };
	icon_struct	anglemeas_ic_ = { anglemeas_width_big, anglemeas_height_big, (char*)anglemeas_bits_big };
	icon_struct	lenmeas_ic_ = { lenmeas_width_big, lenmeas_height_big, (char*)lenmeas_bits_big };
	icon_struct	areameas_ic_ = { areameas_width_big, areameas_height_big, (char*)areameas_bits_big };
	regpoly_ic = regpoly_ic_;
	addpt_ic = addpt_ic_;
	align_ic = align_ic_;
	arc_ic = arc_ic_;
	autoarrow_ic = autoarrow_ic_;
	box_ic = box_ic_;
	arc_box_ic = arc_box_ic_;
	cirrad_ic = cirrad_ic_;
	cirdia_ic = cirdia_ic_;
	c_spl_ic = c_spl_ic_;
	intspl_ic = intspl_ic_;
	c_intspl_ic = c_intspl_ic_;
	copy_ic = copy_ic_;
	glue_ic = glue_ic_;
	break_ic = break_ic_;
	open_comp_ic = open_comp_ic_;
	join_split_ic = join_split_ic_;
	chop_ic = chop_ic_;
	deletept_ic = deletept_ic_;
	ellrad_ic = ellrad_ic_;
	elldia_ic = elldia_ic_;
	flip_x_ic = flip_x_ic_;
	flip_y_ic = flip_y_ic_;
	line_ic = line_ic_;
	library_ic = library_ic_;
	move_ic = move_ic_;
	movept_ic = movept_ic_;
	polygon_ic = polygon_ic_;
	delete_ic = delete_ic_;
	rotCCW_ic = rotCCW_ic_;
	scale_ic = scale_ic_;
	convert_ic = convert_ic_;
	spl_ic = spl_ic_;
	text_ic = text_ic_;
	picobj_ic = picobj_ic_;
	rotCW_ic = rotCW_ic_;
	update_ic = update_ic_;
	edit_ic = edit_ic_;
	tangent_ic = tangent_ic_;
	anglemeas_ic = anglemeas_ic_;
	lenmeas_ic = lenmeas_ic_;
	areameas_ic = areameas_ic_;
}


void populate_icons_small()
{
	icon_struct	regpoly_ic_ = { regpoly_width_small, regpoly_height_small, (char*)regpoly_bits_small };
	icon_struct	addpt_ic_ = { addpt_width_small, addpt_height_small, (char*)addpt_bits_small };
	icon_struct	align_ic_ = { align_width_small, align_height_small, (char*)align_bits_small };
	icon_struct	arc_ic_ = { arc_width_small, arc_height_small, (char*)arc_bits_small };
	icon_struct	autoarrow_ic_ = { autoarrow_width_small, autoarrow_height_small, (char*)autoarrow_bits_small };
	icon_struct	box_ic_ = { box_width_small, box_height_small, (char*)box_bits_small };
	icon_struct	arc_box_ic_ = { arc_box_width_small, arc_box_height_small, (char*)arc_box_bits_small };
	icon_struct	cirrad_ic_ = { cirrad_width_small, cirrad_height_small, (char*)cirrad_bits_small };
	icon_struct	cirdia_ic_ = { cirdia_width_small, cirdia_height_small, (char*)cirdia_bits_small };
	icon_struct	c_spl_ic_ = { c_spl_width_small, c_spl_height_small, (char*)c_spl_bits_small };
	icon_struct	intspl_ic_ = { intspl_width_small, intspl_height_small, (char*)intspl_bits_small };
	icon_struct	c_intspl_ic_ = { c_intspl_width_small, c_intspl_height_small, (char*)c_intspl_bits_small };
	icon_struct	copy_ic_ = { copy_width_small, copy_height_small, (char*)copy_bits_small };
	icon_struct	glue_ic_ = { glue_width_small, glue_height_small, (char*)glue_bits_small };
	icon_struct	break_ic_ = { break_width_small, break_height_small, (char*)break_bits_small };
	icon_struct	open_comp_ic_ = { open_comp_width_small, open_comp_height_small, (char*)open_comp_bits_small };
	icon_struct	join_split_ic_ = { join_split_width_small, join_split_height_small, (char*)join_split_bits_small };
	icon_struct	chop_ic_ = { chop_width_small, chop_height_small, (char*)chop_bits_small };
	icon_struct	deletept_ic_ = { deletept_width_small, deletept_height_small, (char*)deletept_bits_small };
	icon_struct	ellrad_ic_ = { ellrad_width_small, ellrad_height_small, (char*)ellrad_bits_small };
	icon_struct	elldia_ic_ = { elldia_width_small, elldia_height_small, (char*)elldia_bits_small };
	icon_struct	flip_x_ic_ = { flip_x_width_small, flip_x_height_small, (char*)flip_x_bits_small };
	icon_struct	flip_y_ic_ = { flip_y_width_small, flip_y_height_small, (char*)flip_y_bits_small };
	icon_struct	line_ic_ = { line_width_small, line_height_small, (char*)line_bits_small };
	icon_struct	library_ic_ = {library_width_small, library_height_small, (char*)library_bits_small };
	icon_struct	move_ic_ = { move_width_small, move_height_small, (char*)move_bits_small };
	icon_struct	movept_ic_ = { movept_width_small, movept_height_small, (char*)movept_bits_small };
	icon_struct	polygon_ic_ = { polygon_width_small, polygon_height_small, (char*)polygon_bits_small };
	icon_struct	delete_ic_ = { delete_width_small, delete_height_small, (char*)delete_bits_small };
	icon_struct	rotCCW_ic_ = { rotCCW_width_small, rotCCW_height_small, (char*)rotCCW_bits_small };
	icon_struct	scale_ic_ = { scale_width_small, scale_height_small, (char*)scale_bits_small };
	icon_struct	convert_ic_ = { convert_width_small, convert_height_small, (char*)convert_bits_small };
	icon_struct	spl_ic_ = { spl_width_small, spl_height_small, (char*)spl_bits_small };
	icon_struct	text_ic_ = { text_width_small, text_height_small, (char*)text_bits_small };
	icon_struct	picobj_ic_ = { picobj_width_small, picobj_height_small, (char*)picobj_bits_small };
	icon_struct	rotCW_ic_ = { rotCW_width_small, rotCW_height_small, (char*)rotCW_bits_small };
	icon_struct	update_ic_ = { update_width_small, update_height_small, (char*)update_bits_small };
	icon_struct	edit_ic_ = { edit_width_small, edit_height_small, (char*)edit_bits_small };
	icon_struct	tangent_ic_ = { tangent_width_small, tangent_height_small, (char*)tangent_bits_small };
	icon_struct	anglemeas_ic_ = { anglemeas_width_small, anglemeas_height_small, (char*)anglemeas_bits_small };
	icon_struct	lenmeas_ic_ = { lenmeas_width_small, lenmeas_height_small, (char*)lenmeas_bits_small };
	icon_struct	areameas_ic_ = { areameas_width_small, areameas_height_small, (char*)areameas_bits_small };
	regpoly_ic = regpoly_ic_;
	addpt_ic = addpt_ic_;
	align_ic = align_ic_;
	arc_ic = arc_ic_;
	autoarrow_ic = autoarrow_ic_;
	box_ic = box_ic_;
	arc_box_ic = arc_box_ic_;
	cirrad_ic = cirrad_ic_;
	cirdia_ic = cirdia_ic_;
	c_spl_ic = c_spl_ic_;
	intspl_ic = intspl_ic_;
	c_intspl_ic = c_intspl_ic_;
	copy_ic = copy_ic_;
	glue_ic = glue_ic_;
	break_ic = break_ic_;
	open_comp_ic = open_comp_ic_;
	join_split_ic = join_split_ic_;
	chop_ic = chop_ic_;
	deletept_ic = deletept_ic_;
	ellrad_ic = ellrad_ic_;
	elldia_ic = elldia_ic_;
	flip_x_ic = flip_x_ic_;
	flip_y_ic = flip_y_ic_;
	line_ic = line_ic_;
	library_ic = library_ic_;
	move_ic = move_ic_;
	movept_ic = movept_ic_;
	polygon_ic = polygon_ic_;
	delete_ic = delete_ic_;
	rotCCW_ic = rotCCW_ic_;
	scale_ic = scale_ic_;
	convert_ic = convert_ic_;
	spl_ic = spl_ic_;
	text_ic = text_ic_;
	picobj_ic = picobj_ic_;
	rotCW_ic = rotCW_ic_;
	update_ic = update_ic_;
	edit_ic = edit_ic_;
	tangent_ic = tangent_ic_;
	anglemeas_ic = anglemeas_ic_;
	lenmeas_ic = lenmeas_ic_;
	areameas_ic = areameas_ic_;
}




/* create the data structures for them */

icon_struct	open_arc_ic = { open_arc_width, open_arc_height, 
				(char*)open_arc_bits };
icon_struct	pie_wedge_arc_ic = { pie_wedge_arc_width, pie_wedge_arc_height,
				     (char*)pie_wedge_arc_bits };
icon_struct	c_xspl_ic = { c_xspl_width, c_xspl_height,
				(char*)c_xspl_bits };
icon_struct	xspl_ic = { xspl_width, xspl_height,
				(char*)xspl_bits };
icon_struct	smartoff_ic = { smartoff_width, smartoff_height, 
				(char*)smartoff_bits };
icon_struct	smartmove_ic = { smartmove_width, smartmove_height, 
				 (char*)smartmove_bits };
icon_struct	smartslide_ic = { smartslide_width, smartslide_height, 
				  (char*)smartslide_bits };
icon_struct	joinmiter_ic = { joinmiter_width, joinmiter_height, 
				 (char*)joinmiter_bits };
icon_struct	joinround_ic = { joinround_width, joinround_height, 
				 (char*)joinround_bits };
icon_struct	joinbevel_ic = { joinbevel_width, joinbevel_height, 
				 (char*)joinbevel_bits };
icon_struct	capbutt_ic = { capbutt_width, capbutt_height,
				(char*)capbutt_bits };
icon_struct	capround_ic = { capround_width, capround_height, 
				(char*)capround_bits };
icon_struct	capproject_ic = { capproject_width, capproject_height, 
				  (char*)capproject_bits };
icon_struct	solidline_ic = { solidline_width, solidline_height, 
				 (char*)solidline_bits };
icon_struct	dashline_ic = { dashline_width, dashline_height, 
				(char*)dashline_bits };
icon_struct	dottedline_ic = { dottedline_width, dottedline_height, 
				  (char*)dottedline_bits };
icon_struct	dashdotline_ic = { dashdotline_width, dashdotline_height, 
				  (char*)dashdotline_bits };
icon_struct	dash2dotsline_ic = { dash2dotsline_width, dash2dotsline_height, 
				  (char*)dash2dotsline_bits };
icon_struct	dash3dotsline_ic = { dash3dotsline_width, dash3dotsline_height, 
				  (char*)dash3dotsline_bits };
icon_struct	grid1_ic = { grid1_width, grid1_height,
				(char*)grid1_bits };
icon_struct	grid2_ic = { grid2_width, grid2_height,
				(char*)grid2_bits };
icon_struct	grid3_ic = { grid3_width, grid3_height,
				(char*)grid3_bits };
icon_struct	grid4_ic = { grid4_width, grid4_height,
				(char*)grid4_bits };
icon_struct	grid_iso1_ic = { grid_iso1_width, grid_iso1_height,		// isometric grid
				(char*)grid_iso1_bits };
icon_struct	grid_iso2_ic = { grid_iso2_width, grid_iso2_height,
				(char*)grid_iso2_bits };
icon_struct	grid_iso3_ic = { grid_iso3_width, grid_iso3_height,
				(char*)grid_iso3_bits };
icon_struct	grid_iso4_ic = { grid_iso4_width, grid_iso4_height,
				(char*)grid_iso4_bits };
icon_struct	fine_grid_ic = { fine_grid_width, fine_grid_height, 
				 (char*)fine_grid_bits };
icon_struct	unconstrained_ic = { unconstrained_width, unconstrained_height,
				     (char*)unconstrained_bits };
icon_struct	latexline_ic = { latexline_width, latexline_height, 
				 (char*)latexline_bits };
icon_struct	latexarrow_ic = { latexarrow_width, latexarrow_height, 
				  (char*)latexarrow_bits };
icon_struct	mounthattan_ic = { mounthattan_width, mounthattan_height, 
				   (char*)mounthattan_bits };
icon_struct	manhattan_ic = { manhattan_width, manhattan_height, 
				 (char*)manhattan_bits };
icon_struct	mountain_ic = { mountain_width, mountain_height,
				(char*)mountain_bits };
icon_struct	halignl_ic = { halignl_width, halignl_height, 
			       (char*)halignl_bits };
icon_struct	halignr_ic = { halignr_width, halignr_height, 
			       (char*)halignr_bits };
icon_struct	halignc_ic = { halignc_width, halignc_height, 
			       (char*)halignc_bits };
icon_struct	haligndc_ic = { haligndc_width, haligndc_height, 
				(char*)haligndc_bits };
icon_struct	halignde_ic = { halignde_width, halignde_height, 
				(char*)halignde_bits };
icon_struct	haligna_ic = { haligna_width, haligna_height, 
			       (char*)haligna_bits };
icon_struct	valignt_ic = { valignt_width, valignt_height, 
			       (char*)valignt_bits };
icon_struct	valignb_ic = { valignb_width, valignb_height, 
			       (char*)valignb_bits };
icon_struct	valignc_ic = { valignc_width, valignc_height, 
			       (char*)valignc_bits };
icon_struct	valigndc_ic = { valigndc_width, valigndc_height, 
				(char*)valigndc_bits };
icon_struct	valignde_ic = { valignde_width, valignde_height, 
				(char*)valignde_bits };
icon_struct	valigna_ic = { valigna_width, valigna_height, 
			       (char*)valigna_bits };
icon_struct	any_ic = { any_width, any_height,
				(char*)any_bits };
icon_struct	none_ic = { none_width, none_height,
				(char*)none_bits };
icon_struct	fill_ic = { fill_width, fill_height,
				(char*)fill_bits };
icon_struct	blank_ic = { blank_width, blank_height,
				(char*)blank_bits };
icon_struct	textL_ic = { textL_width, textL_height,
				(char*)textL_bits };
icon_struct	textC_ic = { textC_width, textC_height,
				(char*)textC_bits };
icon_struct	textR_ic = { textR_width, textR_height,
				(char*)textR_bits };
icon_struct	noarrows_ic = { noarrows_width, noarrows_height, 
				(char*)noarrows_bits };
icon_struct	farrows_ic = { farrows_width, farrows_height, 
			       (char*)farrows_bits };
icon_struct	barrows_ic = { barrows_width, barrows_height, 
			       (char*)barrows_bits };
icon_struct	fbarrows_ic = { fbarrows_width, fbarrows_height, 
				(char*)fbarrows_bits };


/*************** misc icons *************/

#define printer_width 54
#define printer_height 28
static unsigned char printer_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0x0f,0x20,
0x00,0x00,0x00,0x00,0x00,0x08,0x20,0x00,0x00,0x00,0x00,
0x00,0x08,0x20,0x00,0x00,0x00,0x00,0x00,0x08,0xe0,0xff,
0xff,0xff,0xff,0xff,0x0f,0xa0,0x00,0x00,0x00,0x00,0x00,
0x08,0xa0,0x00,0x00,0xf8,0x03,0x00,0x08,0xa0,0x00,0x00,
0x08,0x02,0x00,0x08,0xa0,0x00,0x00,0xa8,0x02,0x00,0x04,
0xa0,0x00,0x00,0xf8,0x03,0x00,0x02,0xa0,0x00,0x00,0x00,
0x00,0x00,0x01,0xe0,0xff,0xff,0xff,0xff,0xff,0x00,0x80,
0x00,0x00,0x00,0x00,0x80,0x00,0xfc,0xf8,0xff,0xff,0xff,
0x9f,0x00,0x84,0x00,0x00,0x00,0x00,0x80,0x00,0x84,0xf8,
0xff,0xff,0xff,0x9f,0x00,0xfc,0x00,0x00,0x00,0x00,0x80,
0x00,0xe0,0xf8,0xff,0xff,0xff,0x9f,0x00,0xc0,0x00,0x00,
0x00,0x00,0x80,0x00,0x80,0xf8,0xff,0xff,0xff,0x9f,0x00,
0x00,0x01,0x00,0x00,0x00,0x80,0x00,0x00,0xfe,0xff,0xff,
0xff,0xff,0x00,0x00,0x7c,0x00,0x00,0x00,0x7c,0x00,0x00,
0x38,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define kbd_width 56
#define kbd_height 19
static unsigned char kbd_bits[] = {
0xef,0xbd,0xf7,0xde,0x7b,0xef,0xfd,0x29,0xa5,0x94,0x52,
0x4a,0x29,0x85,0x29,0xa5,0x94,0x52,0x4a,0x29,0x85,0xef,
0xbd,0xf7,0xde,0x7b,0xef,0xfd,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xbc,0xf7,0xde,0x7b,0xef,0xbd,0xf7,0xa4,0x94,
0x52,0x4a,0x29,0xa5,0x94,0xa4,0x94,0x52,0x4a,0x29,0xa5,
0x94,0xbc,0xf7,0xde,0x7b,0xef,0xbd,0x97,0x00,0x00,0x00,
0x00,0x00,0x00,0x90,0xf0,0xde,0x7b,0xef,0xbd,0xf7,0x9e,
0x90,0x52,0x4a,0x29,0xa5,0x94,0x82,0x90,0x52,0x4a,0x29,
0xa5,0x94,0x82,0xf0,0xde,0x7b,0xef,0xbd,0xf7,0xfe,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xef,0xbd,0xf7,0xde,
0x7b,0x7f,0x20,0x28,0xa5,0x94,0x52,0x4a,0x41,0x20,0x28,
0xa5,0x94,0x52,0x4a,0x41,0xe0,0xef,0xbd,0xf7,0xde,0x7b,
0x7f};

/* arrowhead bitmaps */

#define no_arrow_width 32
#define no_arrow_height 32
unsigned char no_arrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x04,
0x08,0x00,0x00,0x08,0x08,0x00,0x00,0x08,0x24,0x32,0xd1,0x13,
0x24,0x4a,0x51,0x10,0x62,0x4a,0x53,0x20,0x62,0x4a,0x53,0x20,
0xa2,0x4a,0xd5,0x21,0xa2,0x4a,0x55,0x20,0x22,0x4b,0x59,0x20,
0x22,0x4b,0x59,0x20,0x24,0x4a,0x51,0x10,0x24,0x32,0xd1,0x13,
0x08,0x00,0x00,0x08,0x08,0x00,0x00,0x08,0x10,0x00,0x00,0x04,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define arrow0_width 32
#define arrow0_height 32
unsigned char	arrow0_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x00,0x00,0xe0,0x01,0x00,0x00,0x00,0x1e,0x00,
0x00,0x00,0xe0,0x01,0xf0,0xff,0xff,0x0f,0x00,0x00,0xc0,0x03,
0x00,0x00,0x3c,0x00,0x00,0xc0,0x03,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow1o_width 32
#define arrow1o_height 32
unsigned char	arrow1o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x38,0x00,0x00,0x00,0xe8,0x03,0x00,0x00,0x08,0x3e,0x00,
0x00,0x08,0xe0,0x03,0xf8,0x0f,0x00,0x0f,0x00,0x08,0xf8,0x01,
0x00,0x08,0x1f,0x00,0x00,0xf8,0x01,0x00,0x00,0x18,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow1f_width 32
#define arrow1f_height 32
unsigned char	arrow1f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0xf8,0x1f,0x00,
0x00,0xf8,0xff,0x01,0xf8,0xff,0xff,0x0f,0x00,0xf8,0xff,0x03,
0x00,0xf8,0x3f,0x00,0x00,0xf8,0x03,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow2o_width 32
#define arrow2o_height 32
unsigned char	arrow2o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0x10,0x0f,0x00,0x00,0x20,0x70,0x00,
0x00,0x40,0x80,0x07,0xfc,0xff,0x00,0x1c,0x00,0x40,0x00,0x06,
0x00,0x20,0xe0,0x01,0x00,0x10,0x1e,0x00,0x00,0xe8,0x01,0x00,
0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow2f_width 32
#define arrow2f_height 32
unsigned char	arrow2f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0xf0,0x0f,0x00,0x00,0xe0,0x7f,0x00,
0x00,0xc0,0xff,0x07,0xfc,0xff,0xff,0x1f,0x00,0xc0,0xff,0x07,
0x00,0xe0,0xff,0x01,0x00,0xf0,0x1f,0x00,0x00,0xf8,0x01,0x00,
0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow3o_width 32
#define arrow3o_height 32
unsigned char	arrow3o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0x40,0x0e,0x00,0x00,0x40,0xf0,0x00,
0x00,0x20,0x00,0x07,0xf8,0x1f,0x00,0x18,0x00,0x20,0x00,0x07,
0x00,0x40,0xf0,0x00,0x00,0x40,0x0e,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow3f_width 32
#define arrow3f_height 32
unsigned char	arrow3f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0xc0,0x0f,0x00,0x00,0xc0,0xff,0x00,
0x00,0xe0,0xff,0x07,0xf8,0xff,0xff,0x1f,0x00,0xe0,0xff,0x07,
0x00,0xc0,0xff,0x00,0x00,0xc0,0x0f,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow4o_width 32
#define arrow4o_height 32
unsigned char	arrow4o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x80, 0x83, 0x03,
0x00, 0x60, 0x00, 0x0c, 0xf8, 0x1f, 0x00, 0x10, 0x00, 0x60, 0x00, 0x0c,
0x00, 0x80, 0x83, 0x03, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow4f_width 32
#define arrow4f_height 32
unsigned char	arrow4f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x80, 0xff, 0x03,
0x00, 0xe0, 0xff, 0x0f, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0x80, 0xff, 0x03, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow5o_width 32
#define arrow5o_height 32
unsigned char	arrow5o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x83, 0x01, 0x00, 0x80, 0x00, 0x02,
0x00, 0x40, 0x00, 0x04, 0x00, 0x40, 0x00, 0x04, 0x00, 0x20, 0x00, 0x08,
0x00, 0x20, 0x00, 0x08, 0xf8, 0x1f, 0x00, 0x10, 0x00, 0x20, 0x00, 0x08,
0x00, 0x20, 0x00, 0x08, 0x00, 0x40, 0x00, 0x04, 0x00, 0x40, 0x00, 0x04,
0x00, 0x80, 0x00, 0x02, 0x00, 0x00, 0x83, 0x01, 0x00, 0x00, 0x6c, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow5f_width 32
#define arrow5f_height 32
unsigned char	arrow5f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0xff, 0x01, 0x00, 0x80, 0xff, 0x03,
0x00, 0xc0, 0xff, 0x07, 0x00, 0xc0, 0xff, 0x07, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0xe0, 0xff, 0x0f, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0xe0, 0xff, 0x0f, 0x00, 0xc0, 0xff, 0x07, 0x00, 0xc0, 0xff, 0x07,
0x00, 0x80, 0xff, 0x03, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0x7c, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow6o_width 32
#define arrow6o_height 32
unsigned char arrow6o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x07, 0x00,
0x00, 0x80, 0x01, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0xc0, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00,
0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow6f_width 32
#define arrow6f_height 32
unsigned char arrow6f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3f, 0x00,
0x00, 0x80, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0xc0, 0x3f, 0x00,
0x00, 0xc0, 0x3f, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0xc0, 0x3f, 0x00,
0x00, 0xc0, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00,
0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow7o_width 32
#define arrow7o_height 32
unsigned char arrow7o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
0x00, 0x40, 0x40, 0x00, 0xf8, 0x7f, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define arrow7f_width 32
#define arrow7f_height 32
unsigned char arrow7f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0xf8, 0xff, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow8o_width 32
#define arrow8o_height 32
unsigned char arrow8o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x43, 0x00,
0x00, 0xc0, 0x40, 0x00, 0xf8, 0x3f, 0x40, 0x00, 0x00, 0xc0, 0x40, 0x00,
0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x70, 0x00,
0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow8f_width 32
#define arrow8f_height 32
unsigned char arrow8f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0xf8, 0xff, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x70, 0x00,
0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow9a_width 32
#define arrow9a_height 32
unsigned char arrow9a_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
  0x00, 0xf8, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0xe0, 0x7f, 0x00,
  0x00, 0xc0, 0xff, 0x07, 0xfc, 0xff, 0xff, 0x1f, 0x00, 0x40, 0x00, 0x06,
  0x00, 0x20, 0xe0, 0x01, 0x00, 0x10, 0x1e, 0x00, 0x00, 0xe8, 0x01, 0x00,
  0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow9b_width 32
#define arrow9b_height 32
unsigned char arrow9b_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
  0x00, 0xf8, 0x00, 0x00, 0x00, 0x10, 0x0f, 0x00, 0x00, 0x20, 0x70, 0x00,
  0x00, 0x40, 0x80, 0x07, 0xfc, 0xff, 0xff, 0x1f, 0x00, 0xc0, 0xff, 0x07,
  0x00, 0xe0, 0xff, 0x01, 0x00, 0xf0, 0x1f, 0x00, 0x00, 0xf8, 0x01, 0x00,
  0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow10o_width 32
#define arrow10o_height 32
unsigned char arrow10o_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x18,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0x08,0x1f,0x00,0x00,0x08,0xf0,0x01,
 0xf8,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow10f_width 32
#define arrow10f_height 32
unsigned char arrow10f_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
  0x00, 0xf8, 0x01, 0x00, 0x00, 0xf8, 0x1f, 0x00, 0x00, 0xf8, 0xff, 0x01,
  0xf8, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow11o_width 32
#define arrow11o_height 32
unsigned char arrow11o_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,
 0xe8,0x01,0x00,0x00,0x10,0x1e,0x00,0x00,0x20,0xe0,0x01,0x00,0x40,0x00,0x06,
 0xfc,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow11f_width 32
#define arrow11f_height 32
unsigned char arrow11f_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
  0x00, 0xf8, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0xe0, 0x7f, 0x00,
  0x00, 0xc0, 0xff, 0x07, 0xfc, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow12o_width 32
#define arrow12o_height 32
unsigned char arrow12o_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x03,0x00,0x00,0x80,0x1c,0x00,0x00,0x80,0xe0,0x01,0x00,0x40,0x00,0x0e,
 0xf0,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow12f_width 32
#define arrow12f_height 32
unsigned char arrow12f_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x1f, 0x00, 0x00, 0x80, 0xff, 0x01,
  0x00, 0xc0, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow13a_width 32
#define arrow13a_height 32
unsigned char arrow13a_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00,
0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00,
0x00, 0x80, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00,
0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow13b_width 32
#define arrow13b_height 32
unsigned char arrow13b_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow14a_width 32
#define arrow14a_height 32
unsigned char arrow14a_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow14b_width 32
#define arrow14b_height 32
unsigned char arrow14b_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
icon_struct	no_arrow_ic = { no_arrow_width, no_arrow_height, 
			      (char*)no_arrow_bits };
icon_struct	arrow0_ic = { arrow0_width, arrow0_height, 
			      (char*)arrow0_bits };
icon_struct	arrow1o_ic = { arrow1o_width, arrow1o_height, 
			      (char*)arrow1o_bits };
icon_struct	arrow1f_ic = { arrow1f_width, arrow1f_height, 
			      (char*)arrow1f_bits };
icon_struct	arrow2o_ic = { arrow2o_width, arrow2o_height, 
			      (char*)arrow2o_bits };
icon_struct	arrow2f_ic = { arrow2f_width, arrow2f_height, 
			      (char*)arrow2f_bits };
icon_struct	arrow3o_ic = { arrow3o_width, arrow3o_height, 
			      (char*)arrow3o_bits };
icon_struct	arrow3f_ic = { arrow3f_width, arrow3f_height, 
			      (char*)arrow3f_bits };
icon_struct	arrow4o_ic = { arrow4o_width, arrow4o_height, 
			      (char*)arrow4o_bits };
icon_struct	arrow4f_ic = { arrow4f_width, arrow4f_height, 
			      (char*)arrow4f_bits };
icon_struct	arrow5o_ic = { arrow5o_width, arrow5o_height, 
			      (char*)arrow5o_bits };
icon_struct	arrow5f_ic = { arrow5f_width, arrow5f_height, 
			      (char*)arrow5f_bits };
icon_struct	arrow6o_ic = { arrow6o_width, arrow6o_height, 
			      (char*)arrow6o_bits };
icon_struct	arrow6f_ic = { arrow6f_width, arrow6f_height, 
			      (char*)arrow6f_bits };
icon_struct	arrow7o_ic = { arrow7o_width, arrow7o_height, 
			      (char*)arrow7o_bits };
icon_struct	arrow7f_ic = { arrow7f_width, arrow7f_height, 
			      (char*)arrow7f_bits };
icon_struct	arrow8o_ic = { arrow8o_width, arrow8o_height, 
			      (char*)arrow8o_bits };
icon_struct	arrow8f_ic = { arrow8f_width, arrow8f_height, 
			      (char*)arrow8f_bits };
icon_struct	arrow9a_ic = { arrow9a_width, arrow9a_height, 
			      (char*)arrow9a_bits };
icon_struct	arrow9b_ic = { arrow9b_width, arrow9b_height, 
			      (char*)arrow9b_bits };
icon_struct	arrow10o_ic = { arrow10o_width, arrow10o_height, 
			      (char*)arrow10o_bits };
icon_struct	arrow10f_ic = { arrow10f_width, arrow10f_height, 
			      (char*)arrow10f_bits };
icon_struct	arrow11o_ic = { arrow11o_width, arrow11o_height, 
			      (char*)arrow11o_bits };
icon_struct	arrow11f_ic = { arrow11f_width, arrow11f_height, 
			      (char*)arrow11f_bits };
icon_struct	arrow12o_ic = { arrow12o_width, arrow12o_height, 
			      (char*)arrow12o_bits };
icon_struct	arrow12f_ic = { arrow12f_width, arrow12f_height, 
			      (char*)arrow12f_bits };
icon_struct	arrow13a_ic = { arrow13a_width, arrow13a_height, 
			      (char*)arrow13a_bits };
icon_struct	arrow13b_ic = { arrow13b_width, arrow13b_height, 
			      (char*)arrow13b_bits };
icon_struct	arrow14a_ic = { arrow14a_width, arrow14a_height, 
			      (char*)arrow14a_bits };
icon_struct	arrow14b_ic = { arrow14b_width, arrow14b_height, 
			      (char*)arrow14b_bits };

icon_struct	printer_ic = { printer_width, printer_height, 
			       (char*)printer_bits };
icon_struct	kbd_ic = { kbd_width, kbd_height,
				(char*)kbd_bits };

/* The following XBM image is used for the icon on a monochrome display */

/* new icon from Marc-Aurle Darche */

#define fig_width 64
#define fig_height 64
static char fig_bits[] = {
 0x55,0x55,0x55,0x55,0x55,0xb5,0x6d,0xdb,0x55,0x55,0xa9,0xa4,0x54,0xd5,0xb6,
 0xb5,0x2a,0x95,0x4a,0x95,0xd2,0x6a,0xdb,0xde,0xa9,0x52,0xaa,0x52,0xf5,0xab,
 0x6d,0x6b,0x55,0x55,0x49,0xaa,0xea,0xd7,0xaa,0xd5,0xaa,0x4a,0x25,0x49,0x6a,
 0x2b,0xb7,0xbe,0xa5,0x2a,0x55,0xa5,0xd2,0xdf,0xda,0xd5,0x9a,0x54,0x29,0x95,
 0xd4,0x5f,0xad,0xba,0xa5,0x52,0xa5,0x52,0xea,0xfb,0x76,0xd7,0x55,0x95,0x14,
 0x49,0xe5,0xef,0xda,0xba,0xaa,0xaa,0xaa,0x54,0xf2,0xff,0x6b,0xdb,0xaa,0x24,
 0x49,0x25,0xb5,0xef,0xad,0xad,0x95,0xaa,0x24,0x92,0xf4,0xfe,0xdb,0xf6,0x54,
 0x55,0x55,0xa9,0xfa,0xff,0x6f,0xad,0xab,0x4a,0x55,0x25,0xf9,0x6f,0xbf,0xbb,
 0x54,0x02,0x00,0x95,0xac,0xfb,0xfd,0xd6,0x4a,0x1f,0x50,0x19,0x80,0x5e,0xef,
 0xbb,0x55,0x1f,0xe0,0x7a,0x50,0xeb,0xfa,0xdd,0xaa,0x3e,0xe0,0x3d,0xf8,0x5f,
 0xbf,0xb7,0x55,0x5f,0xe0,0x3c,0xfc,0xea,0xea,0xdf,0x4a,0x7f,0x40,0x1d,0xff,
 0x5d,0xbf,0xbf,0xaa,0x7e,0xc2,0x4e,0xff,0xeb,0xfa,0xdf,0x55,0xf5,0x40,0x84,
 0x7f,0x5f,0xef,0x7e,0xaa,0xf2,0x80,0xe5,0xdf,0xb7,0xfb,0xff,0x55,0x6a,0x81,
 0xf2,0xfb,0xed,0xbe,0xbf,0xaa,0xea,0x89,0xf0,0x7f,0xbf,0xf7,0xff,0xa5,0xea,
 0x01,0xfc,0xff,0xfd,0xde,0x7f,0x54,0xd5,0x03,0xfe,0xff,0xef,0xff,0xff,0x95,
 0xa4,0x03,0xf6,0xef,0xbf,0xff,0xff,0x55,0xd5,0x15,0xf6,0xbf,0xf7,0xfb,0x7f,
 0x55,0x95,0x43,0xf4,0xff,0xff,0xbf,0xff,0xaa,0xaa,0x07,0xea,0xff,0xff,0xff,
 0xff,0xaa,0x54,0x03,0xf4,0xff,0xee,0xfe,0xff,0xaa,0x52,0x11,0xec,0xff,0xff,
 0xff,0x7f,0xaa,0xca,0x18,0xe8,0xff,0xff,0xff,0xff,0x55,0x55,0x1c,0xe8,0xff,
 0xff,0xff,0xbf,0xaa,0x6a,0x2e,0xf0,0xff,0xff,0xff,0xff,0x52,0x15,0xbf,0xd0,
 0xff,0xff,0xff,0x5f,0xaa,0x9a,0x3f,0xaa,0x1f,0x9c,0xff,0xff,0x95,0xc6,0x7b,
 0xa0,0x07,0x04,0xff,0xaf,0xaa,0xd2,0x7a,0x69,0x07,0x00,0xfe,0xbf,0x5b,0xe3,
 0xba,0x40,0x03,0x08,0xff,0xef,0xd5,0x78,0xf5,0x64,0x45,0x0f,0xff,0xd7,0x6d,
 0x74,0x75,0x89,0xe1,0xff,0x7f,0xfa,0xb6,0x5c,0xf5,0xa1,0x02,0x00,0x0f,0x80,
 0x0b,0xe8,0x5a,0x04,0x05,0x81,0x0f,0x80,0x42,0xa2,0x8e,0x50,0x0c,0x80,0x03,
 0x81,0xbd,0xbd,0x7d,0xbf,0xd7,0x96,0xa3,0xe9,0xff,0xff,0xfe,0xff,0xe2,0xc3,
 0xc2,0xe0,0xff,0x77,0xfd,0xff,0xe9,0x83,0x83,0xe8,0x55,0xad,0x56,0x55,0x51,
 0x53,0x4b,0xb0,0xaa,0xb5,0xab,0xea,0xe0,0xc2,0x07,0xf8,0xdd,0x56,0x75,0xbf,
 0x52,0xcb,0x1e,0xfa,0x6b,0xbb,0xad,0xd5,0xe0,0x41,0x8e,0xdf,0xad,0xd5,0xda,
 0xea,0x54,0x25,0x06,0xf8,0xb6,0x6e,0x6f,0xbf,0xf0,0x03,0x01,0xd0,0xdb,0x55,
 0xb5,0xd5,0x54,0x89,0x60,0xe0,0xad,0xba,0x5b,0x6d,0xf0,0xeb,0xa1,0xc1,0xea,
 0x6e,0xed,0x0b,0x5d,0xbf,0xe9,0xca,0xbf,0xd5,0xb6,0x06,0xb8,0xfd,0x01,0xe0,
 0x52,0xbb,0xdb,0x05,0xde,0x77,0x13,0xf0,0xef,0xd6,0xb6,0x2e,0x77,0xff,0x85,
 0xb8,0x5a,0x7b,0xdb,0xab,0xef,0xdd,0x5f,0xff,0xed,0xad,0x6d,0xfd,0xfb,0xf7,
 0xff,0xef};

/* for the whole figure edit panel */

icon_struct	figure_ic = { fig_width, fig_height, (char*) fig_bits };

#ifdef USE_XPM_ICON

/* XPM version of xfig icon - first in full color for TrueColor displays,
   then in reduced color for 256 color-mapped displays */

char * fig_full_c_icon_X[] = {
/* width height num_colors chars_per_pixel */
"    64    64      253            2",
/* colors */
".. c #050804", ".# c #138820", ".a c #793d26", ".b c #ac8664", ".c c #084808", ".d c #74622c",
".e c #e0c68c", ".f c #d0895b", ".g c #3f180a", ".h c #ae643e", ".i c #47511c", ".j c #9c522e",
".k c #ccaa74", ".l c #066813", ".m c #785030", ".n c #412f27", ".o c #b17859", ".p c #eda870",
".q c #117611", ".r c #072804", ".s c #84767c", ".t c #f9e6a4", ".u c #60301f", ".v c #925132",
".w c #ed9967", ".x c #748634", ".y c #1b9c2c", ".z c #07580d", ".A c #9a6350", ".B c #eac8c4",
".C c #cc986c", ".D c #c5774e", ".E c #efb97f", ".F c #b09ea8", ".G c #603b30", ".H c #8c4930",
".I c #342818", ".J c #bb8863", ".K c #b27052", ".L c #7a4730", ".M c #1e6818", ".N c #073707",
".O c #9b6f4f", ".P c #248822", ".Q c #24791f", ".R c #9e5834", ".S c #ae786a", ".T c #8e5b3d",
".U c #1f5717", ".V c #d4a6a0", ".W c #805c3e", ".X c #43251e", ".Y c #b98b84", ".Z c #260f05",
".0 c #eca99d", ".1 c #10801e", ".2 c #e9d9df", ".3 c #d1998e", ".4 c #ae5e39", ".5 c #0a7015",
".6 c #613247", ".7 c #086011", ".8 c #074008", ".9 c #14480e", "#. c #e9dd9c", "## c #cd8d7f",
"#a c #623c3f", "#b c #a05853", "#c c #1c9428", "#d c #924f52", "#e c #279b29", "#f c #f1b7ad",
"#g c #4c2413", "#h c #996960", "#i c #753e49", "#j c #ac6554", "#k c #74514f", "#l c #bd704a",
"#m c #5e4732", "#n c #b27e5b", "#o c #7c4745", "#p c #d5babe", "#q c #766667", "#r c #522f28",
"#s c #f8c9c3", "#t c #c4966c", "#u c #041804", "#v c #fae8e6", "#w c #a4634b", "#x c #ca8055",
"#y c #1c7f21", "#z c #1c892a", "#A c #0a500f", "#B c #d29062", "#C c #f3af77", "#D c #a27759",
"#E c #6c3521", "#F c #6c3c2f", "#G c #c48a60", "#H c #997169", "#I c #ae8069", "#J c #dd9d90",
"#K c #fbc88b", "#L c #146818", "#M c #84503c", "#N c #082f05", "#O c #603629", "#P c #de9966",
"#Q c #14380a", "#R c #259425", "#S c #f0b0a5", "#T c #146016", "#U c #25a430", "#V c #605e24",
"#W c #51372f", "#X c #bc6843", "#Y c #bc7852", "#Z c #1c7720", "#0 c #945638", "#1 c #145812",
"#2 c #ac715c", "#3 c #1e6f16", "#4 c #b99391", "#5 c #2f1c15", "#6 c #147019", "#7 c #14400a",
"#8 c #522a32", "#9 c #746e6c", "a. c #f7d0cb", "a# c #94868c", "aa c #e2b982", "ab c #bfadb4",
"ac c #ac9aa0", "ad c #fcfafa", "ae c #e3a774", "af c #4f4947", "ag c #f0a290", "ah c #f8d7d3",
"ai c #fbf7b0", "aj c #896240", "ak c #fcd898", "al c #1a0a04", "am c #2c3614", "an c #e3a89e",
"ao c #87645e", "ap c #685048", "aq c #a07972", "ar c #e4a694", "as c #c4a4a8", "at c #a7888f",
"au c #888084", "av c #ef9f69", "aw c #f1bf87", "ax c #d9c1c4", "ay c #f0bfba", "az c #dcd294",
"aA c #052004", "aB c #6c4834", "aC c #9c5150", "aD c #1d6012", "aE c #fbe1e0", "aF c #904a52",
"aG c #805e54", "aH c #844225", "aI c #b9877c", "aJ c #6c3644", "aK c #6c3b46", "aL c #84534c",
"aM c #c4948e", "aN c #25811f", "aO c #d49f96", "aP c #14500e", "aQ c #fceff0", "aR c #a48264",
"aS c #fbd092", "aT c #e2a06e", "aU c #e4b078", "aV c #a17f79", "aW c #fcb87e", "aX c #a46f4e",
"aY c #e4b6b0", "aZ c #fcb076", "a0 c #341404", "a1 c #443a24", "a2 c #cf9f6f", "a3 c #c48e84",
"a4 c #c48879", "a5 c #041004", "a6 c #fce09c", "a7 c #aa8784", "a8 c #dc885f", "a9 c #fc9a74",
"b. c #844830", "b# c #8f5b4e", "ba c #fcaa94", "bb c #ac5e54", "bc c #a46a5c", "bd c #844847",
"be c #d4825a", "bf c #a47264", "bg c #bc806f", "bh c #fcb29c", "bi c #1c7228", "bj c #343234",
"bk c #148e25", "bl c #401e13", "bm c #78563f", "bn c #e4ced4", "bo c #ceaeae", "bp c #cf9285",
"bq c #4f2a1e", "br c #846a4c", "bs c #8a6a69", "bt c #94766c", "bu c #fca284", "bv c #fcaa74",
"bw c #bc7a64", "bx c #fcbab1", "by c #bc8059", "bz c #dc915f", "bA c #143204", "bB c #fcc084",
"bC c #fcc1b5", "bD c #141a04", "bE c #8c7274", "bF c #ecd094", "bG c #6c4846", "bH c #a46a51",
"bI c #1c8e24", "bJ c #78422e", "bK c #b36a43", "bL c #1ca22c", "bM c #9c6a52", "bN c #5c4234",
"bO c #b68e6a", "bP c #278e20", "bQ c #a45e39", "bR c #422a20", "bS c #633642", "bT c #a05e4f",
"bU c #945651", "bV c #7b4246", "bW c #ac6a54", "bX c #795651", "bY c #e0a297", "bZ c #bc9a99",
"b0 c #342214", "b1 c #c4b2b4", "b2 c #e4aea6", "b3 c #ecc68c", "b4 c #7c4f3f", "b5 c #0f781d",
"b6 c #5c3231",
/* pixels */
"bK.h#XbKbK#X#l#X#l#l#l#l#l#l#l#l.D#l.D.D#Y.D.D#Y.D.D#Y.D.D#Y#l.D#l#l#l#l#l#l#XbKbKbK.h.h.h.h.h.hbQ.4bQ.R.R.R.R.R.R.j.R.v.j.v.j.v",
"bK#XbKbK#lbK#lbK#l#l#l#l#l.D#l.D#l.D#Y#l.D#l#Y.D#Y#Y.D#Y#Y.D.D#l.D.D#l#l#l#l.ObK#XbK#XbK.h.h.h.4.4bQbQbQ.4.R.R.R.j.j.j.j.j.j.v.v",
"bKbKbK#XbK#l#l#l#l#l#l#l#l.D#l.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y#l.D.D#l.xbk.5.hbKbKbK.h.h.h.4bQ.4bQ.RbQ.R.R.R.R.R.j.j.j.v.v.j",
".hbK#lbK#X#l#X#l#l#l#l.D#l.D#Y.D#Y#Y.D#Y#Y#x#Yby.D#Yby#Y#x#Y#Y#Y#Y.D#Y#Y.h.z.q.1.7bKbK#XbK.h.h.h.hbQbQ.4.RbQ.R.R.R.j#0.j.j.v.v.v",
"#X#XbK#l#lbK#l#l#l#l.D#l#Y#Y#Y#Y#Y.Dby#Yby#Yby#Ybyby.Dby#Yby.Dby#Y#Y#Y#YbQ.r.7#y.7#VbKbKbKbK.h.h.4bQ.4bQbQ.R.R.R.R.j#0.j.j.j.v.v",
"bKbK#lbK#l#l#l#l#l#Y#l#Y#Y.D#Y.D#Yby#Yby.Dbybyby#xbybybybybyby#Yby.D#Y#Y#Y#w.8.q.M.z.m#lbK.hbK.h.h.hbQbQbQbQ.R.R.R.R#0.v.j.v.v.v",
"bK#lbK#l#l#l#l#l#Y#l#Y#Y#Y#Y#Yby#Yby#Ybybybybybybybybybybyby.Dbyby#Yby#Y#YaX.N.9#1.z.N#0bKbKbK.h.hbQ.hbQbQ.RbQ.R.j.R.j.j.v.j.v.v",
"#lbK#X#l#l#l#l#Y#l#Y#Y#Y#Y#Y#Y#Yby#xbybybyby#xbybybybyby#xbybybybybyby#Y#x.K.r.c#A.z.7#A.ibKbK.hbKbQ.4bQbQbQ.R.R.R#0#0#0.j.v.v.v",
"bK#l#l#l#l#l#l#Y#Y#Y#Y#Y#Ybybybybybybybybybyby.Jbybyby.Jbybybybybyby#Yby#YbM.N.z.7.5.5#T.l.7.W.h.h.h.hbQbQbQ.R.R.R.R.j#0.v.v.v.v",
"bK#lbK#lbK#Y#l#Y#l#Y#Y#Yby#Yby#Ybybybybyby.Jby.Jby.J.Jby.Jby.Jbybybybyby#n#m.8.z.7.7.U.#.1.5#A.WbK.hbQbQbQbQbQ.R.R.j#0.j.v.v.v.v",
"#l#l#l#l#Y.K#Y.K#Y#Y#Y#Yby#Yby#nby#n.J.J.Jby.J.J.J.Jby.J.J.Jby.JbybybybybH.N#A.c.9#L.1.1.1.1.l.c.W.h.hbQbQbQ.R.R.R#0.R#0.v.v.v.v",
"#X.K#l.K#l#l#Y#Y#Y#Y.o#Yby#nbybyby.Jby#n.J.J.J.J.J.J.J.J.J.J.Jby.J.Jby#n.m.8.c.N.z.l.l.5.5.l.l.7#AbQ#wbQbQbQ.RbQ.R#0.j.v.j.v.v.v",
"#l.K#l#l.o#l.o#Y.o#Ybyby#nbyby#n.Jby.J.J.J.J.J.J.J.J.J.J.J.J.J.J#n.J#n#Dam.N.N.9.7.7.l.l.l.z.7.7.7.z.W.hbQbQbQ.T.R.R#0.v.v.v.v.H",
".K#l.K#l#Y.K#Y#Y#Y#Y.o#Yby#nbyby.J.J#n.J.J.J.J.J.J.J.J.J.J.J.J.J.Jby.Jbm.r.N#A.z.7.7.l.l.7.7.l.5.l.7.z.ibQbT.R.R.R.R.v.R.v.v.v.v",
"#l#l.K#l.K#Y.o#Y.o#0#nbybybK.KaX.K#D.o.O.O#D#naR#n.bbO.J.b.J.b.J.J.J#Da1.N.c#A.7.7.lb5.1.5.5.1.1.1.1.5.l.z.mbQ.R.R#0#0.v.v.v.v.H",
".K#l.K#l.o#l.o#YaX#lbO.k.ea6a6a6a6akakakakaSbFaT.WbObO#D#Y.C#t.C#t#t.K.T.W.W.d#V.7.1.#.1.1bkbkbkbkbk.1.5.5.7.i#0#0.R.v.j.v.v.H.v",
".K#l.K#Y.K#Y.o#Y#0#E.v.hbeaaa6a6a6.t.taS#G#G#x#xaj.JbOaj.fa2.e#.aiaiaiaiazaz#K.o#3.#bk.#.#.ybk.y.ybk.#.1.1.5.z.c.m.R#0#0.v.v.v.v",
".K#l.K.K#l.o#Y.oaBal.Za0aH#Baka6a6a6a6aS#xbqbqa0#D.J.J#W.u.H#Y.p.taib3bz.f.D#Y.W.#bkbk#c#c.ybLbL.y.y.1.#.1.1.l.z.c.L.v#d.v.v#M.H",
".K.K#l.o.K#Y.o.o.Lalalala0bKaaa6a6a6a6.t#xblalb0aRbObralala0bKakaiaUa8#wbq.Z.ZaD.##c#c#c.ybLbLbLbL.ybk.#.1.1.5.7.c.c.m.v.v.v.H.v",
"#l.K.K#l.o.K#Y.obmalalalal.a#Gakakaka6a6.E#M..bNbObO#m..a0.vb3#.aUa8.L.Z..al#Q.qbk#c.y.y#e#U#UbLbL.ybI#c.1.#.1.l.z.8.8.H.v.v#M.H",
".K.K.K.K.o#Y.o.o#Malalalala0.D#Kaka6aka6aSbKal.O.baRalalbJaU#.aebe#Fal..bD#Q#L#Z#z#c#cbP#R#U#U#UbL#ebIbI#Z.1b5.5.z.8.8.N#M.H.v.H",
".K.K#l.K#l.o.o.o.Aa1.Xalal.Z#0aeakakakakak#P#WaRbObral.aa2bFae#l#Oal#N#A.7#6b5#6.##c#e#e#e#U#U#U#e.ybPbI#y.#b5.l.z.c.8.N#W.v#d.H",
".K.K.K.o.K.o.o#Y.o.o#n.Oalal.g#lakakakakak.EbQbObO.b#F#Gb3ae.K.u..#N.c.z.7#6.q#Z#z#cbP#e#U#e#e#e#R#e#c#y.#.1.1.l.z.c.8.8#N.H#M.H",
".K.K.K.K.o.K.o.o.o#n#n#nbmala0.haeaSakakakak.Dbt.J.O#YaSaT#l.X..#N.8#A.z#L#6#3#3#ybIbP#R#e#e#e#ebP#RbI#z#y#y.q.7.c.8.8.N#N#W.vbd",
".K.K.K.K.K.o.o.o.o.o#n#n.oalal.a.faSaSaSakaSaTaj#D.o#KaTbK.X...r#N.8#A.c.7#L#6b5aN#y.PbP#R#RbP#R#R.P#y#Z#6.q#6.7#A.c.8.8.r.Ib..H",
"bW.K.K.K.o.K#Y.o.obw.S.o#n#mal.g.DaaaSaSaSaS#KbQbKawaebK.X..#u.N#N.8.c.c#T#L#6#3#Z#3aN.P.PbPaN.P#zaN#Z#Z#L#6#L.7.8.8.8.N#NaAb.bd",
".KbW.K.K#2.K.o.o.o.o#n#n#IbMal.Z.R#PaSaSaSaSaSa8aaaebQbq..a5.r#N#N.N#A#A.7#T.MaD#Z#3aN#y.P.PaNaN#y.M#3#Z#T#6.7#A.c.c.8#N.raA.G.v",
"bW.K.K#2.K.o#2#2.o.o.o.o#n#nalal.u.D#K#KaS#KaS#K.EbH.u...na5aA#N.N#N.c.9#A#1#T#Tbi.M#3.Q#y#y#y.M#y#3.M#LaP#L.7#A.N.N.8.N.raA#rb.",
".KbW.K.K.K#2.K.o.o.o.S.o#I.o.Wala0.4a2#K#K#KaS#K#B#Oal.Wbma5aA.r#N#N.8.8aP#1#1.U.MaD.M.Q#Z#Z.Q.Ubi#L#L#T.c#T.z.8.N.8.N.N.r#ubqbd",
"bW.KbW.K#2.K.o#2.o.S.o.S.o.S.Oalal.H.D#K#K#K#K#K#P#Fbm.bapa5#u.r#N#N.8.8.caP#1aP#TaDaD#3#3#3.MaDbi#1#T#1.9.z.c.8#N.N#N.raA#u.nb.",
"bWbW.KbW.K#2.K#2.o.K.o.o.o#I.obNal#g#lbB#K#K#K#K.EbQaR#Ibma5#u.r.r#N.N.N#7aPaP.9.U#TaD#T#L.M#LaP#T#1#T.9.c#A.c.8.N.N#NaA#ua5b0bd",
"bWbWbW.K.K.K#2.K#2#2.o.S.o.o.S.Wal#g#laWbBbBbBbB#K#x.T#I.Wa5#uaA.r.r#N.8.N.c.9.9aP#1aPaD#T#1.U#7#TaPaP.N.8.9.8.N.r.r.r.r#ua5bqb.",
"bWbWbWbW#2#2.K#2#2.o#2.o.o.o.o.Sbl.Rae.EbBbB#KbBbBav#0#naja5#u#uaA.raA.NbA.N.9#7.9aPaP#1#1#1#7aPaP.c#7#N.c.8.N#N.r.r.raA#u..#r#o",
"#jbWbWbWbWbW#2#2#2#2#2bf.obf.o.AbQaT.E.f.fbBbBbBbBbB.h#h#Ha5a5#uaAaAaA#N#N.N#7.c#Q.9#7.9aP.9#7.c.9.9.8.r.8.N#N.r.raAaAa5a5..#E#o",
"bWbWbWbWbWbW#2bW#2#2#2.obf.obM.R#PaW.f.jbQbBaWbBbBaW.f#0.o#5a5#u#uaA#u.r.rbA#N#Q#Q#7#Q.9#7.9#N.9.8.N#N.r.N#N.r.raAaA#ua5....bJbV",
"bK#j#jbWbW#2bWbW#2#2#2bW#2aX.R#BaW#B.a.g#XaTbBaWaWaW#C#0aXbN..#u#u#u#uaA.raAbA.N#N#Q.N#Q.8#Q#N#7#NbA#N.r#N#NaA#u#u#ua5.....XbJ#o",
"#j#j#jbW#jbWbWbW#2bW#2#2aX.v.faW#BbJ.Z.Z.v#laWaWaWaWaW#l.W.A..a5#uaA#uaAaAaA.rbA.rbA.rbA#NbA#N#N.r.r.raA.raA#u#u#ua5......b6bVbJ",
"#j#j#j#jbWbWbWbWbWbWbWbH.v.faWav.R.Zalal#E.havaWaWaWaW#P.v#2.n..#u#u#u#uaAaAbDaA.raA.r.r.raAbA.raAaAaA#u#u#u#ua5a5......#5bJbVbV",
"#j#j#j#j#jbWbWbW#2bWbH.v#xaZ#P.Rbl.I#rala0.R.faWaZaZ#C#C.R.A.A....a5#u#uafas.2aQbnaubD.rafa##9bDaAaA#u#u#ua5a5a5a5......aJbJbVbJ",
"#j#w#j#j#j#j#j#jbc#w#0#xaZ.p.hbqbR.A.Aal.ZaH.RaZaZ.EaZ#C#x#MbWb4..a5a5#qayahaEaEaQaEaubEa.adaQab#u#ua5a5#ua5a5........bq.LbVbVbV",
"#jbb#j#w#jbH#jbW#w#0#xaZbv.K.u...Tbc#2#5.Z.g.4#P#CaZ#C#CaT.v#wbc#r..afb2a.#sbCbCbC#fbZ.3a.a.#say#9a5a5a5a5a5..a5.....Z#ibVbJbVbJ",
"bbbT#jbT#j#jbcbT.v#xaZav#x.aalb4bWbWaX#oala0.jbK#C#C#C#C.pbQ#MbW.Aa0a7bC#s.0.wbhbxaObsbgbhbxbxaO#qa5a5..a5........#5aKbJbVbV#i#i",
"bb#jbb#jbb#wbT.j#xaZaZ#xaH.ZaB#jbWbcbW.Aalal.u.4#P#C.p#C.p#BaH#jbcbcbYbCbC.3aLbKbyaLbRbd.wag.3bf.na5.............ZaK#obVbJbJ#ibJ",
"bbbQbbbT#jbU.jbebvaZbe.vblb6#wbcbc#jbc#j.Gal.g.R#x#C.p.p.p.p.R#M#jbf.0bCbx.Y#W.ubq#5al#g.aaLb4aoa5..........bj#qbsb4bVbV#i#i#i#i",
"#b#b.R#0.v.ja8bvaZav.4.ubRb##j#j#w#jbc#j#Mal#g.j.D.p.p.p.p.p.fb..Sa3#fbx#S#4ababbZacb1bnaQaQaEat.........s#p#vadaQaE#p#p#pb1as#i",
"b..4bK.DbeavaZaZbvbv#X#X.4bQ#0#b#j#wbU.v.R.R.R.h#P.p.p.p.paT.p#Y.vbg###J.BaQadadabaEadaQaEa.boap......a#a.ad#va.#s#saEadadadb1.G",
"b..4bzbza8.w.w.w.w#P#Pav.w#l.HbT#w#jb6.j#xbz#PaT.p.p.pavae.paTaT#P.f.Rb#bx#fbx#SaM#J#S#S#S#S#4bN#r#ObsayaE#sana3###S.0ananara7bS",
".uaH.aaH.a.a.a.aaHaHaHaHaHaHaHbTbTbU.g.aaH.HaHaHaHaHaHaHaH.H.H.v#Mb..vaqa4#2bHbW.Y.AbWbY#Sb2aIbGbd#o.Y#sah#Sa3b4bwbh#SanbfbT#H#a",
"b6alalalalalalalalalalalalal#Fbbbb#Malalal.Zal.Zal.Z.Zal.Z.Z.Zbl.G#h.SbpaM.G.u.ubq#Wa4#S#Sanaq#ibdbGaObC#San#H#Wa3bxananaVbq#g.G",
"aC#i#O#E#OaJ#O#FaJ#F#FaJ#O.G#dbTbTbd#r#r#rbq#r.Xbq.X.XbR.X.Xb0.X.AbY#f#S.YbGaK#F#FaB#J#f#SbYbs#obd#Wbp#Sb2an#H#q#Sa.#SbY#HbSb6aK",
"#b#b#b#bbb#b#b#bbQ#b#b#bbb#b#bbTbb#b#b#b#b#b#b#b#b#b#b#b#b#bbUbU.SbY#S#Sa7b4#daF#dbXbY#S#S.3aG#o#obRbwbab2ana7axaha.anaMbXbSaKaJ",
"aC.4aCbbaC#b#bbb#b#bbb#b#b#bbb#b#b#b#bbT#b#bbT#bb##bbU#bbUbUbU#d#I.0#SanaV#o#daL#o.Aan#S#SaMap#obV.X#oa9.0anayadaEaY#J#H#raJaKaK",
"#baC#baC.4aC#baC#b#b#b#b#b#b#b#b#b#b#b#b#b#b#b#b#bbUbUbU#d#b#daLa4.0#SbY#HbdbdaF#o.S.0#SanaIbGbVbVb6#g.va9an.0#Sb2a3.A.GbSaKaJbS",
"aCaCaCaCaCaC#baC.4aC#baC#b#baC#b#b#b#b#bbU#b#dbU#daCbUaCbU#d#daLbpag#SaO#qaFaLbdaK.Y.0.0anaV#kat#4#ibqaoanahbY#hb#.L#rb6aJ#aaJaJ",
"aC#b#b#b#baC#baCaCaC#baCaC#b#baCaC#daC#d#b#d#b#d#b#d#d#d#d#d#0bU.3.0#SbpaGbdbdbd.G##.0.0bYbZ.2aQac#iaobZ#S#fan#say#pa##iaKaJbSaJ",
"aCaCaCaCaC#baCaCaCaCaC#baCaCaC#b#d#b#b#daCbU#d#d#d#d#d#0#d#d#db##J#S.0.Y#kbdbdbd.Ga4.0an.0aEaQ.Bbtat.BaQaEananan#SbCa.axbXbSaJbS",
"aCaCaCaCaCaCaCaC#baCaCaCaCaC#daC#daC#d#daC#d#d#d#d#d#d#d#daLaFbfbYbaan#IbGbdbdbdb6bTbu.0anan.3bgaqaY#vahanbga4#JanbYb2ayboaKbSbS",
"aCaCaCaCaCaCaCaCaCaCaCaCaC#d.R#daC#daC#d#d#d#d#d#d#daF#dbdaFbdbgan.0.3bs#ibdbdbV#i.u.R#jbHbT#M#Oao#f#sbY#Ib4b.bTbg#JbYbY.VbsbS.6",
"aCaCaCaCaCaCaCaCaCaC#daC#daC#d#d#d#d#0#d#d#d#d#d#dbd#d#h#p#pa7#J.0.0#IbGbdbVbVbVbVbSbq.u.ub6b6bq.S.0.0bYaI#Wbl.ubJ.D.0bY.3bs.6bS",
"aCaFaCaFaCaFaFaCaFaC#daC#daFaCaFaC#daFaF#daF#daFaFaFaLaOahadad#S.0##.AaKbVbdbVbV#ibVbV#i#i#i#i#8b#buanbY.Vbo.Fab#pa.aybYaIbGbS.6",
"aCaFaCaFaCaFaCaFaCaFaCaFaFaCaFaFaFaFaF#daFaFbdaFbdaF#obp#S#f#say#J#hbS#ibVbVbVbV#i#i#i#i#iaK#ib6#ObebabYanayaEadad#vaYbpaG#8bS.6",
"aCaFaFaFaFaCaFaCaFaFaFaCaFaFaFaFaFaFaFaFaFaFbdaFbdaFbV.Kag.0babp.A.GaKbd#ibd#i#i#i#i#i#i#iaK#iaJblbV.DbpbYbYb2#SaYbYbgaL#W.6.6.6",
"aFaFaCaFaFaFaFaFaCaFaFaFaFaFaFaFaFaFaFbdaFbdaFbdbdbdbdaH#jbw#2aL.uaKbV#ibV#i#ibV#i#i#iaK#iaJaKaJaJbl.a#dbT#2bg.Sbc#M.Gb6.6.6.6.6",
"aFaFaFaFaCaFaFaFaFaFaFaFaFaFaFaFaFbdaFbdaFbdaFbdaFbVbd#i#E#E.ub6#i#ibVbV#i#i#i#i#i#i#iaJ#iaJaKaJaKaJ#8bq.u#F#O.u.u#8#8.6.6.6.6.6"
};

/* now reduced colors (notice that some match the predefined brown3, brown4, red4, etc */

char * fig_reduced_c_icon_X[] = {
/* width height num_colors chars_per_pixel */
"    64    64       32            1",
/* colors */
". c #000000", "# c #009000", "a c #925132", "b c #bb8863", "c c #145812", "d c #fbc88b",
"e c #bc8059", "f c #000000", "g c #9e5834", "h c #47511c", "i c #ed9967", "j c #000000",
"k c #b17859", "l c #000000", "m c #84767c", "n c #fbf7b0", "o c #748634", "p c #00b000",
"q c #a05853", "r c #ffe0e0", "s c #bc7852", "t c #b09ea8", "u c #000000", "v c #b27052",
"w c #ffc0c0", "x c #aa8784", "y c #900000", "z c #d5babe", "A c #803000", "B c #bd704a",
"C c #ffffff", "D c #a04000",
/* pixels */
"BgBBBBBBBBBBBBBBsBssssssssssssBsBBBBBBBBBBgggggggggggggggggagaga",
"BBBBBBBBBBBBBsBsBssBsBsssssssssBssBBBBvBBBBBggggggggggggggggggaa",
"BBBBBBBBBBBBBsBssssssssssssssssssBssBo##gBBBgggggggggggggggggaag",
"gBBBBBBBBBBsBssssssssesessesesssssssgc##cBBBBgggggggggggggaggaaa",
"BBBBBBBBBBsBsssssseseseseesesesessssglc#chBBBBggggggggggggagggaa",
"BBBBBBBBBsBsssssseseseeeeeeeeeesessssql#ccaBBgBgggggggggggaagaaa",
"BBBBBBBBsBssssseseseeeeeeeeeeeseesessvlccclaBBBgggggggggggggagaa",
"BBBBBBBsBssssssseeeeeeeeeeeeeeeeeeesevlccccchBBgBggggggggaaagaaa",
"BBBBBBBsssssseeeeeeeeeebeeebeeeeeesesqlcc##cccaggggggggggggaaaaa",
"BBBBBsBsBssseseseeeeebebebbebebeeeeekulcccc###caBgggggggggagaaaa",
"BBBBsvsvssssesekekbbbebbbbebbbebeeeevlcccc####ccaggggggggagaaaaa",
"BvBvBBssssksekeeebekbbbbbbbbbbbebbekalclccc##ccccgqggggggagagaaa",
"BvBBkBkskseekeekbebbbbbbbbbbbbbbkbkklllcccccccccccaggggaggaaaaaa",
"vBvBsvssssksekeebbkbbbbbbbbbbbbbbeballccccccccc#ccchgqggggagaaaa",
"BBvBvskskakeeBvvvkkvvkkkkbbbbbbbbbkjlccccc#########ccagggaaaaaaa",
"vBvBkBksvBbidddddddddddiabbksbbbbbvaaaahc############chaagagaaaa",
"vBvsvsksauageddddnndbbeeabbaeiddnnnndddk#####p#pp#####ccagaaaaaa",
"vBvvBksku.ffabddddddefffkbbufasinndiessa###ppppppp####cccaayaaaa",
"vvBkvskka...fBdddddnef.fkby..fBdniiqfffc#ppppppppp#####cccaaaaaa",
"BvvBkvska....abdddddda.ubbu.faddiiaf..l##ppppppppp#p###ccllaaaaa",
"vvvvkskka....fsddddddB.vbk..aidieu...lc##pp#pppppp######clllaaaa",
"vvBvBkkkqjf..faidddddiukby.aidiBu.lcc####ppppppppp#####ccclluaya",
"vvvkvkkskkkv..fBddddddgbbbubdivf.lccc####p#pppppppp####ccclllaaa",
"vvvvkvkkkkkka.fgidddddsmbvsdiBf.llccc######ppppp#p#####cclllluaA",
"vvvvvkkkkkkkk..aedddddiakkdiBf.lllcccc######pp#pp######ccclllfaa",
"vvvvkvskkekkku.fsddddddgBdiBf..lllcccc##############c#ccllllllaA",
"vvvvkvkkkkkkbq.fgidddddidigf..llllcccccc#########c##c#ccccllllua",
"vvvkvkkkkkkkkk..fsdddddddvf.j.llllcccccc#c#####c##ccccccllllllja",
"vvvvvkvkkkkkbka.fgidddddbu.aa.llllllccccccc####c#ccccccllllll.fA",
"vvvvkvkkkkkkkkv..asdddddiuabu..lllllccccccc###cc#ccccccllllll.ja",
"vvvvvkvkkvkkkbku.fBddddddgkba..llllllcccccccccccccccccclllll..fA",
"vvvvvvkvkkkkkkka.fBddddddeaba..llllllcccccccccclcccllcllllll..fa",
"vvvvkkvkkkkkkkkkfgiddddddiaka...llllllclcccccclcccllclllllll..jA",
"vvvvvvkkkkkkkkkqgideedddddgqm...lllllllclclccclccclllllllll...uA",
"vvvvvvkvkkkkkkqgideggdddddeakf...l.llllllllclclcllllllllll....aA",
"BvvvvkvvkkkvkvgbdbafBiddddiavu.....llllllllllllllllllll......faA",
"vvvvvvvvkvkkvaedbaffaBdddddBaq...l.lllllllllllllllllll.......uAa",
"vvvvvvvvvvvvaedigf..ugiddddiakj.....ll.llllllllllll.........faAA",
"vvvvvvvvkvvaeiigffj.fgediiiigqq.....utrCrm.luxm.ll..........uaAa",
"vqvvvvvvvqaeiigffqq.fagiidiieava...mrrrrCrmmrCCt...........faAAA",
"vqvqvvvvqaeiivf.avkfffgiiiiiiaqvj.uwrrrrrztwrrrrm.........fuAaAa",
"qqvqvvvqaeiiea.avvvA.fgBiiiiigavqfxrrwidrwmbdrrwm........fuaAAuu",
"qvqvqqqgeiieafuvvvvq..fgiiiiibavvvwrrwyBeyfAiwwkj.......fuAAaaua",
"qgqqvygeiieafuqvvvvvu.fgeiiiiigavkwrrxufff.fayay......jmmaAAuuuu",
"qqgaagiiiigffyvvqvvva.fgsiiiiieakxzrwxttttzrCCrx....mzCCCrzzzztu",
"agBseiiiiiBBggaqvqyaggggiiiiiiisabbwrCCCtrCCrrzu...xrCCrrrrCCCzu",
"agiiiiiiiiiiiBaqqvugeiiiiiiiiiiiiegyrzrwxwwwwwxujumrrrwxbwwwwwxu",
"faaaaaaaaaaaaaaqqyfaaaaaaaaaaaaaaaaxbkvvxqvwwwxuAAxrrwxaedwwkqmu",
"u.............uqqa...f.f.ff.ffffuqkwxufffubwwwxuAuwrwwmuxrwwxffu",
"DuuuuuuuuuuuuuyqqAjjjfjfffffffffqwzwxuuuuuwzwwmAAuwwwwmmwrwwmuuu",
"qqqqqqqqgqqqqqqqqqqqqqqqqqqqqqyykwwwxayAyAwwwwyAAfewwwxzrrwxAuuu",
"DgDqDqqqqqqqqqqqqqqqqqqqyqyqyyyybwwwxAyyAqwwwxuAAfAiwwrCrzwmjuuu",
"qDqDgDqDqqqqqqqqqqqqqqqqqyyyyqyybwwwmAAAAkwwwxuAAufaiwwwwxquuuuu",
"DDDDDDqDgDqDqqDqqqqqyqyyyDyDyyyywwwwmAyAuxwwwxAxxufywrwqyajuuuuu",
"DqqqqDqDDDqDDqqDDyDyqyqyqyyyyyaywwwwyAAAubwwwtrCtuytwzwrrzxuuuuu",
"DDDDDqDDDDDqDDDqyqqyDyyyyyyayyyywwwxAAAAubwwwrCrmxrCrwwwwrrzAuuu",
"DDDDDDDDqDDDDDyDyDyyDyyyyyyyyyAkwwwbuAAAuqwwwwwbxzCrwbbwwwwrzuuu",
"DDDDDDDDDDDDDygyDyDyyyyyyyAyAAAbwwwmuAAAufgvvqauyzrwbaaqbwwwwmuu",
"DDDDDDDDDDyDyDyyyyayyyyyyAyqzzxwwwbuAAAAAufffuufkwwwxuffaswwwmuu",
"DADADAADADyDyADADyAAyAyAAAywrCCwwbquAAAAuAAuuuuuywwwwzttzrrwxuuu",
"DADADADADADAADAAAAAyAAAAAAAwwzrrwquuAAAAuuuuuuuuuewwwrrCCCzwyuuu",
"DAAAADADAAADAAAAAAAAAAAAAAAvwwwwquuAuAuuuuuuuuuufAswwwwwzwbyuuuu",
"AADAAAAADAAAAAAAAAAAAAAAAAAavekyfuAuAuuAuuuuuuuuufayqkbkvauuuuuu",
"AAAADAAAAAAAAAAAAAAAAAAAAAAuuufuuuAAuuuuuuuuuuuuuuuffuuffuuuuuuu"
};

#endif /* USE_XPM_ICON */

/* bitmap of letters for splash screen ("3.2.X") */
#include "version.xbm"

/* splash background in XPM */

#ifdef USE_XPM

char *spl_bckgnd_xpm[] = {
/* width height ncolors chars_per_pixel */
"630 210 251 2",
/* colors */
"   c Black",
" . c #D6D6FE",
" X c #A1958E",
" o c #C5AFAD",
" O c #8F8CAE",
" + c #E9CCAF",
" @ c #B3B3BA",
" # c #5C1704",
" $ c #907D6E",
" % c #5A5869",
" & c #C5C3DD",
" * c #C5C5C4",
" = c #D8B89E",
" - c #D8B9AE",
" ; c #7E7B8B",
" : c #D8BEB1",
" > c #B58769",
" , c #EACCC7",
" < c #493F08",
" 1 c #C6B5A7",
" 2 c #7F6554",
" 3 c #C6B7AD",
" 4 c #B4A9F1",
" 5 c #D8C4C1",
" 6 c #A38271",
" 7 c #FCE4C4",
" 8 c #B4B1C9",
" 9 c #FCEACB",
" 0 c #C6C3E8",
" q c #D8D1FF",
" w c #D9B39E",
" e c #382808",
" r c #918781",
" t c #A4795F",
" y c #C7B3BC",
" u c #4A4034",
" i c #FCFCF9",
" p c #B68E78",
" a c #B5AEE8",
" s c #C7C3F1",
" d c #D9D1FE",
" f c #D9D1FF",
" g c #FECDB6",
" h c #B69C8F",
" j c #DAB6A5",
" k c #6E6B81",
" l c #6E6C90",
" z c #9287C6",
" x c #DABFAE",
" c c #FED9B6",
" v c #FEDAC3",
" b c #A49AD1",
" n c #6F574B",
" m c #DBA68C",
" M c #ECD3B5",
" N c #393747",
" B c #816C5B",
" V c #825318",
" C c #C8C3FE",
" Z c #A67155",
" A c #81796E",
" S c #040204",
" D c #4C3519",
" F c #ECE8FF",
" G c #B7A59C",
" H c #FFD9C3",
" J c #938DBC",
" K c #DBC1B7",
" L c #A59ADD",
" P c #B7A9FE",
" I c #FEFEFF",
" U c #706051",
" Y c #C9BEC4",
" T c #B7B0F3",
" R c #827164",
" E c #947F70",
" W c #CAA78A",
" Q c #EEC0AA",
" ! c #95654A",
" ~ c #5F4207",
" ^ c #715335",
" / c #DCBEA0",
" ( c #EECCB6",
" ) c #B8A79B",
" _ c #836343",
" ` c #EDECFB",
" ' c #DCC3AA",
" ] c #A78574",
" [ c #B9947B",
" { c #CAC0C1",
" } c #716359",
" | c #B8B6D1",
".  c #DDB19A",
".. c #CAC3EB",
".X c #CBA694",
".o c #DCD3CC",
".O c #845733",
".+ c #EEE1D7",
".@ c #173206",
".# c #DCDCD8",
".$ c #837FA6",
".% c #2A2326",
".& c #DDC0A9",
".* c #B9A9F1",
".= c #B9A9FE",
".- c #B9ACA6",
".; c #EFD7C7",
".: c #4E4967",
".> c #B9B6D9",
"., c #B9B6DD",
".< c #CBC3F1",
".1 c #CCAE8C",
".2 c #DDDDD1",
".3 c #9689DD",
".4 c #CCB7A4",
".5 c #8484B4",
".6 c #2B2A37",
".7 c #A8A1D5",
".8 c #A98469",
".9 c #4F4B53",
".0 c #BAB6E8",
".q c #BB9D88",
".w c #A99482",
".e c #CCCDC9",
".r c #A9968D",
".t c #F1CDB6",
".y c #978EC9",
".u c #A9A2CD",
".i c #625953",
".p c #AA8C77",
".a c #CDC3FE",
".s c #996B43",
".d c #F2CABE",
".f c #747474",
".g c #BCAA94",
".h c #AA9CEF",
".j c #401704",
".k c #E0CAC7",
".l c #997967",
".z c #AB876E",
".x c #E1AF9B",
".c c #2E1305",
".v c #BCB7E0",
".b c #CEC3FF",
".n c #CECCE2",
".m c #63627D",
".M c #E1BBA8",
".N c #E1C0AA",
".B c #9995C6",
".V c #9998A5",
".C c #9A8271",
".Z c #896040",
".A c #0B0B0C",
".S c #0B0B0F",
".D c #D0B6A5",
".F c #AC9AFE",
".G c #F3F1FF",
".H c #D0BAB0",
".J c #F4D5B8",
".K c #ACA1E2",
".L c #9A97B7",
".P c #ACA9C3",
".I c #ACA9D1",
".U c #D0C3D1",
".Y c #BEB6DD",
".T c #BEBEE6",
".R c #9B887C",
".E c #D1B29C",
".W c #E2DDFF",
".Q c #E2E0FB",
".! c #D1B6A9",
".~ c #1E1C22",
".^ c #ADA2B4",
"./ c #9B96BE",
".( c #423D58",
".) c #ADA9DD",
"._ c #BFB6E8",
".` c #BFB6FF",
".' c #786D64",
".] c #D1CEF5",
".[ c #9C89EC",
".{ c #E4BEB5",
".} c #E3DDFF",
".| c #9C90D5",
"X  c #9C9AB6",
"X. c #D3A189",
"XX c #796358",
"Xo c #313306",
"XO c #F7BC9F",
"X+ c #AEA9E8",
"X@ c #C0B6F1",
"X# c #8B7465",
"X$ c #F7C8AE",
"X% c #AF969C",
"X& c #8B7FBB",
"X* c #E5C4B5",
"X= c #E4E5E3",
"X- c #E5C6C4",
"X; c #7A5E51",
"X: c #9D98CB",
"X> c #C29785",
"X, c #0E1C1A",
"X< c #C1B6FE",
"X1 c #573007",
"X2 c #F7E1D1",
"X3 c #E5D6CD",
"X4 c #AFB0D5",
"X5 c #B0978E",
"X6 c #E5E1E6",
"X7 c #E5E4F2",
"X8 c #0F1307",
"X9 c #9E9AC3",
"X0 c #F8DCBE",
"Xq c #9E9DBC",
"Xw c #C2BED7",
"Xe c #F8E4E1",
"Xr c #B0B1E0",
"Xt c #C3A093",
"Xy c #E6DAD1",
"Xu c #7B70A5",
"Xi c #F8EAEE",
"Xp c #D5B2AC",
"Xa c #D4D3CD",
"Xs c #C3A79A",
"Xd c #696999",
"Xf c #10110E",
"Xg c #8E6C58",
"Xh c #8D8CA2",
"Xj c #E7CCE4",
"Xk c #9F9AD1",
"Xl c #C3B6FF",
"Xz c #E8B39A",
"Xx c #D6A995",
"Xc c #58517A",
"Xv c #B29382",
"Xb c #C3C0E6",
"Xn c #D6B09B",
"Xm c #E8BFA9",
"XM c #7E3516",
"XN c #D5D1FE",
"XB c #C4ACA1",
"XV c #C59579",
"XC c #E8D0C3",
"XZ c #B2A9DD",
"XA c #B2A9E8",
"XS c #A09EC9",
"XD c #8F7460",
"XF c #B2B0AD",
"XG c #C5A284",
"XH c #D6CEC9",
"XJ c #905F29",
/* pixels */
".] . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ...",
".T.] . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ....5",
".T.T.] . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ....5.5",
".T.T.T.] . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ....5.5.5",
".T.T.T.T.] . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ....5.5.5.5",
".T.T.T.T.T.] . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ....5.5.5.5.5",
".T.T.T.T.T.T.] . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ....5.5.5.5.5.5",
".T.T.T.T.T.T.T.] . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ....5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.] . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ....5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.] . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ....5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T._XZ.0Xm.IXZXZ.I b._XZXAX@XZ.I LXZ L LXkXA.0Xk bXk LXZ.hXA 4XlX@.)XmXZ.).!.I.IXA L L.)XAXZXA.=.aXA.}.aX@XA.*.t.* g.t.0.h 4XZXZXZXA.0XZ._.) bXZXAXZ.I L._.IXZXZXZ._._._.I.I.IXs L.,.Y.Y.P b., :.P.!XC.< &.!.,X@.} f H f.}.}.b g.b.} 0 |.I.&._._ bXZ._XAXA.)XZ.,.&._XZ._ &XsXs 1.P 1.PXZ.P.!.PXZ.,.P.I.P.P.P.PXZ.,XZ 1.PXs.I.!.I.!.,.!X9Xs.!.,.!.I.,.IXsX .!._.P.I.!.!.I 1.P.I.PXZ.I.P.P.!Xs.PXs.I.PX Xs.!.PX9X9.I.P 8.,XsXsX9 1X  ).P.P.I.P.P.!.,.,.I b., bXZ.PX9Xs.!.PXsXs bX9.I.P.I bX9.I bXZ._XZ.0Xm.IXZXZ.I b._XZXAX@XZ.I LXZ L LXkXA.0Xk bXk LXZ.hXA 4XlX@.)XmXZ.).!.I.IXA L L.)XAXZXA.=.aXA.}.aX@XA.*.t.* g.t.0.h 4XZXZXZXA.0XZ._.) bXZXAXZ.I L._.IXZXZXZ._._._.I.I.IXs L.,.Y.Y.P b., :.P.!XC.< &.!.,X@.} f H f.}.}.b g.b.} 0 |.I.&._._ bXZ._XAXA.)XZ.,.&._XZ._._ &XsXs 1.P 1.PXZ.P.!.PXZ.,.P.I.P.P.P.PXZ.,XZ 1.PXs.I.!.I.!.,.!X9Xs.!.,.!.I.,.IXsX .!._.P.I.!.!.I 1.P.I.PXZ.I.P.P.!Xs.PXs.I.PX Xs.!.PX9X9.I.P 8.,XsXsX9 1X  ).P.P.I.P.P.!.,.,.I b., bXZ.PX9Xs.!.PXsXs bX9.I.P.I bX9.I bXZ._XZ.0Xm.IXZXZ.I b._XZXAX@XZ.I LXZ L LXkXA.0Xk bXk LXZ.hXA 4XlX@.)XmXZ.).!.I.IXA L L.)XAXZXA.=.aXA.}.aX@XA.*.t.* g.t.0.h 4XZXZXZXA.0XZ._.) bXZXAXZ.I L._.IXZXZXZ._._._.I.I.IXs L.,.Y.Y.P b., :.P.!XC.< &.!.,X@.} f H f.}.}.b g.b.} 0 |.I.&._._ bXZ._XAXA.)XZ.,.&._XZ._.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXrXZ.,._.0XZ b bXZXm._XZX@XkXs.IXZ.I b LXZ bXsX9 b b L.h 4 4 4XAXZX@XA b.IXZXm.t LXZ LXZX+ LXA.*XA.=.aX@ gX@X@ gX@X<X@X@X@.0.)XmXAXZ.,X@XZ.I.IXZXZ.!.I.0.!.,._XZXZXm.I.I b.0 b._XZXC 0 b.!XZ |.^.! M.< |XZ._._ H.}.} f.aXZ.b f.b.}.GXC &XC.].,.I.IXZXZXZ.I.IXZ 0XZ._.,.<._.I.PXs.P.P |.!.I.!XZ.Y b.&.Y.P bXs.,.!.IX .P.I.P.P.PX9Xs.PX9X .!.I.I. .! L.P.^.!X@XZ.I.! |.!.I.I.!.!._.,.E.IXsX X Xs.P.IXsXs.P.PXsXsXs.P.P b.I.I.P bXs., |.!XZ.! b b.0._.Y.P.!.).!XsXsXs.IXsX9.P.)XZ.) b., b.PXs.) bXZXZ.,._.0XZ b bXZXm._XZX@XkXs.IXZ.I b LXZ bXsX9 b b L.h 4 4 4XAXZX@XA b.IXZXm.t LXZ LXZX+ LXA.*XA.=.aX@ gX@X@ gX@X<X@X@X@.0.)XmXAXZ.,X@XZ.I.IXZXZ.!.I.0.!.,._XZXZXm.I.I b.0 b._XZXC 0 b.!XZ |.^.! M.< |XZ._._ H.}.} f.aXZ.b f.b.}.GXC &XC.].,.I.IXZXZXZ.I.IXZ 0XZ._.,XZ.<._.I.PXs.P.P |.!.I.!XZ.Y b.&.Y.P bXs.,.!.IX .P.I.P.P.PX9Xs.PX9X .!.I.I. .! L.P.^.!X@XZ.I.! |.!.I.I.!.!._.,.E.IXsX X Xs.P.IXsXs.P.PXsXsXs.P.P b.I.I.P bXs., |.!XZ.! b b.0._.Y.P.!.).!XsXsXs.IXsX9.P.)XZ.) b., b.PXs.) bXZXZ.,._.0XZ b bXZXm._XZX@XkXs.IXZ.I b LXZ bXsX9 b b L.h 4 4 4XAXZX@XA b.IXZXm.t LXZ LXZX+ LXA.*XA.=.aX@ gX@X@ gX@X<X@X@X@.0.)XmXAXZ.,X@XZ.I.IXZXZ.!.I.0.!.,._XZXZXm.I.I b.0 b._XZXC 0 b.!XZ |.^.! M.< |XZ._._ H.}.} f.aXZ.b f.b.}.GXC &XC.].,.I.IXZXZXZ.I.IXZ 0XZ._.,.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXrXmXZ.,XZ.I bXs.I.,.,.!XA b bXZXAXZ.yXA b.)Xk b b LX9 m.h.=.h LXO g._ b.!.0XZ.t b b bXmXAX+XA 4 4XAXAX@XAXAX@.a g gX<X@XA._XZX@XZ.).,XAXZ LXs.IXZ.I.EXZ b. .IXZ.I.IXZXZXZ.I.!.&.Y._ 0 &.Y.P.PXZ 1.P.I.I |XZ.t f.}.}.b.*.*Xl.} d.; F F.,.0.Y._.&XZXZXZXZ.I.E.IXZ.!.Y.!.<.nXCXZ.PXs.P.I.I.&XZ.,.!.PXZ.,.,.!.I |.! |.!.I.^.!.I.I.P.P.PXs.I.IXZ._.<.P., bXs.,.Y.!.!.!XsXZXZ.!XZ |XZ 0.P.P.P.PX .PXs.&.0.)XsX9.PXs.P 8X9.!XZ.P b.PX9 8 8XZXZXZ.IXZ.,.!XZXZ.!.I LXZ.I.).P b.)Xs. .) 4XA._ b.I.! b.,XZXmXZ.,XZ.I bXs.I.,.,.!XA b bXZXAXZ.yXA b.)Xk b b LX9 m.h.=.h LXO g._ b.!.0XZ.t b b bXmXAX+XA 4 4XAXAX@XAXAX@.a g gX<X@XA._XZX@XZ.).,XAXZ LXs.IXZ.I.EXZ b. .IXZ.I.IXZXZXZ.I.!.&.Y._ 0 &.Y.P.PXZ 1.P.I.I |XZ.t f.}.}.b.*.*Xl.} d.; F F.,.0.Y._.&XZXZXZXZ.I.E.IXZ.!.Y.!.!.<.nXCXZ.PXs.P.I.I.&XZ.,.!.PXZ.,.,.!.I |.! |.!.I.^.!.I.I.P.P.PXs.I.IXZ._.<.P., bXs.,.Y.!.!.!XsXZXZ.!XZ |XZ 0.P.P.P.PX .PXs.&.0.)XsX9.PXs.P 8X9.!XZ.P b.PX9 8 8XZXZXZ.IXZ.,.!XZXZ.!.I LXZ.I.).P b.)Xs. .) 4XA._ b.I.! b.,XZXmXZ.,XZ.I bXs.I.,.,.!XA b bXZXAXZ.yXA b.)Xk b b LX9 m.h.=.h LXO g._ b.!.0XZ.t b b bXmXAX+XA 4 4XAXAX@XAXAX@.a g gX<X@XA._XZX@XZ.).,XAXZ LXs.IXZ.I.EXZ b. .IXZ.I.IXZXZXZ.I.!.&.Y._ 0 &.Y.P.PXZ 1.P.I.I |XZ.t f.}.}.b.*.*Xl.} d.; F F.,.0.Y._.&XZXZXZXZ.I.E.IXZ.!.Y.!.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T aXAXZXAXZXZ.IX9.PXsXZXs.IXZ.I.I L LXZXZXZ b b LXkXs L.IX@ 4 4X@ v.b.IXA.0 b.) bXmX@._._X@XZ._XAXA 4XZXmXAXz 4.a.aX@.0 4X@ 4X@._XZ.IXZX9.I.I.,.P.q.!.IXs.!.}.Y b.!XsXZ._.P b 0.,.I.YXZ.; d.,.IX  1Xs.I.!., g fXl f.bXl fXl.<.<.<.} F.}.,.E.,.!XZXZ.,._._XZ.Y.).IXs.!.P._._XC.<.!.^X Xs.,.Y.,.,XZ 0.<.0 sXZ._.P.!.I.a.,XZ.P.P.PXs.P.IXZ.IXZ.YXA.P.Y.Y.<.!._.Y.,.I.P.,.!.,.,.I.!.PXsXsX X X9.PX .PXs.P.P.P.P b &.I |.P.!Xm.).PXsXs.P.I._X@.t._.0.,._._.I.)Xm.aX@._.<XZ L.IXA.,.)XAXA.,.).IXZXZ.IXAXAXZXAXZXZ.IX9.PXsXZXs.IXZ.I.I L LXZXZXZ b b LXkXs L.IX@ 4 4X@ v.b.IXA.0 b.) bXmX@._._X@XZ._XAXA 4XZXmXAXz 4.a.aX@.0 4X@ 4X@._XZ.IXZX9.I.I.,.P.q.!.IXs.!.}.Y b.!XsXZ._.P b 0.,.I.YXZ.; d.,.IX  1Xs.I.!., g fXl f.bXl fXl.<.<.<.} F.}.,.E.,.!XZXZ.,._._XZ.Y.).IXs.!.P.!._._XC.<.!.^X Xs.,.Y.,.,XZ 0.<.0 sXZ._.P.!.I.a.,XZ.P.P.PXs.P.IXZ.IXZ.YXA.P.Y.Y.<.!._.Y.,.I.P.,.!.,.,.I.!.PXsXsX X X9.PX .PXs.P.P.P.P b &.I |.P.!Xm.).PXsXs.P.I._X@.t._.0.,._._.I.)Xm.aX@._.<XZ L.IXA.,.)XAXA.,.).IXZXZ.IXAXAXZXAXZXZ.IX9.PXsXZXs.IXZ.I.I L LXZXZXZ b b LXkXs L.IX@ 4 4X@ v.b.IXA.0 b.) bXmX@._._X@XZ._XAXA 4XZXmXAXz 4.a.aX@.0 4X@ 4X@._XZ.IXZX9.I.I.,.P.q.!.IXs.!.}.Y b.!XsXZ._.P b 0.,.I.YXZ.; d.,.IX  1Xs.I.!., g fXl f.bXl fXl.<.<.<.} F.}.,.E.,.!XZXZ.,._._XZ.Y.).IXs.!.P.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.0.0XZ b.).)X9XsXk.I.I.IXs b b b bXk.) gX@., LX9XkX9 b LXA.)._XA s f.I b.EXZ b b b L b L.)XZXA.t.0.0 LXAXAXA gX@ g 4.*X< gX@ 4X@XZ.!.IXs.EXZ.!X9.PXsXs.P.& 0.P.I.,.! b.,XZ.Y.I.!.!.I.) d 0.!.!.P.!.Y.Y., g f f.b.b.b f g f.< g.a.G.G.}XZXZ.,XZ |XZ.,XZ._ b._.Y.,.P.,XZ.,XZ.Y &XZ.IXs.P.IXs.IXs.!.Y |.!.YXZ.P.P.! M.n.P.PXs.P.PX9XsXZ.!._XZ.,.,.P |Xs._.,XZ.,.I.P.!.,.IXs.P._ |Xs.!.PX9X .PX XsXs.PXs.I bXZ.,.,.PXsXs.I.,.!X9.PX .P.!.)XZ.0._XZ._.,.Y._.,._X@XZXZ._.I.!XAXZXAXZX<.IXZ.!XZXAXZ.*.0.0XZ b.).)X9XsXk.I.I.IXs b b b bXk.) gX@., LX9XkX9 b LXA.)._XA s f.I b.EXZ b b b L b L.)XZXA.t.0.0 LXAXAXA gX@ g 4.*X< gX@ 4X@XZ.!.IXs.EXZ.!X9.PXsXs.P.& 0.P.I.,.! b.,XZ.Y.I.!.!.I.) d 0.!.!.P.!.Y.Y., g f f.b.b.b f g f.< g.a.G.G.}XZXZ.,XZ |XZ.,XZ._ b._.Y.,.P.,XZXZ.,XZ.Y &XZ.IXs.P.IXs.IXs.!.Y |.!.YXZ.P.P.! M.n.P.PXs.P.PX9XsXZ.!._XZ.,.,.P |Xs._.,XZ.,.I.P.!.,.IXs.P._ |Xs.!.PX9X .PX XsXs.PXs.I bXZ.,.,.PXsXs.I.,.!X9.PX .P.!.)XZ.0._XZ._.,.Y._.,._X@XZXZ._.I.!XAXZXAXZX<.IXZ.!XZXAXZ.*.0.0XZ b.).)X9XsXk.I.I.IXs b b b bXk.) gX@., LX9XkX9 b LXA.)._XA s f.I b.EXZ b b b L b L.)XZXA.t.0.0 LXAXAXA gX@ g 4.*X< gX@ 4X@XZ.!.IXs.EXZ.!X9.PXsXs.P.& 0.P.I.,.! b.,XZ.Y.I.!.!.I.) d 0.!.!.P.!.Y.Y., g f f.b.b.b f g f.< g.a.G.G.}XZXZ.,XZ |XZ.,XZ._ b._.Y.,.P.,XZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXrXZXZ b bXsX9.I.!XZ.I.Y._.)XkXZ.I b L.<.0 L b L.y b b.)XAX@.,XZXmX@ bXZ.I.)Xs b b LXZ b b._ LXA.t g.*.<XAX@X@X<.=X@.= g.a.0._.0XZXZ.,.I.I.P.PXs.!X9XsXZ.P.!.! b.I &XZ.Y._ d._.I.!XZXZXZ._._.!XZ.P.,.<.,.b F.}.a.a.a gX< v.b.b.b.G I f.).I.!XA.I.I.,.IXZ._.,XZXZ.Y.t.Y.P., bXZXZ.P ).PXZ.P.P.I.I.P.IXs.PX9X9.PX  |.!.PXs.PXs.PXs.I.YXA.,.P.Y | b.P.I.0.0XZ._.PXsXZ |.P.I b.P.P.P.P.P.P b.^.P.P.P.PX9X9._ 0 |.PX9Xs.PX XsX9X XsX X XsXZ b. ._ b._ bXm.<.t.<.,.IXZ L.0.YXZ LXZXZ.0Xs.!.I.I.,XZXZXZXZXZ b bXsX9.I.!XZ.I.Y._.)XkXZ.I b L.<.0 L b L.y b b.)XAX@.,XZXmX@ bXZ.I.)Xs b b LXZ b b._ LXA.t g.*.<XAX@X@X<.=X@.= g.a.0._.0XZXZ.,.I.I.P.PXs.!X9XsXZ.P.!.! b.I &XZ.Y._ d._.I.!XZXZXZ._._.!XZ.P.,.<.,.b F.}.a.a.a gX< v.b.b.b.G I f.).I.!XA.I.I.,.IXZ._.,XZXZ.Y.t.Y.,.P., bXZXZ.P ).PXZ.P.P.I.I.P.IXs.PX9X9.PX  |.!.PXs.PXs.PXs.I.YXA.,.P.Y | b.P.I.0.0XZ._.PXsXZ |.P.I b.P.P.P.P.P.P b.^.P.P.P.PX9X9._ 0 |.PX9Xs.PX XsX9X XsX X XsXZ b. ._ b._ bXm.<.t.<.,.IXZ L.0.YXZ LXZXZ.0Xs.!.I.I.,XZXZXZXZXZ b bXsX9.I.!XZ.I.Y._.)XkXZ.I b L.<.0 L b L.y b b.)XAX@.,XZXmX@ bXZ.I.)Xs b b LXZ b b._ LXA.t g.*.<XAX@X@X<.=X@.= g.a.0._.0XZXZ.,.I.I.P.PXs.!X9XsXZ.P.!.! b.I &XZ.Y._ d._.I.!XZXZXZ._._.!XZ.P.,.<.,.b F.}.a.a.a gX< v.b.b.b.G I f.).I.!XA.I.I.,.IXZ._.,XZXZ.Y.t.Y.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T a.)Xm.).IXkX9.I b L bX9X9Xs.) b b bXkXsXs L bXs b.IXk L.aX+.3.*.= g.I bXZX+ b. .)XA.<XA.I.I L L LXAX@ gX@.*XA.aXmX@ g._ 4XZXAX@ b b |.Y.P.).)._.!XZ bXZ.].! 1.!.I.,.IXZXA dXZ 1Xs.I.<Xs.Y.<.I bXZ.IX9 |Xl.}.}XAX@.)._._XC.} f f I F F 1 bXZXZXZ b.,.!XZXZX9X9X9.&.<._.^XZ.)Xs.,.I.I.!.P.IX X .PXs.PXs.P.PX9X9.P.P.<._.IX  )X9.,.IXZ.P.P.!.!X X .P b._.,._ |.I.!XZ.^XsXZ.<.I.P._ 8X .P )X X9X9.P.IXZXC 8.P.PX X X .PX X .IX X .P.PXZXAXmX@.b.a._X@XZXZXA.!XZXZ.!XZXZX@ d.a.0XZXZX9 b.PXs.)XAXZXA.)Xm.).IXkX9.I b L bX9X9Xs.) b b bXkXsXs L bXs b.IXk L.aX+.3.*.= g.I bXZX+ b. .)XA.<XA.I.I L L LXAX@ gX@.*XA.aXmX@ g._ 4XZXAX@ b b |.Y.P.).)._.!XZ bXZ.].! 1.!.I.,.IXZXA dXZ 1Xs.I.<Xs.Y.<.I bXZ.IX9 |Xl.}.}XAX@.)._._XC.} f f I F F 1 bXZXZXZ b.,.!XZXZX9X9X9.&.<._Xs.^XZ.)Xs.,.I.I.!.P.IX X .PXs.PXs.P.PX9X9.P.P.<._.IX  )X9.,.IXZ.P.P.!.!X X .P b._.,._ |.I.!XZ.^XsXZ.<.I.P._ 8X .P )X X9X9.P.IXZXC 8.P.PX X X .PX X .IX X .P.PXZXAXmX@.b.a._X@XZXZXA.!XZXZ.!XZXZX@ d.a.0XZXZX9 b.PXs.)XAXZXA.)Xm.).IXkX9.I b L bX9X9Xs.) b b bXkXsXs L bXs b.IXk L.aX+.3.*.= g.I bXZX+ b. .)XA.<XA.I.I L L LXAX@ gX@.*XA.aXmX@ g._ 4XZXAX@ b b |.Y.P.).)._.!XZ bXZ.].! 1.!.I.,.IXZXA dXZ 1Xs.I.<Xs.Y.<.I bXZ.IX9 |Xl.}.}XAX@.)._._XC.} f f I F F 1 bXZXZXZ b.,.!XZXZX9X9X9.&.<._.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T a. .0.I b.I b.I.IXZ.P bXsX9 L b.IXs b bX9 b L.I b.) bXAX$X<.*.b.a.a b b bXZ LXAXA.*X@XA bX..) L L LXA.*.b.a._XAXAXA s.0XAXA bXA bXZ.Y.I.!.I bXZ.0.).I.! sXm 0.!Xm.t.!. ., d., b.!.;XCXZ.0._XZXC 0 |.P.I g.b f.a._ LXC 0.<._._Xl F f.b I.Y.I.)._XZXm.0XZ.).P b.^ :XC.YX9.PXZXZ._XZ | |.!.PXsXs.IXs.I.!.IXs.PXs.PXsXZ 0.<XZ.I.!.P.!XAXsX9.P.PXs.P.P.,._.IXZXZ.YXZ.P.IXm.;XC.t.! &.^X9X .P.P.^X9 ).P.! |X9Xs.PX .V.VX X X .IX9X9X9.!XZ.<XC._.<.Y.a.t.0._.!XZ |XZXZXAXZ._._.Y._.).I.I b.P.P b._XAXA. .0.I b.I b.I.IXZ.P bXsX9 L b.IXs b bX9 b L.I b.) bXAX$X<.*.b.a.a b b bXZ LXAXA.*X@XA bX..) L L LXA.*.b.a._XAXAXA s.0XAXA bXA bXZ.Y.I.!.I bXZ.0.).I.! sXm 0.!Xm.t.!. ., d., b.!.;XCXZ.0._XZXC 0 |.P.I g.b f.a._ LXC 0.<._._Xl F f.b I.Y.I.)._XZXm.0XZ.).P b.^ :XC.Y.IX9.PXZXZ._XZ | |.!.PXsXs.IXs.I.!.IXs.PXs.PXsXZ 0.<XZ.I.!.P.!XAXsX9.P.PXs.P.P.,._.IXZXZ.YXZ.P.IXm.;XC.t.! &.^X9X .P.P.^X9 ).P.! |X9Xs.PX .V.VX X X .IX9X9X9.!XZ.<XC._.<.Y.a.t.0._.!XZ |XZXZXAXZ._._.Y._.).I.I b.P.P b._XAXA. .0.I b.I b.I.IXZ.P bXsX9 L b.IXs b bX9 b L.I b.) bXAX$X<.*.b.a.a b b bXZ LXAXA.*X@XA bX..) L L LXA.*.b.a._XAXAXA s.0XAXA bXA bXZ.Y.I.!.I bXZ.0.).I.! sXm 0.!Xm.t.!. ., d., b.!.;XCXZ.0._XZXC 0 |.P.I g.b f.a._ LXC 0.<._._Xl F f.b I.Y.I.)._XZXm.0XZ.).P b.^ :XC.Y.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T a.0XAXZ.I.I bXZ.I b b b bX9X9.I.) L L.I b.yXkXZ.).)XAXAX$ f.b._XZXA b.IXZ L 4 g c.b f L L L LXZXm.*.* g.b gXAXAXA._XAXAXA s 4._XZXZ.,XZXZ.I.I.!.,XZ.IXZXZ.<.<.,XZ._.Y._ 0._._.IX9._ 0.<.Y 0.< 0.Y.!.!.I.*.= g.* g.0XCX6X@.0._ v f g.a I.G.}.EXZ._XA.)XZ. XZXZ 1.,XC.,Xs bXZ.IXZ.I.IXs.P.PX .P.!.^.I.,.!.PXs.P b.P.0._., 0XZ., L._XZ.PXsXZ.IXsX  b.Y._XmXZ.t.0.!.I.! F.G.Y &.!XsX9 ) ).PXs )X9X9.! &X9XsXs )X X X X X X .IXsXsX XsXZ.<._XZ.,._.t f._XZ.0._.,.!.I.,XZ.,._.I._ g.!.!.PXs.I b.,XZXA.0XAXZ.I.I bXZ.I b b b bX9X9.I.) L L.I b.yXkXZ.).)XAXAX$ f.b._XZXA b.IXZ L 4 g c.b f L L L LXZXm.*.* g.b gXAXAXA._XAXAXA s 4._XZXZ.,XZXZ.I.I.!.,XZ.IXZXZ.<.<.,XZ._.Y._ 0._._.IX9._ 0.<.Y 0.< 0.Y.!.!.I.*.= g.* g.0XCX6X@.0._ v f g.a I.G.}.EXZ._XA.)XZ. XZXZ 1.,XC.,XZXs bXZ.IXZ.I.IXs.P.PX .P.!.^.I.,.!.PXs.P b.P.0._., 0XZ., L._XZ.PXsXZ.IXsX  b.Y._XmXZ.t.0.!.I.! F.G.Y &.!XsX9 ) ).PXs )X9X9.! &X9XsXs )X X X X X X .IXsXsX XsXZ.<._XZ.,._.t f._XZ.0._.,.!.I.,XZ.,._.I._ g.!.!.PXs.I b.,XZXA.0XAXZ.I.I bXZ.I b b b bX9X9.I.) L L.I b.yXkXZ.).)XAXAX$ f.b._XZXA b.IXZ L 4 g c.b f L L L LXZXm.*.* g.b gXAXAXA._XAXAXA s 4._XZXZ.,XZXZ.I.I.!.,XZ.IXZXZ.<.<.,XZ._.Y._ 0._._.IX9._ 0.<.Y 0.< 0.Y.!.!.I.*.= g.* g.0XCX6X@.0._ v f g.a I.G.}.EXZ._XA.)XZ. XZXZ 1.,XC.,.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.7XZ.0XZ. XZXZXZ.)XZ.IXs bX Xs.P.P b b L.0 bXAXk b._.)Xz f.}.,XAX@X< b b.  LX@.b f.=Xl.tXA L LXAXA.t g gX<.*XA.0 LXA.0XAXZXA.I bXZX@ v.I.IXsXs L._.,XZXZXZ._.tXZXZXZ.<XZ.P.YXC.0 v.]._XZ.I b.P.! 1XsX9 L._XZ L. XAXA 0.YXAXZXZ v.,.YX@.<._ F I I.}.<XA._.)XZXA.YXZ 0.,.bXmXZXZ L.)XmXZXZXA.).*X@.0XZXZXZ.IXZ.PXs.PXAX@.t.,XZ.!XC.,.,.P b.!.IX@.!Xs.t 0._XC 0.<.,.YXm.<.I | | :.P.PXs.P.!.YXsX9.P.UXsXZXsX X9.PX X  )X X X9Xs b b.,.<._Xm. .Y s._ vX@XmXZ.!XZ.0._._ f 0.0.,._._.< f.< bXs b b b bXZ.0XZ. XZXZXZ.)XZ.IXs bX Xs.P.P b b L.0 bXAXk b._.)Xz f.}.,XAX@X< b b.  LX@.b f.=Xl.tXA L LXAXA.t g gX<.*XA.0 LXA.0XAXZXA.I bXZX@ v.I.IXsXs L._.,XZXZXZ._.tXZXZXZ.<XZ.P.YXC.0 v.]._XZ.I b.P.! 1XsX9 L._XZ L. XAXA 0.YXAXZXZ v.,.YX@.<._ F I I.}.<XA._.)XZXA.YXZ 0.,.=.bXmXZXZ L.)XmXZXZXA.).*X@.0XZXZXZ.IXZ.PXs.PXAX@.t.,XZ.!XC.,.,.P b.!.IX@.!Xs.t 0._XC 0.<.,.YXm.<.I | | :.P.PXs.P.!.YXsX9.P.UXsXZXsX X9.PX X  )X X X9Xs b b.,.<._Xm. .Y s._ vX@XmXZ.!XZ.0._._ f 0.0.,._._.< f.< bXs b b b bXZ.0XZ. XZXZXZ.)XZ.IXs bX Xs.P.P b b L.0 bXAXk b._.)Xz f.}.,XAX@X< b b.  LX@.b f.=Xl.tXA L LXAXA.t g gX<.*XA.0 LXA.0XAXZXA.I bXZX@ v.I.IXsXs L._.,XZXZXZ._.tXZXZXZ.<XZ.P.YXC.0 v.]._XZ.I b.P.! 1XsX9 L._XZ L. XAXA 0.YXAXZXZ v.,.YX@.<._ F I I.}.<XA._.)XZXA.YXZ 0.,.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T C f v.IXZXA.0XZXZ L i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i bXk.tXAXA.hXA.=.}.0Xm b.*.bXAXzX@Xz 4Xl.b.}.G.b fX@XAXAXA.a g.a 4.=X@XZXZ._XZ.)XZ._X9.I.P.IXZXZ bX9X9XZXA._XAXZXA._X@XZ.,.!.I.P.!.,.I. XZ._XZX9Xs.I | |.I.!.I.tX@ L bXA.0XZ._.*.bXA.t.}.!Xs g.IXZ f I I I.;._XA M._.Y._.,Xm._XlX<X<.) 4X<Xl.b.<X<X@XZ.,._XZXZ.!.,.)XZ.,XZ.)XAXA 4X@.0.)XZXZ.,.I.I.,.E 0.I.I.,XC.0._XA.!X@.Y.<.].!Xs.P 8XsX9X X9Xs.P.I 1 | |Xs.IX9X XsX9.VX X X X Xs.IX9X9XZ.,._._XA.,._._ d.0._.IXZ.0.0XmX@.a._.,Xs.)XA.0Xm.<XZXAXZ bXm.a f v.IXZXA.0XZXZ L L.) bX9.IX9X9Xs LXs bXk.tXAXA.hXA.=.}.0Xm b.*.bXAXzX@Xz 4Xl.b.}.G.b fX@XAXAXA.a g.a 4.=X@XZXZ._XZ.)XZ._X9.I.P.IXZXZ bX9X9XZXA._XAXZXA._X@XZ.,.!.I.P.!.,.I. XZ._XZX9Xs.I | |.I.!.I.tX@ L bXA.0XZ._.*.bXA.t.}.!Xs g.IXZ f I I I.;._XA M._.Y._.,Xm._.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.] v f._.) b. XAXZ.) i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXZ.I C.h.=.*XA gX@.*.aXzXl.b.b.<.a.tX$Xl.} f f f.b vXA.*X@XAXAXAXA.*.<XAXm.0XZ._XZ._ b.I.P )X9.,.Y., bXZ.,XZ._X@X@.t.t.I.!.I._.,.! b.IXsXs.IXZX .!.,.!.I.I.!Xm.0XAXA L bXZ.Y.)XA.a.* g.*.I.,.<XZ._.<.}.G f f.}.,._., &._.,XZ.,.t.<.,XZXm._X@X@XZ.,XZ._XZ., 0XZ._.IXs LXAXAX@ 4X@ 4X@XmXZ.I.! b.I bXZ.P.!.! bXZ 0._._.0XZ.Y 0.a.<.I.!.!X9.PXsX Xs.I b.!.Y.) b.,.!Xs.IXsX X X X XsXsX9.I b.IXZ.Y._._.t.Y &., gXAXAXmX@XZ.a fXN.,.I.!.!XAXZXZ.,XA._._., f.} d v f._.) b. XAXZ.) b.I.IXsXsXk.I.I b.)XZ.I C.h.=.*XA gX@.*.aXzXl.b.b.<.a.tX$Xl.} f f f.b vXA.*X@XAXAXAXA.*.<XAXm.0XZ._XZ._ b.I.P )X9.,.Y., bXZ.,XZ._X@X@.t.t.I.!.I._.,.! b.IXsXs.IXZX .!.,.!.I.I.!Xm.0XAXA L bXZ.Y.)XA.a.* g.*.I.,.<XZ._.<.}.G f f.}.,._., &._.,XZ.,.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T 0.,XZ._.<.a.t.  bXk i i i i i i i i i i i i.A i i i i i i i i i i i i i iX8 i i i i i i i i i i i i iX8 i i i i i i i i i i i i iX8 i i i i i i i i i i i i i e i i i i i i i i i i i i i i.A i i i i i i i i i i i i i iXo i i i i i i i i i i i i i.A i i i i i i i i i i i i i S i i i i i i i i i i i i i.A i i i i i i i i i i i i i iX8 i i i i i i i i i i i i i.@ i i i i i i i i i i i i i i S i i i i i i i i i i i i i e i i i i i i i i i i i i iX8 i i i i i i i i i i i i i iXo i i i i i i i i i i i i i.A i i i i i iXZ b g.b.*.b.<.* g s._.)XZ. .h.* f.}.} f.}.}.}X@XA L.h g._ L bXA.)XAXA.<X@.0., LXA._XZ LXZ.IXZ.!XZ bXZX@.t s.<XC s._.a 0XZ._.,XmXZ.!.,Xs.^X .P.P.P.PXsX Xs b.I.  b b m.,XC._XZXZ.! f.} f d._._._._.! f.}.}.} F.t.nXwX@ g.<.< 8.0.* gXl f i.G F.}.bX@ 0XZXZ bXZ._._XC.,XZXZ gXZXZXA g.aXlXA.).) 4 g.,.!XZ.IXZX@.<X@X@._ | 1.P.P._.< b.PXs.PX Xs.IXZ.,.!XZ.PXs bXA b.PXs.qX X9X9Xs.PXsX9XZX9 bXZ bXs.IXZ.).I.bXl.a.t._.0XZXA.,.Y bXZXZ.*X@XA._._.tX@._.! v 0.,XZ._.<.a.t.  bXk L.).IXZXZ.IXZXZ bXZXZ b g.b.*.b.<.* g s._.)XZ. .h.* f.}.} f.}.}.}X@XA L.h g._ L bXA.)XAXA.<X@.0., LXA._XZ LXZ.IXZ.!XZ bXZX@.t s.<XC s._.a 0XZ._.,XmXZ.!.,Xs.^X .P.P.P.PXsX Xs b.I.  b b m.,XC._XZXZ.! f.} f d._._._._.! f.}.}.} F.t.nXwX@ g.<.< 8.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T sXZXZ.0XA._.<._XZXZ i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.) b d.< 4 g.a 4.a bXZXZXA 4.<.0 L LX@.a.} f.b 9.<._X<X@ L L LXZXAXA.*._.0XmXA.t._XZ LXZ.0.&.)._.0Xm._._X@._.,._._._ g.}._XZXZ.<._ b b bX9 ).P.q bXZXs.PX9Xs b bXk b L & 0X@XA.I.P._.}.} v.} 0 0.Y., f F F F.}.t.n.]._.<.<.<XC.< f.}.} F I.G.G F.G.}. XAXmXm.0.)XZ.I LXAX@.<XZ.0._X@ gX<XAXAXZX@X@XZXAXZ b MX@._XAXZ.,.PXsXZ bXA.,.!X X9X9.P.I.I &.,.!.I.I.I b.) b bX9X9XsX .!.PX9 bX9.P.PXZ., b.IXZ.I b.*.b.<._X@._XZXZ.0XZ._.,XZXZXA.0._X@XA.0._._.t f.<XZXZ.0XA._.<._XZXZ. XZ LXZXZXZXZ.I.I b.) b d.< 4 g.a 4.a bXZXZXA 4.<.0 L LX@.a.} f.b 9.<._X<X@ L L LXZXAXA.*._.0XmXA.t._XZ LXZ.0.&.)._.0Xm._._X@._.,._._._ g.}._XZXZ.<._ b b bX9 ).P.q bXZXs.PX9Xs b bXk b L & 0X@XA.I.P._.}.} v.} 0 0.Y., f F F F.}.t.n.]._.<.<.<XC.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.]XZXAXA._XZ.IXZXZ._ i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.IXSX9.B.y.)X@.b.aXA L._XA._XZ. XA L.hXAXAXA b.) LXZ f.aXAXAXAX+X@XAXZXZ.)XAX@X@XAXZ L L v vX@.*XmX<.;.<._._.!XsXAXm v.b.<.,.IXZ._._._XZX9.qXsX%Xs.!.I bXZ L.I.IXA LXZ 0.<.)XA.!.!._ d.a.b f._ f._X@.}.b.}.} f.n f f.< f f.a.b f f.}.} F I I.G.G.G F.=Xl.b.a.tXmXZ b.)XZX@.a._XmXA.!.0.tXAXZ b v d.)XA P.=X<.aXm._.! b._.I.!._.<.!.PXs bX Xs.P |.!.!.I.I b b.IXZ.).IXsXsX9Xs.^X9X9X9X  b bXZXZXsXZXZ LXZ.a.<XZXAXA.,XZXZXA._._.0.0 bX@XA._._._X@X@.,.a.t.]XZXAXA._XZ.IXZXZ._XA.)XZ.) b b bXsXAXAX@XA.) L.hX<Xl.b.aXA L._XA._XZ. XA L.hXAXAXA b.) LXZ f.aXAXAXAX+X@XAXZXZ.)XAX@X@XAXZ L L v vX@.*XmX<.;.<._._.!XsXAXm v.b.<.,.IXZ._._._XZX9.qXsX%Xs.!.I bXZ L.I.IXA LXZ 0.<.)XA.!.!._ d.a.b f._ f._X@.}.b.}.} f.n f f.< f f.a.b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.].I.)XZ.I.IXZ.I b b i i i i i i i i i i i iX8 i i i i i i i i i i i i i iX8 i i i i i i i i i i i i i.@ i i i i i i i i i i i i iXo i i i i i i i i i i i i iX8 i i i i i i i i i i i i i i.@ i i i i i i i i i i i i i iX8 i i i i i i i i i i i i iX8 i i i i i i i i i i i i i S i i i i i i i i i i i i iXo i i i i i i i i i i i i i iX8 i i i i i i i i i i i i iX8 i i i i i i i i i i i i i iXo i i i i i i i i i i i i i.A i i i i i i i i i i i i iX8 i i i i i i i i i i i i i i e i i i i i i i i i i i i i e i i i i i i.f.f.f.f.f.f j.<.*.0 LXA b b.tXAXA.t g.0.,.,XZ.P.) L.t.*Xl.a v.<.<X@.t.*XAXZXAX@ 4X@X@XZ.*XAX@.}.t.a.a._X@._._XA.,.& 0 |._._.<.,XZ.0XAXZXmXZX9.I.&.<X$ gX@._.I b b.,.,.!XZ.0.,.!.0.<.].<._.IXm.a.<._ f f.b v._X<.a._.! v._._.G.} f.b f f d.W F.} F.G.G I I I.GXm.&.IXZXZ 4X@.,XZ.!._X@XAX@._ 4X<.*._. XZXA gXA LX@.I.!.t s.I.,.PXZXs.P.P.I.PXZ.I bX .!.P.IXZXZ bXsXsXs.I b.I bX9X X9Xs.^.I b b.!.)XZ.b._.,., bXZXZXZ.0.)XAXZXZXZ L.,XZ.bXA.0XZXZ.)XZ.<.<XN.I.)XZ.I.IXZ.I b bXm 0XZ LXAXZXZ b L. ._XZ LXsXA.h g.<.*.0 LXA b b.tXAXA.t g.0.,.,XZ.P.) L.t.*Xl.a v.<.<X@.t.*XAXZXAX@ 4X@X@XZ.*XAX@.}.t.a.a._X@._._XA.,.& 0 |._._.<.,XZ.0XAXZXmXZX9.I.&.<X$ gX@._.I b b.,.,.!XZ.0.,.!.0.<.].<._.IXm.a.<._ f f.b v._X<.a._.! v._._.G.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T._.Y bXZXZXZ.,XZXZ.) i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.f.f.f.f.f.f.IXzX@ L mXA 4 LXA 0XZ.]._XZXZ b b mXAXzX<.= g.aX@._ d f d.a._XZX@.tXA LXAXA.a._XA f.b d.b.<.t M._.,.,.PXsXZ._.,.I.!.P.I LXZXZ.IXsXsX@ f.bXlX@X@.! b.Y.,.!.I.P.P.IXZ.! d.I.IX .IXA.t 0.! f f v.0.= fXA.,.Y.Y.!., F.b d.b f.} d.<.t F.G.G.G.} F f.G.}._XZ.!.I._ 0 b.).IXZ._ 0._._._._X@.=X@XmXZ fX@ bX@X+.!.<XC.P.I.I.I.PX9 b 1.Y fXZ.PXs.PXs.P.!.I.P bX9 b.P b bX9XsX9X X9XsXZXAXZ b b.IXN.Y._XZXZXA.)XZXZ.)XZ.).)XZXZXZ.0._XAXZ.0XZ L LXZ._._.Y bXZXZXZ.,XZXZ.).)XZXZ._.*XZ LXZXm._.I.)._XmX@.tX@XzX@ L mXA 4 LXA 0XZ.]._XZXZ b b mXAXzX<.= g.aX@._ d f d.a._XZX@.tXA LXAXA.a._XA f.b d.b.<.t M._.,.,.PXsXZ._.,.I.!.P.I LXZXZ.IXsXsX@ f.bXlX@X@.! b.Y.,.!.I.P.P.IXZ.! d.I.IX .IXA.t 0.! f f v.0.= fXA.,.Y.Y.!., F.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX@.<., b.) L b.)XZ b iXo i i.A i i.c i i e i e i i < i iXo i i.c i i.c i i.c i.c i i e i iX8 i iX8 i iX8 i iX8 i i.@ i e i iX8 i iX8 i iX8 i i.c i i e i e i i.A i i.c i i.A i iXo i i i < i e i iXo i i.A i i.c i i e i iXo i i i i.A i i e i i e i i < i iXo i iXo i.A i iXo i i.c i i < i i < i i.A i i i i e i i e i iXo i i e i iX8 i iX8 iXo i iXf i iX8 i i.@ i i S i iX8 i i e i iXo i i < i iXo i iXo i iXo i i i iXo i iX8 i iXo i i e i i e i iXo iXo i iX8 i i S i iX8 i i S i i e iX8 i i S i iXf i iXo i i.@ i iXo i iXi.f.f.f.f.f.fXS 4XA L b.*XA bXA.Y.).,XZXA.0.)XA 4.*.a.* gXl._XA._ g.<._X@.Y.0.t g.a. XAX@.<.<XC.b d.<._.< g._XZXZ.I b.!.I.!.!.I bX .P b.I.)X9 ) bXA.* f.a.t b.I. .,XZ.I.!XsX9Xs.I.! 0.P.PXsXs._._._ &.b f.tX@ f dXAXZXZ.Y.!.I f.}.b.}.} f.Y.<.b.<.}.G.G f.}.b f.GX<.!.0 b bXZ.) b b.!.0XZ.I.I b.!XA g.aX<.0._X@ b b.h.).PXZ.P ).P.IXZ.I.&XZ.b.<.PXsX9Xs.,.I b.PX9.P bXs b.IX9Xs.IXsXsXk LXZX@.0.IXZXA sXmX@.0.I b b.)XZXZXZ bXZXZXZXZ._.0X@XmXZXA.0XZXA._X@.<., b.) L b.)XZ b. XZ.).0XAX@._.<.].I.  bXA.t.<XAXA 4XA L b.*XA bXA.Y.).,XZXA.0.)XA 4.*.a.* gXl._XA._ g.<._X@.Y.0.t g.a. XAX@.<.<XC.b d.<._.< g._XZXZ.I b.!.I.!.!.I bX .P b.I.)X9 ) bXA.* f.a.t b.I. .,XZ.I.!XsX9Xs.I.! 0.P.PXsXs._._._ &.b f.tX@ f dXAXZXZ.Y.!.I f.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.v._XZ.I.,.,XZXZXZ.)X=XyX=X=X=X=X=X=X=X=X=X=.#X=X=.#X=X=X=X=X=XyX=X=X=X=X=X=X=XyX=X=X=X=X=X=X=X=X=X=X=XyX=X=X=X=X=X=X=X=X=X=XyX=X=X=X=X=X=X=XyX=X=X=X=X=.#X=X=X=X=X=X=X=XyX=X=X=X=X=X=X=.#X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=.#X=X=X=X=X=X=X=X=X=X=.#X=X=.#X=X=X=XyX=X=X=X=X=X=X=X=XyX=X=X=X=X=X=X=X=X=X=X=XyX=X=.#X=X=.#X=X=.#X=X=X=X=X=X=X=X=X=X=X=X=X=X=.#X=X=.#X=X=X=X=X=X=.#X=X=X=XyX=X=XyX=X=.#X=X=X=X=X=X=X=.#XyX=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=.#X=X=X=.f.f.f.f.f.fXs._ L LXzXAXZXZ |.)XZXmX@XA b b bXZXAX@X@.a.< b b LXAXZXZXZ.t.aX@.tX@._XAXZ g g fXAXm.)XZ._.0XZXZXZXs.P.P.I.!.,.I b.!XkXA.,.IXsX9Xs b._X@X@.tXZ.t v., bXZ.!.IXZ M 0XZ ).I.!.IXm.].IXZ M.] g.b.b.}.tXZ.YXZXC.<.a.}.}.}.}.b.<XZ.h g d f.W f f.b F.}.}.b.G.a._.t g.< g.*XZ.,XZ.! LXsXZ b.I LXZ._XZX@.bXZ.I.*._.,XZXZ.IXZXj.Y., d.,.P.PX .P.!X9XsX9Xs.IXsXsX9.I b.I.PX9X9 LXl.t.0 g._XZ.* qXZX@.,XZ b.I.)XZ.,.IXZ.)XZ., b._.0._.<X+XZXZ.,XmXZ._.,._XZ.I.,.,XZXZXZ.) b.)XZXCXyX2.n._.Y.,XZ.).! 0.IXAXm._ L LXzXAXZXZ |.)XZXmX@XA b b bXZXAX@X@.a.< b b LXAXZXZXZ.t.aX@.tX@._XAXZ g g fXAXm.)XZ._.0XZXZXZXs.P.P.I.!.,.I b.!XkXA.,.IXsX9Xs b._X@X@.tXZ.t v., bXZ.!.IXZ M 0XZ ).I.!.IXm.].IXZ M.] g.b.b.}.tXZ.YXZXC.<.a.}.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXrX@._.!XZXZ._XA._.).e.eXa.e.eXH.e :.e.eXH.e.eXa.e.eXH.e.e.e.e.e.e.e.e.eXH.e.e.e.eXH.e 5 *XH.e.e.eXH.e.e.eXH.e eXo D.eXaXH.e.e.e.e.e 5.e.e.e.e.e.e.e.e.e.eXa.eXHXH.e.e.e.e.e.e.e.e.eXH.e.eXH.e.e.eXH.e.e.e.e.eXH.e.e.e.eXH.e.e.eXH.eXH.eXH.e.eXH.e.e.e.e.e.e.e.e.e.eXa.e.e.eXH.e.e.e.e.e.e.eXa.e.e.e.e.eXa.eXH.e.e 5.e.e.eXH.e 5.e.eXH.e.e.e.e.e.e.eXa.e.eXa.e.e.e.eXa.e.e.e.e.e.e.e.e.e.e.e.eXaXoXoXoXoXa *.e.e.e.e.e.e.e.e.e.e.e.eXa.eXa.e.e.e.e.e.e.eXa.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.eXa.e.e.e.f.f.f.f.f.fXq LXz LXZ.,.).I b bXAX@ d.*XAXZ bXAXA L b LXZ.). XZXZ. XZ._.a._X@X@._.*.t.t v.b.t v.<XAXmX@.!.! |XsXs.Y.P._ &.! b.I.I.  b L.I b.P.I.I b bXmX@.a d.].)XZXZ.Y._._.0.!XZ.P.!.,.!.<.<.&.Y.<.<._.b.a.<.,.I 1.!.YX@ f F.} f f.} qXl.<XZ._._._ f 0.<.}.}Xl f f FXm._ 0.a.b.bXZ.! b.I.0XsXs LXA.,._XZ.IXZ.<XAXA._Xl 4XZ.,.IXZ &._X@XC.I.PX9X9.P.I.PXs.P.PXs b.IXsXs.I bXs b bX<.a.tXZXZ.0XAXl vX@ vXZ.<XZ.I bXZ.,.,XZ.IXZ.!XZ.IXA.0XZ. .IXZXZ.0X@._XZX@._.!XZXZ._XA._.) b b.Y F IX7.W.n., L.!.I bXAXkXZ.I LXz LXZ.,.).I b bXAX@ d.*XAXZ bXAXA L b LXZ.). XZXZ. XZ._.a._X@X@._.*.t.t v.b.t v.<XAXmX@.!.! |XsXs.Y.P._ &.! b.I.I.  b L.I b.P.I.I b bXmX@.a d.].)XZXZ.Y._._.0.!XZ.P.!.,.!.<.<.&.Y.<.<._.b.a.<.,.I 1.!.YX@ f F.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXrXZ._XZXZXZXZXZXZ L.e.e.e.e.e.e.eXa.e.e.e.eXo.e.e.e.e.e.e.e.e.e.e.e.e.e.eXo.e.e.e.e.e.e.e.e.eXH.e.e.eXoXa *Xo.e.e.e D *.e.e.e.eXa.@.e.eXa.eXa.eXH.eXa.e.e.e.eXo.e.e.e.e.e.e.e.eXH.e.e.e.e.eXo.e.e.e.eXH.e.e.e.e.e.e.e.e.eXoXH.e.e.e.e.e.e.e.e.e.e.e.eXoXH.e.e.eXa.e.e.eXa.e.e.e.e.@Xa.eXa.e.e.e.eXa.e.e.e.e.eXo.e.e.e.e.e.e.e.e.e.e.e.e.e.eXo.e.e.e.e.e.e.eXH.e.e.e.e.eXoXH.e.eXHXa.e.eXH.e.e.c.e.e.e D.AXa.e.e.e.eXa.eXa.e.eXa.eXo.e.e *XH.e.e.e.eXa.e.e.e.eXoXH.eXa.eXH.e.eXH.eXa.e.eXa.e e.e.e.eXH.e.e.e.e.eXa.eXH.eXoXH.e.e.e.e.e.f.f.f.f.f.f JXZXmXZXZ.IXsX.Xs L.,XAX@._XzX@., LXZ.,.I LXZX@XAXA LXAXAX@X@.t.<.t.t._XAX@.b.a._._._XZ._ v.,.I.PXs.P.I 1.!X9.I |XZ.!.).I L L._ b bXA._.I.hXA.a.aXC b.!.IXZXZXZXZ._.<.I.!XZ.,Xm v &._.< f.a f fX@.<XZ 0 s.a f f f f f.b f F v.<X@.*.*X@.0.I.I._.}.G f f.} gX<XZ._.<.a.*X@XZXZ.I.)Xs.IXAXAXZ.I b.I b.I.,.I.}XlX@XmXZ bXAX@XA._.).PXs b 8.P bXsXsX9X9Xs.IX9.I b.I.I.I bX@._._.) b.  f f.,X@XNXZ.0 0._ b.).).,XZXZ.IXZ.,XZ.,XA.)XZ bXZXZ._XZXZXZXZ._XZXZXZXZXZXZ L bXZ &.nX7XCXC.n |.IXs.IXZXA. .,XkXZXmXZXZ.IXsX.Xs L.,XAX@._XzX@., LXZ.,.I LXZX@XAXA LXAXAX@X@.t.<.t.t._XAX@.b.a._._._XZ._ v.,.I.PXs.P.I 1.!X9.I |XZ.!.).I L L._ b bXA._.I.hXA.a.aXC b.!.IXZXZXZXZ._.<.I.!XZ.,Xm v &._.< f.a f fX@.<XZ 0 s.a f f f.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXrXmXAXA L.h L.*.tX7.e.e.eXa.e.e.e.eXa.e.e.e.eXa.e.e.eXH.e.e.e.eXa.e.e.e.e.e.e.e.e.e.eXH.e.e.e.e.eXa.e.e.eXo.eXoXo D.eXo.eXaXa.e.e.e.e.e.e.e.e.e.e.e.e.eXH.e.eXH.e.eXa.eXa.eXH.e.e.e.e.eXa.e.eXa.e.e.e.e.eXH.e.eXa.eXH.e.e.e.e.e.e.e.e.eXa.e.e.e.e.e.e.e.e.eXa.e.e.e.e.e.e.e.e.eXa.e.e.e.e.e.e.e.e.e.eXa.eXH.e.e.e.eXa.e.eXa.eXH.eXa.eXH.eXH.e.eXH.eXa.eXH.e.e.eXa.eXH.e.e.eXH.e.eXH.eXH.eXH e e e.cXH.e.e e.eXH.eXH.e.e.e.eXa.e.e.e.e.eXa.e.eXH.e.e.e.eXH.e.e.e.e.e.e.e.e.eXa.e.e.e.eXH.e.e.eXa.e.e.e.e.e.eXH.e.e.e.e.e.e.e.eXa.e.e.e.f.f.f.f.f.f.BXZ 0XZXZ.!.,XZ bXZ b LXZXAXZ.IXZXZXZ.,._._.*X@.<._._._._X@ g.aXAXA.0.,Xm._X@.b._._.*._XZ.IXZ.P b.,.PXsXs.P.I.!.PX9.!X9.PXZ.0._XZXZXZ.t g.<.< v v v., b.!.I.!XZ._XZ.<.IXZ b.!.!X@.}X2.; M.0.G.Y.< f f.}.bXN F F.G.G F f F F f.t.t 0._.I.)XZ b.) g g.*.*.b g.< f.= L bX@._.<._X+ LXZXZ.)XA._X@XA. XZ bXsX9 f.bXl.b fXl.t._._.I bXsX9X XsXs.P b.I.IXsXs.I.I b b bXA.0XAX@.t.)XZ.)XA._.0.!.,Xs bXZ.)XZ LXZ L.I b bXZ.IXZ.! LXZXZXA.IXZXZ.0.0.Y.)XmXAXA L.h L.*.tX7Xy.n.Y._ &.IXm.,.Y.) bXA.)XAXZ.) LXZ 0XZXZ.!.,XZ bXZ b LXZXAXZ.IXZXZXZ.,._._.*X@.<._._._._X@ g.aXAXA.0.,Xm._X@.b._._.*._XZ.IXZ.P b.,.PXsXs.P.I.!.PX9.!X9.PXZ.0._XZXZXZ.t g.<.< v v v., b.!.I.!XZ._XZ.<.IXZ b.!.!X@.}X2.; M.0.G.Y.< f f.}.bXN F F.G.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXr.)XzXA.*.=.* f.} F.eXa.e.e.e.eXa.e.e.eXHXa.e.eXHXaXH.e.eXaXH.e.eXH.eXaXH.eXaXH.eXH.e.eXaXHXa.eXH.e.eXH e.e.e.e e.eXH.eXo.e.e.eXH.eXaXa.eXH.eXHXHXH.eXH.eXH.eXH.eXH.eXH.e.eXH.eXH.eXH.eXH.e.e.eXH.eXaXH.eXH.eXH.eXH.e.eXHXa.eXHXHXa.eXH.e.eXHXa.eXH.eXH.e.e.eXHXHXaXHXH.eXH.eXH.eXa.e.eXH.eXHXaXHXHXH.e.e.e.eXa.eXa.eXH.e.eXa.eXH.e.eXa.e.eXHXa.e.eXH.e.eXH.eXH.e.eXH.e.eXa :.eXHXH.e.e.e e.eXH eXH.eXH.eXH eXa.e.e.eXaXH.e.eXa.eXaXH.eXH.eXa.eXHXH.eXa.eXH.eXa.eXH.eXHXa.e.eXH.eXHXa.e.e.eXH.eXa.eXaXaXHXa.eXa.eXH.eXHXa.eXH.eXH.e.e.f.f.f.f.f.fX9XZXZ.aX@XZ.Y.,.IXs.I.IXZXZ bXs b.I. .! bXZ.0XAX@.t.<.tXZ bXAX@.tXAXmXZ._ s._X@XZ.). XA b.&.YXs.PXs.PX9Xs bXZ.Y 1X X9 )XsXZ.0XZ L.)X@.t.<X@._.< v.<XA._.IXs.PX@.<._.,.!.!.!._._XC.} d.<._ d FXAXZ.< I I F I i.G I I I.G.G F f.b.<XZXZXZ._.Y.I.,._._ f fX@.} F f.} v 4.aX@.tXA.*.=XA.*.*XAXC.a.b.b.bXAXk L.< 0XA.b.a fX<XmX@ b.)._XsX9X9X9.I.I.P.PX9X9 b.I b.)XZXZXZ L.aXZ b.)XAXAXZ.)XZ.<Xs.I.I.I bXZ b bXZ.I.) b.! bXs.PXs.,.,Xs.!.I.IXZ LXZ.)XzXA.*.=.* f.} FX7.nXZ.IXs bX9 bXZ gXZX+ L.).I LXZXZXZ.aX@XZ.Y.,.IXs.I.IXZXZ bXs b.I. .! bXZ.0XAX@.t.<.tXZ bXAX@.tXAXmXZ._ s._X@XZ.). XA b.&.YXs.PXs.PX9Xs bXZ.Y 1X X9 )XsXZ.0XZ L.)X@.t.<X@._.< v.<XA._.IXs.PX@.<._.,.!.!.!._._XC.} d.<._ d FXAXZ.< I I F I i.G I.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T a.* v d.}.}.}.G.G FXaXaXaXaXaXaXHXaXaXHXaXH BXa.eXH.eXa.oXHXaXaXaXHXaXaXH.'XaXaXaXHXaXaXaXaXHXaXHXa.o R RXH.oXa RXaXHXa RXH.oXaXH RXaXaXaXaXaXaXaXaXaXHXaXaXH RXaXa.oXa.oXaXHXa.oXaXHXHXa.o RXaXH.oXaXaXaXa.oXaXHXaXa.oXH.'.oXaXaXHXaXaXaXaXaXaXHXHXa }.o.oXHXHXaXHXHXH.eXaXaXaXH }XaXH.eXHXa.eXa.eXaXHXa.eXa nXa.eXH.eXH.eXaXH.eXaXHXaXaXH nXHXH.eXa.eXH.e.eXH.eXH.eXH n.e.eXa.e.eXHXHXH nXH.e nXH.e.iXH.e.iXHXaXaXH.e.eXH.e.eXH u.eXa.eXaXH.eXa.eXH.e.eXHXH uXaXa.e.e.eXa.e.eXa.e.eXHXa.e ^.eXa.e.e.e.e.eXa.eXa.eXH.e <Xa.e.eXa.e.e.f.f.f.f.f.f.u.,XZ._ vXZ., | b b.I b.).) L LXZ b.I bXZ.I LXZXZXZX@XA.  b. XA.0X@X@ v._._XZXAXZXZ._._.IXZ.IX9X .! )Xs.I.P._ |.! b.I.I.!.I.)XZXA L gX2.< g g.t.aX@XZXm |XZXC M._.,Xm.!.Y & d.]XC.<XC.YX2 d.}.<.b f I I I I.G I.G F.G F.G.}.}.}._XZXZ.,.PX9Xs 0XZ L.bX< g F F.} d.;.a vX@X@Xl f f v v.a f._.t.W.}.}.a.* f LXkXZX< g f.b gXA.I b.!.I.P b b.I.PXs b b.I.)XZXZXZ.) bXZ.) C bXZXZXAX@.) bXA.) b b b b bXAXZ.).I b.) b.IXs.IXs.P.!XZ.PX9XsXsXZXAXA.* v d.}.}.}.G.G FX7.].,.I b bX. LXAX@ 4.=XAXAXZXZ._.,XZ._ vXZ., | b b.I b.).) L LXZ b.I bXZ.I LXZXZXZX@XA.  b. XA.0X@X@ v._._XZXAXZXZ._._.IXZ.IX9X .! )Xs.I.P._ |.! b.I.I.!.I.)XZXA L gX2.< g g.t.aX@XZXm |XZXC M._.,Xm.!.Y & d.]XC.<XC.YX2 d.}.<.b f I I I I.G I.G.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.Q I I I.G.} F F F FXaXaXa.o.oXa.oXa.o.o.oXa.oXa.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.#.o.o.o.o.o.o.#X3.#.o.RXy.oX3.RX3Xy.o.wX3.oXy.o.#Xy.oX3XyXy.oXy.oX3.#.oX3.#.o.oXy.oX3.oX3X3.#Xy.oXy.o.oXyX3.oXy.oX3.oX3.o.o.o.oX3.o.o.o.o.o.o.o.oX3.o.o.o.o.o.o.o.o.o.o.oXa.R $.o.o.o.o.o.o.oXa.o.oXa.o.oXa.o.o.oXaXa.o.oXaXaXa.oXaXaXa.oXaXa.oXaXaXaXaXaXaXaXaXaXaXH.oXaXHXaXaXaXa.eXHXaXaXaXHXaXa.eXH }Xa.o }XHXHXHXaXa }XHXH.eXaXaXa.eXHXaXaXaXaXHXH.eXaXHXaXaXHXaXa.eXHXa.eXHXaXaXaXHXaXaXHXaXa.eXH.eXa.eXHXaXHXaXHXaXHXaXHXaXaXaXa.eXHXa.eXH.e.f.f.f.f.f.fX9XZXZ bXZX@.YXZ 0.)XZ L bXZ b.I b._XZXZ b L.I.,.)Xs b L.tX@ g.*. ._XZXmX@._XZXZ. XZ.IXZXZ.&.PXZ._.!XsXs.I._ f dX@XA.t., 0._ LXA.<X@XCXy 0X@.<._.0._._ |XZ 0XZ.;XZ g.}.Y | LXCXC._Xw.0._.IXZ.,XC f f I.} F.G.} fXC f.} f f.a.tX@.t.I b bXsX9.I bXA.* 4.,.<.< d f.}.}.} 9.} dXC.<XC.,XZ.,.I.)Xm._.t._XA.!XZ.).!.< g v.b f.a.aXA.t._ b b |.I.I.IXZ.,XZ.).I b b.I bXZX@ gXZ._.IX@X@.,XZ.<XA b b.I.) L bXZX@._XZ.P b b.!XZ.I.P.IXZ., bX9Xs.IXZ.;.G I I I.G.} F F F FXCXA b.<X@XZX@X@.0.I.<.,XZ.,.0._XZXZXZ bXZX@.YXZ 0.)XZ L bXZ b.I b._XZXZ b L.I.,.)Xs b L.tX@ g.*. ._XZXmX@._XZXZ. XZ.IXZXZ.&.PXZ._.!XsXs.I._ f dX@XA.t., 0._ LXA.<X@XCXy 0X@.<._.0._._ |XZ 0XZ.;XZ g.}.Y | LXCXC._Xw.0._.IXZ.,XC f f I.} F.G.} fXC.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T `.G I I F v d.<.]X2Xa.oXa.oXa.o.o.o.o.oXa.o.o.o.o.o.o.o.#.o.oXy.o.#.oXy.#.oXy.oX3.oX3.oXy.#X3X3X3.oX3X3.w.oXyX3.wX3X3X3.w XX3X3X3XyX3Xy.#X3.oXy.#X3Xy.o.oXyX3Xy.#Xy.oXy.#X3.#X3.oXy.oXy.oX3.oX3.o.oXy.#X3.#X3Xy.o.oXy.oX3.oX3.o.o.#.o.o.o.o.o.o.o.o.#.o.o.oX3.C.C.o.o.o.oXa.o.o.o.o.o.o.oXa.o.oXa.o.o.oXa.oXa.oXH.o.oXa.oXH.oXa.oXa.oXa.oXaXaXaXHXHXaXaXHXHXa.oXHXaXHXaXaXHXaXHXaXHXaXHXH BXHXH }.oXHXaXHXH }XHXH }XHXHXHXHXaXHXaXHXHXaXaXaXaXaXaXHXaXaXHXaXa.eXaXH.eXHXH.eXaXH.eXaXHXaXaXHXHXa.eXHXa.eXaXH.eXa.eXaXH.eXHXa.eXH.eXH.e.f.f.f.f.f.f J.) b.)XZ._ 0.!XZXzXAXZ bXZ b.I bXAXZXZ b.I.I.IXZ.!.I.).IXA.<._XA LXZ._X@Xm bXZ.,.) b LXZXA.I.!.!Xs b.0XZXs 0.,XZXA._.!.,._ b._ 0._XC.nX2 0._ |XZXCXZ.!XZXZ.&.a d f FXsXZXZ.nXC 0.Y.,.!.!.I._X@.}.} F F F f f dXC.; f fXN.tX@.t.<.I b.P.I.PX9.I.)XmX@XZ.PXZ.<.b f.}.}.} F.} f.a.t._XZ._XZXs.!X@.0XzX<X+ bXAXzXAX@.0.a.b g g.*._._Xs.I.).,XZ.YXZ.I b.!.I.I.I b.I.0._X@.<., b.*X@XA LX@._.I.!.)XZXZ.I.)Xm s.,.!.I.I.!.P.PXsX9X@.=XZ.PXs |.Y F I.G I I F v d.<.]X2.) L.).<.0XmXZXA._ b.I b LXmXZ.! b.) b.)XZ._ 0.!XZXzXAXZ bXZ b.I bXAXZXZ b.I.I.IXZ.!.I.).IXA.<._XA LXZ._X@Xm bXZ.,.) b LXZXA.I.!.!Xs b.0XZXs 0.,XZXA._.!.,._ b._ 0._XC.nX2 0._ |XZXCXZ.!XZXZ.&.a d f FXsXZXZ.nXC 0.Y.,.!.!.I._X@.}.} F F F f f dXC.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.QX7Xe F.<X@ 4 4 gX@XH.o.o.o.o.o.o.oXa.o.o.o.R.o.o.o.oXa.oXy.o.oX3.oX3.o.o.R.o.o.o.o.#Xy.oX3.o.oX3 {.w B.rXD.rXD BXg.w R.w.q R.w.w R.w.w.w.w.V.w.w.w.w.w.w.w.w B.w.w.w.w.w.w.w.V.w.w.w.w.w.w BXaXy.oX3.oX3X3.o.# {.w.w.w.w 2.r.w.w.w.w.w.r.w.w.w.w.w.w _.w.w.w } _ X.w X.w X.w X.w _ X.w.w XXHXa.o.oXa.o.oXH.oXD.oXa 5.oXHXa.o.oXHXa.oXa.oXa RXaXHXa.oXHXaXaXHXaXaXHXaXH BXHXaXHXaXaXH.oXa.e B 2X; }XH 2XH }XHXHXH _ UXHXHXH.eXHXa }.eXaXHXHXHXHXaXHXaXH.eXH.e UXHXaXHXaXaXaXHXaXaXHXa.eXHXH.i.eXaXa.eXHXaXa.eXHXa.eXHXa nXHXa.eXH.eXH.f.f.f.f.f.fX9.I. .IXZ bXZ.0.!.)Xm. XZ.Y.I b b.)Xk b.,XZ b b bXZ.IXZ b b L L._XZXZXZ LXZ bXZ L b.E.IXZXZ b.,._.IXsXZ.,.P bXZ LXZXZXmXZXsXs.! 0XC 0XC._ |.YXZ.,.Y.!.!.!.Y._.b.G.WXZ._._XCXy.<.Y.,XZ.IXZ.,.Y.t F f d.}.}._ v.t.0.,.} gX<X@._Xl fXZ._ b ) bXs b bXZX@XA L.! g f F f f f.}.G f.b.bX@X@.tXZ._XZ.b.=Xl f.b.*.)XAXA 4 4._.*X<Xl f gXZ.)XZ.I.!.)XZXZ b.I b.I b b LXZXZXAXAXAXZXZ._._.)XZXAXAXZ.I b.I.) L.IXZ.Y.!XZ.P.I.I bXsXsXsXl fX@.I.P b 0X7 FX7Xe F.<X@ 4 4 gX@ bXmXCXk L gXA.0._Xs b.t.<._Xm.0XZ.I. .IXZ bXZ.0.!.)Xm. XZ.Y.I b b.)Xk b.,XZ b b bXZ.IXZ b b L L._XZXZXZ LXZ bXZ L b.E.IXZXZ b.,._.IXsXZ.,.P bXZ LXZXZXmXZXsXs.! 0XC 0XC._ |.YXZ.,.Y.!.!.!.Y._.b.G.WXZ._._XCXy.<.Y.,XZ.IXZ.,.Y.t F f d.}.}._ v.t.0.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T 0.} F f.h. .hXA L.)XaXa.o.o.oXa.o.oXy.o.o.o.o.o.o.#.o.o.o.o.o.#.oX3.o.oXy.#X3Xy.o.oX3.o.#.oXy.#X3.wXg.C.8.l.l.l.8.C.l.C.C t.l.C t.C.l.lXD.C.lXD.CXD.lXDXD.lXD.C.lXD.lXD.lXDXDXDXDXDXDXD.l _ ^X1 5.#X3X3.oX3.oX3.w RXDXgXgXg BXg B B.s B B _ B _ B _ B _ B _ B _ B _ _ U _ B _ _ _ _ _ n ^ u 3Xa.oXa.o.oXa.oXHXa.oXH.oXa.oXHXa.o.oXaXH.oXH.oXa.o.oXHXHXa.oXa.oXHXaXaXaXHXHXHXHXHXaXHXa UXH.oXH _.oXHXHXH 2XHXa }XHXH 2 nXHXHXHXHXHXHXaXHXHXaXaXHXaXH.eXaXaXHXa.eXa.eXHXaXH.eXaXHXHXa.eXHXaXaXHXHXaXHXaXa.eXHXaXa.eXa.eXH.eXHXHXH.eXH.e.f.f.f.f.f.fX9._.IXZ b b.I b.,.Y._.0XAXZXZ LXZXZ v.a.) bXZ.I b.) b.)XA.,Xm._XZXA. .I. .) bXAXAXZ L b.  b bXZ |XZ bXZXZXZXs bXAXZ.I.IX X .! | b.IXZ.YXZXZ._.P._._.Y.YXZ._._.*.b.a.<XmX2.GX2 0._.!.Y.IXZXZ.,XZ.<XZ.,XZXZ.t.a g f.b fX@X@.YXZ._XZ LXs.I., b b b b.t LXZ._.*.0.bXs.<.G c.b.a f f f f.< bXZ.IXZ.} f 0XZ LXA.)X@X@Xl f fXl.b.b.b f f.tXmXZXZ.I bXZ.! bXZXZ.I L bXZ.IXZXA._XAX@._.) b sXZXZXAXZXZ._XZXAXZ.)XA b.IXZ b bXs.IX9Xs s LXZ b.).I LXZ 0.} F f.h. .hXA L.).0 LXAXz g.,XZ L. .,.Y.Y 1.I b.,XZ._.IXZ b b.I b.,.Y._.0XAXZXZ LXZXZ v.a.) bXZ.I b.) b.)XA.,Xm._XZXA. .I. .) bXAXAXZ L b.  b bXZ |XZ bXZXZXZXs bXAXZ.I.IX X .! | b.IXZ.YXZXZ._.P._._.Y.YXZ._._.*.b.a.<XmX2.GX2 0._.!.Y.IXZXZ.,XZ.<XZ.,XZXZ.t.a g f.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T._.b.aXlXO 4.0 L LXZXa.o.o.o.o.o.o.oXa.o.o.o.o.o.o.o.o.o.oXy.oX3.oXy.oXy.oX3.o.oX3X3.#.oXy.o.oX3.o.p W - = : = / / = / = / / = / / = = = / = = / = = = = = =.1 =Xn.4.1XB.1Xn.1.1.1.1 W W.1.C ^X1 < {Xy.o.#X3Xy.o.R.8.g.g h h.q.q.q.q.q.q.q [.q.w.q [ p [.z.w p.z p.z.w.p.z.z.z.z.8.p.zXD ~ ~.RXa.o.o.oXH.o.o.o.oXH.oXHXa.o.oXH.oXHXa.o.oXa.oXaXHXaXHXaXaXH 5.oXaXHXHXHXHXa.oXaXaXHXH B BXH.oXHXH 2 2 n BXHXHXHXHXHXH U BXH.eXHXaXaXHXHXaXHXaXHXaXHXaXaXaXH.e.e 5XaXHXa.eXHXa.eXHXaXaXHXa.eXH.eXaXHXH.eXHXaXa.eXHXaXHXaXHXHXa.eXaXH.eXH.f.f.f.f.f.fX9.! b.I b.I b LXZ.!XZXAXZ LXAXZXZ._._X@._XZ.,.) bXZ.)Xm.t.Y._XAXZXZ LXAXm.)XZ._._XZ bXZ b.) b o.P.& b.) LX9.IX9XZXsXZ.V.qXs.IXZ.).I.Y._XZ.Y.,XZ.Y.!.,.,._._.<XA s.*.<X2 F I 0._.<XZ.YXZ._.!.!._._.0 bXZ._.< v.a g v d vX@XAXA M.&X@ LXZ bXZ.).!XZ.<XZXZXZ.tXA dX<.* F f f.b.}.}.} f f.a._XZXZ.0 L.).I bXA 4Xm.0 g.b f.b.b g g.b.b f fX@XZ b.I.).!XZXZXZ b.I b.) bXZ.) g.aX@.t.).)Xm.)XZXA.0XA._._.0.)XZ L b b.0.!.IXk.IXZX@ LXkXsXA.)X9 L L._.b.aXlXO 4.0 L LXZXZXZ.h.a.a.0.&._._ L.I.I.!XwXAXZXZ.! b.I b.I b LXZ.!XZXAXZ LXAXZXZ._._X@._XZ.,.) bXZ.)Xm.t.Y._XAXZXZ LXAXm.)XZ._._XZ bXZ b.) b o.P.& b.) LX9.IX9XZXsXZ.V.qXs.IXZ.).I.Y._XZ.Y.,XZ.Y.!.,.,._._.<XA s.*.<X2 F I 0._.<XZ.YXZ._.!.!._._.0 bXZ._.< v.a g.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T aX<.F.b.h 4 4.hXA._XH.oXa.o.o.o.o.o.#.o.o.o.R.o.oX3.o.o.#.o.o.#X3.o.o.#.o.RXy.o.oXy.oX3.#Xy.oXy : V.4 / M.;X0 M.JX0X0 M.J MX0.J.J.J.J.J M M M M.J M M M M +.J + M + M + M + + + + + W.1.X Z ~X1.j e 3.#X3X3.o +XD.q.qXG =Xm = / =.4 /.1.4 =.1 =.1.4.1XBXn.1XB.1.1.X.1.1 W.XXB.q.8.8.zXg ~ ~ e.o.oXa.o.o.o.o.o R.o.o.oXH.oXHXa.o.o.oXHXa.oXH RXaXHXaXH.oXaXaXa 5XaXHXa.o }XaXHXH.oXa 2 2XaXHXHXHXH.oXH }XHXHXH 2XHXH _ _XaXaXHXH.e }XHXaXaXHXHXH.eXaXHXaXHXaXH.iXa 5.eXaXHXaXHXH.eXHXHXaXHXa U.eXa.eXaXH.eXHXaXa.eXaXH.e n.eXHXHXHXH.e.f.f.f.f.f.f.^.P.<XZXZ LXZXZ.0.,.,XZ bXZXAXA._XAXZXAXZXZ bXm.0._Xm s.0.)XZXZXZ bXZ.t._XZ._XZXA.IXZXZ bXm f ) b.PXsXs.!X .PX .!.,.!X X9.P.P.!Xm.!.!.Y.,XZ.Y.Y.) M.,.!.!XmX@._XA.< fX7 I F 0XCXCXZ._XA &.P ) sXZXZXAXA s._.t vX@ gX@ g v.aX@XmXm._XA.0 L.I b.I.I |._XZ.) 0., b I.} I f f.} d.}.a.} f.b.Y.!XAXZ L.I L.IXZXZX@ g gX<.b f f.bX@Xl f.b v.bX@XZ L.I.)XZXZ.)XZ.!.).I.IXZ L.b s.t._. XZ.).I.)XAXZ._XA.).0 L.)XZ._. XZ.I b.! M.b.a.) b.I.! b z LXzXAX<.F.b.h 4 4.hXA._.3 4Xz.<.,XmXA._.,XZ.P b.I.I.,XZ |.P.<XZXZ LXZXZ.0.,.,XZ bXZXAXA._XAXZXAXZXZ bXm.0._Xm s.0.)XZXZXZ bXZ.t._XZ._XZXA.IXZXZ bXm f ) b.PXsXs.!X .PX .!.,.!X X9.P.P.!Xm.!.!.Y.,XZ.Y.Y.) M.,.!.!XmX@._XA.< fX7 I F 0XCXCXZ._XA &.P ) sXZXZXAXA s._.t vX@.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T T.b f f f g g.=XlX<Xa.o.o.o.oXa.o.o.o.o.#.o.o.o.o.o.o.oX3.o.o.o.o.oX3.oX3X3.#.oXy.oX3X3.o.#.oX3XF.8 / +X0 7 7 7 7 7 7 7 7 7 7 7X0 7X0X0 7 7 7X0X0X0X0X0X0X0X0 MX0.JX0X0.J.J.J.J MXmXG.X.X.OX1X1X1 e.j.-X3.oXy 3.s.qXG = + ' ' ' ' ' ' ' / / / / / / / / / = / = = = =.4 =.4.1 >.z.z ].O ^X1X1XFXa.o.oXH.oXHXa.o.o.oXa.oXH.o.oXaXHXa.oXa.o.oXH.oXaXHXHXHXH.oXH.oXa.oXHXHXaXH.oXHXH B B _XH BXHXH.oXHXH.oXH ,XHX; _X3 B _X;XHXHXHXHXH.eXa 5Xa.eXHXaXHXH.eXa.eXaXHXHXaXaXHXaXHXaXHXaXa.eXHXaXHXHXaXHXa 5XaXaXHXH.eXHXaXHXaXHXH.eXHXH.e.e.f.f.f.f.f.fXqXs b.) b.0.t.0XZXZ b.t.,.).)XZXZXZ.IXZ._ d._.!.). .!XZ.  bXZXZXZ.)XZ.)XA._XA._._XA b.)XZ.) b.,.,._._ bXs.PX .!._.,.IXs.I.P.!.P.EXZ._XZ.I.Y.Y._.Y.!XsXZ.,.<.<.aXl.b.} I.G._XZ.P.!._.t.a.,XZ.I.I.I b.} F f._._._._X@ v.a g.a d.aXA b._Xm._.YXZXZXA.!._.! |.<.tXZ.} I I F.G F f.b f.b.< f fX@XmXAXZ.I.PXZXZXZ.Y._ gX@X@XA.=.a._.).).b g v.b.b.bXAXZ bXZ.0XZXm g._.a.<.a 4 g.b.a g.aXZXZXA.)XZXAXZXA.0XAXA.)._., b.a.0.)XZX@.*.IXs.IX9.! LX@.0.*.b f f f g g.=XlX<.b C.<._.Y._Xs.,XZXs.I.IXs bXZ.P.IXs b.) b.0.t.0XZXZ b.t.,.).)XZXZXZ.IXZ._ d._.!.). .!XZ.  bXZXZXZ.)XZ.)XA._XA._._XA b.)XZ.) b.,.,._._ bXs.PX .!._.,.IXs.I.P.!.P.EXZ._XZ.I.Y.Y._.Y.!XsXZ.,.<.<.aXl.b.} I.G._XZ.P.!._.t.a.,XZ.I.I.I b.} F f._._._._.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T T f 0.!.<.<.aXl.b fXa.o.o.o.o.o.o.o.o.o.oXaX3.oXy.o.o.#.o.oX3.oX3.o.oX3.o.oX3.oXy.oX3X3.oXyXyXy.q.q : =X* + +.J.;X0 7 7 7 7X0 7 7 7X0 7 7X0X0 7X0 7X0X0X0X0X0X0X0X0X0 M M + : /Xn.1Xn.XXG VX1.j.j <X1 #.RX3.o.gXD.gXG W W.1.1 / / ' ' ' ' ' / : / : /.4 /.4 /.4.4.1 WXG.q [ [ ].z.8.8 ~ ~ #X1.w.o.oXH.o.o.o.o.o.oXH.oXHXH.oXaXH.oXHXa.oXHXH.oXH.oXaXH.oXaXaXHXHXH.oXaXaXHXH.o 5.o _ _Xg 2 2XHXH 2XHXHXH 2XHXH _X;.OX; _X;X;XHXHXHXaXHXH.eXHXHXHXaXa.eXHXHXaXHXaXaXHXH.eXHXHXaXHXHXaXaXH.eXHXHXaXa.eXaXH.eXa.eXHXH.eXH.eXHXHXHXH.eXHXH.f.f.f.f.f.f )XZXZXZXZXZXmXA.IXZXZ._ L.I bXZ.IXZXZ b.0XZXZ LXm.)XZ.IXk LXZXZ L.EXZ.I. XA bXZXAXZXZ.*.tXAXA.I | b.I b b.!.I b.,.I.! |.! bXZ.PXs.<XA._XZ.Y._.; s.I.P.P.P 0.t._.b g v F.}.<.PX9X X@.t._XZXZ bXs.IXs.}.}.} gX<.t s.t v g d H f.aXm b._ 0 s.,XZ.)XZ bXm.,.!._.,.,._ F I F.}.} F.b.}.b f.a H.aX@XZXZ bXsXsXZ.!.PXmX@X@XAXA.*X<XZ.E b.t.b.b.a f f gXAXA._Xm.<X<.b.bX@._X@ g g.b H f gXZXAXZXZXZXZ.0XAXAXAXZ.)XZ._X@XkXk b 4X@.) b b.I.I b.)._.0 4 f 0.!.<.<.aXl.b fXZXZ.,XZ.0. .!.IX9 bXZXZ bXZXZ.P.!XZXZXZXZXZXmXA.IXZXZ._ L.I bXZ.IXZXZ b.0XZXZ LXm.)XZ.IXk LXZXZ L.EXZ.I. XA bXZXAXZXZ.*.tXAXA.I | b.I b b.!.I b.,.I.! |.! bXZ.PXs.<XA._XZ.Y._.; s.I.P.P.P 0.t._.b g v F.}.<.PX9X X@.t._XZXZ bXs.IXs.}.}.} gX<.t s.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T a f.I.IXZ._XZ f fXAXa $.o.oXD.#.o.C.o.o $.o.R.o.o.R.o.o.RX3Xa.R.oXy.R.oX3 X.o X.oXy.w.oX3 X.o.o _XB /Xm =.M.M /.MXz.J 7 7 7 7 7 7X0 7 7X0 7 7X0 7X0X0 7 7X0 7 ' /Xn W WXGXxXn.1Xn.XXxXn [ V.j e D <X1 e ^XHXyXD.lXGXGXGXGXGXG.q.q > W / ' ' / / / /.4 / /.4 W [ >.8 > >.8 >.z.8.p.z.l ~ ~X1 < U.oXaXD.oXa.o.o RXa.o R.o.o R.oXH R.oXa RXH.o R.o RXa.o }Xa 5 R.oXH B.oXH.'XaXH R _Xg _X;Xg 2 ,XH 2XH 2 BX; BX; _ 2 _XHX; 2XH BXHXH nXHXH nXaXa }XHXH UXHXa n.e }XHXH UXaXa UXH.e UXa 5 }XaXH } 5 nXHXa nXHXa n.eXH n.eXH nXa.e nXa 5.e.f.f.f.f.f.fX5.,.Y.IXZXZ.!.).0XZXZ._XAXZ.)XZ.I b b.IXZ L.IXZX@XZXZ LXZ.!., b.I LXZXAXZXZ bXZ.0XA.* g LXAXZ 1 |X9.!.!.)._XZXZ.! bXZ.!.I.I.P.PXs._XmX@.,XZ._X2._XZ.P b.! MX@X@ cX@X@Xe f.t bXsX9.,XZ._XZXZXZXZXAX< f f f f f f.}.} f.t dX@.} f.* bXZ.t.&.Y.PXm.,XZX@XZ.*.Y.I.!XZ v I F f.}.}Xl.b f F d.b gX@.I.P.I.PX9Xs b.,X@X<.*.*.*.0XA L.)XZXZ.*.a v v.} f g.tX@.0X@ g.b f.,XZXA.*.bX@.<X@._XZ._.tXZXZ.)XZXA.0.)XZXZX@.bXA b.).I.=XA b LXs.I b bXZ.,XAXA f.I.IXZ._XZ f fXAXmXZXZ.,XZ.!XZ |Xs bXZ.0._.0.t bXs.,.Y.IXZXZ.!.).0XZXZ._XAXZ.)XZ.I b b.IXZ L.IXZX@XZXZ LXZ.!., b.I LXZXAXZXZ bXZ.0XA.* g LXAXZ 1 |X9.!.!.)._XZXZ.! bXZ.!.I.I.P.PXs._XmX@.,XZ._X2._XZ.P b.! MX@X@ cX@X@Xe f.t bXsX9.,XZ._XZXZXZXZXAX< f f f f f f.}.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX< 0XZ.IXZXZXZ.IXZX@Xa.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.#.o.oXy.o.o.#X3.oX3X3X3X3.o.oXy.oX3.o :.s.w W WXnXn =Xm /.MXm +X0 7 7 7 7 7 7X0 7 7 7 7 7 7X0 7X0Xy ' W =XnXn =XnXnXnXnXx WXG [.8.OX1 < < < eX1.R.#XHXg Z.w p p [ [.q.q.q.q.q.1 ' ' ' / / / / /XG.8 > > > p > > >.8.8.8 t.l.sXM ~.jX1.-XH.o.oXa.o.oXa.oXH.o.o.oXH.o.o.oXHXa.oXa.oXa.oXH.oXHXa.oXHXHXHXHXaXHXaXa.oXHXH 2 B ! ! _ 2 2XH _ 2 2 2X; ! _ _XH _ ! _X;XHXH UXaXHXHXa.eXa :XaXH.eXHXaXH.eXaXHXH.eXaXHXHXH.eXaXHXaXH.eXaXa.eXH.e.eXHXaXHXaXHXaXHXHXHXHXHXHXHXHXaXH.e :.f.f.f.f.f.fX9._.0.tXZ.!Xs b b.) b &.,XZ.) b b b.!.I LXZ.).I.IXZXZXA.0 LXsX9 b.I bXZXZ b LXZ.)XZXAXA._.)XsX  b b LXZ.!.I bXZ.I.,XZ.Y.I._XZ.!.I.!XZ.,._.,._.I._XZXZ.,XZX@.bXlXmX< g.t.a._ b.)XZXkXk b g.aXl.b g._.b f f v f.} f f.}.a f.< f f vXZ._XZ.0.E.tXZ.IXZ.).t 0.!Xs.PXZXZ.G.G F.G F.} f.} f f.b v g.IXZ.I.IXs.IXZXA.tXZXZXAXAXZXA.I L.I b.)XmX<.t.< f.}.bX< gX@X@.=.a.*X@._.tX@.a.<.0.!.!XZXZXZ.,.).!.)XZXZXA.* LXZ L.P.IXA.I bXs b bXkXkXz.0X@.*Xl 0XZ.IXZXZXZ.IXZX@.!XZXZ bXs.P.!.PXs.Y.!.! b b b.,XZ._.0.tXZ.!Xs b b.) b &.,XZ.) b b b.!.I LXZ.).I.IXZXZXA.0 LXsX9 b.I bXZXZ b LXZ.)XZXAXA._.)XsX  b b LXZ.!.I bXZ.I.,XZ.Y.I._XZ.!.I.!XZ.,._.,._.I._XZXZ.,XZX@.bXlXmX< g.t.a._ b.)XZXkXk b g.aXl.b g._.b f f v f.} f.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.].] b.P.P.I.P.!._._Xa.o.o.o.o.o.o.o.o.o.o.o.R.oX3.o.oX3.oX3.o.oX3.o.oX3.o XX3Xy.oXy.oXy.#X3.#.4XD Z.s Z.s.s Z.s pXn.MXmX0 7 7 7 7 7 7 7 7X0 7 7X0 7X0 7 7 7 =Xn =XnXnXtXV [ > t.s.s.s.s Z !X1 < < eX1 e G.o {XgXD.s.s.s.s.s.s.s.qXV.q / ' ' : / : /.4.q.z [ [ [ p.z.8 Z.s.s.s Z.s.sXD _X1X1.j :Xa.oXa.o.o.oXaXD.o.o.oXHXa.oXHXaXa.o.oXHXHXH R.oXaXH.oXHXaXaXH.oXH.oXaXH.'XH.oXH B _ ! 2 ! 2 ,.Z 2 ! 2X;.Z _ _ , 2 _X; _XHXH }XHXH UXHXHXaXH.eXHXHXa.eXaXHXH.e UXaXH.eXaXaXHXaXa.eXHXaXHXHXa UXHXHXa.eXHXH.eXHXH.eXaXa.e nXH.eXHXa.e.e.f.f.f.f.f.fX9.).,XAXZ.I.I b bXZXZ.Y.,.! bXZXZ bXZ L b.I.! b.! bXZXZ bXZ.I. XsXs.I L.) LXZXAXAX.XZ._XZ b. .EXZ L. .,XZXZXAXmXZXZ.IXZXZ.!.I.,.P., 1.I.<._XZ.!XZ.,., |.!XZ f.bXl.bXl._X@., L.h.*.h.=.b.a.b g.a v.} v f f f f.}.} F.}X@ v 0X@ v fXm.<X@XZ.)X@ bXZ b.t 0 :.0 MXZ.<XA i.G I.G.b.} F.b.} f f.b vX@XA.*.I.I b.<X@._ bXAX+.0XZXZXZ b.I.I.I.) g.0 4 f f fXlX@.0X@X@ gX@ gXl 4 4X@.aXZXZ.I.I L.I bXZ.I.! LXAX@XAXZ.) L.P LX@XZ.!Xk b L.h.h LXA 4.* f.] b.P.P.I.P.!._._XZXZXZ.PXs b.P.I.!.I.,.0XAXZXZ._XZ.).,XAXZ.I.I b bXZXZ.Y.,.! bXZXZ bXZ L b.I.! b.! bXZXZ bXZ.I. XsXs.I L.) LXZXAXAX.XZ._XZ b. .EXZ L. .,XZXZXAXmXZXZ.IXZXZ.!.I.,.P., 1.I.<._XZ.!XZ.,., |.!XZ f.bXl.bXl._X@., L.h.*.h.=.b.a.b g.a v.} v f f f f.}.}.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.].,.!XsX9.P bXZXZ._Xa.o.o.o.o.o.o.o.o.o.o.oX3.oX3.o.o.#X3.oXy.oX3.#.oXy.o.oX3.oXy.oX3.#.oX3XyX3X3XH o ^ ~ ~ ~ ~ ^ ! > 'Xm.J 7 7 7 7 7 7 7 7 7 7 7X0 7X0X0 7.J = =Xn >.ZXg _ ^ ~ ~ ~ ~ ~X1 ~ ~X1 e DX1X1 :X3X3X3.l ~ ~ ~ ~ ~ ~ _.q.q / ' / ' ' /.1 > [ > [ [ > t.Z Z.Z ~ ~X1X1 # ~ ~ D ~X1.j XXa.o.o.o.o.oXH.o.o.o.o.o.oXHXa.oXaXH.oXHXH.oXHXHXHXa.oXHXHXHXHXaXHXH.oXaXH.oXHXH.o BX3 2 2 2 !XH _Xg _ _Xg _.Z _X; BX; 2 UXHXHXH U.oXHXHXH.eXHXH.eXHXaXH.eXHXHXHXa.e 5XaXa.eXHXHXaXHXaXHXa.eXHXHXaXaXaXH.eXHXHXaXaXHXH.eXHXHXaXH.eXaXHXH.f.f.f.f.f.fX9XZXZ._.) b bXZ b.)XZXZ |.P._XZ b b bXZXZXZ.! b.).I.0 LXZ LXZXA.I bX XZ.&.0._XZXZ bXZ 0 bXk.  d |.  b L. XZXA.<XZ.! b._ & |.,._XZXZ.I.!XC._XZXZXZ.!.IXs.PXZ f.}.b.b fX<.*X@.b.bXl g v.a M.aX@ g v fXl v v v v f f F 0., M d.YX@ f 4X@._._.* vXm._XZ.<.I.P.Y |XC v F I.G I.G f f.}.}.}.}.b.} f.bXl.b.b.a g.*X@XA.0.0X@XZXZ.IXZXZ L.I b.IX@.*XA.} f.b.b gX@.t.t gX@X< g.*X<X@.bX@XZXZXZ.!.I LXZ.).)XZX@XA.).I bXZ.).*._Xs b b.h.h.[XlXl.t g v.].,.!XsX9.P bXZXZ._.P.P.!.IXZ._.,.!.! L.&._._XZ._._XZXZXZ._.) b bXZ b.)XZXZ |.P._XZ b b bXZXZXZ.! b.).I.0 LXZ LXZXA.I bX XZ.&.0._XZXZ bXZ 0 bXk.  d |.  b L. XZXA.<XZ.! b._ & |.,._XZXZ.I.!XC._XZXZXZ.!.IXs.PXZ f.}.b.b fX<.*X@.b.bXl g v.a M.aX@ g v fXl v v v v f f.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T aXAXZ.IXs |.! | |.PXa.oXa.o.o.#.o.#X3.o.o.o.R.o.o.o.oX3.o.oXy.o.oX3.o.oXy XX3.oXy.#X3.oX3XyX3XyX3Xy.o.w 3 2 ~ ~ ~ ~XgXG /Xm 7 7 7 7 7 7 7 7 7 7X0 7 7X0 7X0X0XV = =XG V ~X1 ~X1X1 ~X1 ~ ~X1 D ~ DX1.jX1XHX3X3.oX3.R u u ~ ~ V.s.q = / ' ' ' /.1 >.q [ [ [.8.s.Z.s.O # ~ DX1 u DX1 ~X1 D u.j.-.o.o.o.oXa.o.o.o R.oXH.oXH.o.oXH.o.oXa.o.oXH.o B.oXHXaXHXaXaXH.oXHXaXHXHXa BXaXHXH B 2XD 2 2 B 2 ! _ 2 _ _ B ! _ _ 2XaXH 2XHXH.oXH U UXHXH.oXHXaXHXaXaXHXH.eXa.e UXaXaXaXHXHXaXHXHXa.eXaXH.eXH } :XH.eXaXHXaXHXHXH.eXaXaXH nXaXHXHXH.e.e.f.f.f.f.f.fX4XZ.!.IXZXZ LXZXZXZ b.I.E |XZXA.P.).IXZXZXZXZ.I bXZXZXZXAXZXZ.0XA._Xm 1.I L._X@XsXZ.,XZX@._._XAX@._.!.,XZXZ.,XZ.I._XZ |.!.I.!.,XZ.Y.Y.,XZ., g v.<XZ.Y.! |X@X2X7 f F F._Xm.t f.!Xm.< g.aXZ._._.b v v H f f.}.} f.} fX@.P M.].YXAXZ.b.bX@ f.}.b.!Xm gXZXZ.<.P.!.!.P.Y.G I I I.}.} f f.} f.b f f.aX@X@.IXm._X@X@._XZ.t.0.I.!XZXA.I.IXZXZ.I.)XAX< d.b.bXl g.b.0X@.t gX@.* g gX@X< g gXZXZXAXZ.,XZ LXZXZXAXZ.)XZ.).*.I b.IXZ b.=XN.aXA.*X@.0XZXZXAXAXZ.IXs |.! | |.PXZXZXZ.0Xm.,.! b b.,._Xm._.,XA._.<XZ.!.IXZXZ LXZXZXZ b.I.E |XZXA.P.).IXZXZXZXZ.I bXZXZXZXAXZXZ.0XA._Xm 1.I L._X@XsXZ.,XZX@._._XAX@._.!.,XZXZ.,XZ.I._XZ |.!.I.!.,XZ.Y.Y.,XZ., g v.<XZ.Y.! |X@X2X7 f F F._Xm.t f.!Xm.< g.aXZ._._.b v v H f f.}.} f.}.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T y.!.Y.!Xs.IX  |.I.IXa.o.o.o.o.o.o.o.o.#.o.o.o.oX3.o.#.oX3.#.oX3.#Xy.oXyX3X3.oXy.oX3.oXyX3.o.#.oX3X3.wX3X3.wXH.w ~ ~Xg.s /X*X0 7 7 7 7 7 7 7 7 7 7 7 7X0X0X0 7 ' = =Xn V V #.j e < ~ u ~ ~ ~ ~X1X1 D # $X3Xy.oXyXyX3.- ~X1 VXJXD.1 ' + ' ' ' W.q [XV [ [.8.sXg.ZXM #X1 DX1X1X1X1 ~ ~X1 ~X1 < *.oXa.o.o.o.o.o.o.oXH.oXH.oXHXa.o.o.o.oXHXa.o.oXaXHXaXHXaXHXaXHXHXaXHXaXHXHXaXH.o B ,XHXH BXHXH 2 2 2 ! ! _ _ _ 2 2X;XHXaXHXaXH.oXHXH U.oXHXH.eXHXHXHXH.eXaXaXHXaXHXHXHXaXHXaXa.eXHXaXHXHXaXHXHXa.eXaXaXH.eXa.eXH.eXaXaXHXHXaXHXHXa.eXHXH.f.f.f.f.f.f 8XC b.IXZ.tXZ. XZXZ bXZ.).!XZ.IXZ. XZXZ bXZXAXZ.PXZ.0XZXZ._XZXAX@._XZ.) 1XZXm.*XA.I.I b.)XZ.).t 0.!.!.I b.<XZXZXZ.,XZ.!.!.,.I.P b.I.I.&.<.b f gX< f.<X@._.;Xe.a._.b f f d.Y F._XZ 0 v.} 0.<.,.}.} f f.b.b.b.} F.} f f.Y 0._.,.YXZ.}.b.t.}XN.t.  v.0.I.!.IXs.I.!.0._ f I I I.} F.G f f fXl f fXl.* gXA.a.bX@ gX@.0X@.<Xs bXZXZXZ bXZXZXZ bXZXA 0 d.b f g.bX@X@X@.bX@Xm._.t g g.a.aXZXA._XAXAXZXZXm s.0XZXZ LX@.0 L.I b._ LX@Xk L LX@._XAXA.,.!.!.Y.!Xs.IX  |.I.I.IXZ.0XZXZ L.,XZXA.0._._XZXAXmXZ 0XC b.IXZ.tXZ. XZXZ bXZ.).!XZ.IXZ. XZXZ bXZXAXZ.PXZ.0XZXZ._XZXAX@._XZ.) 1XZXm.*XA.I.I b.)XZ.).t 0.!.!.I b.<XZXZXZ.,XZ.!.!.,.I.P b.I.I.&.<.b f gX< f.<X@._.;Xe.a._.b f f d.Y F._XZ 0 v.} 0.<.,.}.} f f.b.b.b.} F.}.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX4.)XA.I.Y.IXs.Y.!._Xa.o.o.o.o.o.o.o.o.o.o.#.o.o.o.o.o.o.oX3.o.#X3.oXy.o.o.oXyXy.oXyX3.oXyX3X3.#X3X3.wX3X3.rX3X3.pXF ~.sXG : + 7 7 9 7 9 7 7 7 7 7 7X0 7 7 7X0.J.1.x =.Z V ~.j e < < < ~X1X1 ~ ~X1 ~ D.r.#XyXy.#X3.oXyXF ~ _Xg.q ' + ' ' '.1.q [XV >.q t.s.ZXM #X1X1 ~X1 ^X1 DX1 ~X1 ~X1 ~ BXH.o.#.o.o.o.o.oXH.o.oXa.oXH.o.oXa.oXH.oXH.oXH.oXH.oXaXH.oXHXa.oXH.oXHXa.oXaXHXHXH BXHXH , BXHXHX3XH ! 2X; 2 2XgX;XaXHXaXHXHXaXHXHXHXH 2XHXHXHXHXHXaXH.eXHXHXHXaXaXH.eXaXHXaXHXHXHXaXaXH.eXaXHXH.eXHXHXHXaXHXH.eXaXaXH.eXaXa.eXHXHXH.eXa.e.f.f.f.f.f.fX5X@ b bXA.0._XZ bXZXZXAXZ.IXZ._XAXZXs.IXZXZXmXZ.IXZXZ b b LXAX@XAXZ._.) b.!XAX@._XmXZ._XZ._XZ.<.,.I.! |.!X@X<X@Xl P._.I.I.!X<XZ.I.YX@.0.Y.<.b f f.} v._._.} f.;.t.a._ &.!.Y.}.<X@.}.} F.}.} f.b f.b f.a g.} F F.} F.}.<._._.!.!.I f.bXl F f g f.]XZ bXm 0.<XZ.I.<X2.< I I I.}.G.G.b.a.}Xl.b.b.b gX<X@.a.b gX@.=X@XA gXZXZXZXAXA.)XZ.).!.)XZXAX< f f f.b g.b gXl.<._X@ sX<X@ f g.bXZXZ.,.0.0XZXZ.0XAXZ.) LXAXAXZ.)XZ.,XAXzX@ LXm 0XA._X@._.,.I.)XA.I.Y.IXs.Y.!._ LXZXZ.I.I.!._XAXZXZ.).I.) L._XZXsX@ b bXA.0._XZ bXZXZXAXZ.IXZ._XAXZXs.IXZXZXmXZ.IXZXZ b b LXAX@XAXZ._.) b.!XAX@._XmXZ._XZ._XZ.<.,.I.! |.!X@X<X@Xl P._.I.I.!X<XZ.I.YX@.0.Y.<.b f f.} v._._.} f.;.t.a._ &.!.Y.}.<X@.}.} F.}.} f.b f.b f.a g.} F F.}.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T sXA.0X@XZXC.<XZXZXAXa.o.o.o.#.o.#.o.o.#.o.o.R.oX3.#.o.o.oXy.oX3.oXy.o.oXy.w.o.oX3.oX3X3X3.#.oXyX3X3X5.w.rXyX3X3.wX3X3XB.ZX*X*X0 7 7 9 7 7 7 7 7 7 7 7 7 7 7 7 7Xz = =.g ^ ^.j.j.c e <X1 u.CXDXF { 5.o.oXy.oX3XyX3.#X3X3.- _.w W + ' + '.4XV [.q.q [ t.s !.O ~ ~ ~X1 ~X1X1 B.r.- 3 $ {XHXHXHXa.o.o.o.o.o.o.oXa $.oXHXH.oXHXH.oXa.o.o.oXa.oXH RXa.oXHXaXaXHXaXHXaXHXHXHXH B.o.o BXH.o.e BXHXHXHXH 2.oXH 2XHXH BXHXHXHXHXHXHXaXHXHXH } }XHXHXaXH.eXHXaXaXaXHXH.e.' 5Xa.eXHXaXa.eXHXHXaXaXH.eXH U.e.eXHXaXa.eXaXaXa.eXH.eXH nXHXaXHXa.eXH.f.f.f.f.f.fXq LXZXZXZXZ.P b._ bXZ.I bXA.,._.tXAXZ b.)Xm.0. Xm._._Xm.t._.<.0XA._XZXAXA.tXAXAXA.I.I.P.PXZ.a.I.I bXZXZ g.b f fX<.a.b.bXl.= P gX<XA._X@.0XA.< f.b.b F f.a._X@._.PXsXA._., b d.,XZXZ M g f f.G.}._ f.}.G F f f.G f f f.} f f fXm.<.< f I b.t.b 0.<XA.t.t._._.,XA.YXs., F I.a F.}.}.b.*.b f.} f.=XlX<X@ gX@ bXA.0._XAXA._XA._XA.0XAX@._XZXA._.IX@X@XA.b.b f.b.b f g.tX@.t g v g.b._X@.0._XA.0._.aX@.,XZXA.*XZXZXZXZXA.b.<.0 LXZ LXAX@XmXAXAX@.<XA.0X@XZXC.<XZXZXAXZ.YXZXZ.)XZXA.) b.,XZXZ.)XZXZ b.I LXZXZXZXZ.P b._ bXZ.I bXA.,._.tXAXZ b.)Xm.0. Xm._._Xm.t._.<.0XA._XZXAXA.tXAXAXA.I.I.P.PXZ.a.I.I bXZXZ g.b f fX<.a.b.bXl.= P gX<XA._X@.0XA.< f.b.b F f.a._X@._.PXsXA._., b d.,XZXZ M g f f.G.}._ f.}.G F f f.G f.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T sXA._.YXA.0.0Xm._._Xa.o.o.o.o.o.o.o.o.o.o.oX3.o.o.oX3.#.o.oXy.o.#X3.oXy.#X3.o.o.#X3 M.#X3.oXy.oXyX3.wXy.wXyX3X3X5X3Xy 5Xg.XXm + 9 7 9 7 7 7 7 7 7 7X0 7 7 7X0X0 + = =Xn V ^.j e e e e $.oXyXyX3Xy.#XyXy.oXyXyX3XyX3X3 3 _ pXG : ' ' ' = [.q.qXV [ t.Z.Z.OX1 ~ ~X1 u ~ $ 3Xa.oXyXa.o.o.o.oXa.o.o.o.oXa.oXa.o.o.oXa.o.oXa.o.o.o.oXH.oXa.oXa.oXHXaXa.oXHXaXH.oXHXa.oXHXa.oXHXaXH BXHXH 2XaXaXH.oXH BXHXH 2XHXH 2XH.oXHXHXH 2XHXHXHXHXHX;XaXHXH.eXaXHXHXHXHXH.eXH.eXaXaXHXaXHXaXaXaXHXaXH.eXaXH.eXHXaXH.eXaXaXH.eXHXaXaXH.eXHXH.eXa.eXH.e.f.f.f.f.f.f JXZ.).I bXZ.IXs._._.<XZXZ.IXZ 0._._XA._.*X@X$X@.<X@XZXmX@XZXZXAXA.,XZXmX@.t M.tX@.! 1 b b bXZXZ.!XA.b g.b.b.b.b._ gX< 4X<X@ 4X@X@XZXlX<._.,.t.} fXl f.b.t gX@XZXs.IXZ.!.Y.<XZ.!Xs.I.!._._.t f I I.}._.< f f f.G.}.} f F.<.Y.}.b.t.b.<.G.I.& d bXA.t.0.} 0 L L._ &.^.!.< I.} F.}.} v.a.a.b f fXl.=.* gX@XZXAXZXA.*XAXmXAXZXZXZ.0.,.0XA.).0XmX@X@.tX@ g.b.b.b.a f.t.a g g C.< g.a.b._._._._._X@X<._.0XAXA.0XA.0XA._ gXl 0.!XZXAXAXA g g._._.t.<XA._.YXA.0.0Xm._._. .0XZ LXZXZ.I b.! LXZ.) LXZ b b bXZ.).I bXZ.IXs._._.<XZXZ.IXZ 0._._XA._.*X@X$X@.<X@XZXmX@XZXZXAXA.,XZXmX@.t M.tX@.! 1 b b bXZXZ.!XA.b g.b.b.b.b._ gX< 4X<X@ 4X@X@XZXlX<._.,.t.} fXl f.b.t gX@XZXs.IXZ.!.Y.<XZ.!Xs.I.!._._.t f I I.}._.< f f f.G.}.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX@._XZ.)._Xm.t.0XZXZXaXa.o.oXa.o.#.oXy.o.#.#.o.oXy.o.o.oXy.oXy.oX3.oXy.oX3.o.o.oX3X3.#.oXyX3.#X3X3.wX3XyX5X3XyX3X5X3XyXy.l.sX*Xm 7 9 7 7 9 7 7 7 7 7 7 7 7X0 7 7X0XG = =.p V ~ e.@ e.j.j.oXyXyXy.oXyXy.oXyXyXy.oXy.# :.p t.g.1 + + ' = [.qXV [ [ t.Z.Z.OX1 ~ D ~X1X1 u.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.oXH.o.oXH.oXH.o.oXaXH.oXa.o.o.o.oXa.o.oXH.oXH.oXaXH.oXHXaXHXH.oXHXH B.oXH B.oXH.oXHXH B.oXH BX3XH 2XHXHXHXaXH UXHXHXHXHXHXa }XHXHXHXH.eXaXHXHXaXH 5XaXHXHXaXaXHXaXHXa.eXaXHXaXaXHXH.e.eXHXaXHXa.eXaXHXH.eXHXaXaXHXaXH.eXH.e.f.f.f.f.f.fXq.I bXs.I bXZ.I b.,._._.<., L.Y 0XA.< f g.<X@._XAXZXZ.0XmXA L.! bXA.* g.<.< s._.!Xs.P.I.IXZ.I._X@.b g.bX@.b.a._XAX@ b.IXA._.< MXA.b.bX@ M.< 0 FX<.b g.b.b.b f._Xs.! d.! |._XZ.)X9.I.IXZ.,.YXZ F I.G.}.}.G.G.G F I I I.G F f.G F fXZ.E.} fXm MXZXZ._XZXZ.!.!.!.IX Xs.,Xs.}.G.} f.<.0.).* f F fX$.*X+X@.*.tXA.IXAX@XA._._.0XAXZXA._XA._XZ._ gX@.aX@.*.b gXl.} f.b.<.b.<.< g.b.b.a.b.t d.t._X@ vX@._X@._Xm._.,XA._.*Xl fXZ.*XAXAXAX@XAX@X@.aXAX@._XZ.)._Xm.t.0XZXZ.) L.I |.!.IXZXZ., LXZXZ LXZ.).!.I.I bXs.I bXZ.I b.,._._.<., L.Y 0XA.< f g.<X@._XAXZXZ.0XmXA L.! bXA.* g.<.< s._.!Xs.P.I.IXZ.I._X@.b g.bX@.b.a._XAX@ b.IXA._.< MXA.b.bX@ M.< 0 FX<.b g.b.b.b f._Xs.! d.! |._XZ.)X9.I.IXZ.,.YXZ F I.G.}.}.G.G.G F I.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXr._XAXm.aX@ sXA.)XAXaX3Xa.o.o.o.o.o.o.oX3.o.RX3.o.oXy.o.o.#.oXy.oXy.oX3Xy XX3Xy.o.#X3Xy.oX3X3XyX3.wX3.w.wXyX3X3 hX3XyXy.w.sXnX*.J 7 7 9 7 9 7 7 7 7 7 7X0 7X0 7X0 + = =Xx V nXoXo e.j.cXF.#.w.oXyXyX3XyXy.oXyXyX3XH.wXD.q = + ' ' / [.qXV.qXV t.Z.Z ~ # ~ < D ~X1 $ {X3.oX3.o.o.o.C.o.o.o.o.o.o.o.o.o.o.o.o.oXDXa.o.oXHXH.oXa.o.o.oXaXa.oXa RXHXHXH.oXaXH.oXaXH.oXH.oXH BXH _.oXHXH BXHXHXHXHXH BXHXH 2XHXH 2XHXHXHXHXHXH BXHXaXH U.o 2.eXHXHXaXaXaXHXHXH.eXa UXaXHXHXaXHXHXaXHXaXHXaXHXaXa UXaXaXHXaXHXHXaXHXaXaXHXaXH n.o.eXHXaXaXH.f.f.f.f.f.f.IXA.) bXZXZ b bXZ.)XZ.).EX@._.Y.YXAXZXA.tX@XA.)XZXZ._.,XA.)XZ.IXZ._ v.!.tX2.tXZ.P.I.!XZ.t f.b._XZ 0XCX@.<X@.t sXZXZ._._.t.a.*X@ v f.bXZ f d fX2.a f f f f d._ M.,Xs.IXZ.!.,.!.IXZ.I.!XZXm._XZXZ.Y.t f.G.}.} H f.b.}.G.}.G I I.G I f.}.}.G.}XA.tXZXZ.<.a._XZ.IXs.Y._XC.IXs.t.G f.*._X@XlX@.b.}Xl.*XAXAXA._ L b g.0XZ.I.,XZ.0.aX@.) sXZ.).*Xm.t.b.aX<.b f f.b.b.b f f.b f F F.b.b.b f.a.a._X@ g.<.aX@._._X@ f.} f.b.aX@.aX@.t.a.<.< v.tX@.t._XZ._XAXm.aX@ sXA.)XA._XZXZXsXkXs.,.,XZ.).) b.!XZXAXmX@XA.) bXZXZ b bXZ.)XZ.).EX@._.Y.YXAXZXA.tX@XA.)XZXZ._.,XA.)XZ.IXZ._ v.!.tX2.tXZ.P.I.!XZ.t f.b._XZ 0XCX@.<X@.t sXZXZ._._.t.a.*X@ v f.bXZ f d fX2.a f f f f d._ M.,Xs.IXZ.!.,.!.IXZ.I.!XZXm._XZXZ.Y.t f.G.}.} H f.b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX@._XAXA d.*._XZXA.)Xa.o.o.o.o.#.o.o.o.#.oXy.o.o.oX3.o.#X3Xy.oXy.oX3.#Xy.oX3XyXyXyX3.oX3.oXy.oX3Xy.wX3Xy.rX3X3X3.wXyXyX3X3.l.p / + 7 7 9 9 7 9 7 7 7 7 7 7 7 7 7X0.JXn = = V V <.c e.j D.RXyXyX3XyXyX3XyXyXy.oXy.o.g.s.q.1 / + + =.q.qXG.qXV Z.Z.ZXM # ~X1 DX1 # ^XH.o.o.o.o.oX3.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.oXa.o.o.o.oXa.o.o.oXHXH.o.o.oXH.oXH.oXHXa.oXHXaXHXaXa.o B.oXHXH 2XaXaXHXH.o 2XHXH BXH.o 2XH.oXHXHXa.oX;XHXaXHXHXHXH 2 5XHXaXHXHXHXaXHXaXHXa.eXHXa.eXHXaXHXaXa.eXHXa.eXHXaXHXH.eXaXH.eXaXaXHXa.eXHXHXaXHXHXa.eXH.e.f.f.f.f.f.f.uX@ L b b.)XZ b.Y b.I.IXs.I 0.n.]XA._ LX@XZXZXmXAXAXZ.YXA.,XZ.!.,.,XZXZ.,.,._.Y.I.IXZXZ.b f.a sXm._ 0.Y._., 0XCXC 0._._ 0X@.;.a.b.}.0.I.}.}.G g f.}.b.b f.tX@._.I.E._ bXA._ sXs.I bXZXZ 0XZXZ._._.,.} v.a f.a v f._.Y.}.G F.} I I.} f.} F F.a.;.0 M.tXZ.).Y.P.P.P | &.P.P b F.b gX@.b.b.*Xl.}.bX@._._XAXA.0XAXm.0XZXZ._._XZX@X@XAX@XAXAX<X<.aXlXlX@Xl g f.aX@.bXA.a.}.} F f.a.aX@.b.b.<XAX@X@.a.a gX@X@ g.=.b f._XZX@X@._._X+XAXA.0XmX@ 4.*X@._XAXA d.*._XZXA.).)XZ.IXs bXk.Y.,._ LXZ.I.IXZ.IXA._X@ L b b.)XZ b.Y b.I.IXs.I 0.n.]XA._ LX@XZXZXmXAXAXZ.YXA.,XZ.!.,.,XZXZ.,.,._.Y.I.IXZXZ.b f.a sXm._ 0.Y._., 0XCXC 0._._ 0X@.;.a.b.}.0.I.}.}.G g f.}.b.b f.tX@._.I.E._ bXA._ sXs.I bXZXZ 0XZXZ._._.,.} v.a f.a v f.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.]._.)XA.<._Xz.) bXZXa.o.o.oXy.o.o.oX3.o.o.o.oX3Xy.o.oX3.o.#.oX3.#X3.oX3.#.oXy.oXy.#X3X3XyXy.oXy.wX3Xy.rX3XyX3Xy hX3XyXyX3.p.s =Xm.J 9 7 9 7 9 7 7 7 7 7 7 7 7X0 7X0Xx = = h.O ^.j e.%.c.j.eXyXyX3XyX3X3X3XyXy.oXBXg.wXG ' + ' +.qXGXGXG [ Z.s.ZXM ~X1X1 ~X1X1 _.C.o.o.o.oXy.o.o.o.o.o.oX3.o.o.o.o.o.o.o.oXa.oXH.o.oXH.o.o.oXH.oXHXa.oXH.oXaXHXHXa.oXa.oXaXH.oXaXH.oXaXaXH.o R.oXHXH BXHXaXH.oXH BXaXH 2.oXHXH BXaXHXHXaXaX;XaXHXH.oXHXHXa UXHXHXH.eXaXHXHXHXa 5XaXa 5XaXaXHXHXaXHXH.eXHXaXH.eXHXHXaXHXaXaXHXH.eXaXHXHXaXHXHXH.eXaXH.e.f.f.f.f.f.fXs.aXZ.I b L b L.I b.I b b.!._ LXA.t.). XZXZ. X@XA._Xm 0XZXZ.,.!.! b.IX@ |X9.!XZ.IXZX@.b.a.a f MXA.0.<.t._XZ.&XC._ &._._.t v.a.b f fX@Xs.< d f.b f f f.*.b g.t.0XZ d fXm d.t v v fXA f.<.<.,.t.<.P.!.&.a.b d v.} 9X2.<.}.} I F I.G F._ f I.G.}._.&X@XA._XA.,.! bXs.P.^.IXsX9.G.}XlXl f.aXA g f f._._X@._XAXZ 4X@.,XZXA._.a g 4 g vXA.) bXl.b.bX<X@ g.b.tX@XA f F.bX@X@X@.<X@X@.*.0.a.b d._XAXm.t sX@.a g gXl.b 0._XA._X@._XZ. XAXAXA.* g.t f d._.)XA.<._Xz.) bXZ. .) LXk. XZ.!XA.,XZ.) b b b bXZXm.aXZ.I b L b L.I b.I b b.!._ LXA.t.). XZXZ. X@XA._Xm 0XZXZ.,.!.! b.IX@ |X9.!XZ.IXZX@.b.a.a f MXA.0.<.t._XZ.&XC._ &._._.t v.a.b f fX@Xs.< d f.b f f f.*.b g.t.0XZ d fXm d.t v v fXA f.<.<.,.t.<.P.!.&.a.b d v.} 9.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T CXZ 4 vXA._ 0 bXZ L.e.R.oXa.R.o.#.R.o.o.RX3.R.o.o.RXy.o.R.oXy.RX3.o XX3.o.wX3.wX3.o.wX3.#.wXyX3.wXyX3X5X3X3 hXy [.w.w hXy [Xg [Xm + 9 7 9 7 9 7 9 7 7 7 7 7X0 7 7X0 + = =XB.O ^.j.j.%.6.j.-.wX3Xy.wX3Xy.wX3Xy.R B.zXG / + + + /XGXGXG [ Z.Z.Z ~X1X1 ~X1X1X1 2 ] ].R.o.C.o.o.C.oX3.C.o.o $.o.o.C.o.o.C.o.oXHXa.C.o.oXD.oXa R.oXHXD.o.o RXH.o R.o RXH.o R.oXa R.oXa BXHXH R.o 2 BXa.o B.oXa BXHXa 2XHXa _XHXH B }XH BXaXHXHXH 2XHXH BXa.e 2 _.o UXaXa UXHXH UXa }Xa.e }XH.e }XH.e }XH.e UXHXH }.e }XH.e nXH.e UXaXH.iXHXH nXH.e nXa.eXH.f.f.f.f.f.f.u._ L b L.I bXZXA.! LXZ.I b.!XZ gXA g.<XZXZ.I bXZ.*._XZ.0.<XC.0.< d.<.a._.a f.b gX@._.0._X@ v._.Y.0._.Y._ d.< f MXZXZ bXZ.t f.b f.b f.b f.<.aX<X<.b.} f g.}.b.b g g.b._.t f.bX@ g 1XZXZ._XZXZ.< b._.IXZ.Y._._ v.< f f v.a f.} f.< F f.} f.} F.t.&._._.).IXA.0.! bXZXs.PXs.P I f.b f.bX@XA._ g.b._.t.a g.tXA.0.0.0._X@.b.b g f g f gX$.b 4XA._.b.a 0._X@.0 F.WXmXA.<.b f.b d f.a g g.a.a.a.a.b v.a C.t s.* f.a.t.<._XAXAXAXAXAXA gX@X@X@.b v.aXZ 4 vXA._ 0 bXZ LX@.0XZXZXZXZ.0XZXZXsXZ b b b.IXZ._._ L b L.I bXZXA.! LXZ.I b.!XZ gXA g.<XZXZ.I bXZ.*._XZ.0.<XC.0.< d.<.a._.a f.b gX@._.0._X@ v._.Y.0._.Y._ d.< f MXZXZ bXZ.t f.b f.b f.b f.<.aX<X<.b.} f g.}.b.b g g.b._.t f.bX@ g 1XZXZ._XZXZ.< b._.IXZ.Y._._ v.<.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T._.tXl fX@XZ LXZXZXZXaXa.o.o.o.o.o.oX3Xa.o.o.oX3.o.#.o.oXy.o.oXy.oXyX3.oXy.oXyX3.oXy.o.oXyXy.oX3 hX3Xy.wXyX3X3X3.rXy hX3Xy h.4.sX*XmX0 9 7 9 7 9 7 7 7 7 7 7 7 7X0 7X0Xx = - ].OX1 e.j S e.cXyX3X3XyXyXyX3Xy :XD.z W : + + + / WXGXG [ t.ZXJ ~X1 ~ u ~X1 ~ hXH ] ].o.oXy.o.o.o.o.o.o.o.o.o.o.o.o.o.oXa.o.oX3.oXH.o.o.o.o.o.oXa.oXa.oXH.oXa.oXHXHXaXHXH.oXH.oXHXa.oXaXHXaXH B.o.o.o BXH.o.eXaXHXH BXHXH.o 2XHXH BXHXHXaXHXH.o 2XHXHXHXaXaXHXHX;XHXHXaXaXHXHXa.eXHXHXaXH.eXaXHXH.eXaXHXa.eXa.eXHXH.eXaXa.eXaXaXaXHXHXHXHXHXHXaXaXa.e.o.e.f.f.f.f.f.fXS._XZ.IXZ.I.!XZ.t.0.IX@XZXZXZXm.0XA.t g.,., b.I.!._ 0.&XC 0.t M.,X@ 0 f.b f f.a.bXZ._.*._.,._ 0 0.!._XC.<.a.t d 0XZ._._.a v g f.b g f.b v.a.a.a g.} F.}Xl.a g.b g.b.t.<._ f._Xm.b.I.! |., bXs.! b.I.,.IXZ.Y.t.t M f.}.} F.G.t 0 f.} f f._., f F.YXZXA b b |.!.IXZXC.PXsXs b f.}.b.}.b g.).).*.bX@.<XZ.0 g.0Xm.0 gXZ._X< gX<X<.a.t 4 4.*.tX@XA.aX@.t.*._XA.]XZXZ._X@ d f.} d.aX@X<.<.tX< f f.}.} d.tXAX@.* f fX@.a.t.0 4 4X@XA.*.aX@.* g.a.<._.tXl fX@XZ LXZXZXZ 0.0XAXZ.)XAXA.) bXZ.)XZ bX9 bXAXA._XZ.IXZ.I.!XZ.t.0.IX@XZXZXZXm.0XA.t g.,., b.I.!._ 0.&XC 0.t M.,X@ 0 f.b f f.a.bXZ._.*._.,._ 0 0.!._XC.<.a.t d 0XZ._._.a v g f.b g f.b v.a.a.a g.} F.}Xl.a g.b g.b.t.<._ f._Xm.b.I.! |., bXs.! b.I.,.IXZ.Y.t.t M.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.d f f.b.a._XmXZXA.0Xa.o.#.o.o.o.o.o.o.o.o.oX3.oX3X3.oXy.o.oXy.oX3.o.oXy.oXy.o.oXy.oXyXyXyXyX3X3.wX3X3.rX3X3X3XyX5X3.wXyX3 hXHXgXtX* + 7 7 9 7 9 7 9 7 7 7 7 7 7 7X0 7Xn = =XG V ^.j eXo e eXyXyX3X3Xy.oXyXH.p tXG = + + + 'XGXGXGXG ZXJ.ZXMX1 ~X1 eX1X1.r.o.o.z.CXy.oX3.oX3.o.o.o.o.oX3.o.o.o.o.o.o.o.o.oXH.o.oXH.o.o.oXH.o.o.oXHXa.oXH.oXH.o.o.oXa.oXaXH.oXHXH.oXHXa.oXH BXHXaXHXg.oXaXa.oXHXH 2.oXH.o 2XHXH 2XaXHXaXH.oXHX;XHXHXaXaXHXHXH 2 5XaXH.eXHXa 5XHXHXaXHXHXaXHXHXaXa.eXHXaXHXHXa 5XaXHXa 5XaXH.eXHXHXHXH.eXHXa 5XHXaXa.e.e.f.f.f.f.f.fX  b._XZXZ b b.IXA._ bXAXZ.).h._XA. .0.*XZ b.).,XC._.Y 0.,.!., 0.!XZ._ f.b.b.b.aX@._X@X<XZ.!XZXZ 0.&XC.<X@ d.a vXZ._.< v v f.} f f g v f.<.b v g.} F.G F f.b.b f.bX< s.a._.a._._.t 0XZ.&XC.0.IX .!XZXmXs.,Xs._X@._.a f F.G.G.t f.}.} F fXZ.! f.}.<XmXZXZ.I.) b.I.IXZXZ b.I.I f.}.}.b g.aXZ L.0 f d.bXm. Xm.a gX@.a 4._X@ g 4XA.*.aX@.*XzX@.).*.0.*._XAXAXA.0XZXZXZ g.a._.< 0.b g.t.a g.a f.t._.}.}.}.a g.bXl f f.<X@.<X@.t.<X@ v.a.b f.< g.= g f f.b.a._XmXZXA.0XAXA.0XZX@X@X@XZ.)XZXZ._.I. XZ b.P b._XZXZ b b.IXA._ bXAXZ.).h._XA. .0.*XZ b.).,XC._.Y 0.,.!., 0.!XZ._ f.b.b.b.aX@._X@X<XZ.!XZXZ 0.&XC.<X@ d.a vXZ._.< v v f.} f f g v f.<.b v g.} F.G F f.b.b f.bX< s.a._.a._._.t 0XZ.&XC.0.IX .!XZXmXs.,Xs._X@._.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX- f f f.b.t.<XAXZ.0Xa.o.o.o.o.o.oX3.o.oX3.#.R.o.o.o.oX3.#X3.oXy.oXyX3.oXy.wX3X3Xy.#.oXy.oXyXy.wXyX3Xy.wXyXyXyX3.wXy hX3Xy [X3.X.ZX* +X0 9 7 9 7 7 7 9 7 7 7 7X0 7 7X0.J.M = = V V < e e.c e.wXyX3Xy.#X3.o.wXD.qXnX* + + +XGXGXGXG Z.s.Z ~ ~ DX1X1 D < R.oX3 ,.p ].oX3.o.o.o.oX3.o.C.o.o.o.o.o.o.o.o.o.o.o.o.oXD.oXH.o.o.o.oXaXH.oXH.oXH.o.o RXHXHXH.oXHXaXHXHXaXHXaXHXH RXg.oXH.o BXHXHXaXH.oXH BXHXH 2 2.oXa BXHXHXaXHXHXH.o 2XH }XHXaXHXHXH BXHXHXHXaXHXaXH }XH.eXHXHXa.eXHXHXaXHXHXa.eXH }.eXHXH.eXaXHXHXaXH.eXaXHXa n.eXHXHXHXa.e.f.f.f.f.f.fXSXA LXZXAXZXZ bXZXZXZ.=XlX@ LXA.*XZX@XAXC.,.P.Y._XZ.,.!Xm.Y.,XZ s g.a s._.a.<._.*XZXZ 0.IXZXZXZ.&._.tX@.! M d.; d.< dX@ v f.a.b f.b.a v d v f f.< g F.G.} f f f.=.b.*XZXZXZ._ 0 9.G.}.a.].Y.!.I 1X  b.!XZX9Xm., f.}.G F.G.G F.}.].,.& F.<.a f d f.b.b.*XA v.* 0.< LXZ |XZ., g F fX@XA.0XA.hX@X@ g fX@X<X@ CX@Xl.a.b f.tXA._X@.a.tX@.tX@._XZXZXZXZXA.0 gX@.0.t.<.]._XA.0Xm._XA.0.<._ s.a g.<.<.<XZXAX< f.b.].<.a.}.b.a g.<X@ v f f f.b.a.<XC.t f f f.b.t.<XAXZ.0XA.)XA._X@ 4XZXA.0.,.0._XC.,XZXZXAXA LXZXAXZXZ bXZXZXZ.=XlX@ LXA.*XZX@XAXC.,.P.Y._XZ.,.!Xm.Y.,XZ s g.a s._.a.<._.*XZXZ 0.IXZXZXZ.&._.tX@.! M d.; d.< dX@ v f.a.b f.b.a v d v f f.< g F.G.} f f f.=.b.*XZXZXZ._ 0 9.G.}.a.].Y.!.I 1X  b.!XZX9Xm., f.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T C f.b f f fXl.*XAX@Xa.o.o.o.o.o.o.o.o.o.o.oX3.oXy.oX3.oX3.oXy.oXy.o.oXy.oX3.#Xy.oX3X3XyX3X3X3.wX3X3 hX3X3XyX3X3 hX3X5XyXy.wXy 5Xg =Xm.J 9 7 9 7 9 9 7 7 7 7 7 7 7X0 7 7X. = =.q V ^.j eXo e.eXyX3X3Xy.o.g.ZXG W ' + M ' WXGXGXG Z.Z.ZXM ~ ~X1X1X1 ~.g.oX3.o.o.p.CX3.oXy.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.oXH.o.oXa.o.o.o.oXHXH.o.o.o.o.o.oXH.oXH.o.oXa.oXa.oXHXH.oXHXHXa.oXH BXHXH.o BXHXaXaXHXHXH 2.oXHXa BXHXH BXHXHXHXaXHXHXH B 5XHXaXHXHXHXH BXHXHXHXHXa.e.eXaXH.o.eXHXHXaXaXaXHXa.eXHXHXaXHXHXHXaXa.eXHXaXHXaXH.eXHXaXHXaXHXaXHXH.e.f.f.f.f.f.fXSXZXZXZ.)XAXZ.)XAXAXZXA.0XA.*X@X@XAX@Xm., bXsX@X@._XZ.,.Y._.< gX@X<.t.tX@ vX@X@._.I.!.! |.P.PXZX2 0.<XZ.Y.} 0 0X@.< v.a f.bX@.t.b.a g.b.a f f dX< P.}.}.} f.a.b g.a._Xm._._XZ.,.t v f.t f v 0XZX@.< 0.IXm._XA b I.G.G.G I.} I I.}.a.}.}.bX@.b f.<.} F.a 4.}._XZ.}._XZ |.Y 0 f.}.}.*XmXAXA.*.a.b g.aXAXA fXA._.aXl f f.< 4.* vXAXZ.*X@X@.) bXZXZXZXZ._XlX< sX@._XZXAXZ.0.0.0XmXZXZX<._._ s.aX2.aX@.a g g f f._ :.< F f g.t.a s.t.b g.<.].t.a.a f.b f f fXl.*XAX@X@XmX@.0XA 4XAXZXAXZXZXA._.,.!XZXAXZXZXZ.)XAXZ.)XAXAXZXA.0XA.*X@X@XAX@Xm., bXsX@X@._XZ.,.Y._.< gX@X<.t.tX@ vX@X@._.I.!.! |.P.PXZX2 0.<XZ.Y.} 0 0X@.< v.a f.bX@.t.b.a g.b.a f f dX< P.}.}.} f.a.b g.a._Xm._._XZ.,.t v f.t f v 0XZX@.< 0.IXm._XA b I.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.d.b.<.a v f f.a.aX@Xa.o.o.o.o.o.#.o.o.o.o.oX3.o.o.oXy.o.oX3.o.oXyX3.oXyXy.oX3.oX3.#Xy.oXyX3X3.wXyX3.wXyX3XyXyX3 hX3 hX3XyX3 hX3.l pX* ' 7 9 7 9 7 7 7 7 7 7 7 7 7 7X0 7 '.M =Xn V n.j.cXoXo.-.#Xy.oXy.4 _.q.1X* + + +.1 WXG WXG.Z.Z ~ ~X1X1X1 DX1 GXa.o.oXyX3.C.z.o.o.o.oXy.o.o.oX3.o.o.o.o.o.o.o.oXH.o.o.o.o.oXH.o.o.o.o.o.oXHXH.oXH.o.oXH.oXHXHXaXHXH.oXHXaXHXa.o.oXH B.oXaXHXH BXHXHXaXHXH , BXHXHXH BXHXHXH 2XaXH.eXHXaXHXH 2XaXHXaXHXHXHXH UXaXHXHXaXHXaXH.eXaXHXaXaXHXHXH.eXHXaXH.eXHXH.eXH.eXaXHXaXH.e.eXHXHXH.eXHXH.eXaXH.e 5.f.f.f.f.f.fX9XZXAXZXA.0XZXA.I LXA._._._X@X@X@XmX@X@XA.)Xs._.,XZ.t 0 s s f f._.t f v.<.< vX@._.,._XZ.! bXs b.I |.]., v d dXZ.< v d.<.b f v.aX<X@.<.a d d.aX< 4Xl f F.}.} f f F.}.<.<.<.,.t s M._ f.<.b f f.<.<X@XC.YXZ F v.t.} f.}.}._.P.G.} f v F F.}X@.,X@ f.b F.}.b.}X@.* s.tXZXZ g.<.b.b f.bX<.* 4.tX@ f.b.bX@.=.}XA g.b f.bX@ g gXl d._XAX@.) bXZ.) b.).IXZ g.b._XZXZXZXZ.) bXmXZXZXZXAXA._X@X@XZXA._XA._Xm.a.b f g.bX$ f.< d f.bX@.tX@ g.<._ gX@.a g.b.<.a v f f.a.aX@ v.]X@XA._._XAXmXmXAXZ.,.,XZXZXZXZXZXAXZXA.0XZXA.I LXA._._._X@X@X@XmX@X@XA.)Xs._.,XZ.t 0 s s f f._.t f v.<.< vX@._.,._XZ.! bXs b.I |.]., v d dXZ.< v d.<.b f v.aX<X@.<.a d d.aX< 4Xl f F.}.} f f F.}.<.<.<.,.t s M._ f.<.b f f.<.<X@XC.YXZ F v.t.}.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T C.a.b f fXl.b g g.tXa.o.o.o.o.o.oX3.oX3.oX3.R.oX3.#.oXy.oX3.#X3.o.oXy.o.#.w.o.#X3X3X3Xy.oXy.wXyXyX3 h.rXyX3XyXy.wXy.wXyXyXy hX3 {.s = +.J 7 9 9 9 7 9 9 7 7 7 7 7 7X0 7X0Xx = = t ^ u e e e.jXyXyXy { _.w.1 / + M + =XG WXGXG >.ZXM ~X1X1 u #X1 G.oXy.RX3.o.o.p.pX3.o.o.o.o.o.o.o.RX3.o.o.o.o.o.o.o.o.o.o.o.o.CXH.oXHXa.oXHXa.oXH.o.oXHXa.o R.o.o.oXH.oXaXH.o.oXaXHXH.o BXH.oXH BXHXHXaXH.o.oXH 2.oXH B BXHXHXH BXHXaXHXaXHXH.o } 2XHXaXHXHXaXHXH 2XaXHXaXHXa }XHXHXaXHXaXHXHXHXaXHXHXHXaXH }XH.eXaXHXaXH.eXHXaXaXHXa.e nXHXaXH.eXH.e.f.f.f.f.f.f.u.0XAXAXAX@._._XA._X@.b.a.b.t d f f.b.bXl.b f.b.a.bX<.b f.b d 0 f f f.t.<.a d.,.<XZXZ.IXZXZ.Y v.].Y MXA.t f f._._.<.t f.aX@ f.a.a.a.<.<.t._ vXC 0XA g.G dXA.<.<.t f.} d.<X2.a.a.t., f f f v.<.< fXZXZ.&.P.Y.<.Y v d.;.IXZ M.IXZX@.<.t d.a.,._X@.a f f f.}.} f.a.t g f f f.* f.b.=.a.tX@.a.bXl f f.} gX<.t.t._.b.0.aX@.0XAXz.tXA._.0._XZXAXZXAXAXZXAX@XAXAXZXZXA.0XAX@.,XAXAXZ.)XZXmXZX+X@XmXZ._XZX@XAXZXA f f f.a.b.b f dX2 v.a 0.< g.aX@ g.b.a.b f fXl.b g g.tX@.t gXZ._ 0._._.<X@XZXZ & &.k._._.0XAXAXAX@._._XA._X@.b.a.b.t d f f.b.bXl.b f.b.a.bX<.b f.b d 0 f f f.t.<.a d.,.<XZXZ.IXZXZ.Y v.].Y MXA.t f f._._.<.t f.aX@ f.a.a.a.<.<.t._ vXC 0XA g.G dXA.<.<.t f.} d.<X2.a.a.t., f f f v.<.< fXZXZ.&.P.Y.<.Y v.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.].aXAXA.b f g gX<._Xa.o.o.#.o.o.o.o.o.#.o.oXy.oX3.oX3.o.#X3.oXyXy.oX3XyX3.oXy.oXy.oXyXyXyX3.wXyX3X3.wX3XyXyXyXy hX3 hXyXyX3 hX3XyXg WX*Xm 9 7 7 9 7 7 7 7 7 7 7X0 7 7X0 7 = = =Xt V ^ e e.%.j {Xy :.l.p W / M M MXnXGXG WXG >XJ ~X1 ~ ~X1X1 ~ G.o.oX3.oXy.oX3.C.p.o.o.o.oX3.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.oXa.o.o.oXH.oXH.o.o.oXa.o.o.o.oXHXaXHXa.oXH.oXH.oXaXa.oXHXHXgXH.oXHXgXHXH.oXaXHXHXH BXH.oXH B.oXHXH _XaXHXaXHXHXHXa 2XHXHXHXHXaXHXHXa UXHXHXHXaXHXHXaXHXHXaXHXaXaXaXHXaXH.eXHXHXHXHXHXaXaXHXHXaXHXaXH.eXaXHXaXHXHXaXaXHXH.f.f.f.f.f.f.P.YXZ.0XAXA._ g v.a.b.}.} f.b.b.b.b.bXlXlXl.a f f.bXl f f f d c.} f d.<._.<X2._XC.,XZ. .Y.,.! v d.Y._.<.tX@ d.<._.a f.t.<._.} f.a._._._.<.0.t.< f.< g.G d.< v.a._.a f.<.t.].< f.< f v.W.< 0.&.YXC 0XA.!Xs.!.,.<.< 0.IXZ.I M d.a.a.a.*.b._XZ.IXA.<.0.=Xl f.G F.}XA g f F.}.< F.} f.b gX< f.b.b g.}.b.b f.tXAXA.bXAXZX<X$.b.b.aX@ 4XAX@.*.0XAXA 4XAX@XZ.0XAXZXZ.)XAXmXAXZXZXZXZXZXZ.0 LXZ.t.0XA._XAXZXZ.0XA._X@X<.} f f f.b f.}.G v.a g.a f f f.aXAXA.b f g gX<._ 4 4 4X<X@X<X@.a.<.t.<Xm L.)XZ 0 &.YXZ.0XAXA._ g v.a.b.}.} f.b.b.b.b.bXlXlXl.a f f.bXl f f f d c.} f d.<._.<X2._XC.,XZ. .Y.,.! v d.Y._.<.tX@ d.<._.a f.t.<._.} f.a._._._.<.0.t.< f.< g.G d.< v.a._.a f.<.t.].< f.< f v.W.< 0.&.YXC 0XA.!Xs.!.,.<.<.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.d.a.t._ f.}.bX@.*X@Xa.o.o.oX3.#.oX3.oX3.o.o.o.oX3.o.#.oXy.oX3.#.oXy.oXy.oX3XyX3X3XyX3.oXyXy.wXyX3Xy hX3XyXyX3X3 hX3.qX3XyX3.qX3Xy W.sX*X*.J 9 7 9 7 9 7 7 7 7 7 7X0 7 7X0 +XmXzXn.O ^.c e.j.j.R.o.R t W = + M + / WXG WXt >.s.ZX1 ~X1 ~ ~ ~ G.oX3.oXy.oX3.o.o.z.p.oXy.oX3.o.oX3.o.o.o.o.o.o.o.#.o.o.o.o.o.o.oXH.o.o.o.o.o.o.o.oXa.oXH.oXa.oXH.o.oXH.oXaXHXHXH.oXHXa.o 5 R.oXHXH B.oXHXHXaXa.oXH BXHXH.o _XHXHXH BXaXaXHXHXHXaXaXH 2XaXHXaXHXaXaXHXH 2XHXH.eXHXHXa.eXHXHXHXHXa.eXHXaXHXaXaXa.eXHXHXHXa.eXHXa.eXHXaXHXaXHXHXH.eXHXaXHXH.f.f.f.f.f.f.u 0.Y._._X@X< P.b P P.} F fXl P PX@XA.0X<Xl P.bXl.b.b f.b.b.} v.}.b f.<XC v d.]XZ._ 0XZ.Y.,XsXC sXZ._.0._.&X@.a f f fX<.t.}.} F v 0.<.<._._.< vX@._ f FX@.0.<.t.t v.<X@._ gXZ.t.b f.a vXZX@.<XZ.YXC.a.,.,._._._._._._XC.<.} f.} f.<.b f f.}XZXA.<.,.aX@.= F.G._ g.b f.}.b.b.}.G F.} v.b F.} f.}.}.b.}.b f.b.b.b.b g g.*.a.a.)Xm.0.!.)X@ 4X@X@.0 g.aXZXZ.).) L LXZXA.)XZXZXZXA LXZXA LXA.0XZXZ.)XZXAXZ._.0._._X@.a f f gX@ g v.G F f.} F.b.a g.a.t._ f.}.bX@.*X@XmX@.*X$Xl.b gX@._XA.<.<._XZXZ._._ 0.Y._._X@X< P.b P P.} F fXl P PX@XA.0X<Xl P.bXl.b.b f.b.b.} v.}.b f.<XC v d.]XZ._ 0XZ.Y.,XsXC sXZ._.0._.&X@.a f f fX<.t.}.} F v 0.<.<._._.< vX@._ f FX@.0.<.t.t v.<X@._ gXZ.t.b f.a vXZX@.<XZ.YXC.a.,.,._._._._.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T CX@.*X$Xl F.G.=.=XlXa.#.o.o.o.oX3.o.o.oX3.oXy.o.oX3.#.oX3.o.#Xy.oXyX3.#Xy.o.oX3X3XyX3X3Xy.wX3XyX3 hX3X3XyXyX3Xy.wX3 hXyX3Xy.qXyXyXy.w.zXm +X0 9 9 7 9 7 7 7 7X0 7 7 7X0 7 7 ' = =XB V.O.c.c.j 2 !XG.1X*.J.JXm W W.X W >.Z.ZXM ~ ~ ~X1X1 GX3.oXy.oXy.oXy.oX3.o ].z.oXy.o.oXy.o.o.o.o.o.o.o.o.o.oX3.#.o.o.o.o.o.o.o.o.o.oXa.o.oXa.oXH.oXH.o.o.oXH.oXH.o.o.oXaXH.oXaXH.o BXH.oXHXaXg.oXH.oXaXHXHXH BXHXa.o BXHXHXH BXa 5XaXHXaXaXaXHX;XHXHXHXHXa.eXH.oXH 2 5XHXaXHXHXHXHXaXHXaXHXaXa.eXHXa.eXaXa.eXa.eXHXaXa.eXH.eXHXaXaXHXHXHXHXa.eXa.e.f.f.f.f.f.fXS.,X@.a gXl 4XA.b gX<.b.} f.t.a g FXZX$XlXl g._.a g f f.}.}.<._._ v f.a 0.YXC.}.].n.!XZ._XA.! s._.<.< d.t.t f v.aX@.t._.b.}.< v v.a.<.t.a.,.,._.b v.}.t._XZ.0._.a.t.<.t d.<.,._XZ d.t.}._.YXA._._._.t.tX@X@.<._.<.<._XZ._.< d._.a f.} F.G F.a.YXA b L.h.* g C f f.}.}.}.} F F f f.b f f f f F I I.G.b F.}.b.b.b.b.0Xm._X@XAXZ._ b.).I bXAXZ bX< 4XAXAXZ.)XZ.)Xm.,XZXZXZXZXAXZXZXZXZXAXAXAXZXZXZXZXA.*X@X@XA._ 4.0._X@.}.a g.<.a.< f f v f.a.aX@.*X$Xl F.G.=.=Xl f f.a v.a.<Xl f.bX@X@X@.0._X@XZXA.,X@.a gXl 4XA.b gX<.b.} f.t.a g FXZX$XlXl g._.a g f f.}.}.<._._ v f.a 0.YXC.}.].n.!XZ._XA.! s._.<.< d.t.t f v.aX@.t._.b.}.< v v.a.<.t.a.,.,._.b v.}.t._XZ.0._.a.t.<.t d.<.,._XZ d.t.}._.YXA._._._.t.tX@X@.<._.<.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.; fXl.b F F F f.bXl.o.o.o.o.#.o.o.oX3.#.oXy.oX3.oXy.oXy.oXy.oXy.oXy.oXy.oXyXyX3.oX3.#X3Xy.wXyX3Xy.wXyX3XyXyXyXy hXy.wXyX3XyX3.qXyXy =.s /Xm + 7 9 7 9 7 7 7 7 7 7 7X0 7X0X0X0Xx = = Z V ~.j U _XG.1 +.J.J + W.1 W W p.s.Z V # ~X1X1X1 G.o.oXyX3.oXy.oX3.oX3X3.p.RX3.oX3.o.o.oXy.o.o.oX3.o.#.o.o.o.o.o.o.#.o.o.o.o.o.o.o.o.o.o.oXa.oXa.oXH.oXH.oXa.oXa.oXa.o.oXaXH.o 5XD.oXHXHXHXgXHXHXaXH.oXHXH BXHXaXH B.oXHXH _.oXaXHXaXHXHXH.oXH 2XH.oXHXHXaXa 5Xa U.oXHXHXH.eXaXHXHXaXHXaXHXaXHXaXHXaXHXHXHXHXHXaXaXHXaXaXHXHXaXHXa.eXaXHXaXHXaXH.f.f.f.f.f.f.IXA.<X<Xl PXAXA.b f.= f g f F.t g.G.t.*.t.aX@X<.aX<.b f F.}.<._X@.} F.<.;XC |., |.Y.,.!XZ._XZ M.<.<.b.}.} f f d v.a.a f._ v M d.a v._X@ v M.,.<.t.b v sXZ._XZ._.b g.<.< d._.< 0.<._ g.}XZ._XA._XAXZ._.< C f f.<XZ. .I v._X@ f f.t f f.} F.} 0.  |Xs.)XzXAX@.).t.b f f F F.} I.} f g.*Xl fX@ f.G I.G.b f f.b f.bXlX@XzX@X@X@XA.,XAXZXAXAXZ.0XA g.* 4XZXZXZXZXAXA._ LXZ.)., LXZXA LXZ 4._XZXA L L.)XZXZXAXA._XZXAXAXmX@ f vX@.<._ g.} f v.;.a v fXl.b F F F f.bXl.b g vX<.tX@ g f.a.b f gX@ MXmXmX@XA.<X<Xl PXAXA.b f.= f g f F.t g.G.t.*.t.aX@X<.aX<.b f F.}.<._X@.} F.<.;XC |., |.Y.,.!XZ._XZ M.<.<.b.}.} f f d v.a.a f._ v M d.a v._X@ v M.,.<.t.b v sXZ._XZ._.b g.<.< d._.< 0.<._ g.}XZ._XA._XAXZ._.< C f f.<XZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.].b.} F.G.G F F F.}Xa.o.o.o.o.o.#.oX3.o.o.o.R.oXy.o.oX3.#X3.oXy.oXyX3Xy.o.w.oXyX3X3XyX3X3X5X3XyX3 hX3.rX3XyXyX3.qXy hXy.+X3X3 hXy hX3XDXGX* + 7 7 9 9 7 7 7 7 7 7 7 7 7 7X0 7Xz = =.q ^ ^.jXg.z.4 /.J.J MXx WXx.1 [XJ.ZXM ~ ~ ~ ~X1 G.oXy.oX3Xy.oXy.o.w.oXy.o ].zX3.#.oX3.o.o.o.o.R.o.o.o.o.o.o.# M.#.o.o.o.oXD.o.o.oXHXa.oXa.o.oXH.o.o.o.o R.o.oXH.oXHXHXaXHXHXa.o.o R BX3XH BXaXaXH.oXHXH.oXH BXH.o B _XHXHXH.o 2XHXa.eXaXaXHXH B 2XHXHXaXHXHXHXaXHXH 2XHXH }Xa.eXa.eXHXHXHXHXaXHXH.eXHXH UXHXaXaXHXHXaXHXaXHXa.eXaXH U 5Xa.e.eXa.e.f.f.f.f.f.fX4.t.b.bXlXAXAXZ.b.}.* g g.} F.}.b f f g g f.t.<.<.<.b.} F.}.;XZ.,.t.b.a.].].!.!.!.Y.Y.,XZ.< v v.b v f.}.}.}.}.}.b f.a.aX@XC g d._.<._.t.t.]._ f.b f d.<._._.k._.<.0.Y.t.<.t.<XC.<.t._ f.a._.<.t sX@ g v v.a v.<.0._XA.<.<.< v f f.b f F F.a.I.) L L LXAXA.* L.aXA.*Xl F F F f f f.aX$ fX@.)XA._ d.} f d.< v f f gXl.b gX<._.<XAXmXZ.0.tX@XZ g.a.aX@.) LXZXZXZ._X@XZ.IXZ._XZXZ.,XZXAXAXZXAXZXZ.) b.IXZ.IXZ.0XAXAXAXA._X@ f v.tX@.<.b f.<.< d f.b.} F.G.G F F F.}.b g g.*.a.t g g.a.b f f.b.b.a.a.<.t.b.bXlXAXAXZ.b.}.* g g.} F.}.b f f g g f.t.<.<.<.b.} F.}.;XZ.,.t.b.a.].].!.!.!.Y.Y.,XZ.< v v.b v f.}.}.}.}.}.b f.a.aX@XC g d._.<._.t.t.]._ f.b f d.<._._.k._.<.0.Y.t.<.t.<XC.<.t._ f.a._.<.t sX@ g v v.a v.<.0.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX@.a g f.} F f f f.}Xa.o.oXy.o.oX3.o.oXy.oXy.oX3.o.oXy.o.oXy.#X3Xy.oXyX3XyX3XyX3X3XyX3Xy.wXyX3X3Xy.wX3XyXyX3X3X3 hX3Xy hXyXy.+ [XyXyXy.g.sX*Xm.J 7 7 9 7 7 7 7 7 7X0 7X0 7X0X0 M.MXn = V ^ ^ p.4 / M.J.J.1X..1Xx [XJ.sXM ~X1 ~X1X1 hXHX3X3Xy.oX3.#.oX3.oX3.oX3.p.CX3.oX3.o.oX3.oX3.oX3.oX3.o.o.o.o.o.o.o.o.o.o.o.o.o.o.oXaXa.o.o.o.o.oXa.oXa.o.oXH.o.oXa.oXHXa.o.o 5 BXHXHXHXHXDXaXaXHXHXHXaXHXH B.o.eXH.o BXHXH.o 2Xa 5XaXHXHXaXHXHXH BXHXHXHXaXa.eXHXaXH 2XHXHXHXaXaXaXHXaXHXHXaXHXaXaXHXHXaXHXH.eXaXaXH.eXaXHXHXaXHXH.eXHXH.oXH.e.e.f.f.f.f.f.f.).b g.=X@.= f.G F F.} f.}.G f._.t f f f f g f._.b.} F F.}.} f.aX@.} d.<XCXC.Y._.!.,.YXmXZ._.<.}.G F f f.} f f.a g.b.b.a._.t.< v.b F.} d.<X2.<._.,XZ d f v v._.t.a.a v v d.< d d.<.* g.b.}._XA.a.t.b F F.} vX@XA._X@.t f.< v.YXZ.t g.} FX@Xm g g.!.,.) LX@.<.< g.b.a g.b f f F f.} g.<X@._X@._ L.I b.) L.I.IX9Xs b.I b g.b f g.bXN.b.a.bXA.b f.b g.aX@X@ gXl.b.*Xm.0XZXZXAXAXZXAXAXZXZXZXA.)XZXAXZ.)XZ.0XZ.,. XA LXZXZ._X@.< v._ g.b f d.t._X@.a g f.} F f f f.}.bXl.}X@.<X@.aX@.*.tX< g.b f f.bXl.b g.=X@.= f.G F F.} f.}.G f._.t f f f f g f._.b.} F F.}.} f.aX@.} d.<XCXC.Y._.!.,.YXmXZ._.<.}.G F f f.} f f.a g.b.b.a._.t.< v.b F.} d.<X2.<._.,XZ d f v v._.t.a.a v v d.< d d.<.* g.b.}._XA.a.t.b F F.} vX@XA._.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T C c.b.t.b.b.b f.b.aXa.o.o.o.#.o.oXy.o.o.o.o.oX3.oXy.oXyXy.oX3X3.oXy.oXy.oXy.oX3Xy.oXyXy.wXyX3X3.w.+X3XyXyX3XyX3.qXyX3 hX3XyX3.wX0XyXy ,.Z.1X*Xm 9 7 7 9 7 7 7 7 7 7 7 7 7X0 7X0XV = = > V.Z.1 = +.J.JXnXx.1 WXG.s.sXM ~X1 ~X1X1.rXHX3.#Xy.oXyXyX3.oX3X3X3.oX3 ].pX3.oX3.oXy.o.o.o.o.o.o.oX3.o.o.o.o.oX3.o.o.o.o.o.o.o.oXH.o.o.o.oXH.o.o.o.o.oXH.o.oXH.oXHXH.oXHXa.o R M.o ,XH BXH.o.oXHXHXaXH.o _XH.oXHXH BXH.oXH _.oXHXHXHXaXH.oXHXH 2XHXaXHXHXHXaXHXHXH UXHXHXaXHXHXHXHXaXHXa 5XaXHXa.eXHXHXHXaXaXHXaXHXaXHXaXHXaXHXaXHXaXH.eXaXHXH.f.f.f.f.f.fXZ.b f.bX@.*.b F.G F.}.}.}.} dXZXm f g.b.bX@ g g f.} F F f.} fXC._.a f.].<XCXC 0XCXZ.!.,.Y.t f f f.} f.b f.} f f f.} d.<X@.t v f.G F.< v.,.Y.<.Y.I.!X@ v.a f.<.<.t.a.t.a.b f d MX< f g.}.}.} f.}.}.}.} f fX@X@X@._.t fX@._ f 0 0._.b f.}.<X@.<.].!.Y b LXm.0.* d vX@XAX@ sX@ F.}.b.<XAXZXZ.) L.I b.I.IXs.I.IXsXs b b.PXA f._XZXZ b.I.)._ f f g.b f.b._X@.0X@XAXA.)XZXZXAXAXAXZ.).I LXZXZXAXmXAXZXZXZ.I. .,XAXAXZXZXA.0.,XAX@ f.tX@X$.b.}.<.<.a c.b.t.b.b.b f.b.a.b.} F.t.*X@.t g g.b.aX@.a.b f g.b.b f.bX@.*.b F.G F.}.}.}.} dXZXm f g.b.bX@ g g f.} F F f.} fXC._.a f.].<XCXC 0XCXZ.!.,.Y.t f f f.} f.b f.} f f f.} d.<X@.t v f.G F.< v.,.Y.<.Y.I.!X@ v.a f.<.<.t.a.t.a.b f d MX< f g.}.}.} f.}.}.}.} f fX@X@X@._.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.; g.b.a.b.bXl.}.}.}.o.R.#.o.R.o.o.R.o.o.R.#.p.o.o.R.#.o XX3.o XX3.o.w.oXy.wXy.wXyX3.wX3X5.wXyXy hX3X3 hXyX3 hX3.w hXy hXyXy h hX3.wXyXy t pX* 'X0 7 7 7 7 7 7 7 7X0 7X0 7X0 7X0 ' = =.X V t = M.J M 'Xx W.1XG.s.s V ~X1X1X1 DX1 5Xy.wX3.o.w.o.o.w.oX3.RX3X3.R.p ].RXy.R.#X3.R.oXy.R.o.o.R.o.o.RXa.#XD.o.o.o.o.C.oXHXD.o.oXDXH MXD.o.o R.oXH R.o R.o.o R.o.o RXHXH BXDXH RXH.oXDXaXH B.oXH BXa.o BXHXH BXH _ B.oXH BXH.oXaXa }XHXH 2Xa 2 2XHXa }XHXa UXHXH 2XH UXaXH }XHXa UXaXH }XaXH n.oXH UXH nXaXa U.eXH UXaXH U.eXH UXHXa n.eXa.e.f.f.f.f.f.fXZ f f.b g.aXm F F I f f.b.} f.< g d.<.=X@._X@Xm.b.} F.} g.a g.<._._ f f.<._XC.,.,.YXC.<.t.} F.} f f v f.b f f f.}.< v._._ d F F.GXZ._._._XZXm M.<XC.< g f d.< 0 g g.t.b d v.a v.a PXl f.}.} f.b f f f.aXl g.b.< v.a.t.0 M.a.b f.b.b f.b.a.  d.,.P.!.0.* g.)XA.<X@XA.*Xl.=.=X<.b f.,.)XkXsXsX9Xs.PXs bXZ.I bXk.I.P b LXA.<.P b.I.) L.) L g.b gX@X@X@.).I. XZXZXZ. .I b.0XAXAXZ.). .) L.)XZXZXZXZXZXAXZ._XA._XZXA.Y.0XZXmXA.0.a.} f f.b.} F f v g.b.a.b.bXl.}.}.}.}.} f f.} vX@.* g g.a.t.aX< g g.b f f.b g.aXm F F I f f.b.} f.< g d.<.=X@._X@Xm.b.} F.} g.a g.<._._ f f.<._XC.,.,.YXC.<.t.} F.} f f v f.b f f f.}.< v._._ d F F.GXZ._._._XZXm M.<XC.< g f d.< 0 g g.t.b d v.a v.a PXl f.}.} f.b f f f.aXl g.b.< v.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.Q._.t.aX@ F.GXl.bXlXa.o.o.o.o.o.o.o.o.oXy.o.oX3.#Xy.oX3X3.oX3Xy.oXyX3X3.oX3.o.o.oXyX3X3.wX3XyX3.wXyX3XyXyXyX3XyX5XyX3 hXyXyXy hXyXyXyXy 3.s /Xm + 7 9 7 7 7 7 7 7 7 7 7X0 7 7 7.J WXn = VXG +X0.J +Xx.1XnXG Z.Z V # ~X1 DX1 D.CX3X3XyX3.oXyX3X3.#Xy.oX3X3.oX3.p.p.o.o.oX3.o.o.#.o.o.o.o.o.o.o.oXa.o * {XF X.r.r.V :XHXHXa.o.o.o.oXH.o.oXH.o.o.oXHXaXHXHXHXHXHX3XHX3 BXHXH.o 5 BXHXaXH.oXHXaXHXH RXHXa 5.o BXHXHXH BXHXHXaXHXH.oXaXHXHXH _XaXHXHXa 5XaXHXaXH.oXHXHXHXHXaXa.eXHXHXa 5XaXa.eXHXH.eXa.eXaXaXa.eXH.eXH.eXHXaXHXHXa.eXHXa.e.f.f.f.f.f.f.Y F F.} f.} f f.} f.b f.<.a f f F._ g dXZX@.*XA v f.} F.}.<Xm.a.aX@.< f d f._._.Y.Y._X@ v.<.t.} v f.} f.< v.G fXNXm._X@ f 0.<.<., L.&XZ.,XA.t f.}.G v.}.WXZ.I.I.<.b d d g v f.}.}.<.b F f f.b f.b.bX< f.aX<X<.b._X@.<., v.}.b.}.b.b fXl gX@XA b.! 0Xz L.=.*XA.h b b bXAXAXA f FX@.PXsX9X9 bXsXs.I bXZXZ.P b.I bX9X9XZXZXsX9 bX9X9Xs.)X@.0.) b.!.I.IXZX@XAXA.I.)XZ.)., L.I.IXZ.,.)XZ bXZ.)XZXZXZ._XZXZXZXZXZ.) L bXZXZXZXZXZ.0XA._.} f.} f.b F._.t.aX@ F.GXl.bXl g.b.b f f f.}.} f f.<.t g.a.t.b f F F.} f.} f f.} f.b f.<.a f f F._ g dXZX@.*XA v f.} F.}.<Xm.a.aX@.< f d f._._.Y.Y._X@ v.<.t.} v f.} f.< v.G fXNXm._X@ f 0.<.<., L.&XZ.,XA.t f.}.G v.}.WXZ.I.I.<.b d d g v f.}.}.<.b F f f.b f.b.bX< f.aX<X<.b._.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.] d._.* f f.} g g gXa.o.o.o.o.o.oXy.o.o.o.oX3X3.o.oXy.o.oXy.o.oX3.o.oXyXy.oXyXyX3XyXy.wX3XyX3X3X5XyXyX3XyX3XyXy hXyX3 hX3Xy.+ hXyXyXyXy.+.sXGXmXmX0 7 7 7 7 7 7 7X0 7X0 7X0 7X0X0 = =XnXnXnX0 M M W.1.1XG Z.s VXMX1 ~X1X1X1 $ 5.oXy.oX3Xy.oX3.oX3.oXy.oX3X3.o.p.p.o.o.o.oX3.oX3.o.o.o.oX3.o.oXHXF G G G GXF.r X.R A U XXa.oXH.o.o.oXH.o.oXH.o.o.o.o.o.o.o.oXHXHXHXDXH.o.o.oXDXH.o.oXaXHXaXH.oXH BXH.oXHXH B.oXHXaX;.o.oXHXaXHXaXHXHXH.o }XHXHXaXaXaXHXaXHXH nXHXaXH.eXHXHXaXaXHXHXaXaXHXaXHXHXaXHXaXHXHXHXHXaXHXHXHXa.eXH.eXHXaXH.eXH.f.f.f.f.f.f.Y f g.b.}.}.b g.} F.} f vXl f.} f.} f f.<.a.Y._.}.}.G.G F.}.t f gXl.a F f f.< 0._._ v.<.<.a v.}.}.} F.]XZ f.G.;.< v f fX@XZ d.<XZ.*.}.<.t 0._.t.b.}.t.}XN.IXsXs._ v.b v.<.t v.t f f.}.G f f f d f.b.).b fX@X< v d v.<X<.b.}.t v.a f fXl.b f.<.).!.t.* 4 M.<.<.t.).Y.I.b._Xk f.}.a.PXs bXsXs.I.,XZ.I.!.IXZ b.I bX9XsXZ.IXsXs b.PX9X9 bXm b.I b.I b b.IXZ._XZXZXZ b.I.  b b.I.IXZXZXZ bXZ b b.)XAXZ.)XZXZ.)XZ. XZXZXZXAXZ.0XAXZ._._.}.} F f f f d._.* f f.} g g g g.b.b.b f f f.} f f f.b.b g.b f f f g.b.}.}.b g.} F.} f vXl f.} f.} f f.<.a.Y._.}.}.G.G F.}.t f gXl.a F f f.< 0._._ v.<.<.a v.}.}.} F.]XZ f.G.;.< v f fX@XZ d.<XZ.*.}.<.t 0._.t.b.}.t.}XN.IXsXs._ v.b v.<.t v.t f f.}.G f f f d f.b.).b fX@X< v d.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.d F d v.}.bXl.b.b.aXa.o.o.o.o.o.o.o.o.o.#Xy.R.oX3.o.oXy.oXy.oXy.oXyX3Xy.o.wXyX3XyX3X3.wXyX3XyX3 hX3Xy.wXyXyXyX3 hX3Xy hXyXyX3Xy h.qXyXyXy.g.s 'Xm.d 7 7 9 7 7 7 7X0 7 7X0 7X0X0X0 M =XnXn +.J.J =XxXnXx.8.Z.OXMX1X1X1 DX1 U :XyXyXy.oXy.#X3X3X3.oX3.o.w.oX3.o.p.zX3X3Xy.oX3.o.o.o.RX3.o.oXH {.-XF 3 3 Y { 3 3XF.-.r X R ^.-XaXaXaXaXH * 3 3 B.oXaXHXaXHXaXH.o.oXH B.oXH BXH BX3XHXHXaXHXH.oXH.o _XHXH B.o 2XHXHXa _XHXHXHXHXaXHXH BXHXH 2XHXHXa 5XaXHXHXaXH 2 nXHXHXaXaXHXHXHXa.eXHXHXHXHXH nXH.eXaXHXa.eXHXHXHXHXHXaXa nXaXaXHXaXH.e.f.f.f.f.f.f.Y f.< g.b.a.b f F fXl.b.b f F F.G F.} g.}.G.} f.G I I I.G F.} f f.b._.}.} d.<.<XC s._._ 0.t f.b.}.}.} v.< f.}.} f v d.b.<.,._.t v g.b.< v.;._ v f |.!._.Y b.PX .IX@.t.b f.a.a.a.t F.}.G.b f.b f f.b g.}.} f d g.bX@.0 4XAXA f.b f v.<.*.b f f._ L.tXAX@XCXe FX2XZ.Y.I.].).I.I.0.aXAXm.I b.I.I.I.I b.) b.I b b.I.I bXZ.P.I b.I.I.I b.*.,Xs b b.I.I.I.I.)XZXs.I.0XZ.)XZ.I.I b.,XZ.).I.I b.I b. Xm.) b.I bXZ.IXZXZXZXAXZXAXA.0._._XZ.<.b.}.} v g F d v.}.bXl.b.b.a gX@.b.b fXl.b.b.b 4.*XA.* 4XA f f f.< g.b.a.b f F fXl.b.b f F F.G F.} g.}.G.} f.G I I I.G F.} f f.b._.}.} d.<.<XC s._._ 0.t f.b.}.}.} v.< f.}.} f v d.b.<.,._.t v g.b.< v.;._ v f |.!._.Y b.PX .IX@.t.b f.a.a.a.t F.}.G.b f.b f f.b g.}.} f d g.b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.].b.b F.b f.b g g.bXa.o.#.o.o.#.oX3.o.oX3.oXy.oX3.oXy.oXyXaX3.#X3.oXy.oXy.oX3Xy.oX3Xy.wX3XyXy.wX3XyX3XyXyXyXyXy.qX3X3 hXyXyXyXy hXyX3XyXyXH.s.1XmXm 7 7 7 7 7 7 7 7X0 7X0 7X0 7X0X0.1 =Xm.J.J / W.1Xx t.Z.Z ~ # DX1 DX1X1 {Xy.#.oX3X3.oX3X3.oX3Xy.#X3.oX3.oX3 ].p.o.o.o.o.o.oX3.oX3.oXH {XFXF Y * 5 5 * 5 5 { 3 3 o.-.r.R U.RXH YXF.r.V.r $ A.r {Xa.oXHXa.oXH.oXHXD.oXH.oXHXDXHXHXaXaXHXaXH.oXH B.oXHXHXH BXHXHXH.o BXHXaXHXaXHXaXaXHXHXH 2.oXaXHXaXHXaXHXHXH 2XHXHXaXHXHXaXaXHXaXHXH.eXaXHXHXHXHXH.eXaXHXH.eXH.eXHXHXaXHXHXHXHXa.e.e.f.f.f.f.f.f.DX@.< f.}.a.Y b LXA.a f f vXAXZ g.0 v 0.b.} MXA.b f.b fXC.<._XC.t.a.} f v.}.} d.t s.tX@ v f f F f F.b f d f.}.}.Y._ 0 b.0.!.<XZXA f d.,.b.b.b g.<.!._._.t._ M.0._.I.!.< f.a._ g g.b.}.} g f.}.b.b.bX@.b gXA g.b f f.`XA.).)Xl.b f._X@._.b.bXA L.a g fXmX@ v fX@XZ b.YXZX7 0.) LXA &.!.P b b.IXs.I b.I.!.IXsX9 b b.0.IX9Xs.PX X9Xs 0 b.P bXs b.PXs b.P.I.I.) L.I._._.).) LXZ.I.I b._XAXZ.)XZX@ bXs b.IXZ LXZXZXAXZ.0XZ LXZ.I.)XZXAXA.t f.b f f.b.b F.b f.b g g.b.b f.bXlX<.tX@ g.=XZXZXAXA.t f.<.tX@.< f.}.a.Y b LXA.a f f vXAXZ g.0 v 0.b.} MXA.b f.b fXC.<._XC.t.a.} f v.}.} d.t s.tX@ v f f F f F.b f d f.}.}.Y._ 0 b.0.!.<XZXA f d.,.b.b.b g.<.!._._.t._ M.0._.I.!.< f.a._ g g.b.}.} g f.}.b.b.bX@.b gXA g.b f.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T C.aXl.b.b.b fXl g.aXaXa.oX3.o.o.o.oXy.o.o.oX3.oX3.o.#.oXy.oX3X3.oX3.#X3Xy.oXyX3XyXy.wXyX3.#XyX5X3X3XyXyX3X3XyX3.wXyX3 hXyX3XyXy h.+XyXyX3X3.q.zX*Xm.J 7 7 7 7 7 7 7X0 7X0 7X0X0X0X0 ' /.JX0 + WXnXx p.Z.Z ~ ~X1X1 D DX1 {XyX3XyXyX3.oX3.#X3.oX3.oX3.oX3X3XyXH.p ]X3.o.o.oX3.o.oX3.oXa 3 * Y 5XH 5XH 5X- 5 5 5 : - 3 o o G.R.i.rXFXFXFXF @ G.r A n.gXa.oXa.oXHXHX3 B.oXHXH.oXgXHXH.oXaXaXHXHXH.o 2.oXHXH.o 2XHXH.oXH 2XHXHXHXHXa 5XHXHXHXa 2XHXHXHXHXaXHXaXHXH.o nXaXHXHXaXHXHXH.eXaXHXHXaXHXa.e.eXaXaXHXa.eXHXaXHXH.eXHXHXa.eXaXHXHXH.f.f.f.f.f.f.u v.; f.}.bXZ b b. XZ g.0.) bXZXA M._ 0 f.}._XZXl.}.t 0XA.<X@._.< M.Y.a d f.}.} d.<.< s v.} d F.}.G f 9.t f.G.<.YXC.<.& dXZ.,XZXm f._._X@ v f f._._X2X@.<.a d :.I b.!.a.& C._.}.b.a.} fXl f.b.a gX@ g.b.< g g gXl gXl f.b.b.b.b f.bXl P f.bX@ LXA g.a.a g.Y.<X@Xz L bXZ.YXw.,.IX@.I b bXs.I.!.P.P.I.I.I.I.I.P bXZX@.I.P b.I.IXsXAX9X9XsX9X9 b.I.IXs b bXsXZXZ.I._.Y.) bXZXZ b.!.IXA.tXA bXZ._ b.I.) b bXZXZXZXZXAXZ.0XZXZ L.IXZXZ.0._ vX<.b.b.aXl.b.b.b fXl g.a f f.b.bX@ g.* gX@XZ bXZ.0._X@X@._ v.; f.}.bXZ b b. XZ g.0.) bXZXA M._ 0 f.}._XZXl.}.t 0XA.<X@._.< M.Y.a d f.}.} d.<.< s v.} d F.}.G f 9.t f.G.<.YXC.<.& dXZ.,XZXm f._._X@ v f f._._X2X@.<.a d :.I b.!.a.& C._.}.b.a.} fXl f.b.a gX@ g.b.< g g gXl.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T._.tXl.b.} v g f gXlXa.o.o.o.o.o.#.o.o.o.o.o.RXy.oX3.oXy.o.#.oX3.oXy.oXyX3.w.oX3XyX3.wX3X3XyXy.wXyX3Xy.wXyXyX3Xy hXyX3 hXyXyXyX3 h.wXyXyXyXy {.Z =X*Xm 7 7 7 7 7X0 7X0 7X0X0 7X0X0 7X0.JX0.J.1 =.1 p.Z ! ^ ~ # DX1X1X1 3X3.w.oXy.o.#X3Xy.oX3X3.oXy.oXy.p.o.oX3.p.p.o.oXy.o.o.o.o.o.R { { *XH.oXH , , , ,X-X-X-X- 5.{ o o G h.R.- Y * 5 Y { 3XF.r.R ^ A.o.oXa.oXa B.oXH.o $XH B.oXHXaXHXHXa.oXHXH BXaXH RXH BXHXHXHXH BXHXHXHXaXaXH.'XHXHXH.o 2XaXHXHXHXaXHXaXH U BXHXHXH.eXHXa.eXaXHXHXHXHXH }XHXaXHXH.eXHXHXH.eXHXaXHXa UXHXHXa.eXHXH.f.f.f.f.f.f.u vX@ v.a gXAXZXZ.)XZXZ b b b.I b.,._.!.aXNXZ._.a v.a d.<X2X2.; v.a.<XZ.t.<.a.b F.}.b f.}.} f.}.G F f d v.G.W M.<._X2._.}.,XZ.I.I d.YXZ s g.<.<.P.E._XA.<Xm.b.<.!._.;.tXZ d F.GXl.}.}.b.b f.a P.=X< f.b.a.b 4 g.b.b f.} f f f.b.b.=Xl.`X<X@.Y LXAXA._X@ fXs b.tX<XZ bX@XAXZ.,XZ.t bXZ b.IXZ.I b.IXs bXsXs.! b.IXZXA.P.I bXk.!.)XA bX9X9 )X9.P.!X9.P b.PXs.).I.I.PXs b LXZXZ.IXZ.!. .0XZXZ._XA.I bXZ.IXZ bXZXZ.)XZXZXZXZ.).IXZ LXZ._.0 g v.a._.tXl.b.} v g f gXl.}.} f g.t._.*XAX@XAXA LXA.0XZ._._ vX@ v.a gXAXZXZ.)XZXZ b b b.I b.,._.!.aXNXZ._.a v.a d.<X2X2.; v.a.<XZ.t.<.a.b F.}.b f.}.} f.}.G F f d v.G.W M.<._X2._.}.,XZ.I.I d.YXZ s g.<.<.P.E._XA.<Xm.b.<.!._.;.tXZ d F.GXl.}.}.b.b f.a P.=X< f.b.a.b 4 g.b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX@.t.t 4 d.b.} F.} fXa.o.o.o.o.o.o.o.o.o.#.oXy.o.o.oXy.o.oX3X3.o.oXyX3.#X3.oXy.oX3X3.rX3X3X3Xy.wXyXyX3XyX3XyXyXy hX3Xy hXyXyXyXy.wX0XyXyXyXyXy.sXGXmXm.J 7 7 7 7 7 7 7X0 7 7X0X0X0X0.JX0.JX0.1XnXV.Z !XM ~X1X1X1X1X1.-Xy.oXyXy.oXyX3Xy.oXy.oXy.oXy.oX3.o.oXy.o ].zX3.o.o.oX3.oXyXH { *XH.o.oX3 ,XH , ,X- , , , ,X-X- 5 - o oX5 YXH 5 5 5 5 3 3.-.r.R ^.wXHXa.oXH $XH.oXHXHXHXD.oXHXaXH.oXHXaXH.o BXHXHXHXHXgXH.oXHXa _.oXaXHXHXH.oXHXHXH.o 5 }XHXaXHXaXHXaXHXHXHXH }XHXHXaXHXaXaXHXa.eXHXHXHXHXHXHXaXHXaXa.eXHXHXHXHXHXa.eXHXaXHXaXa.e.f.f.f.f.f.f.u._.t.< f.<._._. .,XCXmX2.!XsXZ.I.I.Y.YXm.<.<.a s g 0XZXA.!XsXZ 0._._ f.a v.a.a.t f I F.}.}.G f F F.}.b f.}XZ b.t.a v c.}.}._XZ.,XZ M 0.,XZXs.Y.I.IXZ.IXZXZ._XZ v.< H F v f.b.GX7.b.} f f.a s fX@X< f f fXlXlX<X2.<XZXA.* g.b.b.*Xl 4._.).I.,XAXZ.<XA.t.0Xm.tX<.0XAXz.b.b.b F.aX$ b.I.).)XZ b b.I.P.I.I b.P LXZXA.!.PXZXZ., LXZ b bXsX9XsXsXsX9X9X X9XsX9X9.I b.IXsX9.I.PXZ.IXZ.I.I LXA.0XA.I b b bXAXZ.,XZ.!.) LXZ L.IXZ b b.I.)XZXm.<X@XmX@.t.t 4 d.b.} F.} f.b.} F.tX@.t.*X@.*.0 L b._._XZXZ.0._.t.< f.<._._. .,XCXmX2.!XsXZ.I.I.Y.YXm.<.<.a s g 0XZXA.!XsXZ 0._._ f.a v.a.a.t f I F.}.}.G f F F.}.b f.}XZ b.t.a v c.}.}._XZ.,XZ M 0.,XZXs.Y.I.IXZ.IXZXZ._XZ v.< H F v f.b.GX7.b.} f f.a s fX@X< f f fXlXlX<X2.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX-X<X@.< v g f f.b fXa.#.o.o.o.#.o.oX3.oX3.o.oX3Xy.o.oXyXy.o.oXy.o.oXy.oX3Xy.oX3XyX3.wX3X3X3Xy.wX3XyXyX3XyXyXyXy [XyXy hXyXyXyXy hXyXyXyXyXyXy.g.s 'Xm ' 7 7 7 7X0 7X0 7X0X0X0 7X0X0X0.JX0 +XnXG.s.Z.OX1X1X1X1 D ~.g.oXyX3XyXy.o.oXy.#XyX3X3X3.oX3.oXy.oX3X3X3.p.RX3.oX3.o.o.o.o { *XH.o.o ,X3 , , , , , , ,X- , , ,X-X- o.X h , , ,X-X- 5 - -.X G hXg ^ 3XaXaXH R.oXH.oXHXg.oXH.oXaXHXHXaXH.oXH BXH.oXH.o BXHXH.oXH BXHXaXHXHXaXHXHXaXaXHXa 2XaXHXHXHXaXHXaXHXaXH _XHXHXaXHXHXHXHXaXaXHXHXHXHXHXaXaXHXHXHXHXHXH.eXHXaXHXHXaXHXaXH.e.e.f.f.f.f.f.f.u._ f.} F g.aX@ b.Y |.}.,.! bXZ.Y.E.!.I v.<._ d._.*.<._._.,.< 0 MXZ M f f.<.,.t.b.}.} F.} f.G f F.G d.;.b FXC.t._ f.} d.b.}.YXZ.P v 0.Y.YX@XZ bXsXZ.!.,.!XZ.< f F f F.G f.aXC f f.b f.b.b.b.b.b P g.b f.b.}X< 4XZXZ.!.a.t._XZ._._XZ.b.bXmXA bXZ.I.IX+XZXZX@ 4.*.y. .=XA._.< FX2 fXZXZ.  b b bXs bXs bXs.I.)XZXZXZ.IXZ.I.IXZX@.).I.IX9X  b.IX9.PXsX9X9 b.IX XsX9 oXsX9 b.I b b b.I b.! bXm.I bXZ.).!XZXZXZ.I.I.! bXZXZ._XZXZXZ LXZ.0._.a.t.t.tX<X@.< v g f f.b f F.}.}.tX@XmX@._X@XA._XZ._ s.<._._._ f.} F g.aX@ b.Y |.}.,.! bXZ.Y.E.!.I v.<._ d._.*.<._._.,.< 0 MXZ M f f.<.,.t.b.}.} F.} f.G f F.G d.;.b FXC.t._ f.} d.b.}.YXZ.P v 0.Y.YX@XZ bXsXZ.!.,.!XZ.< f F f F.G f.aXC f f.b f.b.b.b.b.b P g.b f.b.}X< 4XZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX<X@ g.t.<.a.tX<Xl.bXa.o.o.o.o.o.o.o.o.o.o.o.R.o.oX3.o.#.oXy.oXy.oXy.oXy.#.wX3.oX3.wX3XyX3Xy.wXyXyXyXy.wXyXyXyX3 hXyXy.qX3XyXyXy h hXy MXyXyXyXH.Z.1XmXm 7 7 7 7X0 7X0 7X0 7X0X0X0X0X0X0.J.1X..sXJ.OX1X1 D eX1X1 hXHXyX3X3.w.oXyXy.o.oX3.oXy.oX3.#Xy.o.w.o.oX3 ].p.o.o.o.oX3XH * 5.o.oX3Xy.+ , , , ,X- ,X- , , ,X- ,X-X-.{ o.XXyXy , ,X-X-X-X- -.X h.w.OX1XH.o.o RX3XHXH RXgXHXH.o.oXH.oXH.oXHXHXDXHXH BXH BXHXHXHXH BXHXaXHXaXHXa 2XHXHXHXHXa BXHXHXHXHXa :.o }Xa.o UXHXHXHXaXHXHXHXHXHXHXH UXHXHXHXa.eXHXaXH.eXaXHXaXH U 5XaXH.eXa 5.f.f.f.f.f.f.D.< v f.}X$X@ g.,XZ.).].!.I.!._ v.,.!.! F.} M.}.t g.<._.<._.<XZ._.<.< d.<.t.<.<.a F.} f f f F M.<.} d.<X@ F f d.} F.W v f.0._.0Xs 0 :.P.<._XZX9X  bXZ.,XZX@._.G F d.a f d._._ f F.b.bX<.<.=.b fX@.0.b f f.}X<._ b bXA.,.I L._._XAXA.a.}.*.tXAXA b b L.IXA 0XmXlXZXZX@ b.h.t gXl.tXmXZXZ.IXs b.IX9 b.P b.IXZXZ.).I bXZ bXZXZ._ bXsXsXs.IXs.IX9.PX .PXs.I.IXsX9Xs b.I.I b.IXsX9.IXZXs.) bXZ b.)XZXZ.).,., LXZXZ.).IXZXZ.0XZ.)XZXZXZXA._.<.aX@X<X@ g.t.<.a.tX<Xl.b.} f.bX@X@.0Xm 4XAXAXAXZ.I._.<.<.t.< v f.}X$X@ g.,XZ.).].!.I.!._ v.,.!.! F.} M.}.t g.<._.<._.<XZ._.<.< d.<.t.<.<.a F.} f f f F M.<.} d.<X@ F f d.} F.W v f.0._.0Xs 0 :.P.<._XZX9X  bXZ.,XZX@._.G F d.a f d._._ f F.b.bX<.<.=.b fX@.0.b f f.}X<._ b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX@X@X@.t.aX@X@.0X@ gXa.o.o.o.o.o.o.o.o.oXyX3Xy.o.oXy.oX3.o.#X3.oXy.oX3.oX3X3.#X3Xy.wX3X3X3X3.wX3Xy.oXyXyX3X3XyX3.qXyXyXy hXyXyXyX3.qXyXyXyXyXyXy [.zXmXmX0 7 7 7 7X0 7X0 7X0X0X0X0X0X0.JX0.1 = V.O ~X1 < e eX1 $.oXy.oXyX3XyX3XyXyX3Xy.oXy.oXyXy.oX3.oX3X3X3.o ].z.oX3.oX3.o : *XH.oXy.+.+ , , , , , , , ,X-X-X-X-X-X- ,X* oXpXiXe , 5X-X-X-X- - o.XX5 $ ^ {XH.oXDXHXHXH , $XHXHXa.oXHXHXHXaXH.o _.oXH.oXHXH BXH.o.oXH BXHXaXHXHXaXaXaXH.oXHXH }.oXHXaXaXHXaXHXHXHXH.o nXaXHXH.eXHXa.eXHXa 5XaXH.eXHXaXHXaXH.eXHXaXH.eXaXH.eXHXHXaXa.e.f.f.f.f.f.fX4 v d.b.b f fX@XZ.!XsXs.I.I.!.Y.I.b f F.} F F f.t v.<.<.;.t.,Xm v f M.a.<.< v v v I.}.} v d v.}._.< f v.<._Xm._.<.Y._ f F.b._ b.IXZXm._Xs M f.Y.<.t.b f.}.G I.< d.b.}.}.}.b f.}.}.b.}.}.a.0XA f.< d.b.b.bX<.)XZXZXZXZXm._X@X@Xm.0.) bXm.b v s gX<XAXZ.*XAXZXZ._ 0XA._XAX+ L 0 f d gXZXZXZXZ.I.PXZXsXsX9.I.IXZXA.IXZXZXZXAX@.! b.IX X9X9 bX  b.PX XsX9XsX XsXs.IX XsXsXsX9XsXsXs.I.!XZXZXZ.  L.!.)XZ.IXZ.!.,XZXZ.IXZ.).t f f.}.<XZXZXA s.<.*X@X@X@.t.aX@X@.0X@ g.b.b.b.0XmXZXAXAXA._._XZ.IXZXZ f.< v d.b.b f fX@XZ.!XsXs.I.I.!.Y.I.b f F.} F F f.t v.<.<.;.t.,Xm v f M.a.<.< v v v I.}.} v d v.}._.< f v.<._Xm._.<.Y._ f F.b._ b.IXZXm._Xs M f.Y.<.t.b f.}.G I.< d.b.}.}.}.b f.}.}.b.}.}.a.0XA f.< d.b.b.bX<.)XZXZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T T.tX@ g.t.t.t.*X@X@Xa.o.#.o.o.#.oX3.o.o.o.oX3.oX3.o.#.oXy.o.oXy.oX3.#XyXy.oX3X3X3.wX3XyX3X3X5XyX3XyXyX3X3XyXyXy.wX3XyXy hX3XyXyX3.qXyXyXyX=XyXy.4.s = =X0 7X0 7X0 7X0X0X0X0X0X0X0X0.JX0X0 /XnXG V.O.jX1 e eX1 {X3XyX3Xy.oX3.#XyXyX3.oXyXyX3.oX3.oXyX3.oX3.oX3.p.z.o.o.o.oXH YXH.o.+Xe.+X3 , , , ,X-X3.; , ,X- , , ,X-X- ,Xp 5 iXiXH ,X-X-X-X-X-Xp.X h ].O hXH $XH.o.oXHXHXgXH.oXHXHXH.oXHXaXHXH RXHXHXHXHXH B.oXHXHXH BXaXH.oXHXHXHXHXaXHXH.o }XHXa 5XaXHXaXaXHXHXHXa 2XHXHXHXaXHXHXHXHXHXaXHXHXHXaXHXaXHXHXaXH.eXaXa.eXHXHXaXaXH.e 5.f.f.f.f.f.fX4.}X2._.t.} f c._ 1.!.P ).IXZXZXZ F F.}X@Xl f.<X@.a._.< fXZ.t.<.< d d.<.a.<X@.<.< F f FXl f d v._X@ F.}.t.<.<._._.t._X@ F.}._.<.!.I._.,.!._ d.* f.} F.} F F.}.< f.b fXl f.}.} f.} f.b fX@ v f d.t.b f f.}X$._.PXZXZ.)X@Xm._.b.<XAXAXA.tXZX@._._.aX<X2XC.<.0.!.I.,._X+XA.)XZXk 0 s.bXZ.!.I.P b b.!.I.IX9XZ b.)._. XZXZ bX<._XZXZ bX9XsX9X9X9X9X9 b.P.I L bX9.^X X .PX .PX9X9X9.PXs.I.,XZXA b.IXZ b b b.I bXZ.IXZXZXZXA.IXZ._ f.W.,XZXA.*.n g.*.tX@ g.t.t.t.*X@X@.a.tX@X@XmXAX@X@XAXAX@._.I.Y.,._.<.}X2._.t.} f c._ 1.!.P ).IXZXZXZ F F.}X@Xl f.<X@.a._.< fXZ.t.<.< d d.<.a.<X@.<.< F f FXl f d v._X@ F.}.t.<.<._._.t._X@ F.}._.<.!.I._.,.!._ d.* f.} F.} F F.}.< f.b fXl f.}.} f.} f.b fX@ v f d.t.b f f.}X$._.PXZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX@X<.tX<.a.a v.tX@._Xa.o.o.o.o.o.o.oXy.o.o.o.RXy.oX3.oX3.oXy.#X3X3.oXy.o.o.w.oXy.wX3X3X3XyXy.wX3XyXyX3.wX3XyXyX3 hX3XyX3 hXyXy.+X3 hXyXyX3XyXyXyXy.sXG.M.J 7 7X0 7X0 7X0 7X0 7X0X0X0X0.J.J /XnXnXJ _ # e <.j e.gXyX3XyX3Xy.wX3XyX3XyX3X3.oXyX3X3Xy.oXy.RXy.oX3.p.p.oX3.#.o *XHX3XyXeXi.; , , , ,X-X- , ,X3 ,X-X-X- ,X- , 5.4.+ i.+X- 5X-X-X-X-X* - oX> ].O.pXHXDXHXH.oXHXg RXHXa.o.oXH.oXHXaXH.o 2.oXH B.oXH BXHXaXHXH 2XHXaXHXH.o 2XaXHXaXaXHXH 2XHXa.eXHXaXH }XHXHXHXHX;XHXaXHXaXHXaXH.eXa UXHXH.eXaXHXHXaXHXHXHXHXaXa }XHXHXHXaXH.e.f.f.f.f.f.f.I d.<._ g f f f f &XZXZ.P.I LXZXZ.G F.a._ 4Xl d g.<X@ v d._XZ 0 d v 0X@._._.t.< f f v.}XC.<.<.}._.t.}.<.<._.a f d d v v F.} f f.b g.;X2._._ F._.a.a.} d v.<.; f f f f gXl f F.} f f v.a._ vXe.<._X@.b.} f f.Y.,XAXZXZX@X@X@.a._Xm 4.t sXZ.0 g.0 g.a.0 0 &XC.IXs b L._X@XZ.  L L.)XN.,X9XZ.!XZ.IXZXs b LXZ b b.0._._.,.a.0.I.!.I bXs.P bX9XsX .P.!.IXs.P.PX X X X9.PX9Xs.PXs b.PX9 bXZXAXZ L L.I.IXZ.I b.IXZ.).IXZXZXZ.,XZXZ sX@._XZ 4 g.n.<X@X<.tX<.a.a v.tX@._ gX@ gX@ 4.0.* gX@.t._XZXZ.!.!._X@ d.<._ g f f f f &XZXZ.P.I LXZXZ.G F.a._ 4Xl d g.<X@ v d._XZ 0 d v 0X@._._.t.< f f v.}XC.<.<.}._.t.}.<.<._.a f d d v v F.} f f.b g.;X2._._ F._.a.a.} d v.<.; f f f f gXl f F.} f f v.a._ vXe.<._X@.b.} f f.Y.,XA.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.] g._XA.t.a.<.<.tX@Xa.o.o.o.o.o.oX3.o.o.o.oX3.o.oXy.o.#X3.oX3.oX3Xy.oXy.oXy.o M.pXyXy.oXy.wX3XyX3X3X3XyXyX3X3XyX5X3XyXy hX3X3XyXy hX3XyXyXyXyXyXy 'Xg W.MX0X0 7X0 7X0 7X0X0X0X0X0.JX0.JX0.J.1Xx.X V ^X1 <Xo.c e o.oXyX3XyX3.oX3.#X3X3.o.oXyX3X3X3.o.oX3.o.oX3 ].p.oX3XH.eXH.#X= iXi.; , , ,X-.{ -XnXp ,.dX3.d ,X- , +X-XmXp 9 i.+X-X-X-X-X-X-X- -XpX>.p.Z.p.oXDXHXH.o.o BX3XHXHXHXHXHXH.oXH.oXH BXHXH.o.oXH 2XHXHXHXH _XHXHXaXHXHXaXHXHXHXHXHXHXHXgXHXHXa 5XHXHXaXHXHXHXH _XHXaXaXHXaXHXHXHXHXHXaXaXaXHXHXHXHXaXHXHXH.eXHXHXa 5.eXH.e.f.f.f.f.f.f.I.0X@.,XA f.}.b f.a.t b.,.,.0.I.EX@.t.,Xm._ v._Xm 0._.t.a.,.Y.!.<.<.bXmXAX@.a v f v v f d 0._ f v.a.} v d.t._XA f f.}.G I.G f.G.G.} f._ H.} f.t.a.<.t.,XZ._ v.a._.a.b d g.} f f.}XZ.I.,.,.!._Xe._.0.a.tX2XZ.!.YXZ.I bXAX@.tXZXZ._._X@._XZ.0.*._._.b.a.t.t._XmXZ f.b.*.Y 0.0 L LXs b bX9 1.IXZ.I b.)XZXZXs b._.,.).!._ bXs b.) LXZX9X9Xs b b.PX9 )XsX9XsX9Xs bX9 bX9Xs bXsX9X9XsX9XZ b.I.!.I L b.I.I.I.I.)XZXZXZ.).)XZXZXZXZ.,XZXZXZXZXAXAXC.] g._XA.t.a.<.<.tX@X@ g v.a.aX@XAXAXA sXA._XZXZ.Y._X@.0X@.,XA f.}.b f.a.t b.,.,.0.I.EX@.t.,Xm._ v._Xm 0._.t.a.,.Y.!.<.<.bXmXAX@.a v f v v f d 0._ f v.a.} v d.t._XA f f.}.G I.G f.G.G.} f._ H.} f.t.a.<.t.,XZ._ v.a._.a.b d g.} f f.}XZ.I.,.,.!._Xe._.0.a.tX2XZ.!.YXZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T sX< g.tX@X@.t.<.<.aXa.R.o.o.R.#.o.R.o.o.R.#.RX3.#.RX3.o.w.oXy.w.o.o.w.#Xy.wX3.w.wX3.rXyXyX5X3Xy.wX3Xy.rXyXy.qX3.r hXy.w hX3 hX3X3.qX3Xy hXyXy.gXyXy.l.8 /X$ 7X0 7X0X0X0X0X0X0X0X0X0X0 MX0.J.1XnXn t.O ~.j < e.j.jXy.w.#X3.wXy.oX3X3.wXyXy.w.oXy.RX3.#.pX3X3.p.R.p.RX3.- 5X3X= i i.+ ,X3 , ,X-.MXxXt p , , ,.;X3.dX-.d.dX*Xx.+XeX3X-X-X-X-X*X*X- -XtXt ].Z hXDXHXH $XHXH $XHXH BXaXH BXHXa BXH.o B.oXH BXHXHXgXHXa BXH B.oXH BXHXa 2XH.o 2XaXH _XHX; 2XH.o }XH }XHXH 2XHXH UXaXH }XaXH }XHXa UXH }XHXH }XHXH UXHXH UXHXa UXHXa }XHXaXH.f.f.f.f.f.fX4._._XZ.YXl.a f vX@.<XZ.; v.*._.a._ |Xs.YXZ.,.<X@._._._.<XZXZ.< d f g.<XCXm v f.}.< v.}.<XC.a f.a g F d dX@._.b.b.b f f.} F F.}.} f.}.b f f f.a.a.tX@._.Y M g g M.a.b.<.<.b d v.}XZ.!.!._.I.YX6.nXC vX@XCXm._Xm.<._.0.*X@._ b.!XZXA._._X@.*X@X@ g fX<.*Xl._ d._ s.b fXm._ g.*X+ bX9XAXZ.IXZ.IXs.I bXZ.IXs bXZXZ b.)X<XsX9XsXZXsX9 zXs b.PX9X9.I bX9Xs.I bXsXsX9.PX9X9.PXsX9X X9X XZ.IXs bXZXA bXZXAXZXZXZXZXZXZ b.)XZXZXA._XZ.)XZX@._XA 4.t.<X< g.tX@X@.t.<.<.a.tX@X@.t g.tXAXA.*.aXC._._.< dXZ.<._._XZ.YXl.a f vX@.<XZ.; v.*._.a._ |Xs.YXZ.,.<X@._._._.<XZXZ.< d f g.<XCXm v f.}.< v.}.<XC.a f.a g F d dX@._.b.b.b f f.} F F.}.} f.}.b f f f.a.a.tX@._.Y M g g M.a.b.<.<.b d v.}XZ.!.!._.I.YX6.nXC vX@XCXm._Xm.<.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T s.a v.b._X@._.aX< gXa.o.o.o.o.o.o.o.o.o.#.o.o.o.o.oX3.o.oX3.oXy.oXy.oX3Xy.oXy.pX3X3.#X3.o.rX3X3XyX3XyX3XyX3XyXy.qX3XyXyX5XyXyXyXy hXyXyX3XyX3X3XyXy :.s = ' 7X0 7X0 7X0X0X0X0X0.J.J.JX0.J MXG.1.X.q V ^.j.c e e.j *X3XyX3.oXyX3X3.oX3.oX3.oXyX3Xy.oX3.o.oX3.o.p ].oX3 *.oXyX7 iXe , , , , ,.{XpXx p.s - ,X3.d.d.d.;.J.dXO.{.;.;.; ,X- + 5X-X*X*XpXtXG t.Z oXD.o.oXHXH ,XgXH ,.oXH.o.oXH.oXHXH.o BXH.o.oXH , BXHXHXH.o BXH.oXHXHXHXH.oXHXaXH.oXH.oX;.oXHXHXaXHXHXHXHXHXaXHXH U.oXHXHXHXHXHXHXaXHXHXaXaXH.eXaXHXHXaXaXaXHXHXHXHXHXHXHXH.f.f.f.f.f.f.u 0.t._XAX@ g.bX@._.tXC._._ gX< g d.YXZ.YXZXA v.<.t.<.t d._.< v._.<.< v.a.< v f f.} f d f.< v 9.a v F f.}.} f gX<.a.0X@ H f f.bXl.b.bXA 4XA.=.= g.= f.b.<X@X@.t.} f.a f f f.} f F._._ M.,XsXZ.WXyX7X2.a._.IXZ.aXZXmX@X@XCXZXZ.I.!XZXZXZXAX@.0 c.} f gX@.*.*.)XZ.hX@.} 4 4.<.tX@XA bXZ M b.PXs b.)XZ b L., LXA.I b.*.<.IX9X9 b.IXsXsX9X9XsXZ.! bXsXs.PXs b.I bXs.IXs bXs.P.PX9XsXs.IX  bX9 bXZ.) LXZXZ L.)X+XAXA., b bXZ.)XZ L.IXZXA._.0XAX@.<.a v.b._X@._.aX< g.t.tX@.tX@X@X@X@.t v._._.YX@._XZ._ 0.t._XAX@ g.bX@._.tXC._._ gX< g d.YXZ.YXZXA v.<.t.<.t d._.< v._.<.< v.a.< v f f.} f d f.< v 9.a v F f.}.} f gX<.a.0X@ H f f.bXl.b.bXA 4XA.=.= g.= f.b.<X@X@.t.} f.a f f f.} f F._._ M.,XsXZ.WXyX7X2.a._.IXZ.aXZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX@X2.t g g.<X@.b.a gXa.o.#.oX3.oXy.o.oXy.o.oX3X3.oXy.o.oXyX3.oX3.oX3.#X3.oXy.o.wX3X3X3XyX3.wXyX3X3XyX3X3XyXyX3X3.rX3XyXy hX3X3XyX3Xy hX0XyXyXyXyXyXyXyXg /XOX0 7X0X0X0X0X0X0X0X0X0X0.JX0.JX0 =XnXnXx V ^ u e.c.c e XXy.oXyXyX3X3XyX3.oXyXyX3.oXy.oXy.oX3X3.oX3 ].pX3.o 5X3X= i iXyX3 , , ,X-.MXxXt.8.sX5 - , ,.;.d.d.dXOXxXp.;.;.; , ,X-X-X*X*XOXnX. [.Z.RXHXgXHXHXH.oXHXDXH.oXa.oXHXH.oXaXH.o.o BXH.oXH.oXH BXaXH.oXHXHXHXHXaXa.oXHXHXHXHXaXHXHXa.o }XHXaXHXHXaXHXaXH.oXH.oXH }XHXaXHXHXaXaXH.eXH.eXHXaXHXHXHXaXaXHXH.eXHXaXHXaXaXH.e.f.f.f.f.f.fXs.0.)XZ.I.t.< 0 v.bXZ.IXZ._X@ f v.&XC 0._.<.YX@X@.<._.<._.t 0.a.t v d 0.t f.a.t v f.} v.}.G I.G F.}.b.} F f f f.b f.bXl.b.b.bX<XAX<XA bXsXs.I.I bX9X9 L.* PXlXlX@.b.b.} f.b.}.}.}.<.t f f v.<._.b fX7X7 f v.]XZ b.!XZ._XZ._.)._._.0.IXsXZ.) L.a.a.tXO.t.aX<XzXA LXAXA.<.<.*.aXZ.0XA.Y.,.<.a.* b.I b.P b LX@.tXA v.<XZ.).IXsXs.PX9X9X9X X9X9Xs.P bX9.I.).IXs b.IX9XZ.IXs bXsX9X9.PX9.P.I.IXZXAX@Xm.,XZXZ L.)XAXA bXZXZ._.a.<.IXA.0XZXZ.IXA._X@X2.t g g.<X@.b.a g gX@.*.a g._XAXZXA.a._.0.< 0.!.IXm.0.)XZ.I.t.< 0 v.bXZ.IXZ._X@ f v.&XC 0._.<.YX@X@.<._.<._.t 0.a.t v d 0.t f.a.t v f.} v.}.G I.G F.}.b.} F f f f.b f.bXl.b.b.bX<XAX<XA bXsXs.I.I bX9X9 L.* PXlXlX@.b.b.} f.b.}.}.}.<.t f f v.<._.b fX7X7 f v.]XZ b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T._ d s.t.t.a.* g v gXa.o.o.o.o.o.o.oXy.o.o.#.R.o.o.o.#X3.o.oXy.oX3Xy.oXy.o.wX3.wX3.oX3.oXy.wX3XyXyX3Xy.wX3XyX3Xy.wXyX3Xy.qXyXyX3X3 h hX3XyXy MXyXyXyX3XB = 'X0 7X0X0X0X0X0X0X0X0.JX0.J.J.J M MXGXx.X [ V u.j e eXo.cXHXyX3.wX3X3.oX3XyX3Xy.oXy.oX3X3.o.p.oX3X3.p ].oX3XH.#Xi iXi , , , , , 5XpXxX>.s.O.- o 5X-.dX*XO.xX. pXx , , , , ,X*.d.d.JX$XnXV t.s.g.o BX3.o.o.oXH R.oXHXa.o.o.oXHXH.oXH.o B.oXH BXHXH BXHXaXHXHXH.oXHXHXaXH BXHXaXHXaXHXaXHXH }.oXHXaXa }XHXHXH.eXHXHXH n.o 5XHXHXHXH UXaXHXHXHXaXHXHXaXHXHXa.eXa UXH.eXHXH.eXH.f.f.f.f.f.f.PXZXA._.,._.0 MX@.*XZXZXZ._.0.b.<XZ._.<.Y.,XZ.t.t s.YXm.<._.;.a.<X@.<.< 0 v v.b f d v f.}.}.}.G F.G F f f f f g.b.b g.a.tX@ g.bX@.*XA.IX9 b bXs.qX9XsX9.)XA.*X<.b.} f f f.}.}.} F d._ v._._._._._.t F F.}.<.<.0.I.I._XZ._X@.Y._._.!Xs.!.*XZ.0.a.b 0._.<.tX@XA.).*XZXZ._X@X@._XZ.IX@X@.<Xm.aXA b b.I.I bXk.*._XZ.a.,.).IXsXsXsX9XsX X9X9X9 bXsX9X X9 b b.IXZXZ.PXs.I.!.).IXsXs b bX9Xs bXs.IXZX@XAXAXAXAXAXZXAX@.I.IXA.<X@._XZXZX@XZ.).!Xm.0._ d s.t.t.a.* g v g.a.*.<.a g 4X<.*._ gX@XA.<X@., b.,XZXA._.,._.0 MX@.*XZXZXZ._.0.b.<XZ._.<.Y.,XZ.t.t s.YXm.<._.;.a.<X@.<.< 0 v v.b f d v f.}.}.}.G F.G F f f f f g.b.b g.a.tX@ g.bX@.*XA.IX9 b bXs.qX9XsX9.)XA.*X<.b.} f f f.}.}.} F d._ v._._._._._.t F F.}.<.<.0.I.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.K vX@ g g.<.t.b f gXa.o.o.o.o.#.o.oX3.o.#.oX3.oXy.oX3.oXyX3.oX3.#.oXy.oX3X3.o.wX3XyXyX3.rX3XyX3.oXyXyXyX3XyX3X3 hXyXy.o.qX3XyXyX3X3.qX3XyXyXyXyXyXyXH.z =.dX0X0X0X0X0X0X0X0X0.JX0.J.JX0 MX0 MXn WXnXt V.O.j.jXo SXo G.oX3X3X3X3XyXy.oX3.o.#X3Xy.oX3.#Xy.oX3XH.p ] ,.oX3X= i i.+.; , , ,X-.MXpXt p.s _ 5.oXp 5X-XxXVX>.8.l.XXH , , ,.dX-X$.d.d.MX. >.sX5XH RX3XHXHXHXa RXH.o.oXHXa.oXH.o.oXHXHXH BXHXH.o.oXH B.oXHXa.oXHXHXH.oXHXaXHXaXaXHXa.oXH.oXH 2XHXHXHXHXHXHXHXHXHXaXH.oXa nXaXaXHXH.oXa 5.eXHXaXHXaXaXHXHXaXHXaXaXHXHXaXHXHXaXH.f.f.f.f.f.f.PXAXZXm._XmXZ 0._XAXm.t._XZXZXm.aXZXZ., s.YXZ.0 g.<._._ v.<.<.a d.<.t.<.; v.} d H d v.b.} I F I I F F F F c.b.b f g.a._XZXZXAX@.b.*.* L.I.,.IX X X X9Xs bXz.h.tXA.b F F f.b.b.b f v.a vXZ.YX@.;.,.,Xe FXe g.t.!XZXZ.Y.0._XZXZ.I b.P.I., s.)XZXZ.0.<.,._.<._XA b 0.IXkXA.}.}XkXzXZXA.t._ gX@.* b b.I.) b.I.,.PXAXZ. XZ L.IXs.PX9X X9X XsXs.PX9XsX9X9.I b b.I.IXsX9Xs b b.I.)Xs bX X .P.PXs bXZXm.)XZ L.).)XZ._X@ b b.)._X@XZXZXAXZXZXZ.,.,Xm L vX@ g g.<.t.b f g g g.t._ gXl g gX@XZ._X@X@._.tXZ.YXAXZXm._XmXZ 0._XAXm.t._XZXZXm.aXZXZ., s.YXZ.0 g.<._._ v.<.<.a d.<.t.<.; v.} d H d v.b.} I F I I F F F F c.b.b f g.a._XZXZXAX@.b.*.* L.I.,.IX X X X9Xs bXz.h.tXA.b F F f.b.b.b f v.a vXZ.YX@.;.,.,Xe FXe g.t.!XZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.v d.aX@.<.a.<.b.a.aXa.o.o.o.o.o.o.#.o.o.o.o.o.oXy.o.#.o.oXy.oX3.oX3.oXy.oX3X3X3.oX3.oXy.rX3X3XyXy.oXyX3XyXyX3Xy.wX3XyXy.wX3XyXyXyXy hXyX3XyXyXyX3X3 [.8 /.J 7X0X0 7X0X0X0X0.JX0X0.JX0.J.J M.J '.1Xx.X.8.O ^ e eXoXo.jXyXyX3X3Xy.oXyXy.oXyXy.oX3XyX3.oX3.#X3X3 ].p.o *.#Xi i i , , , , ,X-XpXpXt ZXJ.p.o.o 5 oXp.p.l.s ] 3 : 3.{X*X-X*.{.{XO.MX. >.s ] 5XH $XHXH.oXH.o R.oXH.oXa.oXHXH.oXHXaXH.o B.o.oXHXH M BXaXH.oXHXHXa.oXH.oXHXHXaXHXHXa 5XaXa 5.oX;.oXHXaXHXH.oXHXHXaXHXHXH 2XHXHXHXaXHXHXaXHXaXHXHXHXaXHXHXaXHXaXHXHXaXHXHXaXH.e.f.f.f.f.f.f.u.YX@XA._.,XZ.I._._XAX@.a._ b.* sXZ.,.,.Y.,XZ.,XC.<.<._._.b v v f f.a v f f d.t.,.}.b f.}.} I F.} F F.} f f.b dXl.a._X@XZ. XZ.* g.bXZXs bX X X9X .qX9XsX9X9 b._.h.= f f.<._X@._._.b.a._XZ.;.< dX@ v f.G I.< g.<.Y.IXA.t g._.,.!.IXZ.I.I.I.,._._.0.,.P | & &XZ.I.PXs._.h LXZ.b.}._.I._ v._ f.}X@.! b b bXAXAXl.0 d.<., b.) b b.I.IX9.I.P OX XsX9 b.) b b.P bX9Xs.PX X9X X9Xs b.PX  bX9X9.IX  b bXZX@XA b LXZ.) z.I.IXZ.IXZXZ s._XZXA._XZ._XA., d.aX@.<.a.<.b.a.a._ s g.a.t.b f f.a.t._._._._.<.<._.YX@XA._.,XZ.I._._XAX@.a._ b.* sXZ.,.,.Y.,XZ.,XC.<.<._._.b v v f f.a v f f d.t.,.}.b f.}.} I F.} F F.} f f.b dXl.a._X@XZ. XZ.* g.bXZXs bX X X9X .qX9XsX9X9 b._.h.= f f.<._X@._._.b.a._XZ.;.< dX@ v f.G I.< g.<.Y.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T a.;.a.=XA.; v v.<.aXa.o.o.o.o.o.o.oXy.o.o.o.R.o.o.o.o.#X3.#.oXy.oXy.oXyX3.w.oX3Xy.oXyX3.wX3XyXy.oXyX3.r.oX3XyXy.wXyXyX3 hX3XyX3Xy h.wXyXyX3XyXyXy.g.s.1 +X0 7X0X0X0X0X0.JX0.JX0.J.J.JX0 MX0 M.JXVXx.XXt.O ^.jXo.@Xo eXF.#.w.oX3Xy.oXyXy.oXy.oX3.oX3X3.RX3.oX3 ] ].o 5.+ i i.+X3 , ,.; ,.{XpXxX>.s.Z.g.o.o.oX3.w.r.4 :.o.o.o 5.X 3Xp -XzXpXxX. >.s.X 5XH.o $.o.oXH.o.o BXD.oXa.oXa.oXa.oXaXH.o.o BXH.o BXHXH B.oXHXH.oXHXHXHXHXHXH 2XHXHXaXHXaXHXHXaXH 2XHXaXa 2XHXHXa.eXaXHXaXHXH _XHXHXHXa UXHXHXHXa.eXaXHXaXHXHXaXHXa UXHXH.eXHXHXH.f.f.f.f.f.fX .!X@Xm.*.,XZXZ._XA._.b v.aX@.a g.P.&XCXZ.,XZ b.0X@._._.< v.a.a.a f f s.<.,._._ M f.} F f I I.} F F F f.}.a f d.b.b.t g.0 L.0XA b fXZ.!.P.V.VX X9X X X9XsXsXAX@.h.=Xl.a._XA.t g gX@X@.t.PXZ._._.aX@.}.} F.W.; 0 0.YXZ._._._.!.PXZ.!.).I b.)XA.0.&.IXsX9.!XZ.P.IXkXA f._XZ b v s._ b.)._.) f FX@XmXZXA._.t g.,.P M.<._ b.P LXsXsX9Xs.IXsXsX9Xk.IXs.) bXsXsX9 bX9X9X9XsX X9X9X9 bX .IX9X9 LXsX9.IXAXA b.) L.) b.I.IXZ.) b L.0XA.0XZXAX@X@XAXZXA.;.a.=XA.; v v.<.a.t.tX@.tXA.< f.*.a.t.<._ v._.<.P.P.!X@Xm.*.,XZXZ._XA._.b v.aX@.a g.P.&XCXZ.,XZ b.0X@._._.< v.a.a.a f f s.<.,._._ M f.} F f I I.} F F F f.}.a f d.b.b.t g.0 L.0XA b fXZ.!.P.V.VX X9X X X9XsXsXAX@.h.=Xl.a._XA.t g gX@X@.t.PXZ._._.aX@.}.} F.W.; 0 0.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.KX@ v.bX@ d sX@ g.tXa.o.o.o.o.#.o.o.o.#.o.oXy.oXy.oX3.o.oX3.o.#X3.oXy.oX3.oX3.oX3X3.#X3.wX3.oX3Xy.oXyX3XyXy.oX3 hX3X3XyXy hXyXyX3X3 h MXyXyXyXy.X.Z W =X0 7X0X0X0X0X0X0X0X0X0.J.JX0.J.J M M M M / WXx.XXg.O u eX8XoXo.RX3X3XyX3X3.#X3X3X3.#X3.oX3.oX3.oXyX3.o ] ]XH 5X= i i.; , , , , ,.{XpXt p.Z V {.oXa.o.oX3.o.oXa.o.oXH.o.o 3 hXt GXt [ ] h oXHXHXHXHXDXH.o.oXH , RXHXH.oXHXaXaXH.o.oXHXa.o B.oXH.oXa.oXH 2.o.oXH 'XHXH.oXHXH.oXaXHXHXHXHXaXHXaXHXH _XHXHXaXHXHXHXaXHXH.e.oXH }XH.oXHXH.oXaXH.eXaXaXHXHXaXH.eXH.eXaXHXHXaXaXHXHXa.f.f.f.f.f.f )XZXAX@X@ v.<._XAXA._X<X@ c H.bXmXZ v.<.!.! 0.t.YXAX@ MX@._._._.t.a.< 0._._.<.< 0 f.G.G I.G F F.b.G.} f.bXlXl.b.bX@ g LXZ zXZXZX9.a bXZ.IX9X .! b.IX9X9 bXsXA._XsXk 4.< s M.b.a g.<.b.t.,.,XmXm.t.0 f vX7.GX2._.< 0XZ.0XZ._Xs.P._XZXmXZ.!XZX@.,._.I.P.PXZ bXZXAXZX@ f.,Xs L g.0XAXZ L.).P.t.G._XZ._XZXA.<.!.PXZXA.<X2 b b.I.) b.I b.I.IX9 b bXZ b.I.I.I bXs bXZXsXs.I.PXsXsX9X .P.IXsX .PX9X  b.IXA.I b.!.I b.I b.I L.I b LXZXZXAXZ._X@XZXZ LX@ v.bX@ d sX@ g.t.<.<.t f v.a.}.*Xm.<X@._.<.b.a M.!XZXAX@X@ v.<._XAXA._X<X@ c H.bXmXZ v.<.!.! 0.t.YXAX@ MX@._._._.t.a.< 0._._.<.< 0 f.G.G I.G F F.b.G.} f.bXlXl.b.bX@ g LXZ zXZXZX9.a bXZ.IX9X .! b.IX9X9 bXsXA._XsXk 4.< s M.b.a g.<.b.t.,.,XmXm.t.0 f vX7.GX2._.<.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXrXzX@.aX@ g.aXA 0._Xa.o.o.o.o.o.oX3.o.o.#.#.o.o.o.oX3.oX3.#X3.oXy.oX3.oXyX3.wX3.oXyXyX3.wXyX3Xy.#XyXyX3X3XyXyXy.wX3XyXyX3.wX3XyXyXyX3.rXyXy.#.4XgXt = /X0X0X0X0.M.JX0X0.JX0.J.JX0.J.J MX0.J.J.J +XGX..XX5 V ^ eXo e.A e :.oX3.oX3.# M.#X3Xy.oXy.oXyX3.o.oX3.o.p.p 5XHXi iXi , , ,X3 , , -XxXt >.Z.l 5.#.o.o ,XHX3.o.oXH.oXaXH 5XFXF.r r.p.R.R.V.r.r.-X3XDXH.oXHXH.oXHXg ,XH.oXHXa * {.-.-.- X X $ $.r GXF {Xa BXHXH.oXaXHXHXH.oXHXHXaXH.oXHXHXaXaXH.oXH }XHXHXHXHXaXHXaXHXH.oXHXHXH _XHXHXa 5XaXHXaXHXaXHXaXHXHXaXaXaXH.eXHXHXHXHXaXH.f.f.f.f.f.f.Y.< 0 v.<.t 4Xm.YX@._._XZXm fX@.,._._._.!XZ.,X@ f.t.<XA._XZ._ 0.,.t d.t f.b f.} v I.G F f.a c F.}.b LXAX@.tXA.* s.tX@.!.Y.0 g.<Xs L b.P bX9XsXs.P b.Y.,XsXZ.).I.I.I.P.I P.b._X@.b._X@X@.!XA 0Xl F f.<XZXZ FX7X2.,XZ.!XZ b.!.I._.,XZ.P.I.!.!XAXZ.P.P.I bXZXA.) b.b v f. .!.* gX@XmXZXZ.IXsXZ.aX@.IXs.aX@X@.&XZXZ.).I bXZ L.P L.!.IXZ LX9XsXsX9XsX9X Xs.I.P.IXs.IXs.PX9Xs.PXsXsX9X9X9X X X X X9XZXZXA. XZ.I L.IXsXs.I L bXAXZ.)XZ.0.I b b._XZXZXzX@.aX@ g.aXA 0._X@._X@X@.t.a.a v._.<.t.a.a.<.t.< d.< 0 v.<.t 4Xm.YX@._._XZXm fX@.,._._._.!XZ.,X@ f.t.<XA._XZ._ 0.,.t d.t f.b f.} v I.G F f.a c F.}.b LXAX@.tXA.* s.tX@.!.Y.0 g.<Xs L b.P bX9XsXs.P b.Y.,XsXZ.).I.I.I.P.I P.b._X@.b._X@X@.!XA 0Xl F f.<XZXZ FX7X2.,.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T aXA._.a.* 0XAX@XA._Xa.o.o.#.o.o.#.o.o.o.o.o.RX3.#.o.o.o.o.oX3.oXy.oXy.o.o.w.pX3.oXy.o.wX3X3X3.oXyX3Xy.wX3XyX3X3 hX3X3XyX3 hX3X3X3X5Xy hX3X3 :.l p = =.JX0X0X0 /Xn +X0.JX0X0.J.J.J.J.J.J M M.J M M W WXx W V ^.j eXo e e G.w.#X3XyX3.#X3.o.oXyX3X3.o.#.RXy.o.o.R.R Y.o i iX=X3 , ,.d ,X- -XBXt.l !.wX3XH.o.o.o.RXH.oXH {XF.- GXF.-.-XF.- G G G G G.R.-XHXDX3XHXHX3XH , $ R.o.o 5XF.rXF G G G G G G.r.V $ $ R $ UXHXHXHXH 2.oXHXaXH.'XaXHXHXaXHXHXaXHXHXH B 5Xa 2XaXHXHXaXaXHXHXHXHXHXH U.oXH BXHXaXaXHXH.eXaXHXaXH 5XaXa UXHXaXaXa.e.e.f.f.f.f.f.fXZ v.< dXm._ LXZXm.,.<._XZ.*.a.t v._._XZ.,XC._.< v.a.YXZ.YXm._XAXA.0.t.a.< 0 f.} d F I F.}.b F fXl.h L 4X@XA.* 4XA.t._X9Xs.IXA._X9.).!Xs.I b.P.I b.PX9Xs.P._.! b.PXs.IXZ L.F gXA._X2XA g.P.Y 0.b.G FXZ._ s.2X7X2 &.,.Y.!XZ.,XZ.Y._.I.!XZXs.IXZ.IX9.P.I.)X@X@Xm.* f f.tXZXZX@.<._XAXm.0 b.).!.<.0 LXA._XZXZ._ s._Xm b bXAXZ L.) bXZ bXA.I.yXsX9X9X X9.!.I.I b.IXs.PXsX X9X9X X9X  bXsXsX9X9 zX .)XmX<.,XZ b.I LXkX9XsXZXZX+.)XAXZXZ.I.I bXZXAXAXA._.a.* 0XAX@XA._ g v 0._.0._X@X@._ f v.<.tX@.< v.a v.< dXm._ LXZXm.,.<._XZ.*.a.t v._._XZ.,XC._.< v.a.YXZ.YXm._XAXA.0.t.a.< 0 f.} d F I F.}.b F fXl.h L 4X@XA.* 4XA.t._X9Xs.IXA._X9.).!Xs.I b.P.I b.PX9Xs.P._.! b.PXs.IXZ L.F gXA._X2XA g.P.Y 0.b.G FXZ._ s.2X7X2 &.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T aX@.=.<X@.tX@XA.0 gXa.o.o.o.o.o.oXHX3.o.o.o.oXy.o.oXyXy.oXy.o.o.#.o.oXyXy.o.r.oXy.oXy.p.oXyXyXyXy.oX3XyX3X3XyXy.wXyXyXyX3.wXyXyX3XyX3.wX3 :.z.wXn =.JX0X0X0 'XxXn.1X0.JX0.JX0.J.J.J M.J M M + M M /XxXG W.l.O ^.j D e.c.jXy.o.oX3.oX3.oXy.oX3.oX3.o.oX3.oX3X3 ].r 5Xy i iXy , , , ,X3 :XpXxX5 ].l.pXF 3XF 3.- @.- G G.-XF.-XF o Y Y : Y 3 Y o o.l 2 3XHXDXHXH.oXHXH RXHXH Y GXF.-XF @ 3 3 3 3XF o o.- G.r.R.R R n.r.V.V r X.V X.V X X.V.r.V.r.w GXHXHX3XHX;XHXHXaXHXaXHXHXaXaXHXHXHXH } 5XaXHXaXHXHXaXHXaXH.eXHXaXaXH.eXaXHXHXHXHXHXH.f.f.f.f.f.fXZ sXZ.0XA.a LXZ._.,._._._X@X@.< fXAXA._XZ._X@.t._.<._.)XZXZ.0.0.!.&XN.< M.<.< M.a f F F F.}.bX@XA L bXA L bXk b.) LXZX9 b b. ._ b.!Xk.IXZ.I.I.!. .IX9X XsXZX9X X9XsX9 L b.h f.b.t.aXmX@.& |XZ.a.} F.<.,.!._.nXy 0Xw.,.I.IXZ.,._.YXs.)XZ.!.I LXs.PXs b b._XmX@.b.b.<._XZXZXm.W._.t._.t.<Xl gX@.b.*.*XZXZXZ.a F.}.<._XZXZXZ.) b.I.! bXZ LX9Xs.I b.IXs.PXs.I.I.!.I.PXsX9X X X9X9XsXsX9X9XsX9X X9.I.*X@ L.I.).IXZXZ.I.)._XZ.I LXAXAXZXZ b.I LXAXAX@.=.<X@.tX@XA.0 gX@ g._ 4._XA.a.t.<.a.} v s.< fX@.a sXZ.0XA.a LXZ._.,._._._X@X@.< fXAXA._XZ._X@.t._.<._.)XZXZ.0.0.!.&XN.< M.<.< M.a f F F F.}.bX@XA L bXA L bXk b.) LXZX9 b b. ._ b.!Xk.IXZ.I.I.!. .IX9X XsXZX9X X9XsX9 L b.h f.b.t.aXmX@.& |XZ.a.} F.<.,.!._.nXy 0.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T a.tX@.a.aX@X@.tX@.aXa.o.o.o.o.o.o.o.oXyXH.o.o.o.oX3.o.o.o.oXy.oXy.o.o.oXy.o.wX3.oXy.o.wX3X3.o.#.oXyXyX3X3XyX3X3.wXyX3X3XyX5XyX3XyX3 M hX3.z.8.1 = +X0X0X0 +Xx = =Xn +.JX0.J.J.J.JX0 M M.J.J M.d M MXG W WXG V ^.j.j e e.jXFXyXyX3XyX3X3.oXyX3.oX3.#Xy.o.o.oXH.r o Y.# i i.; , ,.; ,.d.{XpXt hX5 h G.r G G G G GXFXF YXF Y Y 5 Y 5 5 5 - : Y.{X5Xg.O 5.oXg.o.oXH.o.o $XH.-.- @ 3 Y Y { Y 5 Y { - 3 o o o.-.- h.V.R.V.r.r.V.r X X X X.r X X.w X X $XaXHXHXH 2XHXHXHXHXaXHXHXHXHXaXaXHXHXH _XaXHXHXHXaXH.eXHXHXHXH.eXHXHXaXHXHXHXHXa.e.e.f.f.f.f.f.fXZ.;.< dX@._.t.aXZXZ.Y._.,XZ._.aX@XZXZXA.aX@XA._ 0XmXZ._X@XZXm.!XZ 0 f v d.a f.} v._ f.} f b.)XZXkX9 LXA._ L LXkXs b bXZ.!Xs b L._._ b.PXs.IXs.I.IXsXsXs bXZX9 bX X  z b b. .*.b F.b.b.t._X@._ d._XZ.<XZ._XZ 0 M 0XZ.Y.YXC.Y., b.!.P.I.PXZXA |Xs.I L.P.!XZ.I.I.!XZ.)XZXZ.!.,.a.<.t._ &XA f f gX@XA.<.<X@.*.b.bX@ bXAXA._ s.<XZXZ.IXZXZXZXsX9Xs b.I.IXsX9XsX .P.PX Xs.IX X  b bX9X9X9XsXZXsXsX9.IXAX+ b.PXs b b b.P bXZXZ.).).I LXZXZ L.0XZXAXA.tX@.a.aX@X@.tX@.a.0XAX@.0.*.b.a v f f d d.<.t.< d.a.;.< dX@._.t.aXZXZ.Y._.,XZ._.aX@XZXZXA.aX@XA._ 0XmXZ._X@XZXm.!XZ 0 f v d.a f.} v._ f.} f b.)XZXkX9 LXA._ L LXkXs b bXZ.!Xs b L._._ b.PXs.IXs.I.IXsXsXs bXZX9 bX X  z b b. .*.b F.b.b.t._X@._ d._XZ.<XZ._XZ 0 M 0.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T a.aX<X@.aX@ gX<X@X<Xa.o.o.o.o.o.#.o.o.o.oX3.RXy.o.o.oX3.#X3.o.#.o.oX3.#Xy.p.o.o.#X3X3.wX3.oXyX3X3Xy.o.wX3Xy.oXy.wX3XyXyX3.wXyXyX3X5Xy.w.w.C.1 =X*X0X0X0 +Xn =XGXn = =X0.J MX0.J.J MX0.J M M M M + MXn W W W Z.O D.j.cXo < U.#.oXy.oX3.oXy.oX3.oXy.oX3.R 5 @ o Y YXH.o iXeX3 , , , , , -Xp.X o Y o Y Y @ 3 3 3 Y Y Y 5 5 5 5XH 5 5 5 5 5.{ 5Xp p.Z ]XHXD.oXHXHXa.oXH $ o @ Y Y 5 * 5 5 5 - 5 : : - - - o o o.X G G G.-.-.-.-.-.-.-.-.- G.-.- G A.CXHXHXHXH _XH }XHXaXHXHXaXH.eXHXH.oXH.o UXH UXHXH.eXaXaXHXHXaXHXa.eXHXa UXH.eXa 5XaXH.f.f.f.f.f.f.Y g.<.tX@.<._ f._ | 0.YXZXZ._XmXA bXZ._X@XmX@XA.YXZXZ.,._.t d F.a.t v.a g.<.b d.t.<.b F.< L.  z b b L._XA b.) b b.P.!XZ.).I bXs.*._.IXs.P.!.IXs b bX9X9Xs.IXsXsX9X9X9 b.I.h g.aX@.a.b.b f.b.a.<.,XZ.&.YXZ.Y.,.< 0XZXmXw 0XC.<.<.I.,.,.!._.,XZ.I.I.! bXZ., b b b. XZXA., : 0 fX@XZXsXm sXl.b g dXA.0._ v.a vX@XA bXA., d.<., 0XZ b b.IXZ.IXs b bXs.PXsX9X X9X9XsXs.I bXs.I.I.P b.IX9Xs.P.P.IXZ b.0 LXsX9X9 b.IXsXs b.I.) b b b.IXZ.)XZ L.)XZXA.aX<X@.aX@ gX<X@X<.<XAXmX@X@X<.< f.<.}.} f.<.<.a v d g.<.tX@.<._ f._ | 0.YXZXZ._XmXA bXZ._X@XmX@XA.YXZXZ.,._.t d F.a.t v.a g.<.b d.t.<.b F.< L.  z b b L._XA b.) b b.P.!XZ.).I bXs.*._.IXs.P.!.IXs b bX9X9Xs.IXsXsX9X9X9 b.I.h g.aX@.a.b.b f.b.a.<.,XZ.&.YXZ.Y.,.< 0.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T aX@X@ g.a g.t.b.b v.oXa.o.o.o.o.o.o.o.o.o.o.o.oX3.oX3.o.o.oX3X3.oXy.oX3.o.w.oXy.oX3.o.wX3X3Xy.oXyX3XyXyXyX3XyX3.wXyX3X3Xy.wXyX3XyX3X3.C.Z.X =XmX0X0X0X0Xn =XV.sXx.1Xn.J.J.J.J M.J M M M M.J.J M + + M [ WXG p ^ ^.j.j e e.j :.#X3Xy.oXy.oX3XyXy.oXH {XF 3 Y 5 5XHXH.o iXe , , , , , , -Xx - 5 5 5 5 : 5 5 5 Y 5 5XH 5XH 5.o 5 ,X-X- , 5X- -.X ] !.p.oXDXa.o.oXHXH Y.- Y YXHXH 5 5 5 5 5 5 - 5 : 5 : - - 3 o o.X.X 3 o 3 3 o 3 o o 3 o o o o.p 2 $XHXaXH.oXHXHXHXHXaXHXHXHXH.oXH.eXaXHXHXH 2XHXHXaXHXHXHXaXHXHXHXHXHXHXHXaXHXaXHXaXHXH.f.f.f.f.f.f x.a g._.Y._ 0.<.YXZXZ.Y.,.Y.,X@.t.!.,.aXAXA._._XZ.I.,XZXA.*X@.W f.t.< f f.b f.<._._ v.}._XZXm bX9 b 4XZ.0. XAXA b LXZ._ b bX9X9 bXZX9 b.I.,.IXs.) bXsX9XZX9Xk bXs zXs.P bXZ 0 LXkX<.<.b fXl f._.;.<.,XZ.!.YXZ dXC.< f.}.}.} F F 0 M.<.<._._X@.P.!.P.Y.0XZ.!.P b.0._._X2 &.t vXZXA b LXz dX<.b.b f.aXAX@XZ.aXA. ._._X@.<._XZ.I b b.IXs bXZ.P.I.I b.!X9X9X9X9X9X9X9Xs.P.P.IXZ b.IXZ.I.I.IXs bXZXAX@.)X9XsX9X9Xs bXs b b LXk b b b.)XAXAXZXZ LXAX@X@ g.a g.t.b.b vX@.0XA.a vX@.b.<._ f v f v.a f f v.a g._.Y._ 0.<.YXZXZ.Y.,.Y.,X@.t.!.,.aXAXA._._XZ.I.,XZXA.*X@.W f.t.< f f.b f.<._._ v.}._XZXm bX9 b 4XZ.0. XAXA b LXZ._ b bX9X9 bXZX9 b.I.,.IXs.) bXsX9XZX9Xk bXs zXs.P bXZ 0 LXkX<.<.b fXl f._.;.<.,XZ.!.YXZ dXC.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T aX@.a.t d.aX@X@.<.a.o.o.o.o.o.o.oX3.o.o.o.o.o.oX3.o.o.oX3.oX3.oX3X3.oXy.o.pX3X3X3.o.wX3X3.oX3Xy.oXyX3X3.oX3X3X3.wXyX3XyX3 hXy.oXyXyXB.sXG =.MX0X0X0X0X0XnXx.s.s [XnXn /.JX0 MX0.J M M M.J M + M + M + WXGXGXt V.O.j D.j e e G.oX3X3X3.oXyX3.oX3X3 * * YXH 5XH.o , ,.o.+Xy.; ,.; , ,X-.{ 5X-X- 5X- 5 5 5 5 5 5 5 ,X-XH ,X- ,X-X-X-X-X-X-X-Xp.X t !.g ,XD.oXHXH.o @ @ Y 5XHXH 5.o 5X-X- -X-.{ 5.{.{ 5 - 5 5 - - o o - 3 - - 3 - 3 - o o - o h.CX;.CXHXHXHXHXH ,XHXHXHXHXHXHXHXHXaXHXHXHXHXaX;XH.oXHXHXHXHXHXHXHXaXHXaXHXHXHXaXHXHXHXH 5.f.f.f.f.f.f.u.<.<X@._ MX@XZ._ & |., 0 9.Y._X@.< vX< 4.0XZXZ.0.< gX@.t.= g 4 gX@Xm.<.<X@._.a 0. X@ g bXZ._XAXZXm.).I b s._XA bXm.0XZ._ 0 bXs.IXm.!X9XsX9XZ.IXs.I bXZXm.IXZXsXZXZ bXZ & &.*.a.b.a.b gX@.* g 0XZ._.<._ b.!.,.I M.< fXC.t v 9X6X2 &XZ._XZ.t.,XZXA.0.IXZXZ.YXZ.).!._.).<._XA b.I LXk b.) f f.}.}Xl.bXlXl.b._.0., f f FXZXZXZ.!.I bX9X9 b.I.IXs b.PX9X X9XsX9X9X .IX9X9XZ 0XsXsX9X9.!.,XZXAX@X+XA._.) bX9X9X9 bXs.I |XZ L b.)XA 4X@.) LXAXAX@XAX@.a.t d.aX@X@.<.aX@ 4._X@X@.0.a.tXC.t._._ d.t.t._._.<.<X@._ MX@XZ._ & |., 0 9.Y._X@.< vX< 4.0XZXZ.0.< gX@.t.= g 4 gX@Xm.<.<X@._.a 0. X@ g bXZ._XAXZXm.).I b s._XA bXm.0XZ._ 0 bXs.IXm.!X9XsX9XZ.IXs.I bXZXm.IXZXsXZXZ bXZ & &.*.a.b.a.b gX@.* g 0XZ._.<._ b.!.,.I M.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX<XA.b.a.].aX@.aX@.tXH $.o.o $.o.o.R.o.o.R.o.R.o.o.RX3.o.RX3.#.RXy.o.RX3.p.RX3.wX3X3.pX3X3.w.oXy.w.oX3.wX3Xy.wXy.w [X3.wX3.w.wXyXy.C.s h =.M.JX0X0X0X0 /Xx Z.sXJXJ =.1Xx.J M M M M.J M.J M M M + M + M / W WXG.l.O ^.c.~ DXo eXy.oX3.pX3X3.RX3X3.R 5XHX3XHX3X3 ,.#.+.;.; , , , , , , ,X- , ,XHX-X-X- ,X- , 5X- ,X-XHX- , , 5 ,X-X-X-X-X-X-XpXx.l.O YXHXD.o.o $ Y 3 *XH.o , , , , 5 -.{X- :.{ 5.M -.{.{.{.{ -.{.{Xp.{ : : - - - - 5 - - -.X p ] V $XH BXHXH 2X; 2.o 5 BXHXH }XHXH UXHXH 2XH.o UXH UXHXH }XHXH UXaXH UXHXa nXaXH }XaXHXH.f.f.f.f.f.f x.]XC.,., d.aXZ.,XZXZ.!.I d.,XZX@ gX@.*Xz.*.<.Y._.<X@ g.<X<.= g.tX@X@.aX@X@._.t.<._.<.<XZ bXsXZXA.,XZ.!XZXZ.)XA.YXZ._.IXZ._.!.IXs b.,.IX9 z.!.!.IXZ.I.IXZ z b.P.IXZXZ :._X@XZXA.h.a g.=.aXAXA._.,._X2._.!XZ.!.I.a f 9._XNX@.b.;X7XC._.,X@XCXZ.,XZ.!XZXA.,.,XZ.I bXZ. X@.b._XZXZ.) b.IXA f.} FX<._.* 4XzXz.< f f.*.b.}X2.<XZ._.!.PXsXs.I.IXsX9 b.PXsX9Xs.IX X9X .IXsX9 1 0 &XsXs b b.I b b.)XAXAXAXZ.IXs.IX .IXs b b.IXA L bXm gX@XA LX+XZX@X<XA.b.a.].aX@.aX@.t.<.*X<._.< M.<.0._ d.a.a.a.< f.a v.]XC.,., d.aXZ.,XZXZ.!.I d.,XZX@ gX@.*Xz.*.<.Y._.<X@ g.<X<.= g.tX@X@.aX@X@._.t.<._.<.<XZ bXsXZXA.,XZ.!XZXZ.)XA.YXZ._.IXZ._.!.IXs b.,.IX9 z.!.!.IXZ.I.IXZ z b.P.IXZXZ :._X@XZXA.h.a g.=.aXAXA._.,._X2._.!XZ.!.I.a.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX-XAX@X@.<XC f 4X@.0Xa.o.o.o.#.o.o.o.o.o.o.o.oX3.o.oXy.oX3.o.o.oX3.oX3.o.RX3.o.o.oXy.RXy.oX3Xy.oXyX3X3X3X3X3X3X3.r.oXyX3X3X5X3Xy :.C p =Xn.dX0X0X0X0 /.1 >.ZXJ V.sXG.1Xn '.JX0.J M.J M M +.J.J + M + + M >XGXGXt.O ^.j e e e eXFXyX3.oX3.oXy.oX3.o YXH.+.+X3.+.+Xy.; , , , , ,.; , , , , , , , , , , , 5 , , , ,X- ,X-X- ,X-X-X-X-X-X-X-X-XxXt ! ! 5XD.oXHXa { @ 5XH.o ,X3.o , 5.{X*.{.{.{.{.{X$.{.{.{ - 5X- -.{ -.{ - - 5 -.{ - - - - -.X p ].Z.lXHXHXHXH.o BXH.o.oXHXHXHXHXHXaXH.oXHXaXaXHXa 2XH.oXHXHXHXHXaXHXHXaXaXHXHXH.eXH.eXa.e.f.f.f.f.f.fX4.< 0.YXZ.b.t._.!.,.!XZ.Y._XZXZ.,.bX@XZ.I._.<.,XmXA.tX@ gX@ gX@._X@XA._._XAX@X@ v d.t.t L.).I.) b b.,.,.)XZ._XA s.aX< b.IXs.! b.IXsXm.E b b.I.I b. .IXsXs.I b.IXs b b.I LXA LXmXA.0X@X@.bXZ.)._XZXZ._ 0Xs.,.!._.;.}X2.Y.<.<.<XA.tXy &._X@._._ 0XZ.0.IX@ MXZXZXm.I.I.)._X@.<.a.]XZXZXA.0 f f.} M._._XZXk.IXm f.b f d.W.} 0Xm |.,X2.,.) b.P.!.PXs.).I.P b.PX XsX XsX9Xs bXsXZX9XZ.I.) b bX9 bXZXZXZ.).!.I bX9X9Xs.I.I b.).*X@XmXl 4XA.)XZXZXA.tXAX@X@.<XC f 4X@.0.<.<.t.a._._.} v.}.b.b fX@ v F v.<.< 0.YXZ.b.t._.!.,.!XZ.Y._XZXZ.,.bX@XZ.I._.<.,XmXA.tX@ gX@ gX@._X@XA._._XAX@X@ v d.t.t L.).I.) b b.,.,.)XZ._XA s.aX< b.IXs.! b.IXsXm.E b b.I.I b. .IXsXs.I b.IXs b b.I LXA LXmXA.0X@X@.bXZ.)._XZXZ._ 0Xs.,.!._.;.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T aX@XZ b._.aX@ 4X@._XaXa.o.o.o.o.o.o.e.w X X.i X X X X X X X X X X X X X }.' X X X X } X X X X X X X X.' X X X.r } X X X.r 2.w.l.l.1 = +X0X0X0.J MXxXnXG ! V # ~.O.sXGXx.1XO.J M.J M.J + M M + + M + + +XmXGXGXt p.O ^ eXoX8 e.j X X X X X X X X.VXF.o.;.+Xi.+.;.; ,.; , ,.; , , , , , , , , , , , ,X- , ,X- , ,X-X- ,X- ,X-X-X-X-X*X-X-.{.XXt.ZX;.R n.R X.- Y.o.o.+Xi.+ , 5.{X- :.{X*.MX$X$X$X$XO.{X- ,.{ 5.{.{ -.{.{ - -.M.M.{.MXp.MXpXx p t.O ^.w X r r X.R n r X r.R r X r X r X r X r X.9.R X r.R r r r X r r r r.R u.R r.R r r r.f.f.f.f.f.f.4._._.I.!XC.<._.<.Y 0 bXs b.!XZXZ gX@XA._._X@.)XZ.h v bX@X@._XAX@XAXm.t.t._ gXAXZX@X@._XZ bXs.I.I.P.IXZ._.Y.<.bX@X@ s._ gXmXA.I.I.) b.I b.).!.I.I b bX9.PX9Xs b &XZXs bXZ.0 v.a gX2X@Xl fX@XA.t.!.Y.,XZXs.!._.Y dXC.Y.,XZ._ f dXZ.Y.kX2 d FX7._.<.<XZ._X@.I.PXZ.I.YXZ.t.a.<.t.*.a._._Xz.* g g.IXs.I.IXZ b._ s._ g.b.}Xz._ 0XZXZ.!X9 b.I.PX9X .I b.PXsX9X XsX X9Xs LXZ.I b.)X9X X9 | &.PXs b b.).)XZ.I.IXs.!.,.! b.I.I |.Y.,XAX@.t.0XA LXAX@XAX@XZ b._.aX@ 4X@._X@.0._ F.b.} f v._ v.<XCX@ d.}.< M._._.I.!XC.<._.<.Y 0 bXs b.!XZXZ gX@XA._._X@.)XZ.h v bX@X@._XAX@XAXm.t.t._ gXAXZX@X@._XZ bXs.I.I.P.IXZ._.Y.<.bX@X@ s._ gXmXA.I.I.) b.I b.).!.I.I b bX9.PX9Xs b &XZXs bXZ.0 v.a gX2X@Xl fX@XA.t.!.Y.,XZXs.!._.Y d.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXrX@XA.0.0.<.aXmXAX@Xa.o.o.oX3.o.o.o 3.i } }.' } } } }.i.f.i } } } } U n U } } } }.9.' } } } } } } }.i } } } } u } } }.i } 2 2.CXxXn 'X0.JX0 M.J.1XnXG Z V #X1X1 ~ !.wXx.1 = M.J M + M M + + + M + + + + +XGXGXGXG V ^ e eXo e.c } } U } U U } } UXFXH.+.+ i.; , , , , , , , ,.; , , , , , ,X- , , ,X- ,X- , =X-X*.dX*X-X-X*X- ,X-X-X-X*.MXtXt.Z ^ n ^ U A *.o.oXe iXi.+X-X-X* 5X*.{.MXzXz.xX.Xx.M.{.d , ,.{.{ -.{ -.{.MX$X-X$X$.d.dX$.d.M p ].Z ^ n n } U.i } u.i.i.i }.i.i.i } }.i.i.i.i.i.i }.i.i }.i U u D u u u u.i n U n.i.i }.i.f.f.f.f.f.f.Y.<._ b |XZ.Y 0._XZ._X9.I.I.I.!XZ.t f f gX@X@XAXm.*XZXZ gXZ L.YXm.* 4.t 4X@ gXmX@.t v._._.IXs b.! bXsXs.).]XN._.a.t._XZX@.a 0 b., bXs.I bXZXZ L.IXs.I b.P.I.IXsX Xs.P.,Xs.I.0.t.b.b.b f.b.bXl.a.PXs.Y._.,.IXZ |.t s.,.Y.I.&.}.t._X@._._.< d.,XZ.,.,._._XZ.I.!.IXs.)XZX@ f.}.< 0XZ.aX@XZ L g.0.E.I bXs b.0 vX@.).<.<.b.)._.tX2.,Xs b.P b bX9Xs.I b b.IXsXsX9Xs.PX9Xs.I.IXZ.,X9 zX9.Y.n.I.I bXZXmXZXs bXs.PXsXZ.IX9.P.!.k &.,.0X+X< 4.0Xk.*.0.)X@XA.0.0.<.aXmXAX@X@ 4.a.} f.} f.a.t._.a.<.; f.} d f.<._ b |XZ.Y 0._XZ._X9.I.I.I.!XZ.t f f gX@X@XAXm.*XZXZ gXZ L.YXm.* 4.t 4X@ gXmX@.t v._._.IXs b.! bXsXs.).]XN._.a.t._XZX@.a 0 b., bXs.I bXZXZ L.IXs.I b.P.I.IXsX Xs.P.,Xs.I.0.t.b.b.b f.b.bXl.a.PXs.Y._.,.IXZ |.t.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T aX@.)XAXA._.;Xm.0XAXaXa.o.o.o.o.o.o X.'.i } n } } } }.' U } } } } } U n } U } 2 } ^ } } U } } } U } } } } } U ^ U } U B U BXgXG = '.JX0X0X0X0Xn.1 W >.s ~ ~ DX1 # _XJ.1XxX. +.J +.J + M + M + + + + + + + =XGXGXt t ^ ^ eXo.j e U U } U } n U U }XFXHXy.+Xi.; , , ,X- , ,.; , , ,X-.{X*X-X*X-X*X*X-X$X*X-X*X*XpX*.{X-X3Xi M ,X*X- +X-X-XpX.X5.Z ~ ^ U nXF YXHX= i iXi ,.{X*.{.{.{.MXpXxX.XV >X>XpX- ,.; ,X-.{.{ -.{ - -X-.d.d.dX$.d.d.dX$Xx t.O ^ n U U.i U U u.i U U.i U.i U n.i }.i U U U U n u.i n.i U u U u ^ U < U U n }.i.i.i.i.f.f.f.f.f.fX4.a._.I b sXZ.!.t.,._ b b b.Y.Y._X@.tXl.* v g.tX<.*._X< gXm._X@.,X@.t g.<Xl._.t.<XZXZXZ.I.! bXs.I bXZ.I.I.0 |.,.a.0X@XZ. .a._._X@XZ.IXs b L.).I b.IXZ.I b.!. .IX9X9.P.).!XZXmX@.b.b f f g.a g.<.P.I.!._.< 1.^X XZ.t._ 0.Y.0 f f.< g.<.,._.IXZ.P 1Xs.!XA.,Xs b b.!.I.I f v f f.tX@XZXzXA.).! b.) bXs.)XZ g.<XA._.<.<X@XZ._ 0.<.<.P b bXZ.IXs.I.PXs.I.PX9.PXsXk b.PX X9X9Xs.PXsX X9 OX Xs.PX9 b g.).IX X9.P.PXs.PX .P.I &.,XZ g.* 4Xm.=XA.aX@XAX@.)XAXA._.;Xm.0XAX@X@ f d f f.,X@.} d.a d.b.} f._.<.a._.I b sXZ.!.t.,._ b b b.Y.Y._X@.tXl.* v g.tX<.*._X< gXm._X@.,X@.t g.<Xl._.t.<XZXZXZ.I.! bXs.I bXZ.I.I.0 |.,.a.0X@XZ. .a._._X@XZ.IXs b L.).I b.IXZ.I b.!. .IX9X9.P.).!XZXmX@.b.b f f g.a g.<.P.I.!._.< 1.^X XZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T K sXZXZXZ._.aXAXZXZXa.oXa.o.o.o.o * } n.V.w.r.r.r.w.w.w G.w G.w G.g G h G.r G G h G G G.g G.g G.g.g.g G G.g G G.g G.- G B _ WXBXm.JX0.J MX0 =.1Xn >.s.O ~X1X1X1.R h.s [.1Xx = +.J + + M + + + + + + + + ' + >XGXG.q V ^.j D.c.j.r G.w G.w G [.r.r oXH.+.; ,X-X-X-X-Xi ,.; , ,.d ,X*Xp.{.{.{.{.{.{.{.{.{.MXmXm =Xp :.+ i iX-X-X-X-X-X-X*XnXtX5XJ.R $.R.RXF.oX3Xi i i.; 5X*.{X-.{.{XxXtXV > Z.s.8 o ,.;.;.;.; -.{ 5 -.{ -XtX.Xn.MXz.xXzXzXz.MXtXJ.O $ $ $ $ $ $ $ R $ $ $ $ $ $ $ $ $ $ A $ AXD $ $ B $ $ $ B B B $ B B $ B R R.f.i.i.i.f.f.f.f.f.fXs.,XsXZXZ.IXC._._._.<.P.I bX2 f.< fX@.< f.a._.a.tXAX@X< gX@X@XAXZXA.aX@ g.a._XZX@.I b.I b L.IXs.I bXsX9.PXZXZXZXZ.IXm._XAXZ b._.0.tXZXZXZXZ.IXZ.I.PXs.IXs.PXsX9Xs b.I.I.I LXAXm gX@.<.a._XZ.t.<XN.<.Y b.< v.} d.t v.t d d f f f f &X6Xy._.Y._Xs.PXZ.I.!.I.IXs.P b bXZX@Xm g f g.<._XAXA f.a._.,.,.YXA.IXZ g g.*XA L.!XAXZ._XZ.!.I._.)XZ.IXs.I.I bXZX9X9Xs b.I b.PXs.I b.I.I b bXsX9 bXk b L.I.!.!Xs.P.PXsXs o.Y., 0._ b.I.I.a d dXZ.tX<X@.*Xm sXZXZXZ._.aXAXZXZX@X@.}.Y g.b._._ 0 v.a f f v.t 0.&.,XsXZXZ.IXC._._._.<.P.I bX2 f.< fX@.< f.a._.a.tXAX@X< gX@X@XAXZXA.aX@ g.a._XZX@.I b.I b L.IXs.I bXsX9.PXZXZXZXZ.IXm._XAXZ b._.0.tXZXZXZXZ.IXZ.I.PXs.IXs.PXsX9Xs b.I.I.I LXAXm gX@.<.a._XZ.t.<XN.<.Y b.< v.} d.t.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T aX@XA.)XAXAX@._.IXmXaXa.o.o.o.o.o G } $.4.4 3 {.4 { { {.4 { : { = { 3 : { : : : : : : : : : : : : 5 : ' ' 5 ' 5 ' 5 5.gXg.qXn = MX0.JX0X0 /X.Xn [.s.s ~ ~ D #.l : '.z t W WXx + +.J + M + + + + + + ' + + +.1XGXGXGXg ^ D.j e e {.4.4 {.4.4.4 - o YXHX3 ,.{.{ - 5.; i , , , , , ,.{XpX.Xp.M.MXp.MXpXzXp.MXp.MXp.XX- i i iX-X-X-X-X-X-X*.XXt p.Z h h.r G Y.oX= i i i 5X-.{.{ 5.{ 5XxXV >.s.s ]X5 Y ,X3.+.+.;.{.{ -.{ 5.{Xt p t p.XX.X.X.X.X.Xt.8 _.p.r.p.p.p.p.p ].p.p.p.p.R.p.p.p ].p ] ] ].p.R ].R.p.R.p.p.p ].R.p ].R.p.R.R $.i.i X.f.f.f.f.f.f 8.t._.t._._._.,._ 0XC.,.tXm d d.t g.;.<.b.b gXAXAX@XA.,.< 4XA.0.0Xm.aXmX<.}XZ.P.I.I.IXsXsXZ b.PXZ.IX9X9X .I.I bXZXZXZ._.0XZ.IXZXZ f vXZ LXZ.)._.I b.P.!.IXsX9X9X9X9 bXZXZXAXZXZXZXmX@XCXZ._.<XC._.,.!.I.t.t.b.}.a._ v v 9.} f F F.<.2XjXZXZ._ b bXZXsXs.I.,X9Xs.I.IXA.tX@XA.b f fXZXZXA fX@._Xm._XZ.EXs._ sXZXZ._.,XZ._._._._.)XsXAXZXZXZ L.I b.).)X9Xs bX9X9X  b.I.! b.I bXZ bXkX9 z zX9 bXZ 0XZ.I.Y.Y |.,._.0 b bXs.I b b f F.}XA.<.aX<XAXAX@XA.)XAXAX@._.IXm._ C f.<.<X@._._.<.<.a f f d.<._ 0.t._.t._._._.,._ 0XC.,.tXm d d.t g.;.<.b.b gXAXAX@XA.,.< 4XA.0.0Xm.aXmX<.}XZ.P.I.I.IXsXsXZ b.PXZ.IX9X9X .I.I bXZXZXZ._.0XZ.IXZXZ f vXZ LXZ.)._.I b.P.!.IXsX9X9X9X9 bXZXZXAXZXZXZXmX@XCXZ._.<XC._.,.!.I.t.t.b.}.a.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T._X@XZ._.!XZXA.a._._Xa.oXa.o.o.oXa $ U.w {.4.4.4.4.4 =.4 :.4.4 : { : : : : : { : : : ' : ' ' ' ' ' ' 5 ' 5 ' 5 ' ' 5.g.s [ = =.J.J.JX0 M '.1.1XV.s.Z V ~X1X1 # o 5 5XB.ZXG W W.M M + + + M + + + + + + + ' + =XV.qXG.p.O ^.c e.jXF =.4 :.4.4.4XBXp { , 5 oXpXpXp ,Xe iX3 , , , , , :XnXt pX>XtXtXtXtXtXtXtXtXt.X -.+ i iXiX- +X- ,X*X-.{.XXt p ZX5 h hXFXHXyXi i i.+ 5X*.{.{X-.{ -X> p ZXJ >X5 h YXHX3.+Xe.;.{ 5.{ - -.{XtX>.8XJ.s p p p p p p ] !X5 ].p.p.p.p.p.p ].p ].p ].p ].p ].p ].p.p ].p.p.8.l ] ] ].p ] ] ] ].p.R.p.R U U.i 3.f.f.f.f.f.fX4._._.<.t f.a.tXZ bXZXZ.,XZ v.<._.<.a gX@._Xm._X@X@Xm._X@.t._.*X@._X@.tX< v.IXsX9Xs b bX9.I.! bXZ bX X9 b b.I.!XZ._XZXZXZ b.I bXZ.a.bX@.! b bXZX9 b.I.,.I.PXsX9XsX9.  b.I.!.)XZ._._._ 0.<.t._ &.PX .P.!._ f.a c 0._.<.,._X@ f F.}.}XyX6 s.Y._.).!.P.!.!XZXZ.I.P.I.I bXAXZ L.a.b v.,. XZ dX@XAXZXZ.!XZXs.<X@XZ.PX<.aXA._.YXZXZ.I bXZ L b bXZ.IXZ.I b bX9 b.I.I b.I.,.P.I.!.I.).!.I b.I b bXZ.I._X@XZ.<XN._XZXZXsX9XkXs.IXZ.).< F.GX@.0XZX@.t._X@XZ._.!XZXA.a._._XZXZ f._X@X@._ 0 vX@.<X@ d.<.t._.<._._.<.t f.a.tXZ bXZXZ.,XZ v.<._.<.a gX@._Xm._X@X@Xm._X@.t._.*X@._X@.tX< v.IXsX9Xs b bX9.I.! bXZ bX X9 b b.I.!XZ._XZXZXZ b.I bXZ.a.bX@.! b bXZX9 b.I.,.I.PXsX9XsX9.  b.I.!.)XZ._._._ 0.<.t._ &.PX .P.!._ f.a c 0.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.0XZXZ.I._.,.,XZ.!.!XH.o.o.o.o.oXF }.'XF.g.4XB.4.4.4.4.4 { = {.4 /.4.4 / { : : : : : : : 5 : ' 5 ' 5 ' ' ' 5 ' ' 5 ' t >.1 = +.JX0 M.J.J WXnXG t.ZXJX1X1 ~ ~.X 5 ' ' '.Z.zXx W W + + M + + + + + + + + ' + ' +XGXGXt [.O.O.j.j e.r 3 =.4XB = = o - o 3 hX5X5 h :Xy.+ i , , ,.; , , -XpXx t.s.s.8.8 t t.8.8.l ] o ,X= i iX=X-X-X-X-X-X* -XxX> t.l.qX5 h Y.o.# i i iX-X-X* 5.{X-.{XxX>.8.s ZX5.r h YXHXy i i.+ 5.{ -.{.{ -XtX> ]XJ.Z p.8 t.8.8 t.8 t.p.p.p.w.p.p.p.p ].p.p.p.p.p.p.p.p ].p ].p.C.p.p.p.C.p.z ].R.z ].p ].p.l.R $ U.i U *.f.f.f.f.f.f.4X@ gXlX@XZ.0.t.,._._._XAXZXz.a.tXA.<X@XA.,.,.*XZ._X<.tX@XAXmXAXZ._ 4.aX@X<.IXsX9.0._.IXk.P.!XkXsX9XsX9X9XZ.).)XZ.I._ 9._ L.I.).<XZXZXA v 0.IXZXZX9XsX9.!.IX X9 bXZ._.IXZXsXZ.,XZ.I.IXZXZ b b |.P.P.^.I.} f 0 M._ 0.,.Y.!.b f.} f.W._._.!.!.,._XZXAXZXZXA.,.0.!Xs.P.!.).)XZ._XA v.] b b.=.tXAXZ.) L.!.I.} fXZXZXZXZ._XZ.P.!._XmX2 L.P.I.) b.I.P.PXsX Xs.P.).I.!.).I.I b.I.,XZ.,XZ &XC &.,XZ.!.0. .).IXs.IX9X9X X9.PXsXs b.,._.G.G.a 4.).I.Y.0XZXZ.I._.,.,XZ.!.!X9.I.t L._.< v d._.a.<X@._._XZ._ MX@ gXlX@XZ.0.t.,._._._XAXZXz.a.tXA.<X@XA.,.,.*XZ._X<.tX@XAXmXAXZ._ 4.aX@X<.IXsX9.0._.IXk.P.!XkXsX9XsX9X9XZ.).)XZ.I._ 9._ L.I.).<XZXZXA v 0.IXZXZX9XsX9.!.IX X9 bXZ._.IXZXsXZ.,XZ.I.IXZXZ b b |.P.P.^.I.} f 0 M._.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXr.I.I.Y., bXs.,.P.P.oXa.o.oXa.#.w.i.R.4XBXB.4.4.4.4 3 =.4 { = {.4 : { = { / { : : : : : ' : ' : ' ' 5 : ' ' 5 5 '.4.z.1.1 +.J M MX0 +.1XxXx >XJXJX1 ~X1 #.w 5 ' , : ' h.Z.X W WXm + + + M + + ' + ' + ' + ' + WXGXG.q.l.O u.j.c # =.4Xp.4.4XBXpXB.g ].p pX5.X ,.#Xe i , , , , , ,.MXxXt tXJ.s.X.X.X.X.XXG.X G 5.#Xi i iX3X-X-X*X-X*X-XpXtX>.l >X5 h h 5.oX= i iXi 5X- :X*.{.{.{Xx p.sXJ.pX5.w G Y ,Xy i iXe.{.{ -.{.{ -XtX5.8.Z.ZX5.pX5.z.p p.pX5.p.w.p.p.p.p.p.p.p ].p.p.p ].p ].p.p ].p ].p ].p ].z.C ].z.p ] ] ].C.p ].p B ^ U.iXH.f.f.f.f.f.f.u._.b.b g.,._ gXZ.Y._ L.0XZXA.aXmX@ 0._XA.!.,XA.< g.*._ 4X@X@XAX@._.t.t._._XZXsX9._.,X9 b.IXZ.PXsXsXsXsX9XZ.IXZ.IXZXA.a.<._XAXAXZ.P.IXA.b.t L b.0.!X9 z.).I.I bXZXZXA z bXZXZXA.)X .P.I 0Xw |.I :.P b.<.bX@XZ bXN._.Y 0XA v F d f.}XZX@.PXs.P.IXZ.).P.IXAXAXAXZXsXsXsXZ.I.P b b.a.aXZ.I.<.< s b.I.0.)._ FX@._XAXAXmX@.<X@.P._ sXCXZXs.I b bXsX9Xs.I.P.PXs.I b.I.I.!XZ b.I b.I | b.I b.!XZXsXkXZXZ.!.,.I.I.IXsXsX9.PX9.P bXs.IX2.W gX@ b.IXZXZ.I.I.Y., bXs.,.P.PXs.I.t._.t M.<X@.<.<._.t._XZ.,._._._.b.b g.,._ gXZ.Y._ L.0XZXA.aXmX@ 0._XA.!.,XA.< g.*._ 4X@X@XAX@._.t.t._._XZXsX9._.,X9 b.IXZ.PXsXsXsXsX9XZ.IXZ.IXZXA.a.<._XAXAXZ.P.IXA.b.t L b.0.!X9 z.).I.I bXZXZXA z bXZXZXA.)X .P.I 0Xw |.I :.P b.<.bX@XZ bXN.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.v.! b.,Xs b.I.!.!.IXa.o.o.oXa * U } G o.4XB.4.4.4.4.4 3 =.4.4 =.4.4 = { :.4 : :.4 : : : : : : : : ' ' ' 5 ' ' : =.C W.1 +X0 MX0.J.JXnXx.1 >.Z.ZXM ~X1 D.R : ' ' ' ' 'Xp !XVXG W.1 M + + + + + + + + + + / + ' +.8XGXt [.O ^.j e.j h.4 =.4 =Xp.4Xp.4XB o.X o Y ,XyXi i ,.; , ,.dX- -XxXt Z.Z Z.g.XXG.gXG.g G o 5XyXi i iX-X-X-X-X$X-X-XnXtX>.s pX5 h h Y.#Xe i i.+X*X*.{X-X*X- :Xt >.Z Z pX5X5.- Y.o.# i i.+.{ 5.{ -.{.{Xt p.8.Z.Z.p.w.p p.p p p ].w p.p p.w.p.p.p.p ] p.p ].p.p.p.p ].p ].z.p ] ].p ].8 ] ] ].p ].z ] ].p $ n n.i UXH.f.f.f.f.f.f.D.<X@ 4.<XZXmXA._ M._XmX@X@ gX@._X@.tX@ b b.I._.aX@X@X@.*.tX@Xm._._X@._Xm._._XsXs bXZ.IX  b.I.!.IX9.P.I b.YXZ., bXZXAX@ 4.<XZ.)XZ b.!XZ g.a._XZXA.I b b.I.!.I b bXZXZ.Y.)XAXZ b b.qX9X .! 0 & 1X2.n._.aXA.aXZ.I.t f._ M f.}.G.} f.<XZXZ.I.I.!.Y.I.IXs.,.0 0.0.Y.P.IXw &.Y.I.PX XZXAXZ LX< f d.I b vXZ v FX$Xm.I b bXZXZ.*.a.t d._ L.I bXs b.PX9XsXsX9 b.I b.IXZ.).IXZXs b.I.!.I.P.IXs.).IXs.P.I.P.I.!.IX9X9.IX9XsX9X9.P.I.PXs.< F d._XA b.I.,.! b.,Xs b.I.!.!.I.P.!X@ d.a._.aX@._._._XZXZ.,XZ._.t.<X@ 4.<XZXmXA._ M._XmX@X@ gX@._X@.tX@ b b.I._.aX@X@X@.*.tX@Xm._._X@._Xm._._XsXs bXZ.IX  b.I.!.IX9.P.I b.YXZ., bXZXAX@ 4.<XZ.)XZ b.!XZ g.a._XZXA.I b b.I.!.I b bXZXZ.Y.)XAXZ b b.qX9X .! 0 & 1X2.n._.aXA.aXZ.I.t.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXr._._.,XZ |.I.IXZXZXaXH.o.o.o.-.i R.-.4XB.4.g.4.4 3 =.4.4.4 { =.4 :.4 /.4 :.4 { / : : : : : : ' : : : : ' : 5 :.z ZXnXm.J.J M.J.J = WXx [.s.ZXM #X1 ~ #.4 5 ' ' ' ' 5 ' ] Z WXGX. ' + + + + + ' + ' ' + + ' ' ' WXVXG [.s.O ^ e.jXD 3.4 =XBXB =XBXB.4XBXp o 5.#.+Xe i , , , , ,X-Xp.XX>.lXJ ].g.X.gXt.X.g.g o.oX3 i i iX-X- ,X-X-X*X*XxXt p.s [.q h GXHX3Xe i i ,X-.{X- :.{ 5XpXt Z.Z t.wX5.w.- 5.oX= i iXe -.{ -.{.M -Xt p.l.Z.s.p.p.pX5.p p p p.p p.w.p p.p p.p.p.8.p ] p.p p ].p.p ].p ] ].z ].p ].p ].8 ] ].p.R ] ].RXD n n.i XXH.f.f.f.f.f.fX9.&XAXZXmXZ._._.<XA., bXZXA.bXl 4X<X@XZ bXk bX@X@.*X@.tX@XA LXA._.*X@.tX@XA 4._X .P.P.! b.PX9.).! b.!XZXZXZ bXkXZXZXAXZXAXZ.I b.)XZXZ.IXZXA.t.*X@XA., LXs.I.!XZ b.IXZ b b b bXZ bX9Xs bXZXA.* f &X XAXA.!.t.aXC.,Xm v v f I.IXAXA.W.}X2.,.!.!.I b.! s 0 L._XZ s.,._._.<.0XZ.,._X9 b f F.y LXA. X@._.b.t.* L b.IXZ.I.I.Y.I L._.)XZ.).E.PX9X9X X9.IXs.I b.P b.I.I b.I.I._.I.P.P.IXsXZ.,.PXs.P.I.,.I b.I.I |.P.PX XsXZ.!.I.!.IX9.t.G.}._ bXZ bXZ._._.,XZ |.I.IXZXZ.,.I.!.<.<XZXAXZXZ._XZ.&._.0Xm._XZ.&XAXZXmXZ._._.<XA., bXZXA.bXl 4X<X@XZ bXk bX@X@.*X@.tX@XA LXA._.*X@.tX@XA 4._X .P.P.! b.PX9.).! b.!XZXZXZ bXkXZXZXAXZXAXZ.I b.)XZXZ.IXZXA.t.*X@XA., LXs.I.!XZ b.IXZ b b b bXZ bX9Xs bXZXA.* f &X XAXA.!.t.aXC.,.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX- |XZXsXsXsX9 |., LXaXa.o.o.e r }.r.4.g.4.4.4 3.4.4.4.4 3.4 = {.4.4.4 { = { = / { = { / : : : : : : ' : : ' =.p tXGXm.JX0 MX0 M 'Xx WXG Z !.O ~X1X1 ~ ~ ' ' 5 ' : 5 : '.X.sXG WXG = + + + + ' + ' + + ' +XO + ' / [ [XG ] ^ ^.jXo.c.-.4.4XB =XB.4.4XBXBXB o 5X3.#Xi i , , ,.; ,X*Xp.XX> ! V.w.X.X.g.X.gXt h Y ,.# i iXi ,X-X*X-X-X-.{XxXt >.Z hX5X5.-XHXyXi i i ,X*.{X*.{X-X*XnXt.sXJ.8X5X5 h YXH.oXi i iXy.{ -.{ -.{.{Xt [ tXJ.l.pX5.p.w p.p.pX5.p.w p.p.p.p.p.p.p ] ] p.p.p ].p p.p p.p.p ].p.p.z ] ] ].C ].p ] ] ].p.C 2 ^.i.iXF.e.f.f.f.f.f.fX9XZ b.)._.,._., 0XmXm.0 gX@.a.b g.*XZX9Xs.IXkX@X@X@XZX@.*.*XZXAXAXA.t._XA LXm s.PX9X9 bXZXAXAXZXZXZXZ bXZXZ.,XZXZXZ.I.I.I LXZXk LXZ.0.!XZXm.aX<X@ L b b.IXmXA.IXs.I.I b.IXsXsXZ.).P bXs.IXmX@ f.a.PX9.IXZ.< f v.Y.)Xl.b.}.]XZ._._._.]._XZ.IXZXZ.P.P.*.0XZX@.b.<._XC.<.a 4 L.tXA.I.,.t.tX@., bX@X@.tXZ.aX@ b b.I b b bXAXZ.,X@.YXZ.) b.P.IXsX9.IXZ.I b b b.P bXs.I b.!XZ.I b b.P.IXZ b.P.P b.I bXs.I.P.PXsX9Xs.P.I.I.).I.)XsX9.t.}.G F._._XZ.t |XZXsXsXsX9 |., L L.I.P.tX@.,.I.IXZ._.,._XZ.Y._._XZXZ b.)._.,._., 0XmXm.0 gX@.a.b g.*XZX9Xs.IXkX@X@X@XZX@.*.*XZXAXAXA.t._XA LXm s.PX9X9 bXZXAXAXZXZXZXZ bXZXZ.,XZXZXZ.I.I.I LXZXk LXZ.0.!XZXm.aX<X@ L b b.IXmXA.IXs.I.I b.IXsXsXZ.).P bXs.IXmX@ f.a.PX9.IXZ.< f v.Y.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX@.PX9.I bX9.!XC.< bXa.oXa.oXF n } G oXB.4XB.4 o.4 o.4.4.4.4.4.4 = 3 =.4 :.4 : = { : : : { / : : : : : : : -.w.s.g W M.J M M M + W W W t.s.O ~X1 ~ ~X1 G 5 ' ' : ' ' ' 5 :.Z pXG WXG + ' + ' + + 'XO ' + ' ' 'XO 'XGXV [ [ V ^ < e e.R.4 =XB.4XBXB =.1XBXB o 5X3X=XiXe , , , , ,.{XpXx p.ZXJ.w W.g.X.g.X.g.X 5.oX= i i.+ 5 + ,X-X*X- -.XXt >.Z.q h h.-XHX3XiXiXeX- 5.{.{.{X- -XpXt.s V.wX5.w.- YXHX3 i i i , 5.{.{ -.{ -Xt p.sXJ t.p [.p p.w >.w.8X5 ] p.p p.p p.p p.p ] p.p p.p.p.p.p.p ].8 p.8.8 ].z.z ] ].8.z ].z ].R.C ^.i.i.f.e.e.f.f.f.f.f.fX9.IX9.IXCX@.YXZXZ.IXA.tX<Xm.a v vXA bXsX9Xs.IXA.tX@XAXZXAXA._XmXm.*.aXAXZ LXZX@XCX9Xs.IXZ.)XAXZ.)XZ.) bXZXm.0XZ.PXZ.P L.)XZXZ.  LXZXAXZ.,XZ._Xl.*.0.) L L v.aXZ.I b b b.I b.!.)XA.I.I bXZX@XZXAXsX X XsXm f f.< gXl F.b.}.}._XZXZXZ._._ &XAXZ.YXZXsXAXZ LX@.b.<.*.=X@ fXAXz.)Xz.0X@.<._ f._XZXAXA.,., vX@.I.I b.IXs b b.I b.)XZ.I.!.I bXZ.PXs. .IXZXZXZ.).I.IXZ.I.I.IX9Xs.P.I b b.IXZ b.P.! b.I.I b b.I.!Xs.I b.!Xs.I b.!.) g v.a FX7X7._XmX@.PX9.I bX9.!XC.< b.P b.)XZXZXZ.I.!XZXAXA._._._.,XmXZ.IX9.IXCX@.YXZXZ.IXA.tX<Xm.a v vXA bXsX9Xs.IXA.tX@XAXZXAXA._XmXm.*.aXAXZ LXZX@XCX9Xs.IXZ.)XAXZ.)XZ.) bXZXm.0XZ.PXZ.P L.)XZXZ.  LXZXAXZ.,XZ._Xl.*.0.) L L v.aXZ.I b b b.I b.!.)XA.I.I bXZX@XZXAXsX X XsXm f f.< g.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXrXZ.P.PX9X X9 &._ LXa $Xa.o U } $.-XB.-XB oXBXB o.4XB.4 o.4.4.4.4.4 3 3 =.4.4.4 :.4 /.4 : = { : : : : : :.w.s.q.1 / M.J M.J + W.1X. > !.Z ~ DX1 ~X1.p : : : : ' : ' : : :.q.ZXGXGXG = + + + ' + + ' + + ' ' + ' '.1 [XGXG Z V ~Xo e.j.4.4XBXB.4XBXBXBXBXBXFXHX3.+XiXe.;.d , , ,.{Xp.X p.Z VXt.g.gXt.g.gXt G 5X3Xe i iX3 ,X* ,X*X-X- -XtXt ZXJ [.qX5 oXH.;XeXiXeX-X*X-.{X-.{X*.XXtXJ.Z pX5.r 3 Y.o.# i iXe 5.{.{ -.{.{ -X> p.sXJ.l.p p.w.z.p p.p.z p.p.p p ] ].p.p.p.p.8 ].8 p ].8.p ].8.p ].p ] ].8 ].8.z.z.C.z.z.C.p ] U.i U u GXHXH.f.f.f.f.f.fX5.I b.IXZ b b bXZ._XA.t f gXZ LXZ bXsX9Xk b LXZXZ.0XA.) bXZ 4.a.*.) bX9X X9.) L 4.IX9.PXk b.).).,XZXZ.) b.I b b._X@XAXA.,XZ._., & fX@ LXZXZXZ.aX@XAXAXA f f.bXZ.I.P b.I.!Xs.IXZXA.) bXZXs.t s.,.PX .!._ f f.a.0.!.I._.b.b.<.I.IXZ.0XA.0.,.Y.,XZXZXZXAXAX@XA.aXNX<X@X@.0XA.)XzXz.bX@.*.tX@.< 4 L.).YXZXs.PXs.)XZ b b L., b.IXs.IXk |.<._ LX .PXs bXZ._XZXs.I.!Xs.IXsXs.,.!.I b.I.I.P.I b.,XZ.IXs.I b.PXZXZ.)Xs b.P.IXZ.I b b.P.IXs 0._ vX< bXZXZ.P.PX9X X9 &._ LXs b.IXZ.I.I b.I b bXZ.,.Y.!XZ.IXs.I b.IXZ b b bXZ._XA.t f gXZ LXZ bXsX9Xk b LXZXZ.0XA.) bXZ 4.a.*.) bX9X X9.) L 4.IX9.PXk b.).).,XZXZ.) b.I b b._X@XAXA.,XZ._., & fX@ LXZXZXZ.aX@XAXAXA f f.bXZ.I.P b.I.!Xs.IXZXA.) bXZXs.t s.,.PX .!._ f f.a.0.!.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.7.!.I bX9X9 bXw._ LXHXH.o : } U.V.4.g.4XB.-.4.4XB.4.4.4XBXp 3.4.4Xp.4 - 3.4 : = 3 :.4 : : { / { / : : = h.s.q.g / M.J M M M.1X. W >.sXgXM ~X1 uX1XD 3 ' 5 : ' : ' : ' : :.4.Z p WXGXx ' + + + ' + / + / + ' / + / '.8 [ [ p V V e e.jX5.4Xn.4XBXBXnXBXBXB 3.oX3.+ iXe , , , , , -XxXt p.Z.Z.gXt.X.g.X.gXG.-XHXyXi i iX-X-X*X-X*X-X*XnXtX>.sXJ [ h.q G 5X3.+Xe.;X-.{X- :X- :X-XtXtXJ.Z.w.r G *XH.oXi i i.; -.{.{.{.{ - - [.8.s.Z p p.p p.p p.w >.p p.p.p p.p p.p p.p.z p.p p.p.p.p.p.p ] p.p.p ] ] p.p.8.p ].8.8.z.8.p.R U U.i n YXHXH.f.f.f.f.f.f OXs b.P b.I.!.I.IXZXAXAX@ v.I.I.I.PXsX9X.XZ.) | L. XZ b b b.*X@XmXZ bX9XsX9.IXZ.h |X9X9Xs bXZ b.,XZXZ LXZXZXAXA vX@.0 b b.I.)XZ.Y.<.bX@.I.) bX@._X@.*Xl.} f.b., b.I b b.IXs.!XAXA bXZXZ._.*._XZ.&.,., g F.} 0. .)XZ L.aXlXNXZ bXZXm._XmXA 0XCXZ._X@.0X@.0XZXZ.t.a.=.=X@.<.]X@.a.b.=XAX@X@XA LX9 b.0 b.IXZ.I b.I.!.I.I.P.I.I b b.)XZXZ L L bXs.P.IXZXZ.).!.) b.PXs.P.PXZ.IXs.P.I.IXkXsX9XZXZ.I.I.P.I.I.).)XZXZ.I L.I.I.I b.IXs.I.PX9XZXN.b.* b.!.I bX9X9 bXw._ LX9 b L b b.I b.IXZ.IXZ.YXZ.I.! bX9Xs b.P b.I.!.I.IXZXAXAX@ v.I.I.I.PXsX9X.XZ.) | L. XZ b b b.*X@XmXZ bX9XsX9.IXZ.h |X9X9Xs bXZ b.,XZXZ LXZXZXAXA vX@.0 b b.I.)XZ.Y.<.bX@.I.) bX@._X@.*Xl.} f.b., b.I b b.IXs.!XAXA bXZXZ._.*._XZ.&.,., g F.} 0. .).5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXr.,.) b bXsXZ.n.0.)Xa.o.oXF U B.g.4.-XBXBXB.4.- o.4XB.4.4.4.4.4.4.4.4.4 =.4.4 =.4 : 3 / { = : : = : {.g.s.p W / + M + +.JXnXG WXV.s.ZXM ~ ~X1 ~ ~ o : : : : : : : : : : : '.8 tXGXGXG / + ' ' + ' + ' + ' ' / / ' ' WXV [XVXg.O.c e.c ^ o.4XB.4XBXBXnXB o @XH.+.+Xi.+ , , , ,X- -XnXt.8.Z.s.g.X.XXG.g.XXt o.oXyXi i iX- ,X- +X-X-X-XxXt [.Z.Z h.q h G 5.o.;.;.;X-.{X-.{.{.{.{.XXt.Z.O.p G @ YXHX3 i iXe ,.{ -.{.M -.{Xp p Z.Z.l [.p [.p p.w.p [.p p.p p.p p.p.p.p.p.p.p ] p ].p.p.p.p.p.p.p ].p ].p ].p.p.p.8.C.z ].z $ n.i n X.eXHXH.f.f.f.f.f.fX5 bX9Xs.P.I.!Xs.I.P.!XZ.I.0 bXs.I b.PX9.) bXsXZXZ.) |XZ b bXZ bX9 bXsX9.PX9Xs.!.0._XZXsX9XsXZ b.,XZ.0XmX@.a.<X@.< L.t b.IXZ.IXZ.0XA._.a g.<XmXm._._ fXl.b.b g.,.) L LXZ.).IXZXA L b.I.  g._XA LXA gXZ.b.} FXZ.).).I b.*.b.}XZ.I.)XZ.0XAXZX@.].0.<.<XZXZXZ._. .I.b.t.t 0XmXA f fX@._._ 0XA L bXs b b.PXs.I b.I bXZXZ.IXs b.I.I b b b.I.,X9.I.PXs.IXZ b b.I.!.I.IX9.PXs ).PXs.P.!.!.P b b b.) b b b b.I.I b.).I.I.I.I.EXZXZ.I b.I.PXsX9 g f fXZ.,.) b bXsXZ.n.0.).).!.P b b b.I b b b.IXZ.I.P.IX9Xs bX9Xs.P.I.!Xs.I.P.!XZ.I.0 bXs.I b.PX9.) bXsXZXZ.) |XZ b bXZ bX9 bXsX9.PX9Xs.!.0._XZXsX9XsXZ b.,XZ.0XmX@.a.<X@.< L.t b.IXZ.IXZ.0XA._.a g.<XmXm._._ fXl.b.b g.,.) L LXZ.).IXZXA L b.I.  g._XA LXA gXZ.b.} FXZ.).).5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T C._._.PXZXZ &.n._XZXaXaXH.R U X.-.gXBXB.gXBXBXB.4XB.4 o.4.4.4.4.4Xp.4 3 { = {.4 { = =.4 : / { = { :XG.s.z.1 = + M + M + /XG WXG t.s VX1 ~X1 ~X1.g : : ' ' : : : : : : / : =.X V.qXGXV.1 + / ' + / ' / + / + 'XO ' / / > [ [.8 V.j.c D.j G.4XBXBXnXBXB.XXB {.oXyXeXiXy ,.; , , ,XpXxXt.l.Z.lXt.X.gXGXt.gXt Y.o.+ i iXeX-X-X*X-X-X*.{XxXt p.Z Z h h h h 5 ,Xy ,.;X-.{.{X-.{X-.{XxXt.s ^.R.- * *.o.+XiXe , 5 -.{.{ -.{ -X. p.s.s.8.p.p.p p.w p.p.p p.p p.p.p.p.p.p.p.p.w >.8.p p.p.p.p.p.p.z.p.8.p ] p.p.8 ].p ].8 ].p.R 2 D U.iXFXHXHXH.f.f.f.f.f.fXq b.I.I., b.IXZ.I.P.P.I.PXsXs.I.I.).I.IXs bXZ b.I b.IXs.) b | 8Xs bXsXkXZ.P.I b bXA 0., b bXs b.)._.a.bX@.a. ._ b.)XsX@.Y.IXZ b.IXZXZ.0.;X2.a.I bXA v.b sXZXZXZXZ bXZ.PXsX9.P.I bXZ.). .,X@.0 LXZ LXz g._.,Xs L bX9 bXA.b.nXZ.IXsXZXAXm.Y d F gX@.W.!X@XAXm L.I 4._ &.<.,.PXk bXAX@Xm L b.) L.< sXsXs.)Xm.I b.I b.P b bX9XsXZXZ.I.PXsX9.I. .IXZ.! b.I.IXZ.IXs.I.PXs.P.I.Y._._XZ.) b b.!.I b b bXZ.,XZ.IXZXZ.)XZ.) L.I.IXZ.I.I.I bXs.P.I., v.a._._.PXZXZ &.n._XZXZ.I.I.!.!.I.!.I.I bX9 b bX9X9Xs.I b.I.I., b.IXZ.I.P.P.I.PXsXs.I.I.).I.IXs bXZ b.I b.IXs.) b | 8Xs bXsXkXZ.P.I b bXA 0., b bXs b.)._.a.bX@.a. ._ b.)XsX@.Y.IXZ b.IXZXZ.0.;X2.a.I bXA v.b sXZXZXZXZ bXZ.PXsX9.P.I bXZ.). .,X@.0 LXZ LXz g._.,Xs L b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.n.;.].P.) bX2X7._ bXHXa 3 n n.gXB.-.4.gXBXBXB.4.g.4.g.4.4.4.4XB.4.4.4 =.4.4.4.4 :.4 :.4 :.4 =.4 :.g B.zXG = +.d +.J.J /XGXGXG t.s.ZX1X1X1 ~ ~.p 3 : : : : : : : : / : : : : :XJ >XGXGXV + + + / + ' + ' / / ' ' ' ' /.qXV [ [XM u eXf e R.4XBXBXBXnXBXB.X 5.o.+XeXi , , , , ,X*XpXxXG.s.Z.l.X.gXt.gXt.g.X 5X3.# i iXyX- ,X- +X-X- -XxXt ].Z t.q.q h h oXH ,.; ,X-X-.{ 5.{.{X*XpXt.p $.VXF Y 5.o.+.+.;X- -.{.{ -.{.MXpXt t.s.s ]X5.p [.p p.p p [.p.p [.p p p p.p.z p.z.p p.8.p.p.z p.p.8.p.z.p ].p.p.z.z.p.p ] ] ].lXDX1 e.i B 5XHXH.e.f.f.f.f.f.fXqXZ.I b b b.I.!XsX9.P.P.P.I b b.PXZ.IXZXk.) b bXZXZ b.I. XZ |.P b.)Xk.y.IXs bX9X9 bXm.< b.I b b bXA.*.a.t.<X@XZ.) b b._ 0.Y.I.IXZ L._XZ.a f d.!.I.YX@X@X<XZ b bXk.).,XsXsX9X9Xs.I. X@ g L bXA.). X+XAXZXZ b.I.)XZXZXmX@.< &XAXZ b.)XZXZX@ d fX@ v.< 0._Xm b.) L.<.n.t._.,.!.!.0.0XAX+XZ zXZXC.b s b.I b._ b.!XsX9 b.PX9 b b.I.I.! b.) bXZXZ b L bXs b.).,.,.I |.Y |., 0XmXZ bXs b.I b.I L.I.I.IXA.) L.) LXZXZ.)XZXZXZ bXZ.I.I.P.!XsX  bXZ._.n.;.].P.) bX2X7._ b.).I bXZ.,.!XZXsXs.IX9X9X9XsXs.P.IXZ.I b b b.I.!XsX9.P.P.P.I b b.PXZ.IXZXk.) b bXZXZ b.I. XZ |.P b.)Xk.y.IXs bX9X9 bXm.< b.I b b bXA.*.a.t.<X@XZ.) b b._ 0.Y.I.IXZ L._XZ.a f d.!.I.YX@X@X<XZ b bXk.).,XsXsX9X9Xs.I. X@ g L bXA.). X+XAXZXZ b.I.)XZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T d F F.!.I.!XC.n.0X+XaXa X } $.-.g.-XB.-XBXB.gXB.4XB.4XB.4XB.4XB.4.4.4.4.4.4.4 {.4.4 :.4 = 3 : {.gXD.8XG = '.J + + M +XG WX. >.s.Z ~ ~X1 ~ #Xg.4 ' - : : / : / : - : : : = : :.wXJXGXGXV =XO + ' ' / ' ' / + / / ' / ' = [ [ p.l ^.c D.c.j.-XBXB.1XBXBXBXB YX3XyXeXi , , , ,.dX*XpXx [.sXJ.p.X.gXGXt.gXt.g 5.oXe i i ,X-X-X-X-X-X* -.XXt t.Z.8.q.qX5 h.X 5 ,.; , ,X-X*X* 5.{.{ -.X h h o 3 5.o , , , 5.{ -.{ -.{ -XpXtXV.s.s.8 > p p p.p p.z ].z.p p.8 ].z.p p.p.w.z.p p.p.8 p.p.z.p.p p.p >.z.p >.8.p.8.p ] p ] ].p $ ^.i <XFXHXHXHXH.f.f.f.f.f.fXq.IXZXZ.I.I b.IX9Xs.I.IXs.P.P b.I b bXZX9 b b b., |.IXZ.)XZ b b L.y b b.I.IX9 bXsXk bX@ bX9 b.P.!.0.< g.}.t.,XZ.IXs LXZ.0._XZXZ.)XZXZ._.,.a F.IXZXNXZXZ.*X@.I b bXm s b.I.PX9XsXZ.* f.]X@XZXZXA.)XZ.I bX@.IXZ bXZ.t.<Xm._.,XC.0XZXZ.Y.,.a.Y 0 f.bXZ._._XAXZ._._XZXm.0._XA., 0._XAXZXAX+.0.].} gX@XZ. .I.IXZXZ b.IXsXmXsXs.P bXZXZ.,Xm.0.0._XZ.I.I.I.!XZ bX@XZXZ d._XZ.)XsXs b.I.I.!.I bXZ.) b.0XZ.I.IXZXZ.I b.I.)XZXAXZXZXZ LXZXZ.I L.tXZXZ.} F F.!.I.!XC.n.0X+ b.) b.IXs.I b.P.PX9XsX9.PXkXsXs.I.IXZXZ.I.I b.IX9Xs.I.IXs.P.P b.I b bXZX9 b b b., |.IXZ.)XZ b b L.y b b.I.IX9 bXsXk bX@ bX9 b.P.!.0.< g.}.t.,XZ.IXs LXZ.0._XZXZ.)XZXZ._.,.a F.IXZXNXZXZ.*X@.I b bXm s b.I.PX9XsXZ.* f.]X@XZXZXA.)XZ.I bX@.IXZ bXZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.k F F._Xs &X6XAXZ bXa *.i }.w.gXB.-XB.g.4.4.-XBXBXFXBXFXB.4.-.4 3.4.4 3.4.4.4.4 {.4.4 3.4 :.4.gXD.8XG.1X* + + + M +XG WXG [.Z.sXM # ~X1X1 ~XB : 3 = : = : : : = : : : = : { =.4.Z >XGXGXG ' / + / + / + ' / / + / / / / t [ [ [ ^.j e e.j.pXBXBXBXBXB.X o 5X3.+XeXe , , , , ,.{XnXx p.Z.O hXt.g.X.g.g.g.g 5.#Xi i i , ,X*X- +X-X*XpXtX>.sXJ p.q.q h hX5 -XH , , ,X-X-.{X* 5.{X-Xp o o - 5 5 5 5 ,X-.{ -X- -.{.{.MXxX> p.s.s p p >.p p p p.8 p.z p.p p.z p p.z.p.z p.z.p p ].p p.p.p p.p ].p.8.p ].p.z.z.p ] ] ] ].C 2 UXo U nXHXHXH.e.f.f.f.f.f.fXq.YXs.I.I.I b.I.)XZ.P b b b.! b b bX9X9 b.IXsXs.IXZ b LXZ bX9Xs.I b LX9X9XsX9Xs bXkXA.0._ L L.I b.I.IXs b._.0XZ.,X@XA.)XZXZXZXAXZ.IXZXAX@X@X@XAXZ b.P.IXZ.a.<XA.).0 b b.).)XZXA.t f.< b.)XZ._.)XZ.,.I b._ b b b.! bXZ v.].YXZXA.,.! b.I.!XZ &._.0.I.!X@._XZXZ.I.).!._.,XZ.I.I.)XmXZ LXm.bXl g CXZ.h.P b b.I bXsX9.PX  b.).I.I.PXZ.I.I.!XZ.)XZXZ.,.).,.IXZXZXZXZX9.I bX9X9X9.PXsXZXsXsX9X9.I b.I.I.I.IXZ b.I bXs b b.)XZXZXZ b.).I.IXs.IXZ.]XC F F._Xs &X6XAXZ b b.I.I.I.I.I.PX9X9X9X9XsXs.PXs.I.I.YXs.I.I.I b.I.)XZ.P b b b.! b b bX9X9 b.IXsXs.IXZ b LXZ bX9Xs.I b LX9X9XsX9Xs bXkXA.0._ L L.I b.I.IXs b._.0XZ.,X@XA.)XZXZXZXAXZ.IXZXAX@X@X@XAXZ b.P.IXZ.a.<XA.).0 b b.).)XZXA.t f.< b.)XZ._.)XZ.,.I b._ b b b.!.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX4.} FX<.I.YXj., L b.e $ } $.g G.-.g.-.g.-.g.-.g.g.-.-.-.-XB.g.-XF.gXF.- o.-XB.4XF.4XF o.4.gXD tXGXG + + + + + + M.1XtXG.8.s.ZX1X1 ~X1 D $.4 3.4.4.4.4 3.4.-.4.4.4XF.4 o.4 o.4.4.w.s pXGXV W ' / 'XO / + / ' / ' / / / / / > > [.O ^.j.c e.j.C.-.g.g.- G oXHX3.+Xe.+ , , ,.dX- -XnXt >.O !.r h h h h.r h h.oXyXi iXeX-X-X-X-X*X-.{XxXt p.Z.Z.p.w.w.w.r.r.r o 5 , ,X-X-X-.{.{.{.{ 5 5 - 5.{ -.{ 5.{ 5.{ -.M.{.M.xX.XV.8.s ] ].R.p.R.R.p.p.R.l ].C.C.R.C.p.C ].R ].C.C ].C.C.C.l.C.C.l.C.C.C.C.l.R $.R $.C.C.l $.C.R 2.i.i.i.-XH 2XHXH.e.f.f.f.f.f.f JXs b.I.Y L.!.I.I b.I.!XZXZ b.I.I bXsXk.I b b b.I.  b.) bXZX9X9Xs.I L.IXsX9 b b.) L._Xm.<XZ b.! LXZ. .). XC 0.!X@XZXZ.,._XAXZ.,.0 b.IXmX@Xm 0XZ.)XA bXZXZ.*.a sXAXmXZ.I b bXZ.t.<.}.]XZXZXsXZ.!._XAXZXZ._ b.)XZXZXZ.< f.n._.Y.YXw.I b.I.IXZXA.0XZXZ.!.,XZ b bXZ.I b.I.! bXsXZXZXAXA.0X@ f.W vXm.)X@.I b.I.I bX9X XsX9 bXZXZ b.!., b.IXZ | bXs.I.!XZXsXs.).).IXZ.!.IXsX9Xs.P bX9X9 b.PXs.I bXsXZXs.I bXZ.I.I.I b.IXZXZ L.I.)Xs.I.P b bXZ.P |.I.} FX<.I.YXj., L b.).!.I.I b.,.E.IX9XsXsX9X X9.I.I bXs b.I.Y L.!.I.I b.I.!XZXZ b.I.I bXsXk.I b b b.I.  b.) bXZX9X9Xs.I L.IXsX9 b b.) L._Xm.<XZ b.! LXZ. .). XC 0.!X@XZXZ.,._XAXZ.,.0 b.IXmX@Xm 0XZ.)XA bXZXZ.*.a sXAXmXZ.I b bXZ.t.<.}.]XZXZXsXZ.!._XAXZXZ._ b.)XZXZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.u f f f b.,.Y., L.I 3.'.i.i n n ^ ^ n n ^ n ~ n n n U n n ^X1X; ^ n n n ^X1 ~ ^ ^ n n.O ^.s t.q W ' + + + + + +.1.qXG p.s.Z ~X1 DX1X1 <X1 n n eX1 ^ U n n n ^ e n n n n n ^ ^ n ^Xg ].q [XG ' / / + / / / ' / ' / / / / / W [ > ! ^ ^ <.c.j.j e ~ n ^ D.-.o.;.+Xe ,.; , , , ,.MXxXt.8.Z V ^ n n nX;X; ^ n ,.# i i.;X- ,X* ,X*X-Xm.XXt >XJ.O ~ nX; n U ^X;.R - 5X*X-X-X-X-.{X-.{.{.{ -.{X-.{.{.{.{.{.{.{.{.M.xX.X> p.s.s.O n n ^ uX1 ^ nX1 n n n U n U n n nX;X1 nX; n ^X; n.OX1X;X; ^ nX; nX1 n n ^ n n n U ~.O n U U.i DXHXHX;XHXHXH.f.f.f.f.f.fX9XZ b.IXZ.I.I.P b., b.,.,.I.).IX9.) b bXsX9 b b.)XA.IXs b.PX9X9XsXZXAX9.I b.).I.P b.)._ v.< & 0XC 0 0.<XZ d d f.0.0.!XA.,XZXZ._.!XZ.IX@XZ._., b LXZ.).!.I LX@._ 4X@._XZ.IXk LX+XA F.<Xm.,.PXZXZ._XA._._XZX@._.a.< 0 |._ 1 | &.Y &.PXs.I.P.PXZXZ.!._.PXs bXs b._Xs.I b.,.) b L.0._Xm f.b f.}XA b bX@XZ. .I.I.!XsX9.P bXs.!.I.IXAXZ b b.I.I.P.IXs.)XAX9.P.I.P.I.!.IX9XsXZXZ.).P bX9XZ b.).PXs.I.,.I b b.)XZXsXs bXZ.I.I.I bXsXsX9 b.,.,._XsX9X9 f f f b.,.Y., L.I.,XAXZ bXZ._.IXs.PX9XsX9XsX  b.I.)XZ b.IXZ.I.I.P b., b.,.,.I.).IX9.) b bXsX9 b b.)XA.IXs b.PX9X9XsXZXAX9.I b.).I.P b.)._ v.< & 0XC 0 0.<XZ d d f.0.0.!XA.,XZXZ._.!XZ.IX@XZ._., b LXZ.).!.I LX@._ 4X@._XZ.IXk LX+XA F.<Xm.,.PXZXZ._XA._._XZX@._.a.<.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.u.P._.bX@XZ.<XZ L.) 3.V.V G.V G G G GXF G G G G G G.g G G B G G G.- G G G G 2 G G G G $ _ t.q.1 ' + + + + + + =XGXGX>.Z.Z.OX1 ~ ~ ~ e ^ $ G GXD B.- G.g.-.g G.- G G.g G.- G.g G.-.C.ZXGXG [ ' ' + / / ' / / / / / / / / / = > [ p V ^.cXo S.% S S e.V G YXHXy.+Xe.; , , ,.dX- -XxXt Z !.R G G G G h.r GXFX3.+ i i ,X-X*X-X*X-X* -XtXt t.Z.w _ G.V G G G GX; G.4.{X*X-X*X-X- :X-.{X-.{X* -.{.{.{.M.MXmX$X$XzX.XV >.s.s.r.r G G G n.r G.r G.r G G G G.V G G G G G G.r G.V G G G ^ G G G G.r G G G G.V G G G h ^ G h.r.V.V.-XHXHX;XHXHXH.f.f.f.f.f.fX5.P.!.,.,.I.I.E.,XZ.).,.I.I bXs L LXZ bX X9 bXAXA bX9X9 b.,.IXsX9 L._ LXZ.IX X9Xs.I.! bX7X7X2. .)XA.I.EXZ 0X@X@XZ.)XZ., L b.I._.)Xs bXA.) b LXZ b bXZ.*XZ.YXAX@XlX@XZ b b L.t.b.}Xm.tX@.0.I b._._.0 |.!.Y L LXZ 4.h.*.,XZXA.tX@XC.IXs.P.!.IXZ.IXZXZ.<XZXZ.!.0.<.I.YXZXZ._._ bXZXZXAXAXAXZ bXZ.).I.I.) L bXZ b.I.I.I.I b bXZ b.I b., b.PXs.IXsXZ.P.P.P.I.!.I.I.IXs.!.I.!.I bX9XsX9XZ.,XZXsX9.) b b.PXZ.I.PXZ L.).IXsX9Xs bXkXZXZXAXs.)XsX9XsX9.P._.bX@XZ.<XZ L.).) bXZXZXZ b.IXsX9X9.IXZ.EXZ._.PXs.P.!.,.,.I.I.E.,XZ.).,.I.I bXs L LXZ bX X9 bXAXA bX9X9 b.,.IXsX9 L._ LXZ.IX X9Xs.I.! bX7X7X2. .)XA.I.EXZ 0X@X@XZ.)XZ., L b.I._.)Xs bXA.) b LXZ b bXZ.*XZ.YXAX@XlX@XZ b b L.t.b.}Xm.tX@.0.I b._._.0 |.!.Y L LXZ 4.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T 8Xs.I._._Xm.<Xm LXZXaXaXa.o.o.o.oXH.oXH.oXa.o.o.o.o.o.oXH.CXH.o.oXa.o.o.o.o.R.o.o :.gXg.C.q W / + + +XH + + '.qXGXG.s.s.OX1 ~X1 ~ ~ D < B 3.4 $.RXHXH.o.o.#.oX3.oXy.o.o.o.o.o.#.o : _ p [XV / ' / / / / / ' / / / / / / = /XG > p.s V ^.c.% SX,.@.c D.V YX3.+.+Xe , , , , ,X-XpXxX>.lXJ GXH.o.oXH.o.o.o *XyXeXiXi ,X-X-X* ,X*X-XpX.X> Z.ZXg ,XHXH.oXHXH.o RXH o oX-X3 ,X- -X-X-.{.{.{.{.{.{X$X$X$X$.dXz.xX.XV t Z.Z.4.o.oXH.oXH BXHXH.oXH.oXH.oXHXHXHXHXHXH.oXH.oXaXHXaXHXHXH BXHXHXHXaXHXaXHXHXHXHXa.oXHXaXHX;XHXH.oXaXHXH 2XHXHXH.e.f.f.f.f.f.fXq.I.IXZ.,XZ.,.,.IXZ.IXZXZ.I.I L.0XZ.IXsX X9 bXZ.0._ b.IXsXm.,X9 b., |.,.IX9X X9X9.I.I bX2X6Xy.).!.) L._ s L b L._XZXZ.).I.).).IXsXk. ._XZX@._.,XA._XAXA.IXZXZ._.aXmX@XZ.) L f.} f g.aX@XAXZXZ.<.Y & |.!XZXAXA.)X@X@X<.<XAXZ.)Xz 0.!.PXs.I.P.I.!.).I dXZ.!XZ.,XZ.! b.!.I b., b.IXZ.).!XZ LXZ.0.!.I.IXA.0 b.!.I.! bXs b.I.IXZ bXZ b M.IXsX Xs.).IXsX9Xs.I.E.I.IXsXk b bXZ.,XZ.I bX9.I.P.,.! bXZ.I.I b.I b.I.!._XZ L bXsX9 bXA.<.Y |.I.I.PX9Xs.PXs.I._._Xm.<Xm LXZ LXZ.).,XZ.IXs.PXsX9X9X9.I b.I.,.I.I.IXZ.,XZ.,.,.IXZ.IXZXZ.I.I L.0XZ.IXsX X9 bXZ.0._ b.IXsXm.,X9 b., |.,.IX9X X9X9.I.I bX2X6Xy.).!.) L._ s L b L._XZXZ.).I.).).IXsXk. ._XZX@._.,XA._XAXA.IXZXZ._.aXmX@XZ.) L f.} f g.aX@XAXZXZ.<.Y & |.!XZXAXA.)X@.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T 8 b b.I d d.}XAXZ. XHXaXa.oXHXaXHXa.o.oXaXaXD.oXaXa.o.o.o.C.o.o.o.oXa.#Xa.C.R.g G.p B.8.q W / + + ' + ' + +.qXGXGXG.s.ZXMX1X1 ~ ~ ~ ~ D ^ < ~ ~ u ~ ~ ^ $.4.o.R.o.oX3.o.oXa.-.w B ~Xg tXV [ ' / / + / ' / / / / / / = / = / =.8 p.z V _ u.cXf.@.@ u u r *.oXy.+Xe , , ,X-.d.{XpXxX5.s.O.-.o.o.o.o.o.o.o 5X3Xe iXeX-X-X* ,X*X*X*XpXt [.sXJXDXD.oX3XHXHXH Y A , * o 5XHXe i i.+X-.{.M.{X$.d.dX$X$X$.M.xX.XVXV Z.s.g !XHXHXH.oXH.oXH BX3XHXHXHXHXHXHXaXaXHXH.oXH }.oXHXHXH.oXHXHXH 2XHXHXHXaXH BXHXHXHXHXHXHXHXH ,X;XHXHXH 2 2XHXHXHXH.e.f.f.f.f.f.fXq.I.).I.YXZXA.!.I.! b.).I.IXZXZXZXs LX9Xs bXZ.t._., b b.IXs.)XZ b.YX6X6 |XsX9X9X9X9 b.I.<X7X6.,XZ b._ s b.I b 4XAXZXAXZXZ.).) b b. ._.0.*X@._.Y.Y.< dXZXk.0XAXZ fX<XAXA LX$ f fXl.bX@XAXZ.,._XwXw &.,.,XAXAXZXmXZXZ._X2._ LXAXZXAXZ.I.I.P bXZ b bXZ.,XZ.,.!._.I.I.I b b.I b._ b bXZ.)XZXZXA._.IXs.I., bXZ.IXZXZ.,XZ.I.IXZ.I.I b.I._., bX .I.IXZ.IXsXZ.IX9 b.P.P.!.P.P.IXs.P.).P bX9X9.PXA b b.)XZ.I.)XsXZ.)._XA.I.IXZXs b.,.,.P bXs.qX9X9X9.P b b.I d d.}XAXZ.  LXZXZXs.IXs b.I.I.P b.PX9.PX9.).I.I.).I.YXZXA.!.I.! b.).I.IXZXZXZXs LX9Xs bXZ.t._., b b.IXs.)XZ b.YX6X6 |XsX9X9X9X9 b.I.<X7X6.,XZ b._ s b.I b 4XAXZXAXZXZ.).) b b. ._.0.*X@._.Y.Y.< dXZXk.0XAXZ fX<XAXA LX$ f fXl.bX@XAXZ.,._XwXw &.,.,XAXAXZXmXZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.u bX9Xs.}.G.GX@XAXZXa.o.o.o.o.o.o.oXH.oXH.o.o.o.o.o.o.o $.o.o.o.o.o.o :.- G ^ _XgXD.z.q W / ' + ' + + + +.g.qXGXG [.ZXMX1 ~ ~ u ^ ~ u ^ ~ ^ ~ u ^ D ^ <X1 {XyX3XyX3.o {.w R ~ ~ ^ ~ _ t [XV / + / / / / / / / / / / / = / = / W > p.8 V ^ ^.jXoXo < <.R 5X3.+X=.+ , , ,.d ,.{XpXx p.Z V {XH.o.o.o.oXH.o *.;XiXi.+ ,X-X* ,X*X-.{XxXt p.s.l ZXH.oXH.- G.V.r.-XH Y *XHX3 i i iX3.{.{ -X.XnXz.xXx.xX.X.XVXV Z.s.s o 5 B MXHXaXHXaXHXHXgXHXH ,XH.oXaXH.oXH.oXHXHXH.oXHXH.oXHXH.oXHXH 2.oXHXHXH.oXHXHXHXHXHXHXHXHXHXHXH _ 2 2 2XHXHXHXH 5XH.f.f.f.f.f.fXq b b.,.,XZ.,Xs.I b.,XZXZ L.)XZ b.IXs bX9 L.)._._.<.;.0.I bX9X9 b.,X7.) LXZ zXs.).).)X9 b._X7.]X@X+XA.! b._.) b b.,.IXZXAXm.t._X@.aXZX@ b b bXZ.* sX@ g.<._._ LX@XAXOXl.b.b f f.}.b f s.Y | | &.kX7._ L LXAXA.*X@XAXA 0XZ L._XAXZXZ.) b.IXkXz.}.<.<XZXAXZX@._XZ.!XZ.!.I.!XZXsXZ b.)XZXZX@XZXZ.<._._X9.P b.IXZXAXZXs.I.I.I.I.I.IXZ.IXZ.Y b.IXs.! b.)XZ.I.I.I bX9X9Xs b.I.PX9.I.IXZX Xs b._X@ L.I bXZ b.I b b.I.)XZXm._ |.IX9 b b bXs bXs bX9X9 bX9Xs.}.G.GX@XAXZ.).I b.I.IXZ.! b.IX9 b b bX9 b.I.I b b.,.,XZ.,Xs.I b.,XZXZ L.)XZ b.IXs bX9 L.)._._.<.;.0.I bX9X9 b.,X7.) LXZ zXs.).).)X9 b._X7.]X@X+XA.! b._.) b b.,.IXZXAXm.t._X@.aXZX@ b b bXZ.* sX@ g.<._._ LX@XAXOXl.b.b f f.}.b f s.Y | | &.kX7._ L LXAXA.*X@.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.PX9X XsXC.} F._XZ L.e 5.o.oXH.oXH.oXa.o.oXH.oXH.o.oXD.o.C ,.o :.-.g R n 2 _Xg.s.8.qXGXG : + ' + + ' + ' ' [.qXGXG >.s V.O ^ ^ ^ u ~ u ~ ^ ^ ^ D D u D < ~XH.o.oXHXF.w ^ ^ n n 2 B BXg > [XV / / / / / / / / / / / / = / = /.4 / p > >.l.O _ n n ^ ^ ^ D ^.r G 5 , , , , ,X-.{XpX. p.s V 5X3.o.o.oXHX3.o Y.+XeXi.+ 5 +X-X-X*X-.{XxXt p.ZX5 $ : G X XXFXFXF GXH o 5X3X= i iXi 5X-.{XtXtX>.XX.XtXGXV > t.s ].X :XH.o.oXgXHXHXHXH ,XHXg B ! 2XgXHXHXH.oXHXHXHXHXHXHXH.o 5.oXHXH.oXH 2 ,XHXH.oXHXHXHXHXHXH.oXH.oXHXHX3XHXHXH 5XHXHXH.oXaXa.f.f.f.f.f.fXqXs.I LXZXZ.IXsXs bXZ.) LXZ L.!.) b.I.)X9XZ._X@XZ.0X7XCXA bXs b zXs | b b L b b.I.I LXs bXZ F f.a L.! b.) b LXs bXA._X@X@ g.a.0.*.0.I M.) b bXAXm.YXA.*.a g.<.t.b.<._ F.b fXl g.b g f.t.<.,XZ._.Y.nX@XZXZ.,Xm.<X@XAXA._ 0XZXZXZXZ.!XZXm.*.=.a.P bXA.0._.)._ L |XZ.I.I. .) bXZ., L.I bXZX@.0 bXZ L b b.PX9.IXZ.)XZXZXs.!.) b b bXZXsX9XZXZXsX9X9X9 b.! b.IX X .P bXZXZXsXs.P.)XZ.P.P.P.PXZ sXZ L.).!.I bXsXk L.)Xm 0.,X9X X9X9Xs.I.PXs.P bX X X9X XsXC.} F._XZ L bXs.IXs bX9.IXs b b.I.IXk.).I.I.IXs.I LXZXZ.IXsXs bXZ.) LXZ L.!.) b.I.)X9XZ._X@XZ.0X7XCXA bXs b zXs | b b L b b.I.I LXs bXZ F f.a L.! b.) b LXs bXA._X@X@ g.a.0.*.0.I M.) b bXAXm.YXA.*.a g.<.t.b.<._ F.b fXl g.b g f.t.<.,XZ._.Y.nX@XZXZ.,Xm.<X@.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.PX9XsX9XZX2 F.bX@ LXaXDXa.oXDXaXH A.oXHXD.oXD.o.oXD.lXDXDXD.CXgXg RXDXgXD.sXD.w.q.q W / + ' ' ' + ' + ' /.zXV.qXG p.sXDXDXDXD RXDXDXg B B ^ DX1X1 eX1X1 ^.oX3XD.lXg BXgXDXgXDXDXDXD.z [ [ [ / / ' / / / / / / / = / = = / = /.4.8 > > >.zXg.Z _ _ B _ 2 2X;X;.O ! , , ,X-.d -XxXt pXJ ZXD.o.o $XHX3 $XH 5.+XiXe ,X-X- +X-X-X* -.XXt.l.ZXD.w X.V.-XFXF Y.r r r @XH.o i i iX3.{.{.{XxXtXt.X h p >.8.s.Z.O 3XH R.oXHXg B ,XHXH BXHXHXgXHXHXgXa BXgXaXH BXHXH B.o B 5.o BXaXH B 5XH B 2XHXgXHXH 2.o 2XHXH }XHXa U.oXH 2XH.o 2XHXH _XHXHXH.f.f.f.f.f.fXq.I.I.,.I.,.).I.I.I.I.I.I.I b.I b.I. .I b L.*X@.a._.<X2XC.) LXsX9 z.! L L L.) bXZ b.I.IXZX@Xl.a 0XA.)Xz.IXs bX9.IXZ._ v.b.<.< L._ b.) L._ LXZX@._XAXZXZ._XC.<.<.<XZ.I.*.b.}._ s._ g.b fXZ.) b bXZXAXA.)._XA._._._._._ &XC gXZ bXsXZXm.).} fXZ b.I._.!XZXZ.t.)XZ._ bXZ.IXZXZXZXZ.< b b._ dX2._.I.,X9.IXs bXsXZXZ.P.I.IXZXZ b.!.I.I.PX9Xs.,.PX9Xs b.P.I.P.I.IX9Xs.I.,.!X9.P.PXZXZ.IXs.)XsXs.P.I.I bXZ LXZXAX@.t.t 0.I b.E b.P.I.I b.I b.!.PX9X X9XsX9XZX2 F.bX@ L b.I bXZ.Y b.IX9Xs.) bXs b.PXs b.I.I.I.,.I.,.).I.I.I.I.I.I.I b.I b.I. .I b L.*X@.a._.<X2XC.) LXsX9 z.! L L L.) bXZ b.I.IXZX@Xl.a 0XA.)Xz.IXs bX9.IXZ._ v.b.<.< L._ b.) L._ LXZX@._XAXZXZ._XC.<.<.<XZ.I.*.b.}._ s._ g.b fXZ.) b bXZXAXA.)._XA._._._.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.uX9.qX9 b L.0.}.} vXaXaXH.oXaXH.o.o.oXa.oXH.oXH.o.o $.lXD !Xg.sXD t t.z.z [ [.qXG.1 ' ' ' + ' + ' + ' ' /.zXG [XG.q >.z.8 t t ZXg ZXgXgXg.OX1X1 ~X1 DX1.r.RXH.pXgXg.s Z.8 t.z.z > [ [ [ [XG / / / / / / / / / = / / = / = /.1 / = t > > > >.8 t ZXgXg !.Z ! ! ^.p , , , ,X-.MXpXt.8.Z ]X3XHX3XH.oXHXHXH 5.+XeXe ,X* ,X-X*X*X-XpXtX>.l !.r GXF @ Y Y 5 Y.l $ Y YXHXy i iXiX-X*X*.{Xp.XXp o o.X G.r ] $ 2 ^ $ {.oXHXHXgXH.oXHXHX3 B ,XH.oXH.oXH BXH ,XH.oXHXaXH.oXHXH.oXHXH.o.oXH.o 2XHXH.oXHXHXHXHXHXHXHXHXH.oXHXHXHXHXHXH.oXHXHXaXH.e.f.f.f.f.f.fXq.I.,.Y |XZ.I.I b L.I bXs bX9 bXs bXs.P bXk b.)XZXZ.I L 0XC v.0 bXsXkXm._XkXZ.)Xs bXZ._ L.)XZ.*X@._._._Xm bXZXAXZ.0X@X<.a f.a 0XZ.I b b.0._.) L.) L._._.,._ d F., b.I.!.,XZ.,.*.b F v d.<Xm L._XAX@ L.y bXk.h.b f._.t.t sXm.,XZ.I.! s.bXAXA.I b.I bXs.IXZX@XZXCX@._XZ LXZ.).t._.).I b.I._.0.0Xs.PXZ L bXZ.)Xs b bXZ b.I b.IXZXZX9.IXZ b.I L.IXsX9X9 b.IXs.I.,XZ.!XZ.!Xs.IXZ b bXs |.IXZ bX9.0 L.!XZXm.,.!.I.I.PXs bX9 b.IXZ. .I bX9X9XsXsX9X9X9.qX9 b L.0.}.} v. XZXZXZ._.,.I.IXs b.P.I.PX9.! b.I.I.,.Y |XZ.I.I b L.I bXs bX9 bXs bXs.P bXk b.)XZXZ.I L 0XC v.0 bXsXkXm._XkXZ.)Xs bXZ._ L.)XZ.*X@._._._Xm bXZXAXZ.0X@X<.a f.a 0XZ.I b b.0._.) L.) L._._.,._ d F., b.I.!.,XZ.,.*.b F v d.<Xm L._XAX@ L.y bXk.h.b f.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.7X X9X Xs b b.} F.}XaXaXa.oXH.o.oXHXa.oXa.o.o.o.oXH.lXDXgXg.w [ [.q [.q [ [XV.1 = ' + ' + ' + ' + ' ' + '.z.qXGXG [.q.q.q.q.q.q.q [ [.s.Z.OX1 ~X1X1 e < GX3.CXg.z.q [.q p.q [ [ [ [XV.qXx = / / / / / / / / / /.4 / = =.4 / = / / =.8 > > > > > > >.z.8.p ].OXMXt ,X- , ,X* -XxXt.l.Z.w.o.o.o.o.o.oXH 5XH.+XeXeX-X-X-X*X-X*X-XxXxX5.s.r.- Y Y 5 *XH 5 h.Z $.V Y.oX3XiXi.+.{ :.{ : -.{XpXp o o o o G.r X r.' n R Y.o.'XH ,XHXHXD 5XHXHXH.oXHXH.o _XHXHXH.oXHXHXH.oXH.oXHXH.oXH.oXHXH 2 ,XHXH.oXHXHXHXHXHXHXHXHXHXHXaXHXHXHXHXHXHXHXaXH.f.f.f.f.f.fXSXZXZ.,.!.I bXZ.!XZ.I.I b.P.PX9 b.PXkXs L LXs b b.).I bXZ 0XC.<.IX9Xs LXZ.) bXZ.I._XA.) b.I L dXA bXCXCX@X@.t.< g g.b gX@ fX@XA.) b b bXZ LXZXZ. .)XA._.tXZ v F.IXZXZ.I.I.!XZ.a f.a.<._.a.<XZXZXZXA L.)XZ LXAX$.}XN 9.t.0XZ bXZXZ._.} fXZXZ bXsXsXs b.PXZ.t.) | 0._._.)XmXA.0._XZ.IXsXZ.,.!.Y.) b.)XZ.).) bXsX9.I.I.I.I.I.I.I.I.I bXsX9Xs b.IXsX9X9X9X9XsXs.PXZX+Xm.,XZ.,.).I.I.I.,.)XZXZ bXm._XA._., b bX9X9X9.IXZ.P.).I b b.IXs bXsX9XsXs bX X9X Xs b b.} F.}XAXAXA.IXZ.IXsX9.!X9Xs.P b.I.  LXAXZXZ.,.!.I bXZ.!XZ.I.I b.P.PX9 b.PXkXs L LXs b b.).I bXZ 0XC.<.IX9Xs LXZ.) bXZ.I._XA.) b.I L dXA bXCXCX@X@.t.< g g.b gX@ fX@XA.) b b bXZ LXZXZ. .)XA._.tXZ v F.IXZXZ.I.I.!XZ.a f.a.<._.a.<XZXZXZXA L.)XZ LXAX$.}.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T oX9X X9 bXkXk.< F FXHXa.oXa.oXH.oXH.oXa.o.o A.o.oXH $.lXgXg [ > [ [.q.qXG.1.4 ' / + ' ' ' ' / ' ' ' + ' ' ' = WXGXGXV.q >.q [.q.qXG.q.Z.Z ~X1 D D e D u {X3XD.Z [.q [ [ [ [XGXGXx.1.1 / / / / / / / / / = / = = / =.4 / = = =.4.1 = =.1.q > > > t.8 >.8 p.l ^XM o , , ,.dX*XpXxX>.l.Z.XXH.o.o.o.o.o.o *XH.+Xe.;X-X-X-X-X*X-.{XpXtX5.X 3 : 5 5XH ,X- o pX;.r oXF ,XyXeXe ,X-.{X*.{.{.{.{ - -Xp o o o o G h.R r R n $ BXHXH.oXH B ,XDXH.oXa.oXHXH B ,XHXHXaXH.o BXHXHXaXHXHXH.oXHXHXH BXH.oXH 2XHXH.o.oXa.oXHXHXH.oXHXaXH 2XHXHXHXaXH 5.f.f.f.f.f.fX9.,.P.P.PXZ.I.,.,.PXs.I.IX9X9X Xs.!X9 b bXsXk.I z.0Xs b.IXZ.,XCXA.IXs bXs.I.I.IXZX@ L b.P b L.<.< L., 0X@X@X<X@Xl.=X@X@XAX@.*XAXZ.I.IXZ b LXA._XZ._.0Xm.0XZ.,.0XAXZXZ.IX9X9.b FX@X@._._X@ g._.)XA.  b bX@X9 L 4.=.t vXZXm L.aXZXZ fXCXZ.!.IXZ.I.IXs.PXsXZ.t._.,.k.,._XZ._.0 bXZ.0.PXZ.P.IXZ.,XA.0._._XZXZ b.IXs L.I bXZ b b.IXZ L.I bXs L.IXs.P.P.P bXsX9XZ L.)Xs.I LXZ.Y.P.).!.).) bXAXAX@XZ.<._.,.!Xs.PX9Xs.IXZ.).P b b.I b.).I.I b.P.I.IXsX9X X9 bXkXk.< F F.*.) L.I.IXs.I.I.I b bXk.I.IXZXZXZ.,.P.P.PXZ.I.,.,.PXs.I.IX9X9X Xs.!X9 b bXsXk.I z.0Xs b.IXZ.,XCXA.IXs bXs.I.I.IXZX@ L b.P b L.<.< L., 0X@X@X<X@Xl.=X@X@XAX@.*XAXZ.I.IXZ b LXA._XZ._.0Xm.0XZ.,.0XAXZXZ.IX9X9.b FX@X@._._X@ g._.)XA.  b bX@X9 L 4.=.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T 8.P bX9Xk b b.)XA MXaXa.oXa.o.oXa.o.oXa.o.oXH.o.oX3XDXDXg.l p W /.4 / ' ' ' / 'X* / ' + ' + ' ' ' ' ' ' ' + / ' + 'X* / ' /.1 >.q [ p.Z.ZX1X1 e e < ~ eXHX3XD Z [ [.1 = / / / / / / / / / / / / / / = / /.4 / = = = = = /.4 = = = = =.1 = =.1 = = W >.z > tXMXM : , ,X- ,.{Xz.XX5.s.O 3X3.o.o.o.o.o.o *.o.+.+ ,X-X-X*X-X-X*X-Xp.X o 5 5 5 5 , , 5 5Xt ]X; o *XH ,XH.+.;.;.M.{ 5.{.{.{.{.{ - -XpXp o o.X o G h.r r BX1.-XH.oXHXDXHXHXHXHXHXHXHX3 _.oXH.oXH.oXHXHXH.o.o.oXHXHXa.o.oXHX;XHXH.o.oXHXHXHXHXHXHXH.oXHXaXHXaXHXHXHXHXHXaXHXH.f.f.f.f.f.fX9 b.I.IXZ L.IXZ.I.!.I.PX9 bXs.PX9X9X9X9 zX9.P LXA.IXs b b.  LXZ F.nXZXk zX9XZX@X< b.I.IXk b bXZ 4._.,.tX@ g.b f.tX@.< gX<X@XZ.) b b.IXs bXZ._XA._X@.0XA._XZXA 0 LXAXZ.b f qXs._.Y.PXZXAXZ bXAXAX@XlXl v._Xs.IXsXm g.b bXZ b.)XZXZ b b b.I.!.,.,XZ.I.P bXs.YXZ.)XZ b.P.,.) LXZXZ.!.,.,XZ b.)XA.).I b b.)XZXZ L.)XZ.,.).) b.IXZXZXZ.).I b b.I.I b b b._.,.,.Y 0 |.,._._XA.,.I._.,XAXZ.<.b FXl f.< 0.!.!XZ.P b.IXsXZ.IXs.)XZXZ.) b bXZ bXs b.P.P.P bX9Xk b b.)XA M d._XZ b.P.I.I.I.IX9 b b b b b.).) b.I.IXZ L.IXZ.I.!.I.PX9 bXs.PX9X9X9X9 zX9.P LXA.IXs b b.  LXZ F.nXZXk zX9XZX@X< b.I.IXk b bXZ 4._.,.tX@ g.b f.tX@.< gX<X@XZ.) b b.IXs bXZ._XA._X@.0XA._XZXA 0 LXAXZ.b f qXs._.Y.PXZXAXZ bXAXAX@XlXl v._Xs.IXsXm.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T 8X9.I.I b L L.IXZ._XaXHXa.oXH.o.oXa.oXaXH.o.o.o.oXHXDXD _ ] p = / ' ' ' / ' ' ' / ' ' / ' ' ' ' + ' + ' + / ' ' / ' ' 'X*XmXG [X>.q >XJ.OX1X1X1 DX1 ~.C MX3XgXD [XG / /Xm ' / / / / / / / / / / / = / = = / = = = = = = = = = =.1 =.1 = =.1 =.1Xn W.8 >.8.sXM #X- , , ,.d.{XpX. p !.OXHXH.o.o.o.o.o.o YXHX3.;X3X- ,X-X-X*X-.{.{Xp - 5X- 5 ,X- ,X-XpX> p hXHXHXHX3 ,X-.;X-.{.{.{ 5.{.{.{.{.{.{X- -XpXpXp o.X o G.r X $ UXH.oXH BXH ,XHX3.oXHXHXH BXHXH.oXHXHXa MXHXaXH.oXHXHXHXHXH.oXH 2XHXHXHXHXaXH.oXHXHXHXHXHXHXHXHXHXHXHXaXHXaXHXH.f.f.f.f.f.fXq.P.IXZXZ.I.)XZ b b.I.PX9.PX9 bX9 b.q bX X9XsXZ., LX9.PXsXs L bX2.n._.I bX9X@XA b.I b b bXkXA LXA v bXA._XAXZ._.0XA.tX@.*X@XA L b.!.I L.I.)._._ 0.0.0XZXZ._XZ.0X+.*.b s.,Xs.PXZXZ.I. XA._XZ b.*.b.bX@ b L bXkXZXZXA.b bXAXZXZ.,XZ.I.IXZXZXZ.I.I.! bXs b.P |.kXZ.I.I.P &.,XZX+XA.0Xs.!.)XZ bXZXmXZ.I.I b.)XZ.).I.).0XZXZ.!.)XZ b b b.,., b. XA._._._ |.P.I.P.I.!.PXZ._._ d.tXA.*.tX@ v.<.W._XZ & |.Y bXZ b.P.IX9XZ.P bXZ.).0Xs b b.) b b.I.I.PX9.I.I b L L.IXZ._X2.aXz b.I b.I bXs bXk.IXs.).I.I.I.P.IXZXZ.I.)XZ b b.I.PX9.PX9 bX9 b.q bX X9XsXZ., LX9.PXsXs L bX2.n._.I bX9X@XA b.I b b bXkXA LXA v bXA._XAXZ._.0XA.tX@.*X@XA L b.!.I L.I.)._._ 0.0.0XZXZ._XZ.0X+.*.b s.,Xs.PXZXZ.I. XA._XZ b.*.b.bX@ b L bXkXZXZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.7.IXsXsXZ.,.,.!.I LXHXaXa.o.o.o.o.oXa.o.oXHXDXH.oXHXDXD _.z p.q.qXGXGXGXG.qXGXGXGXGXGXGXGXGXGXGXGXGXGXGXGXGXGXG WXGXG WXGXG [XG [ [ t.Z.O ~ ~X1X1 $XFXH.o.C.Z.z.q p.gXG.qXGXGXGXG.qXGXG.qXG.q.q.q.q.qXG.q.q.q.q.q [.q [.q [.q >.q [.q [.q >.q [ [ > > t.8.sXM ] , ,X- ,X-.MXnX. >.Z.lX3X3XH.o.o.o.o.o * 5X3.; ,X*X-X*X-X-X*X-X-.{.{X- 5X- , 5X- -.XXt ] 5 , , ,X3.;.;.;X-X-.{.{.{.{.{.{.{.{ :.{.{.{ - -XpXp o o.X G.r.R B.eXH , B RXHXHXHXHX3 B ,.oXHXHXH.o.o BXH.o 5XaXH.oXHXHXaXHXHXgXHXH B.oXHXaXHXHXaXHXHXHXaXHXH.o 2XHXHXHXaXHXH.f.f.f.f.f.f J.I.!.).!.IXZXZ.I.IXZXsXsXs bXsXsX9X XkXsXsX9._.IXZ b b b.I.I.I._.k &XZ bXZ 4 L b bXs b.I bXZ.).h.b b L.).0Xs bXm.*.*XZX@.0.I.) LXZ. .0 LXZXZ.t.aXZ._XZ L._XZ bX<Xl.b b.I b.!.IXZXZ.IXZ bXZ L.0X<.b._XA.0 L LXm.) L g.)XZ.,.,XZ.I bXsXZ.,.,XZ b.IXs.).!.IXw.# &XsX9 ).I.! |.!XZXA LXZ b 0XZXZ.,XZXs b.I.I bXZ.) LXZXZ.I b.).I.I.!XZXZ b.)XZ.< |Xs.PX XsXs.P.PXs.!.IXZ.Y 0.Y.<.]._.Y &XZ.Y.I.I b.P.!.I.I., b.I.P.I.!X9.I.I.!.!.).IXZ.)Xs.I.I b.IXsXsXZ.,.,.!.I L.} F.<XZXA |.!.P bXZ.IXsX9 b.P.P b.I.!.).!.IXZXZ.I.IXZXsXsXs bXsXsX9X XkXsXsX9._.IXZ b b b.I.I.I._.k &XZ bXZ 4 L b bXs b.I bXZ.).h.b b L.).0Xs bXm.*.*XZX@.0.I.) LXZ. .0 LXZXZ.t.aXZ._XZ L._XZ bX<Xl.b b.I b.!.IXZXZ.IXZ bXZ L.0X<.b._XA.0 L LXm.).5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXr b b.)Xs.I 1 bXZXC.e.oXHXa.oXHXa.oXHXaXaXH.o.oXHX3XDXg _ ].p.8 p.z.z.z.z.z.z.p.z.z p.p.z.z.w >.w.z.p.p.p [.z [.w.p p p > [.p p p pXg ! ^X1X1.pXD.o.oX3.C : !.8.p.w > p p >.p.z.z.z >.z.z.z.z.z.z.z.8.z.8 >.8.8 >.8.8.8.8.z t.z t.8.8.8.8 t.8.8.8 t.8.8.8.O ^ h , , , ,X-.MXxXt Z.Z.wXa ,XH.o.o.o.o.o 5 5X3 , ,X-X*X-X$X-X*X-X*X-X-X-X-X-.{X-.{.{.XXt oXy.#.+.; , , 5X*X*.{.{.{X- 5.{.{.{.{.{ -X- -.{.{ -XpXp o o.X G.rX; 2XHXH.o 2X-XHX3XHX;.o.oXHXH.o.oXHXHXHXHXa.oXHXHXa.oXHXHXHXH BXH ,XHXHXHXHXaXH.oXHXHXHXH.oXHXHXHXHXaXHXHXHXH.f.f.f.f.f.f JXZXZ.,.,XZ LXZ b.).! bXs.IX9XsX  z b LXk L.).I b bXs.)XZ.IXs b b.I b s 4.)XkXk.h LXZXAXZXz.b s.=X@., bXzXk b LXZX@X@.<X@.*XZX@ s LXk b.)XAX@XZXZ.0.)XAX<.b C g.,XZXZ b b.I b.IXZ.t._XZ.!.I LXA b bXA.h L.,XZXZ.hXA.=.I.IXZ., L._.P.P.!.< 0 :.YXZ.) v s.Y 0XZ.) b b.I.! 0._., | 8X7XZXZXZXA.IXZ.I.I.IXZ.!.).I.IXZ.IXZ.!.I.PXs.IXsXs.IXs |XsXs.PXsX XZ.PX9.PX9 b bXZ.PXZ bXs b.I.P.) b.IXZ b.IXZXsXsXs.I.I.I.PXsXs.P.IXsXsXsXZXZ.)XZ.0XZ b.I.) b b.)Xs.I 1 bXZXC F.G.}.I._._.I.I.P.I b.I.PXs.IXZ bXZXZ.,.,XZ LXZ b.).! bXs.IX9XsX  z b LXk L.).I b bXs.)XZ.IXs b b.I b s 4.)XkXk.h LXZXAXZXz.b s.=X@., bXzXk b LXZX@X@.<X@.*XZX@ s LXk b.)XAX@XZXZ.0.)XAX<.b C g.,XZXZ b b.I b.IXZ.t._XZ.!.I LXA b bXA.h L.,XZXZ.h.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXr LXZ.I b.I., b.,.nXaXHXa.oXH.oXH.o.o.o.o.oXHXH.oXHXD o ^.O V V V ~.O V V V V V V V V V V.O V V V V V V V V V V V V V V V V.O.O.O.O.Z _ ~ G :X3.o.C.R.C.o o _ V V V V V V V V V V V V V V.O.O V V V V V V V V V.O V V V V V V V V V V.O V V V V.O.O.O.O.O.OXMXp , ,X-X-X$.MXxXV.s.Z.-.o.o.o.o.oXH.o.o * 5 , , ,X-X-X*X-X*X-X*X-.{X*X*X*X-X-.{X*.{Xx h.+Xi.+.;X- 5X-.{.{.{X*X$X-.M.{.{ 5.{ :X*.{ -.{.{ 5.{.{ -XpXp o.X.X.RX; $XHXHX3 B B _ R.o.oXHXH.oXHXH.o.oXH.oXHXH.o.oXHXaXHXHXH ,XH 2XH.oXHXH.o 5XaXHXaXH.oXHXHXH.oXH.oXHXHXaXHXH.f.f.f.f.f.fX9XA.I |.,.I.I.,.!.I.!Xs.IXs bX9XsX9XZ.I.<X@XA b b bXk b.).I.) bXZ.,._XA L LXs z.)XAXmX+ LX@ sX@.*X@.I L._XZXZXZ b bXA.aX@.*._.*.b bXsXkXm.* fXZ._XA.b.b.b._.0XZ.)XZ.!XZ b bXAXm._._.0XZXZXZXZ._X+ bXZ g.t._.).)Xl.aX@XZ b b._XZXAXs.P.PXZ 0.,XC 0XZXCXC.IXZXZXs b.IXZ.I.P._ bXZ |._._XZXZXZXA.)., b.I b.I.I.I.!.IXZXZ.IXsXs b.I.IXsX X X9XsX9.I b.I.,.!Xs.I.!Xs.,XsX9.I.I.I b.IX9XZXZXZ., LXs.!X9Xs.!.P.!.!X9.IX9X9 bX9X9Xs.IXZ bXA._XZ L LXZ LXZ.I b.I., b.,.nXe.G IXZXZ.I.IXs.IXsX9Xs b.I b.).)XA.I |.,.I.I.,.!.I.!Xs.IXs bX9XsX9XZ.I.<X@XA b b bXk b.).I.) bXZ.,._XA L LXs z.)XAXmX+ LX@ sX@.*X@.I L._XZXZXZ b bXA.aX@.*._.*.b bXsXkXm.* fXZ._XA.b.b.b._.0XZ.)XZ.!XZ b bXAXm._._.0XZXZXZXZ._X+ bXZ g.t._.).)Xl.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXrXZ bXZ b.IXZ.YXC.GXaXaXaXa.oXH.o.o.oXaXaXH $.oXD $ $XD 3XF 3 3 3 3.4XD 3Xg 3XF 3 3 3 { 3 3 3 3 3 { 3XD {.4 3XD 3 { 3 3.4 { 3 3 3XD 3 3 :.o.o.o.o.o.o.o.oXH 3 $ 3 3.4 { 3 { 3.4 { 3 3 { 3 3XD 3 3.lXB 3 - 3 3.4 { 3 3 3.4XD 3.4 - 3 {.4 3 3 3 o 3 oXF - : 5X*XH , ,X-.d.{XnXx p.s.O 5.o.oXH.o.o.o.oXH.o 3 , , , ,X*X-X*X-X*X-X*X*X*X-X*.{.{X$X$X$.MX- iXi.;X-X-.{.{.{.{X$X$XO.M.M.{.{.{ :.{.{X*.{ -.{.{.{ -.{.{ -Xp o.XX5.l ^ GXH BXH.oXHXHXHXH.o 5.oXH.oXHXH BXH.oXHXHXHXHXHXH.oXH.oXH 2XH BXHXHXHXaXaXaXHXaXHXHXaXHXH _XHXHXHXHXHXH.f.f.f.f.f.fX9., b.PXs.Y.!.I.!.I.P.P b.I b.)X9 zXAX9.a.bXlXA L.I b b.I.I bXZXZX@ 4 bXA LX9 zX.XZXA.h.I bX9.< 4 g LXA.<._XZ L b bXZX@X@X@XA._X@.) b. .b.a.b LXAX@.}XN._XZXZ.0.!XZ.,.)XZ.)XA.0XAXZXZ.!XZXZ bXZXZ.). ._XA._XAXZ.bX< g., bXZXZ._Xm.I.IXs.I.!.I.,._.&.I.I.I.I.I bXs.I b.IXs.P.I bXs.I.,.I.!XZ.,Xm.<.I b.I.I bXsXZ.I b.I.I b b bXZ b.PX9X9X9.PX9.I.I.I b.I.I b.I b.I.I b | b.I.I.!.!XZ.,.)XZ.,XZXZ.I.P.I b.!.0 b b zXs b bX9.P b.I.I.0._XA.) b.)XZ bXZ b.IXZ.YXC.G.n F I.aXZ L b b.IX9 b b.I.I.)XZXZ., b.PXs.Y.!.I.!.I.P.P b.I b.)X9 zXAX9.a.bXlXA L.I b b.I.I bXZXZX@ 4 bXA LX9 zX.XZXA.h.I bX9.< 4 g LXA.<._XZ L b bXZX@X@X@XA._X@.) b. .b.a.b LXAX@.}XN._XZXZ.0.!XZ.,.)XZ.)XA.0XAXZXZ.!XZXZ bXZXZ.). ._XA._XAXZ.b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.7 b.I b b b | 0 0 :XHXaXHXH.oXH.oXHXa.oXH.o.o $.o $X3XH $.o.oXa.o.oXaXDXa.o.o.o.oXa.o.o.o.oXa.o.o.o.o.o.o.o.o.C.o.o.o.o.o.o.o.o.o.RX3.o.o.o.o.oX3.o.oX3.o.o.o.o.oXy.o.oX3.o.oX3.o.oX3.o.o.o.o.oX3.o.RX3XH.oX3.o.o.o.o.o.oX3.oX3.o.o.o.#.o.o.o.o.o * 5.oXy.+.; , , , ,.d.{.xXt >.Z.p.o.oX3XHXHX3.o.o.o ,XFXH , ,X-X-X*X$X-.{X*X-X*.{X*X$X$X$X$.MXn.; i i.+ , 5.{.{.{X$X$XO.xX.Xx.M :.{.{.{.{.{.{.{.{.{ -.{.{ -.{.{.MXpXx h.r ! D :XHX3XH 5.oXH.oXa.oXaXHXHXH.oXaXH.oXH.o 5.o.o.oXHXHXHXHXH _.oXHXH.oXHXHXHXHXHXHXHXHXHXaXHXaXHXaXHXa.e.f.f.f.f.f.fX9.I |XZXZ.) b bXsX9X9X9.PXsX X9X9 LXAXZ.IX9X9.I.!XZ._ L b LXZ.)X@.).I LXZ.<XAXZX9 z bXk.I b.) LXA gXZXA.)XZXAXZ.I bXs 4X@.*X<X@.=.b.b f fXl.b.a C._XA._X@.,.PXs b._.,.I.I bX@X@.<XZ.,.!._XZXZXZ. XAXZXZ.0 b.I._XA 4X@.!XZXZ b.*._.I.IXZ )X9.IXs.I.I.P.P bXsXZ.IXs b.I.PX9XsXZXZ.PXs.P.)XZ.* 0 b b.I.I.!XZ b.I bXk. XZ b bXZ.I.!.,.PXsX9X9XsX9 b.I.IXsX .P.P.I.P.IXZ.IXZXZXs.,.,XZXZ L.!.I bXZ.I.I.IX X9XsXsXZ.I b.PX9XsX9X9X9X XsXs b bX9 b b b.I b b b | 0 0 :.k.n.k.<.<XA d.}.] bXZ.) b.I b.).).I |XZXZ.) b bXsX9X9X9.PXsX X9X9 LXAXZ.IX9X9.I.!XZ._ L b LXZ.)X@.).I LXZ.<XAXZX9 z bXk.I b.) LXA gXZXA.)XZXAXZ.I bXs 4X@.*X<X@.=.b.b f fXl.b.a C._XA._X@.,.PXs b._.,.I.I bX@X@.<XZ.,.!._XZXZXZ. XAXZXZ.0 b.I._XA.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX4XsX9 bXs.P.I.Y.I.!XaXaXa.o 5Xa.o.e.oXa.oXD.o.oXHX3.oXH.oXaXDXHXa.o.oXDXa.oXa.o.o.oXa.oXa.o.o.o.o.o.o.o.o.o.o.lX3XH.o.o.o.oXa.o.oX3 $X3.o.o.oXy.o.o.o.o.o.o.o.o.o.o.o.oX3.o.oX3.oX3.o.o.oX3X3.oX3.l.C.l.C.o.oX3.o.o.o.o.o.o.o.o.o.o.o.o.#.o.o.o.o Y.oX3.+.+ , ,X-.d ,X-.MXxXV.s.Z :.o.o.o.oXH.o.o.oXHXH , o - 5.{.{.M.M.M.MXz -.MXz.x.xX.X.X.Xe i iXe ,X-X-.{.{X*.MX.XVXV Z Z.8XtXpXpXp.M.{ -.{.{.{.{.{.{.{.{.M -.M -.{XtX5.pX; ~ ,.oXHX3.oXHXHXH.oXHXH 5.oXH.o.o 5.o.o.oXH.o.oXH.oXHXHXHXH BXH , ! 5.Z.Z ! !X; BXH.oXHXHXHXHXH.oXHXH.f.f.f.f.f.f J b.,.,XZ.I.I.IXs.PXsX9 b.IXsX9XsXZ 4X@ zX X9X9 bX@.<.0.I b.)XZXA b.I b b L._XZ b.y b bXk L._XZ.hX@XZ.0. .0XZXZ.I b b.t.bX<.b.b.bX@._.< LX@X@XZ b.)XA.*X@XZX9X .P b.IXZXZXZXAX@.a._.Y.0.!XZXZ L.0XAXZXZ.  b b LXZXA._XZ.)XZXs.,.< L LXZ.I._XA.IXZ.!.P b bXs.IXZ.I bXs bX9 bXZXZX9.IX9 b._.Y.IXZ bXs.I.I.IXs.IXsX9Xs.P.I.,XZ b.!.I.PXsXsX9Xs b.P.P.IXsX9 bXs bXs.IXZ.)XZ.!.I.IXZXZ.Y.,.!.I.I.! b b.I b b b b.,.!X9XsX9 bXsXkXsX9XsX9X9X9Xs.).IXsX9 bXs.P.I.Y.I.!.) & &XC.aX<.,XZXAXZXAXZ.I bXsXs b b.,.,XZ.I.I.IXs.PXsX9 b.IXsX9XsXZ 4X@ zX X9X9 bX@.<.0.I b.)XZXA b.I b b L._XZ b.y b bXk L._XZ.hX@XZ.0. .0XZXZ.I b b.t.bX<.b.b.bX@._.< LX@X@XZ b.)XA.*X@XZX9X .P b.IXZXZXZXAX@.a._.Y.0.!XZXZ L.0XAXZXZ.  b b LXZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.7.IX9X X9Xs.P L b.I 5XaXHXa.oXHXH.oXaXHXH RXHXH.o.oXH.o.o.oXD.oXHXHXDXH.oXH.o.o.o.o.o.o.o.o.o.o.o.o.o.o.o.oX3 $.o ,.o.o.o.o.o.o.o ,.CX3XHX3.oXH.o.o.#.o.oX3.o.o.o.o M.oXa M.o.o.oX3.o.o.o.oXHX3XHX3.C $.lX3X3XH.o.o.o.o.oX3XH.o.o.o.o.oX3XHX3XHXH 5XHX3.+.+.dX- , ,X-XO.MXt >Xg.p ,.oXH.o.oXH.oXH.o.o.oXa.-.XXBXp -XpXpXpXxXpXxXxXxX.XtX> pX5 i i i , 5.{.{X*.{.MXxXV > Z.s.g : hXtXxXpXpXp -.M.M.{.{.{.{ -.{ -.{.{.{.{.X h p.l ^ 3.o.o 5XHXH.o.oXH.o.oXaXaXHXHXH.oXHXH.oXHXHXHXH.oXHX3XH.o _XHXH BXHXHXHXHXH.oXHXH.oXHXHXHXH.oXHXH :.f.f.f.f.f.fXqXk.I.I.I.IXs bXs.I.I.I b.IX9X9XsXZ bXu R l $.$ bX@XA L L.!XZX@ L b b b.) b 4.)XsXZ.) b LXA.)XAXA.*XZ.) LXZXZ b.)XZ L.b f.b.Y J.m.$XZ.L z.* s.)XZXAXAX@.0.!XZ.!.P.IXs.,XZXZXAXm.<.I.I.)XZ b b.IXZXZ.I bX9./ k.!.)XZ.) b bXZ.IXZ.t./ 6 k.$XCXZ b.IXZ.!.I.P b.I._Xs bXZ.P.Y.I.IXZ.RXZ b b.,X .$.$X Xk L.IXs bXS l ;XSXs b.I.,.I.$.$.B.PX X Xs.P.P bXs b.I.! b.I bX .L.$Xh.I.)XZ.!.!.).w.$.u b.I bX9.!Xk L.$.I.I.) bX9 J.$.$.I.PX9 bXs bX9 ; $ % lX9X X9Xs.P L b.IX9 b., s.<XlXAXA.).$Xh.$Xu.L.IXs.IXk.I.I.I.IXs bXs.I.I.L.m.IX9X9XsXZ.) L.qX9Xs b bX@XA L L.!XZX@ L b b b.$Xu.5.$ $XZ.).BXu.$.$XAXA.*XZ.) LXZXZ b.).u lXu.Y.b.I.bX<XA._._ L.* s.)XZXAXAX@.0.!XZ h.m.IXs.,XZXZXA.X O.m.m.)XZ b b.IXZXZ.I bX9XZXZ.!.).5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.uX9.qX X%Xs |X Xs b.e RXaXa RXa.o BXa.o RXD R.oXH R.oXa R.o R $.o.oXDX3.o $.o $.oXHXD.o.o $.o.o.CXa.o.C.o.oXD $ ,.CX3.CXa.o.C.o.o.C.lXH.l.oXH.R.o.o.C.o.R.o.o.CX3XH.R.o.o.C.oXH.C.o.o.o.C.o.RX3 ,.l.l.C.lXH ,.R.o.o.CXH.o $.o.o G G $Xa.o $X3XH G 5.oX3.+.; , ,X-.d ,X*.xXG Z.Z o $.oXH $.o.oXDXH.oXD.o.o.o oX5.XXt.XXxXtXtXtXtX> p p t.s GX- i i.;X-X*.{X*X*X*XnXGXV.s.sXB.oXDXH hX5XtXxXpXp - -.M -.{.{.{.{.M.{ -.{ -XpXt p.l.O _XaXH BXHXH R 5.o BXH.o BXH BXaXH B.oXH BXa.o _XaXH BXH , _.o 2XHXH BXHX3 2XHXH 2XH.o BXH.o }XH 5XH.f.f.f.f.f.fX9.I LXZ.Y.,XZXZ.).I b.!.IXsXsXs.I bX& k    .%.:.~X, lXZXZ 4.)X@.)XZXA.,X9 b._X<XAXkXzXA.*._.).hXZ.).I.! L L b bXAXl f s.B.6  .m.^.C.S  XZ.)XsXAXAXAXmXAX@.I.^.PXs.I.IXZXm._.bX@._.I.EXZ._XZ b.,.I.  bXZXZ.6  XuXs b._Xs bXZXs b.!.L N  .(._.)Xs.!XZXs.I bXZXZ.!.IXs.I.P.$ %.%  .6 bXZ., R.S % l.A.V.I |.I l.S l kX, k ).I.m.A.i l.S.LXs.PX9XsX9.P.IXsX9Xs.IXZ b.:      .(XZ.P bXS N N.$.~./.).I./.m.~  .6 bXs.I b l.6.S  .%X X9X9.I b.I.RXf   %.qX X%Xs |X Xs b b.).P b.a gXN., L l.S  .~.i.%X, k.I LXZ.Y.,XZXZ.).I b.6   $XsXs.I b z.).qX9Xs b b b.IXZXZ 4.)X@.)XZXA., k.S  .~XuXkXz.7Xc  .:.hXZ.).I.! L L b b l.S k O.:  Xc f.}Xm.<.<X@.)XsXAXAXAXmXAX@.I.^.6  .$.IXZXm._.b b.(   uXZ._XZ b.,.I.  bXZXZ.! L LXs.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T o.qX X9 zXs.!X9X9 bXaXa.o.oXa.oXHXaXH.oXa.oXDXH.o.o.oXa.o RX3XH.oXH $.oXH.oXaXH.o.o.oXa.o.o.o.o.o.o.oXH.o.oXH.C.oXH.oXH.o.oXa.o.oX3XDX3Xa.oX3.o.o.o.o.o.o.oX3.o.o.o.o.o.o.o.oX3.o.o.oX3XH.oXH.o.o.oX3.l.lX3XHX3XH.o.oX3.o.o.o.o $ A.f.'.RXF *.o YXHX3.+.+XyX-.dX- ,X-.MXxXV.s ]XHXHXH.oXH.o.oXH.o.o.oXH.o.o.o 5.-.p.p ] p ] t t.s.s ] h G 5.oXiXe ,X*X*X*.{X* -XxX> p.s.lXHXH.oXHXH 5.g.pXtXxXnXp.M -.{.{.{.{.{ -.M.{ -.MXt p.8.O.g.oXHX3XHXHXHXHXH.o.oXHXaXHXHXH.oXHXH.oXaXHXH.o.oXHXHXHXH.o 2XHXHXHXHXHXHXH.oXHXa.oXa 5.o 5XHXaXa 5.f.f.f.f.f.fX9.I.)._.0.,.!.IXZXk.IXZ.I b.I b bXZ bXZ    .iXs l  .A.u.aXZ bXZ._XA.t L bXs LXm 4 LXAXAXA.6.BXAXA b b.I.! LXZ L.b.}.} O.S   E f.}X@.$.~.<.) bXZXZXZ._XA.0.!.P.!.P.!.IXZXA.<.aXCXCXZ |XZXZ.IXsXZ bXZ bXZXZ.:.6X& b L.< bXs.  LXZ.I.Y.(  .m._X@ g b.I L b.% b bXZ.IX XsXsXs.I.6   %XA._ k  .6.YXZ  .(.PXZ.!.S.6 b b.%X,X9 R  .6.IXZ  .(XZXs.PXsXZ.I.!.PXsX9XZ.) %.:.$.m    Xh.I b N  X&.I.6.(XZXZ.).I.6  .mXs b b.w lXZ.BX,  .iX9 bX9Xs.IXs.~  .RX X9 zXs.!X9X9 b L b.I bXA.0.< 0XZ.0.A  .:.).L    Xh.)._.0.,.!.IXZXk.I.:.6X&.I b bXZ bXZX X9XsXsXZ.IX9XZ.aXZ bXZ._XA.t L b u   u 4 LXAXA l.: bXAXA b b.I.! LXZ.|.S N.}XZ.) N E f.}X@.aXC.<.) bXZXZXZ._XA.0.!.P.i.6 h.IXZ.6.v.aXC.i   kXZXZ.IXsXZ bXZ bXZXZ.) b b b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.uX9X X X%.P.IXs b bXaXaXaXHXH.oXaXHXa.oXH.o.oXDXH.oXHXHXDXaXH.o.oX3 $XH.oXa.o.oXH.oXaXHXH.oXa.o.oXa.o.oXH.o.o $.o.o.o.o.o.o.o.oXH.o.l.o.o.o.o.o.o.o.o.o.o.o.oXH.o.o.o.o.o.o.o.o.o.o.oXa.o.o.o.oXH ,.o $.l.lX3XHX3.oXH.o.o.o * {.V X.R r A A.f r Y.#X3.+.+.;X- , ,X-.dXzX. t.Z.XXHX3 ,.o.o.o.o.o.oXHXH.o.o.oXHX3XH , 5 o 3 o - oXgXH ,XH Y 5X3.+.;X-.{.{X-.{.{.{XtXt >.Z.l ,XH.oXa.oXHXHX3.gX5Xt.XXp -.{X*X- -.{ -.{ -.{.{X>X>.8 _.wXHXHXHX3XHXH.o.oXHXH.o 'XH.oXHXH MXHXHXH.o.oXHXH.oXHXHXHXH BXHX3XHXH.o.oXHXHXH.oXHXH.oXH.oXHXHXHXH.f.f.f.f.f.fXq bXZ.,.IXs b.!.  b.! |.IXZ b.I bXZ.IXh    .R.IXu     OXA._.).I.*._XA L bX9XZXA.} b LXA.(.6XA.)XZXZ.I.I.,.) LXA f.}.>.S  .:.a.b.)X@.<.:._XZXZXZXZ._XZ.).!.PXs.IXs.YXZ. X@ f.Y sX@Xs.)Xs b.IXZ.IXZ._XZXZ.).!X  L LXm f.IX .IXZ bXZ._.S  .u._ s.W gXz.I.(.6XZ.,.,XA.!X9X X9 J    .$._.,X,   k 0XS  Xf.I.P.$  .%Xs.P.6X,X9X,   } bXS  X,.,XZ.,.I.,XZXs.IX9X9XsXs.$.)XZXZX,  .:.!.m   NXA.!.S.%XZ.)XZ.u     J L.IXs.I b b b.%  .m.I.IXsXsX9XS  X,X9X X X%.P.IXs b bXZXAXZXZ.IXZ.<XC 0 J    .$XZ.|    XuXZ.,.IXs b.!.  b.! |.IXZ b.I bXZ.I |X X9Xs.I b b.!.0XA._.).I.*._XA L b.9    .} b L.7.6.7XA.)XZXZ.I.I.,.) L.$  .6 0XZXZ.mXS.b.)X@ d.<._XZXZXZXZ._XZ.).!.PXs.IXs.YXZ u N f.Y s.S   bXs b.IXZ.IXZ._XZXZ.).!X  L L.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T oX9.qX .qXs.IX9.P.IXHXHXHXa.oXaXHXaXHXa.o.o RXaXD RXD RXa.oXH.o.oXHXDXH.o R.oXa.oXH.o.o.o.o.o.o.o.oXa.C.o.o.oXD.o.oXa.o.o.oXH.o.o $.C.o.o.o.o.o.o.o.oXa.o.o.o.C.o.o.o.o.o.o.o.o.o.o.o.o.o.o.RXH.o.o.o ,.l.lX3.o.o.o.o.o.o.r 5 5 @.- G.V.V.V r XXH.o.+.+.+ ,X- , ,X$.d.x p.s.lXH , $.oXH.oXa.oXH.o.o.o.oXHX3XHXD.oXHXHX3XH ,XH.oXH $XD $ G 5X3.; ,X-X*.{.{X-.{.{XxX> p.Z.O.-.oXaXH.o.o ,XHXHXH G h.gXpX-X-X- , :.{.{.{.{.MXt p.8XJ.OXH.oXHXH.o.oXHXHXHXHXHXHXH RXH.oXHXHXH.oXHXH.o.oXH.o ,XH 2 ,XHXHXHXH.oXHXHXHXHXHXaXH 2XHXHXH.oXHXH.f.f.f.f.f.f OXs.P.IXZ.PXs.PXCX6 &.I.P.IX X9 bX9XZ.:  X,.PXs.:  .S b.)X&.i N O %.p.I z.R.: k.$.( l.~  .6 ; b O.(.:.m.mXl f.b._XZ.(  .S.B.b vXZ L 0 hXAXZ bXZ.m.:.:.L b.$.m.: l l.6.m L.L.m.:XZ.L.(.wXZX&.$.: k O.i.$ ;.: l.,XZXA.$.(.( %.$.$ bX9  .%XZ.$.( l.I.$.~  .6 k.IX9.Y |.PX9Xs k  X,.!XZ.I    X& b.$  X,Xs.I.L     }.$   %.P    .$Xs k  .~.I.! b.!.I b b.IXsX9.IXs.I.!.IXZX,  Xh.).~   kXZ.L    XAXA.Y l  .~.IXZ.0XZ bXZ.IXh.A.%XsX9XsX9 b b }   u.m.%.m.q.R.:.9.P.L uXh.I bXZXZXA.aX2 k    .!.I k  .A h.V.$.:.m.R.( 1 @ ;.: k.IX .$.: N.$.: ;.B ;.i.:._ l N l b.!., 0.,Xm.I L $     bXAXA.:Xu.*.< bXZXA.I b LXl f b    .(.0 L b.b v./Xu kX#XA k N./XZ.m NXh b.$ l.: l.$.~  .6 l.a J  .% b $ N l.I.)XZXZ.t._.,XZXZ.,XZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.uX9X X9.IXs.IXs b.I.eXa.oXHXHXa.o.o.oXHXaXa.oXH.oXa.o.o.oXa.o.oXH $.o.o.o.oXH.oXa.o.o.o.o.o.o.oXa.o.o.oXH.o.o $X3XH.o.o.o.o.o.o.o.o ,XD.o.o.o.o.o.o.o.o.o.o.o.oXH.o.o.o.o.o.o.o.o.o.o.o.o.o.oX3.o.o.o.o.l.lXHX3XH.o.o.oXH YXa.o 5 Y Y { o.- G YXyX3X=Xe.;X- , ,X-.d.dX. t.s.gXHXHX3XH.o.o.oXH.o.o.oXH.oXHXHXH.oXHXHX3XHXH.o.oXHX3XHXHXH 5 5.o , ,X-.{X*.{X*.{.{XxXtX5.l ^ # $ 3Xa.oXHXa { 3.- G.- 3 5XH ,X3X-.{ -.{.M -XpXt p Z.ZXBXHXHX3XHXH.oXH MXH.oXHXHXHXH ,XH.o.o.oXHXH.oXHXHXa.oXHXH.oXHXHXH ,XHXHXa.oXHXH.oXHXHXH.o.oXHXHXaXH.f.f.f.f.f.f J.I.IXZ |.P.IXs., &.PXsX9X  b.)XZXs.).%  .(X9.L.S  .mXZ.5.S.9.I.A  Xh.I./.%  .:.S   %.6   l.I.B.S k.).6 l.} s bXZ.|    .(Xs f fXZ. .< fXAXA.R.S %. .6.S.u.$.%  .:.:.S  .$ O.S  XZ.m  .:XZX&.%  .:Xf  .(.%   l._ L.(   $XS  .S.6 L.m  .:.: N  X,XZ./.6   k O.!Xs.0 bX9XsX9.9  .(Xs.!.I    .IXZ.9  .%.I.IXs.:    .6.RX9 b    X .P u  .6.!XZ |XZ.IXZ.).PX9Xs.P.IXZ.0XZ O  .6XZ O    .uXA k  .SXA.0XA.:  .(. .! b 0 L O.:.S.~Xs.IX9.IX9.I.I u  .6.9.A  Xh $.S  .B %  .:XZ._.).IXA.Y.k N  .%.$ k.S N.$.I.L.%  .9.S   %X .%  .mX .$.S.( h.S   $ J.(  .:.m.:  X, & &.,X9X9.,.I.).L    .$._.I.(.<Xl f b bXZ.)Xk.*.} s b N    .6.BXs f f./ u  .m.:.6  .:.: u  .6XZ.$.%   k.L.%   l.L.a.m  .:.: N  X,.! bXZ.t._._XZ._XA._ L.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T 8 b bXs.I b.IX9.PXsXHXaXHXaXaXaXaXH.oXa.o.o.oXH.o.oXH.oXa.o.oXH.o R.o.oXH.o.oXa.oXa.oXa.o.o.o.o.oXH.o.o.oXHX3 $XH.o.o.oXa.o.oXa.o.o.o $.o.o.o.o.o.o.o.o.o.o.o.o.oX3.o.o.o.o.o.o.o.o.o.o.o.o.o.o.oX3XH.oXH.l $ $.C $.o.o Y.o.oX=.o ,XH 5 5 Y Y 5X3.+XeXe , , ,X-X$.dXOXV.s.8XH ,X3XHX3XH.o.o.o.o.o.o.oX3XHXHX3XHX3XH.oXH.o.o.oXHXa ,XH , * 5.o , ,X-.{X*.{.{.{.{XpXtXt.pXD ^.c ^ n r r.V r.V.V.- Y *.oXy iXe.;.{.{.{.{.{XnX> p.s.Z { ,XHXH.oXH.oXH.oXH.oXH MXH.oXH.oXHXHXHXH.oXH.oXH.oXH.oXHXHXH 2 ! 2.o.oXaXH.oXH.oXHXH.oXH.oXaXHXHXH.f.f.f.f.f.f J.!.P.IXZ.I.P.I.,.I.IX X X9.I.!.I bXZ    .6.9 N.iX& bX&.S.~XZ.,  .AXZ.I L.%  .:.B.:.v  .S.b fXu   N 4Xu bXN.IXZXZ l    .m LX@ f.,XZ g.}XA.).S.~XZ.) N  .$ bX,   l.).6  .mXA n  .$.) N l.!.I.%  .:XZ.:.).%  .B.tXu  .%Xs h     LXZ.(  .(.R l   N.I.)  .S f.!.I b.I.IXs.I bX,   } LXZXA.~  XSXB.S   %.I bXS %.~  .SXh ).IX,   h O.A   %.P b.) b.,XZXZXsX9.PXs b.I b b.6.%.uXZ.:  .%.,XZ.(  .6.,XA._.~   kXZ.I._XZXZ.L %    .9XsX9XsXs b.I.A   ; b.6  .m b.(   kXs N ;.,XZ L L.).)XZ     N.:.%.% l b.!.P.%  .:.V.:.I.I.%  Xh.$.S.~.I b  .A.PX .9  .9.$ l  .6 |XZ., bXsXZ.I LXA    Xu L N.].a.b f L.).0 4.*.bXN.IXZ.u.6    .% LX@ f., N  .m J %  .6 O.m  .:XZ b.%  .L.)  Xf.]XA g.(  .(Xh l   NXZXZXA.aXZ.0Xm.,XA.t b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.7.I.I.!X9Xs., LXZXZXaXHXaXH.oXHXa.o.oXHXaXH R.oXHXHXH.oXH.oXH.o.o $.o.o.oXDXH.oXaXH.o.oXH.o.oXH.o.o.o $.o.oXHXDX3XH.o.o.o.o.o.o.o $.oXD.o.o.o.o.o.o.o.o.o.o.oXDX3.o.o.o.o.o.o.o.o.o.o.o.o.o.C.o.oXHX3XHX3 $X3XH.oXH $ Y.o.#X= i , , , , 5XH 5XHXiXiXi.+X-.dX-X$.dX$Xz Z.s.4.o.oXH $XH.o.o.o.o.oXH.o.o.o.o.oXH $XH.oXH ,XaXH.o.o.o.o.o.oXH Y , , ,X-.{X*X-.{.{.{.MXx.X hX5 $ $.' R r r X.V GXF @ Y 5.o i iXi ,.{.{ -.M.MXx [ p.sXgXgXH.oXH.oXH.o.oXH.oXHXH.o.o _.oXH.oXH.o.oXHXH.oXHXaXHXH ,Xg 2 ,XHXH 2XHXHXaXHXaXHXHXH _XHXHXHXHXaXH.f.f.f.f.f.f J.IXZ.PXs.PXs.P.,.,Xs.P.PX9 b.) LXZ ;    .)Xk bXk b |.(   kXZ.$  .( bXZ b  .S.$XZ.) l   %.aXl.7.S  XuXZ.IXZ.) b b.:    XuX9XZ., L.I LX@.h %  .:XZXA.~   O./  X,XZXZ.6  .5XZ.m   %XZ.(.|XZ.u  .SXv g.0XS  .~XZXAXc  .:.a E  .(.IXZ    .i.P.(   %XZ l  .(.& d.0XZ.b d.,XZX     XB.I.I.I.$ NX,.~  .S.u.I.$X, %.B.%   NXZXsXh NX,.%  .A O.$                XuXs.P.I b.:.%.uXZXZ u  .:XZXZ.~  .m.,XZ.B    .uXZXZ b.I.IX9.!.:  .6XsXs.PXsX9.R  .~ b.I.6   lXs.m  .:XZ u.B.PXZ.P b b.I l    X9XA./    Xu.I.u  .A ;Xs.P.,.I  X,.P.(   k L.$  .(.*.0X,  .: b.9   %XZXZXZ b b bXZ.) bX,  .:.mXc b d.aXlXA.=.b.aXZ.IXZ.) b b.I.(     %XZ., L.S   l.h.%  .mXZ.%   l._ b  X,XZ l  .: 4XZXZ    .:XZ.(  .m.,._.t g.0.IXZ._XZXA L.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.7 bX9Xs b bXC |.!.I.eXHXHXHXa.oXa.oXaXaXaXa.oXH.oXH.oXa.oXa.oXHXH $XHXHXHXaXaXa.o.oXH.o.o.o.o.oXa.oXH.oXH.oX3 $XH.oXa.oXa.oXa.oXH.oX3 $.o.o.o.o.o.oXa.o.o.o.o.o.o.o.o.#.o.o.o.o.o.o.o.o.o.o.o.o.o.o.oX3 $XH.CXH.oX3 5 5.oXyXi i ,X3 , , , , ,X-XiXiXi.; ,X-.d.d.dXOX..s.q 5.o.o.o.o.o.oXH.oXH.o.o.o.oXH.oXHXH.o.o.o.oXH.oXH.o.oXHXa.oXHXH Y 5 , ,X-X*.{.{X-.{.{X-Xx o.X.X h.r.V.r.V G G.-XF Y Y 5XH.+ i i.+X* -.M.M.M.{XtXV.l.s.pXHXH.oXHX3XHXH.oXH.o.oXHXa.o.oXHXH.oXHXH.oXH.oXH.o.oXHXHXHXgXHXHXH ,XHX; ,XHXa.oXHXHXHXHXHXHXaXHXHXa.f.f.f.f.f.fXqXZ.PXs.P.P.IXs.< &.!.I.^.q b.I zXA.:  .% b b b b.!XS    .7XA.(  .m b.) l  .% LXAXA.:   k g f fXh    .w b LXZXs.).:    .I bXsXZXZ b bXAXZ.~  .$XZ.B    .) k  .:XA.X  .S.7XZ.$  .6./.:XZXZ l  .6 4.*XZ.m  .:XZ g.B.S N./.~.6 b._ h  .SXS.P.S  ./._ %   k.).,.,XZ.<., L 0 %  .%.!.IX9.!.I.IX&.A  .m.,Xs.6X, b.I.L     bXZ.I b.$.S  .mXs h %.:.:.:.:.:.:.:.V.!X9 b.m.(.u.I./XZ.6  .lXZ.u    Xq.,.,XX  .%XZXZ.I b b.!.).I.$  .6X9XsX9.I.P.9  .i b.B  .A b b.r  .6.L.9.PX9Xs.IXsXZ b.:  .~X@ 4Xm    .:XZ k  .%.P.IXs.< ;  .:.V    XS z.(   l.)X&    .B.!.S  X>XAXAXZ.I.I b.) b.).6   N N b.IXZ g f f.}.}.PXs b L.$ h.) LXZ N  .6XsXZ.$  .SXA./  .~XZ./  .~XA.0 k  .:XA n   kXAXZ.$  .S.uXA.S  ./XZ.* 4.*XZ LXZXZXZ gXA.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T o.PX9X9.I.,.n.k.! bXa.oXa.oXaXHXH.oXH.oXHXHXH.oXH.oXaXH.oXHXH.o.o RX3XH.oXH.o.oXHXa.o.oXa.o.oXa.o.o.o.o.o.oXHXDX3XH.o.o.o.o.o.o.oXHXH.l.oXH.o.o.oXa.o.o.o.oXHXH MXa.o.o.o.o.o.o.o.o.o.o.o.oXHXHX3.o.oXD.o.oX3.oX3XH 5 * ,.#Xi i , ,.;X3 , , , ,Xi iXeX-.dX-.d.dX$.xXV Z {.o.oXaXHXH.oXH.oXH.oXH.oXH.o.o.o.oX3XHXHXH ,XH.oXH.oXHX3.o.o.oXH o 5 , ,X- 5X*.{.{.{X-.{ 5XpXx o o o.X.- o.- o Y Y : 5XH.oX3Xy.; ,.{.{.{.M.{ -XV p Z !.X.o.oXHXHXH.o.o.oXH.o.oXH.oXaXHXH.oXH.o.oXH MXH.oXH.oXHXH ! 5XH.oXaXHXH , 2XH '.oXa.oXHXHX3XHXHXaXHXH.f.f.f.f.f.fX9.I.I b.P.I.P.I d.,.,.IX9X Xs bX9.0.~  .9X9 bXs.,.,.$  .6XZ.u.S  .|., b.(  .m.h.*.0.~  X& L f.^ f %  .: bXZ.)XZX9.$    XuX9 bXAXZ b.$ L o     b b l  .( L.(  Xu._.m  .:XAXA._  .S.:./XZ._.9  .mXZ._._.(   l.BX@.u.( l.:.$._ g.a %  .:Xs R  .%.I.I.~   h.LXs.)XZXZ bXA | u  .9Xs.IX9XZXZ.I.%   uXsXZ b  .6.I.I.I  X, b.!.I.I.%  .(X9Xs.).,XZ b.I.!Xs.!.I bX9Xs R.:XZ.).I.:XZ N  ./.).m  .(.)XAXA N  .:.IXZ b.P.I b.).E l  .mX XsX9XsXs.~  .$Xs.m   %.I.,.n  .A.:.5Xs b b.PXsXZ L.%   uXZ.*.$     k.I.(   %.I.P.I d.9   l.m  .% b J.S  .BXs %   u.,Xh  .%XSXZXZXZ.) L., b b b.:     J.)Xs bXl.Y & f., b.I bXZ.:.$X9 b.I $  .6 bXA.:  .9 L }   % b %  .:.u L.(   l.u.~   z.BXA %  .:XA l  .%.I.BXAXZ._._.I b.)XAX@XZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T o b.I.IX9X9 b.kXZ b.eXHXHXH.oXaXaXHXaXa.o.o R.oXaXHXHXH.oXa.oXH $XHXH.o.o R.oXaXaXH.o.oXHXH.o.o.oXaXa $XH.o.oXDXH.o.oXaXH.o.oXH.oXDX3XD.o.o.o.o.o.o.oXH.oXHX3 $.o.o.o.o.o.o.o.o.o.o.o.o.o.oXD.oX3XH.o $X3XHXHXH.o.o YXHX3Xy.+.+ , ,X- , , ,X3 ,.+Xe ,X-X-.d.d.dXzXV Z.4.o.o.o.o.oXDXH.o.o.oXH.o.o.o.o.oXHXH.oXDX3.oXH.oXHX3XH.o.oXHXHXHX3 { Y ,X-X-X*X*.{X*X*.{.{.{.{XpXpXp o 3 - Y : Y : 5 5 5X- 5 ,.;X-.{.{.{.{.M.MXx p.l ! h.oXgXHXH MXHXH.oXH.o.oXaXH.oXH B MXH.oXH.oXH.oXHXaXH.oXHXH ! !XHXaXH.oXHXH !.oXaXaXHXH.o _XHXHXa 5.eXH.f.f.f.f.f.fX5.IXs.I.P.!XZ.Y.,.I bXs.P b bXZ 4X&    Xu bXZ.,.I bXu  .%.0 %.S.%.pXuXA.~  .BXAX@XZ  .S.$ OX@.9 g.u  .: bX9XsX9.I._.6   NXsXZX@./.6.B._ |.S  Xk bX,.%.uXZ.S  X+XZ.S.%._XZ.0.}.%   nX@XAXZ.~  .BX@.tX@.~   O R.0.(  .:.$.I b b b.%  XhXs.:  .9 n.B  .S.$ lX X9.I b.*._.B.S  .R.I b.,.Y b.~.S.m.I.I LXZ N.%Xs.I.L  .:.I 0.u.%.S.mXs.IXsXkXsXsXk.!X9 b.Y.,.P.!.m.A.6.6.%  .$ b.m  .,.0.~.~XS.!.,.u.S  Xu.)XZXs./.S.(.I.P N.%XZ bXsX9.PX   .AXs hX,.(.IX9X9 b.%  .:.I bXsXs b b.P.w    .mX9.b N  .%Xs.IXf  .V.!XZ.Y.,X,   $.(  .~XZXc.S.~ l l N   k.I.:  .:.:.0._XZXAXmXAXAXAXA.m   %.aXl.b.b...S  .XXZ b.I bX9 u.(.I._.I.m   }XZX@.%   J._.6   )Xk N   l.:XZ.~  .$ %  .S.$ l.0.6  .LXm %  .:.:. XAX@.tX@XA._X@ g.0X@.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.u.IX9X XsX X9.!., LXaXaXaXaXHXa.oXa.oXHXHXaXHXH.oXaXaXaXHXH.oXaXD.oXH.oXHXH.o.oXaXH.o.o.o.oXa.oXa.o.oXaXa.o.oXDXH MXa.o.o.o.o.o.o.oXH.oXD.o.o.o.oXa.o.oXH.o.o.o.o.o.o.o.o.o.o.o.o.o.oXa.o.o.o.oXH.o , $.oX3X3XH.o.o @ 5X3 ,.; , , , , , , , , , ,.;X-.dX$.dX$XzX. t.s ,.oXa.oXH.oXH.o.oXHXH MXH.o.oXH.oXH.oXHXHXHXH.oXHXH.o.oXH.oXHX3.oXH , o 5X-X-X*.{X*.{X*.{.{.{.{.{XpXp - - - - 5 5 5 5X-X-XH ,X-X-.{.{.{.M.M.MXpX. >.s ] 5XHXH.oXH.oXHXH MXH.oXH.oXHXH.o.oXHXHXHXH.o.oXH.oXH.oXHXH , 2 ,.oXaXaXHXH , 2XHXH.oXaXHXaXH.oXH.oXHXHXH.f.f.f.f.f.fX X9.IXZ._ |.I._ L b b b bXZ._X<.$.%     N.$ 0XZ.) L.u.%  .~ J.S   kXA [  .6 s._XZXS.S  .m._.$  .m kX,X&.I.I b bXZ._XB.(  .~.:.(.6./ LXz.< k.S l.(.6.|XZ O    .:.6 N.uXZ.)XA.a.6X,.uX@XZ.L  .%X@.a.a._.~  .:XAX@.$.S    .S %XZXS  .A.! b.m  X,.w./.S   k.,XsX .!XZ.a %.6     N }XsXS.:.6 %.B b.!XZXAXZ.$.%.9 l.%.:.!XS.:.6 %XB.)Xs.P.I.!.PXs.!.I )X9.P.!.! ;          X,.!XZ.! N %.(.6.VXZXA %.6     N }.P.IX&.~  .9.9.9XSXZXZ.PXsX9.$X,X, l.6.:X9X XsX X9.6.~.| b.I bX9Xs b l.~    .6.9.~ N.m.B.P.$  .%._ |.I._ LX,  .(.B.%  .~ O.A  .m b.S  .u.)Xc  .~.$XZXAXZ LXZXAXz 4.b O.~XZ.0XA.0._XZ.S   b.< b b.I.I.6.~.( O R.S.: bXZXZ  .S L m  .S & L N  .~.uXZ.~  .( b.S  .m.).7  .A.IXZ.m  .~.L.,X@.a.a._.tX@.aXAX@XN.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T 8.^XsXs.IXsX9.!.I.IXHXHXHXH.oXaXaXH.oXaXaXH.oXaXH.oXHXH.o.oXH.o RXH.oXH.o.oXH.o.o.oXa.oXH.o.o.o.o.oXa.oXHXH.oXDXH.oXa.oXaXH.oXH.o.o.o.o $.oXH.oXH.o.o.o.o.oXH.o.o.o.o.o.o.o.o.o.oXHXH.o.o.oXHX3XH.o.o $XHXHXHX3.oXH @ 5 , ,X3 , , , ,X- ,X- ,X-X- ,X-.d.d.dXzX. >.s.q.oXH.o.o.oXH.o.o.o.o.o.o.oXH.o.o.o.o.oX3XHXHX3XH.o.oXH.o.oXHX3XH.o.oXa { :X-X*X-X*.{X*.{X*.{X*.{.{.{.{.{ - - - 5 5X-.{ 5.{X-X- :.{ -.{.{.M.{.xX.XV.s.s -XH.oXH.oXH.o.oXH.oXHXH.o.oXH.oXHXH.oXH.o.oXH.oXHXH.o.oXa.oXH !XHXHXHXa.oXHXH BXHXHXHXaXHXa.oXHXHXHXHXHXH.f.f.f.f.f.fXq.P.I.I |.P.IXZXZXZXZ b.)._.a 4.y.3 bXA.,.,.I LXZ.).)XA.$XA._./.BXA.* f.b fXAXZ.)XZ.B.|XZXA.I.|.B.IXm L b b.I.IXZ.)Xs bXS ;Xu b._.  L bXz.,.vXu z.) L L.m   n.L.BXZ.)XZXZXZ.a.6Xu bXmX@Xm._XZ.b.} fX@.<XZXZ LXu.6.pXu.(    .5.).*XZ.P.!.I.$ L.Y.Y 1.v.Y.!.PX XZ._._.,X9XsX9X9X9XsX9.u._.I.I.I.I.IXZXZ.!.I O.$.u.).IXsXSXsXs.!XZ.I bXZXZXsXk.I.IX9XsX .I., b.I.,XZ.,.!.I.IXZ.,XZ O O bXZ._._.,.I.!.I.I b.)Xs.I.I.$XuXs.P.!._.)XZ.IXsXsX9.w l.P.^XsXs.IXsX9.6.$.IXZXZ.I bXk b b.,.).I.!XsXZXC.<.I.I.P.I.I |.P.IXZXZXZ./ b.)._ J 4.yX&X&XA.,.,.I LXZ.) OXAXZXA._XZXAXA.* f.b f.7./.)XZ b LXZXAXq zXA fXm L b b.L.I.u.$ $.B.I.P bX@._.  L bXz.,.< b L O L LXZ bX>._XA.u bXZXZXZ.a.I b bXm./Xm._XZ.b.} fX@.<.aXZ L 4X@.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.uXs.PX9X9X9Xs.,XZ bXaXaXaXaXHXaXH.oXH.oXHXa RXHXHXa.oXa.oXHXaXH R.o.o.oXH R.oXHXH.oXa.oXa.oXaXH.oXa.oXD.o.oXHXDX3XH.o.oXH.oXH.o.oXD.oXH $X3XH.o.o.oXa.oXH.o.oXD.o.o.o.o.o.o.o.o.o.o.o.o.oXH $XHX3.o.oXH.lX3XH.oXH.o Y Y.o , , , , ,X- , , ,X- , ,X-X$X$.dXzX. >.s.8 :XHX3XH.o.o , R.oXH.oXH.o.o.o.o.oXH.oXH.oXD.oXHXH MXH.oXH MXH.oXH.o.o.o $ -.{X-.{.{X*.{.{X*.{.{X*.{.{.{.{.{.{.{.{.{ 5.{X-.{.{.{.{.{.M.M.M.{XzX.XV >.s.ZXH ,XH RXH.oXH.oXH.o.oXH.oXHXH ,XH BXHXHXH.oXHXHXH MXHXHXH.oXHXH _.oXHXHXHXHXgXHXH.oXH.o.oXH 2.oXH.o.o 5XH.f.f.f.f.f.f.P., ).P.!XZ._._.IX9XZ.t.b.aX@XA.[.0.,XA.IXs bXAXAXAXA.*X@.F f f.a.0XZXAXZXZ LXZ bXmXAXZ bXsXZ.0XA.) FX@.).I b L.0.!XZX9X X9 b &._XZ.) b b.h.)._X@.b._Xm.(  .$.,XZXA., O.m.7 $.mXA.,._XAXZXZ b.tX@ gXmXA._.) b.6.(XZ.)X@.:  .I._.0 bXs b.t 0XZ.,.PXZ.I.!Xs.IXZX@ 0XZXs b.)XsXs.PX9XsXZXZ b.I b.I b.).0.).!.)XZ., L.).IX9Xs.IXsXZ.,XZ.) L b.IXZ.I |XsXs.I.).I.I.,._.,.,.I bXs.!.I b.Y.0.,.!.).I b.IXZ.).I.I.PXs.I.IXsX9X9XsX9.I.,.IX9XsXsX9X X9Xs.P.$ % J } %XZ b L.I.) L.I.IXZ.I.I.I bXZXs b.) 0.Y., ).P.!XZ._._.IX9XZ.t.b.aX@XA.[.0.,XA.IXs bXAXAXAXA.*X@.F f f.a.0XZXAXZXZ LXZ bXmXAXZ bXsXZ.0XA.) FX@.).I b L.0.!XZX9X X9 b &._XZ.) b b.h.)._X@.b._Xm._.IXZ.,XZXA.,XZXAXA.t fXA.,._XAXZXZ b.tX@ gXmXA._.) bXAXZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T oX9.PX X .!XsXZXZ.)XaXHXaXHXHXaXH.oXHXH.oXH.o.oXHXaXHXa.o.oXH.o RXHXaXH.o.oXHXa.oXHXH.o.o.oXH.oXHXa.oXH.o.oX3 $ ,XHXa.oXaXa MXH.oXH.o.o.lXH.o.o.o.o.oXH.o.o.o.o.o.o.oXa.o.oXH.o.o.oX3XH.oXH.oX3XH.oXHX3.o $ ,XHX3XH.r YX-XH , ,X- ,X- , ,X- , , ,X$.dXO.xX.XV.s.s 5.oXHXH.o.oXH.o.o MXH.o.oXH.oXHXH.o.oXHXH.o.oXHX3XH.o.oXHXH.oXH.o.oXHXaXHX3.XXp -.{.{.{.{.{.{.{X*.{.{.{.{.{.{.{.{ 5.{.{.{.{ -.{.{.MXmXmXm.MXxX.XV >.s.XXg ,XHXHXH.oXH.oXHXHXHXH.oXHXHXHXa.o ,XHXH.o.o.o MXHXaXH.o.oXa ,XH.o _ ,XH , 2XHXHXH.o.oXHXH.oXHXHXHXHXHXa.e.f.f.f.f.f.f 8XZX9Xs.I.IXs.<Xs.I.IXl d.a.<X@.0 & bXZXZ.) b.) LXZ.*X<X@.} f._.)XZXz.).).) bXZ LXAXZXZ.I bXZ.)XZXA.b.aXzXA.I b.) b.) bX9X  b._X@Xm.) b b bXZXA.* f.aXZ.S  ./.,XA.0 L.:     % g.0._X@XAXZ.) LXm.*X@XZXA.,XZXZ.m.S.mXu l.~ l gX@XZXAXkXz.a._XZ.I b.IX  b.!.YXZ.t.,XZ bXs.IXZX9XsXsX9 bXZXsXs.PX9Xk.! M.0 L b.I.IXZ.) bXs.I._X9.!XZXZ.I b.IXs.,.E.IX9XZXZ.!Xs b.).,XZ.,.IXZ.P.IXZ |XZ.) b bX9.!XZ.I.0 L b bXkXs.P.P.PXsX9XZ.I.q.I., b.P.IX X9XsX9.P.9    .9XZXZ.)XZ bXs b b.I., b.!XZ.!.I.IXs b.< 0XZX9Xs.I.IXs.<Xs.I.IXl d.a.<X@.0 & bXZXZ.) b.) LXZ.*X<X@.} f._.)XZXz.).).) bXZ LXAXZXZ.I bXZ.)XZXA.b.aXzXA.I b.) b.) bX9X  b._X@Xm.) b b bXZXA.* f.aX@XZ bXZ.,XA.0 LXZXA._X@ g.0._X@XAXZ.) LXm.*X@XZXA.,XZXZXAXZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.uX X X X9.I.I.IXZXZXaXHXHXaXH.oXaXHXaXa.eXHXH.oXaXa.oXHXH.o.o B.o.oXaXH.o.o.oXH.o.o.oXH.oXH.o.o.o.oXH.o.oXHXHXDXHX3.oXH.o.o.oXH.o.o.o.oXDXHX3XH.oXH.o.oXH.o.o.o.o.oXH.o.o.o.o.oXH.o.oXH.o.oXHXH.o.o.oXH.oXH $ $ $ $ 5.- 5 5X-X- ,X-.dX- ,X- ,X*X*Xm.M.xXG >.s.s.sX3XHXHX3XH 5.o 5.oXH.o.o.o.oXH.o.o.oXH.o.o.oXH.o.oXH.oXH MXa.o.oXH.o.oXH.oXH.C.X oXp -.{ -.{.{.{ :X*.{.{.{.{.{.{.{.{.{.{.{.{.M.M.{.{XO.M.xX.XVXV >.s ]XHXg.oXHXH.oXH.o 5.o ,.oXH.o '.oXH M.oXaXH ,XHXH.oXH.o.oXHXHXHXHXH.oXHXH B 2 !XHXHXH.oXHXH.oXH 5XHX3XHXHXHXHXH.f.f.f.f.f.fX4.,.I b LXk b.)XZXAXmX<.aXC.< vX<.hXAX@XzXAXA 4XA.h.b.a.b.a.).0XAXAX@XZ.) bXA., b.). .0 bXA b bXs.)XA gX@XZ L L bXZ bXZXsX9 bXZ._XZ.0 b b b LXZXZXA.a.:.:.:.:./.)XZXZ.I k zXA 4XA.b._. XZXZ b.*.aXAXZ.)XAXZ.)XZ.L.$.$.$XZXAX@.a g.b.b.}X@.,.I b.I.IXs.IXZXZ._X@.,.IXs.I.IXs.P.PXs.IXs.) b.I b bXk.P.!.0 b.IX9Xs b.I.) b.Y.,.I.,.)XZ L.).IXs.,.,XZ.P._ 0.P.I.IXZ.IXZ.!XZ.!.I.!.,.,.!.I bXZ.I b.,XZXZ.)XZ.).I b.IX9.I.P.I | bX X9.!.I L.IX9XsX9X X  O.m.L.I.IXZXZ.P.I b.I.I.I.I.I.IXZ.!.I L.P.I.t.<.,.I b LXk b.)XZXAXmX<.aXC.< vX<.hXAX@XzXAXA 4XA.h.b.a.b.a.).0XAXAX@XZ.) bXA., b.). .0 bXA b bXs.)XA gX@XZ L L bXZ bXZXsX9 bXZ._XZ.0 b b b LXZXZXA.aXAXZ.)XZXZ.)XZXZ.,XZ LXA 4XA.b._. XZXZ b.*.aXAXZ.)XAXZ.)XZ.I.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.PX9X9Xs.IX  )Xs b.P.e BXHXa BXHXa B.oXa BXa BXaXH RXH.o RXHXH AXHXH R.oXH R.o RXHXH R.oXa RXHXH RXHXaXDXHXDXDXD t BXH $XaXH $.o.oXDXa.o $ ,XHXDXHXaXD.oXDXH.oXDXH.oXD.oXaXD.oXaXD.o.o.oXDXH.CXH.oXDXH.oXD.oX3 $XH.o $ G 3 5 5X-X- , , ,X$X*X*.M.M.x.xXV Z Z.s.s.lXDXHXD.oXHXDX3XH $.oXaXD.oXHXDXH.oXDXHXHXHXHXD ,XHXDXH.o R.oXHXD.oXH R.oXH $ !.lX5 o - - -Xp -.{ -.{.{.{X*.{.{.{.M.{.{.MXm.MX*XOXm.M.xX.X.XV >.s Z ] { , !XD 5X3 BXH.o RXa.o B.oXH RXH.o BXH BXH.o B.oXH BXHXH B.o.o B.oXHXgXH 2X3XHXgXH.o _XHXH BXH.o B 5Xa 2.oXaXH.f.f.f.f.f.f.P.I.b.a f f.b.a.a g.<.a.0XmXl.b._._X@.a.a._.) b.).IXZ.I bXZ LXZ.IXAXAXAXZ.).) bXZ b b LX  zX9 b.I b.0X@X@.*._.).I bX9Xs bXs bXz.tXZXA.0 b LXZ.) L.)X@X@.aXZ._.0.)XZXZ.! bXA._XA.a._XZ.)XZ.)X$.aX@._ b bXZ.IXZ.0XZXZ.hXAXZ.aXZXmXZ.< fX@.!._XZ b.)XZ b.I.I bXZ.,XZXZ b.P b.IXs.IXsXs.I.IXs.,XAXZ b.I.IXZXA b b.).I.I.).,Xs.IXZ.I.!.,.!XZ b.,.YXZ L.!.!.I.I.I bXZXZ.!.).I.IXs.I.!.PXZXZ.PXZ.,.).I.!XZ.IXs.I bXs.I.PXZ.P b.)Xs.!X9X9.!.).PX X9X X9X9Xs.IX  )Xs b.PXs.I b.! bXsXs.)Xs b L LXZ.,XZXA.,.I.b.a f f.b.a.a g.<.a.0XmXl.b._._X@.a.a._.) b.).IXZ.I bXZ LXZ.IXAXAXAXZ.).) bXZ b b LX  zX9 b.I b.0X@X@.*._.).I bX9Xs bXs bXz.tXZXA.0 b LXZ.) L.)X@X@.aXZ._.0.)XZXZ.! bXA._XA.a._XZ.)XZ.)X$.aX@._ b bXZ.IXZ.0XZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.PXZ.,._ b.PX9X9XsX9XHXHXaXaXHXaXa.oXa 5XaXHXHXHXaXaXHXaXH MXH RXH.oXHXH.oXa.o.oXHXHXHXHXHXa.oXa.oXH.o.oXH.oXD.lXDXH.oXH.o.oXHX3XH.oXa.oX3XDXH.o.o.o.oXH.o.oXH.o.o.o.oXa.o.o.o 5.o.o.o.o.o.oXH.o.o.o.o.o.o.oX3XH.oXH.oXH 3 h oXpXpXp -XpXxXpX.X.XG >.s.Z.XXH ,XD.sXH.o.oXH.o ,XH.o.o.o.oXHXa MXHXHXH.o.oXH.oXH.oXH MXH.o 'XH.o MXH.o.o 5.o ,XHXH ,XHX3 G.pXtXtXxXnXxXnXxXnXxXnXxXn.xXx.xXxX.XxX.XVXVXV > Z Z tXBXHXHXHXH.oXHXg ,.oXH M.o.o 5.o.oXHXHXH.o MXH.oXHXH.oXH.oXHXHXHXHXHXH.o.oXH MXH.oXHXHX3XHXH ,XHXH.o.oXH.oXHXHXH.oXH.o.e.f.f.f.f.f.fX Xs.a f f F f.a._., | bXm.bXN._._ b.).).IXs b LXZ.I b b b b b.)XA._.)._XA b bXZXA b.I.)X9XsX9.I bXs b LXZ.bX@._ z bXk LXkX9XAX@.aXAXZ b.) b.)._Xs b f.b fX@._XA b.0XA.).)XAXAXAX@XAXZXZXZXAXAXZXZXZXZ.P LXZXzXZ.!XAXA LXA fXZ.)._._._.<XA.,XZ.) b b bXZ b LXZ._XA.).I.IXs.IX9Xs.I.I.I.!.P.IXZ.,.I b.I.!XA.) b L.,.I b., b.IXZXZ.I.I.PXZ.IXZ.,.0.,XZXZXZXZ b.I.I.).I.!.I.I.I.P.I.I.) b b.I.!XZ.).I.I.I.I b.P.!XsXsX9X .I.I b.PX9X .I.!.IX .qX XZ.,._ b.PX9X9XsX9XsX9.P.I.IXsXs.IXs.IXZ._XZXZ.,.I.PXs.a f f F f.a._., | bXm.bXN._._ b.).).IXs b LXZ.I b b b b b.)XA._.)._XA b bXZXA b.I.)X9XsX9.I bXs b LXZ.bX@._ z bXk LXkX9XAX@.aXAXZ b.) b.)._Xs b f.b fX@._XA b.0XA.).)XAXAXAX@XAXZXZXZXAXAXZXZXZXZ.P LXZXzXZ.!.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T a._ | o b.I b b.PX9XaXHXHXaXHXaXaXHXaXaXaXa R.oXHXH.oXHXHXHXH R.oXHXaXaXH RXHXaXa.o.o.oXa.oXHXH.o.oXHXD.oXH $XDXDXH.o.o.oXH.oXHX3XDXaXH.oXDX3XHXHXH.o.o.oXH.oXDXH.o.o.oXaXH.o.oXH.oXH.oXH.oXDXa.o.o.oXH.o.oXH.o.o.oXHX3.oXD.pXtXxXB.XXx.XXtX> >.s.s.gXD ,.oXH.lXDXH.oXHXa.oXa.oXHXDXaXH.o.oXHXH M.oXHXH M.oXHXD.oXa.o.o.o.o.oXHXH.oXH.oXHXHXDXH ,XHXHX3 5 h ]X5X>XtXtXxXtXx.XXxX.XtX.XtXtXVXVXV > t.s Z ].XXH.oXHXH MXHXH.oXDXHXHXgXaXHXH.oXHXHXH.oXHXH.oXHXH B MXHXHXH MXH.oXHXH.oXH 5.oXH B.o.oXHXHXH.oXH.o.oXHXH.oXH 2.oXHXHXH 5 5.f.f.f.f.f.fX5XsX@.< d.t sXA.aXsX9Xl f.} M.0XA b.! b.I b b.I b.IXs.I.I.I.I bXAXZ.IXz., LXZX@.,Xk b b b z b L.IXs.IX9 b.aX@X@ zX9 bXAXZ.& v.<XAXA.) LXA L.*._.)Xm F fXl.<.tX@ LXAXmXZ._XA.<.0 bXmX@.t s._XA L L L.IXs L.0XZ.IXZXAXAXZ g v L.I. ._ L.0., LXZ.!Xs.I b.IXZ.I.) 0.0XZ.I.I bXs.I.IXZXs.I.PXs.I.I.IXs.I b.I.IXAXA.I b.I.I., bXZ._.I.)XZ.!XZXm._XZXA._._.,.I bXs.!Xs b.)XZ b b.!X Xs.I.)XZ.I.I.IXZ b b.P.!.PX9Xs.I.I.I b.IXsXs.IX  ).P.,X .I b bXA._ | o b.I b b.PX9X9Xs.IX9Xs.P b LXAXZ b.I.,.IXs.PXsXsX@.< d.t sXA.aXsX9Xl f.} M.0XA b.! b.I b b.I b.IXs.I.I.I.I bXAXZ.IXz., LXZX@.,Xk b b b z b L.IXs.IX9 b.aX@X@ zX9 bXAXZ.& v.<XAXA.) LXA L.*._.)Xm F fXl.<.tX@ LXAXmXZ._XA.<.0 bXmX@.t s._XA L L L.IXs L.0XZ.IXZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX4XsX9X9X9X9.PXZXZX9Xa.eXHXaXHXHXHXaXHXHXa.oXaXHXHXaXaXH.oXa RXHXHXaXaXH.oXaXaXaXHXHXaXaXaXH.oXaXHXaXaXH.oXH $ RXD.o.oXHXH.o.oXHXHXaXH.o.o $.oXa.o.o.oXaXa.oXa.o.oXaXHXa.oXa.oXaXa.oXa.oXaXaXa.oXHXaXa.oXH.o.o.o.oXH.oXH.o.o 5.r.w.wX5.p ].l ! ] G 3XH.o.o.oXH $XDXH.oXaXHXH.oXH.o.oXH.o.oXH.o.oXaXa.o.oXa.o.oXa.oXH.o.oXH.oXa.o.o.oXHX3XHX3.oXHXHX3XHXHXH.o : oX5.l ] ] p p p p p p p >.8.l.lXg.sX5 o -XHXHXH.o.o.oXH.oXHXH B ,XHXH.oXH.oXH.o.o.oXHXH.o.oXHXa.oXHXa.o.oXaXHXa.o.o.o.oXa.oXa.oXHXH.oXH.oXH.oXHXaXHXHXaXaXHXH.o.oXHXaXH.f.f.f.f.f.fXq b._._ s.< g.<.b.} f.b._.,XZ b L b LXA.) b b.I b L b.IXZ L b b.) L.) L.)XAXAXZ b b.I b.PX9X9X9 b.I bXsXAXl.G f.t gXl.b.b.b vXN L.I bXsXZXAXz 0XAXZX@.t.<._._X@ gX@X<X@.*._.)XZ LXZXmXAXA.*.*XZXmXZXAXZ b.a.t._X@.t.)X@ f.]XZ.!X@.h LXZXC f.a.!.I b.0.I b.IXZ.0X@XZXA b L.I.I.IXZ bXs.P.PXsXsXs b.I b b.I b.IXZ 0XZ.,.YXZXZXZXZXZ.) b.IXZ.,._XZXAXZXZXZ.I._.).PXZXZXZX9.I.P b.IXsXZ._XZXZXZ.).IXZ |.IXsX9.IXZXA. XZ.IXsX9.IX X .V.!XZ.I.I.Y.IXsX9X9X9X9.PXZXZX9.!.I.PXk L.)XZXAXZ.IXsXk.!X9XsXs.I b._._ s.< g.<.b.} f.b._.,XZ b L b LXA.) b b.I b L b.IXZ L b b.) L.) L.)XAXAXZ b b.I b.PX9X9X9 b.I bXsXAXl.G f.t gXl.b.b.b vXN L.I bXsXZXAXz 0XAXZX@.t.<._._X@ gX@X<X@.*._.)XZ LXZXmXAXA.*.*XZXmXZXAXZ b.a.t._X@.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX4.IXsXsXsX X9 0._ b.eXaXaXH.eXH.eXHXaXHXa.eXHXHXa.eXHXHXaXH.iXHXaXHXHXaXHXHXaXHXHXaXHXHXaXHXHXHXaXHXHXHXHXa U U }XHXHXHXaXHXHXHXaXHXaXHXH UXHXaXHXHXH.eXaXHXaXHXaXHXHXHXaXHXaXHXHXaXaXHXaXHXaXHXHXHXaXHXaXHXHXHXHXaXHXaXHXHXHXH h h.R.w h G o 5XHXHXHXHXHXaXHX; 2XHXHXaXHXaXHXHXaXHXHXHXHXHXaXHXHXHXHXHXaXHXaXHXaXHXHXHXaXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXaXHXHXH - n hX5.p ]Xg.l.p.r h G.X 3 ^XHXHXHXHXHXHXHXH.eXaXHXHXH nXaXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXHXH.eXHXHXHXHXHXHXHXHXHXHXHXHXHXH.eXH.eXHXH.e.f.f.f.f.f.fX9.)XZXZ._ d.<._.b d._._X@ 0XsXs b bXs.) L LXs L.! bXZ bXZ.I L LXZXm LXA._XAXA L b b L.I.IXsX9X9 bXsX9 b L.b.G dX@ 4 g.0XA 4 g.a bXs.y.I.)XAXAXAX@X@ g.<.t.)XZ.<XAXZ.) fX@XZXs bXZ LXAXAXm vXZ.).7.$.$.$.$./X@.] L. XA g f.].0.!XmXZXZXA.n &X2XZ b.IXZ b bXs.IXZ.< L._ b.)XZXsXZ., bXs b./.$ %.$XS.$.L b bXZ.I.!.I.!.IXZ.IXZ.,.,._.,.!.!XZ.!.,XZ.0XZ.,XZ.I | b.I.,XZXZXh }.I.!., bXZXZXZ.P.IXZ./.V.m.m.P.P.IXZXZ., |X Xs b.!X9XsX9XZ 0.PX Xs.$.IXsXsXs O l OXZ b.,XZ L w.$ O.B.!X9.) b.I.PXsX XuXZ.)XZXZ._ dX9 O k O._._X@ 0XsXs b bXs.) L LXs L.! b.uXu.$.$Xu.5XZXm LXA._XAXA L b b L.I.IXsX9X9 bXsX9 b L.b *Xq l l g.0XA 4 g.aXu $Xd.$.$.7 J.$ O./ g.I $.)XZ.<XAXZ.) fX@XZXs bXZ LXAXAXm vXZ.)XAXZXZXZ.)X@X@.] L.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.7Xs L.IX X9X9XZ., L 5.eXH.e.eXa.eXH.e.e.e.e e.e.eXH.e.eXH.e <.eXH.e.eXH.eXo.e.e.e.e.eXH.e.e.eXH.e.e.e <.e.e e.j.jXHXH.eXH.e.eXH.e <XH.eXH e.eXH.e.e.eXH.eXH.e e.eXa.eXH.eXH.eXH.eXH.eXH.e 5 <.eXa.eXH.eXH.e.e.e.e.e.e.e.e <.eXHXHXHXHXHXHXHXH.eXH.eXH <.e.eXH D eXHXHXHXH.eXH.eXHXo.e.e.e.e.e.eXH.eXa.e.e.e.e <.e.eXH.eXH.eXH.e.e.eXa.eXHXHXo.eXHXH.eXHXH.eXH.eXH.e <XH eXHXHXHXHXHXH 5XHXHXH.e ~ 5XH.jXHXH.e.e.eXa.e.eXHXH eXH.e <XHXH.eXa.e.e.e.e.e.e.e.e.e <.e.eXH.e.e.eXH.e.e.e.e.e.e.e <.eXH.e.e.eXH.e.e.e.eXH.e.eXoXH.eXH.e.e.e.f.f.f.f.f.fX9XZXZ.I.).W.<.< f d.<.YXZ 0.IXs.IXs b bXZXZ b.IXZXZ.) LXZ b.) bXZXAXAXA.)XAXZXZ b b b bXZ.IX9X9 b b L bXk f F.}.t g.aX+ L m.=.aXA L b.)XZ.<XAXAX@X@X@.<.< b bXAXAXm._X@.0.IXZXA.t.,XZXZXZ.) bXZ.X k    .%.:.6.~ l.IXZ._ f._ b.)XAXZXZXZ.k.,.!XAXAXZ.).).I b bX@.0XZXAXk b.) b.)XZ.I.L.6  .: $ l.A   h.)XZ.,.!.PXkXs.I.)Xs.IXZXZXZ.0.IXZ.,XZ._. XZXZXZ.,.I.P b.P.,.IXs.6  .$.I.,.!XZ.).I.P.I.IXq N  .(X X9.!.,XZ.IXsX X9.IXs b.I.!.P./.i.~  .6Xs L.I %.A % l.S z._XA l.S.m l.S.VXsXs.IX& %.~  .6XZXZXZ.I.).WX9.~   k.<.YXZ 0.IXs.IXs b bXZXZ b.IXZXZ b.m    .%.:.%.~XuXA.)XAXZXZ b b b bXZ.IX9X9 b b L bXk f |.6  XX.aX+ L m.=.a l.S  .S k.v.$   N OX@ N  Xu bXAXAXm._X@.0.IXZXA.t.,XZXZXZ.) bXZ. .).0XZXZXAX@.a b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX4Xs.I.I.IXs b.I._.0.e.e.e.eXH.e.eXH.eXa.e.eXH.eXa.e.eXH.e.e e.e.eXH.e.eXH.eXHXH.eXH.e.e.eXH.e.eXHXHXH.e.eXH.e e.e.e.e.e.e.e.e.eXa :.e.e.eXH e.eXHXH.eXa 5.e.eXa.eXH.eXH.eXH.eXa.eXH.e.eXa.e.e.eXH.eXH.e.eXa.eXa.eXa.e.e.e.e.eXHXH.e.eXH.eXH.e.e.e.e.e.e.e.e.e e eXH.e.e.eXa.e.eXH.eXa.eXH.eXH.e.e.e.eXH.eXH.eXH.e.e.e.e.e.e.e.eXH.e.e.e.e.eXaXH.e.e.e.e.e.e.e.e.e.e.e.e.e.e *XH.e.e.e.e.e.e.e.e e.e.e.e.e.e.e.e.e.e.e.e.e.e.e <.e.e.e.e.e.e.eXH.eXH.e.eXH.e.e.eXH.e.e.eXaXH.eXH.eXa.eXH.e.e.eXa.e.eXa.eXa.eXaXaXH.eXa.eXH.eXH.eXH.e.e.f.f.f.f.f.fX9 &.).I.! sXAXl._ 0.!XA.!.I.,XkXs L b.)XZ |.I b b L b.) b.) L._XZ.)XZXZ.)XZ._.I b b bX9X9XsXs bXs b.I.IXm f F FXZ.) L. X@Xz.b f.!.).! b b.).)XA.*XA.0Xm._XsXA.<XA._X<.)XZ.t g CX@ MX@ 0 LXZ.,XZXZXA    .m bXu  XfXZXAXZXZ.)XZXAXZ LXZXZ.IXZ.,X@.tXZXZ.6.B.IXZ._ 0 |.,.) LXZ.I.IXsXh.S  .mXsXs.P RX,.,.PX .I b.I.PXsXZ b.Y.,Xs.!.IXZXZXm.IXZ.)XZ.I.IXZ.I b.!.PX9.PX9X .9.6X&.,.,.!.IXZ.I.!XZ.I.I.(   }.).!.I.!.P.P.P.%.u.,XZ.I.PX9.P b.I.%   %Xs.I l  .% b.I  .:Xm l  .6Xs.)  .(XsX X9.IX .6   %XZ &.).I.! sXA.6  .I.!XA.!.I.,XkXs L b.)XZ |.I b b L b.)    Xc._ l  .S.u.)XZ._.I b b bX9X9XsXs bXs b.I.IXm f F N  .$ L. X@Xz.b f.!.~  .: b.) k.(.*XA.0 n N.wXA.<XA._X<.)XZ.t g CX@ MX@ 0 LXZ.,XZXZXAXZ LXZ bXAXZ.t.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T 8X9X9 bX9 zXk bX@XA.eXa.eXH.e.eXa.e.eXH.e.e.e.e.e.e.eXa.e.e eXH.e.e.eXH.e.e.e.e.e.e.eXH.e.e.e.e.e.e.eXHXH.e.e eXa.e.eXa.eXa.e.e.e.e.eXa.eXH D.e.e.e.e.e.e.e.eXH.e.e.eXa.e.e.eXH.e.e.e.e.e.e.e.eXH.e.eXa.e.e.eXa.e.eXa.e.e.e.e.eXa.e.e.eXH.eXHXa.e.e.e.eXa.eXH D D.eXH.e.e.eXa.e.e.eXH.e.eXa.e.eXa.eXH.e.e.e.e.e.eXa.eXa.e.eXH.e.e.eXa.e.e.eXo.eXa.e.e.e.e.e.e.eXa.e.eXa.eXHXHXH.e.e.eXa.eXH.e.e <.eXH.eXa.e.e.eXa.e.eXa.e.e.e eXHXa.e.eXa.e.e.e.eXa.e.eXa.e.e.e.eXa.eXa.e.e.e.e.eXa.e.e.eXa.e.eXH.eXa.e.e.e.e.e.e.e.e.e.eXa.e.e.e.e.e.f.f.f.f.f.f.P.IXZ b.!.).*XlXm & |.!.I.P.Y., b.,XZXZ |., b.I L.E.) b.P b.).).0.) LXZ. .)XZ.I.I L bXsXs.I.I b LXZXZXZ.h.= f g._ b b f.b.b.b F.I bX9 b z b. .*X@ 0XA.)XZ b.!X<. .)XZXmX@.0.0XZ.)XsXZXC b.)XZXZXZ.$    .R.!.$     O.aXAX@Xm._.0 bXZXZ.!.I L.0XCXN.0.(.6.IXsXZ.<._XZ._ MXAXZXs.PX .S  .9.P.PXsX  J N.PXsX9.IX Xs._XZ.,.I.!._ b.).E.,XZ.0.I.YXZ.!._XZ.!.! b.PXs bXsX XsXs |.I bXZ.!XZ.IXZ.I.IXZXs.S  X .I.I.PX9X9X9.(.6X@.,Xs.IX X .PX9.u    XhX9X9X,  XcXk.B  .~.,X,   }.IXB  XfX9X9Xs.IXS     O.,.IXZ b.!.).K  .~ & |.!.I.P.Y., b.,XZXZ |., b.I L.E.)Xu     O.) O    .$. .)XZ.I.I L bXsXs.I.I b LXZXZXZ.h.= f  .S b b f.b.b.b F.L     l z.m u.*X@ 0XA.)XZ b.!X<. .)XZXmX@.0.0XZ.)XsXZXC b.)XZXZXZXZ.,XZXs.!.IXAX@.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T o bXsX9 b L b LX@ v.e.e.e.e.eXa.eXa.e.e.e.eXoXa.e.eXH.e.e.c.e.e.e.e.eXa.eXo.e.e.e.eXH.e.e.eXH.e.e.e.e e.e.eXH.eXH.eXa *.e.e.eXa.eXo.e.e.e.eXoXH.e.eXa.e.e.e.eXo.eXa.e.eXa.e.eXa.e.e.e.e.eXaXo.e.eXa.eXa.eXa.e.eXa.e.e.e.e <.eXa.e.eXa.e.e.e.eXa.eXH.e u.e.e.e < eXH.eXa.eXa.e.e.eXo.e.e.e.e.e.e.e.eXa.e.e.e.eXo.e.e.e.e.e.e.e.e.e.e.e.e.eXHXo.e.e.eXa.eXa.eXa.e.e.e.e.eXo.e.e.e.eXH.e.eXa.e.e.e DXH * u.e.eXa.e.e.e.e.eXa.e.eXo.eXo.e.e.e.eXa.e.e.e.e.e.e.e.e D.e.e.e.e.eXa.e.eXa.e.eXa.e.eXo.e.e.e.eXa.eXa.e.eXa.e.eXaXo.eXa.e.e.e.e.f.f.f.f.f.f OX9., &.).* fX<.)XZ.I.IX9XsXZ 0 bXs.I.!.,.I., b.I L b.I bXk. XZXZ L.IXA b LXAXZ.I b.I b.I.! b b._X@XZXk L.*XN.).<.,Xz.b f.b.= f._ b z b b b L._._XAXm L.).)XA._XA._XAXZ.t.P bXs bXZXZXA bXZXZX@._.:  X,.PXZ.:  .S.v.W./ % u O %.$Xq.$.: R O.i.P O.~  .%.mXh.( % l.$ 0.,._._ b b.(  .AXS b bXs.PX  $.PX X .i.9.9.I &.IXh.m % l l.6.m.YX .: %XZXS.: O.L ;.9.mXh.(.VXh.m.9 l.IXZXh.(.(.m.$.$., b J  .%.P k u kXs $X,  .6 k.,.PXsXs.PXs.I l  X,Xs bXs     z b l  .~ b    .L L l  X,X9X9Xs.I l  X,.,X9X9., &.).*.$  .( k.6 lX9Xs O %.:Xs.L.9 O.I., b.I L b.:  X,. XZ.:  .S.7 b z.: N.$.:.$ b.L.R.:.:._X@.m.: L.* O  .(.,Xz.b f.b.= f.m    .B.m % L._._ J.C.: l.).7 O.m %XA l u k bXs b.$.(.( %.$.$X@._.) L.I.PXZ.I.)._.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX4 bXm 0.n.] 0XZ.*.bX=X=X7X=X=X7X=X=X=X7X=X=X=X=X=X=X=.@.@XoX=X=X7X=X=X=X=X=X=X=X7X=X=X=X=X=X7X=X=X=X=X=X=Xo e.cXoX=X=X7X=X7X=X=X=X7X=X=X=X= D.c eX=X=X=X7X=X7X=X=X=X=X=X=X=X7X7X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X7X=X=X=X7X=X=X=X=X7X=X=X=X=X= e eX=X7X=X=X=X=X=X=X=X=X=X7X=X7X=X7X7X=X=X7X7X7X=X=X=X7X=X=X7X=X=X7X=X7X=X=X= eX=X=X=X=X=X=X7X=X=X=X7X=X=X=X=X=X=X=X=X=X=X=X7X= e eXoXoX=X=X=X=X=X=X=X7X=X7X=X= eX=X=X=X=X=X=X=X7X=X=X7X=X=X7X=X=X=X=X7X=X=X=X7X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=X=.f.f.f.f.f.f.B.IXA f f.I.^XA., b.P bXs.PX9.!.0 b.I b bXZ LXZ.I.).I b L bXAXZ b.!.I.!._.*XA.0._.<X@XAXA._._XAXZXZ b.I b.t 0 b bX<.bXl.bX@ 4XA L bXZXZ LXAXZ 0X+.tXZ.!XZ LXmXAXZ.0.)XA.!X9 b b.) b LXAXZ._.) b.).%  .( bXh.S   kXZ O.S.iXZ.S  .$./.%  .:.S  .:./.6   k.R.S.mXs.6 }XZXZXA.<Xs.u    .(Xs.!.!.I.,._.,Xs.R.A %X9.%.SXB |Xh.%  .i.:.S   lXh.S  .I.m   %.V.%  .9.A  .9.R.%  .mX9.(  .R.I  .S N.IXZ.m  .:.: N  Xf.I.V.%  .m.R b.PXZ.I.IXZ.P.9  .(.I bXm    .] 0.(   N._    X Xs u  .%Xs.I bXA.:  .9.I L.IXA f f.I.9  .6.:.A  .R.P l.A  .B %  .:XZ LXZ.I.).I.~  .(XA O.S  .m.!.L.S.(.).S   OXA.B.(   NXZ./  X, b.t %  .mX<.bXl.bX@ 4XA N  .6.: NXAXZ 0X+Xt.%   k L w.(  .:.m.:  X, b b.(  Xu.7  .S.6 b.).)XZ.I b.I.).!XZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXr._ FX6XC 0XZ.I._ d i i i i i i i i i i i i i i i i i DX8Xo.@X8 i i i i i i i i i i i i i i i i i i i i.A i i i i e i i i i i i i i i i i D.A.c.A i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i e e i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.c i i i i i i i i i i i i i i i i i i i i i i iXo i i i i.A i i i i i i i i i i iXo i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.f.f.f.f.f.f J L fXN.,XsXs.)XC.I b.PX9 bX9.!._ bXsXZ b.I bXZ.! L.I bXZ L._.I b.IXZXAX@X@ b L bXA L L bXZXA b b L bXZXAX@., b 4.* 4.a gX@Xk bXA L.I b LXA.,XmXA.tXA.0XZXZXZXAXZ._._XAXZXs b b.I.! b._XZX@XAXZ.u    .6.( N.i./.I.L.S.~XCX@  .S.IXZ.%  .i./.:.B.Y  .SXZXu   N.I lXh.!Xm g.<XZ l     l.).,., bX@XZ.!XS.AXfX X9.%  Xu.I.PX,   lXZ.6  .9._.(   $.I N.$.P.%  .9.V.9 OXs.%  .V l  .%.IXB    .I.)XZ N  .( O $   N.I.P  .S.IX9Xs.I.I.IXs.I.P.~   k.)._ F.~  .>.u.S   k._.~   J h.A   %.I b.)XZX,  .mXs b L fXN.,Xs.A  .r.I.6  .m bX9.9   lXs N l.I bXZ.! LXS    .6.: N %.LXZ.B.S.~ b L  .S L L b.(  .m bXc  .:XAX@.~  .|.* 4.a gX@Xk b.S  X,  .S.7.,XmXA.t.%  ./XZXZ.(   %.LXu  .% bXu  .% bXZ    XAXZXZXZ b.!.I.IXsXZ.I.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T._ &Xj 0X9.I L bXZ v i i i i i i i i i i i iXo i i i iXf S S S uXi i i i iXo i i i i i i i i i i i i iX8 i i i i i i i i i i i i i.c i i i.c.c.A.A i i i i i iXo i i i i i i i i i i i i i iXo i i i i i i i i i i i i i iX8 i i i i i i i i i i i i iXf i i i.@X8 i i i i i i i i e i i i i i i i i i i i i i.c.c e e.c D.c.c.c.c i i i i i e i i i i i i i i i i i i i S i i i i i i i i e i i i i i SXo i i i i i i i i i i e iXo i i S D S.AXo S i i i i i e i i i i i i i i i i i i i i.c i i i i i i i i i i i i iXo i i i i i i.f.f.f.f.f.fXS.b.,.P.!X9.PXs s., bXsX9X9.PXs._Xs.I.I b. XZ.I b.I L L.IXZ.! b.,._X@ LXAXZ LXZXZXZ L b.I LXA.) bXsXZ L.).0 bXs LX+XzXAXAXZ z.y b.)XsXs.I.,._.hXAXZ.,.&.).) bXZXs.)XA.a 0Xs bXZ.,.IXA._XZXZXAXA $     hX  bXs.Y b.(  .$ 0 O  .(Xs.B  .S.$XZXZ.) l  .:XZ.B.S  .m.IXs.P._.< 0.a %    XhXZXZXAXl._X@.,.i  .:Xs.PX,  .$ b.L  X,.I.!.%  .$XZ.m  .:.!.(.I h  .A.$.PXZ.IX   .~ b }  .:.! k   N.,.IXs    .9.I.(   %Xs l  .(Xs.PX9 b.IXZ.IXsX&    .B._ &XjXq NX,.~  .S (XZ O NX,.%  .S.BXs b.IX&    .B zXA.b.,.P.!.$  .% s.,.6   lX9.P.i  .9.I.(.B. XZ.I b.I l    .u.! b.,._X@.(   k L.$  .( L b.I.S   b b.%  Xu.)XS  Xf LX+XzXAXAXZ zXd     $.A   %._.hXA.u  .~.).) b.~  .:XA.:  .i b.m  .:XA l   NXAXA.! L.IXsX  bXs.Y b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T., bXs b.,.I bXsX9Xs i i i i i i i i i i i i i i i i i e SXo e i i i i i i i i i i i i i i i i i i iX8 i i i i i i i e i i i i i i i i i i i SXo e i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXoXo i i i i i i i i i i i i i i i i i i i i i i i i.c.A e i i i.j i i i i i e i i i i i i i i i i i i i i i i i i i i i iXo i i i i i i i i e i i i i i i i i i iXo i i i.@ i.@ S i.@ i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.f.f.f.f.f.f.BXs b.PXsXsX9Xs.I.!., b.!.I.,.I b.IXk b.) bXk.  LXZXZXZXZ._XA.h b b b LXZ.) LXZXk L.) b.t.) b L L b bX9XzXA L L.I b L gX@XA b.) L b LXZXZ b LXA.) b L bXZXZXZXA b.).)Xm.) b.)XZ.I.PXm., bXA. ._.:  .%.I.^.IXs.IX     XZ.b.:   k.IXu  .%.I.IXZ.I.:   k._._ k    .V.I LXZ.0 |.,.:     0.;., &.I.P.PXsXf   $X9.L    XS.!.m  .9.I./  .S K.I.$  .6.L.9XZ k  .% b |.I.< k   %XZXq.A N./Xf.%.VX9XsXu  .SXSXs.S  .$X9.:  .mXs.P.P.I.P.P.P.I %  .%.,., bXs b.,.L.S  .mXsXA.) b.L.S  .m.I.I.).I %  .~.* C LXs b.PXs.9  .i.IXB  .S.!.I.,.$  .6.5.:.) bXk.  LXZ.(  .%._XA.h b b.B     b L.(  .m.) bXt  .~ LXu  .SX9Xz l  .:.I b L gX@XA b.:  .S L.:  .S.|XA.).m  .:XZXZ./     b.)Xf  X&.)./.S N.X.~.~.B. ._._._XZ.I.^.IXs.I.P.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX4.I b., bXs.I.IXs b i i i i i i i i i i i i i i i i i.cXf.A S i i i i i i i i i i i i i i i i i i iXo i i i i i i iX8 i i i i i i i i i i i e e.A i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.@.@ i i i i i i i i i i i i i i i i i i i i i i i i.c i eX8 S SXo S i i i iX8 i i i i i i i i i i i i i i i i i i i i i iXo i i i i i i i iXo i i i i i i i i i iXo i i i.@ SXo i S S i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXi.f.f.f.f.f.fXq.PX9.I.IXsX9X9.P.I |.IXkXsXZ.! b b b LXkXsX9XZ.)XZ bXA b L b.I b L.).0 b.) b.)X9 b b L.)Xz g.<.  bXk L L.t._XZ L L b.h g dXZ b.) b.I.Y b.IXZXZ LXZ.)XZXZXZXZ.IXZXZ.I._.,Xs bXZXZ.)Xm., b._XA._.~  .:.! 8.!.I | $  .6XA.N.S  .I b.(  .mXZXZ.!XsX,  .B.u O b.:  .:.!.Y.I.!XZ bXh     OXZ.I.!.IX .RXs    .P b }  .( bXZ.(  .$.I.:   %.Y b b  .A.9./.,.9   %.P.!XZ.!.9   ;./ b.( }.9.$.IX9.I.I.:  .9X9 k  .% J OX,  Xh.$.IXsX9.I.I.I.I N   %.k.I.I b., b.%  .(Xs bXZ LXZ.%  .(.I b b L.! N  .mX@XZ.I.PX9.I.I.%  .$.P.m   %XkXsXZ.!  .S.: zXkXsX9XZ.)XZX,  .: L b.I b L.$  .6.).B.S  .B b L.:   R.< u   N.| L u   l z L b.h g dXZ.~   N.I.I.S  .mXZ L.(   l./XZ.m   NXZ.$  .% h b.u.( k nXh b._XA._XAXAXZ.! 8.!.I |Xs.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.7.I b.I.) bXs bX9 b iXo i i e i i.A i i e iXo i i e i i.c.A i e i iX8 i iXo i.c i i < i i.c i iXo i.c.c i iX8 i i <X8X8 i iX8 i iXo i i S i S eX8 iXf iXo i iX8 i iXo i i S i iXo i i i S i e i iXo i i.@ i iXo i iXo i iXo i i i i e i iXo i i.c i i e i i u.@.@Xo i.@ i iXo i iX8 i iXo i iXo i i.@ i i i iX8 i S.@ i iX8 i iX8 i iXo iXoXo iXo i i < i iXo i iX8 i iX8 i iX8 i i.@ i.@ S i iX8 i i.c iXfX8 i i.@ i i i iXo i S S i iXf i i D i i S i i < iXo i iX8 i iXo i iXo i iXo i iX8 iXo i i < i iX8 i iXo i iX8 i i e i i i.f.f.f.f.f.f OX9Xs bXsXsXs.PXs b.I.! bX9 bX9 b L.) b b bX9 b.) L._.)XkXs b b b.) b._XZXmXA b z b b.hXZX@ f.=X< s. XA LX@.<X@.I b L.)XzX@XZ.YXZ.!.,.I L.I |XZ.I b LXZXA bX9Xs.0XZXZXZ L b.IXZ.I.&XAX@ bXZXA.B    Xu |., |.I.!Xu  .%XA %Xf.%Xh lX,  ./XZ._.I.$  .A l l.( LXS  .:XA.0 b.! 0.) b.6   N.PXZ.I.w.%.V.I.S   b._X,.%XS.P.!.A  XsXB.S.~._ 0XZ.I.%  .9.,.!X,  .L.I.I.)XZ.~   $ % N  .( k._.!XZXsXs.%  .$Xs.9  .9.9.$  .A k R.P b.)Xs b.I.I.A  Xh., b.I bXS.%.S } bX9 b LXS.%.S l.IXZ L 4XZ w.S  .$. ._X9X9Xs b h  .A.P hX,.(.! bX9 bX9.~  .: b b bX9 b.) z    XuXs b b b.)Xu  .%Xm.:.S.~Xu l.h.6   OXcXc   n.: L.~   O % b L.)XzX@.u     }.,.I.(  .~XZ.IX,  .$.m b N   lXZ.:  .:.:.I N  .9XuX@ bXZXAXAXm._ b |., |.I.! b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXr.I b b b.IXs.IXsXZ i i i i i i i i i i i i i i i i i i SXo i i i i i i i i i i i i i i i i i i i iXo i i i i i i iXo i i i i i i i i i i i iXf S i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXo.@ i i i i i i i i i i i i i i i i i i i i i i iXo i i i i i i i i i i i i.A i i i i i i i i i i i i i i i i i i i i i iXo i i i i i i i i e i i i i i i i i i iXo i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.f.f.f.f.f.f OXsX9X9Xs.).I bX9.PX9._XZ.! LX9X9 LXkX..)XA.0Xm._.,.,.I bXZ b.IX9 b b.I b.) bXk b LXAX@XA.*X@.b.=X<.*XAXAXAXA L b.I bXZXZ.* gXm.,.) b bX@XZ.tXZ b bXZXAXAXZ.0 b b.0XZX@.0.  bXZXs.<X@X<.a.0.$.%    .(.$.^.P bXZ.X.~  .~ J.S   k.L  .%XZXAX@.,X>.S  .m O   n k.~./ b.!.IXZ._XAXZXS.(  .%.9 N.%.L |.P k.S.$.9.6.u.P.!Xh    .:.% NXSXZ.)XA.I.6.~XSXsXh  .%.I.I b.,.)X,  .(.I.m.A    .S.:XsX9XS  .AXs.P %  X,Xh.$.A  .iX9.I.I.I.I.Y %.6     N.m.)XS.:.6 %XSXs.IXs.u.:.6 %XS b. X@.<.}.m N     N kX9X9XsX9X9.w.~X, l.6.9X9._XZ.! LX9.6X,.yX..)XA.0Xm O.%     N.$ b.IX9 b.B.%  .~.$.S  .mXAX@.(  .~ b.m  .~ JXA.~  .( b.I bXZXZ.| u    .6XuXu N     NX&X,  .(XAXZ.S  .B.0.m  .~ p b k.A    .S.m.0XZXAXAX@X@XZ.^.P bXZ. .5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXrXsXs.I.I bX9XsX9._ i i i i i i i i i i i i i i i i i i.A S i i i i i i i i i i i i i i i i i i i i i e i i i i i i i i i i i i i i i i i i i SXo i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i SX8 i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i e i i i i i i i i i i i i i i i i i i i i i i iXo i i i i i iX8 i i i i i i i i i i i.c i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.f.f.f.f.f.f J bXsX9X9.I.I.I bX9X ._.) b.I b mXAXA LXz._.tXA.t.I.IXZ b.I bX9 b bXkXsX.X+XA b LXA.*X<X@.)XAX@.*X@XZXAXAXAXA.I.) LXZXA.h L d.<., b b LXAXZ._XAXZXZ LXA.) LXZXZXZXmX@ gX@XZ.)XZXZ.0X@.b.b.b.}.<XmX@XA.0.I.I.I.<.I.IXu LXA.E bXAXZ |._._._XZ.I._.I.uXZXZXZ.uX9XZ.!XZ.PXZ._ 0._., b.I.P $ ;.w.PXsX X .PXS.R.wX9.!XZ.P %  .:.wX .IXZXZXZ.!.Y.6.$XZ.)XZ.,._XZXZ.!.I.,.I.LXs l.%.$ l.:    .$.P.IX9.PXsX9.^.$.PX X X X X9Xs.PXs b &.n.n |.I.I.!.)XZXs h.I.I bX9XsX9._.| bXZXk L 0.b F F.,XZ.)XZX9X9XsXk bXsX9X9.IXh.$ bX9X ._.) b.I b.%.$XA LXz._.tXA.t.I.IXZ b.I bX9 b bXkXs.lX+XAX& zXA.*X<X@ OXAX@.* bXZXAXA.7.B.I.) LXZXA.h L d.<., b b LXAXZ._XAXZXZ zXA.) LXZXZXZXmX@.XX@XZ l.%.$.$.:     b.}.<XmX@XA.0.I.I.I.<.I.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.vX9 b b b.IX X9 b.t i i i i i i i i i i i iX8 i i i i i S i i i i i i i iX8 i i i i i i i i i i i i iXo S i i i iXo i i i i i i iX8 i i i i i iXo i i i i i iX8 i i i i i i i i i i i i i iXo i i i i i i i i i i i i i iXo i i i i i i i i i i i i iX8 i i iXoX8 i i i i i i i i S i i i i i i i i i i i i i.A i i i i i i i i i i i i iXo D i i i i i i i i i i i i iXo i i i i i i i i iXo i i i i D i i i i i i i i i i i i e.c i i i i i i i i i i i i i e i i i i i i i i i i i i i iXo i i i i i i i i i i i i iXo i i i i iXi.f.f.f.f.f.f JX9X9XsXs.!.PXsX9Xs.P.,._Xs.I bXZ LXZXZXZXAXAX@XZXZ b.I b., b.! b b.E b L.)XAXAXA.*.t.0 4XZXAXA 4.*XAXAXAXz.)XZ LXZXZ b.yX.X2.nXZXAXAX+XAXA L.) bXZXZXZ LXZXAXZXAXAX<X<.<.,. XZ LXZXA.aXAXA.= f f sXZXZXZ.). ., L b.)XZXZXA._.,XZ.!.IXZ.,XZXZ 0.,.,.!._.0.<X@._ b.P b._.0._., M.,XsX9.I.I.P.P.P.P.P.PXs b.I.P.I 0Xm N  Xh.! b b.! O }XS.'.:.).,XZ |.,XZ.,.I.I.P.I.IXsX9.%.(.,XZ.0.:  ./XZ b.I.I.P.P.P.PXsX9XsXsX X9X9Xs.,.YXj 8.I b b.IXZXZ.,X9 b b b.IX X9 b.tXZ.)XZXm._.Y.}XNXZ bXZ.<.I bX9 bXkX9X9XsXs.!.PXsX9Xs.P.,.L.iXS.m.: LXZXZXZXAXAX@XZXZ b.I b., b.! b b.E b L.)XAXAXA.*.t.0 4XZXAXA 4.*XAXAXAXz.)XZ LXZXZ b.yX.X2.nXZXAXAX+XAXA L.) bXZXZXZ LXZXAXZXAXAX<X<.<.,.6.( LXZXA.m  .B.= f f sXZXZXZ.). ., L.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXr.P b b.IXsX9XZ bXZ i i i i i i i i i i i i i i i i i iXo i i i i i i i i i i i i i i i i i i i i i i i i eXf.c e i i i i i i i i i i i i i i i S i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXf e i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXo i i i i i i i i i i i i i i i i i i i i i iXi i i i SXo < e i i i i i i i i i i i i i i.c i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.f.f.f.f.f.fX5 bX9.P._.Y & |X9X9X9 b.,.IXk L.) L bX+XAXm gXA.I b.I L b b L. XA 4X@XmXA L LXZXZ._XAXAXA LXA LXAXAXZ.h.).)XZXZ b.)XAXAXZ._ f._XAXA LXAXZXZXZXZ.) L.) b b 4XAXZXZXZ 4.=._XZ b LXAXA._XmXZXZ.0XZXAX@.b.bX@.0XZXZXA.) b.I L bXA._X@XZXZXZXZ._._XZ.0XZ.t.0XZX@X@XZXZX9.!XZXmXZ b.!.P b.!Xs.!.,.I.P.PX9.P.I.!.!XZ.,.!.7.A   h.) L.)XZ.:    .9 bX9.P.P.!XZXZ.!.I.I.!Xs.!., b }.A.mXu lX,.m.IXZ | b b.I.I.PXsXsX X X X X9.! |.I.PX..!.I b.! b b L.).P b b.IXsX9XZ bXZ._XZXZX9X+ gX  bX9.IX9 b b.IXZ bXs bX9.P._.Y & |X9X9X9 b %    .:.) L bX+XAXm gXA.I b.I L b b L. XA 4X@XmXA L LXZXZ._XAXAXA LXA LXAXAXZ.h.).)XZXZ b.)XAXAXZ._ f._XAXA LXAXZXZXZXZ.) L.) b b 4XAXZXZXZ 4.=._XZ %.S l.$.$.~ kXZ.0XZXAX@.b.bX@.0XZXZXA.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXr b.I b.IXs.!.I b.! i i i i i i i i i i i i i i S SXo S i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.cXf.A i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iX8X8 i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXfXo eXf i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i eX8XoXoX8 i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.f.f.f.f.f.fX9 bXs bXZ., | & bX9Xs b.I.I L L b bXZX@XAX@.0.)XZXA.IXk.) L.)XAXA.0.*XA.)XkX+ L.)XZ.0XZXAXAXA.*XAXZ LXZ LXZX@Xm., L.*X@.< g F.<.* 4XAXZXZXZXZ.!XZXAXA.hXAXZ LXZXA., L.=XNXs bXA._XZXZX+XA.)XAXAXZXZX< g g.aX@ 0XZ b bXs b bXZXm._.,XZ._X@._.0.!XZXZ.,Xm.0XmX@.<.!.I.I.!.,.)XsXZXs.!.IX9.P.IXs.^.P.PXs.I.I.I.I.I.I %.: %.:X&., b.,XB.m.VX9.PXs.IXs.I.I.,.I.P.P.I.I.I.I b.I.w.$.$.R.PXs b.,Xs b.I b.I b.I.PX .PX9XsXs |.PXsX9.IXs.I.I.IXZ.I bXZ b.I b.IXs.!.I b.!X@XA.)XA.=.)X9X9X9X9X .IX9Xs.I.).) bXs bXZ., | & bX9Xs bXS.m z L b bXZX@XAX@.0.)XZXA.IXk.) L.)XAXA.0.*XA.)XkX+ L.)XZ.0XZXAXAXA.*XAXZ LXZ LXZX@Xm., L.*X@.< g F.<.* 4XAXZXZXZXZ.!XZXAXA.hXAXZ LXZXA., L.=XNXs b.B O.$.$X+XA.)XAXAXZXZX< g g.aX@ 0XZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.7 L.I.P b.) bXZ bXZ i i i i i i i i i i i i S i i i i i iXo i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i S i i i i i S i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.@Xo i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXo i i i i i iXo i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXo i i i i i i S i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.f.f.f.f.f.fX9 bX9 bX9X9.P.P b b b L.).I L bXkXAX@X@.).hXz.).hXA b b L bXA._XAXA.)XA L b.I L bXZXmXA._XZXAX@XA.0 L.h. XAX@XZXZ L.0._.<X< F d.=X<XA L LXZXAXZ.h._ g g.a._.0XA L._._.*.a.!XZ.tXA L bXZXAX@.<._X@XZXm.0XZXmXl.b.) b b b b.!XZ.,XZXZXZ._.t.,XZXA._XZXA._X@._XZXZXZ.IXZ.IXZ.I.I.IXs |.PXsXsXs.PX9X9 b.I.I.I b.I.I.,XC g._Xm.,._.,.! |Xs.PXsXs.!._ 0XZ b.I.IXs b.PXs b.I.P._ b L.I.I.I.PXs.I.IXZXZ.I.!.IX9 bX9.^X XZ |.PXs.I b.).I.PXs b bXZ.I b L.I.P b.) bXZ bXZXZ 0XZ 4X@X9X9.qX9X9Xs b.IX9XsXZ.) bX9 bX9X9.P.P b b b L.).I L bXkXAX@X@.).hXz.).hXA b b L bXA._XAXA.)XA L b.I L bXZXmXA._XZXAX@XA.0 L.h. XAX@XZXZ L.0._.<X< F d.=X<XA L LXZXAXZ.h._ g g.a._.0XA L._._.*.a.!XZ.tXA L bXZXAX@.<._X@XZXm.0XZXmXl.b.).5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.7 L.IXs b L L.I.IXA i i i i i i i i i i iXo i i i i i i i iXo i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXo i i i i i i iXo i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.@X8 i i i i i i i i i i i i i i i i i i i i i i i i i i i i iX8 i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXo i i i i i i i iX8 i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.f.f.f.f.f.fXq b.IXZ L zX X  bXsXk.).I b., bXZ._., bXZX+XkX+.).hXZ.) L LXAXAXA 4.a.)XZXk bXm f bXzXZXZXZXAXZ 4X@.h 4XA d sXA LXZ._ 4Xz 4Xl d b LXz.,. .)XA bXZXm g.b.b MXAXA b b.!.b.0.yXZ.P.P.! b.)XZ._.0XA.0XZXZXZXm._.)XA g f f.,X9 b.,.! b._._XZX@.,XAX@._XAXZ.,._XZ.,.I b.I._.!XZ.IXZXZXZXZXZXZXZ.!.I bX9.PXsXsXs.,.I.! b.P.P.I.YXs.I.I._ |X9.P.I.I b.!XZ.IXZ.IXs.IXs bXs.I.I.,.t._.I.I.!Xs.P b.P.IXZ.! b.I.) b.YXCXjX6 oXsX9.P.P.P.IXsXs.I.I.) b.I b L.IXs b L L.I.IXAXA f.}._X@XZX9.q z z b.) b.PX9.).I b.IXZ L zX X  bXsXk.).I b., bXZ._., bXZX+XkX+.).hXZ.) L LXAXAXA 4.a.)XZXk bXm f bXzXZXZXZXAXZ 4X@.h 4XA d sXA LXZ._ 4Xz 4Xl d b LXz.,. .)XA bXZXm g.b.b MXAXA b b.!.b.0.yXZ.P.P.! b.)XZ._.0XA.0XZXZXZXm._.)XA g.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXrXs.I b.IXZ.,XmX@.t i i i i i i i i i i i SXo i i i i i i i S i i i i i iXo i i i i i i i i i i i i i.@ i i i i i i i i i i i i iXo i i i i e i i i i i i iXo e i i i i i i i i i i i i i iX8 i i i i i i i i i i i i i iX8 i i i i i i i i i i i i iXo i i iX8.@ i i i i i i i iXo i i i i i i i i i i i i iXo i i i i i i e i i i i i i iXf i i i i i i i i i i i i iX8 i i i i i i i i i i i i i i e i i i i i i i i i i i S iXo i i i i i i < i i i i i iXo i i i i i i i i i i i i i iXo i i i i i i i i i i i i i S i i i i i i.f.f.f.f.f.f OXsXs.)XZ LX9X9X9 bX9 L bXZXZ._XAXZ.I b b LXA bXAXAXA.) LX@._. XZXZXAXA.) b LXA._XZ bXZ b.)XAXAXZ 4 LXzXAXmXAXZ.0XA., L.hXzX@ 0.YXA._X@XZ.IXZXZXA._XAX@X@ g._.).IXZ._.b._.!.I bXZ._XZXA.)XA._XZXA._XZ.)XA.0XAXZ L LXm.b.a sXZXZ.I._XZXZ sXZ._X@ 0._.,XZXZ.!XZ LX@XAX@.I._.,XC.YXZXZ.I.I.I.!XZXZ.PXs.I.P.I 1 b.I b.I.PXZ s._.,.!XZXZ.!.P.I.!XZ.IXs.PXZ.I.IX .PX9.PXs.PX@ d._.I bXZXs.P b.!.I.I._.!.!._.nXwXe :.P.I.P bXs.P.I.I.I.IXsXsXs.IXs.)Xs.I b.IXZ.,XmX@.t g f.}X2.<XZX9X9.IX9XZ LXs.PX9XsX9XsXs.)XZ LX9X9X9 bX9 L bXZXZ._XAXZ.I b b LXA bXAXAXA.) LX@._. XZXZXAXA.) b LXA._XZ bXZ b.)XAXAXZ 4 LXzXAXmXAXZ.0XA., L.hXzX@ 0.YXA._X@XZ.IXZXZXA._XAX@X@ g._.).IXZ._.b._.!.I bXZ._XZXA.)XA._XZXA._XZ.)XA.0XAXZ L.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T 8X9Xs.IXZ.I.I.<.t.0 i i i i i i i i i i i < i i i i i i i iXo i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iX8 i i i i i i iXo i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.@X8 i i i i i i i i i i i i i i i i i i i i i i i i i i i i i e i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXo i i i i i i i i S i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.f.f.f.f.f.f J.IXs b.I.I bXs bXk bXZ.)XZXZXAX< b.I.I b b L bXAXAX@XAXz._XAXZ.) LX@.0 b bXk L.) 0.IXZXZXAXA.0XAXA.hXA.*XA._XZXm 0., L LXz.} c f._.t._.!XsXZXZXmX@XAXZ.)XkXm._ b 4 g.aX2XA.) bXZX@XZ LXZ._._.,._XAXAXZ.,XZ.0XZ.I.)XsXsX<.}XZX@._._XA._X@ MXA._XZ.) LXZXZ LXZ.I.0XZXZ b._.!.] &XA bXZ.E.)XZXZ._XZ.I bXZ.!.I.P.IXZ.! b.IXZ.<.! |.!.P.I.!.!.IXZ.I.I.I.I.IXsXsXs.P.I.P. XA._X@ b b.I b.P bXs b.).).I.) &.n.n |XZ.P bXZXs.IXs.I.PXs.P.I.IX9XZ.I.PX9Xs.IXZ.I.I.<.t.0 g fX2X6.n.<.IXs bXZ.).IXkXsX9.I b.IXs b.I.I bXs bXk bXZ.)XZXZXAX< b.I.I b b L bXAXAX@XAXz._XAXZ.) LX@.0 b bXk L.) 0.IXZXZXAXA.0XAXA.hXA.*XA._XZXm 0., L LXz.} c f._.t._.!XsXZXZXmX@XAXZ.)XkXm._ b 4 g.aX2XA.) bXZX@XZ LXZ._._.,._XAXAXZ.,XZ.0XZ.I.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T oX9.)XZX9.!._ b.)XA i i i i i i i i i i iXf i i i i i i i iXo i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXo i i i i i i iXf i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iX8X8 i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXo i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i e i i i i i i i i e i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.f.f.f.f.f.f )XsXZ b.I b bXkX9Xs.I.,XZ bX9XZ.)XAXZXZ.I.wXu.m.$.7 O./ LXAXA.)XZ.)XA.0.) L bXk.) L b.)X+XA.tXAXAXA.0._XZXZ L g.<X<XlXlXZ.$.}.}.b.a 4XAXZXZ.I.,.$.$ l lXZX. b L.h g F._ f gXZXA.).,XZ.0XZ L b.$._._XZ.,.;.^.$.u b b.).,.,.uXq.^.< v d.t.}.  OXu O O L LXZ.,.,XsXZ.Y.)XZXZ.b.<._XA._ O._.<XZ._._.).5 X.I.Y.I._._.>Xh.$XZ.<XA.I.PXS ;.RX9.P.I.I.P.!.I.PXh $ % R.)XZ._ L.) b.Y.!.!.I | | | | 1.P 1.k.k.!.P bXS l kXq.!Xh.P.I.!.I.P.PXs.IXsXs.PXsX9.)XZX9.!._ b.)XAXZXZ._Xw.Y 0.* bXc.u.IXsX9.PXs.I.! h l.m.L b.$XkX9Xs.I.,XZ bX9XZ.)XAXZXZ.IXs bX+XAXAXZXZ LXAXA.)XZ.)XA.0.) L bXk.) L b.).B.$ $ lXAXA.0._XZXZ L g.<X<XlXl.b f.}.}.b.a 4XAXZXZ.L k zXA J O.mXg b L.h g F._ f gXZXA.).,XZ J.$.m.mXZ._._XZ., 9.}XZXZ b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.uXZXA.I.,.0XZXZ._X@ i i i i i i i i i i i iX8 i i i i i iXoXi i i i i i i e i i i i i i i i i i i i iXo i i i i i i i i i i i i iXo i i i i iXo i i i i i e iXo i i i i i i i i i i i i i i.@ i i i i i i i i i i i i i iX8 i i i i i i i i i i i i i e i i iX8X8 i i i i i i i i e i i i i i i i i i i i i i.@ i i i i i i i e i i i i i iX8 i i i i i i i i i i i i iXo i i i i i i i i i i i i i i e i i i i i i i i i i i iXf e i i i i iX8 i i i i i i i S i i i i i i i i i i i i i iXo i i i i i i i i i i i i iX8 i i i i i i.f.f.f.f.f.fXq.IX9Xs b b b.I b L.! L.).IXkX9 b.0.)./.%   %.5.$.S  .|Xk.)XZ LXA.*.t. XZ LXZ b b LXA L.*X@._ 4. XA.) L._Xm._X@.< gX<Xl N  Xq.}X2.* g.a.,.!.IX9X& N  .( L L L. Xz.a d g g._X@Xm._ b._.u.m.%  .6XZ._ LXuXf.m l.A./XZXZXZ $.S.p.V.~.V.<XZ.a.~      .~ bXZXZ bXZ.,.P.I.I.,XA.0 z.m.6   NXZX@._XA l.S k.$.S h b.!.$Xf.$.$.~.$XZ.I R.A k $X, k.!.I bXZ.P.!XqX,  .m.!._._ b.P.PXZ & | | |.! 8 o.P.P.P.P.P bXs k.A %.$.:   % b.I.I.!XsX9X9X9.PX9XsX9XZXA.I.,.0XZXZ._X@.IXs._.,XAXZXA.:  .9 b.IXsXsX9 b.m.S % $.:  .:.I b L.! L.).IXkX9 b.0.).)Xs b._.*._XZXk LXk.)XZ LXA.*.t. XZ LXZ b b LXA L.|.(  .:. XA.) L._Xm._X@.< gX<Xl PXl f.}X2.* g.a.,.!.6  Xu b J.~  Xc L. Xz.a d g g._X@Xm._ b._.L.%  .: bXZ._ L.b.}.Y.IXsXZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.P s.!XA._XA LXAX@.0 i i i i i i i i i i i i iX8 i i i i e i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i e i i iXf i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iX8.@ i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXo i i i iXo i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iX8 i i i iXf i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.f.f.f.f.f.f J b b.IXs.IXs.!.IX+._XA b bXkX. LXZ.L.S   l.bX@XA lX, LXk LXk.)XA sXA.) L L.IXk.) L L b.)XA.0.0.hXmXZ._X@X@XA._X< f v.*.:.6 &.}.}.<.<X@ | &XZ.I z.(   l LXA.,._XA._., NXZ._.t.0._ bXZXAXm N  .m LXZ.$   N.<XZ   u bXA.<.S N._.t N.~X@._ l.%.6.6.6.mX@.0XZ.IXZXZXsXsXZ._XC._.)XA u   A._Xm.< l   N._XZ  .9 8XZ.S.6XZXA N.~XZ.P.A.6.!.P.6.~ |.I.P.Y.I.P.P.~  .V.I.,.!.I.P.I.IXw., |.PX9X9.IXs.PX Xs.IXZXB.S.6.I.P.I N k L.!.P.IX9 )X X X X9X X  s.!XA._XA LXAX@.0.I b.I.I.! L L l.6 lXZ b b bX9XS.S.6 b.IXs N }.!.IX+._XA b bXkX. LXZ._.6.uX@.bX@XA.) L LXk LXk.)XA sXA.) L L.IXk.) L.6.B.).(   l.hXmXZ._X@X@XA._X< f v.*XA.h.}.}.}.<.<X@ | &.:.6.$.) b.%  .B.,._XA._.,X@X@._.t.0._ bXZXA u   O.0 LXZ._.<.<.<XZ.!Xs.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T sXsXZ b.y b.*X@.,XZ i i i i i i i i i i i i i iXfXo e e i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXo e e i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.@X8 i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXo SXoXf i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i iXo e SXo i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.f.f.f.f.f.fXqXsX9.IXsXkXZ b bXk L g v._._.,XZ.|.S   %XA 4XAXA.B.(Xz.0Xk LX+XA.) LXA L LXAXZ bXAXAXAXAXA b b.I b.) b. .IXZ.).0.<X@.0XZX@.}.b.}Xl.a.0Xm.)XA | |.S  .nXC L LXAXZ._.:.6XZ.YXZXZ._XZXZ L.u     OX@X@.~   l gXZ  .~.}.b J  .6.}.b N.~._._.:.a g.0 bXZ b.I b.I L.IXZ bXZ._XZX@._XZ    .L.<._._.~   l.aXZ  .~.I.$  .%XAXZ.6.~._ O  .6._.t NX,.!._.P 1 |XZ.)  .~XZXZ |XsXsX X9.P | b.I.P.PX9X X  )Xs.P.I.).R  .~.PXsXZ } O.!.PXsXs.PX9XsXsX9 bXZ.<XsXZ b.y b.*X@.,XZXk bX9.) b b b b.IXAXZ.) LXsX9 $  .%X9.IXs % O b bXk L g v._._.,XZ L.: NX@XA 4XAXA b.)Xz.0Xk LX+XA.) LXA L LXAXZ b.(.6XAXA.S  .B.I b.) b. .IXZ.).0.<X@.0XZX@.}.b.}Xl.a.0Xm.)XA | | & |  .~ L LXAXZ._.<XAXZ.YXZXZ._XZXZ L  .S.*.,X@X@Xz.tX@ gX@X@ f.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX4.I bX9 b.*X@ bXZ.) i e i iXo i iX8 i iXo i S i iX8 i iXo i i S i iX8 i iXo i < i iXo i i e i i S i iXo i iX8 i iXo iXo i iX8 i iX8 i iX8 i i e i iXo iXo i iXo i i S i i e i iXo i i i e i e i iXo i i S i i S i i S i i e i i i iX8 i i e i i e i iXf i i.A.%XoX8 iX8 i iXo i i e i iXo i iXo i iXo i i i iXo i i < i iXo i iXf i i S i iXo i e i iXo i iXo i iXo i i e i iX8 i iX8 i iXo i iXo i iXo i i S i iXo i i i iXo i i S i iXo i i S i iXo i i S iX8 i iXo i i S i iX8 i iX8 i i e iX8 i iX8 i i S i iXo i iXo i i.@ i i i.f.f.f.f.f.f OX9 zX9X9 bX9XsXs zX9X@.a.,.)XZXZ.:  .S Q 4 4 LX+XZ.$XA L.|Xc.:.: z._XZ.5 k.: l l.6.mXZ O.:.: L z.(.$./.$ n l J.(./ O.C.:.$.} FXq n % RXvXhXZ.Y.V  .%X6 r N lXA.$.~  .6.m._ bXZXZXZ.)XA l  .~ 0 v.a    .LXm.$  .~.*.*.Y    Xu b   kXZ O  .~.: wXA bXZXmXZ. XZ.I._ |.IX@.*X@ 0Xh  .~._X@._X@    .Y v.$  .~X@.u     l z   l s.u     ; o   k |XZX .PX9._ k  .9 R.6 k b.V.9.9X9X .9.w.I.PXsX X9 b.I.PXs.!Xh    .(.!.).IXZ.L A.9.9 )Xs % uX9.w.m.: l l.6 %.*X@ bXZ bXc.i.:./X9X&Xu.:.:XA L L b b b.$     NX9X9 bX9.w $.(.9X@.a.m.:XZ.$.~  .6 E 4 4 z.: N.$.:Xu.|Xu.m.: L.$ N lXZ b.$X,  .6 k O  .~ L l N lXZ.I. XA.B.: N.$ n.$.L ;.f f Q.9.XXt ;.: ; | | r  .9.m.6XuXA.B O.:.:._ b.m.:XZ.)Xu   NXA 0 v.a b.I.IXmX@Xz.*.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T y bX9 bXl CXsXs.I.I i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i SX8 i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.f.f.f.f.f.fX5 zX  zX9X9 zX9Xk mX+XAXA. XAXZ b    .:X@ s.*XZ. X+ L.)X&.SXcXA.6.S.NXZ J.%  .:.:.S  .l O.S   b n  .:./.~  .:.S  .: O.%  .m.b %  .q.<  .S.6XZ.Y.m   % % N  .~XA z.%   k O M.)XmXAXAXA.*.m  .9.< fXA    XZ.a.:  .6XAXA f.m     N bXAXZ %      .S.BXZ.).<.,.,.)XZ._._.I g.a.0.n %  .:.< v.0XA    XA f %   N._.t %     N./.t._._.:    .6.w.P.!.,.!Xs.!._.:  .6.9.A  .$.R.A  .r %  .9.P.P.P 1.IXZXs.IXs.PXs N    .6.uXZ.I.L N   NX9.w  X,XZ O.%  .:.9.S  .$XsXsXh.S.mXZ.6.A JX&.(   NXAXA LXk bX9X9 u    .6 JX9 z.$ N   NXA.B  .~XZ./.%   l./ s z.S u L.S  Xu.B.(  .(.m U  .~XAXZ./.%   k p.m  .:.: u  X,.) bXZ O.S.(.|.S  .$.5.S  .<.X  .9./.%   k._.].9  .6 %.S  .5.u N   N M./  .~XAXAXc   ;.Y.< fXA.)XZXZ.a.aX< L.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXr gXlX@ b bXs.IXsXs i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i D S i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i i.f.f.f.f.f.f.P bXsX9Xs.PX9Xs.P.I.IXZ.) b L L l     l.h LX+XAX@XAXA.y.S.~XA 4.6  .$.) b.~   l.h.6  .:.<.:   lXA N lXZ.%  .: z.:.uXA.%  .L J  .6.b.v     bXZ b N  .9.L ;   N._ L  .S 4 M 0XZXA._._Xe.G.~   l LXZXAX,  .uX@Xf  .m b.) b.m.~  XfXt.=X@XA.aXu.S  .iXA.!.,.,._._.0.<XAX@X@X@.b.<.~   ;.0._X@Xm.~  .hX@.S  .m._.7.m.~  .S.L.0.,XZ.m.~  XfX9.,XZ.!XZXZ., |.A  XhXZ.6  .m.P.:  .w b u.mX9X .IXs bX9X9X X9 b.IXS.6    .%.!XZXZ.9   RXC.m  .:X9.YX,  .pXl N  .:XsXS.AXf b.I.6  XuX9.:  .mXk LXZ L.PXsXZ |.6    .%.PX9Xs.(  .mXZ.m  .: LXZ  .SXA.h z.S.~X@XA  .SXk.).(  .:.LXu  .6.).).)  .S L L.(  .( OXu   NXZXZ.w.SX,XAXZ  .SXZ.I N  .P.b.( %XZ.~  X&XZ.a.S  Xh 1.6  .mXZ.(   $ 0.m   %._Xe.~  .uX@ LXZXA.IXZXZ.b gX@XZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T._X@.) b.I.IXsX9.PX9 b.I b b b.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.^X9XsX9X9X9X9X9Xs.PXsXZ b b b L.:    .$ L.)XZXAX+XAX@.:  .:XAX@X,  Xu.) z  X, LXZ.%  Xu._.m  .( L.(XSXB  .SXu LXZXZ.X  X,.) R  .mX@ k   N bXZ.      % |.9  XX._ l  .i.< |.!XZXA._._.n 8    .7XZXAXZXh N.~.6  .S.B b.$X,.m w.6   NX@._._.bXl.q   u._.$                 OX@ v.H    .7XA v gX@./.(.~.%  Xf.uX9.~ R.>.%  .(.Y.L.~ %.u.%  .(.!._._.,XZ.YXh  .%Xs.P.6   ;._.m   %.P.( hXsXsXsXsXZ.P.PXsX .PX9XsXs.(     %.^ |.A   O.P.~   X.,X   .~X@.).~  .$Xs.9  .9 b.IX,  Xu.I.~  X&X9.) bXsXkXk., |X9 u     %X9X9.A   hXZ.~  Xu LXu  .(XA L.(   lX+.$  .( LXZ.~  .:.y.(  Xc b L l  .( b L     %.y.(   %.!.).(  .mXZ.$  .( L.)XX  XqX@ N.B.u  .~. XA./  .%.Y.) u  Xu.hXf  .P.!.%   O._ 8  .~X@XAXZXAXZ.I.,XmX@X$X@ b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX<XZ b.I.I.PX9X9X9X9.!.I.P.PX9.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f OX9X9X9X XsX9X9 b b b.0XZ.).) L.:    XA.h L L.) L L._.~  Xu.h b    .7 L k  .:XmXS  .S m.0Xu  .6.$.:.I l  .~ L bXZ.I.m  .:XZ b.S.(.E.~.%./.).!Xh  .S wXZ.S  ./XZ %   ;.Y.Y.Y.PXZ._ 0Xw.m  .%.,.).,XZ bXZ bXf   l.0.0.6Xf b.).E    ._XA.0.b fX@   N.=./ % %.:.: } % U %.u.< 0 k  .6X@.t.b.t.tX@X@.&.S  .$XA N.~.<.I.u    XZ N.~XC.nXq    X2.n.n.,._.,.9   %.P.B  .AXs.) O   N.L.9XsX Xs.P.I.I bXZ.!.P.$X .P.IXs N  .%.P.$  .~ bXu  .S._ 0 k  XcXZX&  .SX X9X,   l.!.L     J h  X, bXs bX9X9Xk l.PX9X9X9 N  .%X9.$  .~ b O  .S.) L.:  .mXA.|     b L.(   ;XA z     b.).S  ./XAXA n  .m.).z  .S.7.).A  .L b.B    .BXZ.(  .m bXZ %   J U.$.I k  .i., L.:  .m._.|  .SX@Xt  .%.YXh  .S._ 0.f   %XA.,.).,XZ bXZX@.t 4._.0.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.vXAXZ.).I.I LXZ.I.I.I b.I.I.I.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.fX X9X9XsXA.) b b b b b.)XAXZXk.h.5    Xu L LXA.h L J.)    ._XA k  .9.0. .(  XuXZ.:   %X+XZ L  .S.:X& L.(   %.tXA L L.(   R./.|.:Xu.:.5XZ.yX..y.:  .:X@Xu  .~.NXZX,  ./.X.<.b &._XZXZ | u  .:.0.,.I.!XA.a.6  .(.0 bXk  .6 L.,.<  .~.0._XA.t.b.a   %Xm.aXZXA.a.< s 0XZ 0.a v.<.(  .f.<X@ g._.<.<XC.6  .i.,.t   NXZ.I.P  X,XZ  .6 &.]._  .~XZ.P.P.!.I.I.%  Xh.0 l  .iXZ.<XZ  .A.:X&.!XZXZ.!.!XZ.I ).P.P.i $.PXs.I.$  .6.I.9   %X9 N   u.I.I.:  XhXA.:  .:.I L    .I.I.m  .(.I k  .( bXsX9Xk b b.9.p.PX9X9 $  .6 b.:   % b N   N.y.hX,   zX&Xu  .6.h L.S  .y.h.m   N.).R  .% L.) b.~  .IXS.:  .: L ;  .~.| bXu   uXA.|.S   bXsXZ.:  .:.:.*XZ.(  .m./XZ.%   z.0.m  .m b.:  XX.<.(  .(.uXZ N  .$.B.0.,.I.!XA.a.a.IXA.0 b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXr LXAXA._.,XZ.0XZXZ.!.) b.I.I.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.fX5XsX9XZ.<XZXk b.) b.) LXZ.)Xz.h L.6   N LXZXA.B u z L.S  .)X+.~.%.u._XA.S   L.7.S.%XZ bXAXA.%  .: b.IX,  .XX< L L bX,  Xu % N  .:.$X@._Xk.h b.%   J._.:  .: % 1  .S.$ R LXm.,XZXZ._.I.S  .$._XZ b.).N.6.S } bX@ bXs N.% bXZXq   % z.S u g.< k.6.<.a.a._._.,.! 8.,.PXZ._.0XZ.S  .^._._.,XZ.<.I.%.S l._.Y &.(.% |.P.L  .9.I N.%XZ._XS  .:XZX  bXZXZXS  .S bXB.~.9.Y.P.IXC.%  .: b.I.,.,.I &., |XZXZXs N.( b.I.! }  .m.P.6   k.9.9   %.:.!.S  XZ.|.S.%._.,XZ.S  XZ.!.~.~XS.I.(   k.)XkX9XsX9X9 N.:XsXsX9 k   kXk.6   l.:.:  .: n z  .S l lXu  .%XA n.S.~Xu l N   $.0.:  .:.:XZ z  .SXu l.~   J._.:  .:.: bXu  .6 L.:.S.~ $ l.I.:  .:X@X@._X,  Xu.m.7  .S.hXZX,.:XCX9.6   R.: n  .:.:._.~  .$.m._XZ b.).t.bX@Xs bX@ b.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T o.! L.I bXsXkXsXZXZ b.IXk.P.I.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.f.fXqX XZ.a.a b b b b b b L L LX+ L.h.|.(  .%.: N.6.BXZXk.m.S l.(.6.7XZXA J    .:.% N b.)Xk.).,.6X,.7XZ.$  .6XAXA L.) bX,  .(X9.m.S    .S % z L.|  .SXZX+.m  X,.q.I.S  Xc._XZXA._.,._.:.6     N kXA.u.: N k.I.I bX@.I b.$.%.: k.%.:.,.u.~  .(.: %XZ.] s._._ 0XZ.,.P 8 1.PXs.i N    .( lXZ.&XZ %.6 k.v.<.I._.! o.% % $.%.iXs.I O.%.: l.6.:.).0Xs., bXA./.~.~ l.%.9XZ.!.! |.!.6X,XS.I bXs.I.IXC &., |.Y.,.6.%.(.$.m.A %.IX9 u  X,.$X;  X,.RXh    .9.% NXS bXsXk }.S l.(.6.y.P.IX,   zXZ bX9X9Xs.I.6.%.( k k.S.m b b.(  X,.$Xc  X, J z.S  Xc L b.%  .~ J.S  .m.).S  .7XA.m  .~.LXA z.S  .m b  .S.,., %  .~.$ b.K.%  X, O.S   }XZX9.:.:Xl.*X<._X,  .( LX&.~.~Xu.6.:Xm s b.(  .~ O.m  .~.LXZ.~  .:XZXZXAXZ.)X@.a.,.I bX@.I.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T 8.).IXs.I bX9.I.!XZXZ.0 LXk b L L.IXA z b bXZ.,XsXk 4.h 4XzXAXsX9Xk b bXk LXAXA L L.h b.)XZ.)XZ.)Xk.h._.y L.).0X+XmXAXAXAXm.,XAX+.hXA., LXk.)XAX@ LXZ.*.}.a.IX9X9 bX9.P bXAXAXA LXz.bXAX@X@XA b LXZ.) LXAX+ L.*XA.tX9 L.I bXAXA.nXZXZX9Xs.)XZXA._XAX@.aXZXZ.I.I b LXZX9X9X9.I._.)._.tX@XZX@.<.a._X@XCXs.IXZ.P.P.P.,.I.I.I.IXZXZ.!._.n.t.,.!.P.& 0 0.,.Y 0.Y.! |._.PXZ 0.!.,.)XZ.).0XZ.)Xs.).!.IXm._XmXZ.!.PXZ.I.IXm.I )XZ.PX9Xs.Y._.!XZ.,XAXZ 0._X@._.,Xw | : | y._XZ b b.  v.IXZ | 1X X@.^ b.P.).IXs.I bX9.I.!XZXZ.0 LXk b L L.IXA z b bXZ.,XsXk 4.h 4XzXAXsX9Xk b bXk LXAXA L L.h b.).u.$.$./Xk.h._.y L b O.BXmXAXAXAXX  .: J zXA., LXk.)XA NXuXZ.*.}.a.IX9X9 bX9.P b.BXAXu.~.z.$.(     J b LXZ.) LXAX+.5.*XA.t J.|.I bXAXA.nXZXZX9Xs.)XZXA._XAX@X@XZXZ.I.I b LXZXsX9X9.$.$XZ.)._.tX@.$ O.<.a._X@XCXs.IXZ.P.P.P.,.I.I.I.IXZXZ.!._.n.t.,.!X .& 0 0.,.Y 0.Y.! |.L ;.u 0.!.,.)XZ O O.u.)Xs.).!.IXm._XmXZ.w ;XZ.I.IXm.I )XZ.6 lXs.Y._.!XZ.,XAXZ 0._X@._XqXw.P XXh @._XZ b b p v.IXZX  1X .m  .:Xh./.IXs.I bX9.IXB.$./.0 LXkX&  .~.IXA z b bXZ.,.wXk.KXu.5 mXAXsX9Xk.$ bXk L.BXA L L.|.B.)XZ.)XZ.$Xk.h.uX& L.).0X+XmXAXA JXm.,XAX+.|.7., LXk.)XAX@ L O.*.}.a.IX9 l bX9.VX&XAXAXA zXz.bXAX@X@XAX& LXZ.) L J.$ L.*XA.tX9 LXh bXAXA 8XZXZX9 h./XZXA._XAX@.aXZXZ.I.I b LXZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX4Xs.P.I bXAXZXA.0.I L b., b L.I b. XZ.I bXZ.IXZXZ L g f.*X@ L b bXs.IX9 b L._ L L.)XAXk L.).)XZXZ.h.)XkXk LXAXk LXA.h 4.hXA._XZXAXAXA.) LX+.) L.)XA gX<X@ L.& z L bXsXsX  bXA.)._XA.b.)XA.*.0.IXk L b L b b L.b f.} bXZ b b.I. .} | b.I.IXZ._._XA._XC vXZ._._XZ.! LXZ.I.IXsXZ._.tX@.<.a._ vXZ.YXZ.,.Y.IXZXZXsXs.P.!.!.!.!.PXZ.!.!XZXj 0._.P.IXZ.! |XZXZ.Y.! |XZXZ.!.,.< 0XZ b.)XA.0XZXZ b.!.,.!.,.,._ |.!.I.I b.I.,.PX9.I b.P._X2.Y bXZ.,.<XC.)._XCXC | |.!.P.P.P.,.I.!.,.,.I.IXsX X X9XZ.P.).IXs.P.I bXAXZXA.0.I L b., b L.I b. XZ.I bXZ.IXZXZ L g f.*X@ L b bXs.IX9 b L._ L L.)XAXk L.).)XZXZ.h.)XkXk LXAXk LXA.h 4.h N  .$XAXAXA.).5.m b.m.:XA gX<X@ L.& z L bXsXsX  bXA.6.:XA.b.).:  XS.IXk L b L b b L.b f.} bXZ b b.I. .} | b.I.IXZ._._XA._XC vXZ._._XZ.! LXZXZ.I.IXsXZ._.tX@.<.a._ vXZ.YXZ.,.Y.IXZXZXsXs.P.!.!.!.!.PXZ.!.!XZXj 0._.P.IXZ.! |XZXZ.Y.! |XZXZ.!.,.< 0XZ b.)XA.0XZXZ b.!.,.!.,.,._ |.!.I.I b.I O % J.m.:.P._X2.Y bXZ.,.<XC.)._XCXC | |.!.P.P.P.,.I.!.,.,.I.IXsX X X9 N  .$.IXs.P.I bXAXZXA.0.I L b N.$.m  .m. XZ.I bXZ.IXZXZ L g f.*X@ L b bXs.IX9 b L._ L L.)XAXk L.).)XZXZ.h.)XkXk LXAXk LXA.h 4.hXA._XZXAXAXA.) LX+.) L.)XA gX<X@ L.& z L bXsXsX  bXA.)._XA.b.)XA.*.0.IXk L b L b b L.b f.} bXZ b b.I. .} | b.I.IXZ._._XA._XC vXZ._._XZ.! LXZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T oX X9X .IXZ.,XZ b b L.)XA.) LXZXk L bX9 bX9 zXsXkXAX@.aXlX@.h.)Xs b b bXZXZXZXkXk LXk.h L LXZ.) L LXAXA.3XkXA.h.h._ 4XAX@XmX@ 4X+XAXAXAXzXZXzXZ.I.a._.)XZ b L b.)XZX9Xs.PXZXAXm.0X@XlXZ bXZ._ b.I.,XZXZXZXm._ f.}.}XZ.)XZ bXA 4 F &XZ. XZXZXA._XZX@ 0.a.aXl._.!.I L.IXZ b.IXZ._X@.<._._.!.].I.,.Y bXsXZ.I.! ).P.P.P.P.).Y.P.P.IXZ._XCXy 0Xs.!.,.,XZ |.Y |.!.!XZ.,., 0._._XZ LXZ._._.0 b.I b.I.PXs b.!.!.PXZXs.PXs.P.!.PX .!X9.WXj.!XZ.) |._XZXZ.I.P 8.I.PX9X X X XsX X9XsXZXZ.^X .!X9Xs., b bXsX X9X .IXZ.,XZ b b L.)XA.) LXZXk L bX9 bX9 zXsXkXAX@.aXlX@.h.)Xs b b bXZXZXZXkXk LXk.h L LXZ.) L LXAXA.3XkXA.h.h._ 4XAXZXf  .|X+XAXAXA n    .:.I.a._.)XZ b L b.)XZX9Xs.PXZXAXX.S lX& lX, k._ b.I.,XZXZXZXm._ f.}.}XZ.)XZ bXA 4 F &XZ. XZXZXA._XZX@ 0.a.aXl._.!.I L.I.IXZ b.IXZ._X@.<._._.!.].I.,.Y bXsXZ.I.! ).P.P.P.P.).Y.P.P.IXZ._XCXy 0Xs.!.,.,XZ |.Y |.!.!XZ.,., 0._._XZ LXZ._._.0 b.I b.I.PXs b.!.!.PXZXs.PXs.9    .9.!X9.WXj.!XZ.) |._XZXZ.I.P 8.I.PX9X X X XsX X9XsXZXZ.^X .!X9 h.S  X&XsX X9X .IXZ.,XZ b b L b  .:.6.(Xk L bX9 bX9 zXsXkXAX@.aXlX@.h.)Xs b b bXZXZXZXkXk LXk.h L LXZ.) L LXAXA.3XkXA.h.h._ 4XAX@XmX@ 4X+XAXAXAXzXZXzXZ.I.a._.)XZ b L b.)XZX9Xs.PXZXAXm.0X@XlXZ bXZ._ b.I.,XZXZXZXm._ f.}.}XZ.)XZ bXA 4 F &XZ. XZXZXA._XZX@ 0.a.aXl._.!.I L.I.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX4XsXs.! b.)Xs.P b.I., LXZX+ bXZXAXA.)Xk.I b.! b L LX@ f f._.I bXA gXZXAXZ.,XZXkXkXkX+Xk.yXk L.) LXAX+.)XA.).hXAXA 4 L L.0X+.h 4XA 4X@.0X@.0XA.,._. XAXAXA._ b.,.!.I bXs._ b.y LXZ bXsX@XAXA._.IXs.!.IXs.<.<._ s f.G.a.,XZXZ c.b dXZ.IXZXA._Xm._._ |.,.*X@X@.,.!._.I.I b.P.Y.,.0.<.0 b 1.PXs.^.I.! &.!.!.,.I.IXs | | 1.PXsX9.P b.^.P.I &.,.,.P.!.!.!., |.P.YXCXC.!.!.I.,.I.,XA.PXZ.Y.P.I.I.P.! b.P.I.!.I.P.I.IXsX9.P.^X X XsX9XsX9.P 0.!XZ.< 0 bXZXZ.!.!.P.IX9XsXZXs.I b.I.!.PX9.PXs ).0.IXs b.IXsXs.! b.)Xs.P b.I., LXZX+ bXZXAXA.)Xk.I b.! b L LX@ f f._.I bXA gXZXAXZ.,XZXkXkXkX+Xk.yXk L.) LXAX+.)XA.).hXAXA 4 L L %.:.:Xc.B 4X@.0XZ l.B.,._. XAXAXA._ b.,.!.I bXs._ b.y L./Xu $ OXAXA._.IXs.!.IXs.<.<._ s f.G.a.,XZXZ c.b dXZ.IXZXA._Xm._._ |.,.*X@X@.,.!._.I.I.P b.P.Y.,.0.<.0 b 1.PXs.^.I.! &.!.!.,.I.IXs | | 1.PXsX9.P b.^.P.I &.,.,.P.!.!.!., |.P.YXCXC.!.!.I.,.I.,XA.PXZ.Y.P.I.I.P.! b.P.I.!.I.P.I.IXsX9X .mXhX XsX9XsX9.P 0.!XZ.< 0 bXZXZ.!.!.P.IX9XsXZXs.I b.I.!.PX9.PXs ) %.:.9.:.LXsXs.! b.)Xs.P b.I., L./.: lXZXAXA.)Xk.I b.! b L LX@ f f._.I bXA gXZXAXZ.,XZXkXkXkX+Xk.yXk L.) LXAX+.)XA.).hXAXA 4 L L.0X+.h 4XA 4X@.0X@.0XA.,._. XAXAXA._ b.,.!.I bXs._ b.y LXZ bXsX@XAXA._.IXs.!.IXs.<.<._ s f.G.a.,XZXZ c.b dXZ.IXZXA._Xm._._ |.,.*X@X@.,.!._.I.I.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TXr.I.).I.) b.I.)XsX9 b b bXAXAXA bXkXs z b L.I bXk.*.b.aXlXl.<. .b f.t._XZ.0X+.) m.h.)Xk L.3.h.) L.).) L.).hXAXA 4 4.hXk. XAXA.h 4X@ 4._XAXAXAXA.,XZXA |.,XC :.!XA._XZ., bXZXk b.!.P.!X@.<._XZ.P.I.!.PXZ., |XZ.  f.} v._XZX@ f.b.}XZ b.!.IXZ.0XA.YXZ._XZ.*.tX@.!XCXC.P.!.I.PXZXZ |.!.I.PXs.PX  )Xs.!XC.!.I.P.!., :.E |.PXC.IXs.PXs.P.P., &.P.P.!._.Y |.P.P.I s.PXZ o.P.Y., :.P.Y.I.IXs.!.P |.P.P.PXs.P.!XZ.I.!.PXs b |.!Xs.I.PX9 ).!.!.P bXC._.)., 0.,._XC.I.P.I.YXsXZ.,.IXZ.I b.PX9X@.)X Xs.IXZ.I.).I.) b.I.)XsX9 b b bXAXAXA bXkXs z b L.I bXk.*.b.aXlXl.<. .b f.t._XZ.0X+.) m.h.)Xk L.3.h.) L.).) L.).hXAXA 4 4.hXk. XAXA.h 4X@ 4._XAXAXAXA.,XZXA |.,XC :.!XA._XZ., bXZXk b.!.P.!X@.<._XZ.P.I.!.PXZ., |XZ.  f.} v._XZX@ f.b.}XZ b.!.IXZ.0XA.YXZ._XZ.*.tX@.!XCXC.P b.!.I.PXZXZ |.!.I.PXs.PX  )Xs.!XC.!.I.P.!., :.E |.PXC.IXs.PXs.P.P., &.P.P.!._.Y |.P.P.I s.PXZ o.P.Y., :.P.Y.I.IXs.!.P |.P.P.PXs.P.!XZ.I.!.PXs b |.!Xs.I.PX9 ).!.!.P bXC._.)., 0.,._XC.I.P.I.YXsXZ.,.IXZ.I b.PX9X@.)X Xs.IXZ.I.).I.) b.I.)XsX9 b b bXAXAXA bXkXs z b L.I bXk.*.b.aXlXl.<. .b f.t._XZ.0X+.) m.h.)Xk L.3.h.) L.).) L.).hXAXA 4 4.hXk. XAXA.h 4X@ 4._XAXAXAXA.,XZXA |.,XC :.!XA._XZ., bXZXk b.!.P.!X@.<._XZ.P.I.!.PXZ., |XZ.  f.} v._XZX@ f.b.}XZ b.!.IXZ.0XA.YXZ._XZ.*.tX@.!XCXC.P.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX4 b.! b.,XZ.! L.I.IX9X9X9 bXAXZXA L L.y b z.I b bX@ L.yXlXlX@.t f.W.t s._XA LX+.).I b.I.I L LXk.) L L LXk b LXz 4.hXz.).hXAXA.hX@X@ 4X@.*X@ L.hXAXs bXs., |.,XA._XZXZ._.Y.IX9X9XZ.!XsXA.t._XZ b.Y.).!.tXZ.!XZ._.b.} fX@.*XZ._ g F |XZ.!.).EX@XZ :XZ.).0.*.<X@.t.}.}XZ 0XZ.,.!XCXZ._.I ).PX Xs.^.^Xs o.PXsXZX .PXsXZ & : 8.I.PX9.!.I.I b._X  ).P._.!.I.! b.!XZ.IXZ.I.!.P.! | 1.!.P.!XZ.I.P.PX9Xs.PX Xs.I.PXZ.!.IXsXsXZ.I.PXs.IX X9., ).P.P 0XZXZX2._.IXZXZ._XZXZ.,.I.!.I b.P L.!.).P.0.qX  b.I.I b.! b.,XZ.! L.I.IX9X9X9 bXAXZXA L L.y b z.I b bX@ L.yXlXlX@.t f.W.t s._XA LX+.).I b.I.I L LXk.) L L LXk b LXz 4.hXz.).hXAXA.hX@X@ 4X@.*X@ L.hXAXs bXs., |.,XA._XZXZ._.Y.IX9X9XZ.!XsXA.t._XZ b.Y.).!.tXZ.!XZ._.b.} fX@.*XZ._ g F |XZ.!.).EX@XZ :XZ.).0.*.<X@.t.}.}XZ._ 0XZ.,.!XCXZ._.I ).PX Xs.^.^Xs o.PXsXZX .PXsXZ & : 8.I.PX9.!.I.I b._X  ).P._.!.I.! b.!XZ.IXZ.I.!.P.! | 1.!.P.!XZ.I.P.PX9Xs.PX Xs.I.PXZ.!.IXsXsXZ.I.PXs.IX X9., ).P.P 0XZXZX2._.IXZXZ._XZXZ.,.I.!.I b.P L.!.).P.0.qX  b.I.I b.! b.,XZ.! L.I.IX9X9X9 bXAXZXA L L.y b z.I b bX@ L.yXlXlX@.t f.W.t s._XA LX+.).I b.I.I L LXk.) L L LXk b LXz 4.hXz.).hXAXA.hX@X@ 4X@.*X@ L.hXAXs bXs., |.,XA._XZXZ._.Y.IX9X9XZ.!XsXA.t._XZ b.Y.).!.tXZ.!XZ._.b.} fX@.*XZ._ g F |XZ.!.).EX@XZ :XZ.).0.*.<X@.t.}.}XZ.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.TX4 b.,.IXAXZ.IXZXZ LXs.I bX9X9.)Xk b.IXZ.I b L LXZ b.IX9 L gXlXl.}.} f d._._X@XZ b.IXs bXZXZ L.) L.)XAXA LXZXA.= 4XzXAXZX+X@XA 4 gX<.t 4.*.0 LXAXZ.,.!.<Xs bXZ.!XZ.P.IXZ.I.,.IXZ._XZ.I.!.I.!., b.,.<XZ.!.Y.Y.,X9Xl.} f.<XZXZXm.b.<.!Xs._.0XZ.,.YXZ._Xm.0XZXmX@ g.t s.Y.<._ b.!.Y.,.Y ).P oXsXs.^.PXs.I.P.P.PXs.^.PXs.I.P.!.! b.0XZ b., 8.P.,Xs.P.P.PXs.I.!XZ.I.,.Y |.P.,.I |.!Xs.Y 0 : &.YXs.! | 8 oXs.PXs., 0.!.!.,XZ.!.P bXs.!.!.IXsXsX .! b.,.)XZXZXZ.IXs.IXZXZ.)XZXZXs.P._ 1XsXs.I.I |XZXZ.I b.,.IXAXZ.IXZXZ LXs.I bX9X9.)Xk b.IXZ.I b L LXZ b.IX9 L gXlXl.}.} f d._._X@XZ b.IXs bXZXZ L.) L.)XAXA LXZXA.= 4XzXAXZX+X@XA 4 gX<.t 4.*.0 LXAXZ.,.!.<Xs bXZ.!XZ.P.IXZ.I.,.IXZ._XZ.I.!.I.!., b.,.<XZ.!.Y.Y.,X9Xl.} f.<XZXZXm.b.<.!Xs._.0XZ.,.YXZ._Xm.0XZXmX@ g.t s.Y &.<._ b.!.Y.,.Y ).P oXsXs.^.PXs.I.P.P.PXs.^.PXs.I.P.!.! b.0XZ b., 8.P.,Xs.P.P.PXs.I.!XZ.I.,.Y |.P.,.I |.!Xs.Y 0 : &.YXs.! | 8 oXs.PXs., 0.!.!.,XZ.!.P bXs.!.!.IXsXsX .! b.,.)XZXZXZ.IXs.IXZXZ.)XZXZXs.P._ 1XsXs.I.I |XZXZ.I b.,.IXAXZ.IXZXZ LXs.I bX9X9.)Xk b.IXZ.I b L LXZ b.IX9 L gXlXl.}.} f d._._X@XZ b.IXs bXZXZ L.) L.)XAXA LXZXA.= 4XzXAXZX+X@XA 4 gX<.t 4.*.0 LXAXZ.,.!.<Xs bXZ.!XZ.P.IXZ.I.,.IXZ._XZ.I.!.I.!., b.,.<XZ.!.Y.Y.,X9Xl.} f.<XZXZXm.b.<.!Xs._.0XZ.,.YXZ._Xm.0XZXmX@ g.t s.Y.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.7XZ., bXZ.) b._._Xm b b b b.I.! b bXZXAXAXZ LXk.I bXs b.=.a.bXl.}._.} fXm 0Xm LXZXZ.I L.).) LXZX+ L 4X@XA 4.= 4XAXA._X+.)XAX+X+X@.<X@.hXA.)XAXZ.).<._X@XZ b._.IXZ.I |XZ L.,.Y.Y._.! b |.!.!Xs.!XZ.,.I.!XZ.<.I.E f.}.b.aXA._ v.a.0.IXZXAXAXZ.Y.0 LXZXAXA.).)._ 0.Y.tX@XC |XZ.,.!.P.!Xs.^.PX .!.P.P.P.^.PXs |.PXs.P.I.!XZ.,XZ.,.!.!.,.PXs.P.Y.I ) b.I.P.IXZ |XZ.Y.,._XZ.Y 1.! |.! |.I.P.P.!.,.P b.I.^.P.!.!.!.,.Y.I.!.!._ b.I.! :.PXs.P.PXsXZ.I.I.!XZ.Y.PX9.PXZ.!.I b.)._ b b.Y.IXZ.P.,.E s.IXZ bXZ., bXZ.) b._._Xm b b b b.I.! b bXZXAXAXZ LXk.I bXs b.=.a.bXl.}._.} fXm 0Xm LXZXZ.I L.).) LXZX+ L 4X@XA 4.= 4XAXA._X+.)XAX+X+X@.<X@.hXA.)XAXZ.).<._X@XZ b._.IXZ.I |XZ L.,.Y.Y._.! b |.!.!Xs.!XZ.,.I.!XZ.<.I.E f.}.b.aXA._ v.a.0.IXZXAXAXZ.Y.0 LXZXAXA.).)._ 0.Y.tX@.<XC |XZ.,.!.P.!Xs.^.PX .!.P.P.P.^.PXs |.PXs.P.I.!XZ.,XZ.,.!.!.,.PXs.P.Y.I ) b.I.P.IXZ |XZ.Y.,._XZ.Y 1.! |.! |.I.P.P.!.,.P b.I.^.P.!.!.!.,.Y.I.!.!._ b.I.! :.PXs.P.PXsXZ.I.I.!XZ.Y.PX9.PXZ.!.I b.)._ b b.Y.IXZ.P.,.E s.IXZ bXZ., bXZ.) b._._Xm b b b b.I.! b bXZXAXAXZ LXk.I bXs b.=.a.bXl.}._.} fXm 0Xm LXZXZ.I L.).) LXZX+ L 4X@XA 4.= 4XAXA._X+.)XAX+X+X@.<X@.hXA.)XAXZ.).<._X@XZ b._.IXZ.I |XZ L.,.Y.Y._.! b |.!.!Xs.!XZ.,.I.!XZ.<.I.E f.}.b.aXA._ v.a.0.IXZXAXAXZ.Y.0 LXZXAXA.).)._ 0.Y.tX@.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T.v.IXZXs._XZXZ.,.)XZ b.IXk. .)XZX9 b.) LXAXA LXzXZ.I z bX@ g.b.b.}.<.)XZ._.).0XA._ L. .I L bX+ L LXAXZ LXAXl v 4X+.*XAXZXA.0XA.*Xm.0.0.).)X..,XZ bXA., b.!.).t._._.I.P.I.Y bXZ |.Y., b.IXs.IXZXZ.,.,XZ.0.!.Y &X@.}.} g.b._.t.b.bXCXZXZXZ._._.).)._.)XZXZ.Y.!XZ.!.I._.t.<.!.!._.P., o.PXs.P.P.PXs ).P.PXs.P.P |Xs.P.IXZ._.!.P.P.P.P.Y.I.P.IXZ._._.P.P.P |.I.I 0.,.! |.Y 0., 1.!.I.P.P.!.I.P.P.P.Y.YXs.PXs |.!XZ.Y._.!.0._.!.)XZ.P.I.PX9X9.P.P.!.P.I.!.,.^X9XsXZXZ.IXZXZXZ.,.).! bXZ.IXZ.P._ bXZ.Y.IXZXs._XZXZ.,.)XZ b.IXk. .)XZX9 b.) LXAXA LXzXZ.I z bX@ g.b.b.}.<.)XZ._.).0XA._ L. .I L bX+ L LXAXZ LXAXl v 4X+.*XAXZXA.0XA.*Xm.0.0.).)X..,XZ bXA., b.!.).t._._.I.P.I.Y bXZ |.Y., b.IXs.IXZXZ.,.,XZ.0.!.Y &X@.}.} g.b._.t.b.bXCXZXZXZ._._.).)._.)XZXZ.Y.!XZ.!.I._.t 0.<.!.!._.P., o.PXs.P.P.PXs ).P.PXs.P.P |Xs.P.IXZ._.!.P.P.P.P.Y.I.P.IXZ._._.P.P.P |.I.I 0.,.! |.Y 0., 1.!.I.P.P.!.I.P.P.P.Y.YXs.PXs |.!XZ.Y._.!.0._.!.)XZ.P.I.PX9X9.P.P.!.P.I.!.,.^X9XsXZXZ.IXZXZXZ.,.).! bXZ.IXZ.P._ bXZ.Y.IXZXs._XZXZ.,.)XZ b.IXk. .)XZX9 b.) LXAXA LXzXZ.I z bX@ g.b.b.}.<.)XZ._.).0XA._ L. .I L bX+ L LXAXZ LXAXl v 4X+.*XAXZXA.0XA.*Xm.0.0.).)X..,XZ bXA., b.!.).t._._.I.P.I.Y bXZ |.Y., b.IXs.IXZXZ.,.,XZ.0.!.Y &X@.}.} g.b._.t.b.bXCXZXZXZ._._.).)._.)XZXZ.Y.!XZ.!.I._.t.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.T @X:X9X:X:.7 {X:XkX:X9X:.y.yX9XkXkX9X9.y.u.y L.yX%.yX5.y.7 LXA.KXA.vX: yXkX9.y zXk.7.7.7.7X:.|Xt.|XkX:Xk.7.7.3.7.|Xk.7 L L.7.7.7.y.u.7.7.7XB.y.yX:X9.yX:X9.y.y.7XtX9X9X:X9X9X:X:X9XkX:.u.7X: G G.uX9.u.u.u.I.uXA.n.n.nXb.vXBXk.7XZ.yX:.u.I.7.yX:X:X:X:X:.7 yX:.u.7XZ.-.uX:.uXS.LX%.LX  OX%.LX9.L.LX%XS.LX%X X:.u.LX:.u G.L.LX9.L G.yX9X9.LX9.L G.L GXSX%X% G.uXS GX%.uX:.u G G.LXSXS G GX9.LX%.LXSX X9X% X J G G.uX:.H.7.uXS GX9 OX%X% O JX% GX9X%.LX%.L GX:X:.uX9X:X:X:X: GX:X:.LX%X:X%.LXZX: GX:X9X:X:.7 {X:XkX:X9X:.y.yX9XkXkX9X9.y.u.y L.yX%.yX5.y.7 LXA.KXA.vX: yXkX9.y zXk.7.7.7.7X:.|Xt.|XkX:Xk.7.7.3.7.|Xk.7 L L.7.7.7.y.u.7.7.7XB.y.yX:X9.yX:X9.y.y.7XtX9X9X:X9X9X:X:X9XkX:.u.7X: G G.uX9.u.u.u.I.uXA.n.n.nXb.vXBXk.7XZ.yX:.u.I.7.yX:X:X:X:X:.7 yX:.u.7XZ.-.7.uX:.uXS.LX%.LX  OX%.LX9.L.LX%XS.LX%X X:.u.LX:.u G.L.LX9.L G.yX9X9.LX9.L G.L GXSX%X% G.uXS GX%.uX:.u G G.LXSXS G GX9.LX%.LXSX X9X% X J G G.uX:.H.7.uXS GX9 OX%X% O JX% GX9X%.LX%.L GX:X:.uX9X:X:X:X: GX:X:.LX%X:X%.LXZX: GX:X9X:X:.7 {X:XkX:X9X:.y.yX9XkXkX9X9.y.u.y L.yX%.yX5.y.7 LXA.KXA.vX: yXkX9.y zXk.7.7.7.7X:.|Xt.|XkX:Xk.7.7.3.7.|Xk.7 L L.7.7.7.y.u.7.7.7XB.y.yX:X9.yX:X9.y.y.7XtX9X9X:X9X9X:X:X9XkX:.u.7X: G G.uX9.u.u.u.I.uXA.n.n.nXb.vXBXk.7XZ.yX:.u.I.7.yX:X:X:X:X:.7 yX:.u.7XZ.-.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.T.>XdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXd.5.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.T.>XdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXd.5.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.T.>XdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXd.5.5.5.5.5.5.5.5",
".T.T.T.T.T.T.>XdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXd.5.5.5.5.5.5.5",
".T.T.T.T.T.>XdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXd.5.5.5.5.5.5",
".T.T.T.T.>XdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXd.5.5.5.5.5",
".T.T.T.>XdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXd.5.5.5.5",
".T.T.>XdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXd.5.5.5",
".T.>XdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXd.5.5",
".>XdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXdXd.5"
};
#endif /* USE_XPM */

/* splash background for monochrome or non-XPM compile */

#define spl_bckgnd_width 630
#define spl_bckgnd_height 210
char spl_bckgnd_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x02,0x80,0x20,0x02,0x88,0x40,0x40,0x00,0x88,0x80,0x00,
 0x11,0x12,0x82,0x40,0x40,0x40,0x08,0x00,0x00,0x88,0x04,0x20,0x04,0x00,0x09,
 0x10,0x00,0x00,0x04,0x20,0x22,0x00,0x00,0x01,0x80,0x20,0x12,0x21,0x00,0x00,
 0x10,0x20,0x82,0x40,0x02,0x20,0x81,0x08,0x02,0x00,0x02,0x00,0x41,0x08,0x84,
 0x08,0x00,0x04,0x40,0x00,0x11,0x08,0x04,0x20,0x90,0x40,0x00,0x24,0x00,0x22,
 0x09,0x10,0x24,0x00,0x00,0x90,0x00,0x22,0x28,0x09,0x02,0x48,0x00,0x12,0x09,
 0x49,0x02,0x12,0x12,0x40,0x80,0x08,0x12,0x09,0x09,0x21,0x49,0x49,0x02,0x90,
 0x84,0x90,0x14,0xa0,0x84,0x24,0x29,0x21,0x01,0x80,0x94,0x24,0x24,0x09,0x02,
 0x00,0x04,0x49,0x92,0x44,0x02,0x08,0x12,0x48,0x09,0x24,0x20,0x48,0x92,0x28,
 0x09,0x04,0x21,0x11,0x20,0x49,0x90,0x04,0x49,0x40,0x22,0x21,0x89,0x04,0x12,
 0x49,0x80,0x24,0x08,0xa0,0x84,0x80,0xa4,0x94,0x04,0x12,0x28,0x02,0x20,0x08,
 0x01,0x44,0x00,0x00,0x00,0x40,0x00,0x80,0x08,0x08,0x40,0x00,0x00,0x00,0x00,
 0x00,0x00,0x20,0x01,0x00,0x00,0x40,0x04,0x00,0x00,0x00,0x00,0x10,0x11,0x00,
 0x00,0x00,0x20,0x88,0x84,0x00,0x00,0x00,0x00,0x20,0x41,0x00,0x00,0x40,0x00,
 0x82,0x00,0x00,0x00,0x80,0x20,0x00,0x00,0x02,0x00,0x02,0x20,0x00,0x08,0x00,
 0x00,0x00,0x00,0x00,0x00,0x09,0x00,0x01,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
 0x11,0x88,0x00,0x20,0x90,0x10,0x04,0x12,0x11,0x11,0x24,0x04,0x82,0x20,0x00,
 0x04,0x22,0x12,0x42,0x04,0x12,0x00,0x44,0x24,0x22,0x02,0x00,0x91,0x48,0x84,
 0x44,0x42,0x00,0x21,0x42,0x88,0x00,0x00,0x10,0x48,0x84,0x48,0x10,0x09,0x00,
 0x44,0x22,0x04,0x02,0x08,0x22,0x22,0x40,0x22,0x00,0x42,0x20,0x88,0x24,0x20,
 0x01,0x22,0x82,0x40,0x24,0x02,0x91,0x40,0x04,0x40,0x04,0x20,0x10,0x22,0x49,
 0x04,0x21,0x22,0x24,0x14,0x02,0x44,0x02,0x04,0x80,0x90,0x00,0x04,0x00,0x01,
 0x41,0x00,0x02,0x92,0x90,0x08,0x80,0x10,0x90,0x00,0x49,0x00,0x00,0x00,0x00,
 0x49,0x00,0x02,0x10,0x10,0x00,0x48,0x04,0x10,0x02,0x48,0x22,0x01,0x02,0x20,
 0x00,0x04,0x00,0x24,0x01,0x80,0x00,0x20,0x01,0x00,0x00,0x12,0x00,0x92,0x10,
 0x08,0x01,0x80,0x08,0x88,0x00,0x00,0x12,0x00,0x48,0x00,0x12,0x40,0x02,0x90,
 0x08,0x01,0x00,0x00,0x40,0x04,0x00,0x01,0x2a,0x28,0x00,0x88,0x40,0x02,0x00,
 0x48,0x20,0x02,0x10,0x08,0x48,0x10,0x00,0x00,0x40,0x08,0x80,0x00,0x48,0x00,
 0x12,0x91,0x44,0x24,0x00,0x04,0x20,0x01,0x00,0x12,0x01,0x40,0x00,0x10,0x01,
 0x00,0x48,0x90,0x00,0x11,0x21,0x22,0x01,0x88,0x08,0x48,0x04,0x90,0x48,0x44,
 0x00,0x09,0x00,0x80,0x00,0x10,0x02,0x00,0x20,0x44,0x48,0x80,0x88,0x00,0x22,
 0x00,0x11,0x88,0x00,0x02,0x44,0x44,0x44,0x12,0x40,0x44,0x40,0x15,0x02,0x11,
 0x01,0x10,0x20,0x22,0x02,0x00,0x48,0x82,0x00,0x02,0x80,0x44,0x44,0x00,0x02,
 0x09,0x22,0x02,0x10,0x40,0x00,0x00,0x01,0x02,0x41,0x04,0x80,0x84,0x00,0x10,
 0x10,0x24,0x41,0x80,0x48,0x00,0x00,0x12,0x04,0x80,0x00,0x40,0x20,0x00,0x02,
 0x41,0x04,0x00,0x01,0x21,0x40,0x22,0x08,0x44,0x84,0x10,0x92,0x04,0x00,0x02,
 0x08,0x02,0x20,0x08,0x44,0x00,0x20,0x44,0x80,0x00,0x11,0x10,0x00,0x10,0x10,
 0x10,0x15,0x28,0x04,0x10,0x01,0x01,0x00,0x20,0x49,0x00,0x00,0x22,0x10,0x09,
 0x00,0x00,0x09,0x10,0x20,0x00,0x80,0x44,0x00,0x42,0x24,0x10,0x48,0x08,0x80,
 0x24,0x10,0x48,0x44,0x82,0x00,0x04,0x12,0x00,0x21,0x09,0x40,0x20,0x02,0x88,
 0x04,0x01,0x11,0x20,0x10,0x40,0x02,0x08,0x04,0x04,0x80,0x20,0x10,0x00,0x40,
 0x00,0x80,0x08,0x10,0x40,0x10,0x81,0x80,0x00,0x42,0x02,0x00,0x08,0x08,0x80,
 0x00,0x41,0x82,0x00,0x41,0x29,0x04,0x41,0x42,0x20,0x90,0x88,0x04,0x00,0x22,
 0x24,0x00,0x01,0x00,0x22,0x22,0x20,0x41,0x04,0x10,0x21,0x00,0x12,0x10,0x00,
 0x80,0x00,0x20,0x22,0x00,0x01,0x02,0x00,0x00,0x42,0x00,0x00,0x09,0x08,0x80,
 0x08,0x80,0x20,0x02,0x10,0x08,0x84,0x04,0x00,0x11,0x48,0x40,0x00,0x01,0x11,
 0x04,0x02,0x42,0x04,0x40,0x22,0x20,0x81,0x04,0x40,0x10,0x00,0x20,0x10,0x00,
 0x22,0x42,0x42,0x04,0x04,0x10,0x00,0x04,0x50,0x15,0x52,0x84,0x24,0x95,0x4a,
 0x22,0x52,0xa5,0x90,0x92,0xaa,0x54,0x55,0x84,0x00,0x41,0x8a,0x48,0xa5,0x94,
 0x52,0x49,0xa5,0xaa,0x2a,0x55,0x45,0x49,0x29,0xaa,0xa8,0x52,0x55,0x94,0xaa,
 0x2a,0x52,0x22,0x29,0xa1,0x4a,0x4a,0xa9,0x40,0x40,0x10,0x51,0x55,0x4a,0x91,
 0x2a,0x55,0x34,0xa2,0x52,0xa9,0x94,0x52,0x15,0x89,0x4a,0x4a,0x52,0x15,0x25,
 0x55,0x95,0x42,0xa9,0x48,0x29,0x29,0x51,0x51,0x84,0x54,0xa9,0xaa,0x2a,0x00,
 0x29,0x89,0x88,0x24,0x94,0x14,0x08,0x24,0x04,0x11,0x42,0x20,0x51,0x48,0x10,
 0x50,0x12,0x09,0x44,0x14,0x92,0x08,0x01,0x84,0x88,0x28,0x24,0x84,0x44,0x92,
 0x04,0x11,0x25,0x49,0x80,0x24,0x01,0x42,0x14,0x11,0x20,0x10,0x2a,0x11,0x41,
 0x14,0x02,0x01,0x44,0x44,0x22,0x89,0x14,0x44,0x12,0x49,0x08,0x91,0xa4,0x24,
 0x11,0x89,0x88,0x4a,0x22,0x48,0x10,0x84,0x24,0x02,0x00,0x12,0x82,0x20,0x00,
 0x42,0x40,0x15,0x2a,0x40,0x22,0x55,0x92,0x22,0xa0,0xa2,0x80,0xa8,0x44,0x94,
 0x82,0x82,0x20,0x42,0x05,0x41,0xa4,0x92,0xa0,0x48,0x24,0x54,0x29,0x51,0x42,
 0x91,0x52,0x12,0x49,0x52,0xa2,0x48,0x92,0x2a,0x42,0xaa,0x88,0xa2,0xa4,0x4a,
 0x41,0x41,0x20,0x10,0xa1,0x08,0xaa,0x94,0x10,0x49,0x24,0xa2,0x28,0xa1,0xa4,
 0x52,0x44,0x12,0x91,0x44,0x24,0x25,0x89,0x88,0x22,0x45,0x10,0x91,0x54,0x55,
 0x48,0x54,0x00,0x91,0x94,0x5a,0x2a,0x80,0x2a,0x49,0x82,0x94,0x40,0x15,0x10,
 0x52,0x22,0x29,0x42,0x28,0x28,0x84,0x20,0xa0,0x14,0x29,0x00,0x15,0x25,0x89,
 0x22,0xa2,0x8a,0x54,0x0a,0x10,0x48,0x92,0x88,0x14,0x25,0x49,0x40,0x91,0x04,
 0x20,0x14,0x12,0x24,0x8a,0x14,0x88,0x40,0x14,0xa4,0x10,0x02,0xa5,0x24,0x82,
 0x08,0x45,0x4a,0x08,0x09,0x22,0x48,0x24,0x91,0x42,0xa2,0x24,0x51,0x89,0x28,
 0x49,0x24,0x09,0x89,0x02,0x09,0x54,0x20,0x21,0xa1,0x12,0x0a,0x90,0x24,0x29,
 0x49,0x12,0x49,0x45,0x08,0x89,0x44,0x29,0x85,0x12,0x01,0x80,0x4a,0x22,0x44,
 0x55,0x20,0x82,0x50,0x44,0x14,0x24,0x82,0xa4,0xa2,0x22,0x41,0x52,0xa2,0x88,
 0x12,0x29,0x4a,0xa8,0x84,0xa0,0x44,0x91,0x48,0x82,0x02,0x90,0xa2,0x12,0x4a,
 0x29,0x10,0x49,0x29,0x51,0x28,0x91,0x92,0xa4,0x88,0x22,0x89,0x24,0x29,0x09,
 0x49,0x08,0x52,0x42,0x84,0x12,0x92,0x24,0xa4,0x20,0x01,0x80,0x84,0x54,0x15,
 0x40,0x25,0x89,0x88,0x14,0xa1,0x24,0x91,0x42,0x24,0x29,0x04,0x50,0x24,0x28,
 0x42,0x12,0x48,0x29,0x22,0x95,0x54,0x0a,0x92,0xa2,0x92,0x54,0x22,0x09,0x48,
 0x94,0x10,0x09,0x25,0x49,0x12,0x25,0x02,0x29,0x15,0x29,0x09,0x12,0x20,0x20,
 0x21,0x10,0xa0,0x52,0x84,0x45,0x12,0x44,0x8a,0x92,0x14,0x49,0x12,0x25,0x49,
 0x22,0x91,0x88,0xa4,0x12,0x45,0x89,0x10,0x21,0xa4,0x24,0x89,0x12,0x0a,0x10,
 0x29,0x29,0xa1,0x2a,0x0a,0x88,0x24,0x15,0x21,0x0a,0x91,0x04,0x08,0x49,0x90,
 0xa8,0x0a,0x11,0x82,0x20,0x49,0x21,0x42,0x49,0x42,0x21,0x51,0x49,0x94,0x44,
 0x92,0x14,0xa4,0x82,0x24,0xa5,0x54,0x44,0x92,0x48,0x90,0x54,0x80,0xa0,0x80,
 0xa4,0xa0,0x0a,0x05,0x90,0xca,0x12,0x84,0x52,0x92,0x48,0x09,0x11,0x24,0x41,
 0x92,0x44,0x10,0x04,0x49,0x24,0x25,0x49,0x4a,0x28,0x12,0x45,0x44,0x41,0x08,
 0x10,0x44,0x09,0x05,0x20,0x42,0x94,0x14,0x40,0x45,0x92,0xa2,0x14,0xa1,0x44,
 0x52,0xa5,0x84,0x0a,0x02,0xa0,0x88,0x28,0x40,0x82,0x8a,0x28,0x92,0x24,0x14,
 0x0a,0x04,0x49,0x22,0xa5,0x02,0x09,0x29,0x49,0x20,0x22,0x29,0x09,0x22,0x45,
 0x02,0x55,0x14,0x2a,0x08,0x12,0x24,0x48,0x21,0x11,0xa1,0xa2,0x88,0x44,0x92,
 0xa4,0x08,0x49,0x2a,0x55,0x12,0x84,0x52,0x24,0x49,0x92,0x24,0x11,0x91,0x44,
 0x12,0x22,0x14,0x45,0x45,0x21,0x50,0x40,0x81,0x28,0x51,0x15,0x2a,0x90,0x24,
 0x94,0x22,0x94,0x90,0x08,0x10,0x12,0x50,0x54,0x05,0x22,0x82,0x12,0x28,0x20,
 0x45,0x49,0x92,0xa2,0xa4,0x08,0x24,0x49,0x14,0xaa,0x20,0x42,0x24,0x95,0x54,
 0x52,0x92,0x48,0x90,0x24,0x80,0xa2,0x88,0x22,0x49,0x92,0x00,0x04,0x44,0x44,
 0x14,0x25,0x12,0x21,0x12,0x42,0x92,0x90,0x88,0x44,0x51,0x88,0x48,0xa2,0xa4,
 0x52,0x04,0x4a,0x50,0x88,0x88,0xa2,0x28,0x08,0x85,0x02,0x25,0x08,0x41,0xa8,
 0x2a,0x80,0x24,0x91,0x49,0x14,0x22,0x44,0x02,0x45,0xa1,0x0a,0x22,0xa0,0x94,
 0x48,0x04,0x40,0x95,0x20,0x82,0x04,0x10,0x01,0x42,0x49,0x22,0x45,0x01,0x88,
 0x10,0x90,0x22,0x09,0x89,0x04,0x92,0x44,0x01,0x55,0x48,0x22,0x40,0x80,0x24,
 0xaa,0x00,0x20,0x91,0x82,0x90,0x44,0x94,0x84,0x90,0x24,0x4a,0x55,0x12,0x08,
 0x22,0x22,0x11,0x49,0x88,0x22,0x91,0x84,0x22,0x25,0x11,0x05,0x52,0x50,0xa8,
 0x40,0x02,0x94,0x42,0x15,0x0a,0x42,0x0a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x49,0x09,0x01,0x52,0x22,0x25,
 0x49,0x95,0x2a,0x42,0x41,0x52,0x88,0x04,0x28,0x42,0x12,0x21,0x22,0x0a,0x92,
 0x10,0x22,0xa1,0xa2,0x40,0x88,0x44,0x24,0x25,0x14,0x42,0x10,0x81,0x48,0x4a,
 0xa8,0x88,0x92,0x42,0x0a,0x14,0x40,0x34,0x29,0xa0,0x80,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x12,0x40,
 0xa0,0x88,0x08,0x49,0x12,0x20,0x11,0x91,0x14,0x08,0x20,0x48,0x45,0x29,0x41,
 0x94,0x08,0x41,0x49,0x45,0x95,0x0a,0x10,0x94,0x22,0x20,0x92,0x92,0x82,0x10,
 0x81,0x28,0x22,0x91,0x02,0x45,0x24,0x28,0x51,0x41,0x10,0x42,0x15,0x02,0x2a,
 0x0a,0x00,0x01,0x80,0x00,0x20,0x00,0x08,0x00,0x02,0x00,0x01,0x80,0x00,0x20,
 0x00,0x08,0x00,0x02,0x00,0x01,0x40,0x00,0x20,0x00,0x08,0x00,0x02,0x00,0x01,
 0x40,0x00,0x40,0x15,0x84,0x24,0x52,0x82,0x40,0x85,0xa4,0x24,0x10,0x51,0x82,
 0x20,0x00,0x84,0x14,0x49,0xa2,0x94,0x24,0x2a,0x22,0x54,0x49,0x11,0x8a,0x84,
 0x24,0x24,0x48,0x0a,0x50,0xa2,0x88,0x44,0x48,0x10,0x49,0x45,0x04,0x14,0x40,
 0x58,0x15,0x50,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x40,0x52,0x20,0x21,0x92,0x80,0x28,0x14,0x50,0x2a,
 0x92,0x4a,0x04,0x20,0x0a,0x00,0x21,0x21,0x02,0x12,0x22,0x09,0x41,0xa9,0x22,
 0x02,0xa4,0x20,0x28,0x49,0x49,0x12,0xa1,0x04,0x14,0x22,0x29,0x12,0xa4,0x24,
 0x29,0x51,0x80,0x08,0x51,0x25,0x0a,0x14,0x05,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xa0,0x82,0x4a,0x14,0x44,0x2a,
 0x41,0x22,0x0a,0x91,0x24,0x20,0x20,0x00,0x00,0x80,0x24,0x84,0x54,0x41,0x84,
 0x52,0x2a,0x92,0x44,0xa9,0x42,0x8a,0x40,0x24,0x85,0x40,0x0a,0x29,0x41,0x44,
 0x80,0x20,0x02,0x89,0x44,0x04,0x29,0x20,0xa0,0x2a,0x20,0xa1,0x08,0x00,0x01,
 0x80,0x00,0x20,0x00,0x08,0x00,0x02,0x00,0x01,0x80,0x00,0x20,0x00,0x08,0x00,
 0x02,0x00,0x01,0x40,0x00,0x20,0x00,0x08,0x00,0x02,0x00,0x01,0x40,0xa0,0x2a,
 0x11,0x42,0x11,0x44,0x08,0x08,0xa1,0x08,0x91,0x0a,0x8a,0x94,0x44,0x11,0x80,
 0x52,0x00,0x28,0x51,0x08,0x91,0x24,0x29,0x10,0x91,0x20,0x2a,0x42,0x28,0x25,
 0x21,0x42,0x12,0x29,0x0a,0x8a,0xa8,0x24,0x28,0x29,0x02,0x89,0xa4,0x14,0x82,
 0x14,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x40,0x85,0x44,0x29,0x44,0x22,0x25,0xa1,0x04,0x25,0x24,0xa4,0x20,
 0x20,0x02,0x00,0x20,0x08,0x55,0x91,0x84,0xa2,0xa4,0x4a,0x92,0x22,0x4a,0x4a,
 0x48,0x89,0x42,0x88,0x84,0x14,0x08,0x44,0x21,0x10,0x41,0x12,0x81,0x84,0x24,
 0x20,0x52,0x15,0x28,0xa0,0x20,0x49,0x49,0x92,0x92,0x24,0x29,0x49,0x52,0x92,
 0x44,0x49,0x92,0x90,0x24,0x29,0x49,0x12,0x92,0x24,0x25,0x49,0x92,0x24,0x09,
 0x49,0x92,0x92,0x24,0x25,0x49,0xa2,0x55,0x22,0x88,0x88,0x80,0x40,0x48,0xa8,
 0x10,0x89,0x12,0x15,0x44,0x21,0x0a,0x44,0xa5,0x08,0x44,0xa8,0x48,0x12,0x21,
 0x21,0x94,0x24,0x90,0x22,0x24,0x90,0x44,0x52,0x88,0x42,0x01,0x08,0x49,0x2a,
 0x49,0x54,0x22,0x89,0x88,0xa0,0x2a,0x82,0x12,0x05,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x20,
 0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0xa0,0x22,0x89,0x12,0x12,
 0x25,0x12,0x25,0x51,0x2a,0x24,0x44,0xa0,0x20,0x04,0x20,0x00,0x00,0xa5,0x92,
 0x12,0x12,0x49,0x4a,0x84,0x48,0x92,0x02,0x94,0x92,0x24,0x92,0x04,0x25,0x14,
 0xa9,0xa0,0x24,0x91,0x24,0x81,0x44,0x20,0x22,0x52,0x12,0x20,0x44,0x22,0x92,
 0x24,0x55,0xa5,0xaa,0x9e,0x92,0x52,0xa9,0x2a,0x91,0x24,0xa9,0x2a,0x49,0xaa,
 0x54,0x12,0xaa,0x0a,0xaa,0x24,0x3d,0xa9,0xaa,0xaa,0x8a,0x2a,0x91,0x24,0x49,
 0x4d,0x24,0xa4,0x44,0x48,0x40,0x48,0x0a,0x45,0x41,0x21,0x0a,0x09,0x01,0x4a,
 0x12,0xaa,0x20,0x24,0x84,0xa4,0xa4,0x24,0x29,0x92,0x44,0xa8,0x42,0x10,0x48,
 0x49,0x52,0x48,0xa1,0x00,0x04,0x48,0x24,0x49,0x48,0x28,0x0a,0x80,0x50,0x15,
 0x8a,0x88,0x88,0x00,0x81,0x80,0x00,0x20,0x11,0x08,0x08,0x02,0x00,0x05,0x82,
 0x00,0x20,0x20,0x08,0x02,0x43,0x00,0xa1,0x40,0x00,0x62,0x00,0x08,0x00,0x02,
 0x00,0x05,0x42,0x60,0x85,0x92,0x88,0x92,0x00,0x09,0x11,0x51,0x28,0x22,0x4a,
 0x21,0x20,0x48,0x00,0x41,0x00,0x95,0x88,0x50,0x08,0x09,0x09,0x82,0x20,0x12,
 0x05,0x94,0x0a,0x20,0x24,0x49,0x11,0x05,0x4a,0x51,0x22,0x89,0x24,0x21,0x41,
 0xa1,0x14,0xa2,0x2a,0x20,0x52,0x22,0xa8,0x28,0x10,0x28,0x89,0x2e,0x49,0x82,
 0x88,0x44,0xa0,0x20,0x92,0x44,0x0a,0x82,0x20,0x08,0x49,0x08,0x08,0x52,0x9f,
 0x25,0x21,0x92,0x20,0x91,0xa0,0x90,0xa4,0x56,0x48,0x52,0x20,0x52,0xa0,0xa4,
 0x08,0x05,0x00,0x11,0x04,0x89,0x00,0xa4,0x04,0x52,0x48,0x52,0x04,0xa5,0xa4,
 0xa4,0x28,0x94,0xa4,0xa8,0x42,0x40,0x15,0x49,0x24,0x4a,0xa8,0x20,0x08,0x49,
 0x22,0x11,0x84,0x14,0x04,0x80,0x50,0x15,0x8a,0x80,0x80,0x02,0x02,0x41,0x02,
 0x60,0x44,0x00,0x10,0x22,0x10,0x01,0x84,0x00,0x10,0x40,0x08,0x84,0x20,0x00,
 0x41,0x22,0x81,0x04,0x01,0x84,0x00,0x0a,0x04,0x02,0x04,0xa2,0x0a,0x91,0x84,
 0x8a,0x88,0x0a,0x12,0x55,0xa8,0x52,0x42,0x01,0x04,0x00,0x10,0x92,0x80,0x22,
 0x40,0x11,0x28,0x49,0x12,0x45,0x49,0x42,0x22,0x29,0x11,0xa1,0x04,0x91,0x90,
 0x02,0x45,0x51,0x24,0x49,0x44,0x22,0xa1,0x40,0x14,0x20,0x29,0x20,0x14,0x10,
 0x00,0x41,0x88,0x80,0xa4,0x54,0xaa,0x04,0x02,0x04,0x14,0x91,0x48,0x22,0x11,
 0x29,0x11,0x0a,0x24,0x11,0x40,0x90,0x64,0x91,0x18,0x48,0x22,0x41,0x21,0x41,
 0x48,0x45,0x4a,0x2a,0x21,0x22,0xa0,0xa4,0x20,0x05,0x80,0x10,0x50,0x00,0x00,
 0x41,0x11,0x20,0x00,0x09,0x04,0x85,0x24,0x89,0x20,0x92,0x94,0x94,0x00,0x40,
 0x0a,0x51,0x28,0x25,0x51,0x11,0x0a,0x89,0x24,0x12,0x40,0x08,0x12,0x01,0x50,
 0x15,0x82,0x00,0x40,0x14,0x04,0x02,0x12,0x00,0x44,0x00,0x20,0x90,0x20,0x41,
 0x00,0x02,0x00,0x06,0x00,0x40,0x40,0x01,0x44,0x12,0x81,0x04,0x09,0x42,0x02,
 0x00,0x04,0x04,0x28,0x61,0x2b,0x90,0x20,0x4a,0x84,0x8a,0x08,0x89,0x88,0x14,
 0x4a,0x89,0x12,0x08,0x94,0x24,0x02,0x52,0xa4,0x22,0x50,0x92,0x24,0x95,0x24,
 0x22,0x11,0x00,0x10,0x51,0x84,0x42,0x8a,0x04,0x44,0x50,0x52,0x90,0x84,0x14,
 0xa1,0x48,0x00,0xa0,0x2a,0x28,0x02,0x04,0x80,0x90,0x90,0x40,0x44,0x81,0x00,
 0x02,0x02,0x02,0x00,0x44,0x40,0x92,0x40,0x12,0x09,0x11,0x20,0x01,0x00,0xa4,
 0x04,0x89,0x00,0x90,0x24,0x21,0x41,0x02,0xa0,0x8a,0x4a,0x4a,0x21,0x29,0x52,
 0x52,0x22,0x22,0x42,0x01,0x20,0x00,0x22,0x41,0x8a,0x08,0x00,0x41,0x08,0x95,
 0x24,0x89,0x00,0x89,0x48,0xa4,0x00,0x49,0x12,0x52,0x28,0x41,0x52,0x29,0x8a,
 0x04,0x09,0x22,0x42,0x09,0x01,0x0a,0x50,0x15,0x82,0x40,0x91,0x10,0x01,0x80,
 0x08,0xb1,0x2e,0x5b,0xd5,0xaa,0xd4,0x12,0xa8,0x9a,0x24,0x97,0x54,0x00,0x82,
 0x04,0x49,0x52,0x00,0xab,0x18,0x48,0x02,0x02,0x08,0x09,0x48,0xa5,0x2a,0x21,
 0x25,0x8a,0x44,0x84,0x80,0x94,0x04,0x14,0xa0,0x44,0x05,0x00,0x94,0x28,0x21,
 0x2a,0x0a,0x51,0x20,0x92,0x24,0x55,0x12,0x25,0x11,0x24,0x84,0x48,0x89,0x82,
 0x2c,0x49,0x42,0x51,0x52,0x52,0x09,0x09,0x44,0x54,0x41,0xa9,0x2a,0x24,0x04,
 0x04,0x04,0x20,0x12,0x00,0x28,0xd1,0xaa,0x2a,0x55,0x55,0x83,0x54,0x6b,0xdb,
 0x6d,0xdb,0x49,0x20,0x40,0x00,0x00,0x29,0x42,0x62,0x12,0x90,0x48,0x42,0x40,
 0x02,0x40,0x85,0x88,0x10,0x29,0x21,0x29,0x55,0x22,0xa9,0x82,0x0a,0x90,0xa0,
 0x92,0x22,0x45,0x82,0x40,0xa1,0x04,0x02,0x21,0x49,0x88,0xa4,0x90,0x44,0x81,
 0x22,0x12,0x22,0x29,0x02,0x92,0x28,0x24,0x91,0x24,0x42,0x44,0x01,0x80,0x10,
 0x50,0x12,0x90,0x50,0x25,0x21,0x85,0x00,0x11,0x80,0x04,0x00,0x90,0x20,0x92,
 0x06,0x24,0x84,0x24,0x92,0x64,0x00,0x09,0x09,0x92,0x24,0x30,0x3c,0x10,0x40,
 0x02,0x02,0x10,0x05,0x28,0x69,0x2b,0x25,0x45,0x22,0x94,0xa4,0x24,0x49,0x02,
 0x54,0x10,0x42,0x0a,0x00,0x48,0x08,0x08,0x00,0x44,0x42,0x48,0x8a,0x04,0x21,
 0x42,0x25,0x2a,0x51,0x14,0xa0,0x48,0x42,0xa9,0x24,0x42,0x89,0x24,0x49,0x29,
 0x11,0x14,0x14,0x4a,0xa2,0x2a,0x05,0x8a,0x08,0x40,0x10,0x90,0x44,0x2a,0x20,
 0xa4,0x04,0x88,0x40,0x9f,0x14,0x29,0x91,0x24,0xd5,0x25,0x02,0x20,0x01,0x41,
 0x92,0x20,0x32,0x19,0x40,0x22,0x05,0x51,0x41,0x40,0x45,0x89,0x90,0x08,0x09,
 0x09,0x48,0x12,0x51,0x81,0x04,0x10,0x51,0x49,0x12,0x45,0x05,0x88,0x92,0x10,
 0x02,0x51,0x52,0x94,0x28,0x10,0x41,0x0a,0x49,0x15,0x12,0x29,0x12,0x09,0x14,
 0x52,0x48,0x44,0x42,0xa4,0x02,0x40,0x91,0x50,0x15,0x50,0x00,0x42,0x12,0x02,
 0x01,0x00,0x08,0x00,0x00,0x00,0x02,0x94,0x1d,0x24,0x80,0x04,0x90,0xd4,0x81,
 0x50,0x02,0x24,0x04,0xa8,0x80,0x56,0x80,0x14,0x08,0x20,0x00,0x04,0xa5,0x2a,
 0x10,0x25,0x52,0x52,0x50,0x81,0x44,0x8a,0x14,0x12,0x45,0x04,0x04,0x20,0x12,
 0x00,0x21,0x48,0x42,0x14,0x04,0x00,0x20,0x41,0x45,0x2a,0x40,0x04,0xa2,0xa4,
 0x20,0x49,0xa0,0xa2,0x20,0x85,0x12,0x89,0x00,0x08,0x15,0x02,0x92,0x2a,0x04,
 0x55,0x10,0x00,0x40,0x90,0x40,0x94,0x04,0x01,0x90,0x00,0x41,0x77,0x4a,0x25,
 0xa0,0x4a,0xaa,0x13,0x04,0x20,0x01,0x90,0xb2,0x4c,0xd4,0x24,0x00,0x82,0x08,
 0x12,0x41,0x60,0x0b,0xa5,0x88,0x04,0x09,0x25,0x54,0x22,0x21,0xa1,0x00,0x10,
 0x12,0x81,0x14,0x91,0x0a,0x04,0x92,0x90,0x02,0x51,0x29,0x49,0x2a,0xa8,0x88,
 0x12,0xa1,0x14,0x11,0x4a,0x12,0x15,0x11,0x15,0xa2,0x84,0x24,0xaa,0x22,0x44,
 0x29,0xa0,0x12,0x92,0x80,0x48,0x49,0x49,0x12,0x8a,0x04,0x02,0x08,0x01,0x54,
 0xaa,0x3f,0x92,0x94,0x0a,0x52,0xe9,0x12,0x92,0x26,0xb5,0x49,0xaa,0x54,0x2b,
 0x49,0xd3,0x92,0xa4,0x24,0x29,0xa3,0xaa,0x08,0x55,0x52,0xa4,0x88,0x12,0x89,
 0x04,0x48,0x92,0x4a,0x09,0x08,0x20,0x22,0x00,0x80,0x24,0x45,0x54,0x00,0x40,
 0x04,0x41,0x11,0x25,0x48,0x14,0x50,0x44,0x11,0xa1,0xa0,0x24,0xa2,0x08,0x52,
 0x92,0x20,0x80,0x08,0x82,0x54,0x15,0x20,0x28,0x05,0x00,0x00,0x80,0x10,0xa8,
 0x50,0x20,0x00,0x82,0x44,0xb5,0x54,0x09,0x40,0x95,0xd6,0x81,0x00,0x00,0x00,
 0x00,0xb4,0xaa,0x2d,0x01,0x04,0x20,0x01,0x01,0x04,0x50,0x05,0x52,0x82,0x24,
 0x29,0x25,0x49,0x24,0xa9,0x12,0x04,0x24,0x40,0x20,0x91,0x14,0x55,0x20,0x90,
 0x28,0x12,0x24,0x95,0x50,0x2a,0x4a,0x92,0x12,0xa1,0x0a,0x29,0x48,0x14,0x15,
 0x49,0x09,0x55,0x89,0x20,0x94,0x14,0xa5,0x24,0xa0,0x2a,0x82,0x22,0x10,0x95,
 0x12,0x09,0x80,0xaa,0x06,0x00,0x08,0x29,0xb5,0x3f,0x56,0x55,0x52,0x6a,0xe9,
 0x09,0x52,0x48,0x01,0x52,0x6a,0x6a,0x99,0x4c,0x10,0x03,0x24,0x29,0x51,0xa4,
 0xaa,0x04,0x29,0x91,0x42,0x88,0x24,0x91,0x44,0x44,0x51,0x92,0x04,0x01,0x04,
 0x91,0x00,0x02,0x49,0x82,0x24,0x41,0x00,0x22,0x91,0x84,0x24,0x48,0x84,0xa4,
 0x84,0x12,0x49,0xa4,0x24,0x52,0x10,0x12,0x45,0x41,0x40,0x14,0x00,0x52,0x0a,
 0x28,0x48,0x45,0x00,0x40,0x00,0x09,0xe0,0x2b,0x02,0x20,0xd0,0xee,0x56,0xd8,
 0x83,0xa8,0xaa,0x7f,0x81,0x00,0x02,0xa4,0x00,0xa4,0xb4,0x2a,0x02,0x41,0x90,
 0x00,0x00,0x00,0xa1,0x15,0x52,0x92,0x48,0x28,0x25,0x91,0x24,0x10,0x51,0x80,
 0x00,0x20,0x40,0x51,0x44,0x04,0x10,0x00,0x28,0x91,0x10,0xa9,0x94,0x44,0x52,
 0x12,0x22,0x29,0x11,0x21,0xa5,0x24,0x11,0x92,0x88,0x4a,0x41,0x28,0x94,0x12,
 0x01,0x22,0xa0,0x2a,0x82,0x20,0x02,0x20,0x09,0x92,0x20,0x00,0x2f,0x40,0x00,
 0xe2,0xbb,0x3b,0x72,0x15,0x92,0xfa,0xd6,0x24,0x8a,0x10,0x01,0x52,0xdd,0xab,
 0x25,0x0c,0x04,0x02,0x4a,0x25,0x49,0x48,0x45,0x49,0x24,0x25,0x85,0x10,0x44,
 0x92,0x4a,0x00,0x01,0x4a,0x01,0x04,0x04,0x20,0x09,0x40,0x54,0x41,0x4a,0x02,
 0x00,0x40,0x12,0x89,0x48,0x49,0x44,0x44,0x94,0x08,0x92,0xa4,0x48,0x12,0x20,
 0x2a,0x81,0x20,0x00,0xa4,0x80,0x50,0x15,0x28,0x4a,0x29,0x0a,0x00,0x00,0x80,
 0x94,0xa8,0x00,0x02,0xa8,0xee,0x3e,0xc0,0x02,0xa9,0xb6,0xfb,0x00,0x20,0x40,
 0x48,0x00,0x20,0xda,0x06,0xa9,0x90,0x90,0x00,0x00,0x00,0xa2,0x26,0x22,0x89,
 0x88,0x20,0x49,0x91,0x44,0x10,0x49,0x94,0x00,0x12,0x41,0x81,0x14,0x02,0x00,
 0x01,0x14,0x11,0x21,0x95,0x24,0xa4,0xa0,0x24,0x90,0x12,0x12,0x21,0xa2,0x48,
 0x12,0x84,0xa4,0x8a,0x44,0x2a,0x88,0x88,0x08,0x12,0xa0,0x24,0x82,0x10,0x84,
 0x40,0x92,0x48,0x02,0x10,0x1a,0x12,0x90,0xe4,0xbf,0x8b,0xa8,0x52,0x4a,0xdf,
 0xae,0x48,0x02,0x05,0x01,0x49,0x22,0x54,0x91,0x08,0x02,0x02,0x48,0x92,0x54,
 0x60,0x55,0x94,0x50,0x52,0x95,0x24,0x02,0x90,0x42,0x00,0x00,0x04,0x40,0x00,
 0x4a,0xa0,0x24,0x10,0x24,0x40,0xa4,0x04,0x40,0x90,0x10,0x15,0x82,0x42,0x48,
 0x49,0x4a,0x94,0x22,0xc9,0x12,0x02,0x10,0x10,0x49,0x01,0x20,0x00,0x40,0x54,
 0x15,0x20,0x8a,0x02,0x08,0x01,0x80,0x28,0xa1,0xc0,0x00,0x00,0x40,0x6d,0x21,
 0x40,0x01,0xa5,0x75,0x09,0x02,0x42,0x10,0x49,0x40,0x22,0x24,0x01,0x10,0x40,
 0x4a,0x02,0x01,0x40,0x49,0x85,0x22,0x05,0x04,0x20,0x40,0xa9,0x04,0x10,0x92,
 0x52,0x91,0x08,0x20,0x00,0x04,0x10,0x44,0x88,0x2a,0x09,0x52,0x12,0x04,0x85,
 0x84,0x54,0x14,0x25,0x22,0x11,0x45,0x90,0x10,0xa0,0xa8,0x4a,0x45,0x10,0x10,
 0x15,0x95,0x08,0x90,0x2a,0x8a,0x20,0x28,0x20,0x48,0x02,0x00,0x10,0x44,0x00,
 0x01,0xd4,0x1f,0x08,0x41,0x4a,0xf4,0x1f,0x20,0x10,0x08,0x40,0x00,0x02,0x92,
 0x24,0x49,0x52,0x0a,0x00,0x48,0x54,0x01,0xa0,0x2a,0x84,0xa8,0x90,0x8a,0x8a,
 0x04,0x50,0xa5,0x00,0x24,0x4a,0x00,0x89,0x24,0x89,0x42,0x00,0x21,0x42,0xa2,
 0x00,0x80,0x50,0x50,0x48,0x02,0x21,0x90,0x94,0xa4,0x90,0x42,0x44,0x05,0x20,
 0x11,0x80,0x42,0x41,0x48,0x20,0x20,0xa1,0x12,0x20,0x94,0x84,0x04,0x02,0x20,
 0x02,0x48,0x84,0x02,0x00,0x00,0x7b,0x00,0xa4,0xa0,0x5a,0x55,0x82,0x04,0x21,
 0x0a,0x90,0x50,0x12,0x24,0xa1,0x20,0x20,0x91,0x02,0x00,0x28,0x64,0x4b,0x29,
 0x02,0x24,0x21,0x20,0x21,0x25,0x08,0x92,0x08,0x21,0x22,0x00,0x10,0x50,0x18,
 0x50,0x10,0x11,0x11,0x92,0x24,0x04,0x09,0x82,0x50,0x14,0x25,0x21,0x12,0x25,
 0x14,0x11,0x52,0x95,0x84,0x54,0x10,0x12,0x11,0x95,0x02,0xa0,0x2a,0x82,0x00,
 0x02,0x40,0x21,0x89,0x48,0x21,0x50,0x08,0x24,0xa9,0x3e,0x21,0x50,0x92,0xea,
 0x07,0x08,0x20,0x82,0x40,0x05,0x42,0x11,0x21,0x81,0x2c,0x01,0x02,0x48,0x09,
 0x41,0xa1,0x92,0x42,0x54,0x11,0x8a,0x14,0x84,0x90,0x42,0x00,0xa2,0x94,0x08,
 0x00,0x00,0x02,0x45,0x04,0x49,0x4a,0x44,0x08,0x00,0x20,0xa0,0x08,0x02,0x41,
 0x88,0x44,0xa1,0x44,0x21,0x44,0x04,0x40,0x08,0x10,0x45,0x00,0x44,0x44,0x08,
 0x28,0x15,0x28,0xaa,0x54,0x12,0x08,0x00,0x00,0x48,0x85,0x82,0x00,0x80,0x5f,
 0x84,0x28,0x48,0x7a,0x15,0x21,0x89,0x10,0x10,0x40,0x08,0x51,0x24,0x91,0x40,
 0x90,0x24,0x01,0x42,0x08,0x48,0x4d,0x28,0x01,0x48,0x21,0xa1,0x28,0x02,0x20,
 0x48,0x48,0x20,0x02,0x22,0x00,0x48,0x12,0x51,0x80,0x10,0x29,0x21,0x15,0x8a,
 0x0a,0xa1,0x48,0x14,0x25,0x29,0x14,0x29,0x48,0x92,0x52,0x2a,0x42,0x45,0x00,
 0x20,0x21,0x29,0x82,0x50,0x15,0x42,0x20,0x02,0x00,0x40,0x44,0x04,0x04,0x80,
 0x00,0x00,0x10,0x7d,0x00,0x14,0x51,0xb7,0x03,0x04,0x00,0x84,0x04,0x11,0x00,
 0x11,0x24,0x82,0x80,0x02,0x00,0x14,0x10,0x22,0x61,0x25,0x45,0xaa,0x02,0x0a,
 0x0a,0x80,0x28,0x84,0x00,0x01,0x89,0xa8,0x00,0x20,0x90,0x48,0x01,0x29,0x21,
 0x40,0x04,0xa0,0x00,0x20,0x14,0x25,0x40,0x52,0x44,0xa1,0x44,0x85,0x08,0x88,
 0x08,0x08,0x20,0xa4,0x04,0x04,0x80,0x28,0xa0,0x12,0x10,0x8a,0x28,0x49,0x09,
 0x92,0x52,0x21,0x2c,0x15,0x08,0x81,0x6e,0x49,0x0a,0x4a,0xed,0x4a,0x49,0x52,
 0x92,0x20,0x25,0x59,0x92,0x24,0x2a,0xaa,0xb2,0xb2,0x64,0x25,0x49,0x4a,0x45,
 0x29,0x01,0xa9,0xa0,0x40,0x29,0x40,0x11,0x24,0x48,0x20,0x09,0x90,0x04,0x44,
 0x44,0x88,0x00,0x8a,0x04,0xa1,0x08,0x24,0x89,0x80,0x00,0x2a,0x84,0x22,0x25,
 0xa2,0x10,0xa5,0x22,0x42,0xa1,0x12,0x01,0x88,0xa0,0x24,0x0a,0xaa,0x2a,0x42,
 0x00,0x05,0x04,0x20,0x00,0x00,0x84,0x90,0x02,0x00,0x28,0xfd,0x00,0x22,0xd4,
 0xbf,0x04,0x00,0x00,0x00,0x02,0x80,0x80,0x08,0x42,0x81,0x01,0x01,0x04,0x00,
 0x80,0x00,0xa0,0x15,0x42,0x4a,0x02,0x02,0x14,0x82,0x12,0x40,0x80,0x00,0x05,
 0x52,0x01,0xa0,0x90,0x92,0x20,0x2a,0x10,0x52,0x04,0x02,0x10,0x00,0x52,0x2a,
 0x80,0x12,0x94,0x48,0x09,0x41,0x10,0x08,0x28,0x0a,0x40,0x48,0x02,0x02,0x90,
 0x50,0x51,0x0a,0x14,0xa5,0x00,0x21,0x89,0x08,0x00,0x24,0x04,0x04,0x41,0x00,
 0xfa,0x90,0x8a,0xa2,0x6a,0x24,0x91,0x14,0x49,0x28,0x11,0x84,0x48,0x4c,0x12,
 0x21,0x11,0x01,0x09,0x2a,0x48,0xa2,0x4a,0x29,0x91,0xa4,0x28,0x81,0x24,0x08,
 0x04,0x04,0x52,0xa0,0x04,0x14,0x02,0x41,0x24,0x01,0x81,0x84,0x00,0x52,0xa9,
 0x42,0xa2,0x00,0x00,0x49,0x40,0x21,0x15,0xa4,0x14,0x45,0x22,0x81,0x40,0x12,
 0x00,0x00,0x28,0x05,0x45,0xa0,0x2a,0x20,0x00,0x2a,0x00,0x01,0xa0,0x94,0x22,
 0x94,0x24,0x00,0x40,0xed,0x02,0x21,0xda,0x1f,0x02,0x04,0x40,0x02,0x01,0x41,
 0x50,0x02,0x24,0x02,0x0a,0x42,0x2a,0xa0,0x01,0x41,0xa8,0x12,0x82,0x04,0x12,
 0x82,0x54,0x92,0x20,0x91,0x10,0x88,0x02,0xb2,0x02,0x10,0x84,0x90,0xa8,0x24,
 0x12,0x55,0x09,0x00,0x04,0x08,0x92,0x48,0x00,0x15,0x0a,0xa0,0x12,0x22,0x12,
 0x81,0x14,0x15,0x40,0x12,0x89,0x40,0x20,0x14,0x95,0x2a,0x8a,0x12,0x01,0x24,
 0x88,0x04,0x00,0x00,0x81,0x08,0x08,0x12,0xf4,0xa0,0x0a,0xe9,0x0a,0x8a,0x90,
 0x04,0x20,0x40,0x10,0x84,0x98,0x44,0x4a,0x42,0x12,0x00,0x09,0x40,0x10,0x42,
 0x4d,0x29,0x51,0x81,0x10,0x00,0x01,0x44,0x00,0x02,0x20,0x08,0x44,0x00,0x00,
 0x11,0x24,0x00,0x81,0x40,0x00,0x42,0x55,0x29,0x01,0x00,0x02,0x49,0x42,0xa1,
 0x4a,0x44,0x11,0x41,0x10,0x40,0x82,0x14,0x40,0x10,0x12,0x05,0x80,0x50,0x15,
 0x20,0x00,0xa4,0x80,0x20,0x80,0x20,0x12,0x14,0x0a,0x00,0x40,0xbd,0x48,0xa0,
 0xdc,0x27,0x22,0x00,0x10,0x84,0x04,0x85,0x40,0x08,0x44,0x04,0x14,0x84,0x44,
 0x00,0x0a,0x45,0x68,0x23,0x44,0x04,0x2a,0x82,0x54,0x4a,0x00,0x4a,0x88,0x80,
 0xa0,0x00,0x81,0x00,0x84,0x40,0x22,0x48,0x04,0xa9,0x14,0x08,0x42,0xaa,0x44,
 0x10,0x00,0x08,0x0a,0x24,0x29,0x44,0x0a,0x89,0x14,0x49,0x40,0x0a,0x04,0x00,
 0x90,0x14,0xa0,0x24,0x09,0x2a,0x01,0x10,0x02,0x91,0x08,0x21,0x00,0x89,0x40,
 0x00,0xe8,0x21,0x11,0x75,0x83,0x04,0x4a,0x82,0x12,0x20,0x01,0x92,0x84,0x64,
 0x24,0x09,0x29,0x12,0x49,0x21,0x40,0x41,0x4d,0x11,0x80,0x00,0x20,0x80,0x10,
 0x94,0x00,0x10,0x0a,0x0a,0x50,0x54,0x2a,0x01,0x08,0x48,0x02,0x51,0x04,0x42,
 0x45,0x91,0x00,0x10,0x84,0x24,0xa1,0x40,0x09,0x02,0x81,0x40,0x00,0xa0,0x10,
 0x88,0x20,0x91,0x84,0x04,0x40,0x55,0x15,0xa4,0x00,0x14,0x01,0x08,0x00,0x02,
 0x91,0x14,0x28,0x00,0x84,0xfa,0x29,0xa4,0xde,0x09,0x12,0x00,0x08,0x40,0x02,
 0x28,0x40,0x24,0x44,0x04,0x44,0x08,0x00,0x20,0x80,0x08,0xa4,0x22,0x82,0x14,
 0x52,0x82,0x14,0x42,0x01,0xa8,0x02,0x20,0x00,0x85,0x80,0x80,0x54,0x20,0x01,
 0x10,0x04,0x51,0x09,0x12,0x4a,0xaa,0x82,0x10,0x08,0x04,0x25,0xa0,0x10,0x14,
 0x12,0x52,0x09,0x42,0x01,0x00,0x00,0x10,0x22,0x25,0x50,0x15,0x01,0x22,0x41,
 0x48,0x21,0x24,0x20,0x04,0x04,0x11,0x08,0x00,0xe8,0x93,0x88,0xea,0x40,0x44,
 0x22,0x41,0x02,0x20,0x01,0x49,0x04,0x44,0x44,0x12,0x90,0x22,0x09,0x12,0x22,
 0x60,0x8d,0x28,0x40,0x01,0x10,0x40,0x11,0x20,0x01,0x90,0x42,0x92,0x20,0x2a,
 0x20,0x82,0x08,0x00,0x02,0x41,0x24,0x50,0x49,0x21,0x24,0x08,0x00,0x41,0x52,
 0x10,0x15,0x24,0xa0,0x80,0x00,0x40,0x11,0x48,0xa4,0x12,0x85,0x80,0x80,0x92,
 0x2a,0x54,0x08,0x04,0x02,0x80,0x80,0x80,0x10,0x10,0x21,0x41,0x20,0xd1,0x05,
 0x52,0x3f,0x10,0x02,0x08,0x10,0x48,0x0a,0x44,0x20,0x45,0x44,0x04,0x88,0x22,
 0x08,0x40,0x40,0x80,0xa4,0x22,0x02,0x25,0x44,0x44,0x09,0x44,0x12,0x90,0x02,
 0x04,0x08,0x8a,0x80,0x04,0x28,0x02,0x28,0x20,0x14,0x49,0x85,0x90,0x94,0x92,
 0x22,0x41,0x04,0x00,0x41,0x20,0x81,0x04,0x0a,0x84,0x24,0x44,0x02,0x01,0x08,
 0x10,0x0a,0x0a,0xa4,0x14,0x01,0x22,0x20,0x20,0x08,0x10,0x88,0x88,0x44,0x48,
 0x00,0x04,0xe4,0x2a,0xd1,0x15,0x04,0x14,0x81,0x04,0x01,0x80,0x10,0x24,0x10,
 0x45,0x94,0x22,0x20,0x40,0x12,0x14,0x24,0x40,0x15,0x24,0x00,0x11,0x00,0x42,
 0x11,0x40,0x22,0x88,0x42,0x02,0x21,0x28,0x08,0x84,0x80,0x00,0x01,0x40,0x90,
 0x20,0x25,0x22,0x44,0x08,0x14,0x10,0x4a,0x10,0x8a,0x24,0x80,0x20,0x08,0x88,
 0x02,0x50,0x48,0x42,0x85,0x10,0xa1,0x50,0x15,0x54,0x00,0x88,0x88,0x21,0x81,
 0x00,0x20,0x14,0x22,0x00,0x00,0xa8,0x81,0x54,0x8f,0xa0,0x02,0x08,0x00,0x92,
 0x10,0x81,0x60,0x02,0xa4,0x08,0x18,0x49,0x03,0x40,0x81,0x40,0xa9,0x45,0x81,
 0x00,0x04,0x05,0x28,0x00,0x08,0x08,0x42,0x08,0x51,0x04,0x81,0x20,0x52,0x2a,
 0x24,0x42,0x02,0x05,0x4a,0x90,0x44,0x89,0x52,0x80,0x00,0x00,0x81,0x20,0x02,
 0x08,0x02,0x21,0x21,0x08,0x00,0x20,0x00,0x10,0x42,0x04,0xa4,0x2a,0x01,0x15,
 0x02,0x00,0x04,0x08,0x48,0x0a,0x00,0x42,0x89,0x20,0x62,0x09,0xe9,0x17,0x00,
 0x44,0x82,0xa4,0x00,0x04,0x10,0x12,0x92,0x84,0x22,0x21,0x80,0x50,0x12,0x10,
 0x12,0xa0,0x0a,0x00,0x94,0x00,0xa0,0x84,0x42,0x02,0x81,0x10,0x22,0x04,0x11,
 0x28,0x84,0x20,0x00,0x80,0x94,0x54,0x90,0x00,0x25,0x29,0x52,0x08,0x11,0x8a,
 0x48,0x28,0x88,0x40,0x42,0x08,0x08,0x14,0x21,0x89,0x82,0x94,0x04,0x10,0x11,
 0x51,0x15,0x24,0x40,0x10,0x21,0x80,0x20,0x41,0x80,0x24,0x48,0x00,0x00,0xc4,
 0x20,0xb6,0x82,0x24,0x12,0x08,0x00,0x24,0x90,0x04,0x10,0x02,0x24,0x08,0x24,
 0x89,0x04,0x40,0x42,0x40,0x62,0xa5,0x22,0x00,0x12,0x04,0x10,0x00,0xa0,0x00,
 0x02,0x80,0x00,0x00,0x81,0x10,0x4a,0x91,0x10,0x49,0x12,0x49,0x28,0x88,0x44,
 0x08,0x25,0x04,0x00,0x00,0x81,0x00,0x01,0x08,0x81,0x20,0x40,0x00,0x20,0x00,
 0x02,0x50,0x00,0x00,0x94,0x24,0x08,0x05,0x21,0x49,0x49,0x12,0x92,0x24,0x89,
 0x82,0x02,0x08,0x50,0x44,0xf5,0x23,0x04,0x25,0x49,0x12,0x92,0x25,0x65,0x55,
 0xb2,0xa4,0x09,0x49,0x92,0x92,0x2d,0x25,0x49,0xa2,0x0a,0x00,0xa0,0x00,0x11,
 0x89,0x90,0x08,0xa0,0xa8,0x14,0x50,0x44,0x24,0x04,0x10,0x24,0x45,0x22,0x49,
 0x12,0x82,0x22,0x21,0xa5,0x40,0x21,0xa1,0x04,0x14,0x49,0x80,0x40,0x08,0x08,
 0x15,0x40,0x82,0xa0,0xa0,0x04,0x2a,0x84,0x50,0x15,0x22,0x10,0x04,0x00,0x00,
 0x80,0x40,0x04,0x24,0x48,0x88,0x40,0x48,0x11,0xdd,0x82,0x10,0x02,0x20,0x48,
 0x01,0x00,0x00,0x10,0x02,0x84,0x28,0x20,0x00,0x00,0x00,0x00,0x02,0x48,0x03,
 0x44,0x05,0x05,0x44,0x24,0x02,0x20,0x15,0x01,0x02,0x02,0x10,0x11,0x42,0x45,
 0x89,0x50,0x49,0x12,0x49,0x14,0x49,0x4a,0x10,0x15,0x02,0x04,0x50,0x00,0x00,
 0x12,0x12,0x21,0x22,0x20,0x09,0x08,0x0a,0x09,0x42,0x00,0x11,0xa2,0x2a,0x88,
 0x42,0x40,0x12,0x48,0x08,0x08,0x00,0x00,0x82,0x02,0x00,0x20,0xa0,0xb6,0x11,
 0x80,0x88,0x84,0xa4,0x3c,0x88,0x00,0x09,0x81,0x84,0x08,0x49,0x49,0x49,0x40,
 0x92,0xa0,0x62,0x25,0x01,0x00,0x40,0x10,0x00,0x80,0x04,0x40,0x00,0x88,0x00,
 0x22,0x80,0x10,0x20,0x22,0x20,0x92,0xa4,0x24,0x49,0x92,0x90,0x8a,0x48,0x89,
 0x10,0x04,0x40,0x12,0x00,0x00,0x04,0x00,0x49,0x80,0x80,0x40,0x00,0x11,0x00,
 0xa0,0x50,0x15,0x22,0x10,0x09,0x40,0x01,0xa1,0x20,0x2a,0x25,0x04,0x01,0x02,
 0x41,0x44,0x7f,0x80,0x24,0x06,0x08,0x12,0x62,0x21,0x15,0x48,0x09,0xa4,0x48,
 0x48,0x00,0x03,0x05,0x41,0x44,0xa0,0x06,0x10,0x20,0x02,0x00,0x55,0x04,0xa0,
 0x04,0x52,0x25,0x24,0x00,0x49,0x40,0x04,0x88,0x92,0x24,0x09,0x89,0x92,0x48,
 0x25,0x51,0x22,0x04,0x40,0x91,0x12,0x41,0xa2,0x40,0x00,0x14,0x00,0x01,0x10,
 0x09,0x12,0x8a,0x12,0x02,0xa4,0x2a,0x08,0x05,0x00,0x09,0x22,0x00,0x84,0x00,
 0x80,0x20,0x49,0x40,0x10,0xa9,0xd5,0x24,0x00,0x20,0x21,0x81,0x88,0x94,0x02,
 0x09,0xa1,0x04,0x12,0x82,0x52,0x48,0x50,0x10,0x10,0xa8,0x4a,0x4a,0x8a,0x08,
 0x25,0x00,0xa1,0x08,0x89,0x00,0x08,0x01,0x49,0x00,0x92,0xa4,0x50,0x08,0x91,
 0xa4,0xa4,0x24,0x25,0x48,0x94,0x94,0x22,0x09,0x00,0x48,0x10,0x08,0x14,0x08,
 0x01,0x48,0x48,0x44,0x84,0x40,0x21,0x80,0x10,0x51,0x12,0x20,0x90,0x12,0x00,
 0x08,0x09,0x10,0x42,0x24,0x04,0x01,0x08,0x04,0x64,0x3f,0x00,0x91,0x06,0x80,
 0x08,0xa2,0x21,0x15,0x48,0x04,0x94,0x10,0x88,0x00,0x06,0x02,0x85,0x84,0xa0,
 0x02,0x24,0x21,0x44,0x80,0x20,0x00,0x20,0x20,0x4a,0x10,0x04,0x00,0xa9,0x00,
 0x02,0x22,0xa5,0x44,0x92,0x12,0x49,0x90,0x82,0x20,0x41,0x14,0x44,0xa4,0x20,
 0x85,0x2a,0x41,0x22,0xa4,0x00,0x00,0x11,0x51,0x04,0x14,0x09,0x44,0x50,0x15,
 0x0a,0x05,0x20,0x49,0x01,0x40,0x11,0x22,0x04,0x08,0x16,0x00,0x20,0xb1,0x97,
 0x10,0x20,0x00,0x29,0x80,0x10,0x4a,0x94,0x44,0x11,0xa4,0x50,0x09,0x25,0x82,
 0x08,0x21,0x40,0xa4,0x2d,0x09,0x0a,0x00,0x20,0x04,0x00,0x08,0x4a,0x20,0x85,
 0x48,0x2a,0x02,0xa8,0x28,0x91,0x50,0x94,0x48,0x48,0x22,0x25,0x29,0x95,0x94,
 0x02,0x01,0x01,0x94,0x20,0x00,0x15,0x84,0x00,0x24,0x02,0x00,0x0a,0xa8,0x40,
 0x80,0x08,0xa2,0x2a,0x50,0x10,0x00,0x00,0x90,0x04,0x40,0x08,0x50,0x22,0x82,
 0x40,0x00,0xea,0x0e,0x84,0x04,0x15,0x00,0x25,0x44,0x01,0x19,0x02,0x41,0x85,
 0x12,0x20,0x81,0x28,0x20,0x80,0x12,0xa1,0x02,0x24,0xa9,0x4a,0x15,0x00,0x21,
 0x45,0x04,0x95,0x10,0x00,0x00,0x90,0x04,0x85,0x04,0x84,0x12,0x25,0x55,0x95,
 0x44,0x24,0x4a,0x12,0x29,0x14,0x88,0x22,0x0a,0x55,0x48,0x21,0x95,0x00,0x20,
 0x4a,0xa0,0x42,0x02,0x22,0x02,0x54,0x15,0x84,0x84,0x94,0x48,0x04,0x00,0x12,
 0x02,0x05,0x04,0x24,0x08,0x04,0xb9,0x05,0x00,0x00,0x44,0x4a,0x00,0x41,0x90,
 0x64,0x94,0x08,0x84,0x10,0x08,0x11,0x08,0x04,0x29,0x00,0x48,0x4d,0x08,0x02,
 0x20,0x00,0x25,0x04,0x00,0x48,0x04,0x02,0x21,0x49,0x0a,0x51,0x50,0x50,0xa1,
 0xa4,0x88,0x40,0x48,0xa9,0x4a,0x81,0x48,0x0a,0x01,0x00,0x88,0x00,0x08,0x25,
 0x48,0x00,0x08,0x00,0x00,0x0a,0x14,0x11,0x00,0x48,0x91,0x12,0x12,0x22,0x00,
 0x02,0x21,0x92,0x08,0x21,0x10,0x88,0x04,0x00,0x20,0xf6,0x93,0x48,0xa4,0x02,
 0x00,0x24,0x08,0x01,0x52,0x44,0x42,0x30,0x44,0x09,0x42,0x52,0x10,0x01,0x49,
 0x62,0x05,0xa1,0x28,0x82,0x4a,0x00,0x40,0x88,0x22,0xa9,0x20,0x84,0x10,0x50,
 0x04,0x25,0x85,0x00,0x49,0x52,0x2a,0x25,0x12,0x22,0x2a,0x22,0x11,0xa4,0xa2,
 0x24,0x25,0x22,0x00,0x00,0x95,0x42,0xa2,0x00,0xa0,0x48,0x80,0x92,0x20,0xa4,
 0x2a,0x80,0x08,0x45,0x20,0x00,0x00,0x40,0x00,0x44,0x02,0x10,0x41,0x82,0xda,
 0x02,0x02,0x00,0x4a,0x12,0x01,0x82,0x90,0xd0,0x84,0x10,0x04,0x21,0x40,0x0a,
 0x21,0x45,0x44,0x80,0xa0,0x0a,0x28,0x04,0x20,0x00,0x80,0x10,0x22,0x48,0x00,
 0x04,0x01,0x04,0x0a,0x51,0x88,0x50,0xa8,0x24,0x89,0x48,0x49,0x49,0x11,0x91,
 0x14,0xa0,0x02,0x08,0x89,0x00,0x88,0x2a,0x22,0x00,0x00,0x08,0x2a,0x15,0x02,
 0x10,0x00,0x0a,0x51,0x15,0x2a,0x42,0x10,0x84,0x24,0x49,0x0a,0x49,0x44,0x48,
 0x0c,0x08,0x10,0xf6,0x21,0x90,0x24,0x04,0x01,0x48,0x28,0x00,0x2a,0xa2,0x80,
 0x44,0x29,0x12,0x42,0x24,0x00,0x10,0x12,0xa4,0x45,0x40,0x89,0x08,0x49,0x05,
 0x82,0x08,0x02,0x05,0x10,0x90,0x20,0x51,0x08,0x01,0x8a,0x02,0x91,0x24,0x12,
 0x25,0x25,0x45,0x4a,0xa2,0x04,0x48,0x21,0x10,0x45,0x20,0x81,0x88,0x24,0x89,
 0x00,0x00,0xa0,0x08,0x42,0x90,0x00,0x54,0x2a,0x80,0x10,0x04,0x01,0x01,0x80,
 0x00,0x01,0x01,0x08,0x50,0x00,0x80,0xb8,0x89,0x00,0x00,0x02,0x40,0x02,0x81,
 0xa4,0xc0,0x82,0x24,0x24,0x81,0x08,0x14,0x42,0x48,0x05,0x44,0x41,0x25,0x24,
 0x02,0x22,0x02,0x40,0x10,0x01,0x90,0x20,0x81,0x00,0x08,0x08,0x82,0x50,0x22,
 0x48,0x4a,0x82,0xa4,0x90,0x48,0x92,0x22,0x11,0x51,0x12,0x04,0xa5,0x10,0x49,
 0x0a,0x01,0x41,0x00,0x48,0x49,0x08,0x80,0x00,0x01,0x20,0x51,0x15,0x0a,0x22,
 0x11,0x08,0x88,0x00,0x24,0x24,0xa4,0x80,0x10,0x40,0x02,0xea,0x03,0x22,0x92,
 0xa4,0x00,0x08,0x04,0x00,0x2a,0x52,0x80,0x04,0x29,0xa0,0x80,0x90,0x02,0xa0,
 0x20,0xb4,0x8a,0x40,0x49,0x80,0xa8,0x04,0x01,0x24,0x00,0x84,0x08,0x52,0x11,
 0xa5,0x14,0x0a,0x44,0x55,0x24,0x29,0x49,0x25,0x95,0x54,0x94,0x24,0x84,0x00,
 0x90,0x00,0x45,0x80,0x40,0x14,0x04,0x21,0x01,0x04,0x42,0x12,0x0a,0xa4,0x04,
 0xa4,0x12,0xa0,0x40,0x20,0x49,0x49,0x94,0x92,0x00,0x09,0x29,0x22,0x09,0x08,
 0x71,0x97,0x90,0x24,0x0a,0x48,0x52,0x90,0x48,0x50,0x49,0x92,0x24,0x21,0x4b,
 0x9a,0x92,0x64,0x25,0x49,0x42,0x45,0x12,0x90,0x2a,0x02,0x10,0x12,0x01,0x40,
 0x20,0x40,0x00,0x42,0x10,0x42,0x41,0x11,0x82,0x92,0x44,0x12,0x49,0x42,0x0a,
 0x22,0x89,0x52,0x48,0x05,0x54,0x20,0x22,0x14,0x81,0x42,0x08,0x08,0x01,0x00,
 0xa0,0xa0,0x10,0x41,0xa2,0x2a,0x02,0x05,0x05,0x00,0x00,0x02,0x02,0x12,0x44,
 0x00,0x28,0x00,0x40,0xd4,0x07,0x00,0x00,0x22,0x00,0x09,0x01,0x00,0xa9,0x40,
 0x04,0x04,0x25,0x00,0x08,0x00,0x01,0x00,0x04,0xa0,0x15,0x41,0x42,0x00,0x91,
 0x00,0x00,0x24,0x85,0x12,0x11,0x54,0x00,0x49,0x14,0x04,0x44,0x28,0x24,0x89,
 0xa4,0x24,0x29,0xd1,0x44,0x54,0x04,0x21,0x90,0x00,0x85,0x88,0x40,0x24,0x08,
 0x81,0x00,0x28,0x48,0x05,0x02,0x80,0x08,0x29,0x15,0x50,0x20,0x40,0x92,0x44,
 0x40,0x80,0x00,0x00,0x90,0xa0,0x20,0x01,0xe9,0x4f,0x12,0x00,0x0a,0x20,0x54,
 0xa0,0x48,0x44,0x45,0x90,0x24,0x01,0x10,0x51,0x24,0x12,0x2a,0x81,0x64,0x45,
 0x90,0x10,0x4a,0x00,0x84,0x40,0x40,0x28,0x89,0x04,0x01,0x14,0x84,0xa2,0x82,
 0x92,0x44,0x92,0x40,0x52,0x92,0x94,0x14,0x91,0x02,0x52,0x02,0x22,0x4a,0x50,
 0x20,0x12,0x09,0x42,0x10,0x40,0x80,0x42,0xa8,0x10,0x21,0x02,0x50,0x15,0x0a,
 0x85,0x08,0x00,0x01,0x92,0x92,0x28,0xa5,0x04,0x00,0x04,0x04,0xa4,0x8d,0x40,
 0x32,0x44,0x84,0x18,0x12,0x02,0x18,0x41,0x02,0x24,0x49,0x49,0x10,0x81,0x42,
 0x01,0x68,0xa0,0x16,0x49,0x42,0x20,0x49,0x10,0x00,0x09,0xa1,0x54,0x42,0xa0,
 0x80,0x28,0x08,0x11,0x04,0x12,0x24,0x2a,0x89,0x24,0x42,0xa2,0x24,0x54,0x24,
 0x48,0x00,0x21,0x85,0x92,0x40,0xa0,0x10,0x04,0x08,0x09,0x28,0x45,0x02,0x00,
 0x24,0x55,0x29,0x40,0x10,0x82,0x24,0x90,0x00,0x42,0x00,0x00,0x20,0x49,0x00,
 0x20,0xd1,0x17,0x04,0x80,0x02,0x10,0x95,0xc8,0x90,0xa4,0x20,0x80,0x04,0x01,
 0x02,0x12,0x14,0x14,0x40,0x02,0x49,0x45,0x02,0x24,0x0a,0x00,0x01,0x00,0x40,
 0x12,0x92,0x10,0x00,0x12,0x82,0x52,0x44,0x51,0x44,0x92,0x84,0x54,0x52,0xa9,
 0x14,0x49,0x11,0x89,0x02,0x49,0x10,0x28,0x04,0x14,0x05,0x40,0x80,0x00,0x80,
 0x42,0x29,0x89,0x24,0x09,0x40,0x15,0x0a,0x41,0x08,0x00,0x02,0x00,0x00,0x42,
 0xa4,0x08,0x10,0x21,0x00,0xa4,0x1f,0x10,0x01,0x0a,0x00,0x0a,0x15,0x02,0x8a,
 0x24,0x29,0x24,0x09,0x08,0x20,0x41,0x84,0x04,0x00,0x60,0x15,0x54,0x91,0xa0,
 0x24,0x24,0x04,0x22,0x40,0x29,0x05,0x95,0x08,0x28,0x88,0x28,0x4a,0x11,0x48,
 0x52,0xa2,0x84,0x44,0x52,0x22,0x4a,0x24,0x48,0x00,0x49,0x41,0x52,0x21,0x50,
 0x02,0x09,0x00,0x29,0x04,0xa5,0x24,0x82,0x00,0x34,0x15,0x40,0x24,0x40,0x22,
 0x41,0x94,0xa4,0x20,0x04,0x90,0x50,0x00,0x49,0x48,0x3d,0x41,0x28,0x12,0xa4,
 0x54,0x84,0x50,0x95,0x48,0x00,0x24,0xa1,0xa8,0x24,0x02,0x08,0x51,0xd2,0xa4,
 0x8a,0x02,0x04,0x0a,0x00,0x81,0x80,0x88,0x2a,0x8a,0xa8,0x00,0x02,0x00,0x45,
 0x82,0x10,0x40,0x21,0x80,0x14,0x52,0x2a,0x89,0x94,0x44,0x89,0x12,0x52,0x00,
 0x94,0x04,0x92,0x0a,0x24,0x20,0x40,0x80,0x52,0x12,0x89,0x20,0x12,0xa1,0x2a,
 0x2a,0x81,0x12,0x08,0x08,0x01,0x40,0x08,0x91,0x04,0x0a,0x04,0x00,0xd1,0x17,
 0x04,0x00,0x04,0x00,0x0d,0x10,0x8a,0x80,0x20,0x92,0x04,0x02,0x02,0x40,0x28,
 0x49,0x00,0x00,0xa0,0x25,0x28,0x50,0x91,0x12,0x04,0x10,0x02,0x49,0x51,0x11,
 0x92,0x10,0x2a,0x28,0x29,0x45,0x15,0x44,0x45,0xa2,0x8a,0x90,0x52,0x22,0x29,
 0x11,0x01,0x00,0x25,0x01,0x28,0x00,0x90,0x80,0x02,0x08,0x45,0x24,0xa9,0x10,
 0x84,0x00,0x54,0x09,0x00,0x28,0x00,0x01,0x02,0x20,0x05,0x00,0x84,0x20,0x24,
 0x40,0x04,0x88,0xbe,0x00,0x24,0x05,0x92,0x04,0x82,0x60,0x55,0xa2,0x20,0x55,
 0x4a,0x00,0x52,0x02,0x10,0x24,0x25,0xa4,0x8a,0x44,0x09,0x40,0x04,0x01,0xa0,
 0x40,0x90,0x14,0x8a,0x40,0x84,0x40,0x45,0x44,0x02,0x40,0x11,0x28,0x29,0x51,
 0x4a,0x28,0x89,0x44,0x44,0x24,0x55,0x08,0x50,0x82,0x54,0x45,0x2a,0x00,0x41,
 0x10,0x91,0x04,0xa5,0x22,0xa4,0xa0,0x2a,0xaa,0x82,0x0a,0x50,0x91,0x88,0x50,
 0x22,0x00,0x88,0x12,0x05,0x90,0x50,0x3f,0x52,0x00,0x12,0x40,0x4a,0x12,0x15,
 0x49,0x20,0x4a,0xa8,0x42,0xac,0x40,0x22,0xa1,0x01,0x40,0xa1,0x02,0x12,0xa0,
 0x22,0x48,0x00,0x09,0x95,0x4a,0xa2,0x50,0x0a,0x21,0x88,0x90,0x2a,0xa4,0x2a,
 0xa4,0x22,0x42,0x8a,0xa4,0x42,0x25,0x29,0xa9,0x88,0x00,0x40,0x01,0x29,0x01,
 0x00,0x81,0x08,0x28,0x45,0x4a,0x2a,0x04,0x88,0x00,0x50,0x15,0x00,0x28,0x80,
 0x04,0x00,0x00,0x21,0x88,0x94,0x22,0x04,0x20,0x02,0x24,0x75,0x00,0x49,0x04,
 0x09,0x95,0xa4,0x40,0x0a,0x14,0x11,0x85,0xaa,0x12,0x8a,0x08,0x24,0x48,0x12,
 0x60,0xad,0x84,0x12,0x88,0x12,0x14,0xa0,0x48,0x01,0x29,0x25,0x41,0x82,0x42,
 0x24,0x40,0x41,0x00,0x11,0x88,0x94,0x24,0x49,0xaa,0x88,0x84,0x24,0x22,0xa2,
 0x12,0x48,0x44,0xa0,0xaa,0x10,0x02,0x44,0x22,0x21,0xa1,0xaa,0x42,0xa2,0x52,
 0x2a,0x4a,0x81,0x2a,0x00,0x12,0x01,0x04,0x00,0x84,0xa0,0x82,0x0a,0x10,0x90,
 0x7f,0x01,0x00,0x01,0x20,0x49,0x02,0x12,0x4c,0x50,0x44,0x28,0x25,0xa9,0xa2,
 0x20,0x40,0x00,0x40,0x4a,0x03,0x10,0xa1,0x22,0x88,0x40,0x15,0x25,0xaa,0x44,
 0x4a,0x04,0x49,0x28,0x49,0x15,0x0a,0x49,0x44,0x50,0x22,0x49,0x92,0x14,0x25,
 0x29,0x91,0x88,0x08,0x80,0x20,0x11,0x15,0x00,0x05,0x90,0x12,0x95,0x44,0x8a,
 0xa8,0x10,0x09,0x50,0x25,0x10,0x28,0x00,0x49,0x41,0x50,0xa1,0x44,0x00,0x88,
 0x20,0x00,0x41,0x22,0xfa,0x48,0x52,0x14,0x84,0x10,0xa8,0x04,0x25,0x11,0x01,
 0x42,0x90,0x44,0x0a,0x06,0x49,0x25,0x49,0xa0,0x8a,0x4a,0x14,0x88,0x02,0x02,
 0x48,0x12,0x11,0x91,0x24,0x51,0x10,0x02,0x10,0x48,0x51,0x10,0x10,0x0a,0x94,
 0xa4,0x24,0x85,0x50,0x4a,0x4a,0x02,0x42,0x09,0x04,0x80,0x40,0x55,0x40,0x02,
 0xa8,0x48,0x92,0x24,0x45,0x04,0x40,0x25,0x15,0x42,0x85,0x04,0x00,0x08,0x02,
 0x00,0x10,0xa5,0x60,0x82,0x16,0x04,0x40,0xdd,0x00,0x80,0x80,0x10,0x42,0x01,
 0x90,0x2a,0x44,0x54,0x88,0x0a,0x92,0x42,0x90,0x80,0x80,0x00,0x61,0x25,0x20,
 0xa1,0x12,0x20,0x88,0x92,0x48,0x4a,0x4a,0x52,0x04,0x44,0x88,0x40,0x25,0x02,
 0xa5,0xa2,0x90,0x48,0x92,0x92,0x28,0x85,0x90,0x24,0x29,0x28,0x44,0x90,0x2a,
 0x0a,0x90,0x08,0x88,0x02,0x91,0x24,0x52,0x92,0x54,0x12,0x50,0x29,0x10,0x00,
 0x41,0x92,0x00,0x40,0x29,0x02,0x00,0x22,0x00,0x85,0x80,0x24,0xfa,0x89,0x28,
 0x04,0x80,0x10,0x20,0x02,0x84,0x10,0x00,0x22,0xa0,0x08,0x15,0x01,0x92,0x28,
 0x52,0xa4,0x0a,0x4a,0x08,0x44,0x15,0xa2,0x48,0x92,0x22,0x21,0x24,0x22,0x89,
 0x22,0x24,0x08,0xa9,0x10,0x08,0x04,0x25,0x49,0x24,0x44,0xa2,0x4a,0x42,0x82,
 0x02,0x11,0x04,0x80,0x40,0x05,0x92,0xa2,0xa8,0x24,0x4a,0x89,0x28,0x01,0x44,
 0x55,0x15,0x42,0x15,0x24,0x49,0x4a,0x95,0x90,0x28,0x95,0x98,0xa8,0x2a,0x08,
 0x40,0xdd,0x10,0x02,0x21,0x25,0x42,0x82,0xa8,0x26,0x85,0xa4,0x88,0x02,0xa1,
 0x92,0x9a,0x24,0x25,0x49,0xa2,0x45,0x20,0xa2,0x10,0x40,0x11,0x25,0x49,0x94,
 0x94,0x89,0x08,0x20,0x04,0x81,0x50,0x04,0x4a,0xa0,0x10,0x48,0x92,0x92,0x2a,
 0x49,0x92,0x28,0x04,0x28,0x40,0xa1,0x14,0x0a,0x28,0x40,0x08,0x05,0x89,0x90,
 0x50,0x82,0x44,0x11,0x50,0x15,0x28,0x80,0x08,0x00,0x00,0x40,0x04,0x00,0x84,
 0x20,0x40,0x07,0x42,0x92,0xf4,0x83,0x10,0x00,0x00,0x08,0x28,0x00,0x14,0x00,
 0x08,0x20,0x54,0x48,0x06,0x01,0x00,0x02,0x00,0x48,0x15,0x09,0x09,0x44,0x24,
 0x84,0x10,0x00,0x01,0x49,0x24,0x45,0x15,0x41,0x44,0x0a,0xa9,0x20,0x48,0x84,
 0x92,0xa4,0x24,0x41,0x12,0x49,0x02,0x51,0x02,0x09,0x08,0xa1,0xa2,0x02,0x15,
 0x82,0x50,0x42,0x0a,0x0a,0x55,0x28,0x08,0xa5,0x2a,0x82,0x2a,0x42,0x50,0xdb,
 0xaa,0x5a,0x6b,0x55,0x07,0xc9,0x5a,0x00,0x00,0xf5,0x2b,0x05,0x24,0x24,0x21,
 0x01,0x49,0x6b,0x91,0x20,0x85,0x00,0xa1,0x6a,0xb6,0x6d,0xd5,0xd6,0xb2,0xa2,
 0xa4,0xa4,0x08,0x11,0x21,0xa5,0x2a,0xaa,0x24,0x51,0x20,0x42,0x02,0x11,0x20,
 0x02,0x8a,0x24,0x01,0x20,0x09,0x49,0x8a,0xa4,0x24,0x54,0x02,0x29,0x20,0x20,
 0x44,0x44,0x54,0x20,0x49,0x4a,0x08,0xa4,0xa4,0x90,0x80,0xa2,0x90,0x14,0x20,
 0x80,0x10,0xc4,0x6a,0x5b,0xab,0xb5,0x6a,0x11,0xa4,0x8f,0x28,0x49,0xa9,0xee,
 0x16,0x01,0x01,0x00,0x44,0x00,0x5a,0x00,0x8a,0x00,0x52,0x08,0xb6,0xd7,0xb6,
 0x6d,0xbb,0x5d,0x4d,0x40,0x02,0x52,0x24,0x08,0x48,0x80,0x24,0x49,0x0a,0x09,
 0x90,0x54,0x00,0x4a,0xa9,0xa0,0x48,0xa4,0x94,0xa4,0x24,0x29,0x11,0x89,0x82,
 0x54,0x02,0x84,0x44,0x11,0x09,0x02,0x15,0x80,0x24,0x42,0x91,0x52,0x2a,0x25,
 0x10,0x52,0x15,0x8a,0x2a,0x8a,0xb0,0xad,0x6a,0x6d,0xad,0x5b,0x45,0xe8,0x56,
 0x00,0x00,0xfa,0xab,0x05,0x48,0x48,0x4a,0x10,0x52,0x2d,0x41,0x20,0x15,0x08,
 0x41,0xad,0x5a,0x55,0xb7,0x6d,0xab,0x82,0x8a,0x48,0x00,0x81,0xa0,0x12,0x25,
 0x90,0x24,0xa9,0x40,0x4a,0x82,0x54,0x11,0x12,0x04,0x12,0x42,0x48,0x92,0x92,
 0xa4,0xa2,0x24,0x28,0x02,0x88,0x10,0x90,0x44,0x44,0x28,0x40,0x29,0x92,0x28,
 0x24,0x84,0x40,0x00,0x49,0xa9,0x2a,0x20,0x90,0x00,0x52,0x22,0x49,0x12,0x42,
 0xa4,0x00,0xaa,0x2b,0x89,0x24,0xd1,0x53,0x42,0x02,0x90,0x00,0x05,0x04,0x52,
 0x00,0xa9,0x82,0x42,0x14,0x55,0x55,0x55,0xa9,0x56,0xb5,0x55,0x20,0x01,0x52,
 0x28,0x94,0xa4,0x10,0x25,0x49,0x12,0x95,0x00,0x20,0x00,0x44,0x49,0xa0,0xa4,
 0x28,0x22,0x49,0x48,0x4a,0x48,0x88,0x82,0x50,0x25,0x04,0x24,0x48,0x11,0x02,
 0x15,0x44,0x49,0x85,0x42,0x29,0x2d,0x95,0x20,0xa0,0x12,0x8a,0x42,0x4a,0x28,
 0x84,0x04,0x41,0x08,0x40,0x11,0xe9,0x22,0x20,0x10,0x6a,0x03,0x14,0x40,0x02,
 0x2a,0x80,0x50,0x25,0x10,0x50,0x01,0x88,0x21,0xaa,0xa4,0xaa,0x4a,0xa9,0x56,
 0x05,0x05,0x24,0x04,0x85,0x22,0x49,0x4a,0x82,0x10,0x49,0x00,0x52,0x08,0x80,
 0x14,0x22,0x09,0x00,0x42,0x89,0xa4,0x4a,0x91,0x12,0x51,0x10,0x05,0x80,0x90,
 0x80,0x02,0x40,0x28,0x40,0x08,0x12,0x14,0x8a,0x44,0x90,0x00,0x89,0x28,0x15,
 0x20,0x10,0x01,0x10,0x29,0x50,0x28,0x22,0x55,0x84,0xb4,0x51,0x05,0x42,0xd2,
 0x57,0x81,0x0a,0xd0,0x44,0x05,0x02,0x15,0x40,0xa5,0x2a,0x42,0xae,0x25,0x55,
 0x52,0xaa,0x54,0xaa,0x4a,0x50,0x09,0xa1,0x20,0x48,0x92,0x82,0x14,0x4a,0x92,
 0xaa,0x24,0x82,0x12,0xa1,0x94,0x50,0xaa,0x14,0x52,0x92,0x24,0xa4,0x84,0x14,
 0x42,0x50,0x15,0x25,0x28,0x50,0x89,0x44,0x15,0xd2,0xa4,0xa2,0x04,0x92,0x4a,
 0x54,0x22,0xa2,0x2a,0x82,0x4a,0x94,0xac,0x40,0x01,0x81,0x88,0x10,0x41,0xfa,
 0x20,0x91,0x08,0xa4,0x01,0x2a,0x41,0x44,0x55,0x01,0x48,0x89,0x10,0xa8,0x00,
 0x28,0x55,0x4a,0xa9,0x4a,0xa9,0x92,0x4d,0x13,0x09,0xa0,0x14,0x8a,0x92,0x24,
 0x14,0x21,0x91,0x44,0x00,0x91,0x28,0x40,0x84,0x40,0x42,0x44,0xa0,0x20,0x49,
 0x92,0x12,0x52,0xa2,0x20,0x05,0x48,0x80,0x82,0x02,0x02,0x12,0x48,0x0a,0x49,
 0x04,0x51,0x24,0x92,0x22,0x14,0xa8,0x0a,0x50,0x10,0x05,0x10,0x14,0x54,0x24,
 0x22,0x50,0x10,0x5d,0x4a,0x02,0x80,0xd2,0x57,0x91,0x00,0x51,0x91,0x00,0x21,
 0x25,0x00,0x32,0x05,0x42,0x25,0x55,0x25,0xa9,0x2a,0x55,0x66,0x0d,0xa2,0x0a,
 0x02,0x11,0x24,0x91,0x49,0x48,0x4a,0x29,0x55,0x24,0x82,0x84,0x52,0x2a,0x12,
 0x11,0x0a,0x4a,0x92,0x44,0x88,0x84,0x94,0x82,0xd0,0x12,0x24,0x24,0x50,0x51,
 0x01,0x05,0x41,0x92,0x52,0x24,0xa2,0x24,0x91,0xa2,0x52,0x29,0x0a,0xa5,0x90,
 0xae,0xa2,0x80,0x90,0x80,0x0a,0xa0,0x36,0xa0,0x24,0x49,0xa4,0x07,0x24,0x00,
 0xc0,0x4a,0x42,0x44,0x09,0xa8,0x54,0x02,0x89,0x4a,0x29,0x55,0x55,0x52,0x55,
 0x4b,0x25,0x09,0xa0,0xa8,0x48,0x92,0x24,0x22,0x25,0x10,0x42,0x2a,0x81,0x24,
 0x10,0x24,0x84,0x24,0x24,0xa8,0x90,0x24,0x91,0x52,0x12,0x29,0x52,0x0a,0x42,
 0x90,0x40,0x05,0x04,0x55,0x10,0x54,0x49,0x08,0x49,0x94,0x44,0x54,0x00,0xa4,
 0x2a,0x40,0x08,0x0a,0x08,0x08,0x2a,0x04,0x28,0x24,0x49,0x6d,0x89,0x02,0x02,
 0xa8,0x5e,0x89,0x22,0x29,0x91,0x00,0x10,0x25,0x00,0x50,0x09,0x40,0xaa,0x94,
 0x92,0x4a,0x55,0x49,0x65,0x45,0x40,0x15,0x02,0x82,0x24,0x92,0x94,0x10,0x45,
 0x29,0x81,0x28,0x00,0x44,0x89,0x22,0x89,0x89,0x12,0x24,0x49,0x4a,0x84,0xa4,
 0x44,0x01,0xa1,0x94,0x0a,0x15,0x50,0xa1,0x00,0xa5,0x12,0x12,0x55,0x12,0x41,
 0x92,0x0a,0x54,0x21,0x15,0x12,0xa1,0x20,0xa6,0xa2,0x40,0x51,0x81,0x04,0x90,
 0x3f,0xa4,0x14,0x48,0x92,0x8b,0x10,0x00,0xd0,0x4a,0x82,0xa0,0x0a,0x24,0x2d,
 0x00,0xa5,0x2a,0xa5,0x54,0x52,0xa5,0xaa,0xa7,0x2a,0x15,0xa0,0x2a,0x09,0x51,
 0x49,0x20,0x45,0x28,0x44,0x2a,0xa2,0x08,0x02,0x12,0x88,0x10,0x02,0x49,0x91,
 0x92,0x88,0x52,0x12,0x09,0x42,0x94,0x08,0x24,0xa8,0x02,0x44,0x2a,0x08,0xa9,
 0x48,0x40,0x49,0x94,0x48,0x50,0x21,0xa8,0x2a,0x44,0x28,0x09,0x4a,0x10,0x14,
 0x04,0x28,0x4a,0x64,0x15,0x81,0x82,0x82,0xa0,0x2e,0xa4,0x02,0x49,0x91,0x00,
 0x4a,0x49,0x40,0x90,0x05,0x08,0x95,0xaa,0xaa,0xaa,0x54,0xaa,0xa4,0x46,0x80,
 0x22,0x81,0x50,0x04,0x12,0x95,0x28,0x82,0x28,0x49,0x11,0x42,0xa8,0xa4,0x22,
 0x44,0x50,0xa4,0x44,0x44,0x52,0x89,0xa4,0xa4,0x08,0x22,0x52,0x89,0x02,0x54,
 0x91,0x82,0x92,0x10,0x92,0x2a,0x92,0x42,0x24,0x95,0x14,0xa1,0x12,0x10,0x45,
 0xa2,0x25,0xa5,0xa2,0xa8,0x82,0x01,0xa9,0x4f,0x24,0x29,0x08,0x4a,0x9f,0x02,
 0x10,0xa4,0x24,0x20,0x20,0x05,0x04,0x2d,0x80,0xa0,0xaa,0x24,0xa5,0x94,0xaa,
 0xd2,0xa3,0x95,0x16,0x94,0x54,0xa2,0xb2,0x48,0x42,0x42,0x29,0x92,0x24,0x24,
 0x28,0x01,0x11,0x88,0x22,0x85,0x12,0x89,0x88,0x04,0x52,0x08,0x49,0x21,0x49,
 0x84,0x24,0x54,0x21,0x24,0x54,0x20,0xa5,0x44,0x42,0x40,0x28,0x48,0x22,0x48,
 0x54,0x15,0x45,0x50,0x09,0x8a,0x08,0x08,0x02,0x50,0x12,0xd2,0x15,0x08,0x0a,
 0xa0,0x20,0x5d,0x54,0x81,0x50,0x89,0x02,0x89,0x52,0x20,0xb2,0x04,0x4a,0x4b,
 0x95,0x52,0x4a,0x25,0x55,0x4a,0xa5,0xa0,0x20,0x09,0x49,0x48,0x92,0x24,0x11,
 0x42,0x24,0x49,0x11,0x12,0x54,0x84,0x22,0x08,0x52,0xa4,0x24,0x25,0xa9,0x14,
 0xa5,0x24,0x14,0xa4,0x52,0x49,0xa5,0x14,0x92,0x82,0x4a,0x49,0x92,0x24,0x15,
 0x05,0x24,0x91,0x12,0x50,0x2a,0x10,0x85,0x48,0x25,0x52,0x51,0x54,0x45,0x41,
 0x6c,0x47,0xa1,0x92,0x02,0xaa,0x3e,0x21,0x40,0xa4,0x52,0x40,0xa0,0x05,0x89,
 0x18,0x41,0x80,0x92,0x54,0x4a,0x55,0x4a,0xa9,0x61,0x15,0x15,0x95,0xa4,0x94,
 0x82,0x44,0x90,0x44,0x08,0x48,0x24,0x4a,0x48,0x82,0x50,0x84,0xa0,0x24,0x11,
 0x49,0x52,0x24,0xa1,0x14,0x49,0x29,0x09,0x24,0x12,0x08,0xa1,0x48,0x2a,0x29,
 0xa2,0x44,0x90,0x40,0x50,0x91,0x24,0x44,0xaa,0x12,0x44,0x20,0x02,0x89,0x04,
 0x84,0x02,0x50,0x88,0xea,0x13,0x08,0x25,0x90,0x20,0x6d,0x14,0x11,0xc8,0x24,
 0x00,0x52,0x29,0x20,0x54,0x00,0x52,0x55,0x4a,0x55,0x25,0x55,0xd5,0xa2,0x4a,
 0x41,0x22,0x49,0x42,0x54,0x12,0x0a,0x29,0x92,0x92,0x12,0x04,0x25,0x28,0x04,
 0x22,0x0a,0x91,0xa4,0x24,0x11,0x49,0x28,0x42,0x92,0x44,0x50,0x91,0xa4,0xa5,
 0x14,0x92,0x44,0x42,0x09,0x12,0x24,0x2a,0x08,0x48,0x12,0x91,0x90,0x2a,0x02,
 0x49,0xa8,0x51,0x52,0x29,0xa8,0x52,0x20,0xba,0x42,0x21,0x8a,0x42,0x44,0x3e,
 0x21,0x00,0x31,0x49,0x22,0x48,0x85,0x84,0x94,0x48,0x48,0xa9,0x94,0x24,0xa9,
 0x54,0x6a,0x49,0x25,0x2a,0x49,0x12,0xa9,0x92,0x44,0x50,0x84,0x08,0x49,0x44,
 0x51,0x88,0x92,0x50,0x89,0x50,0x44,0x4a,0x52,0x4a,0x22,0x45,0x29,0x49,0x92,
 0x20,0x24,0x12,0x12,0x49,0x25,0x29,0x29,0x92,0x24,0x89,0x84,0xa4,0x8a,0x44,
 0x02,0xa5,0x0a,0x50,0x82,0x84,0x0a,0x21,0x02,0x05,0x94,0x84,0xea,0x11,0x88,
 0x24,0x10,0x91,0x7a,0x8a,0x42,0xc4,0x24,0x00,0x42,0x29,0x10,0x21,0x10,0xa2,
 0x4a,0xa5,0xaa,0x54,0x25,0xd5,0xc0,0x16,0x89,0x94,0xa4,0x24,0x24,0x12,0x24,
 0x29,0x44,0x84,0x12,0x14,0x25,0x24,0x02,0x22,0x0a,0x21,0x91,0x84,0x90,0x84,
 0x28,0x8a,0x84,0x24,0x12,0x48,0xc9,0xa4,0xa4,0x90,0x04,0x4a,0x29,0x09,0x52,
 0x52,0x08,0x44,0x12,0xa9,0xa8,0x2a,0x02,0x20,0xc8,0x50,0x94,0x28,0x50,0x0a,
 0x50,0xbd,0x44,0x25,0xaa,0x04,0x44,0xed,0x50,0x10,0x28,0x49,0x50,0xa8,0x92,
 0x00,0x94,0x42,0xa9,0x92,0x2a,0x49,0xa5,0xaa,0x6a,0xa5,0xa2,0x24,0x51,0x42,
 0x52,0x89,0xa4,0x92,0x44,0x28,0x29,0x44,0xa1,0x84,0x90,0x28,0x89,0x24,0x48,
 0x4a,0x12,0x45,0x28,0x45,0x51,0x52,0x92,0xa0,0x12,0x12,0x09,0x09,0x25,0x69,
 0x90,0x44,0x52,0x08,0x09,0x51,0x29,0x41,0x24,0x55,0x15,0x50,0x45,0x52,0x8a,
 0x22,0x8a,0x8a,0x22,0x49,0x57,0x21,0x80,0x14,0x41,0x11,0xf9,0x0a,0x00,0xe5,
 0x92,0x00,0xc2,0x54,0x48,0x01,0x10,0x50,0x55,0xa9,0xaa,0x2a,0x55,0xb5,0x62,
 0x15,0x51,0x0a,0x29,0x89,0x24,0x12,0x04,0x21,0x85,0x40,0x81,0x14,0x29,0x45,
 0x44,0x52,0x22,0x91,0x22,0x49,0x22,0x45,0x92,0x08,0x89,0x48,0x02,0xa4,0x48,
 0x52,0x52,0x92,0x84,0x4a,0x12,0x09,0x42,0xa2,0x48,0x40,0x8a,0x12,0xa1,0x24,
 0x0a,0x80,0xe4,0x7d,0xef,0xf5,0x75,0x09,0xa4,0x7e,0xdf,0x7f,0xab,0x14,0x40,
 0xf6,0xb7,0x20,0xa8,0x6e,0x40,0xa8,0xab,0x02,0x94,0x44,0xd5,0xee,0xd6,0xb6,
 0xdb,0xb5,0x55,0xa2,0xa6,0x04,0x51,0x42,0x52,0x12,0x41,0x50,0x14,0x28,0x15,
 0x25,0x42,0x00,0x28,0x91,0x88,0x08,0x24,0x14,0x92,0x94,0x28,0x29,0xa5,0x24,
 0x25,0x51,0x49,0x52,0x49,0x24,0x29,0x29,0x25,0x29,0xa4,0x28,0x08,0x92,0x8a,
 0x20,0x48,0x94,0x2a,0x80,0x2a,0x08,0x82,0x10,0x0a,0x8a,0x02,0xa9,0xb7,0x24,
 0x80,0x54,0x00,0x15,0xa9,0x2f,0x08,0x24,0x11,0x10,0x52,0x51,0x21,0x01,0x01,
 0x2a,0x11,0x29,0x49,0x24,0x08,0x29,0x4a,0x15,0x52,0x4a,0x29,0x09,0x49,0x28,
 0x89,0xa2,0x92,0xa0,0x00,0x29,0xaa,0x82,0x24,0x22,0xa5,0x8a,0x42,0x49,0x22,
 0x85,0x84,0x28,0x92,0x88,0x04,0x12,0x15,0x12,0x49,0x8a,0x92,0x90,0x44,0x08,
 0x02,0x53,0x25,0x50,0x85,0x12,0x52,0x15,0x2a,0x88,0x22,0x00,0x40,0x20,0x31,
 0x28,0xd2,0x2e,0x82,0x04,0x90,0x52,0x40,0xfa,0x1f,0x40,0x59,0x40,0x40,0xa8,
 0x84,0x84,0x28,0x54,0x05,0x04,0x00,0x00,0x81,0x22,0x82,0x60,0xa5,0x88,0x90,
 0x92,0xa4,0x12,0x44,0x12,0x14,0x49,0x02,0x49,0x80,0x04,0x54,0x92,0x94,0x08,
 0x51,0x94,0x24,0x49,0x28,0x2a,0x91,0x48,0x22,0x29,0x24,0x50,0xa1,0x20,0x51,
 0x22,0x4a,0x0a,0x51,0x54,0x84,0x48,0x05,0x00,0x41,0x51,0x15,0x00,0x25,0x08,
 0x29,0x89,0x02,0xa9,0x82,0xb4,0xfb,0x7f,0x22,0x5d,0x04,0x94,0xa4,0x5d,0x11,
 0x22,0x08,0x10,0x44,0x81,0x08,0x82,0x00,0x2a,0x91,0x44,0x26,0x14,0x81,0xa4,
 0xa2,0x15,0x52,0x4a,0x20,0x09,0xa8,0x90,0x44,0x45,0x82,0xa8,0x00,0x55,0xa2,
 0x02,0x09,0x21,0xa5,0x08,0x49,0x42,0x12,0x45,0x91,0x44,0x92,0x54,0x0a,0x89,
 0x4a,0x14,0x4a,0x24,0x49,0x05,0x52,0x84,0x22,0x29,0x82,0x40,0xa9,0x28,0x52,
 0x29,0x4a,0x08,0x02,0x80,0x40,0x48,0x4b,0x00,0xd1,0xd6,0x5a,0x40,0xab,0x50,
 0x01,0xea,0x17,0x00,0x34,0x21,0x42,0xa9,0x28,0x02,0x08,0xf5,0x08,0x0c,0x10,
 0x80,0x04,0x04,0x58,0x48,0xa5,0x84,0xa4,0x8a,0xa4,0x42,0x22,0x2a,0x10,0x09,
 0x02,0x52,0x80,0x08,0xa9,0x20,0x44,0x08,0x51,0x22,0x89,0x48,0x2a,0x22,0x2a,
 0x49,0x42,0x11,0x52,0x24,0xa9,0x24,0x49,0x04,0x52,0x49,0x90,0x94,0x40,0x09,
 0x2a,0x00,0x42,0x49,0x15,0x10,0x52,0x54,0x09,0x52,0x64,0x25,0xa8,0xb4,0x7d,
 0x77,0xb4,0x55,0x04,0x50,0x51,0x7a,0x25,0x29,0x44,0x10,0xa8,0x94,0x00,0x50,
 0x12,0x92,0xe8,0x04,0x22,0x94,0x50,0x02,0x60,0x15,0x51,0x12,0x01,0x12,0x95,
 0x48,0x81,0x44,0xa2,0xa4,0x00,0x4a,0x52,0x24,0x94,0x92,0x52,0x24,0x49,0x2a,
 0x55,0x89,0x94,0x84,0x04,0x29,0x0a,0x88,0x92,0x04,0x49,0x22,0x49,0x89,0x24,
 0x21,0x09,0x2a,0xa4,0x00,0x12,0x09,0x50,0x15,0x42,0x24,0x20,0x48,0xa9,0x5a,
 0x89,0x82,0x52,0xa5,0xbd,0xaa,0x4a,0x51,0x05,0x4c,0xab,0x02,0x54,0x12,0x80,
 0x54,0xa1,0x02,0xa5,0xac,0x08,0x41,0xd3,0x92,0x24,0x25,0x49,0xa3,0x4a,0x8a,
 0x48,0x2a,0x49,0x24,0x20,0x2a,0x14,0x09,0x10,0x8a,0x24,0x01,0x92,0x42,0x24,
 0x24,0x92,0x24,0x51,0x02,0x22,0x49,0x52,0x50,0x92,0x54,0x52,0x24,0x29,0x22,
 0x49,0x02,0x52,0x92,0x94,0x24,0x90,0x12,0x52,0x40,0x52,0xa5,0x2a,0x10,0x49,
 0x01,0x02,0x50,0x55,0x25,0x90,0x54,0x55,0x6f,0xaa,0x2a,0x04,0xa0,0xa2,0x6a,
 0x4b,0x29,0x00,0x24,0x50,0x8a,0x08,0x10,0x62,0x51,0x14,0x00,0x00,0x08,0x00,
 0x20,0x48,0x15,0x21,0x95,0x42,0x90,0x92,0x0a,0x09,0x41,0x52,0x89,0x00,0x42,
 0x92,0x04,0x28,0x49,0x91,0x48,0x92,0x88,0xa8,0x94,0x24,0x11,0x2a,0x49,0x22,
 0x08,0x49,0x92,0x94,0x24,0xa9,0x88,0x24,0x02,0x12,0x49,0x84,0x10,0x0a,0x84,
 0x50,0x12,0x42,0x14,0x89,0x48,0xd0,0x22,0x80,0x80,0x22,0xa9,0x3b,0x25,0x49,
 0x50,0x0a,0x28,0x95,0x05,0x2a,0x51,0x80,0x2a,0x60,0x41,0x42,0xa9,0x12,0x02,
 0x06,0x4a,0x92,0x24,0x09,0xa0,0x25,0x4a,0x22,0x94,0x24,0x4a,0x92,0x20,0x54,
 0x04,0x50,0x52,0x94,0x00,0x92,0x92,0x00,0x22,0x25,0x49,0x52,0x52,0x42,0x42,
 0xc4,0x42,0x92,0x4a,0x50,0x92,0x44,0x22,0x49,0x42,0x10,0x49,0x29,0x41,0x24,
 0x51,0x48,0x21,0x29,0x51,0x15,0x14,0xa1,0x20,0x00,0xa5,0x94,0x2a,0x2a,0x94,
 0xd4,0x2e,0x52,0x12,0x05,0x41,0x45,0x49,0x83,0x10,0x04,0x24,0x08,0x92,0x84,
 0x10,0x88,0x16,0x8a,0x50,0x02,0x10,0x01,0x40,0xa5,0x8a,0x22,0x49,0x25,0x49,
 0x21,0x21,0x0a,0x89,0xa2,0x0a,0x01,0x21,0x95,0x44,0x24,0x54,0x49,0x88,0x24,
 0x89,0x24,0x29,0x91,0x22,0xa8,0xa4,0x50,0x21,0x49,0x22,0x91,0x24,0x29,0x4a,
 0x22,0x42,0x10,0x49,0x0a,0x92,0x40,0x42,0xa5,0x2a,0x40,0x94,0x02,0x09,0x50,
 0x41,0x00,0x00,0x41,0xa2,0x3f,0x05,0x41,0x90,0x14,0x10,0x54,0x15,0x2e,0x20,
 0x10,0xa1,0x60,0x00,0x42,0x51,0x5a,0x22,0x04,0x90,0x10,0x24,0x09,0x60,0x55,
 0x94,0x94,0x48,0x84,0x44,0x0a,0x20,0x52,0x14,0x50,0x54,0x0a,0x40,0x92,0x92,
 0x20,0x22,0x51,0x92,0x24,0x89,0x80,0x24,0x88,0x05,0x09,0x25,0x42,0x92,0x94,
 0x44,0x49,0x45,0xa1,0x94,0x14,0x02,0x24,0x51,0x09,0x0a,0x09,0x54,0x15,0x14,
 0x49,0x48,0x40,0xa2,0x14,0x49,0x49,0x10,0xd5,0x2b,0x55,0x90,0x24,0x20,0x45,
 0x51,0x03,0x11,0x09,0x42,0x08,0x14,0x92,0x10,0x84,0x24,0x82,0x84,0x04,0x44,
 0x01,0x80,0x48,0x15,0x49,0xa2,0x92,0x42,0x29,0xa1,0x8a,0x08,0x81,0x0a,0x09,
 0xa1,0x96,0x44,0x44,0x95,0x94,0x24,0x24,0x92,0x44,0x2a,0x08,0x52,0xa8,0xa4,
 0x94,0x24,0x49,0x22,0x29,0xaa,0xa8,0x04,0xa1,0x42,0x51,0x89,0x04,0x42,0x51,
 0xa2,0x42,0x12,0x42,0x24,0x05,0x12,0x69,0x49,0x12,0x25,0x25,0x54,0x87,0x22,
 0x25,0x49,0x95,0x2a,0xa5,0x91,0x0c,0x20,0x08,0x25,0x51,0x00,0x42,0x12,0x52,
 0x0c,0x12,0x92,0x30,0x49,0x52,0xa2,0x45,0x22,0x15,0x49,0x24,0x52,0x0a,0x10,
 0xa5,0x54,0x44,0xa4,0x04,0x41,0x28,0x29,0x10,0x42,0x92,0x42,0x49,0x28,0x91,
 0x22,0x89,0x22,0x12,0x21,0x81,0xa4,0x14,0x42,0x11,0x21,0xa9,0x14,0x24,0x0a,
 0x12,0x51,0x14,0x85,0x08,0x59,0x15,0x10,0x91,0x90,0x00,0x50,0xa5,0xaa,0x52,
 0x55,0xd3,0x49,0x9a,0x9a,0xaa,0xaa,0x54,0x55,0x05,0xaa,0x04,0x01,0x00,0x08,
 0x90,0x90,0x80,0xc8,0x28,0x81,0x00,0x22,0x80,0x00,0x40,0x95,0x94,0x48,0x92,
 0x12,0x89,0x40,0x8b,0x20,0x01,0x21,0x09,0xa9,0x28,0x12,0x80,0xa4,0x90,0x88,
 0x28,0x22,0x45,0x4a,0x48,0x42,0x94,0xa4,0x4a,0x44,0x12,0x89,0x54,0xa4,0x4a,
 0x0a,0x4a,0x89,0xa2,0xa4,0x08,0xa1,0x50,0x52,0xa2,0x2a,0x42,0x24,0x05,0x92,
 0x50,0xdf,0x76,0xdd,0xb6,0x6d,0x28,0xeb,0x76,0xb7,0x6d,0xdb,0xb6,0x21,0x05,
 0x10,0xa4,0x48,0x12,0x05,0x02,0x2a,0xa2,0xd0,0x24,0x24,0x40,0x12,0x92,0xb4,
 0x4a,0x42,0x92,0x24,0x44,0x12,0x15,0x24,0x4a,0x14,0x94,0x22,0x12,0x42,0x49,
 0x15,0x09,0x45,0x52,0x42,0x49,0x8a,0x90,0x12,0x29,0x51,0x12,0x94,0x02,0x49,
 0x22,0x81,0x0a,0x14,0x51,0x21,0x50,0x14,0x12,0x52,0x84,0x82,0x04,0xa9,0x0a,
 0x10,0x91,0x40,0x00,0x2d,0xa0,0x00,0x22,0x42,0x10,0x00,0x12,0x80,0x08,0x80,
 0x00,0x08,0x80,0x28,0x42,0x01,0x02,0x00,0xa0,0xa8,0x80,0x10,0x0b,0x00,0x02,
 0x49,0x01,0x40,0x40,0x95,0x28,0x55,0x90,0x92,0x4a,0xa1,0x12,0x21,0x84,0x42,
 0x90,0x84,0x14,0x92,0x40,0x54,0x12,0x21,0x29,0x24,0x21,0x25,0x89,0x48,0x8a,
 0x84,0x42,0x40,0x24,0x49,0x2a,0x51,0xa1,0x08,0x4a,0x05,0x89,0xa0,0x04,0x52,
 0x28,0xa9,0x50,0x29,0x0a,0x24,0x11,0x12,0x42,0x20,0x44,0x00,0x02,0x8a,0x22,
 0x80,0x04,0x50,0x12,0x92,0x20,0x0a,0x85,0x00,0x14,0xa8,0x84,0x04,0x01,0x12,
 0xa2,0x02,0x49,0x48,0x80,0xa4,0x04,0xd1,0x0a,0x45,0x88,0x4a,0x24,0x28,0x0a,
 0xa4,0x84,0x50,0x94,0x22,0x51,0x42,0x21,0x95,0xa2,0x48,0x94,0x44,0x49,0xaa,
 0x44,0x24,0x25,0x29,0xa9,0x94,0x08,0x91,0x24,0x51,0x8a,0x8a,0x62,0x94,0x24,
 0x24,0x05,0x90,0x88,0x42,0x04,0x25,0x15,0xa0,0x92,0x84,0x80,0x00,0x09,0x10,
 0x90,0x90,0x10,0x08,0x22,0x20,0x52,0x80,0x00,0x08,0x40,0x16,0x28,0x81,0x02,
 0x21,0xa0,0xaa,0x80,0x88,0x46,0x00,0x02,0x12,0xa9,0x46,0x44,0xa5,0x28,0x25,
 0x05,0x49,0x45,0xa1,0x12,0x20,0x0a,0x45,0x48,0x14,0x51,0x48,0x22,0x11,0x25,
 0x25,0x52,0x92,0x12,0x29,0x91,0x90,0x88,0x24,0x49,0x22,0x24,0x49,0x14,0x51,
 0x44,0x94,0x22,0x91,0x22,0x20,0x25,0x25,0x11,0x52,0xa9,0x2a,0x02,0x24,0x09,
 0x92,0x14,0x51,0x81,0x02,0x02,0x10,0x40,0x08,0x81,0x50,0x22,0x24,0x81,0x88,
 0x42,0x82,0x54,0x54,0x80,0xaa,0x04,0x4a,0x22,0x15,0x49,0x10,0x00,0x09,0x10,
 0xb0,0x16,0xa1,0x44,0x54,0x92,0x28,0x8a,0x24,0x95,0x50,0x2a,0x21,0xa1,0x84,
 0x22,0x44,0x4a,0x48,0x94,0x84,0x48,0x24,0x52,0x42,0x25,0x25,0x49,0x92,0x94,
 0x90,0x24,0xa1,0x8a,0x2a,0x11,0x49,0x6a,0x14,0x89,0x88,0x98,0xa4,0x64,0xa4,
 0x12,0x50,0xa9,0x24,0x49,0x49,0x12,0x2a,0xa4,0x2a,0x95,0x52,0x92,0x24,0x29,
 0x12,0x91,0x14,0x42,0x4a,0x10,0x02,0xa9,0x10,0x50,0x52,0x11,0x48,0x4a,0x92,
 0x92,0x65,0x24,0x89,0x42,0x45,0x14,0xa9,0xe2,0x2f,0x85,0x24,0x89,0x30,0x0a,
 0x4e,0x8a,0xf4,0xf5,0xd4,0xf3,0x93,0x92,0x27,0x5f,0x2f,0x5f,0x79,0x29,0x48,
 0xf1,0x97,0x54,0x22,0x48,0x13,0x7f,0x20,0x81,0xa4,0x90,0xc4,0x85,0x20,0xa2,
 0x5d,0x10,0xf2,0x52,0x15,0x0a,0x44,0x0a,0x00,0x81,0x10,0x80,0x00,0x02,0x10,
 0x00,0x00,0x00,0x20,0x00,0x2c,0x00,0x90,0x01,0x41,0xb4,0x16,0x40,0x2a,0x40,
 0x44,0x82,0x0a,0x00,0x00,0x10,0x81,0x20,0xa4,0x95,0xa2,0x84,0x3c,0x84,0x28,
 0x91,0x04,0xb1,0x50,0x0f,0x28,0x69,0x9c,0x19,0xe9,0x53,0x4a,0xd7,0xa9,0x99,
 0x99,0x34,0x92,0x12,0x1a,0x4a,0x22,0x95,0xa2,0xcb,0xa1,0x56,0x5a,0x82,0x4a,
 0xea,0x10,0x81,0xd4,0x9a,0xa2,0x68,0x54,0x2a,0x20,0x29,0x81,0x24,0x42,0x12,
 0x21,0x20,0x22,0x41,0x12,0x04,0x49,0xc4,0x92,0xd2,0x25,0x22,0x22,0x12,0x40,
 0x40,0x89,0x50,0x91,0x12,0x20,0x05,0x49,0x4a,0x04,0x26,0x08,0xa1,0x4a,0x10,
 0x52,0x9a,0x54,0x92,0x24,0xa2,0x10,0x25,0xa6,0x9a,0x64,0x9d,0x5b,0x13,0x88,
 0x04,0x87,0x9d,0xb9,0x31,0x71,0x49,0x44,0xb9,0x22,0x55,0x42,0x08,0x92,0x35,
 0x08,0x19,0x28,0x91,0x66,0x85,0x28,0x82,0x38,0x48,0x72,0x49,0x15,0x82,0xa8,
 0x2a,0x00,0x1d,0x90,0x04,0x25,0x02,0x0c,0x40,0x12,0x00,0x41,0x00,0x08,0x81,
 0xc0,0x08,0x80,0x02,0x19,0x20,0x2a,0x04,0x44,0x85,0x4c,0x00,0x02,0x01,0x81,
 0x42,0xa8,0x2a,0x45,0x89,0x5c,0x82,0x68,0x6b,0x0a,0x1d,0x92,0x77,0x4e,0x72,
 0xac,0xbd,0x79,0x25,0xa9,0xeb,0xda,0x9b,0x9f,0xd4,0x94,0x09,0x3a,0x6d,0xa4,
 0x2e,0xe1,0xc9,0xc3,0xa7,0xae,0xd7,0x2a,0x6b,0x53,0xd7,0xf6,0xda,0x9a,0x34,
 0x52,0x15,0x28,0x12,0x04,0x49,0x20,0x09,0x40,0x80,0x90,0x20,0x12,0x20,0x49,
 0x90,0x90,0xa2,0x04,0x90,0x82,0x24,0x28,0x80,0x08,0xc0,0x01,0x09,0x20,0x05,
 0x92,0x20,0x48,0x10,0x10,0xa2,0x45,0x92,0x24,0x8f,0xe8,0xe7,0xe7,0xf6,0x5b,
 0x7f,0x76,0x1e,0xe9,0xce,0xf3,0xfa,0x90,0x24,0xc3,0x9c,0x8f,0x27,0xf9,0xbb,
 0x53,0xf9,0x71,0xef,0x8f,0x8f,0x13,0x1f,0x76,0x9e,0x9d,0x9d,0xf7,0xce,0xcd,
 0xce,0xfc,0xbc,0xb3,0xa8,0x2a,0x82,0x48,0x09,0x00,0x00,0x48,0x12,0x04,0x02,
 0x22,0x40,0x02,0x00,0x41,0x47,0x00,0x80,0x44,0x08,0x00,0x81,0x24,0x42,0xb5,
 0x6f,0x02,0x8a,0x4a,0x00,0x84,0x00,0x4d,0x40,0xa0,0x16,0x49,0x52,0x5e,0x32,
 0x76,0x6e,0x76,0x9b,0x99,0x77,0x27,0x34,0xdc,0xf9,0xe4,0x25,0x89,0xeb,0x5d,
 0x57,0x4f,0x9a,0xb9,0x21,0xe4,0x75,0xe7,0xec,0xcc,0xa4,0x5e,0x73,0xed,0xcc,
 0x9b,0x73,0x66,0xce,0x64,0xcd,0xcc,0x39,0x52,0x12,0x20,0x92,0x84,0x24,0x09,
 0x89,0x00,0x21,0x4a,0x28,0x09,0x82,0x24,0x89,0x10,0x90,0x22,0x60,0x22,0x49,
 0x04,0x00,0x10,0x80,0x52,0x11,0x40,0x0a,0x48,0x22,0x48,0x22,0x4a,0xa4,0x4a,
 0x22,0x89,0x0e,0x79,0x6f,0xc6,0x66,0xba,0x3d,0x67,0x8e,0xb2,0xfa,0xcd,0xc3,
 0xfb,0xd7,0x93,0xcf,0xce,0x1e,0xb9,0x33,0x89,0xd2,0xb3,0x66,0x5d,0xdd,0x12,
 0xbd,0x77,0xce,0xde,0x5d,0x73,0xf7,0xd6,0xe4,0xdc,0xdd,0xb9,0x48,0x15,0x8a,
 0x48,0x12,0x80,0x20,0x08,0x44,0x88,0x00,0x20,0x20,0x08,0x00,0x40,0x00,0x00,
 0x00,0x89,0x08,0x00,0x90,0xa4,0x40,0x2a,0x05,0x04,0x95,0x22,0x01,0x01,0x01,
 0x41,0x00,0xa1,0x92,0x44,0x12,0x2f,0x1a,0xb7,0xe6,0xba,0x8c,0x8d,0x3b,0x53,
 0x38,0xe0,0xa4,0x89,0xf9,0x97,0x49,0x6f,0x6e,0x4e,0xce,0xb4,0x52,0x84,0x3b,
 0x6b,0xee,0xce,0x64,0xb8,0x3b,0x67,0xe6,0x9c,0xb1,0x3b,0xe7,0x6a,0xe6,0xce,
 0x1a,0x51,0x15,0x20,0x24,0x88,0x24,0x08,0x22,0x11,0x20,0x44,0x22,0x04,0x21,
 0x49,0x24,0x52,0x94,0x40,0x20,0x00,0x49,0x22,0x00,0x92,0x40,0x50,0x01,0x80,
 0x0a,0x48,0x48,0xa4,0x88,0x22,0xc8,0x26,0x11,0x49,0x8e,0x5a,0x77,0xd3,0x33,
 0x5d,0xa7,0x75,0x8b,0x7a,0x75,0x96,0xa5,0x02,0xc0,0x25,0xa7,0xec,0x1c,0xd9,
 0xf1,0x09,0x55,0xdb,0x73,0x66,0xee,0xc9,0xb2,0xb9,0xee,0xce,0xcd,0x39,0x73,
 0xcb,0xb3,0x6e,0xec,0x59,0xaa,0x2a,0x82,0x48,0x21,0x00,0x21,0x84,0x80,0x84,
 0x12,0x88,0x20,0x02,0x00,0x21,0x00,0x00,0x02,0x1a,0x29,0x00,0x02,0x89,0x00,
 0x12,0x05,0xa4,0xa4,0x22,0x01,0x02,0x80,0x82,0x48,0xa0,0x4a,0xa2,0x52,0x5d,
 0xb9,0xb1,0xc1,0xbd,0xae,0xc9,0x5b,0x27,0x1c,0x98,0xce,0xcd,0x94,0xea,0x91,
 0x69,0x6d,0xa6,0x6c,0x6a,0xa4,0x8c,0xbb,0x77,0xf7,0x66,0x62,0xb4,0x77,0x6b,
 0x77,0xde,0xba,0xb7,0xcf,0xf8,0xa6,0x76,0x5d,0x50,0x09,0x54,0xa4,0x0a,0x49,
 0x84,0x14,0x24,0x20,0x02,0x42,0x08,0x10,0x49,0x20,0x52,0x42,0x90,0x48,0x00,
 0x92,0x48,0x20,0x48,0x84,0x50,0x01,0x48,0x09,0x90,0x40,0x92,0x90,0x00,0x52,
 0x25,0x54,0x24,0xf8,0x75,0xb9,0xe5,0x58,0x9c,0xaf,0xb9,0x8b,0xfe,0x56,0xf4,
 0x7c,0x42,0xd2,0x6b,0xc5,0x8b,0x17,0x3c,0xb1,0x48,0xfe,0xb9,0xeb,0x49,0xe3,
 0xc8,0x9f,0x3b,0xef,0xce,0xdc,0x59,0xf7,0x56,0x64,0x5e,0xce,0x3a,0x92,0x2a,
 0x00,0x09,0x08,0x00,0x11,0x84,0x00,0x01,0xa2,0x48,0x42,0x42,0x00,0x25,0x00,
 0x08,0x01,0x0a,0x25,0x00,0x00,0x81,0x02,0x11,0x02,0x54,0x51,0x20,0x01,0x0a,
 0x80,0x80,0x24,0xa1,0x96,0x82,0x48,0x05,0x08,0x5a,0xc4,0x22,0xe1,0x9e,0x04,
 0x12,0x00,0x02,0x02,0x01,0x89,0x14,0x44,0x28,0x24,0x48,0x41,0x34,0x22,0x01,
 0x4a,0x32,0xa2,0x74,0x12,0xa0,0x48,0x50,0x11,0x82,0x82,0x48,0x42,0x29,0x21,
 0x55,0x80,0xa4,0x2a,0x52,0x52,0x85,0x24,0x41,0x84,0x44,0xa8,0x08,0x48,0x00,
 0x02,0x24,0x41,0x29,0x21,0x24,0x25,0x08,0x49,0x26,0x10,0x51,0x80,0x24,0x01,
 0xa4,0x09,0x48,0x42,0x12,0x49,0x40,0xa0,0x45,0x28,0x92,0x50,0x81,0x38,0x5a,
 0x48,0x55,0x38,0x51,0xa1,0x82,0xa8,0x50,0x54,0x52,0xa2,0x92,0x8a,0x92,0x22,
 0x15,0x97,0x94,0x54,0x21,0xb9,0x14,0xb5,0x44,0x12,0x12,0x05,0x44,0x51,0x10,
 0x22,0x21,0x02,0x88,0x00,0x25,0x52,0x15,0x08,0x28,0x29,0x00,0x04,0x11,0x10,
 0x02,0x02,0x41,0x14,0x88,0x00,0x80,0x00,0x84,0x80,0x0a,0x40,0x00,0x80,0x04,
 0x04,0x15,0x10,0x24,0x29,0x44,0x02,0x10,0x40,0x22,0x09,0xaa,0x2a,0x11,0x08,
 0x05,0x54,0x9e,0x1c,0x25,0xe2,0x0d,0x22,0x04,0x29,0x92,0x24,0x22,0x21,0x09,
 0x09,0x51,0x48,0x94,0xa0,0x26,0x21,0x21,0x4a,0x3a,0x51,0x3c,0x91,0x48,0x48,
 0xaa,0x10,0x8a,0x4a,0x95,0x4a,0x49,0x25,0xaa,0x88,0xa8,0x14,0x42,0x45,0x02,
 0x92,0x20,0x04,0x02,0x00,0x42,0x00,0x41,0x21,0x20,0x12,0x56,0x01,0x50,0x85,
 0x12,0x24,0x11,0x40,0x4a,0x40,0x05,0x41,0x94,0x10,0x90,0x04,0x12,0x1c,0x80,
 0x40,0x85,0x8a,0xa2,0x28,0x09,0x55,0x22,0x49,0x89,0x86,0x14,0xa9,0x84,0x24,
 0x01,0x49,0x90,0x54,0x52,0x0a,0xa2,0x02,0x15,0x91,0x94,0x94,0x92,0xda,0x24,
 0x95,0x44,0x12,0x20,0x01,0x48,0x49,0x12,0x20,0x41,0x12,0x11,0x01,0x42,0x52,
 0x25,0x08,0x28,0x29,0x49,0x49,0xd2,0x98,0xb6,0x2d,0x4d,0x12,0x92,0x46,0x49,
 0x12,0x28,0x45,0x15,0x49,0x12,0x92,0x26,0x25,0x09,0x50,0x84,0x4a,0x49,0x92,
 0xd2,0x24,0xa1,0x29,0x62,0x15,0x20,0x08,0xa2,0xa4,0x48,0x15,0x12,0x22,0x51,
 0xa0,0x04,0x51,0x92,0x14,0x92,0x4a,0xa2,0x84,0x50,0x09,0x54,0x44,0x44,0x42,
 0x22,0x24,0x09,0x92,0x50,0x12,0x41,0x09,0xaa,0x92,0x24,0x45,0x95,0x94,0x48,
 0xa4,0x54,0x29,0x49,0x15,0xa2,0x8a,0x44,0x00,0x00,0x02,0x20,0x00,0x02,0x80,
 0x40,0x00,0x00,0x00,0x80,0x42,0x32,0x44,0x00,0x80,0x00,0x00,0x80,0x44,0x05,
 0x69,0x01,0x01,0x01,0x00,0x00,0x04,0x80,0xa4,0x4a,0x08,0xa1,0x14,0x09,0x25,
 0xa2,0x48,0x91,0x08,0x15,0x51,0x24,0x21,0x82,0x48,0x22,0x11,0x29,0x25,0x52,
 0x11,0x29,0xa9,0x94,0x54,0x49,0x52,0x49,0x8a,0x08,0x28,0x50,0x91,0x24,0x49,
 0x51,0x48,0x42,0x12,0x09,0x22,0x84,0xa4,0x2a,0x08,0x20,0x09,0x49,0x25,0x92,
 0x82,0x20,0x25,0x8a,0x04,0x13,0x14,0x49,0x88,0x14,0x4d,0x02,0x94,0x04,0x4a,
 0x48,0x09,0x29,0xa8,0x2a,0x24,0x49,0x24,0x12,0x49,0x21,0x4a,0xa0,0x25,0x52,
 0x14,0x49,0x52,0x50,0x49,0x92,0x48,0x02,0x48,0x04,0x89,0x44,0x54,0x25,0x89,
 0x24,0x24,0x4a,0x09,0xa2,0x44,0x02,0x22,0x81,0x22,0x21,0x25,0x11,0x51,0x84,
 0x84,0x4a,0x02,0x12,0x45,0x92,0x28,0x09,0x50,0x89,0x28,0x52,0x0a,0x42,0xaa,
 0x24,0x00,0x00,0x01,0x00,0x08,0x85,0x90,0x20,0x00,0x41,0x00,0x22,0xa4,0x02,
 0x2c,0x01,0x40,0x00,0x02,0x40,0x54,0xab,0x0a,0x01,0x01,0x80,0x04,0x00,0x08,
 0x00,0xa4,0x8a,0x00,0x44,0x25,0x09,0x8a,0x94,0x20,0x20,0xa9,0x02,0x52,0x52,
 0x28,0x20,0x90,0x50,0x4a,0x49,0x11,0xa2,0x14,0x91,0x54,0x91,0x54,0x94,0x94,
 0x48,0x4a,0x0a,0x21,0x52,0x90,0xb4,0xa4,0x94,0x20,0x40,0x02,0x05,0x20,0x92,
 0xa0,0x2a,0x08,0x11,0x81,0x24,0x49,0x49,0x4a,0x22,0x13,0x80,0x08,0x24,0x00,
 0x25,0x80,0x28,0x48,0x03,0x24,0x09,0x49,0x48,0x12,0x21,0x15,0x25,0x24,0x95,
 0x04,0xa0,0x24,0x42,0x91,0x60,0x15,0x4a,0x29,0x94,0xa4,0x54,0x22,0x88,0x4a,
 0x04,0xa8,0x04,0x88,0x02,0x05,0x4d,0x42,0x90,0x92,0x44,0x88,0x40,0x22,0x89,
 0x24,0x91,0x42,0x62,0x22,0x28,0x29,0x84,0x24,0x25,0x41,0x12,0x29,0x88,0x2a,
 0x54,0xa8,0x4a,0x25,0x59,0x15,0x44,0xa4,0x2a,0x08,0x01,0x81,0x10,0x20,0x07,
 0x99,0x82,0x02,0x29,0x81,0x92,0x82,0x22,0x26,0x09,0x42,0x02,0x02,0x01,0x50,
 0x40,0x24,0x01,0x09,0xa0,0x0a,0x00,0x11,0x44,0xa4,0xa6,0x00,0x92,0xf2,0x27,
 0x09,0x49,0x81,0xd0,0x3b,0x05,0x51,0x45,0x68,0x52,0x3c,0x95,0xe6,0xe5,0xe9,
 0xd3,0x2b,0x49,0x57,0x5e,0x5e,0xbc,0xf4,0x14,0x85,0xfe,0x41,0x98,0x92,0x14,
 0xf1,0x75,0x01,0xf6,0x02,0x85,0x22,0x4f,0xa2,0x24,0x12,0x11,0x80,0x20,0x4a,
 0x15,0x42,0x09,0x12,0x04,0x11,0x94,0x80,0x08,0x00,0x08,0x08,0x06,0x90,0x08,
 0x94,0x28,0xaa,0x84,0x08,0x04,0x14,0xa2,0x12,0x20,0x95,0x80,0x10,0xa1,0x0a,
 0x52,0x24,0x74,0x8e,0xa4,0x34,0x28,0x72,0x8c,0x28,0x84,0x28,0xe1,0x48,0x8d,
 0x50,0xc8,0x39,0x33,0x66,0x46,0x92,0x1f,0x93,0x9c,0x36,0x61,0xa1,0x54,0x8c,
 0x13,0x5d,0x24,0x49,0xf4,0x30,0xa8,0x23,0x14,0xd2,0xa9,0x23,0x49,0x15,0x40,
 0xa8,0x2a,0x84,0x00,0x81,0x00,0x80,0x42,0x41,0x45,0x01,0x12,0x22,0x49,0x21,
 0x41,0x96,0x04,0x20,0x01,0x00,0x01,0x20,0x02,0x55,0x81,0x0a,0x00,0x09,0x00,
 0x24,0x42,0x48,0xa5,0x04,0x49,0xb5,0x2e,0x51,0x64,0x21,0x78,0x29,0x12,0x21,
 0x45,0x4a,0x24,0x5c,0x9a,0xd2,0x59,0x77,0xf7,0x96,0x54,0xb8,0x3b,0x3d,0xab,
 0xec,0x48,0x92,0xde,0x85,0x12,0x49,0x22,0xc5,0x55,0x11,0xd3,0x42,0x81,0x14,
 0x4b,0xa4,0x2a,0x0a,0x45,0x81,0x10,0xa5,0xa4,0x94,0x34,0x04,0x08,0x01,0x12,
 0x40,0x01,0xa0,0x04,0x24,0x06,0x2a,0x09,0x4a,0x49,0x89,0x42,0x28,0x24,0x24,
 0x4a,0x12,0x22,0x51,0x01,0x48,0x62,0x15,0x51,0x22,0x78,0xa7,0x46,0x39,0x84,
 0x98,0x48,0xe1,0xee,0x8c,0xb8,0x88,0xac,0x1c,0xea,0x3c,0x77,0x3b,0x27,0xa1,
 0x9e,0xb9,0x4c,0x77,0xb1,0x3b,0x4b,0xce,0x29,0x2d,0x5b,0x9d,0xe8,0x14,0x04,
 0x27,0x77,0x6e,0xdd,0x3b,0x51,0x15,0x40,0x10,0x04,0x00,0xe0,0x00,0x00,0x80,
 0x17,0x10,0x17,0x80,0x08,0x40,0x04,0x40,0x00,0x46,0x00,0x00,0x00,0x00,0x01,
 0x10,0x00,0x1e,0x00,0x02,0x40,0x00,0x00,0x88,0x00,0x40,0x4b,0x48,0x91,0x3a,
 0x6b,0xf7,0xfb,0x2f,0x5d,0x82,0xcf,0x9f,0xed,0x67,0xfe,0xee,0xbd,0x60,0x99,
 0xe3,0x71,0x8e,0x14,0xd9,0x35,0x9e,0x73,0x74,0x63,0x23,0xee,0xfa,0xce,0x9d,
 0x3b,0xc2,0x49,0x49,0x9f,0xee,0xd7,0x3d,0x77,0xaa,0x12,0x2a,0x85,0x02,0x00,
 0xe0,0x03,0x00,0x40,0x08,0x80,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,
 0x00,0x00,0x00,0x01,0x00,0x00,0x21,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0xa0,
 0x0a,0x25,0x4a,0xfa,0xb2,0x63,0x9f,0x09,0x9e,0x74,0xec,0xcc,0xea,0x3e,0x63,
 0xcf,0x0c,0xea,0x5c,0xd7,0x35,0x27,0x49,0xce,0xb9,0xa6,0xbb,0xb2,0x73,0x4b,
 0x7f,0xd9,0xad,0xee,0x9d,0xd4,0x96,0x24,0x5e,0x66,0xe6,0xac,0x35,0x51,0x2a,
 0x00,0x40,0x04,0x00,0xe1,0x83,0x00,0x20,0x00,0x88,0x07,0x02,0x00,0x01,0x80,
 0x00,0x20,0x06,0x08,0x00,0xfe,0x07,0x01,0x40,0x80,0x60,0x00,0xca,0x0f,0x02,
 0x00,0x01,0x40,0x60,0x45,0x42,0x91,0x38,0x39,0xeb,0x58,0xab,0x3c,0xe1,0xde,
 0xae,0xdd,0x32,0x77,0x6e,0xad,0x60,0xf0,0xb3,0xe3,0xf3,0x9f,0xc6,0x5d,0xce,
 0xb1,0x30,0xeb,0x52,0xc6,0xba,0xee,0x8c,0x59,0xd2,0x4b,0x88,0x3c,0x77,0xef,
 0x9c,0xbb,0x54,0x15,0xaa,0x2a,0x09,0x00,0xe0,0x01,0x00,0x10,0x10,0x00,0x07,
 0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x38,0x82,0x00,0x00,0x40,0x80,
 0x00,0x44,0x0b,0x00,0x00,0x00,0x00,0x40,0x2b,0x89,0x24,0x1d,0xbc,0x73,0x1a,
 0x07,0x4d,0x3a,0x6e,0x8e,0x65,0x3c,0xbb,0xe6,0x2e,0x7a,0xc5,0x9d,0x8b,0xeb,
 0x2d,0xe9,0x9c,0xd6,0x3d,0xba,0x63,0x85,0xd7,0x1d,0xe6,0xee,0x1d,0xc9,0x25,
 0x25,0xba,0x77,0x63,0xcd,0x19,0xa2,0x2a,0x00,0x40,0x02,0x00,0xe0,0x01,0x00,
 0x10,0x10,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0xe8,0x87,
 0x00,0x00,0x40,0x80,0x00,0xc4,0x0d,0x00,0x00,0x00,0x00,0x40,0x95,0x54,0x92,
 0xbc,0x9a,0x3b,0xbc,0x5e,0x9c,0xb4,0xe6,0xa6,0x67,0x59,0x2a,0x77,0x8e,0xb2,
 0xe8,0x29,0xe7,0x05,0x82,0xd5,0x2d,0x97,0xb9,0xb8,0xe9,0x29,0xe7,0x59,0x77,
 0xce,0xac,0xd2,0xa1,0xd0,0x30,0x33,0x77,0xd6,0x5d,0x51,0x15,0x52,0x95,0x24,
 0x49,0xc9,0x92,0x92,0x34,0x39,0x49,0x57,0x92,0x44,0x49,0x92,0x90,0x24,0x2f,
 0x49,0x12,0x9a,0xa4,0x25,0x49,0xd2,0xa4,0x09,0x4d,0x92,0x92,0x24,0x25,0x49,
 0x62,0x25,0x21,0x49,0x8d,0xb8,0x75,0xad,0x24,0x39,0x73,0x77,0x8b,0x73,0x5a,
 0x47,0xeb,0x56,0x78,0x72,0x9a,0xe9,0xa8,0xe8,0xcf,0xac,0xa7,0x0d,0x9d,0xd2,
 0x04,0xeb,0x0c,0xef,0xd7,0x2e,0xa4,0xc5,0xc5,0xba,0xbb,0xeb,0xce,0x2c,0x2a,
 0x29,0x04,0x24,0x09,0x00,0xc0,0x00,0x00,0x10,0x10,0x00,0x06,0x00,0x00,0x00,
 0x00,0x00,0x00,0x04,0x00,0x00,0x04,0x80,0x00,0x00,0x40,0x80,0x00,0x04,0x00,
 0x00,0x00,0x00,0x00,0x40,0x95,0x94,0x24,0x7e,0xfa,0x3b,0xdc,0x4f,0xf4,0xea,
 0xe2,0x45,0xb3,0x38,0x3f,0x73,0x1e,0x7d,0x99,0xf0,0x35,0x12,0xe5,0x17,0x97,
 0x1f,0x97,0x70,0x69,0xc1,0x7f,0xae,0xe6,0xed,0x1c,0xc9,0xe8,0xa8,0x9d,0x5b,
 0xf7,0xee,0x5d,0x51,0x15,0x90,0x48,0x02,0x00,0xc0,0x00,0x00,0x20,0x00,0x00,
 0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
 0x40,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0xa0,0x4a,0x4a,0x52,0x80,0x24,0x82,
 0x00,0x90,0x50,0x11,0x39,0x88,0x20,0x51,0xbd,0x84,0x20,0x80,0x24,0x0a,0x88,
 0x44,0x08,0xa0,0x20,0xa0,0x20,0x45,0x52,0x10,0x81,0x14,0x09,0x24,0x55,0x12,
 0x41,0x45,0x20,0x10,0x01,0x02,0x00,0x52,0x15,0x25,0x22,0x05,0x00,0x41,0x80,
 0x00,0x60,0x08,0x08,0x04,0x02,0x00,0x01,0x80,0x00,0x20,0x06,0x08,0x00,0x02,
 0x80,0x01,0x40,0x00,0x21,0x00,0x0c,0x00,0x02,0x00,0x01,0x40,0x40,0x2b,0x11,
 0x09,0x55,0x92,0x54,0xaa,0x24,0x09,0x4a,0x32,0xb5,0x49,0x8a,0x31,0x22,0x94,
 0x52,0x8a,0x22,0x25,0x11,0xa5,0x2a,0x95,0x2a,0x90,0x28,0x2d,0xa5,0x54,0x42,
 0x54,0x49,0x42,0x49,0x2a,0x28,0x49,0xa5,0x54,0xa8,0x52,0xa9,0x2a,0x80,0x48,
 0x08,0x00,0x40,0x00,0x00,0x80,0x07,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,
 0x06,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x1e,0x00,0x08,0x00,0x00,0x00,0x00,
 0x00,0x60,0x25,0x24,0x52,0x88,0x04,0x81,0x44,0x92,0x50,0x90,0x38,0x32,0x04,
 0xd1,0xb5,0x88,0x10,0x0a,0x51,0x88,0x48,0x4a,0x48,0x44,0x52,0x42,0x25,0xa5,
 0x5e,0x08,0x89,0x98,0x22,0x90,0x14,0x22,0x41,0x41,0x10,0x12,0x01,0x05,0x04,
 0x24,0x09,0x29,0x28,0x05,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,
 0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0xf8,
 0x00,0x00,0x00,0x00,0x00,0x40,0x95,0x92,0x94,0x52,0x52,0x2a,0x22,0x21,0x88,
 0x4a,0x6a,0xa9,0x22,0x24,0x0a,0x24,0x45,0xa1,0x08,0x25,0x25,0x21,0x25,0x92,
 0x08,0x29,0x12,0x11,0x00,0xaa,0x52,0x44,0x94,0x4a,0x42,0x49,0x28,0x2a,0xa4,
 0xa4,0x54,0x52,0x29,0xa9,0x2a,0x84,0x92,0x08,0x00,0x81,0x00,0x00,0x00,0x00,
 0x00,0x82,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x02,0x01,0x00,
 0x00,0x00,0x00,0x04,0x02,0x00,0x00,0x00,0x00,0xa0,0x2a,0xa9,0x02,0x44,0x89,
 0x44,0x49,0x94,0x20,0x01,0x09,0x20,0x88,0x90,0x52,0x11,0x28,0x4a,0xaa,0x00,
 0x90,0x94,0x48,0x49,0x52,0x92,0xa4,0xa4,0xaa,0x12,0xa4,0x92,0x02,0x91,0x28,
 0x05,0xa5,0x90,0x40,0x02,0x02,0x89,0x40,0x50,0x15,0x41,0x48,0x02,0x80,0x00,
 0x01,0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,
 0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x02,0x04,0x00,0x00,0x00,0x00,0xc0,0x86,
 0x24,0x54,0x29,0x22,0x11,0x22,0x09,0x4a,0x2a,0x92,0x8a,0x52,0x04,0x09,0xa4,
 0x0a,0x21,0x12,0x5a,0x45,0x42,0x12,0x22,0x89,0x20,0x49,0x4a,0x02,0xa8,0x12,
 0xa9,0xa8,0x24,0x85,0xa0,0x08,0x4a,0x14,0x49,0x54,0x51,0x14,0xa5,0x2a,0x14,
 0x25,0x01,0x80,0x01,0x81,0x00,0x20,0x00,0x08,0x01,0x03,0x00,0x01,0x80,0x00,
 0x20,0x06,0x08,0x00,0x02,0x01,0x01,0x40,0x00,0x20,0x00,0x0a,0x04,0x02,0x00,
 0x01,0x40,0xa0,0x2a,0x49,0xa1,0x44,0x48,0xa2,0x94,0xa4,0x10,0x81,0x08,0x25,
 0x84,0x52,0xa4,0x02,0xa4,0x94,0xa4,0x20,0x88,0x94,0x24,0x94,0x24,0x4a,0x12,
 0x11,0x41,0x45,0x4a,0x12,0x45,0x92,0x28,0x95,0x52,0x20,0x91,0x24,0x08,0x82,
 0x22,0x28,0x25,0x41,0x90,0x08,0x80,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x01,
 0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
 0x02,0x04,0x00,0x00,0x00,0x00,0x40,0x95,0x24,0x14,0x92,0x12,0x15,0x21,0x00,
 0x41,0x54,0x42,0x48,0x51,0x24,0x20,0xa8,0x42,0x20,0x21,0x4a,0x25,0x42,0x92,
 0x22,0x89,0x90,0xa4,0xa4,0x10,0x28,0x91,0xa4,0x90,0x44,0x44,0x22,0x84,0x8a,
 0x00,0x02,0x45,0x54,0x90,0x52,0x15,0x04,0x45,0x02,0x80,0x00,0x01,0x00,0x00,
 0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x01,0x00,
 0x00,0x00,0x00,0x00,0x02,0x04,0x00,0x00,0x00,0x00,0x60,0x25,0x95,0xa2,0x44,
 0xa4,0xa8,0x84,0x2a,0x88,0x08,0x09,0x22,0x05,0x88,0x02,0x22,0x29,0x05,0x8a,
 0x04,0x48,0x29,0x49,0xa4,0x22,0x25,0x12,0x05,0x45,0xa5,0xa4,0x0a,0x25,0x89,
 0x12,0x95,0x68,0x22,0x54,0x54,0x12,0x22,0x45,0xa4,0x2a,0x50,0x28,0x09,0x00,
 0x81,0x80,0x00,0x20,0x00,0x08,0x82,0x02,0x00,0x01,0x80,0x00,0x20,0x06,0x08,
 0x00,0x02,0x02,0x01,0x40,0x00,0x20,0x00,0x0c,0x02,0x02,0x00,0x01,0x40,0xa0,
 0x95,0x42,0x49,0x22,0x09,0x05,0x50,0x40,0x21,0x52,0x12,0x91,0x7f,0x52,0x90,
 0x90,0x08,0xfc,0x21,0x51,0x25,0x12,0x26,0xc9,0x49,0x88,0xae,0x5e,0x3e,0x3c,
 0xea,0x51,0x49,0xfe,0x89,0x40,0xe2,0xc0,0xf3,0x96,0x84,0x10,0x12,0xa9,0x14,
 0x82,0x84,0x04,0x00,0x42,0x00,0x00,0x00,0x00,0x00,0x44,0x00,0x00,0x00,0x00,
 0x00,0x00,0x06,0x00,0x00,0x00,0x84,0x00,0x00,0x00,0x00,0x00,0x08,0x01,0x00,
 0x00,0x00,0x00,0x40,0x25,0x14,0x12,0x49,0x22,0xb2,0x8a,0x02,0x80,0x24,0x49,
 0x44,0x73,0x22,0x41,0x46,0x52,0xc7,0x44,0x04,0x92,0xa4,0x46,0xd0,0x92,0x25,
 0x9d,0xb3,0xb3,0x5a,0xd1,0x84,0x84,0x9c,0x23,0x95,0x74,0xc5,0x23,0x4e,0x12,
 0x4a,0x24,0x50,0x25,0x28,0x21,0x01,0x00,0x3c,0x00,0x00,0x00,0x00,0x00,0x38,
 0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x00,
 0x00,0xf0,0x00,0x00,0x00,0x00,0x00,0x60,0x95,0x22,0x49,0x24,0x49,0x09,0x52,
 0x54,0x25,0x09,0x02,0x92,0x73,0x08,0x14,0x2b,0x89,0x83,0x10,0xa9,0x40,0x08,
 0x95,0xca,0x25,0x49,0x4e,0x73,0xb3,0x3c,0x6a,0x29,0x51,0xac,0x4b,0x49,0x62,
 0x90,0x99,0x04,0x41,0x21,0x89,0x54,0x15,0x02,0x54,0x2a,0x49,0x49,0x92,0x92,
 0x24,0x29,0x49,0x52,0x92,0x44,0x49,0x92,0x90,0x24,0x2b,0x49,0x12,0x92,0x24,
 0x25,0x49,0x92,0x24,0x09,0x49,0x92,0x92,0x24,0x25,0x49,0x42,0xab,0x14,0x24,
 0x89,0x92,0xa4,0x84,0x00,0x00,0x84,0x54,0xc9,0x73,0x6d,0xa0,0x91,0xe4,0x91,
 0x44,0x66,0xce,0xd2,0x4a,0xe4,0xce,0x25,0x9d,0xb5,0x75,0x9a,0xe4,0x33,0x0b,
 0xdd,0xb1,0x3a,0x79,0xe5,0x85,0x6b,0x17,0x4a,0x22,0xa2,0x2a,0xa0,0x22,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0xa0,0x4a,0x4a,0x09,0xa2,0x08,0x12,0x29,0x55,0x89,0x22,0x22,0x90,0x75,0x36,
 0xff,0xef,0xc2,0x05,0xb9,0xfc,0xdd,0x6e,0xe7,0xef,0xed,0x8b,0xce,0xb9,0x73,
 0x9d,0xf2,0x6e,0x43,0xce,0xdd,0x39,0xa7,0xc8,0x07,0xe6,0xce,0x3f,0x80,0x90,
 0x14,0x0a,0x44,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0xa0,0x92,0x90,0xa4,0x48,0xa2,0x28,0xa2,0x24,0x20,0x84,
 0x48,0xc2,0x0b,0x73,0xb3,0x91,0xe8,0x20,0xc6,0xce,0xcc,0x6e,0x33,0x73,0xcd,
 0x20,0xa7,0xbb,0x3d,0x2e,0x79,0x76,0x2b,0x3f,0xce,0xda,0x79,0xd2,0x53,0x6b,
 0x66,0x0c,0x55,0x54,0x15,0x20,0x29,0xaa,0x7e,0x55,0xd5,0x76,0xb7,0x6a,0x5b,
 0x55,0xed,0xff,0xfe,0xff,0xff,0x5f,0x55,0xdb,0xff,0xad,0xaa,0xea,0xbe,0xdf,
 0xaa,0xb6,0x4a,0xb5,0xfd,0xff,0xfb,0xff,0xae,0xa6,0x4a,0x52,0x12,0x29,0x85,
 0x14,0x49,0x85,0x52,0x92,0x94,0xa9,0x3b,0x8f,0x39,0xc2,0x88,0xe6,0xce,0x9a,
 0x96,0xb7,0xe7,0xee,0x55,0x0e,0x7f,0x7f,0x4d,0x72,0xe7,0x92,0x8e,0xec,0x9c,
 0x35,0xe5,0x8e,0x73,0xef,0x0e,0x08,0xa1,0x2a,0x82,0xa0,0x08,0xa1,0xaa,0x5a,
 0x55,0x55,0xab,0xaa,0xaa,0x2a,0x48,0x21,0x02,0x04,0xa8,0x6a,0x35,0x44,0x55,
 0x55,0xad,0x52,0x54,0xdb,0xaa,0xaa,0xaa,0x22,0x11,0x45,0x48,0xa9,0x4a,0x12,
 0x89,0x24,0x92,0x28,0x49,0x92,0x50,0x08,0x09,0xc2,0x85,0x39,0xe3,0x70,0xe9,
 0x20,0xe7,0xe6,0x58,0xa6,0xb9,0x79,0x66,0x88,0xa7,0x1c,0x99,0xae,0x98,0xd6,
 0x24,0x27,0xd7,0xda,0xb9,0xe8,0x4e,0x6b,0x63,0x56,0x25,0x54,0x09,0x28,0x14,
 0x52,0x5e,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xab,0xab,0xde,0xfa,0xf5,0x6b,
 0xad,0xaa,0x5b,0xd5,0xaa,0x55,0xad,0x55,0x55,0x55,0x6b,0x55,0xad,0xd6,0x5a,
 0xab,0xd6,0x2a,0xa9,0x24,0x49,0x09,0x45,0x22,0x49,0x04,0xa5,0x90,0xe8,0xa1,
 0x9b,0xc3,0x6a,0xd0,0x05,0x63,0x6e,0x7a,0x8f,0xe3,0x64,0x6f,0x25,0x0b,0x4c,
 0x2e,0x2e,0x3a,0xe7,0x4b,0x4f,0xe6,0xcc,0x3b,0x65,0x9d,0x35,0xd7,0x0b,0x20,
 0xa9,0x2a,0x82,0x48,0x49,0xd2,0xb6,0xd5,0xaa,0x6a,0xad,0xda,0xaa,0x5a,0xb5,
 0x52,0x95,0x2a,0x55,0xab,0x55,0x55,0xab,0x56,0x55,0x55,0xab,0xaa,0x5a,0x55,
 0x6b,0x5b,0xad,0xb6,0x56,0xb5,0x0a,0x42,0x52,0x92,0x50,0x88,0x94,0x24,0x51,
 0x11,0x49,0xe2,0x94,0xfd,0xd5,0x64,0xc5,0x71,0xbb,0xb2,0x38,0xd3,0x35,0x39,
 0xeb,0x92,0xa3,0x87,0x96,0x47,0xd9,0xc9,0x10,0x93,0x6e,0xff,0x5a,0xf8,0x9c,
 0x37,0x6b,0xa0,0x8a,0x24,0x15,0x28,0x42,0x12,0xad,0xaa,0x5a,0x6d,0x5b,0xd5,
 0x56,0xdb,0xaa,0x56,0xad,0xd6,0xd6,0x5a,0x55,0xad,0x6a,0xb5,0xaa,0xda,0x6a,
 0xb5,0x55,0xab,0x5a,0xad,0xaa,0x55,0x55,0xb5,0x55,0xa5,0x2a,0x89,0x44,0x0a,
 0x25,0x21,0x91,0x0a,0x4a,0x92,0xf0,0x89,0xbb,0xe3,0x7d,0x50,0x1f,0x2e,0x5f,
 0x1a,0x87,0xf3,0x75,0xe7,0xc4,0xaf,0xa9,0x4b,0xaf,0xb8,0x64,0xca,0x4f,0xfe,
 0x9c,0x79,0xf5,0xbe,0x7b,0xe7,0x17,0x11,0xa9,0x2a,0x82,0x94,0x48,0x22,0x09,
 0x21,0x11,0x44,0x22,0x88,0x20,0x52,0x88,0x90,0x10,0x10,0x41,0x24,0x40,0x80,
 0x88,0x40,0x00,0x02,0x44,0x88,0x24,0x21,0x00,0x20,0x20,0xa1,0x40,0x92,0x14,
 0x94,0x54,0x92,0x50,0x54,0x14,0x4a,0x50,0x91,0x48,0x0a,0x22,0x05,0x08,0x80,
 0x82,0x44,0x81,0x03,0x59,0x28,0xdc,0x03,0x14,0x51,0x40,0x52,0x20,0x11,0x45,
 0x4a,0x29,0x24,0x41,0xa2,0x04,0x02,0x41,0x80,0xa8,0xa7,0x44,0x52,0x25,0x20,
 0x48,0x22,0x49,0x42,0x4c,0x4a,0x91,0x94,0x42,0x8a,0x88,0x22,0x4a,0xa2,0x4a,
 0x0a,0x49,0x15,0x2a,0x22,0x95,0xaa,0xa8,0x12,0x22,0x42,0x12,0xa5,0x4a,0x9a,
 0x14,0x95,0x48,0x82,0x42,0x82,0x24,0x25,0x82,0x42,0x25,0x05,0x4a,0x90,0xa0,
 0x84,0xa8,0x42,0x25,0x29,0x09,0x28,0xab,0x8d,0x82,0x2a,0x53,0x42,0x14,0x95,
 0x84,0x94,0xa4,0x00,0x6d,0x84,0x92,0x94,0x28,0x42,0x69,0x92,0x2a,0x71,0x16,
 0x20,0xa4,0x14,0x8a,0x92,0x94,0x24,0x89,0x92,0x28,0x25,0x41,0x14,0x21,0x25,
 0x44,0x11,0x41,0x20,0x90,0x24,0x20,0x91,0x84,0x00,0x00,0x01,0xa1,0x94,0x94,
 0x20,0x94,0x92,0x44,0x52,0x24,0xa5,0x24,0x15,0x55,0x52,0x92,0x14,0x88,0x48,
 0xa8,0x10,0x21,0x14,0x12,0x42,0x14,0x88,0x44,0xa0,0xc2,0x83,0x23,0x54,0x9c,
 0x89,0x28,0x21,0x14,0x29,0x22,0x4a,0xaa,0x9c,0x52,0x24,0x21,0x42,0x88,0x84,
 0x48,0x12,0x18,0x4b,0x85,0xa8,0x2a,0x20,0x24,0x45,0x92,0x14,0x21,0x85,0x48,
 0x2a,0x42,0x14,0x51,0x29,0x4a,0x20,0x12,0x25,0x48,0x95,0x24,0x29,0x55,0x55,
 0x54,0x4a,0x22,0x49,0x8a,0x42,0x24,0x12,0x09,0x92,0x10,0x82,0x48,0x91,0x88,
 0x08,0x42,0x25,0x12,0x25,0x4a,0x10,0x81,0x40,0x29,0x81,0x22,0x29,0x15,0x28,
 0x55,0x54,0x85,0xe2,0x22,0x44,0x95,0xa2,0x44,0x49,0x21,0x05,0x21,0xa9,0x92,
 0x94,0x14,0x25,0x52,0x12,0x44,0xe1,0x21,0x50,0x52,0x15,0x92,0x90,0x28,0x29,
 0x41,0x04,0x54,0x25,0x91,0x94,0x40,0x84,0x82,0x10,0x41,0x48,0x88,0x22,0x20,
 0x41,0x24,0x82,0x20,0x11,0x11,0x89,0x24,0x29,0x24,0x49,0x49,0x52,0x49,0xaa,
 0x14,0x20,0x4a,0x52,0x52,0x29,0x88,0x48,0x81,0x10,0x21,0x54,0x0a,0x90,0x54,
 0x45,0x80,0x44,0x41,0x04,0x01,0x29,0x14,0x44,0x11,0x22,0x09,0x29,0x2a,0x4a,
 0x22,0x80,0x44,0x24,0x49,0xa2,0x88,0x88,0x44,0x09,0x00,0x44,0x05,0x49,0x29,
 0x04,0x24,0x92,0x88,0x2a,0xa0,0x22,0x92,0x48,0x22,0x2a,0x51,0x28,0x8a,0x14,
 0x91,0x22,0x00,0x95,0x94,0x02,0x29,0x4a,0x44,0xa4,0x54,0x88,0x44,0x11,0x42,
 0xa4,0x84,0x24,0x49,0x89,0x02,0x21,0x89,0x24,0x02,0x25,0x92,0x28,0x85,0x88,
 0x88,0x24,0x09,0x21,0x10,0x55,0x92,0x94,0xa2,0xa8,0x44,0x89,0x2a,0x08,0x91,
 0xa4,0x84,0x44,0x29,0x11,0x29,0x29,0x49,0x92,0x08,0x52,0x24,0x11,0xa2,0x52,
 0x28,0x50,0x50,0x15,0x50,0x49,0x49,0x25,0x92,0x02,0x94,0x24,0x25,0x41,0x91,
 0x84,0x42,0x22,0x42,0x40,0x44,0xa8,0x20,0x49,0x54,0xa4,0x24,0x89,0x00,0x81,
 0x22,0x11,0xa2,0x94,0x08,0x29,0x52,0x12,0x25,0xa8,0x94,0x52,0x90,0xa8,0x48,
 0x49,0x42,0x28,0x21,0x22,0x92,0xa0,0x94,0xaa,0x08,0x49,0x12,0x14,0x02,0x11,
 0x22,0x50,0xa5,0x24,0x12,0x29,0x29,0x52,0x4a,0x00,0x42,0x92,0x20,0x50,0x81,
 0x92,0xa4,0x08,0x01,0x41,0x05,0xa8,0x2a,0x05,0x24,0x50,0x90,0x24,0x88,0x22,
 0x89,0x40,0x28,0x04,0x52,0x14,0x11,0x81,0x14,0x91,0x02,0x4a,0x12,0x89,0x12,
 0x49,0x52,0xaa,0x54,0x90,0xa4,0x14,0x21,0x45,0x92,0x88,0xa4,0x10,0x01,0x49,
 0x08,0x25,0x42,0x22,0x84,0x18,0x85,0x40,0x90,0x20,0x08,0xa0,0x04,0x45,0x22,
 0x49,0x81,0x54,0x94,0x90,0x8a,0x48,0x92,0x88,0x44,0x42,0x09,0x11,0xa4,0x94,
 0x24,0x14,0x05,0x54,0x24,0x08,0x44,0x48,0x28,0xa2,0x92,0x14,0x50,0x90,0x82,
 0x2a,0x49,0x20,0x44,0x52,0x8a,0x42,0xa9,0x88,0x50,0x44,0x10,0x48,0x4a,0xa4,
 0x90,0xa4,0x24,0x24,0x24,0x08,0x09,0x11,0x45,0x92,0xa0,0x94,0x28,0x49,0x52,
 0x12,0x25,0x24,0x92,0x52,0x88,0x28,0x49,0x52,0xa2,0x28,0x12,0x45,0x8a,0xa2,
 0x0a,0x29,0x94,0x88,0x24,0x2a,0x49,0x21,0x45,0x24,0x22,0x49,0x52,0x12,0x29,
 0x52,0x4a,0x10,0x51,0x92,0xa2,0xa8,0x02,0x91,0x52,0x29,0x21,0x82,0x14,0x50,
 0x25,0x09,0x4a,0x6a,0x92,0x2a,0x95,0xaa,0x14,0x29,0x29,0x25,0xa5,0x8a,0x2a,
 0x85,0x92,0x24,0x29,0x2a,0x49,0x92,0x92,0x4a,0xa5,0xa4,0xaa,0x92,0x54,0x2a,
 0x25,0x95,0x24,0x2a,0xa5,0x54,0x49,0xa5,0x14,0x55,0x8a,0x94,0x94,0x14,0x85,
 0x80,0x28,0x25,0x49,0xa4,0xa4,0x22,0x55,0x49,0x49,0x92,0x54,0x92,0x52,0x95,
 0x24,0x25,0x49,0x4a,0x49,0x29,0xa5,0x0a,0x89,0x14,0x25,0xd9,0xa4,0x94,0x84,
 0x80,0x54,0x89,0x55,0x15,0xa4,0xb4,0xd5,0x56,0xd5,0x6a,0x55,0x6b,0xd5,0xd6,
 0xda,0x5a,0x6d,0xd5,0x7a,0x6b,0xdb,0xd6,0xd5,0xb6,0x6d,0x6d,0xb5,0x5a,0x5b,
 0x55,0x6d,0xab,0xad,0xda,0x6a,0xdb,0xd5,0x5a,0xab,0xb6,0x5a,0xeb,0xaa,0x75,
 0x6b,0x6b,0xeb,0x7a,0x7f,0xd7,0xda,0xb6,0xdb,0xda,0x6e,0x55,0xb5,0xb6,0x6d,
 0xab,0x6d,0xad,0x6a,0xdb,0xda,0xb6,0xb5,0xb6,0xd6,0x5a,0xf5,0x76,0x6b,0xd5,
 0x56,0x5b,0x6b,0xbb,0xbe,0xad,0x76,0x55,0x15,0x01,0x5a,0xb5,0xea,0xaa,0xd6,
 0xb6,0xaa,0xb6,0xaa,0x56,0xad,0xb6,0x6a,0x4d,0xb5,0xaa,0xaa,0xb6,0xaa,0xaa,
 0x56,0xab,0x56,0xd5,0xaa,0x55,0xd5,0x6a,0xab,0xaa,0xaa,0xaa,0xaa,0x55,0xd5,
 0xaa,0xaa,0xd6,0x56,0x55,0x55,0xad,0xaa,0x92,0xaa,0xaa,0xaa,0xaa,0x56,0x55,
 0x6b,0x5b,0x55,0x55,0xb5,0xaa,0x56,0x5b,0x55,0x55,0x55,0x55,0xab,0x55,0xab,
 0x56,0x55,0xb5,0xb6,0xaa,0xaa,0xaa,0xaa,0x55,0xd5,0xaa,0x96,0x2a,0x54,0xab,
 0x56,0xad,0x6d,0xad,0x6a,0x6d,0xad,0x6d,0xb5,0x6a,0xd5,0x56,0xab,0x56,0x55,
 0xb5,0xaa,0x55,0xb5,0xb5,0xd6,0x6a,0xad,0x6d,0xad,0xb6,0x56,0x55,0x5b,0x55,
 0x5b,0x5b,0x6d,0x55,0x6b,0xad,0x5a,0x55,0xdb,0x5a,0x55,0xab,0x76,0xb5,0x6d,
 0x55,0xb5,0xb5,0xaa,0x56,0xd5,0xaa,0xaa,0x56,0xd5,0xda,0xaa,0xb6,0xad,0x5a,
 0x6b,0x55,0xad,0x6a,0x55,0xab,0xaa,0x55,0xb5,0xb5,0x6d,0xad,0xaa,0xb6,0x56,
 0xb5,0x14,0x00,0xd5,0x5a,0xab,0xaa,0xb5,0x55,0xab,0x55,0x55,0x55,0xab,0x55,
 0x6b,0x75,0xdb,0xb6,0xad,0x5a,0x6d,0x5b,0xd5,0x6a,0x55,0xab,0x56,0xb5,0x55,
 0xd5,0xda,0xaa,0x6d,0xd5,0x6a,0x55,0x5b,0xb5,0x56,0xab,0x6a,0x55,0x6b,0x6b,
 0xd5,0x4a,0xad,0xaa,0x6d,0x5b,0xd5,0xb6,0xb5,0xaa,0xb6,0x6d,0xab,0x6d,0x55,
 0xb5,0x55,0xd5,0xd6,0x5a,0x6d,0xb5,0xad,0x6a,0xb5,0xad,0xaa,0xad,0x5a,0x55,
 0x6b,0x6d,0xab,0xda,0x5a,0x15,0xea,0x5a,0xd5,0x5a,0xad,0xaa,0xd6,0x5a,0xb5,
 0xda,0xb6,0x56,0xab,0x5a,0x55,0x55,0x55,0x6b,0x6b,0xd5,0xaa,0x56,0xad,0xad,
 0x5a,0xb5,0xaa,0xaa,0xad,0x55,0x6d,0xd5,0xaa,0x56,0xdb,0x6a,0xad,0xb5,0x6a,
 0x5b,0xab,0xaa,0x5a,0x5b,0xdd,0x6a,0x55,0x55,0x55,0xab,0xaa,0x6a,0x5b,0x55,
 0x55,0x6d,0xab,0xaa,0x56,0xd5,0x5a,0x55,0xd5,0xda,0xaa,0xda,0xd6,0xaa,0xda,
 0xb6,0x6a,0xd5,0xaa,0xaa,0x55,0xd5,0xaa,0x55,0x25,0x20,0xad,0xad,0x6a,0x6b,
 0x55,0xb5,0xaa,0xd6,0x56,0x55,0xb5,0xda,0xaa,0xad,0x55,0x6b,0x55,0x55,0x5b,
 0x6d,0x6b,0xab,0x6a,0xab,0xd5,0x56,0x6d,0x55,0x6d,0xab,0x5a,0xdb,0xaa,0x55,
 0x55,0xab,0xaa,0xb5,0xaa,0xda,0x5a,0xab,0xaa,0x55,0xad,0xb6,0xb6,0xd6,0x5a,
 0x6d,0xad,0x6a,0xdb,0xb6,0x55,0xb5,0xb6,0xd5,0x5a,0x6b,0x6b,0x5b,0x2b,0xdb,
 0xaa,0x5a,0x5b,0xab,0x5a,0xad,0xad,0xb6,0xb5,0xaa,0x5a,0xab,0x6a,0x15,0xd2,
 0x6a,0xb5,0x55,0x55,0xdb,0xaa,0xd6,0xaa,0xaa,0x6d,0x6d,0xb5,0x56,0x55,0x6d,
 0xad,0xda,0x5a,0x55,0x55,0x55,0xb5,0x56,0xb5,0xaa,0xda,0x5a,0x5b,0xab,0x5a,
 0xab,0xaa,0x5a,0xb5,0xb6,0x6a,0x6d,0xad,0xd5,0xaa,0xd6,0x6a,0x6d,0xb5,0xd5,
 0x6a,0xd5,0x5a,0xb5,0x55,0xab,0x55,0x55,0x55,0xb5,0xaa,0x55,0xad,0xb5,0xaa,
 0x56,0x55,0xd5,0xaa,0x56,0x55,0xb5,0x6a,0xd5,0xaa,0x6a,0x55,0xab,0x6d,0xab,
 0xb6,0x56,0x15,0x58,0xab,0x56,0xad,0xb6,0xad,0xb6,0xb5,0x5a,0xb5,0xaa,0x55,
 0xab,0xda,0xda,0xaa,0xaa,0xad,0xd6,0x6a,0xab,0xb5,0xaa,0xb5,0x56,0x5b,0x55,
 0xab,0x6a,0x55,0xd5,0x6a,0x6d,0x6b,0xad,0x55,0xad,0x56,0x55,0x6d,0x6d,0xab,
 0x5a,0xab,0xaa,0x6a,0xad,0x5a,0x55,0xad,0x6a,0xd5,0xda,0xaa,0xaa,0x5a,0x5b,
 0xb5,0x55,0xad,0x5a,0xb5,0x6a,0x6d,0x55,0xb5,0xad,0xd6,0x5a,0xab,0xd6,0x56,
 0xb5,0x5a,0x55,0x6d,0x55,0x5b,0x2b,0x56,0xad,0xaa,0xda,0xaa,0x6a,0x55,0x55,
 0x6b,0x6b,0x55,0xab,0xd6,0xaa,0x55,0xdb,0xb6,0xaa,0xaa,0xad,0xb6,0xd6,0x56,
 0xd5,0x6a,0xb5,0x6b,0xd5,0xaa,0xda,0x56,0xad,0x55,0x55,0xab,0xda,0x5a,0xd5,
 0x6a,0x55,0xab,0x5a,0xab,0x5a,0x6b,0xad,0xaa,0xd5,0xb6,0x55,0x5b,0xad,0x56,
 0xdb,0xb6,0xd5,0x6a,0xab,0x5a,0xd5,0xd6,0x6a,0x5b,0xab,0x6d,0xab,0xda,0xaa,
 0x55,0x6d,0xad,0xda,0xd6,0x6a,0xdb,0xaa,0x6a,0xd5,0x2a,0xaa,0xb5,0xb5,0x55,
 0x55,0x55,0x5b,0xad,0x55,0xad,0x6d,0xd5,0x5a,0xad,0x6a,0x55,0x55,0xb5,0xb5,
 0xaa,0xaa,0xaa,0xda,0x5a,0xb5,0x56,0xb5,0xb6,0xb6,0xad,0x6a,0xab,0xaa,0x5a,
 0xd5,0x56,0xab,0xb5,0xb6,0x5a,0xb5,0x6a,0xb5,0xd5,0x5a,0xab,0x6d,0xad,0xaa,
 0xd6,0xaa,0xb5,0x6a,0x55,0xab,0x56,0xad,0x5a,0x6b,0xab,0xaa,0x56,0x55,0xb5,
 0xaa,0x55,0xab,0x5a,0xd6,0xaa,0x55,0xab,0xaa,0x56,0x55,0xd5,0xb6,0x6a,0x15};

/* fig2dev with gs sets creates xbm file named "noname_" */
icon_struct	letters_ic = { noname_width, noname_height, 
			      (char*)noname_bits };
icon_struct	spl_bckgnd_ic = { spl_bckgnd_width, spl_bckgnd_height, 
			      (char*)spl_bckgnd_bits };

#define		MODE_SW_HT_SMALL	22	/* height of a small mode switch icon */
#define		MODE_SW_WD_SMALL	22	/* width of a small mode switch icon */
#define		MODE_SW_HT_BIG	32	/* height of a mode switch icon */
#define		MODE_SW_WD_BIG	36	/* width of a mode switch icon */



int mode_sw_ht;
int mode_sw_wd;

void setup_icons_small()
{
	mode_sw_ht = MODE_SW_HT_SMALL;
	mode_sw_wd = MODE_SW_WD_SMALL;
	populate_icons_small();
}

void setup_icons_big()
{
	mode_sw_ht = MODE_SW_HT_BIG;
	mode_sw_wd = MODE_SW_WD_BIG;
	populate_icons_big();
}
