/*   
  *   *  
 *  Copyright (C) 2001-2005 Edscott Wilson Garcia under GNU GPL
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
static void *smb_object;

static xfdir_t smb_xfdir;
static GList *listSMB=NULL;
static GList *listSHARES=NULL;
static GList *listMASTERS=NULL;
static int   smb_count;
static char *smb_server;
static char *smb_pass;
static gboolean samba_server;
static int cual_chingao,query_result=UNDEFINED;

static widgets_t *smb_widgets_p=NULL;


typedef struct share_t{
	char *share;
	unsigned type;
}share_t;

#include "smblookup.i"

static void set_private_variables(widgets_t *widgets_p){
    smb_widgets_p=widgets_p;
}


static void 
free_share_t(gpointer data,gpointer user_data){
	share_t *d_share=(share_t *)data;
	g_free(d_share->share);
	d_share->share=NULL;
	g_free(d_share);
	d_share=NULL;
}
	


static
int smb_stderr(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    if (strstr(line,"Server="))
	print_diagnostics(smb_widgets_p,NULL, line, NULL);
    else
	print_diagnostics(smb_widgets_p,"xfce/error", line, NULL);
    return TRUE;
}


static
void 
free_data(gpointer data,gpointer user_data){
	g_free((char *)(data));
	data=NULL;
}

static void
printout_shares(gpointer data,gpointer user_data){
  share_t *d_share=(share_t *)data;
  smb_xfdir.gl[smb_count].pathv=g_strdup(d_share->share);
  
  smb_xfdir.gl[smb_count].en=mk_entry(0);
  SET_NETWORK_TYPE(smb_xfdir.gl[smb_count].en->type);

  if (samba_server) SET_SAMBA_SERVER(smb_xfdir.gl[smb_count].en->subtype);
  smb_xfdir.gl[smb_count].en->path=
	(char *)malloc(strlen(d_share->share)+strlen(smb_server)+2);
  sprintf(smb_xfdir.gl[smb_count].en->path,"%s/%s",smb_server,d_share->share);
  smb_xfdir.gl[smb_count].en->st=(struct stat *)malloc(sizeof(struct stat));
  smb_xfdir.gl[smb_count].en->st->st_size=0;
  smb_xfdir.gl[smb_count].en->st->st_mtime=time(NULL);
  smb_xfdir.gl[smb_count].en->st->st_gid=(gid_t)-1;
  smb_xfdir.gl[smb_count].en->st->st_uid=(uid_t)-1;
  smb_xfdir.gl[smb_count].en->st->st_mode=S_IFLNK;
  if (smb_pass) smb_xfdir.gl[smb_count].en->tag=g_strdup(smb_pass);
  else {
	  if (getenv("SMB_USER") && strlen(getenv("SMB_USER"))
			  && strchr(getenv("SMB_USER"),'%'))
		  smb_xfdir.gl[smb_count].en->tag=g_strdup(getenv("SMB_USER"));
	  else 
		  smb_xfdir.gl[smb_count].en->tag=g_strdup("GUEST%%");
  }
  
  switch (d_share->type){
	  case __XF_NETSHARE:
		  SET_XF_NODE(smb_xfdir.gl[smb_count].en->type);
		  SET_XF_NETSHARE(smb_xfdir.gl[smb_count].en->subtype);
		  break;
	  case __XF_NETPRINT:
		  SET_XF_NETPRINT(smb_xfdir.gl[smb_count].en->subtype);
		  break;
	  case __XF_NETIPC:
		  SET_XF_NODE(smb_xfdir.gl[smb_count].en->type);
		  SET_XF_NETIPC(smb_xfdir.gl[smb_count].en->subtype);
		  break;
  }
  smb_count++;
}

static void
SMBForkOver (pid_t pid)
{	
  smb_object = NULL;
  return;
}
 
 
static
xfdir_t *
private_get_xfdir(record_entry_t *en){
  gchar *servidor, *g;
  char *argument[7];
  int i;
  char *c=getenv("SMB_USER");

  TRACE("private_get_xfdir smb_ws.c, en=0x%x,user=%s",
	  (unsigned)en,c);

  if (!en) return NULL;

  servidor=en->path;
  
  if (!servidor || !strlen(servidor) || smb_object){
     return FALSE;
  }
	  
  if (!en->tag) {
    if (c && strlen(c)){
	if (!strchr(c,'%')){
	    en->tag=g_strconcat(c,"%","challenge_me",NULL);
	}
	else en->tag=g_strconcat(c,"challenge_me",NULL);	
    }
    else en->tag=g_strconcat("GUEST","%%",NULL);
  }
	  
  if (strncmp(en->tag,"GUEST",strlen("GUEST"))!=0){
      if (*(strchr(en->tag,'%')+1) == 0){
	  c=en->tag;
	  en->tag=g_strconcat(c,"%","challenge_me",NULL);
	  g_free(c);
      }	  
  }
 
ask_again:
  
  smb_server=servidor; 
  if (en->tag) smb_pass=en->tag;
  samba_server=FALSE;
  cual_chingao = 0;

  g=g_strdup_printf( _("Querying %s"), servidor);
  print_status(smb_widgets_p,NULL,g,NULL);

  /* bla bla section */
  print_diagnostics(smb_widgets_p,NULL,"XFSAMBA> smbclient -N -L ",servidor,"\n",NULL);
  /*print_diagnostics(smb_widgets_p,NULL,"XFSAMBA> smbclient -N -U ",en->tag," -L ",servidor,"\n",NULL);*/
  
   if (listSMB){
	g_list_foreach(listSMB,free_data,NULL);
      	g_list_free(listSMB);
	listSMB=NULL;
  }
  if (strncmp(servidor,"//",strlen("//"))==0) listSMB = g_list_append (listSMB,(gpointer)(g_strdup(servidor+2)));
  
  if (listSHARES){
	g_list_foreach(listSHARES,free_share_t,NULL);
      	g_list_free(listSHARES);
	listSHARES=NULL;
  }
  if (listMASTERS){
	g_list_foreach(listMASTERS,free_data,NULL);
      	g_list_free(listMASTERS);
	listMASTERS=NULL;
  }

  i=0;
  argument[i++]=  "smbclient";
  argument[i++]=  "-N";
  /*
  if (caso && pass) */
  {
    argument[i++]=  "-U";
    argument[i++]=  en->tag;
  }
  argument[i++]=  "-L";
  argument[i++]=  servidor;
  argument[i++]=  0;


  
  query_result=UNDEFINED;
  smb_object = Tubo (fork_function, 
	(void *)argument, 
	SMBForkOver, 
	NULL, 
	SMBparseLookup, 
	smb_stderr,0,FALSE);
  while (smb_object){
	 set_progress_generic(smb_widgets_p,-1,-1,1);
     while (gtk_events_pending()) gtk_main_iteration();
     usleep(5000);
  }

  switch (query_result) {
	  case UNDEFINED:
		  printf("TRACE: undefined error at smblookup.c\n");
		  break;
	  case CHALLENGED:
		{
		  const char *p;
                  print_status(smb_widgets_p,"xfce/warning",
				  _("Query password has been requested."),
				  NULL);
	       
		  p=xffm_get_smbuserpass(smb_widgets_p,en);
		  if (p && strlen(p)) {
		       g_free(en->tag);
		       en->tag=g_strdup(p);
		       goto ask_again;
		  } else {
		    smb_xfdir.pathc = 0;
		  }
		}

		  break;
	  case SUCCESS:
		  print_status(smb_widgets_p,"xfce/info",
				  _("SMB query done"),
				  NULL);
  		  if (listSHARES){
  			print_status(smb_widgets_p,"xfce/info",
				  _("Query done"),NULL);
        		smb_xfdir.pathc = g_list_length(listSHARES);
        		smb_xfdir.gl = (dir_t *) malloc(smb_xfdir.pathc * sizeof(dir_t));
			smb_count=0;
			g_list_foreach(listSHARES,printout_shares,NULL);
		  } else {
		    smb_xfdir.pathc = 0;
		  }
		  break;
	  case FAILED:
		  print_status(smb_widgets_p,"xfce/error",
				  _("SMB query failed"),
				  NULL);
		  smb_xfdir.pathc = 0;
	  default: break;
  }
  return &smb_xfdir;
}



