
static int childFD;
extern gboolean force_override;
static pid_t Gpid;
static gboolean exit_status;

static widgets_t *rcp_widgets_p;

static gint watch_stop(gpointer data)
{
    
    if(!rcp_widgets_p->tubo_object) return FALSE;
    if(rcp_widgets_p->stop)
    {
	gchar *m=g_strdup_printf("%d", Gpid);
	print_diagnostics(rcp_widgets_p,"xfce/warning", strerror(ECANCELLED), " pid=", m, NULL);
	g_free(m);
	/*cancelled = TRUE;*/
	TuboCancel(rcp_widgets_p->tubo_object, NULL);
	rcp_widgets_p->stop = FALSE;
	rcp_widgets_p->tubo_object = NULL;
	
	hide_stop(rcp_widgets_p);
	Gpid = 0;
	/*cursor_reset(rcp_window);*/
	return FALSE;
    }
    set_progress_generic(rcp_widgets_p,-1, -1,1);
    return TRUE;
}

static int operate_stderr(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    if (!line) return TRUE;
#ifdef DEBUG
    printf("stderr:%s",line);
#endif
    if (strncmp(line,"debug1:",strlen("debug1:"))==0){
	    TRACE("%s",line);
    }
    if (line[0] != '\n'){
	   if (strncmp(line,"debug1:",strlen("debug1:"))!=0 ||
		strstr(line,"uthentication"))  {
	      print_diagnostics(rcp_widgets_p, "xfce/error", line, NULL);
	   }
    }
    if (strstr(line,"debug1: Exit status 1")) exit_status=TRUE;
    
    if (strstr(line,"Next authentication method: password") || strstr(line,"assword:")){
	const char *p;
    	print_diagnostics(rcp_widgets_p, "xfce/warning",_("Query password has been requested"),"\n", NULL);
	p=xffm_get_password(rcp_widgets_p,_("Query password has been requested"));
	if (p && strlen(p)) write(childFD,p,strlen(p));
	write(childFD,"\n",strlen("\n"));
	return TRUE;
    }
    return TRUE;
}

static int operate_stdout(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    print_diagnostics(rcp_widgets_p,NULL, line, NULL);
    return TRUE;
}


static void fork_finished_function(pid_t pid)
{
    char m[32];
    int status;
    sprintf(m, "%d\n", pid);

    hide_stop(rcp_widgets_p);
    waitpid(pid, &status, WNOHANG);
    if (exit_status)
	    print_diagnostics(rcp_widgets_p,"xfce/error", _("Command done"), "\n",NULL);
    else
	    print_diagnostics(rcp_widgets_p,"xfce/info",  _("Command done"), "\n",NULL);
    
    if(rcp_widgets_p->progress) {
	/* XXX: fixme: only on return for treeview... */
	//local_monitor(TRUE);
	gtk_widget_hide(rcp_widgets_p->progress);    
    }
    rcp_widgets_p->tubo_object = NULL;
}


