#ifndef __MODULES__H_
#define __MODULES__H_

#include <gtk/gtk.h>
#include "types.h"

#include "../modules/combo-module.h"
#include "../modules/icon-module.h"
#include "../modules/applications-module.h"
#include "../modules/properties-module.h"
#include "../modules/find-module.h"
#include "../plugins/trash/trash.h"

 

#define FSTAB_is_mounted(x) (function_natural("plugins","xffm_fstab",(void *)(x),"is_mounted"))
#define FSTAB_is_in_fstab(x) (function_natural("plugins","xffm_fstab",(void *)(x),"is_in_fstab"))
#define FSTAB_fstab_mount(x,y) (function_rational("plugins","xffm_fstab",(void *)(x),(void *)(y),"fstab_mount"))

#define XF_SMBget_cache_file(x,y) (const gchar *)(function_rational("plugins","xffm_smb_list",(void *)(x),(void *)(y),"SMBget_cache_file"))

#define XF_SMBget_netfile_cache_dir(x) (const gchar *)(function_void("plugins","xffm_smb_list","get_netfile_cache_dir"))


void *
function_void(const gchar *librarydir,const gchar *module_name, const gchar *function_id);

/* integers */
void *
function_natural(const gchar *librarydir,const gchar *module_name, void *p,const gchar *function_id);

/* rationals */
void *
function_rational(const gchar *librarydir,const gchar *module_name, void *p,void *q,const gchar *function_id);


xfdir_t *
module_xfdir(		widgets_t *widgets_p,
			const gchar *module_name,
			record_entry_t *en);

gchar **
module_info_cache(	const gchar *path);

GSList *
find_root_plugins(	void);


void *get_xfdir_p(const gchar *librarydir,const gchar *module_name);

void set_module_treeview(GtkTreeView *treeview);

/* private xffm modules: */
/* property module (could be made exportable easily) */
xfprop_functions *load_prop_module(void);
void unload_prop_module(void);


/* trash module */
xftrash_functions *load_trash_module(void);
void unload_trash_module(void);

/* find module */
xffind_functions *load_find_module(void);
void unload_find_module(void);


/* exportable modules: */
/* combo module: */
xfc_combo_functions *load_xfc(void);
void unload_xfc(void);

/* mime module */
xfmime_functions *load_mime_module(void);
void unload_mime_module(void);

/* mime_icon module */
xfmime_icon_functions *load_mime_icon_module(void);
void unload_mime_icon_module(void);


#endif

