/* copywrite 2001-2004 edscott wilson garcia under GNU/GPL 
 * 
 *  pasteboard routines for xffm
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <X11/Xlib.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "constants.h"
#include "types.h"
#include "primary.h"
#include "secondary.h"
#include "actions_lib.h"



extern char *src_host;

/*  */



G_MODULE_EXPORT
void pasteboard_copy_cut(widgets_t *widgets_p, gboolean cut, GList **paste_list)
{
    int len;
    char *buffer,*files;
    GList *tmp;


    if(*paste_list==NULL) return;
    
    if (cut) print_status(widgets_p,"xfce/info",_("Cutting to pasteboard"),NULL);
    else print_status(widgets_p,"xfce/info",_("Copying to pasteboard"),NULL);
    
    process_pending_gtk();
    
    XStoreBuffer(GDK_DISPLAY(), "", 1, CUT_BUFFER);	/* store a null string */
    
    len = 1 + strlen("#xfvalid_buffer:copy:%%:\n");
    len += strlen(OUR_HOST_NAME(widgets_p));
    for(tmp = *paste_list; tmp; tmp = tmp->next)
    {
	int addlen;
	record_entry_t *en=(record_entry_t *)tmp->data;
	if (IS_NETWORK_TYPE(en->type)){
		addlen=strlen("smb://@://\n");
		addlen += ((en->tag)?strlen(en->tag):strlen("GUEST%%"));
	} else addlen=0;
	len += (1 + strlen(en->path)+addlen);
    }
    buffer = (char *)malloc(len * sizeof(char) + 1);
    if(!buffer)
    {
#ifdef DEBUG
	g_warning("xffm: unable to allocate paste buffer\n");
#endif
	return;
    }
    sprintf(buffer, "#xfvalid_buffer:%s:%s:\n", (cut) ? "cut" : "copy", OUR_HOST_NAME(widgets_p));
    files=buffer+ strlen(buffer);

    for(tmp = *paste_list; tmp; tmp = tmp->next)
    {
	record_entry_t *en=(record_entry_t *)tmp->data;
	if (IS_NETWORK_TYPE(en->type)){
		char *server,*remote_file;
		server=g_strdup(en->path+2);
		strtok(server,"/");
		if (IS_XF_NETWS(en->subtype)) {
			sprintf (files, "%s://%s@%s/",
			  IS_SAMBA_SERVER(en->subtype)?"SMB":"smb",
			  (en->tag)?en->tag:"GUEST%%",
			  server);
		} else {
		  	remote_file=server+strlen(server)+1;
		  	sprintf (files, "%s://%s@%s/%s%s",
			  IS_SAMBA_SERVER(en->subtype)?"SMB":"smb",
			  (en->tag)?en->tag:"GUEST%%",
			  server,remote_file,
			  (IS_NETDIR(en->subtype))?"/\n":"\n");
		}
		g_free(server);
		server=NULL;
	        files = files + strlen(files);
		
	} else {
	  strcat(buffer, en->path);
	  strcat(buffer, "\n");
	}
    }
    /*printf("dbg:len=%d,strlen=%d,data=%s\n",len,strlen(buffer),buffer); */
    XStoreBuffer(GDK_DISPLAY(), buffer, len, CUT_BUFFER);
    g_free(buffer);
    buffer=NULL;
    
    if (cut) print_status(widgets_p,"xfce/info",_("Pasteboard cut"),NULL);
    else print_status(widgets_p,"xfce/info",_("Pasteboard copy"),NULL);
}

G_MODULE_EXPORT
void pasteboard_show(widgets_t *widgets_p)
{
    char *b, *word;
    int len = -1;
    char *mess[] = {
	N_("Pasteboard cut"),
	N_("Pasteboard copy")
    };

    b = XFetchBuffer(GDK_DISPLAY(), &len, 0);
    /*printf("dbg:bytes=%d,buffer0=%s\n",len,b); */

    if(b && strlen(b))
    {
	show_text(widgets_p->diagnostics);
	print_diagnostics(widgets_p,"xfce/info",_("List Pasteboard"),":\n", NULL);
	word = b;
	if(valid_pasteboard())
	{
	    strtok(b, ":");
	    if((word = strtok(NULL, ":")) != NULL)
	    {
		if(strcmp(word, "cut") == 0)
		    print_diagnostics(widgets_p,NULL, _(mess[0]), " :\n", NULL);
		else
		    print_diagnostics(widgets_p,NULL, _(mess[1]), " :\n", NULL);
	    }
	    if((word = strtok(NULL, ":")) != NULL)
	    {
		print_diagnostics(widgets_p,NULL, " ", _("from host"), " ", word, " :\n", NULL);
	    }
	    word += (strlen(word) + 1);
	}
	print_diagnostics(widgets_p,NULL, word, "\n", NULL);
    }
    else
    {
	print_diagnostics(widgets_p,"xfce/error", _("The pasteboard is currently empty."), "\n", NULL);
    }

    XFree(b);
    return;
}

G_MODULE_EXPORT
int pasteboard_list(GList **list_p){
    gboolean cut;
    char *b=NULL, *word;
    int i, len = -1;

    b = XFetchBuffer(GDK_DISPLAY(), &len, 0);
    /*printf("dbg:bytes=%d,buffer0=%s\n",len,b); */
    if((!b) || (!strlen(b))) {
no_pasteboard:
	if(b) XFree(b);
	return 0;
    }

    if((word = strtok(b, ":")) == NULL)  goto no_pasteboard;	
    if(!strstr(word, "#xfvalid_buffer")) goto no_pasteboard;	
    if((word = strtok(NULL, ":")) == NULL) goto no_pasteboard;	
    if(strstr(word, "cut")) cut = TRUE; else cut = FALSE;
    if((word = strtok(NULL, ":")) == NULL) goto no_pasteboard;	
    if(!word) {
	goto no_pasteboard;
    }
    src_host = g_strdup(word);

    word = word + strlen(word) + 1;
    if(word[0] == '\n') {
	word++;
	if(word[0] == 0) goto no_pasteboard;	
    } else {
	if((word = strtok(NULL, "\n")) == NULL) goto no_pasteboard;
	word = word + strlen(word) + 1;
    }

    /* create list to send to CreateTmpList */
    i = uri_parse_list(word, list_p);
    if(!i) goto no_pasteboard;	
    XFree(b);			
    if (cut) return 1; else return 2;
}

G_MODULE_EXPORT
int
pasteboard_transfer(widgets_t *widgets_p, record_entry_t *t_en,GList *list, gpointer gui_data, gboolean cut, gboolean symlink){
    gchar *url=(gchar *)list->data;
    if (!url) return 0;
    TRACE("pastepath is %s",xffm_details->pastepath);
    if (strncmp(xffm_details->pastepath,"//",2)==0){
      TRACE("TRACE:pastepath=%s,en->path=%s\n",xffm_details->pastepath,t_en?
			  t_en->path:"null");
	  
    } else {
	if(strncmp(url,"smb://",strlen("smb://"))==0
	    || strncmp(url,"SMB://",strlen("SMB://"))==0)
    	  {				/* src_host may be remote or local  
				   but target only local  or bookmark */
	    if (g_file_test(t_en->path,G_FILE_TEST_EXISTS)) {  
		/* this cannot live in module without excessive complication */
		function_natural("xffm-plugins","xffm_smb_list",t_en,"set_drop_entry");
		function_rational("xffm-plugins","xffm_smb_list",list,widgets_p,"SMBGetFile");
		function_void("xffm-plugins","xffm_smb_list","clear_drop_entry");
	    }
	    return 1;
	  }
    } 

    if (t_en->module) {
	TRACE("en->module=%s",t_en->module);
      if (function_natural("xffm-plugins",t_en->module,t_en,"valid_drop_site")){
	TRACE("module: valid_drop_site for %s",t_en->module);
	function_natural("xffm-plugins",t_en->module,t_en,"set_drop_entry");
	if (function_rational("xffm-plugins",t_en->module,list,widgets_p,"process_drop")){
	    TRACE("module: process_drop ok");
	    /*result=TRUE;*/
	}
	function_void("xffm-plugins",t_en->module,"clear_drop_entry");
	return 1;
      }
    }

    TRACE("scp check");
    /* single command line for rsync not possible, only for scp! */
    if(strcmp(src_host, OUR_HOST_NAME(widgets_p)) != 0)
    {
	int l = 0;
	char **srcs;
	GList *tmp;
	for(tmp = list; tmp != NULL; tmp = tmp->next)
	{
	    l++;
	}
	srcs = (char **)malloc((l+1) * sizeof(char *));
	if(!srcs){
	    g_warning("critical: %s at malloc\n",strerror(errno));
	    return 0;
	}
	srcs[l] = NULL;
	for(l = 0, tmp = list; tmp != NULL; tmp = tmp->next, l++) {
	    srcs[l] = tmp->data;
	}
	xffm_scp(widgets_p, (const gchar **)srcs, t_en->path);
	return 1;
    }
    TRACE("must be local then");
    
    {
	gchar *tmpfile = xffm_CreateTmpList(widgets_p, list, t_en);
	/*fprintf(stderr,"dbg:tmpfile=%s\n",tmpfile); */
	if(tmpfile) {
	    int mode;
	    if (cut) mode=TR_MOVE; else mode=TR_COPY;
	    if (symlink) mode=TR_LINK;
	    xffm_IndirectTransfer(mode, tmpfile, widgets_p);
	    unlink(tmpfile);
	    g_free(tmpfile);
	}
    }
    return 1;
}


