/*
 * Copyright (C) 2002-5 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 * Some code in here contributed by the FSF
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <errno.h>
#include <grp.h>
#include <pwd.h>
#include <regex.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"
#include "primary.h"
#include "secondary.h"


static
void xffm_filter_activate(GtkEntry * entry, gpointer data)
{
    widgets_t *widgets_p=(widgets_t *)data;
    if (!widgets_p) {
	g_warning("xffm_filter_activate: !widgets_p");
	return;
    }
    xffm_refresh(widgets_p);
}

G_MODULE_EXPORT
void set_filter_combo(widgets_t *widgets_p){
    gchar *f;
    GtkWidget *filter_combo;
    gchar *xdg_dir;
    xfc_combo_info_t	*filter_combo_info;
    if (!widgets_p || widgets_p->filter_combo_info) return;
    filter_combo_info=widgets_p->filter_combo_info;
    /* let's postpone module loading if filter is hidden */
    if(!GTK_WIDGET_VISIBLE(lookup_widget(widgets_p->window,"filter_box")))
	    return;
    xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
    f=g_build_filename(xdg_dir,FILTER_DBH_FILE,NULL);

    g_free(xdg_dir);
    filter_combo = lookup_widget(widgets_p->window,"filter_combo");

    if (!filter_combo_info){
	 filter_combo_info = XFC_init_combo((GtkCombo *)filter_combo);
	 filter_combo_info->activate_user_data = widgets_p;
	 filter_combo_info->activate_func = xffm_filter_activate;
         XFC_read_history(filter_combo_info,f);
    }
    g_free (f);
    XFC_set_blank(filter_combo_info);
    return;
}

G_MODULE_EXPORT
const gchar *get_filter(widgets_t *widgets_p)
{
    GtkWidget *filter_entry, *filter_combo;
    char *f;
    static gchar *last_filter=NULL;
    gchar *ff;
    xfc_combo_info_t	*filter_combo_info;
    if (!widgets_p || widgets_p->filter_combo_info) return "*";
    filter_combo_info=widgets_p->filter_combo_info;

    filter_entry = lookup_widget(widgets_p->window,"combo_entry2");
    filter_combo = lookup_widget(widgets_p->window,"filter_combo");
    if(!GTK_WIDGET_VISIBLE(lookup_widget(widgets_p->window,"filter_box")))
    {
	return "*";
    }
    if(!filter_entry) assert_not_reached();
    if (!filter_combo_info){
	set_filter_combo(widgets_p);
    }
   
    f = (char *)gtk_entry_get_text(GTK_ENTRY(filter_entry));
    if(!f || !strlen(f)) return "*";
    if (last_filter && strcmp(last_filter,f)==0) return last_filter;
    
    g_free(last_filter);
    last_filter=g_strdup(f);
    {
	gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	ff=g_build_filename(xdg_dir,FILTER_DBH_FILE,NULL);
	g_free(xdg_dir);
    }
    XFC_read_history(filter_combo_info,ff);
    filter_combo_info->list = g_list_prepend(filter_combo_info->list,g_strdup(f));
    XFC_save_to_history(ff,f);
    g_free (ff);
      
    if (!strlen(last_filter)) return "*";
    else return (const gchar *)last_filter;
}


