/*
 * 
 * copywrite 2003-5 under GNU/GPL which means what it means.
 * Edscott Wilson Garcia 
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <limits.h>

#include <dirent.h>
#include <fcntl.h>
#include <signal.h>
#include <time.h>
#include <utime.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
 
#include "constants.h"
#include "types.h"
#include "primary.h"
#include "actions_lib.h"

#include "tubo.h"


#define MAX_LINE_SIZE (_POSIX_PATH_MAX*3)
#define CHILD_FILE_LENGTH 64

#include "cpy.i"
/*****************************************************************************/
/**********************     exported symbols     *****************************/
/*****************************************************************************/


G_MODULE_EXPORT
gchar *xffm_PlainTmpList (GtkTreeView *treeview,GtkTreeSelection *selection)
{
    gchar *fname = randomTmpName(NULL);

    TRACE("TRACE: fname=%s\n",(fname)?fname:"null");
    if(!fname) return NULL;
    
    if((plaintmpfile = fopen(fname, "w")) == NULL){
    	TRACE("TRACE: cannot open %s for write\n",(fname)?fname:"null");
	g_free(fname);
	return NULL;
    }
    gtk_tree_selection_selected_foreach(selection, get_selection, (gpointer) treeview);
    /*    fprintf(tmpfile, "%d\t%s\t%s\n", TR_COPY, src, tgt);*/
    fclose(plaintmpfile);
    return fname;
}

G_MODULE_EXPORT
gchar *xffm_SimpleTmpList (const gchar *tgt, const gchar *src)
{
    gchar *fname = randomTmpName(NULL);
    FILE *tmpfile;

    TRACE("TRACE: fname=%s\n",(fname)?fname:"null");
    if(!fname) return NULL;
    
    if((tmpfile = fopen(fname, "w")) == NULL){
    	TRACE("TRACE: cannot open %s for write\n",(fname)?fname:"null");
	return NULL;
    }
    fprintf(tmpfile, "%d\t%s\t%s\n", TR_DUPLICATE, src, tgt);
    fclose(tmpfile);
    countT = nitems = 1;
    return fname;
}

G_MODULE_EXPORT
int xffm_warn_target_exists (widgets_t *widgets_p, const gchar *target, const gchar *src)
{
    if(force_override)
    {
	if(!waste){ 
	   return DLG_WASTE;
	} else return DLG_YES;
    }
    else
    {
	overwrite_dlg_result = DLG_CANCEL;
	make_overwrite_dialog(widgets_p, NULL, target, src);
    }
    if (waste && overwrite_dlg_result==DLG_YES) return DLG_WASTE;
    return overwrite_dlg_result;
}

G_MODULE_EXPORT
char *xffm_CreateTmpList (widgets_t *widgets_p, GList * list, record_entry_t * t_en)
{
    char *target = NULL;
    FILE *tmpfile;
    static char *fname = NULL;
    record_entry_t *s_en;

    cpy_widgets_p = widgets_p;
    countT = nitems = 0;
    if((fname = randomTmpName(NULL)) == NULL) return NULL;
    if((tmpfile = fopen(fname, "w")) == NULL) {
	g_free(fname);
	return NULL;
    }
    force_override = FALSE;
    for(; list != NULL; list = list->next)
    {
	int type = 0;
	gchar *url;
	SET_LOCAL_TYPE(type);
	url = list->data;
	s_en = stat_entry(url, type);
	/* entry new has stated path by now */
	if(!s_en) {
	    TRACE("***warning*** s_en is NULL!\n"); 
	    continue;
	}

	target = mktgpath(t_en->path, s_en->path);
	TRACE("target=%s\n",t_en->path);


	switch (ok_input(target, s_en))
	{
	    case DLG_NO:
		print_diagnostics(cpy_widgets_p,NULL, _("Omitting"), " :\n", s_en->path, "\n", NULL);
		break;
	    case DLG_CANCEL:	/* dnd cancelled */
		print_diagnostics(cpy_widgets_p,"xfce/warning", strerror(ECANCELLED), "\n", NULL);
	    case DLG_CANCEL_QUIET:	/* AUTOMATIC */
		destroy_entry(s_en);
		fclose(tmpfile);
		unlink(fname);
		g_free(target); target=NULL;
		return NULL;
	    case DLG_YES:
	    case DLG_CONTINUE:
	    default:
		nitems++;
		/*fprintf(tmpfile, "%d\t%s\t%s\n", u->type, s_en->path, target);*/
		fprintf(tmpfile, "TYPE\t%s\t%s\n",s_en->path, target);
		break;
	}
	destroy_entry(s_en);
    }
    g_free(target); 
    fclose(tmpfile);
    if(!nitems)
    {
	unlink(fname);
	return NULL;
    }
    countT = nitems;
    TRACE("tmp file is %s\n",fname);
    return fname;
}


G_MODULE_EXPORT
gboolean xffm_IndirectTransfer (int mode, const gchar *tmpfile, widgets_t *widgets_p)
{
    if (!tmpfile || !g_file_test(tmpfile,G_FILE_TEST_EXISTS)) return FALSE;
    if (rw_fork_obj || !widgets_p) {
	print_status(widgets_p,"xfce/error",strerror(EBUSY),NULL);
	return FALSE;
    }
    force_override = FALSE;

    cpy_widgets_p = widgets_p;

    if(CHILD_FILE_LENGTH < strlen(tmpfile) + 1) {
	g_warning("CHILD_FILE_LENGTH < strlen(tmpfile)\n");
	assert_not_reached();
    }
    strncpy(child_file, tmpfile, CHILD_FILE_LENGTH);
    child_file[CHILD_FILE_LENGTH - 1] = (char)0;

    child_mode = mode;


    TRACE("Total files to copy/move = %d\n",countT); 
    TRACE("childfile is = %s\n",child_file); 

    initial = time(NULL);
    show_stop(cpy_widgets_p);
    cursor_wait(cpy_widgets_p->window);

    rw_fork_obj = Tubo(ChildTransfer, NULL, rwForkOver, NULL, rwStdout, rwStderr,0,FALSE);

    /* only parent continues from here */
    TRACE("call to innerloop from xffm_IndirectTransfer()\n"); 
    set_innerloop(TRUE);

    /*set_progress_generic(cpy_widgets_p->progress,countT, countT,1);*/

    return TRUE;
}



/**********************************************************************/

