/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"
#include "primary.h"

#include "treeview.h"

G_MODULE_EXPORT
record_entry_t *
treeview_get_selected_entry (		GtkTreeIter * iter)
{
    static record_entry_t *en=NULL;
    gint tree_id = get_active_tree_id();
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = xffm_details->arbol->treestuff[tree_id].selection;

	gtk_tree_selection_set_mode(selection, GTK_SELECTION_SINGLE);
	if(gtk_tree_selection_get_selected(selection, &treemodel, iter))
	{
	    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
	    if(!en) assert_not_reached();
	    if(!IS_PATH(en->type))
	    {
		if(IS_DUMMY_TYPE(en->type))
		{
		    GtkTreeIter *child;
		    child = gtk_tree_iter_copy(iter);
		    gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
		    if(gtk_tree_model_iter_parent(treemodel, iter, child))
			gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
		    if(!IS_PATH(en->type))
			en = NULL;
		    gtk_tree_iter_free(child);
		}
	    }
	    gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
	    return en;

	}

	gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
	if(!en || !get_selectpath_iter(iter, &en)) return NULL;
    
    return en;
}


G_MODULE_EXPORT
void 
free_entry (		GtkTreeModel * treemodel,
			GtkTreeIter *iter,
			record_entry_t *en)
{
    if (!en && !iter){
        g_warning("!en && !iter");
	return;
    } else if (!en) {
       	gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    }
    if (en) {
	g_free(en->filter);
	g_free(en->st);
	g_free(en->path);
	g_free(en->tag);
    }
    g_free(en);
}





  
