#ifndef DESKVIEW_TYPES_H
#define DESKVIEW_TYPES_H

typedef struct desk_population_t {
    int x;
    int y;
    int w;
    int h;
    int serial;
    GdkPixbuf *pixbuf;
    GdkPixbuf *saturated;
    GdkPixbuf *selected_pixbuf;
    gboolean selected;
    PangoLayout *layout;
    PangoRectangle logical_rect;
    record_entry_t *en;
    gchar *icon_id;
    gchar *URL;
    gchar *exec;
} desk_population_t;

typedef struct desk_view_t {
    record_entry_t *en;
    GList *population_list;
    GList *selection_list;
    widgets_t widgets;
    /*GtkWidget *window;*/
    GtkWidget *paper;
    GtkWidget *popup;
    gint paperX;
    gint paperY;
    GdkGC *penGC;
    Pixmap root_pxm;
    Pixmap background;
    GdkPixmap *pixmap;
    gdouble offset_x;
    gdouble offset_y;
    int drag_button;
    gdouble initial_x;
    gdouble initial_y;
    gboolean restore_pixbuf;
    int serial;
    GdkColormap *cmap;
    GdkEventDND drag_event;
    desk_population_t *clicked_p;
    desk_population_t *doing_drag_p;
    desk_population_t *saturated;
    GtkScrolledWindow *scrolled_window;
    int hot_x;
    int hot_y;
    gboolean dragstate;
    XfceDesktopEntry *dentry;
    void *xfdesktop_menu_p;
    gboolean redlight;
} desk_view_t;
    
#endif
