/**********************************************************************/
/*  Copywrite Edscott Wilson Garcia 2005 
 *  See attached GPL licence for further information.
 *
 *  Included code contributed by xfce project is GPL:
 *  Copyright (C) 2004-2005 Eduard Roccatello (eduard@xfce.org)
 *  Copywrite (c) 2004 Brian Tarricone, <bjt23@cornell.edu>
 *  Copyright (C) 2002-2003 Jasper Huijsmans (huysmans@users.sourceforge.net)
 *  Copyright (C) 2003 Benedikt Meurer <benedikt.meurer@unix-ag.uni-siegen.de>
 *  Copyright (c) 2004 Nils Rennebarth
*/

/******************  apfinder... *****************/
/* What to search for in .desktop files */
#define KEYS_LENGTH 10
static const char *keys [KEYS_LENGTH+1] =
{
    "Name",
    "Comment",
    "Icon",
    "Categories",
    "OnlyShowIn",
    "Exec",
    "Terminal",
    "Type",
    "Encoding",
    "URL",
    NULL
};

#if 0
static const char *categories [] =
{
    "All",
    "Recently Used",
    "Core",
    "Development",
    "Office",
    "Graphics",
    "Network",
    "AudioVideo",
    "Game",
    "Education",
    "System",
    "Filemanager",
    "Utility",
    NULL
};

static const char *i18ncategories [] =
{
    N_("All"),
    N_("Recently Used"),
    N_("Core"),
    N_("Development"),
    N_("Office"),
    N_("Graphics"),
    N_("Network"),
    N_("AudioVideo"),
    N_("Game"),
    N_("Education"),
    N_("System"),
    N_("Filemanager"),
    N_("Utility"),
    NULL
};
#endif

static
gchar * 
get_desktop_string(const gchar *string, const gchar *file){
    XfceDesktopEntry * dentry;
    gchar *value=NULL;
    if (!string || !file || !g_file_test(file,G_FILE_TEST_EXISTS)) return NULL;
    dentry = xfce_desktop_entry_new (file, keys, KEYS_LENGTH);
    
    if (xfce_desktop_entry_get_string (dentry, string, TRUE, &value)){
	TRACE("%s: %sstring=%s",string, file,value);
    }
    g_object_unref(G_OBJECT(dentry));
    return value;
}


#if 0
gboolean xfce_appfinder_list_add (XfceDesktopEntry *dentry, GtkListStore *store, GPatternSpec  *psearch, GPatternSpec  *pcat)
{
    GtkTreeIter iter;
    GdkPixbuf *icon = NULL;
    gchar *name = NULL;
    gchar *img = NULL;
    gchar *dcat = NULL;
    gchar *comment = NULL;

    if (!(xfce_desktop_entry_get_string (dentry, "Name", TRUE, &name) && name))
    {
            return FALSE;
    }

    if (pcat)
    {
        if (!(xfce_desktop_entry_get_string (dentry, "Categories", TRUE, &dcat) && dcat))
        {
            return FALSE;
        }
        
        if (g_pattern_match_string (pcat, g_utf8_casefold(dcat, -1)) == FALSE)
        {
            g_free(dcat);
            return FALSE;
        }
    }
    
    if (psearch)
    {
        xfce_desktop_entry_get_string (dentry, "Comment", TRUE, &comment);
        if (!(comment && g_pattern_match_string (psearch, g_utf8_casefold(comment, -1))) &&
                    !g_pattern_match_string (psearch, name))
        {
            return FALSE;
        }
    }

    if (xfce_desktop_entry_get_string (dentry, "Icon", TRUE, &img) && img)
    {
        icon = xfce_themed_icon_load(img, 24);
        g_free(img);
    }
    else
    {
        icon = NULL;
    }
            
    gtk_list_store_append(store, &iter);
    gtk_list_store_set(store, &iter,
                            APP_ICON, icon,
                            APP_TEXT, name,
                            -1);

    g_free(name);
    if (icon)
    {
        g_object_unref (icon);
    }

    return TRUE;
}

/**
 * This function handles all the searches into desktop files
 *
 * @param category - the category to search for (defined into the array in the header)
 * @param pattern - the pattern of the text to search for (set to NULL if any text is ok)
 * @returns GtkListStore * - a pointer to a new list store with the items
 */
GtkListStore *fetch_desktop_resources (gint category, gchar *pattern) {
    XfceDesktopEntry *dentry;
    GtkListStore  *store;
    GPatternSpec  *psearch = NULL;
    GPatternSpec  *pcat = NULL;
    gchar *tmp;
    GDir *dir;
    gchar *filename;
    gchar *fullpath;
    gint n = npaths - 1;
    gint i = 0; /* A counter for general use */

    store = gtk_list_store_new(APP_COLS, GDK_TYPE_PIXBUF, G_TYPE_STRING);
    if (category==APPFINDER_HISTORY)
    {
        /* We load data from appfinder' rc file */
        gchar **history = parseHistory();
        if (history!=NULL)
        {
            while (history[i]!=NULL)
            {
                if (g_file_test(history[i], G_FILE_TEST_EXISTS) &&
                                XFCE_IS_DESKTOP_ENTRY(dentry = xfce_desktop_entry_new (history[i], keys, 7))) 
                {
                    xfce_appfinder_list_add (dentry, store, NULL, FALSE);
                    if (dentry)
                    {
                        g_object_unref (dentry);
                    }
                }
                i++;
            }
            
            if (history)
            {
                g_strfreev(history);
            }
        }
    }
    else
    {
        if (pattern != NULL)
        {
            tmp = g_strconcat("*", g_utf8_casefold(pattern, -1), "*", NULL);
            psearch = g_pattern_spec_new (tmp);
            g_free(tmp);
        }

        if (category!=APPFINDER_ALL)
        {
            tmp = g_strconcat("*", g_utf8_casefold(categories[category], -1), "*", NULL);
            pcat = g_pattern_spec_new (tmp);
            g_free(tmp);
        }

        while (entriespaths[i]!=NULL)
        {
            if ((dir = g_dir_open (entriespaths[i], 0, NULL))!=NULL)
            {
                while ((filename = (gchar *)g_dir_read_name(dir))!=NULL)
                {
                    fullpath = g_build_filename(entriespaths[i], filename, NULL);
                    if (g_str_has_suffix(filename, ".desktop"))
                    {
                        dentry = xfce_desktop_entry_new (fullpath, keys, 7);
                        if (!XFCE_IS_DESKTOP_ENTRY(dentry))
                        {
                            continue;
                        }
                        xfce_appfinder_list_add (dentry, store, psearch, pcat);
                        g_object_unref (dentry);
                        g_free(fullpath);
                    }
                    else if (g_file_test(fullpath, G_FILE_TEST_IS_DIR))
                    {
                        entriespaths[n] = fullpath;
                        entriespaths[n] = NULL;
                    }
                }
                g_dir_close(dir);
            }
            i++;
        }
    }

    if (psearch)
    {
        g_pattern_spec_free (psearch);
    }
    
    if (pcat)
    {
        g_pattern_spec_free (pcat);
    }

    return store;
}
#endif

/****************************   xfdesktop *************************/
static 
void 
do_atoms(		desk_view_t *desk_view_p)
{
    Window xid;
    GdkAtom atom;
#if 0
	//GdkWindow *win=gtk_widget_get_parent_window(desk_view_p->paper);
	// gotta be realized...
        //gdk_window_move_resize (win, 0, 0, root_w,root_h);
	//gdk_window_lower(win);
#endif
    gtk_window_set_type_hint(GTK_WINDOW(desk_view_p->widgets.window), GDK_WINDOW_TYPE_HINT_DESKTOP);
    atom = gdk_atom_intern("_NET_WM_WINDOW_TYPE_DESKTOP", FALSE);
    gdk_property_change(GTK_WIDGET(desk_view_p->widgets.window)->window,
            gdk_atom_intern("_NET_WM_WINDOW_TYPE", FALSE),
            gdk_atom_intern("ATOM", FALSE), 32,
            GDK_PROP_MODE_REPLACE, (guchar *)&atom, 1);
    gtk_widget_realize(desk_view_p->widgets.window);
    xid = GDK_WINDOW_XID(GTK_WIDGET(desk_view_p->widgets.window)->window);
    
    gdk_property_change(gdk_get_default_root_window(),
            gdk_atom_intern("XFCE_DESKTOP_WINDOW", FALSE),
            gdk_atom_intern("WINDOW", FALSE), 32,
            GDK_PROP_MODE_REPLACE, (guchar *)&xid, 1);
   /* we are not nautilus... 
    gdk_property_change(gdk_get_default_root_window(),
            gdk_atom_intern("NAUTILUS_DESKTOP_WINDOW_ID", FALSE),
            gdk_atom_intern("WINDOW", FALSE), 32,
            GDK_PROP_MODE_REPLACE, (guchar *)&xid, 1);*/
}

static 
void
screen_set_selection(desk_view_t *desk_view_p)
{
	const gchar *display = g_getenv("DISPLAY");
	gchar *p;
	gint xscreen = -1;
	
	Window xwin;
	gchar selection_name[100];
	Atom selection_atom;
	
	if(display) {
		if((p=g_strrstr(display, ".")))	xscreen = atoi(p);
	}
	if(xscreen == -1) xscreen = 0;

	/*xwin = GDK_PIXMAP_XID(desk_view_p->pixmap);*/
	xwin = GDK_WINDOW_XID(GTK_WIDGET(desk_view_p->paper)->window);
	/* one screen for now */
	/* xscreen = gdk_screen_get_number(desktop->priv->gscreen);*/
	
	selection_atom = XInternAtom(GDK_DISPLAY(),"XFFM_DESKVIEW_SELECTION", False);
	XSetSelectionOwner(GDK_DISPLAY(), selection_atom, xwin, GDK_CURRENT_TIME);
	

	/* tell xfdesktop we are already here */
	g_snprintf(selection_name, 100, XFDESKTOP_SELECTION_FMT, xscreen);
	selection_atom = XInternAtom(GDK_DISPLAY(), selection_name, False);
	//XSelectInput(GDK_DISPLAY(), xwin, PropertyChangeMask | ButtonPressMask);
	XSetSelectionOwner(GDK_DISPLAY(), selection_atom, xwin, GDK_CURRENT_TIME);
	
	//manager_atom = XInternAtom(GDK_DISPLAY(), "MANAGER", False);
#if 0
	XSelectInput(GDK_DISPLAY(), xwin, PropertyChangeMask | ButtonPressMask);
	XSetSelectionOwner(GDK_DISPLAY(), selection_atom, xwin, GDK_CURRENT_TIME);

	/* listen for client messages */
	/*g_signal_connect(G_OBJECT(desktop), "client-event",
			G_CALLBACK(client_message_received), NULL);*/

	/* Check to see if we managed to claim the selection. If not,
	 * we treat it as if we got it then immediately lost it */
    if(XGetSelectionOwner(GDK_DISPLAY(), selection_atom) == xwin) {
		XClientMessageEvent xev;
		/*Window xroot = GDK_WINDOW_XID(gdk_screen_get_root_window(desktop->priv->gscreen));*/
		Window xroot = GDK_WINDOW_XID(gdk_get_default_root_window());
		
		xev.type = ClientMessage;
		xev.window = xroot;
		xev.message_type = manager_atom;
		xev.format = 32;
		xev.data.l[0] = GDK_CURRENT_TIME;
		xev.data.l[1] = selection_atom;
		xev.data.l[2] = xwin;
		xev.data.l[3] = 0;	/* manager specific data */
		xev.data.l[4] = 0;	/* manager specific data */

		XSendEvent(GDK_DISPLAY(), xroot, False, StructureNotifyMask, (XEvent *)&xev);
	} else {
		g_error("%s: could not set selection ownership", PACKAGE);
		exit(1);
	}
#endif
}

static 
gboolean
zap_if_running(gboolean get_id)
{
    Window xid;
    Atom selection_atom;
    selection_atom = XInternAtom(GDK_DISPLAY(), "XFFM_DESKVIEW_SELECTION", False);
    if((xid = XGetSelectionOwner(GDK_DISPLAY(), selection_atom))){
	if (get_id) printf("0x%x",(unsigned)xid);
	else g_warning("xffm-deskview already running");
	exit(0);
	/*XDestroyWindow(GDK_DISPLAY(),*xid);*/
	return TRUE;
    }
    return FALSE;
}


static 
void
event_forward_to_rootwin(GdkScreen *gscreen, GdkEvent *event)
{
	XButtonEvent xev, xev2;
    Display *dpy = GDK_DISPLAY_XDISPLAY(gdk_screen_get_display(gscreen));
    
	if(event->type == GDK_BUTTON_PRESS || event->type == GDK_BUTTON_RELEASE) {
		if(event->type == GDK_BUTTON_PRESS) {
			xev.type = ButtonPress;
			/*
			 * rox has an option to disable the next
			 * instruction. it is called "blackbox_hack". Does
			 * anyone know why exactly it is needed?
			 */
			XUngrabPointer(dpy, event->button.time);
		} else
			xev.type = ButtonRelease;
        
		xev.button = event->button.button;
		xev.x = event->button.x;	/* Needed for icewm */
		xev.y = event->button.y;
		xev.x_root = event->button.x_root;
		xev.y_root = event->button.y_root;
		xev.state = event->button.state;

		xev2.type = 0;
	} else if(event->type == GDK_SCROLL) {
		xev.type = ButtonPress;
		xev.button = event->scroll.direction + 4;
		xev.x = event->scroll.x;	/* Needed for icewm */
		xev.y = event->scroll.y;
		xev.x_root = event->scroll.x_root;
		xev.y_root = event->scroll.y_root;
		xev.state = event->scroll.state;
		
		xev2.type = ButtonRelease;
		xev2.button = xev.button;
	} else
        return;
    xev.window = GDK_WINDOW_XWINDOW(gdk_screen_get_root_window(gscreen));
	xev.root =  xev.window;
	xev.subwindow = None;
	xev.time = event->button.time;
	xev.same_screen = True;

	XSendEvent(dpy, xev.window, False, ButtonPressMask | ButtonReleaseMask,
            (XEvent *)&xev);
	if(xev2.type == 0)
        return;

	/* send button release for scroll event */
	xev2.window = xev.window;
	xev2.root = xev.root;
	xev2.subwindow = xev.subwindow;
	xev2.time = xev.time;
	xev2.x = xev.x;
	xev2.y = xev.y;
	xev2.x_root = xev.x_root;
	xev2.y_root = xev.y_root;
	xev2.state = xev.state;
	xev2.same_screen = xev.same_screen;

	XSendEvent(dpy, xev2.window, False, ButtonPressMask | ButtonReleaseMask,
            (XEvent *)&xev2);
}

static 
gboolean
scroll_cb(GtkWidget *w, GdkEventScroll *evt, gpointer user_data)
{
	event_forward_to_rootwin(gtk_widget_get_screen(w), (GdkEvent*)evt);
	return TRUE;
}

static
int
desktop_main(int argc, char **argv)
{
    if(argc > 1 && (!strcmp(argv[1], "--version") || !strcmp(argv[1], "-V"))) 
    {
    	g_print("\tThis is %s version %s for Xfce %s\n", PACKAGE, VERSION,
			xfce_version_string());
	g_print("\tbuilt with GTK+-%d.%d.%d, ", GTK_MAJOR_VERSION,
			GTK_MINOR_VERSION, GTK_MICRO_VERSION);
	g_print("linked with GTK+-%d.%d.%d.\n", gtk_major_version,
			gtk_minor_version, gtk_micro_version);
	exit(0);
    }
    zap_if_running(FALSE);
    return 0;
}


