// Preferences dialog box

#include "config.h"
#include "i18n.h"

#include <fox-1.6/fx.h>
#include <fox-1.6/fxkeys.h>

#include "icons.h"
#include "xfedefs.h"
#include "File.h"
#include "FileDialog.h"
#include "FontDialog.h"
#include "Preferences.h"
#include "XFileExplorer.h"
#include "MessageBox.h"


FXbool Theme::operator != (const Theme& t)
{
    for(int i=0;i<COLORS_NUM;i++)
        if(color[i] != t.color[i])
            return TRUE;
    return FALSE;
}

// Main window
extern FXMainWindow *mainWindow;

// Single click navigation
extern FXbool single_click_diropen;
extern FXbool single_click_fileopen;


// Map
FXDEFMAP(PreferencesBox) PreferencesMap[]=
{
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_ACCEPT,PreferencesBox::onCmdAccept),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_CANCEL,PreferencesBox::onCmdCancel),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_TXTEDIT,PreferencesBox::onCmdBrowse),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_TXTVIEW,PreferencesBox::onCmdBrowse),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_IMGVIEW,PreferencesBox::onCmdBrowse),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_XTERM,PreferencesBox::onCmdBrowse),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_COLOR,PreferencesBox::onCmdColor),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_NORMALFONT,PreferencesBox::onCmdNormalFont),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_TEXTFONT,PreferencesBox::onCmdTextFont),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_THEME,PreferencesBox::onCmdTheme),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_BROWSE_ICON_PATH,PreferencesBox::onCmdBrowsePath),
	FXMAPFUNC(SEL_UPDATE,PreferencesBox::ID_COLOR,PreferencesBox::onUpdColor),
	FXMAPFUNC(SEL_UPDATE,PreferencesBox::ID_TRASH_BYPASS,PreferencesBox::onUpdTrashBypass),
	FXMAPFUNC(SEL_UPDATE,PreferencesBox::ID_CONFIRM_DEL_EMPTYDIR,PreferencesBox::onUpdConfirmDelEmptyDir),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_SU_CMD,PreferencesBox::onCmdSuMode),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_SUDO_CMD,PreferencesBox::onCmdSuMode),
	FXMAPFUNC(SEL_UPDATE,PreferencesBox::ID_SU_CMD,PreferencesBox::onUpdSuMode),
	FXMAPFUNC(SEL_UPDATE,PreferencesBox::ID_SUDO_CMD,PreferencesBox::onUpdSuMode),
	FXMAPFUNC(SEL_UPDATE,PreferencesBox::ID_COLOR,PreferencesBox::onUpdColor),
	FXMAPFUNC(SEL_COMMAND,PreferencesBox::ID_WHEELADJUST,PreferencesBox::onCmdWheelAdjust),
	FXMAPFUNC(SEL_UPDATE,PreferencesBox::ID_WHEELADJUST,PreferencesBox::onUpdWheelAdjust),
	FXMAPFUNC(SEL_UPDATE,PreferencesBox::ID_SINGLE_CLICK_FILEOPEN,PreferencesBox::onUpdSingleClickFileopen),
};

// Object implementation
FXIMPLEMENT(PreferencesBox,DialogBox,PreferencesMap,ARRAYNUMBER(PreferencesMap))

// Construct window for one file
PreferencesBox::PreferencesBox(FXWindow *win, FXColor listbackcolor, FXColor listforecolor, FXColor highlightcolor): DialogBox(win,_("Preferences"), DECOR_TITLE|DECOR_BORDER)
{
    currTheme.name = _("Current Theme");
    currTheme.color[0] = getApp()->getBaseColor();
    currTheme.color[1] = getApp()->getBorderColor();
    currTheme.color[2] = getApp()->getBackColor();
    currTheme.color[3] = getApp()->getForeColor();
    currTheme.color[4] = getApp()->getSelbackColor();
    currTheme.color[5] = getApp()->getSelforeColor();
    currTheme.color[6] = listbackcolor;
    currTheme.color[7] = listforecolor;
    currTheme.color[8] = highlightcolor;

    Themes[0] = currTheme;
    Themes[1] = Theme("GNOME2",FXRGB(220,218,213),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(75,105,131),FXRGB(255,255,255),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(238,238,238));
    Themes[2] = Theme("KDE3",FXRGB(238,238,230),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(255,222,118),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(238,238,238));
    Themes[3] = Theme("XFCE4",FXRGB(238,238,238),FXRGB(0,0,0),FXRGB(238,238,238),FXRGB(0,0,0),FXRGB(99,119,146),FXRGB(255,255,255),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(238,238,238));
    Themes[4] = Theme("CDE",FXRGB(156,153,156),FXRGB(0,0,0),FXRGB(131,129,131),FXRGB(255,255,255),FXRGB(49,97,131),FXRGB(255,255,255),FXRGB(131,129,131),FXRGB(255,255,255),FXRGB(131,129,131));
    Themes[5] = Theme("Digital CDE",FXRGB(74,121,131),FXRGB(0,0,0),FXRGB(49,76,74),FXRGB(255,255,255),FXRGB(65,80,90),FXRGB(255,255,255),FXRGB(49,76,74),FXRGB(255,255,255),FXRGB(49,76,74));
    Themes[6] = Theme("Sea Sky",FXRGB(165,178,198),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(49,101,156),FXRGB(255,255,255),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(238,238,238));
    Themes[7] = Theme("Blue Slate",FXRGB(156,186,205),FXRGB(0,0,0),FXRGB(197,194,197),FXRGB(0,0,0),FXRGB(82,129,148),FXRGB(255,255,255),FXRGB(197,194,197),FXRGB(0,0,0),FXRGB(238,238,238));
    Themes[8] = Theme("Human",FXRGB(0xEF,0xEB,0xE7),FXRGB(0,0,0),FXRGB(0xEE,0xEE,0xEE),FXRGB(0,0,0),FXRGB(0xB3,0x91,0x69),FXRGB(0xFF,0xFF,0xFF),FXRGB(0xEE,0xEE,0xEE),FXRGB(0,0,0),FXRGB(255,255,255));
    Themes[9] = Theme("iMac",FXRGB(205,206,205),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(0,0,128),FXRGB(255,255,255),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(238,238,238));
    Themes[10] = Theme("BeOS",FXRGB(222,218,222),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(172,170,172),FXRGB(255,255,255),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(238,238,238));
	Themes[11] = Theme("Windows 95",FXRGB(192,192,192),FXRGB(0,0,0),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(0,0,128),FXRGB(255,255,255),FXRGB(255,255,255),FXRGB(0,0,0),FXRGB(238,238,238));


    // Buttons
    FXHorizontalFrame *buttons=new FXHorizontalFrame(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X,0,0,0,0,10,10,5,5);

    // Contents
    FXHorizontalFrame *contents=new FXHorizontalFrame(this,LAYOUT_SIDE_TOP|FRAME_NONE|LAYOUT_FILL_X|LAYOUT_FILL_Y|PACK_UNIFORM_WIDTH);

	// Accept
    FXButton *ok = new FXButton(buttons,_("&Accept"),NULL,this,PreferencesBox::ID_ACCEPT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    ok->addHotKey(KEY_Return);
    
    // Cancel
    new FXButton(buttons,_("&Cancel"),NULL,this,PreferencesBox::ID_CANCEL,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    
	// Switcher
    FXTabBook *tabbook = new FXTabBook(contents,NULL,0,LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_RIGHT);


    // First tab - Options
    new FXTabItem(tabbook,_("&General"),NULL);
    FXVerticalFrame *options=new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);

	FXGroupBox *group=new FXGroupBox(options,_("Options"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    trashcan=new FXCheckButton(group,_("Use trash can for file deletion (safe delete)")); 
	trashbypass=new FXCheckButton(group,_("Include a command to bypass the trash can (permanent delete)"),this,ID_TRASH_BYPASS);
    autosave=new FXCheckButton(group,_("Auto save layout"));
    diropen=new FXCheckButton(group,_("Single click directory open"));
    fileopen=new FXCheckButton(group,_("Single click file open"),this,ID_SINGLE_CLICK_FILEOPEN);

	group=new FXGroupBox(options,_("Mouse"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    FXMatrix *matrix = new FXMatrix(group,2,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);
	new FXLabel(matrix,_("Mouse scrolling speed:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    FXSpinner* spinner=new FXSpinner(matrix,3,this,PreferencesBox::ID_WHEELADJUST,JUSTIFY_RIGHT|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_ROW,0,0,0,0, 2,2,1,1);
    spinner->setRange(1,100);

	group=new FXGroupBox(options,_("Root mode"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
	FXRadioButton* subutton=new FXRadioButton(group,_("Authentication using su (uses root password)"),this,ID_SU_CMD);
	FXRadioButton* sudobutton=new FXRadioButton(group,_("Authentication using sudo (uses user password)"),this,ID_SUDO_CMD);
	if (getuid()==0) // Super user
	{
		subutton->disable();
		sudobutton->disable();
	}
	use_sudo=getApp()->reg().readUnsignedEntry("OPTIONS","use_sudo",FALSE);

    FXbool use_trash_can=getApp()->reg().readUnsignedEntry("OPTIONS","use_trash_can",TRUE);
	trashcan->setCheck(use_trash_can);
    
	if (trashcan->getCheck())
	{
	    FXbool use_trash_bypass=getApp()->reg().readUnsignedEntry("OPTIONS","use_trash_bypass",FALSE);
		trashbypass->setCheck(use_trash_bypass);
	}
	else
		trashbypass->disable();

	FXbool auto_save_layout=getApp()->reg().readUnsignedEntry("OPTIONS","auto_save_layout",TRUE);
	autosave->setCheck(auto_save_layout);
    single_click_diropen=getApp()->reg().readUnsignedEntry("OPTIONS","single_click_diropen",FALSE);
	diropen->setCheck(single_click_diropen);
    single_click_fileopen=getApp()->reg().readUnsignedEntry("OPTIONS","single_click_fileopen",FALSE);
	fileopen->setCheck(single_click_fileopen);

    // Second tab - Dialogs
    new FXTabItem(tabbook,_("&Dialogs"),NULL);
    FXVerticalFrame *dialogs=new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);
	group=new FXGroupBox(dialogs,_("Confirmations"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    ask=new FXCheckButton(group,_("Confirm copy/move/rename/symlink"));
    dnd=new FXCheckButton(group,_("Confirm drag and drop"));
	del=new FXCheckButton(group,_("Confirm delete"));
	del_emptydir=new FXCheckButton(group,_("Confirm delete non empty directories"),this,ID_CONFIRM_DEL_EMPTYDIR);
    overwrite=new FXCheckButton(group,_("Confirm overwrite"));
	quit=new FXCheckButton(group,_("Confirm quit"));

	group=new FXGroupBox(dialogs,_("Warnings"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
#if defined(linux)
    mount=new FXCheckButton (group,_("Warn when mount points are not responding"));
	show_mount=new FXCheckButton(group, _("Display mount/umount success messages"));
#endif
    root_warning=new FXCheckButton (group,_("Warn if running as root"));

	FXbool confirm_quit=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_quit",TRUE);
	quit->setCheck(confirm_quit);
    FXbool confirm_del=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_delete",TRUE);
	del->setCheck(confirm_del);
    FXbool confirm_del_emptydir=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_delete_emptydir",TRUE);
	del_emptydir->setCheck(confirm_del_emptydir);
    FXbool confirm_overwrite=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_overwrite",TRUE);
	overwrite->setCheck(confirm_overwrite);
    FXbool ask_before_copy=getApp()->reg().readUnsignedEntry("OPTIONS","ask_before_copy",TRUE);
	ask->setCheck(ask_before_copy);
    FXbool confirm_dnd=getApp()->reg().readUnsignedEntry("OPTIONS","confirm_drag_and_drop",TRUE);
	dnd->setCheck(confirm_dnd);

#if defined(linux)
	FXbool mount_warn=getApp()->reg().readUnsignedEntry("OPTIONS","mount_warn",TRUE);
	FXbool mount_messages=getApp()->reg().readUnsignedEntry("OPTIONS","mount_messages",TRUE);
	mount->setCheck(mount_warn);
	show_mount->setCheck(mount_messages);
#endif

	FXbool root_warn=getApp()->reg().readUnsignedEntry("OPTIONS","root_warn",TRUE);
	if(getuid()) // Simple user
        root_warning->disable();
    else
        root_warning->setCheck(root_warn);

	// Third tab - Programs
    new FXTabItem(tabbook,_("&Programs"),NULL);
    FXVerticalFrame *programs=new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);
    group=new FXGroupBox(programs,_("Programs"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    matrix = new FXMatrix(group,3,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);

    new FXLabel(matrix,_("Default text editor:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    txteditor = new FXTextField(matrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
    new FXButton(matrix,_("\tSelect file..."),filedialogicon,this,ID_BROWSE_TXTEDIT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    oldtxteditor=getApp()->reg().readStringEntry("PROGS","txteditor","xfw");
    txteditor->setText(oldtxteditor);

	new FXLabel(matrix,_("Default text viewer:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    txtviewer = new FXTextField(matrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
	new FXButton(matrix,_("\tSelect file..."),filedialogicon,this,ID_BROWSE_TXTVIEW,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    oldtxtviewer=getApp()->reg().readStringEntry("PROGS","txtviewer","xfv");
    txtviewer->setText(oldtxtviewer);

	new FXLabel(matrix,_("Default image editor:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    imgeditor = new FXTextField(matrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
	new FXButton(matrix,_("\tSelect file..."),filedialogicon,this,ID_BROWSE_IMGVIEW,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    oldimgeditor=getApp()->reg().readStringEntry("PROGS","imgeditor","gimp");
    imgeditor->setText(oldimgeditor);

	new FXLabel(matrix,_("Default image viewer:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    imgviewer = new FXTextField(matrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
	new FXButton(matrix,_("\tSelect file..."),filedialogicon,this,ID_BROWSE_IMGVIEW,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    oldimgviewer=getApp()->reg().readStringEntry("PROGS","imgviewer","xfi");
    imgviewer->setText(oldimgviewer);

	new FXLabel(matrix,_("Default archiver:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    archiver = new FXTextField(matrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
	new FXButton(matrix,_("\tSelect file..."),filedialogicon,this,ID_BROWSE_IMGVIEW,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    oldarchiver=getApp()->reg().readStringEntry("PROGS","archiver","file-roller");
    archiver->setText(oldarchiver);

	new FXLabel(matrix,_("Terminal program:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    xterm = new FXTextField(matrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
    new FXButton(matrix,_("\tSelect file..."),filedialogicon,this,ID_BROWSE_XTERM,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    oldxterm=getApp()->reg().readStringEntry("PROGS","xterm","xterm -sb");
    xterm->setText(oldxterm);

	// Fourth tab - Visual
    new FXTabItem(tabbook,_("&Themes"),NULL);
    FXVerticalFrame *visual=new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);

    FXGroupBox *themes=new FXGroupBox(visual,_("Color theme"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    FXPacker *pack = new FXPacker(themes,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_Y|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
    themesList = new FXList(pack,this,ID_THEME,LIST_BROWSESELECT|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    themesList->setNumVisible(7);
	for(int i=0;i<THEMES_NUM;i++)
        themesList->appendItem(Themes[i].name);
    themesList->setCurrentItem(0);

    FXGroupBox *colors=new FXGroupBox(visual,_("Custom colors"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X);
    FXHorizontalFrame *col=new FXHorizontalFrame(colors,LAYOUT_FILL_X);
    colorsBox = new FXComboBox(col,COLORS_NUM,NULL,0,COMBOBOX_STATIC|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_SIDE_RIGHT);
  	colorsBox->setNumVisible(COLORS_NUM);
    pack = new FXPacker(col,LAYOUT_SIDE_LEFT|FRAME_SUNKEN|LAYOUT_FILL_Y);
    cwell = new FXButton(pack,"",NULL,this,ID_COLOR,LAYOUT_FIX_WIDTH|LAYOUT_FILL_Y,0,0, 30);

    colorsBox->appendItem(_("Base color"));
    colorsBox->appendItem(_("Border color"));
    colorsBox->appendItem(_("Background color"));
    colorsBox->appendItem(_("Foreground color"));
    colorsBox->appendItem(_("Selection background color"));
    colorsBox->appendItem(_("Selection foreground color"));
    colorsBox->appendItem(_("File list background color"));
    colorsBox->appendItem(_("File list foreground color"));
	colorsBox->appendItem(_("File list highlight color"));
    colorsBox->setCurrentItem(0);

	// Find iconpath from the Xfe registry settings or set it to DEFAULTICONPATH
	FXGroupBox *group2=new FXGroupBox(visual,_("Icon theme path"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X);
	FXMatrix *matrix2 = new FXMatrix(group2,2,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);
	iconpath = new FXTextField(matrix2,40,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
    new FXButton(matrix2,_("\tSelect path..."),filedialogicon,this,ID_BROWSE_ICON_PATH,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
	oldiconpath=getApp()->reg().readStringEntry("SETTINGS","iconpath",DEFAULTICONPATH);
    iconpath->setText(oldiconpath);

    // Fifth tab - Fonts
    new FXTabItem(tabbook,_("&Fonts"),NULL);
    FXVerticalFrame *fonts=new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);
    FXGroupBox *fgroup=new FXGroupBox(fonts,_("Fonts"),GROUPBOX_TITLE_LEFT|FRAME_GROOVE|LAYOUT_FILL_X|LAYOUT_FILL_Y);

    FXMatrix *fmatrix = new FXMatrix(fgroup,3,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    new FXLabel(fmatrix,_("Normal font:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    normalfont = new FXTextField(fmatrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
    new FXButton(fmatrix,_(" Select..."),NULL,this,ID_NORMALFONT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y);//,0,0,0,0,20,20);
    oldnormalfont=getApp()->reg().readStringEntry("SETTINGS","font","Helvetica,100,normal,regular");
    normalfont->setText(oldnormalfont);

    new FXLabel(fmatrix,_("Text font:"),NULL,JUSTIFY_LEFT|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
    textfont = new FXTextField(fmatrix,30,NULL,0,FRAME_THICK|FRAME_SUNKEN|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X);
	new FXButton(fmatrix,_(" Select..."),NULL,this,ID_TEXTFONT,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y);//0,0,0,0,20,20);
    oldtextfont=getApp()->reg().readStringEntry("SETTINGS","textfont","Helvetica,100,normal,regular");
    textfont->setText(oldtextfont);
}


long PreferencesBox::onUpdColor(FXObject* o,FXSelector s,void* p)
{
    FXButton *btn = (FXButton*)o;
    int i = colorsBox->getCurrentItem();
    btn->setBackColor(currTheme.color[i]);
    return 1;
}


long PreferencesBox::onCmdColor(FXObject* o,FXSelector s,void* p)
{
    FXButton *btn = (FXButton*)o;
    FXColorDialog colordlg(this,_("Color Dialog"));
    colordlg.setRGBA(btn->getBackColor());
    if(colordlg.execute())
    {
        int i = colorsBox->getCurrentItem();
        currTheme.color[i] = colordlg.getRGBA();
    }
    return 1;
}


long PreferencesBox::onCmdTheme(FXObject* o,FXSelector s,void* p)
{
    currTheme = Themes[themesList->getCurrentItem()];
    return 1;
}


long PreferencesBox::onCmdBrowsePath(FXObject* o,FXSelector s,void* p)
{
	FileDialog browse(this,_("Select an icon theme directory or an icon file"),0,0,0,650,480);

	browse.setSelectMode(SELECT_FILE_MIXED);
	browse.setFilename(iconpath->getText());

	if(browse.execute())
	{
		FXString path=browse.getFilename();
		if (::isFile(path))
			iconpath->setText(FXPath::directory(path).text());
		else
			iconpath->setText(path);
	}
	return 1;
}


long PreferencesBox::onCmdBrowse(FXObject* o,FXSelector s,void* p)
{
    FileDialog browse(this,_("Select an executable file"),0,0,0,650,480);
    const FXchar *patterns[]=
        {
            _("All files"),     "*",NULL
        };
	browse.setFilename(ROOTDIR);
	browse.setPatternList(patterns);
	browse.setSelectMode(SELECT_FILE_ANY);
    if(browse.execute())
    {
        char *path=strdup(browse.getFilename().text());
        switch(FXSELID(s))
        {
        case ID_BROWSE_TXTEDIT:
            txteditor->setText(FXPath::name(path).text());
            break;
        case ID_BROWSE_TXTVIEW:
            txtviewer->setText(FXPath::name(path).text());
            break;
        case ID_BROWSE_IMGVIEW:
            imgviewer->setText(FXPath::name(path).text());
            break;
        case ID_BROWSE_XTERM:
            xterm->setText(FXPath::name(path).text());
            break;
        }
    }
    return 1;
}

// Change normal font
long PreferencesBox::onCmdNormalFont(FXObject*,FXSelector,void*)
{
    FontDialog fontdlg(this,_("Change Normal Font"),DECOR_BORDER|DECOR_TITLE);
    FXFontDesc fontdesc;
	FXString fontspec;

	fontspec=getApp()->reg().readStringEntry("SETTINGS","font","Helvetica,100,normal,regular");
   	FXFont* nfont=new FXFont(getApp(),fontspec);
	nfont->create();
	nfont->getFontDesc(fontdesc);
    
	fontdlg.setFontSelection(fontdesc);
    if(fontdlg.execute())
    {
        fontdlg.getFontSelection(fontdesc);
		nfont->setFontDesc(fontdesc);
		fontspec=nfont->getFont();
        normalfont->setText(fontspec);
        if(BOX_CLICKED_CANCEL!=MessageBox::question(this,BOX_OK_CANCEL,_("Restart"),_("Normal font will be changed after restart.\nRestart X File Explorer now?")))
		{
        	getApp()->reg().writeStringEntry("SETTINGS","font",fontspec.text());
            mainWindow->handle(this,FXSEL(SEL_COMMAND,XFileExplorer::ID_RESTART),NULL);
			getApp()->setNormalFont(nfont);
		}
    }
    return 1;
}

// Change text font
long PreferencesBox::onCmdTextFont(FXObject*,FXSelector,void*)
{
    FontDialog fontdlg(this,_("Change Text Font"),DECOR_BORDER|DECOR_TITLE);
    FXFontDesc fontdesc;
	FXString fontspec;
	fontspec=getApp()->reg().readStringEntry("SETTINGS","textfont","Helvetica,100,normal,regular");
   	FXFont* tfont=new FXFont(getApp(),fontspec);
	tfont->create();
	tfont->getFontDesc(fontdesc);
    fontdlg.setFontSelection(fontdesc);
    if(fontdlg.execute())
    {
        fontdlg.getFontSelection(fontdesc);
		tfont->setFontDesc(fontdesc);
		fontspec=tfont->getFont();
        textfont->setText(fontspec);
        if(BOX_CLICKED_CANCEL!=MessageBox::question(this,BOX_OK_CANCEL,_("Restart"),_("Text font will be changed after restart.\nRestart X File Explorer now?")))
		{
        	getApp()->reg().writeStringEntry("SETTINGS","textfont",fontspec.text());
            mainWindow->handle(this,FXSEL(SEL_COMMAND,XFileExplorer::ID_RESTART),NULL);
		}
    }
    return 1;
}

long PreferencesBox::onCmdAccept(FXObject* o,FXSelector s,void* p)
{
    FXbool restart=FALSE;
	
	if(oldiconpath != iconpath->getText())
	{
		getApp()->reg().writeStringEntry("SETTINGS","iconpath",iconpath->getText().text());
 		getApp()->reg().write();
		restart=TRUE;
	}

    // Text editor has changed
	if(oldtxteditor != txteditor->getText())
	{
        // Update the txteditor string
		FXString newtxteditor=txteditor->getText().text();
		getApp()->reg().writeStringEntry("PROGS","txteditor",newtxteditor.text());
		
		// Update each filetype where the old txteditor was used
		FXStringDict *strdict = getApp()->reg().find("FILETYPES");
		FileDict *assoc=new FileDict(getApp());

		FXint i;
		FXString key, value, newvalue;
		FXString strtmp, open, view, edit, command;
		for (i=strdict->first(); i<strdict->size(); i=strdict->next(i))
		{
			// Read key and value of each filetype
			key=strdict->key(i);
			value=strdict->data(i);
			
			// Replace the old txteditor string with the new one
			if (value.contains(oldtxteditor))
			{
				// Obtain the open, view, edit and command strings
				strtmp=value.before(';',1);
				command=value.after(';',1);
				open=strtmp.section(',',0);
				view=strtmp.section(',',1);
				edit=strtmp.section(',',2);
				
				// Replace only the open and edit strings, if needed
				if (open==oldtxteditor)
					open=newtxteditor;
				if (edit==oldtxteditor)
					edit=newtxteditor;
				
				// Replace with the new value
				value=open + "," + view + "," + edit + ";" + command;
				assoc->replace(key.text(),value.text());
			}
		}
	}

    // Text viewer has changed
	if(oldtxtviewer != txtviewer->getText())
	{
        // Update the txtviewer string
		FXString newtxtviewer=txtviewer->getText().text();
		getApp()->reg().writeStringEntry("PROGS","txtviewer",newtxtviewer.text());
		
		// Update each filetype where the old txtviewer was used
		FXStringDict *strdict = getApp()->reg().find("FILETYPES");
		FileDict *assoc=new FileDict(getApp());

		FXint i;
		FXString key, value, newvalue;
		FXString strtmp, open, view, edit, command;
		for (i=strdict->first(); i<strdict->size(); i=strdict->next(i))
		{
			// Read key and value of each filetype
			key=strdict->key(i);
			value=strdict->data(i);
			
			// Replace the old txtviewer string with the new one
			if (value.contains(oldtxtviewer))
			{
				// Obtain the open, view, edit and command strings
				strtmp=value.before(';',1);
				command=value.after(';',1);
				open=strtmp.section(',',0);
				view=strtmp.section(',',1);
				edit=strtmp.section(',',2);
				
				// Replace only the view string, if needed
				if (view==oldtxtviewer)
					view=newtxtviewer;
				
				// Replace with the new value
				value=open + "," + view + "," + edit + ";" + command;
				assoc->replace(key.text(),value.text());
			}
		}
	}

    // Image editor has changed
	if(oldimgeditor != imgeditor->getText())
	{
        // Update the imgeditor string
		FXString newimgeditor=imgeditor->getText().text();
		getApp()->reg().writeStringEntry("PROGS","imgeditor",newimgeditor.text());
		
		// Update each filetype where the old imgeditor was used
		FXStringDict *strdict = getApp()->reg().find("FILETYPES");
		FileDict *assoc=new FileDict(getApp());

		FXint i;
		FXString key, value, newvalue;
		FXString strtmp, open, view, edit, command;
		for (i=strdict->first(); i<strdict->size(); i=strdict->next(i))
		{
			// Read key and value of each filetype
			key=strdict->key(i);
			value=strdict->data(i);
			
			// Replace the old imgeditor string with the new one
			if (value.contains(oldimgeditor))
			{
				// Obtain the open, view, edit and command strings
				strtmp=value.before(';',1);
				command=value.after(';',1);
				open=strtmp.section(',',0);
				view=strtmp.section(',',1);
				edit=strtmp.section(',',2);
				
				// Replace only the open and edit strings, if needed
				if (open==oldimgeditor)
					open=newimgeditor;
				if (edit==oldimgeditor)
					edit=newimgeditor;
				
				// Replace with the new value
				value=open + "," + view + "," + edit + ";" + command;
				assoc->replace(key.text(),value.text());
			}
		}
	}

    // Image viewer has changed
	if(oldimgviewer != imgviewer->getText())
	{
        // Update the imgviewer string
		FXString newimgviewer=imgviewer->getText().text();
		getApp()->reg().writeStringEntry("PROGS","imgviewer",newimgviewer.text());
		
		// Update each filetype where the old imgviewer was used
		FXStringDict *strdict = getApp()->reg().find("FILETYPES");
		FileDict *assoc=new FileDict(getApp());

		FXint i;
		FXString key, value, newvalue;
		FXString strtmp, open, view, edit, command;
		for (i=strdict->first(); i<strdict->size(); i=strdict->next(i))
		{
			// Read key and value of each filetype
			key=strdict->key(i);
			value=strdict->data(i);
			
			// Replace the old imgviewer string with the new one
			if (value.contains(oldimgviewer))
			{
				// Obtain the open, view, edit and command strings
				strtmp=value.before(';',1);
				command=value.after(';',1);
				open=strtmp.section(',',0);
				view=strtmp.section(',',1);
				edit=strtmp.section(',',2);
				
				// Replace only the view string, if needed
				if (view==oldimgviewer)
					view=newimgviewer;
				
				// Replace with the new value
				value=open + "," + view + "," + edit + ";" + command;
				assoc->replace(key.text(),value.text());
			}
		}
	}

    // Archiver has changed
	if(oldarchiver != archiver->getText())
	{
        // Update the archiver string
		FXString newarchiver=archiver->getText().text();
		getApp()->reg().writeStringEntry("PROGS","archiver",newarchiver.text());
		
		// Update each filetype where the old archiver was used
		FXStringDict *strdict = getApp()->reg().find("FILETYPES");
		FileDict *assoc=new FileDict(getApp());

		FXint i;
		FXString key, value, newvalue;
		FXString strtmp, open, view, edit, command;
		for (i=strdict->first(); i<strdict->size(); i=strdict->next(i))
		{
			// Read key and value of each filetype
			key=strdict->key(i);
			value=strdict->data(i);
			
			// Replace the old archiver string with the new one
			if (value.contains(oldarchiver))
			{
				// Obtain the open, view, edit and command strings
				strtmp=value.before(';',1);
				command=value.after(';',1);
				open=strtmp.section(',',0);
				view=strtmp.section(',',1);
				edit=strtmp.section(',',2);
				
				// Replace the open, view and edit strings, if needed
				if (open==oldarchiver)
					open=newarchiver;
				if (view==oldarchiver)
					view=newarchiver;
				if (edit==oldarchiver)
					edit=newarchiver;
				
				// Replace with the new value
				value=open + "," + view + "," + edit + ";" + command;
				assoc->replace(key.text(),value.text());
			}
		}
	}

	// Terminal has changed
	if(oldxterm != xterm->getText())
        getApp()->reg().writeStringEntry("PROGS","xterm",xterm->getText().text());

	getApp()->reg().writeUnsignedEntry("OPTIONS","auto_save_layout",autosave->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","use_trash_can",trashcan->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","use_trash_bypass",trashbypass->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","ask_before_copy",ask->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","single_click_diropen",diropen->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","single_click_fileopen",fileopen->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","confirm_delete",del->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","confirm_delete_emptydir",del_emptydir->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","confirm_overwrite",overwrite->getCheck());
	getApp()->reg().writeUnsignedEntry("OPTIONS","confirm_quit",quit->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","confirm_drag_and_drop",dnd->getCheck());
    getApp()->reg().writeUnsignedEntry("OPTIONS","root_warn",root_warning->getCheck());
#if defined(linux)
    getApp()->reg().writeUnsignedEntry("OPTIONS","mount_warn",mount->getCheck());
	getApp()->reg().writeUnsignedEntry("OPTIONS","mount_messages",show_mount->getCheck());
#endif
	
	// Update some global options
	single_click_diropen=diropen->getCheck();
	single_click_fileopen=fileopen->getCheck();
	
	if (single_click_diropen & single_click_fileopen)
	{
		((XFileExplorer*) mainWindow)->lpanel->list->setDefaultCursor(getApp()->getDefaultCursor(DEF_HAND_CURSOR));
		((XFileExplorer*) mainWindow)->rpanel->list->setDefaultCursor(getApp()->getDefaultCursor(DEF_HAND_CURSOR));
		((XFileExplorer*) mainWindow)->dirpanel->list->setDefaultCursor(getApp()->getDefaultCursor(DEF_HAND_CURSOR));
	}
	else
	{
		((XFileExplorer*) mainWindow)->lpanel->list->setDefaultCursor(getApp()->getDefaultCursor(DEF_ARROW_CURSOR));
		((XFileExplorer*) mainWindow)->rpanel->list->setDefaultCursor(getApp()->getDefaultCursor(DEF_ARROW_CURSOR));
		((XFileExplorer*) mainWindow)->dirpanel->list->setDefaultCursor(getApp()->getDefaultCursor(DEF_ARROW_CURSOR));
	}
   
	// Theme has changed
	if(currTheme != Themes[0])
    {
		getApp()->reg().writeColorEntry("SETTINGS","basecolor",currTheme.color[0]);
        getApp()->reg().writeColorEntry("SETTINGS","bordercolor",currTheme.color[1]);
        getApp()->reg().writeColorEntry("SETTINGS","backcolor",currTheme.color[2]);
        getApp()->reg().writeColorEntry("SETTINGS","forecolor",currTheme.color[3]);
        getApp()->reg().writeColorEntry("SETTINGS","selbackcolor",currTheme.color[4]);
        getApp()->reg().writeColorEntry("SETTINGS","selforecolor",currTheme.color[5]);
		getApp()->reg().writeColorEntry("SETTINGS","listbackcolor",currTheme.color[6]);
		getApp()->reg().writeColorEntry("SETTINGS","listforecolor",currTheme.color[7]);
		getApp()->reg().writeColorEntry("SETTINGS","highlightcolor",currTheme.color[8]);

		getApp()->reg().write();
        restart=TRUE;
    }
	
	// Restart application if necessary
	if (restart)
	{
		if(BOX_CLICKED_CANCEL!=MessageBox::question(this,BOX_OK_CANCEL,_("Restart"),_("Theme will be changed after restart.\nRestart X File Explorer now?")))
			mainWindow->handle(this,FXSEL(SEL_COMMAND,XFileExplorer::ID_RESTART),NULL);
	}
	
	// Finally, update the registry
	getApp()->reg().write();
	
    DialogBox::onCmdAccept(o,s,p);
    return 1;
}


long PreferencesBox::onCmdCancel(FXObject* o,FXSelector s,void* p)
{
	// Reset preferences to their previous values
	
	// First tab - Options
	trashcan->setCheck(trashcan_prev);
	trashbypass->setCheck(trashbypass_prev);
	autosave->setCheck(autosave_prev);
	diropen->setCheck(diropen_prev);
	fileopen->setCheck(fileopen_prev);
	getApp()->setWheelLines(value_prev);	
	use_sudo=use_sudo_prev;
	getApp()->reg().writeUnsignedEntry("OPTIONS","use_sudo",use_sudo);
	
	// Second tab - Dialogs
	ask->setCheck(ask_prev);
	dnd->setCheck(dnd_prev);
	del->setCheck(del_prev);
	del_emptydir->setCheck(del_emptydir_prev);
	overwrite->setCheck(overwrite_prev);
	quit->setCheck(quit_prev);
#if defined(linux)
	mount->setCheck(mount_prev);
	show_mount->setCheck(show_mount_prev);
#endif
	root_warning->setCheck(root_warning_prev);
	
	// Third tab - Programs
	txteditor->setText(oldtxteditor);	
	txtviewer->setText(oldtxtviewer);	
	imgeditor->setText(oldimgeditor);	
	imgviewer->setText(oldimgviewer);	
	archiver->setText(oldarchiver);	
	xterm->setText(oldxterm);

	// Fourth tab - Visual
    themesList->setCurrentItem(themelist_prev);
	currTheme=currTheme_prev;
    iconpath->setText(oldiconpath);

	// Fifth tab - Fonts
	normalfont->setText(oldnormalfont);
	textfont->setText(oldtextfont);

	// Finally, update the registry (really necessary?)
	getApp()->reg().write();
	
    DialogBox::onCmdCancel(o,s,p);
    return 1;
}


// Execute dialog box modally
FXuint PreferencesBox::execute(FXuint placement)
{
	// Save current preferences to restore them if cancel is pressed
	
	// First tab - Options
	trashcan_prev=trashcan->getCheck();
	trashbypass_prev=trashbypass->getCheck();
	autosave_prev=autosave->getCheck();
	diropen_prev=diropen->getCheck();
	fileopen_prev=fileopen->getCheck();
	value_prev=getApp()->getWheelLines();
	use_sudo_prev=use_sudo;
	
	// Second tab - Dialogs
	ask_prev=ask->getCheck();
	dnd_prev=dnd->getCheck();
	del_prev=del->getCheck();
	del_emptydir_prev=del_emptydir->getCheck();
	overwrite_prev=overwrite->getCheck();
	quit_prev=quit->getCheck();
#if defined(linux)
	mount_prev=mount->getCheck();
	show_mount_prev=show_mount_prev;
#endif
	root_warning_prev=root_warning->getCheck();

    // Third tab - Programs
	oldtxteditor=txteditor->getText();
	oldtxtviewer=txtviewer->getText();
	oldimgeditor=imgeditor->getText();
	oldimgviewer=imgviewer->getText();
	oldarchiver=archiver->getText();
	oldxterm=xterm->getText();
	
	// Fourth tab - Visual
	themelist_prev=themesList->getCurrentItem();
    currTheme_prev = currTheme;
    oldiconpath=iconpath->getText();
	
	// Fifth tab - Fonts
	oldnormalfont=normalfont->getText();
	oldtextfont=textfont->getText();

	create();
    show(placement);
	getApp()->refresh();
    return getApp()->runModalFor(this);
}


// Update the bypass trash can option item
long PreferencesBox::onUpdTrashBypass(FXObject* o,FXSelector,void*)
{
	if (trashcan->getCheck())	
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
	else
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);
    return 1;
}


// Update the confirm delete empty directories option item
long PreferencesBox::onUpdConfirmDelEmptyDir(FXObject* o,FXSelector,void*)
{
	if (del->getCheck())	
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
	else
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);
    return 1;
}


// Set root mode
long PreferencesBox::onCmdSuMode(FXObject*,FXSelector sel,void*)
{
	if (FXSELID(sel)==ID_SU_CMD)
		use_sudo=FALSE;
		
	else if (FXSELID(sel)==ID_SUDO_CMD)
		use_sudo=TRUE;

	getApp()->reg().writeUnsignedEntry("OPTIONS","use_sudo",use_sudo);
	getApp()->reg().write();

	return 1;
}


// Update root mode radio button
long PreferencesBox::onUpdSuMode(FXObject* sender,FXSelector sel,void*)
{
	FXSelector updatemessage=FXSEL(SEL_COMMAND,ID_UNCHECK);
	
	if (FXSELID(sel)==ID_SU_CMD)
	{
		if (use_sudo)
			updatemessage=FXSEL(SEL_COMMAND,ID_UNCHECK);
		else
			updatemessage=FXSEL(SEL_COMMAND,ID_CHECK);
	}
	else if (FXSELID(sel)==ID_SUDO_CMD)
	{
		if (use_sudo)
			updatemessage=FXSEL(SEL_COMMAND,ID_CHECK);
		else
			updatemessage=FXSEL(SEL_COMMAND,ID_UNCHECK);

	}		
	sender->handle(this,updatemessage,NULL);
	return 1;
}

// Set scroll wheel lines (Mathew Robertson <mathew@optushome.com.au>)
long PreferencesBox::onCmdWheelAdjust(FXObject* sender,FXSelector,void*)
{
    FXuint value;
    sender->handle(this,FXSEL(SEL_COMMAND,ID_GETINTVALUE),(void*)&value);
    getApp()->setWheelLines(value);
	getApp()->reg().write();
    return 1;
}


// Update the wheel lines button
long PreferencesBox::onUpdWheelAdjust(FXObject* sender,FXSelector,void*)
{
    FXuint value=getApp()->getWheelLines();
	sender->handle(this,FXSEL(SEL_COMMAND,ID_SETINTVALUE),(void*)&value);
    return 1;
}


// Update single click file open button
long PreferencesBox::onUpdSingleClickFileopen(FXObject* o,FXSelector,void*)
{
	if (diropen->getCheck())	
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
	else
		o->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);
    return 1;
}


