#include "config.h"
#include "i18n.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <string.h>

#include <fox-1.4/fx.h>
#include <fox-1.4/FXPNGIcon.h>

#include "XFileExplorer.h"
#include "FilePanel.h"
#include "File.h"
#include "icons.h"

// Global variables
FXMainWindow *mainWindow;
FXString startdir="";
char **args;
FXbool iconic=FALSE;
FXbool maximized=FALSE;

// Usage message
#define USAGE_MSG	_("\
Usage: xfe [options] [startdir] \n\
\n\
    [options] can be any of the following:\n\
\n\
        -h, --help         Print (this) help screen and exit.\n\
        -v, --version      Print version information and exit.\n\
        -i, --iconic       Start iconified.\n\
        -m, --maximized    Start maximized.\n\
\n\
    [startdir] is the path to the initial directory you want to\n\
    open on start up.\n\
\n")


int main(int argc,char *argv[])
{
    char *title   = "Xfe";
	char *appname = "Xfe";
	char *vdrname = "XFileExplorer";
	int i;

#ifdef HAVE_SETLOCALE
  	// Set locale via LC_ALL.
  	setlocale (LC_ALL, "");
#endif

#if ENABLE_NLS
  	// Set the text message domain.
  	bindtextdomain (PACKAGE, LOCALEDIR);
  	textdomain (PACKAGE);
#endif

	// Parse basic arguments
	for(i = 1; i < argc; ++i)
	{
    	if(compare(argv[i],"-v")==0 || compare(argv[i],"--version")==0)
		{
			fprintf(stdout,"%s version %s\n",PACKAGE,VERSION);
			exit(0);
		}
    	else if(compare(argv[i],"-h")==0 || compare(argv[i],"--help")==0)
		{
			fprintf(stdout,USAGE_MSG);
			exit(0);
		}
    	else if(compare(argv[i],"-i")==0 || compare(argv[i],"--iconic")==0)
		{
			iconic=TRUE;
		}
		else if(compare(argv[i],"-m")==0 || compare(argv[i],"--maximized")==0)
		{
			maximized=TRUE;
		}
		else
	    {
			// Start directory, if any
			startdir=argv[i];
	    }
	}

    // Global variable (used to properly restart Xfe)
	args = argv;

	// Application creation
    FXApp* application=new FXApp(appname,vdrname);
    application->init(argc,argv);

	FXString fontspec;
	fontspec=application->reg().readStringEntry("SETTINGS","font","Helvetica,100,normal,regular");
	if(!fontspec.empty())
	{
    	FXFont* normalFont=new FXFont(application,fontspec);
        application->setNormalFont(normalFont);
    }
 
    if (getuid()==0)
        title="Xfe (root)";

	// Icons
    FXIcon *miniicon=new FXPNGIcon(application,miniFileManager);
    FXIcon *bigicon=new FXPNGIcon(application,FileManager);

	// If given, start in indicated directory
	if(startdir!="")
		startdir=::filePath(startdir);

   	// Create and run application
	mainWindow=new XFileExplorer(application,title,bigicon,miniicon);

	// Also catch interrupt so we can gracefully terminate
	application->addSignal(SIGINT,mainWindow,XFileExplorer::ID_QUIT);

	application->create();
   	application->run();
}
