/* main-panel-plugin.c generated by valac, the Vala compiler
 * generated from main-panel-plugin.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (C) 2009  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libxfce4panel/libxfce4panel.h>
#include <libxfce4util/libxfce4util.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <libxfcegui4/libxfcegui4.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <popup.h>
#include <gdk/gdk.h>


#define TYPE_NOTES_PLUGIN (notes_plugin_get_type ())
#define NOTES_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTES_PLUGIN, NotesPlugin))
#define NOTES_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTES_PLUGIN, NotesPluginClass))
#define IS_NOTES_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTES_PLUGIN))
#define IS_NOTES_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTES_PLUGIN))
#define NOTES_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTES_PLUGIN, NotesPluginClass))

typedef struct _NotesPlugin NotesPlugin;
typedef struct _NotesPluginClass NotesPluginClass;
typedef struct _NotesPluginPrivate NotesPluginPrivate;

#define XNP_TYPE_APPLICATION (xnp_application_get_type ())
#define XNP_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_APPLICATION, XnpApplication))
#define XNP_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_APPLICATION, XnpApplicationClass))
#define XNP_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_APPLICATION))
#define XNP_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_APPLICATION))
#define XNP_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_APPLICATION, XnpApplicationClass))

typedef struct _XnpApplication XnpApplication;
typedef struct _XnpApplicationClass XnpApplicationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _NotesPlugin {
	GObject parent_instance;
	NotesPluginPrivate * priv;
};

struct _NotesPluginClass {
	GObjectClass parent_class;
};

struct _NotesPluginPrivate {
	GtkInvisible* invisible;
	GtkButton* button;
	GtkImage* image;
	XfcePanelPlugin* panel_plugin;
	XnpApplication* application;
};


static gpointer notes_plugin_parent_class = NULL;
extern NotesPlugin* plugin;
NotesPlugin* plugin = NULL;

GType notes_plugin_get_type (void);
GType xnp_application_get_type (void);
#define NOTES_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTES_PLUGIN, NotesPluginPrivate))
enum  {
	NOTES_PLUGIN_DUMMY_PROPERTY
};
XnpApplication* xnp_application_new (const char* config_file);
XnpApplication* xnp_application_construct (GType object_type, const char* config_file);
void xnp_application_show_hide_notes (XnpApplication* self);
static void _lambda27_ (NotesPlugin* self);
static void __lambda27__gtk_button_clicked (GtkButton* _sender, gpointer self);
GtkMenu* xnp_application_context_menu (XnpApplication* self);
static gboolean notes_plugin_set_x_selection (NotesPlugin* self);
static gboolean _lambda29_ (XfcePanelPlugin* p, gint size, NotesPlugin* self);
static gboolean __lambda29__xfce_panel_plugin_size_changed (XfcePanelPlugin* _sender, gint size, gpointer self);
void xnp_application_save_windows_configuration (XnpApplication* self);
static void _lambda30_ (NotesPlugin* self);
static void __lambda30__xfce_panel_plugin_save (XfcePanelPlugin* _sender, gpointer self);
void xnp_application_save_notes (XnpApplication* self);
static void _lambda31_ (NotesPlugin* self);
static void __lambda31__xfce_panel_plugin_free_data (XfcePanelPlugin* _sender, gpointer self);
void xnp_application_open_settings_dialog (XnpApplication* self);
static void _lambda32_ (NotesPlugin* self);
static void __lambda32__xfce_panel_plugin_configure_plugin (XfcePanelPlugin* _sender, gpointer self);
void xnp_application_open_about_dialog (XnpApplication* self);
static void _lambda33_ (NotesPlugin* self);
static void __lambda33__xfce_panel_plugin_about (XfcePanelPlugin* _sender, gpointer self);
NotesPlugin* notes_plugin_new (XfcePanelPlugin* panel_plugin);
NotesPlugin* notes_plugin_construct (GType object_type, XfcePanelPlugin* panel_plugin);
static gboolean _lambda28_ (GtkInvisible* w, GdkEventClient* event, NotesPlugin* self);
static gboolean __lambda28__gtk_widget_client_event (GtkInvisible* _sender, GdkEventClient* event, gpointer self);
static void notes_plugin_finalize (GObject* obj);
void panel_plugin_register (XfcePanelPlugin* panel_plugin);
static void _lambda0_ (void);
static void __lambda0__gcallback (void);
static void _panel_plugin_register_xfce_panel_plugin_func (XfcePanelPlugin* panel_plugin);
gint _main (char** args, int args_length1);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _lambda27_ (NotesPlugin* self) {
	xnp_application_show_hide_notes (self->priv->application);
}


static void __lambda27__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda27_ (self);
}


static gboolean _lambda29_ (XfcePanelPlugin* p, gint size, NotesPlugin* self) {
	gboolean result;
	gint _tmp0_ = 0;
	GdkPixbuf* pixbuf;
	g_return_val_if_fail (p != NULL, FALSE);
	gtk_widget_set_size_request ((GtkWidget*) self->priv->button, size, size);
	if (gtk_widget_get_style ((GtkWidget*) self->priv->button)->xthickness > gtk_widget_get_style ((GtkWidget*) self->priv->button)->ythickness) {
		_tmp0_ = gtk_widget_get_style ((GtkWidget*) self->priv->button)->xthickness;
	} else {
		_tmp0_ = gtk_widget_get_style ((GtkWidget*) self->priv->button)->ythickness;
	}
	size = size - (2 + (2 * _tmp0_));
	pixbuf = xfce_themed_icon_load ("xfce4-notes-plugin", size);
	if (pixbuf == NULL) {
		GdkPixbuf* _tmp1_;
		pixbuf = (_tmp1_ = xfce_themed_icon_load (GTK_STOCK_EDIT, size), _g_object_unref0 (pixbuf), _tmp1_);
	}
	gtk_image_set_from_pixbuf (self->priv->image, pixbuf);
	result = TRUE;
	_g_object_unref0 (pixbuf);
	return result;
}


static gboolean __lambda29__xfce_panel_plugin_size_changed (XfcePanelPlugin* _sender, gint size, gpointer self) {
	return _lambda29_ (_sender, size, self);
}


static void _lambda30_ (NotesPlugin* self) {
	xnp_application_save_windows_configuration (self->priv->application);
}


static void __lambda30__xfce_panel_plugin_save (XfcePanelPlugin* _sender, gpointer self) {
	_lambda30_ (self);
}


static void _lambda31_ (NotesPlugin* self) {
	xnp_application_save_windows_configuration (self->priv->application);
	xnp_application_save_notes (self->priv->application);
}


static void __lambda31__xfce_panel_plugin_free_data (XfcePanelPlugin* _sender, gpointer self) {
	_lambda31_ (self);
}


static void _lambda32_ (NotesPlugin* self) {
	xnp_application_open_settings_dialog (self->priv->application);
}


static void __lambda32__xfce_panel_plugin_configure_plugin (XfcePanelPlugin* _sender, gpointer self) {
	_lambda32_ (self);
}


static void _lambda33_ (NotesPlugin* self) {
	xnp_application_open_about_dialog (self->priv->application);
}


static void __lambda33__xfce_panel_plugin_about (XfcePanelPlugin* _sender, gpointer self) {
	_lambda33_ (self);
}


NotesPlugin* notes_plugin_construct (GType object_type, XfcePanelPlugin* panel_plugin) {
	NotesPlugin * self;
	XnpApplication* _tmp1_;
	char* _tmp0_;
	GtkButton* _tmp2_;
	GtkImage* _tmp3_;
	GtkMenuItem* mi;
	GtkMenu* menu;
	g_return_val_if_fail (panel_plugin != NULL, NULL);
	self = (NotesPlugin*) g_object_new (object_type, NULL);
	self->priv->panel_plugin = panel_plugin;
	xfce_textdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR, NULL);
	self->priv->application = (_tmp1_ = xnp_application_new (_tmp0_ = xfce_panel_plugin_save_location (panel_plugin, TRUE)), _g_object_unref0 (self->priv->application), _tmp1_);
	_g_free0 (_tmp0_);
	self->priv->button = (_tmp2_ = xfce_create_panel_button (), _g_object_unref0 (self->priv->button), _tmp2_);
	self->priv->image = (_tmp3_ = g_object_ref_sink ((GtkImage*) gtk_image_new ()), _g_object_unref0 (self->priv->image), _tmp3_);
	gtk_container_add ((GtkContainer*) self->priv->button, (GtkWidget*) self->priv->image);
	g_signal_connect_object (self->priv->button, "clicked", (GCallback) __lambda27__gtk_button_clicked, self, 0);
	gtk_widget_show_all ((GtkWidget*) self->priv->button);
	gtk_container_add ((GtkContainer*) panel_plugin, (GtkWidget*) self->priv->button);
	xfce_panel_plugin_add_action_widget (panel_plugin, (GtkWidget*) self->priv->button);
	gtk_widget_set_tooltip_text ((GtkWidget*) panel_plugin, _ ("Notes"));
	xfce_panel_plugin_menu_show_configure (panel_plugin);
	xfce_panel_plugin_menu_show_about (panel_plugin);
	mi = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Go")));
	menu = xnp_application_context_menu (self->priv->application);
	gtk_menu_item_set_submenu (mi, (GtkWidget*) menu);
	gtk_widget_show_all ((GtkWidget*) mi);
	xfce_panel_plugin_menu_insert_item (panel_plugin, mi);
	notes_plugin_set_x_selection (self);
	g_signal_connect_object (panel_plugin, "size-changed", (GCallback) __lambda29__xfce_panel_plugin_size_changed, self, 0);
	g_signal_connect_object (panel_plugin, "save", (GCallback) __lambda30__xfce_panel_plugin_save, self, 0);
	g_signal_connect_object (panel_plugin, "free-data", (GCallback) __lambda31__xfce_panel_plugin_free_data, self, 0);
	g_signal_connect_object (panel_plugin, "configure-plugin", (GCallback) __lambda32__xfce_panel_plugin_configure_plugin, self, 0);
	g_signal_connect_object (panel_plugin, "about", (GCallback) __lambda33__xfce_panel_plugin_about, self, 0);
	_g_object_unref0 (mi);
	_g_object_unref0 (menu);
	return self;
}


NotesPlugin* notes_plugin_new (XfcePanelPlugin* panel_plugin) {
	return notes_plugin_construct (TYPE_NOTES_PLUGIN, panel_plugin);
}


static gboolean _lambda28_ (GtkInvisible* w, GdkEventClient* event, NotesPlugin* self) {
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	if (_vala_strcmp0 (popup_get_message_from_event (event), "SHOW_HIDE") == 0) {
		xnp_application_show_hide_notes (self->priv->application);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean __lambda28__gtk_widget_client_event (GtkInvisible* _sender, GdkEventClient* event, gpointer self) {
	return _lambda28_ (_sender, event, self);
}


static gboolean notes_plugin_set_x_selection (NotesPlugin* self) {
	gboolean result;
	GtkInvisible* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->invisible = (_tmp0_ = g_object_ref_sink ((GtkInvisible*) gtk_invisible_new ()), _g_object_unref0 (self->priv->invisible), _tmp0_);
	if (!popup_set_x_selection ((GtkWidget*) self->priv->invisible)) {
		result = FALSE;
		return result;
	}
	g_signal_connect_object ((GtkWidget*) self->priv->invisible, "client-event", (GCallback) __lambda28__gtk_widget_client_event, self, 0);
	result = TRUE;
	return result;
}


static void notes_plugin_class_init (NotesPluginClass * klass) {
	notes_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NotesPluginPrivate));
	G_OBJECT_CLASS (klass)->finalize = notes_plugin_finalize;
}


static void notes_plugin_instance_init (NotesPlugin * self) {
	self->priv = NOTES_PLUGIN_GET_PRIVATE (self);
}


static void notes_plugin_finalize (GObject* obj) {
	NotesPlugin * self;
	self = NOTES_PLUGIN (obj);
	_g_object_unref0 (self->priv->invisible);
	_g_object_unref0 (self->priv->button);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->application);
	G_OBJECT_CLASS (notes_plugin_parent_class)->finalize (obj);
}


GType notes_plugin_get_type (void) {
	static GType notes_plugin_type_id = 0;
	if (notes_plugin_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (NotesPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notes_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotesPlugin), 0, (GInstanceInitFunc) notes_plugin_instance_init, NULL };
		notes_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "NotesPlugin", &g_define_type_info, 0);
	}
	return notes_plugin_type_id;
}


void panel_plugin_register (XfcePanelPlugin* panel_plugin) {
	NotesPlugin* _tmp0_;
	g_return_if_fail (panel_plugin != NULL);
	plugin = (_tmp0_ = notes_plugin_new (panel_plugin), _g_object_unref0 (plugin), _tmp0_);
}


static void _lambda0_ (void) {
	gtk_main_quit ();
}


static void __lambda0__gcallback (void) {
	_lambda0_ ();
}


static gint xfce_PanelPluginRegisterExternalFull (int* argv_length1, char*** argv, XfcePanelPluginFunc _register_, XfcePanelPluginPreInit preinit, XfcePanelPluginCheck check) {
	gint result;
	XfceExternalPanelPlugin* panel_plugin;
	if (preinit != NULL) {
		if (!preinit (*argv_length1, *argv)) {
			result = 3;
			return result;
		}
	}
	gtk_init (argv_length1, argv);
	if (check != NULL) {
		if (!check (gdk_screen_get_default ())) {
			result = 2;
			return result;
		}
	}
	panel_plugin = g_object_ref_sink (xfce_external_panel_plugin_new (*argv_length1, *argv, _register_));
	if (panel_plugin == NULL) {
		result = 1;
		_g_object_unref0 (panel_plugin);
		return result;
	}
	g_signal_connect_after (panel_plugin, "destroy", __lambda0__gcallback, NULL);
	gtk_widget_show ((GtkWidget*) panel_plugin);
	gtk_main ();
	result = 0;
	_g_object_unref0 (panel_plugin);
	return result;
}


static gint xfce_PanelPluginRegisterExternal (int* argv_length1, char*** argv, XfcePanelPluginFunc _register_) {
	gint result;
	result = xfce_PanelPluginRegisterExternalFull (argv_length1, argv, _register_, NULL, NULL);
	return result;
}


static void _panel_plugin_register_xfce_panel_plugin_func (XfcePanelPlugin* panel_plugin) {
	panel_plugin_register (panel_plugin);
}


gint _main (char** args, int args_length1) {
	gint result;
	result = xfce_PanelPluginRegisterExternal (&args_length1, &args, _panel_plugin_register_xfce_panel_plugin_func);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _main (argv, argc);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




