#include <xen/elfnote.h>
#include <xen/elfstructs.h>
#include <xen/grant_table.h>

#include "list.h"

extern int libxc_trace;
extern int libxc_fixme;
int xenner_evtchnd_domid(int evtchnd, int domid);

struct xennerdom {
    int                domid;
    int                refcount;
    uid_t              uid;
    gid_t              gid;

    char               filename[256];
    int                fd;
    void               *vmcore;
    off_t              vmcore_size;
    Elf64_Ehdr         *vm_ehdr;
    Elf64_Phdr         *vm_phdrs;
    Elf64_Shdr         *vm_shdrs;
    char               *vm_shstrtab;

    int                parsed;
    struct grant_entry *grant_table;
    int                grant_entries;
    void               *shared_info;
    struct xenner_info *vminfo;

    struct list_head   next;
};

struct xennerdom *xenner_get_dom(int domid);
void xenner_put_dom(struct xennerdom *dom);
