/* undo -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64
 * needed for the open*() syscall wrappers below. */
#undef _LARGEFILE_SOURCE
#undef _FILE_OFFSET_BITS

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include <dlfcn.h>
#include <stdarg.h>
#include <assert.h>
#include <dirent.h>
#include <inttypes.h>
#include <fcntl.h>

#include <sys/stat.h>
#include <sys/mman.h>
#include <sys/types.h>

#include <xenctrl.h>

#include "xennerctrl.h"

/* version check using a define which is new in xen 3.2.0 */
#ifdef FLASK_LOAD
# define HAVE_XEN_320 1
#endif

/* --------------------------------------------------------------------- */

static evtchn_port_t xsd_port;
static int           xsd_fd;
static void          *xsd_map;

/* ------------------------------------------------------------------ */

int xc_readconsolering(int xc_handle,
                       char **pbuffer,
                       unsigned int *pnr_chars,
                       int clear
#ifdef HAVE_XEN_320
		       , int incremental, uint32_t *pindex
#endif
    )
{
    /* we have no hypervisor console, thus no data */
    *pnr_chars = 0;
    return 0;
}

/* ------------------------------------------------------------------ */

static int fake_xsd_port(void)
{
    char file[32] = "/tmp/xsd_port.XXXXXXXX";
    char buf[16];
    int fd;

    xsd_port = 69;
    if (libxc_trace)
	fprintf(stderr, "libxc: %s, port %d\n", __FUNCTION__, xsd_port);
    snprintf(buf, sizeof(buf), "%d\n", xsd_port);
    fd = mkstemp(file);
    write(fd, buf, strlen(buf));
    lseek(fd, 0, SEEK_SET);
    unlink(file);
    return fd;
}

static int fake_xsd_kva(void)
{
    char file[32] = "/tmp/xsd_kva.XXXXXXXX";

    if (libxc_trace)
	fprintf(stderr, "libxc: %s\n", __FUNCTION__);
    xsd_fd = mkstemp(file);
    lseek(xsd_fd, PAGE_SIZE-1, SEEK_SET);
    write(xsd_fd, "\0", 1);
    lseek(xsd_fd, 0, SEEK_SET);
    xsd_map = mmap(NULL, PAGE_SIZE, PROT_READ | PROT_WRITE,
		   MAP_SHARED, xsd_fd, 0);
    unlink(file);
    return xsd_fd;
}

/* open syscall wrappers, to fake /proc/xen files */
int open(const char *file, int flags, ...)
{
    static int (*real_open)(const char *file, int flags, ...);
    va_list args;
    mode_t mode;

    if (libxc_trace)
	fprintf(stderr, "libxc: %s\n", __FUNCTION__);

    if (!real_open)
	real_open = dlsym(RTLD_NEXT, "open");

    if (0 == strcmp(file, "/proc/xen/xsd_port"))
	return fake_xsd_port();
    if (0 == strcmp(file, "/proc/xen/xsd_kva"))
	return fake_xsd_kva();

    /* default: forward */
    if (libxc_trace)
	fprintf(stderr, "libxc: %s: %s\n", __FUNCTION__, file);

    va_start(args, flags);
    mode = va_arg(args, mode_t);
    va_end(args);
    return real_open(file, flags, mode);
}

int open64(const char *file, int flags, ...)
{
    static int (*real_open64)(const char *file, int flags, ...);
    va_list args;
    mode_t mode;

    if (libxc_trace)
	fprintf(stderr, "libxc: %s\n", __FUNCTION__);

    if (!real_open64)
	real_open64 = dlsym(RTLD_NEXT, "open64");

    if (0 == strcmp(file, "/proc/xen/xsd_port"))
	return fake_xsd_port();
    if (0 == strcmp(file, "/proc/xen/xsd_kva"))
	return fake_xsd_kva();

    /* default: forward */
    if (libxc_trace)
	fprintf(stderr, "libxc: %s: %s\n", __FUNCTION__, file);

    va_start(args, flags);
    mode = va_arg(args, mode_t);
    va_end(args);
    return real_open64(file, flags, mode);
}
