"""
Statically ports utilities from ubelt needed by xdoctest.
"""


def _autogen_xdoctest_utils():
    import ubelt as ub
    import liberator
    lib = liberator.Liberator()

    from ubelt import util_import
    lib.add_dynamic(util_import.split_modpath)
    lib.add_dynamic(util_import.modpath_to_modname)
    lib.add_dynamic(util_import.modname_to_modpath)
    lib.add_dynamic(util_import.import_module_from_name)
    lib.add_dynamic(util_import.import_module_from_path)
    lib.add_dynamic(util_import._pkgutil_modname_to_modpath)
    lib.add_dynamic(util_import._importlib_import_modpath)
    lib.add_dynamic(util_import.is_modname_importable)

    lib.expand(['ubelt'])
    text = lib.current_sourcecode()
    print(text)

    """
    pip install rope
    pip install parso
    """

    # target_fpath = ub.Path('~/code/xdoctest/src/xdoctest/utils/util_import.py').expand()
    target_fpath = ub.Path(xdoctest.utils.util_import.__file__)

    import parso
    import xdoctest
    new_module = parso.parse(text)
    old_module = parso.parse(target_fpath.read_text())
    new_names = [child.name.value for child in new_module.children if child.type in {'funcdef', 'classdef'}]
    old_names = [child.name.value for child in old_module.children if child.type in {'funcdef', 'classdef'}]

    print(set(old_names) - set(new_names))
    print(set(new_names) - set(old_names))

    prefix = ub.codeblock(
        '''
        # -*- coding: utf-8 -*-
        """
        This file was autogenerated based on code in ubelt
        """
        from __future__ import print_function, division, absolute_import, unicode_literals
        ''')

    target_fpath.write_text(prefix + '\n' + text + '\n')
