#!/usr/bin/python
# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
#
# Copyright (C) 2010 Bryce Harrington bryce@canonical.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
import os
import gtk
import subprocess

# For bug reporting about problems with xdiagnose
try:
    import LaunchpadIntegration
    launchpad_available = True
except:
    launchpad_available = False

from xdiagnose.helpers import get_builder

class XDiagnoseWindow(gtk.Window):
    __gtype_name__ = "XDiagnoseWindow"
    
    def __new__(cls):
        """Constructs a new instance of this class.
        
        Returns a fully instantiated XDiagnoseWindow object.
        """
        builder = get_builder('XDiagnoseWindow')
        new_object = builder.get_object("xdiagnose_window")
        new_object.finish_initializing(builder)
        return new_object

    def finish_initializing(self, builder):
        """Called while initializing this instance in __new__

        finish_initalizing should be called after parsing the UI definition
        and creating a XDiagnoseWindow object with it in order to finish
        initializing the start of the new XDiagnoseWindow instance.
        """
        # Get a reference to the builder and set up the signals.
        self.builder = builder
        self.builder.connect_signals(self)

        global launchpad_available
        if launchpad_available:
            # see https://wiki.ubuntu.com/UbuntuDevelopment/Internationalisation/Coding for more information
            # about LaunchpadIntegration
            helpmenu = self.builder.get_object('helpMenu')
            if helpmenu:
                LaunchpadIntegration.set_sourcepackagename('xdiagnose')
                LaunchpadIntegration.add_items(helpmenu, 0, False, True)
            else:
                launchpad_available = False

        ## Views
        views_treestore = self.builder.get_object('views-treestore')
        piter = views_treestore.append(None, ['Troubleshoot', 'Various options for troubleshooting issues'])
        views_treestore.append(piter, ['Resolution', 'Troubleshoot resolution issues'])
        views_treestore.append(piter, ['3D', 'Troubleshoot 3D issues'])

        views_treeview  = self.builder.get_object('views-treeview')
        views_treeview.expand_all()
        views_treeview.connect('button-press-event', self.on_view_selected)

        ## Actions ##
        actions_liststore = self.builder.get_object('actions-liststore')
        actions_liststore.append(['Force Standard Display Resolution', 'Sets all monitors to 1024x768'])
        actions_liststore.append(['Configure Rendering', 'Runs driconf to adjust mesa 3D settings'])

        actions_treeview  = self.builder.get_object('actions-treeview')
        actions_treeview.connect('button-press-event', self.on_action_button_press)
        actions_treeview.connect('button-release-event', self.on_action_button_release)
        actions_treeview.connect('row-activated', self.on_action_activated)

    def quit(self, widget, data=None):
        """Signal handler for closing the XDiagnoseWindow."""
        self.destroy()

    def on_destroy(self, widget, data=None):
        """Called when the XDiagnoseWindow is closed."""
        # Clean up code for saving application state should be added here.
        gtk.main_quit()

    def on_view_selected(self, widget, data=None):
        print "Hello selected view"

    def on_action_button_press(self, widget, data=None):
        pass

    def on_action_button_release(self, widget, data=None):
        pass

    def on_action_activated(self, widget, foo=None, data=None):
        if os.path.lexists('/usr/bin/driconf'):
            subprocess.call(['driconf'])
        else:
            # TODO: Offer to install it
            sys.stderr.write("Error:  driconf is not installed\n")
            sys.stderr.write("It can be installed by running:  sudo apt-get install driconf\n")

