/*
 
 *****************************************************************************
 * Author:                                                                   *
 * ------                                                                    *
 *  Anton Kokalj                                  Email: Tone.Kokalj@ijs.si  *
 *  Department of Physical and Organic Chemistry  Phone: x 386 1 477 3523    *
 *  Jozef Stefan Institute                          Fax: x 386 1 477 3811    *
 *  Jamova 39, SI-1000 Ljubljana                                             *
 *  SLOVENIA                                                                 *
 *                                                                           *
 * Source: $XCRYSDEN_TOPDIR/C/togl_ppm.c
 * ------                                                                    *
 * Copyright (c) 1996-2003 by Anton Kokalj                                   *
 *****************************************************************************

*/

/*
  Togl_DumpToPpmFile function is a variation on the theme of
  Togl_DumpToEpsFile functions from the togl.c:

  Togl - a Tk OpenGL widget
  Version 1.6
  Copyright (C) 1996-2002  Brian Paul and Ben Bederson
  See the .../otherLICENSES/Togl:LICENSE file for copyright details.
*/

static int generatePPM(const char *filename, int inColor, int interpDegree,
                       int antialias, unsigned int width, unsigned int height);

int Togl_DumpToPpmFile( const struct Togl *togl, const char *filename,
                        int inColor, int interpDegree, int antialias,
			void (*user_redraw)( const struct Togl *))
{
  int          using_mesa = 0;
#if 0
  Pixmap       ppm_pixmap;
  GLXPixmap    ppm_glxpixmap;
  XVisualInfo  *vi = togl->VisInfo;
  Window       win = Tk_WindowId( togl->TkWin);
#endif
  Display      *dpy = Tk_Display( togl->TkWin);
  int          retval;
  int          scrnum = Tk_ScreenNumber(togl->TkWin);
  unsigned int width = togl->Width, height = togl->Height;
  
#if defined(X11)
  if (strstr(glXQueryServerString( dpy, scrnum, GLX_VERSION ), "Mesa"))
    using_mesa = 1;
  else
#endif /* X11 */
    using_mesa = 0;
  /* I don't use Pixmap do drawn into, because the code should link
   * with Mesa libraries and OpenGL libraries, and the which library
   * we use at run time should not matter, but the name of the calls
   * differs one from another:
   * MesaGl: glXCreateGLXPixmapMESA( dpy, vi, ppm_pixmap, Tk_Colormap(togl->TkWin))
   * OpenGl: glXCreateGLXPixmap( dpy, vi, ppm_pixmap);
   *
   * instead of this I read direct from back buffer of the screeen.
   */
#if 0
  ppm_pixmap = XCreatePixmap( dpy, win, width, height, vi->depth);
  if ( using_mesa)
    ppm_glxpixmap = glXCreateGLXPixmapMESA( dpy, vi, ppm_pixmap, Tk_Colormap(togl->TkWin));
  else
    ppm_glxpixmap = glXCreateGLXPixmap( dpy, vi, ppm_pixmap);
  
  glXMakeCurrent( dpy, ppm_glxpixmap, togl->GlCtx);
  user_redraw();
#endif
  if ( !togl->RgbaFlag) {
    
#if defined(WIN32)
    /* Due to the lack of a unique inverse mapping from the frame buffer to
       the logical palette we need a translation map from the complete
       logical palette. */
    {
      int n, i;
      TkWinColormap *cmap = (TkWinColormap *)Tk_Colormap(togl->TkWin);
      LPPALETTEENTRY entry = malloc(togl->EpsMapSize * sizeof(PALETTEENTRY));
      n = GetPaletteEntries(cmap->palette, 0, togl->EpsMapSize, entry);
      for (i=0; i<n; i++) {
	togl->EpsRedMap[i]   = (GLfloat)(entry[i].peRed / 255.0);
	togl->EpsGreenMap[i] = (GLfloat)(entry[i].peGreen / 255.0);
	togl->EpsBlueMap[i]  = (GLfloat)(entry[i].peBlue / 255.0);
      }
      free(entry);
    }
#endif /* WIN32 */
    
    glPixelMapfv( GL_PIXEL_MAP_I_TO_R, togl->EpsMapSize, togl->EpsRedMap);
    glPixelMapfv( GL_PIXEL_MAP_I_TO_G, togl->EpsMapSize, togl->EpsGreenMap);
    glPixelMapfv( GL_PIXEL_MAP_I_TO_B, togl->EpsMapSize, togl->EpsBlueMap);
  }

  user_redraw(togl);
  glFlush(); 
  retval = generatePPM( filename, inColor, interpDegree, antialias, width, height);
#if 0
  glXMakeCurrent( dpy, win, togl->GlCtx );
  glXDestroyGLXPixmap( dpy, ppm_glxpixmap);
  XFreePixmap( dpy, ppm_pixmap);
#endif
  return retval;
}


#define COLOR_MIX(dst,s,ih,iw) \
do { \
dst[ih][iw] \
 = f16 * (s[ih-1][iw-1]+s[ih-1][iw+1]+s[ih+1][iw+1]+s[ih+1][iw-1]) + \
   f8  * (s[ih-1][iw]  +s[ih+1][iw]  +s[ih][iw-1]  +s[ih][iw+1]) + \
   f4  * s[ih][iw]; \
} while(0)

static int generatePPM(const char *filename, int inColor, int interpDegree,
                       int antialias, unsigned int width, unsigned int height)
{
  FILE          *fp;
  GLvoid        *pixels;
  unsigned char *curpix;  
  unsigned int  components, row, pos, size;
  int           num, i, ih, iw, w, h;
  unsigned char *charpix, bitpixel;
  
  pixels = grabPixels(inColor, width, height);
  if (pixels == NULL)
    return 1;

  /* minus (-) filename is a synonym for STDOUT */
  if ( filename[0] == '-' ) {
    fp = stdout;
  } else {
    fp = fopen(filename, "w");
  }
  if (fp == NULL) {
    return 2;
  }
  
  if (interpDegree == 1) {
    w = width;
    h = height;
  } else {
    w = interpDegree * width - 1;
    h = interpDegree * height - 1;
  }
  if ( inColor == 1 ) {
    components = 3;     /* Red, green, blue. */
    fprintf(fp, "P6\n#Creator::XCRSYDEN-0.x\n%d %d\n%d\n", w, h, 255);
  } else if ( inColor == 2 ) {
    components = 3;    /* RGBtoGRAY */
    fprintf(fp, "P5\n#Creator::XCRSYDEN-0.x\n%d %d\n%d\n", w, h, 255);
  } else {
    components = 1;     /* Luminance. */
    fprintf(fp, "P5\n#Creator::XCRSYDEN-0.x\n%d %d\n%d\n", w, h, 255);
  }
  
  row  = components * width;
  size = row * height;

  if ( interpDegree == 1 && antialias == 0 ) {
    
    /* NO Interpolation */

    if ( inColor == 0 || inColor == 1 ) {
      /* RGB and/or LUMINANCE */
      num = 0;
      for (ih = height-1; ih > -1; ih--) {
	pos    = ih * width * components; 
	curpix = (unsigned char *) pixels + pos;
	num   += fwrite((void *) curpix++, 1, (size_t) row, fp);
      }
      if (num != size) return 2;
    } else if ( inColor == 2 ) {
      /* RGB to GRAY */
      num = 0;
      for (ih = height-1; ih > -1; ih --) {
	pos     = ih * width * 3; 
	charpix = (unsigned char *) pixels + pos;
	for (iw = 0; iw < width; iw++) {
	  bitpixel = (unsigned char) (int)	    
	    (((float)charpix[0] + (float)charpix[1] +(float)charpix[2]) / 3.0) ;
	  charpix += 3; 
	  /*(((float)*charpix++ + (float)*charpix++ +(float) *charpix++) / 3.0) ;*/
	  num += fwrite((void *) &bitpixel, 1, (size_t) 1, fp);
	}
      }
      if (num*3 != size) return 2;
    }
  } else {
    
    /* Interpolation */
    
    int n[2], deg[2];      
    float **intred,   **red,   **ir;
    float **intgreen, **green, **ig;
    float **intblue,  **blue,  **ib;
    float f16 = 1./16., f8 = 1./8., f4 = 1./4.;
    /*float f16 = 1./12., f8 = 1./12., f4 = 1./3.;*/

    n[0]   = height;
    n[1]   = width;
    deg[0] = deg[1] = interpDegree;
    
    MALLOC_TENSOR2(float, red, n[0], n[1]);
    MALLOC_TENSOR2(float, green, n[0], n[1]);
    MALLOC_TENSOR2(float, blue, n[0], n[1]);
    MALLOC_TENSOR2(float, ir, n[0], n[1]);
    MALLOC_TENSOR2(float, ig, n[0], n[1]);
    MALLOC_TENSOR2(float, ib, n[0], n[1]);
    
    /* decompose RGB vector field pixels to R/G/B scalar fields */
    
    for (ih = height-1; ih > -1; ih--) {
      i      = height-1 - ih;
      pos    = ih * width * components; 
      charpix = (unsigned char *) pixels + pos;
      for (iw = 0; iw < width; iw++) {
	red[i][iw]   = *charpix++;
	green[i][iw] = *charpix++;
	blue[i][iw]  = *charpix++;
      }
    }

    /* pseudo-antialiasing */
    for (ih = 1; ih < height-1; ih++) {
      for (iw = 1; iw < width-1; iw++) {
	COLOR_MIX (ir, red,   ih, iw);
	COLOR_MIX (ig, green, ih, iw);
	COLOR_MIX (ib, blue,  ih, iw);
      }
    }
    
    intred   = cryRegPeriodInterpolator_f_LCASI2D(n, deg, ir);
    intgreen = cryRegPeriodInterpolator_f_LCASI2D(n, deg, ig);
    intblue  = cryRegPeriodInterpolator_f_LCASI2D(n, deg, ib);

    if ( deg[0]*deg[1] > 1 ) {
      n[0] *= deg[0];
      n[1] *= deg[1];
    } else {
      n[0]++;
      n[1]++;
    }
    num = 0;
    for (ih = 0; ih < n[0]-1; ih++) {
      for (iw = 0; iw < n[1]-1; iw++) {
	/*fprintf(stderr,"pixel (%d,%d):: value (%f,%f,%f)\n",
	  ih, iw, intred[ih][iw], intgreen[ih][iw], intblue[ih][iw]);*/
	bitpixel = (unsigned char) (int) intred[ih][iw];
	num += fwrite((void *) &bitpixel,   1, (size_t) 1, fp);
	bitpixel = (unsigned char) (int) intgreen[ih][iw];
	num += fwrite((void *) &bitpixel, 1, (size_t) 1, fp);
	bitpixel = (unsigned char) (int) intblue[ih][iw];
	num += fwrite((void *) &bitpixel,  1, (size_t) 1, fp);
      }
    }
    if ( num != 3*(n[0]-1)*(n[1]-1) ) return 2;
    FREE_TENSOR2 (red);
    FREE_TENSOR2 (green); 
    FREE_TENSOR2 (blue);
    FREE_TENSOR2 (ir);
    FREE_TENSOR2 (ig); 
    FREE_TENSOR2 (ib);
    FREE_TENSOR2 (intred);
    FREE_TENSOR2 (intgreen); 
    FREE_TENSOR2 (intblue);
  }
  
  /*num = fwrite((void *) pixels, 1, (size_t) size, fp);*/
  
  free(pixels);
  if ( fp != stdout ) fclose(fp);
  return 0;
}
