#ifndef SHANKLAND_H_
#define SHANKLAND_H_

#include <meschach/matrix2.h>
#include <fftw3.h>

extern const double two_pi;

#ifndef MIN
#define ABS(x)   ( (x)>0 ? (x) : -(x)  )
#define MAX(x,y) ( (x)>(y) ? (x) : (y) )
#define MIN(x,y) ( (x)<(y) ? (x) : (y) )
#endif

#define COMPLEX_SET(dst, re, im) \
  do {				 \
    dst[0] = re;		 \
    dst[1] = im;		 \
  } while(0)

#define COMPLEX_CONJ(dst, src)   \
  do {				 \
    dst[0] =  src[0];		 \
    dst[1] = -src[1];		 \
  } while(0)

#define COMPLEX_COPY(dst, src)   \
  do {				 \
    dst[0] = src[0];		 \
    dst[1] = src[1];		 \
  } while(0)

#define COMPLEX_SCALE(comp, scale) \
  do {				 \
    comp[0] *= scale;		 \
    comp[1] *= scale;		 \
  } while(0)

#define FT_MAX(n) ( n/2 )
#define FT_MIN(n) ( (1 - n%2) - n/2 )
#define FT_INDEX(n,N) ( n<0 ? N+n : n  )

/* fft3d.c */
extern float ***general_grid_fft_interpolator_tensor3f(int n[3], int degree[3], float ***src);
extern double *fft3d_interpolator(int n1, int n2, int n3, int n1new, int n2new, int n3new, double *func);
extern void fft3d_interpolate(int n1, int n2, int n3, int n1new, int n2new, int n3new, double *func, double *result);

/* fft_util.c */
extern void fft2d_enlarge_complex_r2c(size_t n1, size_t n2, fftw_complex *in, size_t n1new, size_t n2new, fftw_complex *out);
extern void fft3d_enlarge_complex_r2c(size_t n1, size_t n2, size_t n3, fftw_complex *in, size_t n1new, size_t n2new, size_t n3new, fftw_complex *out);

/* shank_util.c */
extern double one_func(double m2, double sigma);
extern double first_order(double m2, double sigma);
extern double first_sqrt_order(double m2, double sigma);
extern double second_order(double m2, double sigma);
extern double pickett(double m2, double sigma);
extern double gauss(double m2, double sigma);
extern double exp_abs(double m2, double sigma);
extern double estimate_sigma(double power, int m, double (*roughnessFunc)(double m2, double sigma));
extern void print_double_vector(FILE *stream, const char *name, size_t m, double *mat);
extern void print_complex_vector(FILE *stream, const char *name, size_t m, fftw_complex *mat);
extern void print_double_matrix(FILE *stream, const char *name, size_t m, size_t n, double *mat);
extern void print_complex_matrix(FILE *stream, const char *name, size_t m, size_t n, fftw_complex *mat);
extern void print_MAT_matrix(FILE *stream, const char *name, MAT *mat);

/* shank_Hinv.c */
extern MAT *shank_HinvObj(size_t Npoints, size_t Nwaves, double sigma, double (*roughnessFunc)(double m2, double sigma));
extern void shank_Hinv(size_t Npoints, size_t Nwaves, double sigma, double (*roughnessFunc)(double m2, double sigma), MAT *Hinv);
extern double *shank1d_lambdaObj(int n1, int n1new, double sigma, double *func, double (*roughnessFunc)(double m2, double sigma), double *f_aver);
extern double shank1d_lambda(int n1, int n1new, double sigma, double *func, double *lam, double (*roughnessFunc)(double m2, double sigma));
extern double *shank2d_lambdaObj(int n1, int n2, int n1new, int n2new, double sigma, double *func, double (*roughnessFunc)(double m2, double sigma), double *f_aver);
extern double shank2d_lambda(int n1, int n2, int n1new, int n2new, double sigma, double *func, double *lam, double (*roughnessFunc)(double m2, double sigma));
extern double *shank3d_lambdaObj(int n1, int n2, int n3, int n1new, int n2new, int n3new, double sigma, double *func, double (*roughnessFunc)(double m2, double sigma), double *f_aver);
extern double shank3d_lambda(int n1, int n2, int n3, int n1new, int n2new, int n3new, double sigma, double *func, double *lam, double (*roughnessFunc)(double m2, double sigma));

#endif
