 /*
 *  file      : popup.c
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2011 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */
 
 
#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	// #include <libintl.h>
	//#define _(String) gettext (String)
	/* INTERNATIONALISATION DE DATAS DEPUIS LES STRUCTURES :
	 *	http://chl.be/glmf/www.linuxmag-france.org/old/lm5/inter.html
	 */
	#define gettext_noop(x) (x) 
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "poche.h"
#include "file.h"
#include "cd_audio.h"
#include "dvd.h"
#include "split.h"
#include "popup.h"



typedef struct {
	DETAIL      *detail;
	CD_AUDIO    *Audio;
	TYPE_FILE_IS type_file_is;
	
	/*GdkPixbuf   *Image_dbfs_no;
	GdkPixbuf   *Image_dbfs_choice;
	GdkPixbuf   *Image_dbfs_yes;
	GdkPixbuf   *GlobalImage_dbfs_no;
	GdkPixbuf   *GlobalImage_dbfs_choice;
	GdkPixbuf   *GlobalImage_dbfs_yes;
	GdkPixbuf   *Image_mix_no;
	GdkPixbuf   *Image_mix_choice;
	GdkPixbuf   *Image_mix_yes;
	GdkPixbuf   *GlobalImage_mix_no;
	GdkPixbuf   *GlobalImage_mix_choice;
	GdkPixbuf   *GlobalImage_mix_yes;*/
} VAR_POPUP;

VAR_POPUP VarPopup;

typedef struct {
	gboolean   Show;
	gint       Type;
	gint       Val;
	gint       Call;
} MENU_VAL;

typedef struct {
	GtkWidget *Widget;
	gchar     *Title;
	MENU_VAL   Op;
} POP_MENU;




#define CASE_POP_MENU_FICHERS 0
#define MAX_POP_MENU_FICHERS 9
POP_MENU PopMenuFichiers [ MAX_POP_MENU_FICHERS ] = {
/*
 WIDGET	TITLE							OP
								SHOW		TYPE	VAL	CALL
*/
{NULL,	gettext_noop("   Deselection globale"),			{TRUE,		0,	0,	CASE_POP_MENU_FICHERS}},
{NULL,	gettext_noop("   Deselection verticale"),		{TRUE,		0,	0,	CASE_POP_MENU_FICHERS +1}},
{NULL,	gettext_noop("   Deselection horizontale"),		{TRUE,		0,	0,	CASE_POP_MENU_FICHERS +2}},
{NULL,	gettext_noop("   ---"),					{FALSE,		-1,	0,	-1}},
{NULL,	gettext_noop("   Selection verticale"),			{TRUE,		0,	0,	CASE_POP_MENU_FICHERS +3}},
{NULL,	gettext_noop("   Selection Expert verticale"),		{TRUE,		0,	0,	CASE_POP_MENU_FICHERS +4}},
{NULL,	gettext_noop("   ---"),					{FALSE,		-1,	0,	-1}},
{NULL,	gettext_noop("   Selection horizontale"),		{TRUE,		0,	0,	CASE_POP_MENU_FICHERS +5}},
{NULL,	gettext_noop("   Selection Expert horizontale  "),	{TRUE,		0,	0,	CASE_POP_MENU_FICHERS +6}}
};


#define CASE_POP_MENU_CD 10
#define MAX_POP_MENU_CD 9
POP_MENU PopMenuCD [ MAX_POP_MENU_CD ] = {
/*
 WIDGET	TITLE							OP
								SHOW		TYPE	VAL	CALL
*/
{NULL,	gettext_noop("   Deselection globale"),			{TRUE,		0,	0,	CASE_POP_MENU_CD}},
{NULL,	gettext_noop("   Deselection verticale"),		{TRUE,		0,	0,	CASE_POP_MENU_CD +1}},
{NULL,	gettext_noop("   Deselection horizontale"),		{TRUE,		0,	0,	CASE_POP_MENU_CD +2}},
{NULL,	gettext_noop("   ---"),					{FALSE,		-1,	0,	-1}},
{NULL,	gettext_noop("   Selection verticale"),			{TRUE,		0,	0,	CASE_POP_MENU_CD +3}},
{NULL,	gettext_noop("   Selection Expert verticale"),		{TRUE,		0,	0,	CASE_POP_MENU_CD +4}},
{NULL,	gettext_noop("   ---"),					{FALSE,		-1,	0,	-1}},
{NULL,	gettext_noop("   Selection horizontale"),		{TRUE,		0,	0,	CASE_POP_MENU_CD +5}},
{NULL,	gettext_noop("   Selection Expert horizontale  "),	{TRUE,		0,	0,	CASE_POP_MENU_CD +6}}
};


#define CASE_POP_MENU_NORMALISE_CD 200
#define MAX_POP_MENU_NORMALISE_CD 3
POP_MENU PopMenuNormaliseCD [ MAX_POP_MENU_NORMALISE_CD ] = {
/*
 WIDGET	TITLE							OP
								SHOW		TYPE	VAL	CALL
*/
{NULL,	gettext_noop("   Deselection verticale    "),		{TRUE,		0,	0,	CASE_POP_MENU_NORMALISE_CD +0}},
{NULL,	gettext_noop("   ---"),					{FALSE,		-1,	0,	-1}},
{NULL,	gettext_noop("   Selection verticale  "),		{TRUE,		0,	0,	CASE_POP_MENU_NORMALISE_CD +1}}
};


#define CASE_POP_MENU_NORMALISE_DVD 300
#define MAX_POP_MENU_NORMALISE_DVD 3
POP_MENU PopMenuNormaliseDVD [ MAX_POP_MENU_NORMALISE_DVD ] = {
/*
 WIDGET	TITLE							OP
								SHOW		TYPE	VAL	CALL
*/
{NULL,	gettext_noop("   Deselection verticale    "),		{TRUE,		0,	0,	CASE_POP_MENU_NORMALISE_DVD +0}},
{NULL,	gettext_noop("   ---"),					{FALSE,		-1,	0,	-1}},
{NULL,	gettext_noop("   Selection verticale  "),		{TRUE,		0,	0,	CASE_POP_MENU_NORMALISE_DVD +1}}
};


#define CASE_POP_MENU_REPLAYGAIN 30
#define MAX_POP_MENU_REPLAYGAIN 6
POP_MENU PopMenuReplayGain[ MAX_POP_MENU_REPLAYGAIN ] = {
/*
 WIDGET	TITLE							OP
								SHOW		TYPE	VAL	CALL
*/
{NULL,	gettext_noop("---SELECTION VERTICALE-----"),		{FALSE,		-2,	0,	-1}},
{NULL,	gettext_noop("   Deselection verticale   "),		{TRUE,		0,	0,	CASE_POP_MENU_REPLAYGAIN +0}},
{NULL,	gettext_noop("   ---"),					{FALSE,		-1,	0,	-1}},
{NULL,	gettext_noop("   Selection PISTE         "),		{TRUE,		0,	0,	CASE_POP_MENU_REPLAYGAIN +1}},
{NULL,	gettext_noop("   Selection ALBUM         "),		{TRUE,		0,	0,	CASE_POP_MENU_REPLAYGAIN +2}},
{NULL,	gettext_noop("   Selection NETTOYER      "),		{TRUE,		0,	0,	CASE_POP_MENU_REPLAYGAIN +3}}
};


#define CASE_POP_MENU_TRASH 40
#define MAX_POP_MENU_TRASH 3
POP_MENU PopMenuTrash[ MAX_POP_MENU_TRASH ] = {
/*
 WIDGET	TITLE							OP
								SHOW		TYPE	VAL	CALL
*/
{NULL,	gettext_noop("---MENU TRASH--------------"),		{FALSE,		-2,	0,	-1}},
{NULL,	gettext_noop("   Deselection verticale"),		{TRUE,		0,	0,	CASE_POP_MENU_TRASH}},
{NULL,	gettext_noop("   Selection verticale   "),		{TRUE,		0,	0,	CASE_POP_MENU_TRASH +1}}
};


#define CASE_POP_MENU_FREQUENCE_CELL_HERTZ 50
#define CASE_POP_MENU_FREQUENCE_COL_HERTZ 60
#define MAX_POP_MENU_FREQUENCE 22
POP_MENU PopMenuFrequence[ MAX_POP_MENU_FREQUENCE ] = {
/*
 WIDGET	TITLE							OP
								SHOW		TYPE	VAL	CALL
*/
{NULL,	gettext_noop("   Cellule"),				{TRUE,		-3,	0,	-1}},
{NULL,	gettext_noop("    8000  Hertz   "),			{TRUE,		-10,	8000,	CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL,	gettext_noop("   22000  Hertz   "),			{TRUE,		-10,	22000,	CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL,	gettext_noop("   32000  Hertz   "),			{TRUE,		-10,	32000,	CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL,	gettext_noop("   44056  Hertz   "),			{TRUE,		-10,	44056,	CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL,	gettext_noop("   44100  Hertz   "),			{TRUE,		-10,	44100,	CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL,	gettext_noop("   48000  Hertz   "),			{TRUE,		-10,	48000,	CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL,	gettext_noop("   88200  Hertz   "),			{TRUE,		-10,	88200,	CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL,	gettext_noop("   96000  Hertz   "),			{TRUE,		-10,	96000,	CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL,	gettext_noop("   --------------------"),		{FALSE,		-10,	0,	-1}},
{NULL,	gettext_noop("   Valeur d'origine   "),			{TRUE,		-10,	-1,	CASE_POP_MENU_FREQUENCE_CELL_HERTZ}},
{NULL,	gettext_noop("   Colonne"),				{TRUE,		-3,	0,	-1}},
{NULL,	gettext_noop("    8000  Hertz   "),			{TRUE,		-10,	8000,	CASE_POP_MENU_FREQUENCE_COL_HERTZ}},
{NULL,	gettext_noop("   22000  Hertz   "),			{TRUE,		-10,	22000,	CASE_POP_MENU_FREQUENCE_COL_HERTZ}},
{NULL,	gettext_noop("   32000  Hertz   "),			{TRUE,		-10,	32000,	CASE_POP_MENU_FREQUENCE_COL_HERTZ}},
{NULL,	gettext_noop("   44056  Hertz   "),			{TRUE,		-10,	44056,	CASE_POP_MENU_FREQUENCE_COL_HERTZ}},
{NULL,	gettext_noop("   44100  Hertz   "),			{TRUE,		-10,	44100,	CASE_POP_MENU_FREQUENCE_COL_HERTZ}},
{NULL,	gettext_noop("   48000  Hertz   "),			{TRUE,		-10,	48000,	CASE_POP_MENU_FREQUENCE_COL_HERTZ}},
{NULL,	gettext_noop("   88200  Hertz   "),			{TRUE,		-10,	88200,	CASE_POP_MENU_FREQUENCE_COL_HERTZ}},
{NULL,	gettext_noop("   96000  Hertz   "),			{TRUE,		-10,	96000,	CASE_POP_MENU_FREQUENCE_COL_HERTZ}},
{NULL,	gettext_noop("   --------------------"),		{FALSE,		-10,	0,	-1}},
{NULL,gettext_noop( "   Valeur d'origine   "),			{TRUE,		-10,	-1,	CASE_POP_MENU_FREQUENCE_COL_HERTZ}}
};


#define CASE_POP_MENU_PISTE_CELL 70
#define CASE_POP_MENU_PISTE_COL 80
#define MAX_POP_MENU_PISTE 14
POP_MENU PopMenuPiste[ MAX_POP_MENU_PISTE ] = {
/*
 WIDGET	TITLE							OP
								SHOW		TYPE	VAL	CALL
*/
{NULL,	gettext_noop("   Cellule"),				{TRUE,		-3,	0,	-1}},
{NULL,	gettext_noop("   1  piste"),				{TRUE,		-10,	1,	CASE_POP_MENU_PISTE_CELL}},
{NULL,	gettext_noop("   2  pistes"),				{TRUE,		-10,	2,	CASE_POP_MENU_PISTE_CELL}},
{NULL,	gettext_noop("   4  pistes"),				{TRUE,		-10,	4,	CASE_POP_MENU_PISTE_CELL}},
{NULL,	gettext_noop("   6  pistes"),				{TRUE,		-10,	6,	CASE_POP_MENU_PISTE_CELL}},
{NULL,	gettext_noop("   --------------------"),		{FALSE,		-10,	0,	-1}},
{NULL,	gettext_noop("   Valeur d'origine   "),			{TRUE,		-10,	-1,	CASE_POP_MENU_PISTE_CELL}},
{NULL,	gettext_noop("   Colonne"),				{TRUE,		-3,	0,	-1}},
{NULL,	gettext_noop("   1  piste"),				{TRUE,		-10,	1,	CASE_POP_MENU_PISTE_COL}},
{NULL,	gettext_noop("   2  pistes"),				{TRUE,		-10,	2,	CASE_POP_MENU_PISTE_COL}},
{NULL,	gettext_noop("   4  pistes"),				{TRUE,		-10,	4,	CASE_POP_MENU_PISTE_COL}},
{NULL,	gettext_noop("   6  pistes"),				{TRUE,		-10,	6,	CASE_POP_MENU_PISTE_COL}},
{NULL,	gettext_noop("   --------------------"),		{FALSE,		-10,	0,	-1}},
{NULL,	gettext_noop("   Valeur d'origine   "),			{TRUE,		-10,	-1,	CASE_POP_MENU_PISTE_COL }}
};


#define CASE_POP_MENU_FILEWAV_QUANTIFICATION_CELL 90
#define CASE_POP_MENU_FILEWAV_QUANTIFICATION_COL 100
#define MAX_POP_MENU_QUANTIFICATION 16
POP_MENU PopMenuQuantification[ MAX_POP_MENU_QUANTIFICATION ] = {
/*
 WIDGET	TITLE							OP
								SHOW		TYPE	VAL	CALL
*/
{NULL,	gettext_noop("   Cellule"),				{TRUE,		-3,	0,	-1}},
{NULL,	gettext_noop("    8  bits"),				{TRUE,		-10,	8,	CASE_POP_MENU_FILEWAV_QUANTIFICATION_CELL}},
{NULL,	gettext_noop("   16  bits"),				{TRUE,		-10,	16,	CASE_POP_MENU_FILEWAV_QUANTIFICATION_CELL}},
{NULL,	gettext_noop("   24  bits"),				{TRUE,		-10,	24,	CASE_POP_MENU_FILEWAV_QUANTIFICATION_CELL}},
{NULL,	gettext_noop("   32  bits"),				{TRUE,		-10,	32,	CASE_POP_MENU_FILEWAV_QUANTIFICATION_CELL}},
{NULL,	gettext_noop("   64  bits"),				{TRUE,		-10,	64,	CASE_POP_MENU_FILEWAV_QUANTIFICATION_CELL}},
{NULL,	gettext_noop("   --------------------"),		{FALSE,		-10,	0,	-1}},
{NULL,	gettext_noop("   Valeur d'origine   "),			{TRUE,		-10,   -1,	CASE_POP_MENU_FILEWAV_QUANTIFICATION_CELL}},
{NULL,	gettext_noop("   Colonne"),				{TRUE,		-3,	0,	-1}},
{NULL,	gettext_noop("    8  bits"),				{TRUE,		-10,    8,	CASE_POP_MENU_FILEWAV_QUANTIFICATION_COL}},
{NULL,	gettext_noop("   16  bits"),				{TRUE,		-10,   16,	CASE_POP_MENU_FILEWAV_QUANTIFICATION_COL}},
{NULL,	gettext_noop("   24  bits"),				{TRUE,		-10,   24,	CASE_POP_MENU_FILEWAV_QUANTIFICATION_COL}},
{NULL,	gettext_noop("   32  bits"),				{TRUE,		-10,   32,	CASE_POP_MENU_FILEWAV_QUANTIFICATION_COL}},
{NULL,	gettext_noop("   64  bits"),				{TRUE,		-10,   64,	CASE_POP_MENU_FILEWAV_QUANTIFICATION_COL}},
{NULL,	gettext_noop("   --------------------"),		{FALSE,		-10,	0,	-1}},
{NULL,	gettext_noop("   Valeur d'origine   "),			{TRUE,		-10,   -1,	CASE_POP_MENU_FILEWAV_QUANTIFICATION_COL}}
};


#define CASE_POP_MENU_SPLIT 110
#define MAX_POP_MENU_SPLIT 5
POP_MENU PopMenuSplit[ MAX_POP_MENU_SPLIT ] = {
/*
 WIDGET	TITLE							OP
								SHOW		TYPE	VAL	CALL
*/
{NULL,	gettext_noop("   ---"),					{FALSE,		-1,	0,	-1}},
{NULL,	gettext_noop("   Selecteur suivant           "),	{TRUE,		0,	0,	CASE_POP_MENU_SPLIT +0}},
{NULL,	gettext_noop("   Selecteur precedant         "),	{TRUE,		0,	0,	CASE_POP_MENU_SPLIT +1}},
{NULL,	gettext_noop("   ---"),					{FALSE,		-1,	0,	-1}},
{NULL,	gettext_noop("   Supprimer la plage active   "),	{TRUE,		0,	0,	CASE_POP_MENU_SPLIT +2}}
};


// 
// 
void popup_callback (GtkMenuItem *menuitem, gpointer user_data)
{
	MENU_VAL *Op = (MENU_VAL *)user_data;
	
	if (-1 == Op->Call) return;
	
	// g_print("Op->Call = %d\n",Op->Call);
	
	switch (Op->Call) {
	
	// Deselection globale	
	case CASE_POP_MENU_FICHERS :
		file_from_popup (FILE_CONV_DESELECT_ALL, VarPopup.detail, VarPopup.type_file_is);
		break;
	// Deselection verticale	
	case CASE_POP_MENU_FICHERS +1 :
		file_from_popup (FILE_CONV_DESELECT_V, VarPopup.detail, VarPopup.type_file_is);
		break;
	// Deselection horizontale	
	case CASE_POP_MENU_FICHERS +2 :
		file_from_popup (FILE_CONV_DESELECT_H, VarPopup.detail, VarPopup.type_file_is);
		break;
	// Selection verticale	
	case CASE_POP_MENU_FICHERS +3 : 
		file_from_popup (FILE_CONV_SELECT_V, VarPopup.detail, VarPopup.type_file_is);
		break;
	// Selection Expert verticale
	case CASE_POP_MENU_FICHERS +4 :
		file_from_popup (FILE_CONV_SELECT_EXPERT_V, VarPopup.detail, VarPopup.type_file_is);
		break;
	// Selection horizontale
	case CASE_POP_MENU_FICHERS +5 :
		file_from_popup (FILE_CONV_SELECT_H, VarPopup.detail, VarPopup.type_file_is);
		break;
	// Selection Expert horizontale
	case CASE_POP_MENU_FICHERS +6 :
		file_from_popup (FILE_CONV_SELECT_EXPERT_H, VarPopup.detail, VarPopup.type_file_is);
		break;
	

	// Deselection globale
	case CASE_POP_MENU_CD +0 :
		cdaudio_from_popup (CD_CONV_DESELECT_ALL, VarPopup.Audio, VarPopup.type_file_is);
		break;
	// Deselection verticale
	case CASE_POP_MENU_CD +1 :
		cdaudio_from_popup (CD_CONV_DESELECT_V, VarPopup.Audio, VarPopup.type_file_is);
		break;
	// Deselection horizontale
	case CASE_POP_MENU_CD +2 :
		cdaudio_from_popup (CD_CONV_DESELECT_H, VarPopup.Audio, VarPopup.type_file_is);
		break;
	// Selection verticale
	case CASE_POP_MENU_CD +3 :
		cdaudio_from_popup (CD_CONV_SELECT_V, VarPopup.Audio, VarPopup.type_file_is);
		break;
	// Selection Expert verticale
	case CASE_POP_MENU_CD +4 :
		cdaudio_from_popup (CD_CONV_SELECT_EXPERT_V, VarPopup.Audio, VarPopup.type_file_is);
		break;
	// Selection horizontale
	case CASE_POP_MENU_CD +5 :
		cdaudio_from_popup (CD_CONV_SELECT_H, VarPopup.Audio, VarPopup.type_file_is);
		break;
	// Selection Expert horizontale
	case CASE_POP_MENU_CD +6 :
		cdaudio_from_popup (CD_CONV_SELECT_EXPERT_H, VarPopup.Audio, VarPopup.type_file_is);
		break;
	

	// Deselection verticale
	case CASE_POP_MENU_NORMALISE_CD +0:
		cdaudio_from_popup (CD_REPLAYGAIN_SELECT_V, VarPopup.Audio, VarPopup.type_file_is);
		break;
	// Selection verticale
	case CASE_POP_MENU_NORMALISE_CD +1:
		cdaudio_from_popup (CD_REPLAYGAIN_DESELECT_V, VarPopup.Audio, VarPopup.type_file_is);
		break;


	// Deselection verticale
	case CASE_POP_MENU_NORMALISE_DVD +0:
		dvd_from_popup (CD_NORMALISE_SELECT_V , FALSE);
		break;
	// Selection verticale
	case CASE_POP_MENU_NORMALISE_DVD +1:
		dvd_from_popup (CD_NORMALISE_DESELECT_V, TRUE);
		break;
	
	
	// Deselection verticale
	case CASE_POP_MENU_REPLAYGAIN +0 :
		file_from_popup (FILE_REPLAYGAIN_DESELECT_V, VarPopup.detail, VarPopup.type_file_is);
		break;
	// Selection PISTE
	case CASE_POP_MENU_REPLAYGAIN +1 :
		file_from_popup (FILE_REPLAYGAIN_SELECT_PISTE, VarPopup.detail, VarPopup.type_file_is);
		break;
	// Selection ALBUM
	case CASE_POP_MENU_REPLAYGAIN +2 :
		file_from_popup (FILE_REPLAYGAIN_SELECT_ALBUM, VarPopup.detail, VarPopup.type_file_is);
		break;
	// Selection NETTOYER
	case CASE_POP_MENU_REPLAYGAIN +3 :
		file_from_popup (FILE_REPLAYGAIN_SELECT_NETTOYER, VarPopup.detail, VarPopup.type_file_is);
		break;
	

	// Deselection verticale
	case CASE_POP_MENU_TRASH :
		file_from_popup (FILE_TRASH_DESELECT_V, VarPopup.detail, VarPopup.type_file_is);
		break;
	// Selection verticale
	case CASE_POP_MENU_TRASH +1 :
		file_from_popup (FILE_TRASH_SELECT_V, VarPopup.detail, VarPopup.type_file_is);
		break;
	
	
	// Cellule HERTZ: 8000,22000,32000,44056,44100,48000,88200,96000 ou valeur d' origine
	case CASE_POP_MENU_FREQUENCE_CELL_HERTZ :
		FileWav_from_popup (FILEWAV_FREQUENCY_CELL_HERTZ, VarPopup.detail, Op->Val, -2, -2);
		break;
	// Colonne HERTZ: 8000,22000,32000,44056,44100,48000,88200,96000 ou valeur d' origine
	case CASE_POP_MENU_FREQUENCE_COL_HERTZ :
		FileWav_from_popup (FILEWAV_FREQUENCY_COL_HERTZ, VarPopup.detail, Op->Val, -2, -2);
		break;
	
	
	// Cellule PISTE: 1,2,4,6 ou valeur d' origine
	case CASE_POP_MENU_PISTE_CELL :
		FileWav_from_popup (FILEWAV_TRACK_CELL, VarPopup.detail, -2, Op->Val, -2);
		break;
	// Colonne PISTE: 1,2,4,6 ou valeur d' origine
	case CASE_POP_MENU_PISTE_COL :
		FileWav_from_popup (FILEWAV_TRACK_COL, VarPopup.detail, -2, Op->Val, -2);
		break;
	
	
	// Cellule BITS: 8,16,24,32,64 ou valeur d' origine
	case CASE_POP_MENU_FILEWAV_QUANTIFICATION_CELL :
		FileWav_from_popup (FILEWAV_QUANTIFICATION_CELL, VarPopup.detail, -2, -2, Op->Val);
		break;
	// Colonne BITS: 8,16,24,32,64 ou valeur d' origine
	case CASE_POP_MENU_FILEWAV_QUANTIFICATION_COL :
		FileWav_from_popup (FILEWAV_QUANTIFICATION_COL, VarPopup.detail, -2, -2, Op->Val);
		break;
	
	
	// Selecteur suivant
	case CASE_POP_MENU_SPLIT :
		split_from_popup (0);
		break;
	// Selecteur precedant
	case CASE_POP_MENU_SPLIT +1:
		split_from_popup (1);
		break;	
	// Supprimer le selecteur actif
	case CASE_POP_MENU_SPLIT +2:
		split_from_popup (2);
		break;
	}
}
// 
// 
void popup_make_popup (POP_MENU *p_popup, gint nbr_op)
{
	GtkWidget *menu = NULL;
	GtkWidget *Attach = NULL;
	GtkWidget *SubMenu = NULL;
	gint       cpt = 0;
	gint       val = 0;
	
	/*VarPopup.Image_dbfs_no		= libutils_init_pixbufs ("xcfa/dbfs-no.png");
	VarPopup.Image_dbfs_choice	= libutils_init_pixbufs ("xcfa/dbfs-choice.png");
	VarPopup.Image_dbfs_yes		= libutils_init_pixbufs ("xcfa/dbfs-yes.png");
	// 
	VarPopup.GlobalImage_dbfs_no	= libutils_init_pixbufs ("xcfa/global-dbfs-no.png");
	VarPopup.GlobalImage_dbfs_choice= libutils_init_pixbufs ("xcfa/global-dbfs-choice.png");
	VarPopup.GlobalImage_dbfs_yes	= libutils_init_pixbufs ("xcfa/global-dbfs-yes.png");
	// 
	VarPopup.Image_mix_no		= libutils_init_pixbufs ("xcfa/mix-no.png");
	VarPopup.Image_mix_choice	= libutils_init_pixbufs ("xcfa/mix-choice.png");
	VarPopup.Image_mix_yes		= libutils_init_pixbufs ("xcfa/mix-yes.png");
	// 
	VarPopup.GlobalImage_mix_no	= libutils_init_pixbufs ("xcfa/global-mix-no.png");
	VarPopup.GlobalImage_mix_choice	= libutils_init_pixbufs ("xcfa/global-mix-choice.png");
	VarPopup.GlobalImage_mix_yes	= libutils_init_pixbufs ("xcfa/global-mix-yes.png");*/
	
	if (VarPopup.detail != NULL) {
		if (VarPopup.detail->type_infosong_file_is == FILE_IS_WAV) {
			INFO_WAV *info = (INFO_WAV *)VarPopup.detail->info;
			val = info->LevelDbfs.level;
		}
		else if (VarPopup.detail->type_infosong_file_is == FILE_IS_OGG) {
			INFO_OGG *info = (INFO_OGG *)VarPopup.detail->info;
			val = info->LevelDbfs.level;
		}
		else if (VarPopup.detail->type_infosong_file_is == FILE_IS_MP3) {
			INFO_MP3 *info = (INFO_MP3 *)VarPopup.detail->info;
			val = info->LevelDbfs.level;
		}
	}
	
	menu = gtk_menu_new ();	
	gtk_widget_set_extension_events (menu, GDK_EXTENSION_EVENTS_ALL);

	for (cpt = 0; cpt < nbr_op; cpt ++) {
		if (p_popup[ cpt ].Op.Type > -1) {
			p_popup[ cpt ].Widget = gtk_menu_item_new_with_mnemonic (gettext(p_popup[ cpt ].Title));
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (menu), p_popup[ cpt ].Widget);
		}
		else if (p_popup[ cpt ].Op.Type == -1) {
			p_popup[ cpt ].Widget = gtk_separator_menu_item_new ();
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (menu), p_popup[ cpt ].Widget);
		}
		else if (p_popup[ cpt ].Op.Type == -2) {
			p_popup[ cpt ].Widget = gtk_menu_item_new_with_mnemonic (gettext(p_popup[ cpt ].Title));
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (menu), p_popup[ cpt ].Widget);
		}
		else if (p_popup[ cpt ].Op.Type == -3) {
			Attach = p_popup[ cpt ].Widget = gtk_menu_item_new_with_mnemonic (gettext(p_popup[ cpt ].Title));
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (menu), p_popup[ cpt ].Widget);
			
			SubMenu = gtk_menu_new ();
			gtk_menu_item_set_submenu (GTK_MENU_ITEM (p_popup[ cpt ].Widget), SubMenu);
		}
		/*else if (p_popup[ cpt ].Op.Type == -4) {
			p_popup[ cpt ].Widget = gtk_image_menu_item_new_with_mnemonic (gettext(p_popup[ cpt ].Title));
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (SubMenu), p_popup[ cpt ].Widget);
			
			if (p_popup[ cpt ].Op.Val == -6) {
				gtk_widget_show (GTK_WIDGET(VarPopup.Image_dbfs_yes));
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), GTK_WIDGET(VarPopup.Image_dbfs_yes));
			}
			else if (p_popup[ cpt ].Op.Val == -24) {
				gtk_widget_show (GTK_WIDGET(VarPopup.Image_dbfs_no));
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), GTK_WIDGET(VarPopup.Image_dbfs_no));
			}
			else if (val == p_popup[ cpt ].Op.Val) {
				gtk_widget_show (GTK_WIDGET(VarPopup.Image_dbfs_choice));
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), GTK_WIDGET(VarPopup.Image_dbfs_choice));
			}
		}
		else if (p_popup[ cpt ].Op.Type == -5) {
			p_popup[ cpt ].Widget = gtk_image_menu_item_new_with_mnemonic (gettext(p_popup[ cpt ].Title));
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (SubMenu), p_popup[ cpt ].Widget);
			
			if (p_popup[ cpt ].Op.Val == -6) {
				gtk_widget_show (GTK_WIDGET(VarPopup.Image_dbfs_yes));
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), GTK_WIDGET(VarPopup.Image_mix_yes));
			}
			else if (p_popup[ cpt ].Op.Val == -22) {
				gtk_widget_show (GTK_WIDGET(VarPopup.Image_dbfs_no));
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), GTK_WIDGET(VarPopup.Image_mix_no));
			}
			else if (val == p_popup[ cpt ].Op.Val) {
				gtk_widget_show (GTK_WIDGET(VarPopup.Image_dbfs_choice));
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), GTK_WIDGET(VarPopup.Image_mix_choice));
			}
		}
		else if (p_popup[ cpt ].Op.Type == -6) {
			p_popup[ cpt ].Widget = gtk_image_menu_item_new_with_mnemonic (gettext(p_popup[ cpt ].Title));
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (SubMenu), p_popup[ cpt ].Widget);
			
			if (p_popup[ cpt ].Op.Val == -6) {
				gtk_widget_show (GTK_WIDGET(VarPopup.GlobalImage_dbfs_yes));
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), GTK_WIDGET(VarPopup.GlobalImage_dbfs_yes));
			}
			else if (p_popup[ cpt ].Op.Val == -24) {
				gtk_widget_show (GTK_WIDGET(VarPopup.GlobalImage_dbfs_no));
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), GTK_WIDGET(VarPopup.GlobalImage_dbfs_no));
			}
			else if (val == p_popup[ cpt ].Op.Val) {
				gtk_widget_show (GTK_WIDGET(VarPopup.GlobalImage_dbfs_choice));
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), GTK_WIDGET(VarPopup.GlobalImage_dbfs_choice));
			}
		}
		else if (p_popup[ cpt ].Op.Type == -7) {
			p_popup[ cpt ].Widget = gtk_image_menu_item_new_with_mnemonic (gettext(p_popup[ cpt ].Title));
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (SubMenu), p_popup[ cpt ].Widget);
			
			if (p_popup[ cpt ].Op.Val == -6) {
				gtk_widget_show (GTK_WIDGET(VarPopup.GlobalImage_dbfs_yes));
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), GTK_WIDGET(VarPopup.GlobalImage_mix_yes));
			}
			else if (p_popup[ cpt ].Op.Val == -22) {
				gtk_widget_show (GTK_WIDGET(VarPopup.GlobalImage_dbfs_no));
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), GTK_WIDGET(VarPopup.GlobalImage_mix_no));
			}
			else if (val == p_popup[ cpt ].Op.Val) {
				gtk_widget_show (GTK_WIDGET(VarPopup.GlobalImage_dbfs_choice));
				gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (p_popup[ cpt ].Widget), GTK_WIDGET(VarPopup.GlobalImage_mix_choice));
			}
		}*/
		else if (p_popup[ cpt ].Op.Type == -10) {
			p_popup[ cpt ].Widget = gtk_image_menu_item_new_with_mnemonic (gettext(p_popup[ cpt ].Title));
			gtk_widget_show (p_popup[ cpt ].Widget);
			gtk_container_add (GTK_CONTAINER (SubMenu), p_popup[ cpt ].Widget);
		}
		
		gtk_widget_set_sensitive (p_popup[ cpt ].Widget, p_popup[ cpt ].Op.Show);
	}

	for (cpt = 0; cpt < nbr_op; cpt ++) {
		g_signal_connect ((gpointer) p_popup[ cpt ].Widget, "activate",
					G_CALLBACK (popup_callback),
					(gpointer)&p_popup[ cpt ].Op);
	}

	GLADE_HOOKUP_OBJECT_NO_REF (menu, menu, "menu");
	for (cpt = 0; cpt < nbr_op; cpt ++) {
		GLADE_HOOKUP_OBJECT (menu, p_popup[ cpt ].Widget, p_popup[ cpt ].Title);
	}

	gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL, 3, 0);	
}

// 
// 
void popup_normalise_dvd (void)
{
	VarPopup.detail = (DETAIL *)NULL;
	popup_make_popup (PopMenuNormaliseDVD, MAX_POP_MENU_NORMALISE_DVD);
}
// 
// 

void popup_cd (CD_AUDIO *Audio, TYPE_FILE_IS TypeFileIs)
{
	VarPopup.detail       = (DETAIL *)NULL;
	VarPopup.type_file_is = TypeFileIs;
	VarPopup.Audio        = Audio;
	popup_make_popup (PopMenuCD, MAX_POP_MENU_CD);
}
// 
// 
void popup_normalise_cd (void)
{
	VarPopup.detail = (DETAIL *)NULL;
	popup_make_popup (PopMenuNormaliseCD, MAX_POP_MENU_NORMALISE_CD);
}

// 
// 
void popup_file (DETAIL *detail, TYPE_FILE_IS TypeFileIs)
{
	VarPopup.detail = detail;
	VarPopup.type_file_is = TypeFileIs;
	popup_make_popup (PopMenuFichiers, MAX_POP_MENU_FICHERS);
}
// 
// 
void popup_file_ReplayGain (DETAIL *detail)
{
	VarPopup.detail = detail;
	PopMenuReplayGain[ 3 ].Op.Show = TRUE;
	if (VarPopup.detail->type_infosong_file_is == FILE_IS_FLAC) {
		PopMenuReplayGain[ 3 ].Op.Show = FALSE;
	}
	popup_make_popup (PopMenuReplayGain, MAX_POP_MENU_REPLAYGAIN);
}
// 
// 
void popup_file_Split (void)
{
	VarPopup.detail = (DETAIL *)NULL;
	popup_make_popup (PopMenuSplit, MAX_POP_MENU_SPLIT);
}

// 
// 
void popup_trash (void)
{
	VarPopup.detail = (DETAIL *)NULL;
	popup_make_popup (PopMenuTrash, MAX_POP_MENU_TRASH);
}
// 
// 
void popup_file_wav_frequence (DETAIL *detail)
{
	VarPopup.detail = detail;
	popup_make_popup (PopMenuFrequence, MAX_POP_MENU_FREQUENCE);
}
// 
// 
void popup_file_wav_piste (DETAIL *detail)
{
	VarPopup.detail = detail;
	popup_make_popup (PopMenuPiste, MAX_POP_MENU_PISTE);
}
// 
// 
void popup_file_wav_quantification (DETAIL *detail)
{
	VarPopup.detail = detail;
	popup_make_popup (PopMenuQuantification, MAX_POP_MENU_QUANTIFICATION);
}

// POPUP POCHEEVENT
// 
void on_centrer_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gboolean is_recto = GPOINTER_TO_INT(user_data);
	pocheevnt_action_popup (is_recto, 0);
}
// 
// 
void on_centrer_horizontal_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gboolean is_recto = GPOINTER_TO_INT(user_data);
	pocheevnt_action_popup (is_recto, 1);
}
// 
// 
void on_centrer_vertical_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gboolean is_recto = GPOINTER_TO_INT(user_data);
	pocheevnt_action_popup (is_recto, 2);
}
// 
// 
void popup_for_pocheevent (gboolean bool_recto)
{
	GtkWidget *menu;
	GtkWidget *centrer;
	GtkWidget *centrer_horizontal;
	GtkWidget *centrer_vertical;

	menu = gtk_menu_new ();
	gtk_widget_set_extension_events (menu, GDK_EXTENSION_EVENTS_ALL);
	centrer = gtk_menu_item_new_with_mnemonic (_(" Centrer"));
	gtk_widget_show (centrer);
	gtk_container_add (GTK_CONTAINER (menu), centrer);
	centrer_horizontal = gtk_menu_item_new_with_mnemonic (_(" Centrer horizontal "));
	gtk_widget_show (centrer_horizontal);
	gtk_container_add (GTK_CONTAINER (menu), centrer_horizontal);
	centrer_vertical = gtk_menu_item_new_with_mnemonic (_(" Centrer vertical"));
	gtk_widget_show (centrer_vertical);
	gtk_container_add (GTK_CONTAINER (menu), centrer_vertical);
	g_signal_connect ((gpointer) centrer, "activate", G_CALLBACK (on_centrer_activate), GINT_TO_POINTER(bool_recto));
	g_signal_connect ((gpointer) centrer_horizontal, "activate", G_CALLBACK (on_centrer_horizontal_activate), GINT_TO_POINTER(bool_recto));
	g_signal_connect ((gpointer) centrer_vertical, "activate", G_CALLBACK (on_centrer_vertical_activate), GINT_TO_POINTER(bool_recto));
	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (menu, menu, "menu");
	GLADE_HOOKUP_OBJECT (menu, centrer, "centrer");
	GLADE_HOOKUP_OBJECT (menu, centrer_horizontal, "centrer_horizontal");
	GLADE_HOOKUP_OBJECT (menu, centrer_vertical, "centrer_vertical");
	gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL, 3, 0);
}



