 /*
 *  file      : poche_timer.c
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2011 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gprintf.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/stat.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <pthread.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "cursor.h"
#include "poche.h"





typedef struct {
	gboolean  Enable;		/* TRUE: le timer peut etre active	*/
	gboolean  TimeoutActif;		/* TRUE: le timer est actif		*/

	gboolean  GenPostScript;	/* Generation de code			*/
	gboolean  PrintImage;		/* Affichage de l'image			*/
	gboolean  FlagsRecto;		/* Set etats flags recto		*/
	gboolean  FlagsVerso;		/* Set etats flags verso		*/

	gint      Count;		/* Compteur				*/
	pthread_t nmr_tid;		/* Handler du thread			*/
	guint     timeout;		/* Handler du timer			*/
} POCHETIMER_EVENT;

POCHETIMER_EVENT pochetimer_event = { FALSE, FALSE, FALSE, FALSE, FALSE, FALSE };



// 
// 
static gint pochetimer_timeout (gpointer data)
{
	if (pochetimer_event.Count -- <= 0) {
	
		cursor_set_watch ();
		pocheevnt_set_flag (FALSE);

		if (pochetimer_event.GenPostScript == TRUE) pochegen_gen_code_postscript ();
		if (pochetimer_event.PrintImage == TRUE)    pochegen_affiche_image ();
		if (pochetimer_event.FlagsRecto == TRUE)    pocheevnt_set_flag_buttons_recto ();
		if (pochetimer_event.FlagsVerso == TRUE)    pocheevnt_set_flag_buttons_verso ();
		
		pochetimer_event.TimeoutActif = FALSE;
		
		pochetimer_event.GenPostScript = FALSE;
		pochetimer_event.PrintImage = FALSE;
		pochetimer_event.FlagsRecto = FALSE;
		pochetimer_event.FlagsVerso = FALSE;

		cursor_set_old ();
		pocheevnt_set_flag (TRUE);
		
		gtk_timeout_remove (pochetimer_event.timeout);
	}
	return TRUE;
}
// 
// 
void pochetimer_action (PTIMER_ACTION TimerEnable, PTIMER_ACTION GenPostScript, PTIMER_ACTION PrintImage, PTIMER_ACTION FlagsRecto, PTIMER_ACTION FlagsVerso)
{
	if (pochetimer_event.Enable == FALSE) return;
	
	pochetimer_event.GenPostScript = (GenPostScript == PTIMER_DISABLE) ? FALSE : TRUE;
	pochetimer_event.PrintImage    = (PrintImage == PTIMER_DISABLE) ? FALSE : TRUE;
	pochetimer_event.FlagsRecto    = (FlagsRecto == PTIMER_DISABLE) ? FALSE : TRUE;
	pochetimer_event.FlagsVerso    = (FlagsVerso == PTIMER_DISABLE) ? FALSE : TRUE;
	
	if (TRUE == pochetimer_event.TimeoutActif) {
		pochetimer_event.Count = 4;
	}
	else {
		pochetimer_event.TimeoutActif = TRUE;
		pochetimer_event.timeout = gtk_timeout_add (500, pochetimer_timeout, 0);
	}
}
// 
// 
void pochetimer_enable (void)
{
	pochetimer_event.Enable = TRUE;
}









