 /*
 *  file    : poche_exec.c
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2011 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "poche.h"



/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

typedef struct {
	gint   signal_numchildren;
	gint   tube [ 2 ];
	pid_t  code_fork;
} POCHEXEC_CONV;

POCHEXEC_CONV pocheexec_conv;

/*
*---------------------------------------------------------------------------
* SIGNAL
*---------------------------------------------------------------------------
*/

void pocheexec_sigchld_convert (gint signum)
{	
	gint status;
	wait (&status);
	
	/* PRINT_FUNC_LF(); */
        /* if there are still children waiting
        *  re-install the signal handler
	*/
	pocheexec_conv.signal_numchildren --;
	if (pocheexec_conv.signal_numchildren > 0)
        {
                /* re-install the signal handler */
                signal (SIGCHLD, pocheexec_sigchld_convert);
        }
}
gint pocheexec_exec_with_output_conv (gchar **args, pid_t *p)
{
	if (pipe (pocheexec_conv.tube) != 0)
	{
		fprintf (stderr, "error: pipe\n");
		exit (1);
	}
	if ((*p = fork()) == 0)
	{
		dup2 (pocheexec_conv.tube [ 1 ], STDERR_FILENO);
		execvp (args[0], args);
		fprintf (stderr, "error: exec");
		exit (2);
	}
	pocheexec_conv.signal_numchildren ++;
	signal (SIGCHLD, pocheexec_sigchld_convert);
	close (pocheexec_conv.tube [ 1 ]);
	return (pocheexec_conv.tube [ 0 ]);
}

/*
*---------------------------------------------------------------------------
* CONVERSIONS VERS PNG
*---------------------------------------------------------------------------
*/

void pocheexec_convert_to_png (gchar *Source, gchar *Destination, gchar *dimension)
{
	gint   fd;
	gint   pos;
	gint   size = 1;
	gchar *args[ 20 ];
	gchar  buf[256];

	pos = 0;

	/* LineCommand = g_strdup_printf ("convert -transform -filter Cubic -resize 80x80 \"%s\" \"%s\"", filename, new->name_png); */

	args [ pos ++ ] = "nice";
	args [ pos++  ] = "-n";
	args [ pos ++ ] = "0";
	args [ pos ++ ] = "convert";
	args [ pos ++ ] = "-transform";
	args [ pos ++ ] = "-filter";
	args [ pos ++ ] = "Cubic";
	args [ pos ++ ] = "-quiet";
	args [ pos ++ ] = "-resize";
	/*args [ pos ++ ] = "80x80";*/
	args [ pos ++ ] = dimension;
	args [ pos ++ ] = Source;
	args [ pos ++ ] = Destination;
	args [ pos ++ ] = NULL;
	args [ pos ++ ] = NULL;

	/*
	printf ("!-----------------------------------!\n");
	printf ("!         C O N V E R T             !\n");
	printf ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		printf ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	printf ("\n");
	*/

	pocheexec_conv.signal_numchildren = -1;
	fd = pocheexec_exec_with_output_conv (args, &pocheexec_conv.code_fork);
	do {
		pos = -1;
		do {
			pos++;
			size = read(fd, &buf[pos], 1);

		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		buf[pos] = '\0';

	} while (size != 0);

	/* FERMER UNIQUEMENT EN FIN DE THREAD */
	close (fd);
}

/*
*---------------------------------------------------------------------------
* CONVERSIONS VERS POSTSCRIPT
*---------------------------------------------------------------------------
*/

void pocheexec_convert_to_postscript (gchar *Source, gchar *Destination)
{
	gint   fd;
	gint   pos;
	gint   size = 1;
	gchar *args[ 20 ];
	gchar  buf[256];
	pos = 0;

	/*
	LineCommand = g_strdup_printf ("convert \"%s\" \"%s\"", gl->name_img, file_recto_tmp);
	*/

	args [ pos ++ ] = "convert";
	args [ pos ++ ] = Source;
	args [ pos ++ ] = Destination;
	args [ pos ++ ] = NULL;
	args [ pos ++ ] = NULL;

	/*
	printf ("!-----------------------------------!\n");
	printf ("!         C O N V E R T             !\n");
	printf ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		printf ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	printf ("\n");
	*/
	
	pocheexec_conv.signal_numchildren = -1;
	fd = pocheexec_exec_with_output_conv (args, &pocheexec_conv.code_fork);

	do {
		pos = -1;
		do {
			pos++;
			size = read(fd, &buf[pos], 1);

		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		buf[pos] = '\0';

	} while (size != 0);

	/* FERMER UNIQUEMENT EN FIN DE THREAD */
	close (fd);
}

/*
*---------------------------------------------------------------------------
* EXEC VIEWER POSTSCRIPT
*---------------------------------------------------------------------------
*/

void pocheexec_exec_viewer_postscript (gchar **args, pid_t *p)
{
	if ((*p = fork()) == 0)
	{
		execvp (args[0], args);
		fprintf (stderr, "error: exec");
		exit (2);
	}
	pocheexec_conv.signal_numchildren ++;
	signal (SIGCHLD, pocheexec_sigchld_convert);
}

void pocheexec_viewer_postscript (gchar *ProgName, gchar *PtrDest)
{
	gint   pos;
	gchar *args[ 20 ];

	pos = 0;

	args [ pos ++ ] = ProgName;
	args [ pos ++ ] = PtrDest;
	args [ pos ++ ] = NULL;
	args [ pos ++ ] = NULL;
	/*
	printf ("!-----------------------------------!\n");
	printf ("!     E X E C    V I E W E R        !\n");
	printf ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		printf ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	printf ("\n");
	*/
	pocheexec_conv.signal_numchildren = -1;
	pocheexec_exec_viewer_postscript (args, &pocheexec_conv.code_fork);
}

/*
*---------------------------------------------------------------------------
* CONSTRUIT UN FICHIER PDF
*---------------------------------------------------------------------------
*/

gboolean pocheexec_pdf (gchar *ProgName, gchar *PtrSrc, gchar *PtrDest)
{
	pid_t  pid;
	gint   ret = 0;
	gint   status;

	/*PRINT_FUNC_LF();*/

	wait (&status);
	pid = fork ();
	if (pid == 0) {
		ret = execlp (ProgName, ProgName, PtrSrc, PtrDest, NULL);
		_exit (0);
	}
	return (ret == -1 ? FALSE : TRUE);
}

void pocheexec_make_pdf_file (gchar *source, gchar *destination)
{
	gchar *dest = NULL;
	gchar *ptr = NULL;

	/*PRINT_FUNC_LF();*/

	/*
	g_print ("\nGENERATION D'UN DOCUMENT PDF\n");
	g_print ("\tSOURCE:      %s\n", source);
	*/
	if (destination == NULL) {
		dest = g_strdup_printf ("%s12345678", source);
		ptr = strrchr (dest, '.');
		if (!ptr) {
			g_free (dest);
			dest = NULL;
			g_print ("GENERATION D'UN DOCUMENT PDF: PROBLEME !!\n");
			return;
		}
		ptr ++;
		*ptr ++ = 'p';
		*ptr ++ = 'd';
		*ptr ++ = 'f';
		*ptr ++ = '\0';
	}
	else {
		ptr = strrchr (source, '/');
		dest = g_strdup_printf ("%s%s12345678", destination, ptr);
		ptr = strrchr (dest, '.');
		if (!ptr) {
			g_free (dest);
			dest = NULL;
			g_print ("GENERATION D'UN DOCUMENT PDF: PROBLEME !!\n");
			return;
		}
		ptr ++;
		*ptr ++ = 'p';
		*ptr ++ = 'd';
		*ptr ++ = 'f';
		*ptr ++ = '\0';
	}
	/*g_print ("\tDESTINATION: %s\n", dest);*/
	
	if (poche.file_preview_pdf) {
		g_free (poche.file_preview_pdf);
		poche.file_preview_pdf = NULL;
	}
	poche.file_preview_pdf = g_strdup (dest);
		
	pocheexec_pdf ("ps2pdf", source, dest);

	g_free (dest);
	dest = NULL;
}












