 /*
 * file    : poche_evnt.h
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2011 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gprintf.h>
#include <glib/gstdio.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <pthread.h>
#include <string.h>
#include <math.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "fileselect.h"
#include "configuser.h"
#include "dragNdrop.h"
#include "prg_init.h"
#include "win_info.h"
#include "win_scan.h"
#include "cd_audio.h"
#include "file.h"
#include "cursor.h"
#include "tags.h"
#include "popup.h"
#include "poche.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/
extern double round(double x);

extern gint n_drag_types;

#define DEFAULT_ZOOM_POCHETTE 1

typedef enum {
	IMG_NONE,
	STOP,
	MOVE_TO_GAUCHE,
	MOVE_TO_BAS,
	MOVE_TO_HAUT,
	MOVE_TO_DROITE,
	BORD_GAUCHE_TO_GAUCHE,
	BORD_GAUCHE_TO_DROITE,
	BORD_DROITE_TO_GAUCHE,
	BORD_DROITE_TO_DROITE,
	BORD_HAUT_TO_HAUT,
	BORD_HAUT_TO_BAS,
	BORD_BAS_TO_HAUT,
	BORD_BAS_TO_BAS
} ETAT_IMAGE;

ETAT_IMAGE etat_image = IMG_NONE;

VAR_POCHETTE poche;

typedef struct {
	gboolean  EndThread;
	gboolean  AfficheImage;
	gboolean  AjouteTable;
	gboolean  EndTimeout;
	guint     timeout;
	pthread_t nmr_tid;
} POCHEVENT_EVENT;

POCHEVENT_EVENT pochevent_event;


void pocheevnt_print_tab_recto (void);
void pocheevnt_print_tab_verso (void);





// 
// 
void on_notebook_pochette_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (TRUE == Config.BoolConfigOk)
		Config.NotebookPochette = page_num;
}
// 
// 
void pocheevnt_remove (void)
{
	GLIST_POCHETTE *gl = NULL;
	GList          *list = NULL;

	list = g_list_first (poche.glist);
	while (list) {
		if ((gl = (GLIST_POCHETTE *)list->data)) {
			g_free (gl->name_img);
			gl->name_img = NULL;
			g_free (gl->name_png);
			gl->name_png = NULL;
			g_free (gl);
			gl = NULL;
			list->data = NULL;
		}
		list = g_list_next (list);
	}
	g_list_free (poche.glist);
	poche.glist = NULL;

	g_free (poche.Path_pochette_ps);	poche.Path_pochette_ps  = NULL;
	g_free (poche.Path_pochette_png);	poche.Path_pochette_png = NULL;
	g_free (poche.Path_pochette);		poche.Path_pochette = NULL;
	
	poche.Path_pochette_base = libutils_remove_temporary_rep (poche.Path_pochette_base);

	g_free (poche.file_preview_ps);		poche.file_preview_ps = NULL;
	g_free (poche.file_preview_png);	poche.file_preview_png = NULL;
	g_free (poche.file_recto_ps);		poche.file_recto_ps = NULL;
	g_free (poche.file_verso_ps);		poche.file_verso_ps = NULL;
}
// 
// 
gboolean bool_togglebutton_clicked_reentrance = FALSE;
// 
// 
void pocheevnt_destroy_image (gpointer user_data)
{
	GLIST_POCHETTE *gl = (GLIST_POCHETTE *)user_data;
	GList          *list = NULL;
	GList          *freeglist = NULL;
	gboolean        bool_affiche = FALSE;

	if (bool_togglebutton_clicked_reentrance == TRUE) return;
	bool_togglebutton_clicked_reentrance = TRUE;

	/*PRINT_FUNC_LF();*/

	/* Annulation de l'effet du click souris */
	/*gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), FALSE);*/
	/*gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gl->togglebutton), FALSE);*/

	gtk_widget_destroy (gl->togglebutton);
	gtk_widget_destroy (gl->label);

	list = g_list_first (poche.glist);
	while (list) {
		if ((gl = (GLIST_POCHETTE *)list->data)) {

			if (gl == user_data) {

				if (gl == poche.ptr_recto) {
					g_unlink (poche.file_recto_ps);
					poche.bool_file_recto_ps = FALSE;
					poche.ptr_recto = NULL;
					bool_affiche = TRUE;
				}
				if (gl == poche.ptr_verso) {
					g_unlink (poche.file_verso_ps);
					poche.bool_file_verso_ps = FALSE;
					poche.ptr_verso = NULL;
					bool_affiche = TRUE;
				}

				g_free (gl->name_img);
				gl->name_img = NULL;
				g_unlink (gl->name_png);
				g_free (gl->name_png);
				gl->name_png = NULL;
				g_free (gl);
				gl = NULL;
				freeglist = list;
				freeglist->data = NULL;
				poche.glist = g_list_remove_link (poche.glist, freeglist);

				if (bool_affiche == TRUE) {
					pochetimer_action (PTIMER_DISABLE, GENPOSTSCRIPT, PRINTIMAGE, FLAGSRECTO, FLAGSVERSO);
				}

				break;
			}
		}
		list = g_list_next (list);
	}
	bool_togglebutton_clicked_reentrance = FALSE;
}
// 
// 
void pocheevnt_togglebutton_clicked (GtkButton *button, gpointer user_data)
{
	GLIST_POCHETTE *gl = (GLIST_POCHETTE *)user_data;
	GList          *list = NULL;

	if (poche.bool_destroy_image == TRUE) {
		pocheevnt_destroy_image (user_data);
		return;
	}
	
	if (bool_togglebutton_clicked_reentrance == TRUE) return;
	bool_togglebutton_clicked_reentrance = TRUE;

	// PRINT_FUNC_LF();

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gl->togglebutton), FALSE);

	/* */
	if (poche.bool_radio_recto_actif == TRUE) {
		g_unlink (poche.file_recto_ps);
		poche.bool_file_recto_ps = FALSE;
		poche.ptr_recto = poche.ptr_recto == (GLIST_POCHETTE *)user_data ? NULL : (GLIST_POCHETTE *)user_data;
	}
	else if (poche.bool_radio_recto_actif == FALSE) {
		g_unlink (poche.file_verso_ps);
		poche.bool_file_verso_ps = FALSE;
		poche.ptr_verso = poche.ptr_verso == (GLIST_POCHETTE *)user_data ? NULL : (GLIST_POCHETTE *)user_data;
	}

	list = g_list_first (poche.glist);
	while (list) {
		if ((gl = (GLIST_POCHETTE *)list->data)) {

			if (poche.ptr_recto == gl && poche.ptr_verso == gl) {
				gtk_label_set_markup (GTK_LABEL (gl->label), _("<b>Recto / Verso</b>"));
				poche.bool_file_recto_ps = TRUE;
				poche.bool_file_verso_ps = TRUE;
			} else if (poche.ptr_recto == gl) {
				gtk_label_set_markup (GTK_LABEL (gl->label), _("<b>Recto</b>"));
				poche.bool_file_recto_ps = TRUE;
			} else if (poche.ptr_verso == gl) {
				gtk_label_set_markup (GTK_LABEL (gl->label), _("<b>Verso</b>"));
				poche.bool_file_verso_ps = TRUE;
			} else {
				gtk_label_set_markup (GTK_LABEL (gl->label), "<b></b>");
			}
		}
		list = g_list_next (list);
	}
	
	pochetimer_action (PTIMER_DISABLE, GENPOSTSCRIPT, PRINTIMAGE, FLAGSRECTO, FLAGSVERSO);
	bool_togglebutton_clicked_reentrance = FALSE;
}
// 
// 
void pocheevnt_table_add_images_init (void)
{
	if (poche.Adr_table) {
		gtk_widget_destroy (poche.Adr_table);
		poche.Adr_table = NULL;
	}

	poche.Adr_table = gtk_table_new (4, 5, TRUE);
	gtk_container_add (GTK_CONTAINER (poche.Adr_viewport_image_preview), poche.Adr_table);
	gtk_widget_show_all (poche.Adr_table);
}
// 
// 
void pocheevnt_table_add_images (void)
{
	GLIST_POCHETTE *gl = NULL;
	GList          *list = NULL;
	GtkWidget      *table;
	gint            total_row_table = 0;
	gint            row_table = 0;

	if (poche.Adr_table) {
		gtk_widget_destroy (poche.Adr_table);
		poche.Adr_table = NULL;
	}

	total_row_table = g_list_length (poche.glist);

	poche.Adr_table = table = gtk_table_new (2, total_row_table, FALSE);
	gtk_widget_show (table);
	gtk_container_add (GTK_CONTAINER (poche.Adr_viewport_image_preview), table);

	list = g_list_first (poche.glist);
	while (list) {
		if ((gl = (GLIST_POCHETTE *)list->data)) {

			/* button */
			gl->togglebutton = gtk_toggle_button_new ();
			gtk_widget_show (gl->togglebutton);
			gtk_table_attach (GTK_TABLE (table),
						gl->togglebutton,
						row_table, row_table +1, 0, 1,
						(GtkAttachOptions) (GTK_FILL),
						(GtkAttachOptions) (0), 0, 0);
			gtk_widget_set_size_request (gl->togglebutton, 95, 95);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gl->togglebutton), FALSE);
			gtk_container_set_border_width (GTK_CONTAINER (gl->togglebutton), 5);

			/* image */
			// gl->image = create_pixmap (WindMain, NULL);
			gl->image = gtk_image_new ();
			gtk_widget_show (gl->image);
			gtk_container_add (GTK_CONTAINER (gl->togglebutton), gl->image);
			gtk_image_set_from_file (GTK_IMAGE (gl->image), gl->name_png);

			/* signal */
			g_signal_connect ((gpointer)gl->togglebutton,
						"clicked",
						G_CALLBACK (pocheevnt_togglebutton_clicked),
						gl);

			/* label */
			gl->label = gtk_label_new (NULL);
			gtk_widget_show (gl->label);
			gtk_table_attach (GTK_TABLE (table),
						gl->label,
						row_table, row_table +1, 1, 2,
						(GtkAttachOptions) (GTK_FILL),
						(GtkAttachOptions) (0), 0, 0);
			gtk_label_set_use_markup (GTK_LABEL (gl->label), TRUE);

			row_table ++;
		}
		list = g_list_next (list);
	}
	gtk_widget_show_all (table);

	list = g_list_first (poche.glist);
	while (list) {
		if ((gl = (GLIST_POCHETTE *)list->data)) {

			if (poche.ptr_recto == gl && poche.ptr_verso == gl) {
				gtk_label_set_markup (GTK_LABEL (gl->label), _("<b>Recto / Verso</b>"));
			} else if (poche.ptr_recto == gl) {
				gtk_label_set_markup (GTK_LABEL (gl->label), _("<b>Recto</b>"));
			} else if (poche.ptr_verso == gl) {
				gtk_label_set_markup (GTK_LABEL (gl->label), _("<b>Verso</b>"));
			} else {
				gtk_label_set_markup (GTK_LABEL (gl->label), "<b></b>");
			}
		}
		list = g_list_next (list);
	}
}
// 
// 
gboolean bool_event_button_press = FALSE;

gint oldX = -1;
gint oldY = -1;
// 
// 
void pocheevnt_print (void)
{
	gchar *name [] = {
	"MOVE_NONE",
	"MOVE_RECTO",
	"MOVE_RECTO_GAUCHE",
	"MOVE_RECTO_DROIT",
	"MOVE_RECTO_HAUT",
	"MOVE_RECTO_BAS",
	"MOVE_RECTO_COIN_HAUT_GAUCHE",
	"MOVE_RECTO_COIN_HAUT_DROIT",
	"MOVE_RECTO_COIN_BAS_GAUCHE",
	"MOVE_RECTO_COIN_BAS_DROIT",
	"MOVE_VERSO",
	"MOVE_VERSO_GAUCHE",
	"MOVE_VERSO_DROIT",
	"MOVE_VERSO_HAUT",
	"MOVE_VERSO_BAS",
	"MOVE_VERSO_COIN_HAUT_GAUCHE",
	"MOVE_VERSO_COIN_HAUT_DROIT",
	"MOVE_VERSO_COIN_BAS_GAUCHE",
	"MOVE_VERSO_COIN_BAS_DROIT",
	};
	/*PRINT_FUNC_LF();*/
	g_print ("%s\n", name [poche.move] );
}
// 
// 
gboolean bool_dedans = FALSE;
// 
// 
gboolean on_eventbox_image_preview_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	gint            x, y, yy = 0;
	GdkModifierType state;
	gdouble         percent = pocheevnt_get_percent_zoom ();
	gint            point;
	guint           button;

	/*
	g_print ("TAILLE IMAGE\n");
	g_print ("\tx      = %d\n", poche.Adr_image_preview->allocation.x);
	g_print ("\ty      = %d\n", poche.Adr_image_preview->allocation.y);
	g_print ("\twidth  = %d\n", poche.Adr_image_preview->allocation.width);
	g_print ("\theight = %d\n", poche.Adr_image_preview->allocation.height);
	g_print ("\n");

	g_print ("event->type == %d\n", event->type);
	*/

	/*
	if (poche.bool_file_recto_ps == FALSE && poche.bool_file_verso_ps == FALSE) {
		return (FALSE);
	}*/

 	button = ((GdkEventButton*)event)->button;
 	if (button == 3 && (poche.move == MOVE_RECTO || poche.move == MOVE_VERSO)) {
 		popup_for_pocheevent (poche.move == MOVE_RECTO ? TRUE : FALSE);
 		return (FALSE);
 	}

	if (event->type == GDK_ENTER_NOTIFY) {
		/*g_print ("GDK_ENTER_NOTIFY\n");*/
		bool_dedans = TRUE;
	}
	else if (event->type == GDK_LEAVE_NOTIFY) {
		/*g_print ("GDK_LEAVE_NOTIFY\n");*/
		if (bool_event_button_press == FALSE) {
			poche.move = MOVE_NONE;
			if (cursor_get_watch () == FALSE) cursor_set_old ();
			bool_dedans = FALSE;
			return (FALSE);
		}
	}
	if (poche.bool_redraw == TRUE) {
		cursor_set_watch ();
		return (FALSE);
	}
	if (cursor_get_watch () == TRUE) {
		return (FALSE);
	}
	if (bool_dedans == FALSE) return (FALSE);

	gdk_window_get_pointer (((GdkEventButton*)event)->window, &x, &y, &state);
	yy = poche.Adr_image_preview->allocation.height - y;

	/* Recuperation coordonnees de la souris */
	if (oldX == -1 || oldY == -1) {
		oldX = x;
		oldY = y;
	}
/*
	g_print ("oldX %3d  oldY %3d\n", x,y);
	g_print ("x    %3d  y    %3d\n", x,y);
*/
	if (event->type == GDK_BUTTON_PRESS) {
		/*g_print ("GDK_BUTTON_PRESS\n");*/
		bool_event_button_press = TRUE;
		/*pocheevnt_print ();*/
	}
	else if (event->type == GDK_BUTTON_RELEASE) {
		/*g_print ("GDK_BUTTON_RELEASE\n");*/
		bool_event_button_press = FALSE;

		switch (poche.move) {
		case MOVE_NONE :
			break;

		case MOVE_RECTO_COIN_HAUT_GAUCHE :
		case MOVE_RECTO_COIN_HAUT_DROIT :
		case MOVE_RECTO_COIN_BAS_GAUCHE :
		case MOVE_RECTO_COIN_BAS_DROIT :
		case MOVE_RECTO :
			{
			gdouble t;

			/* Mise a jour PTR0 et PTR2 */
			if (poche.grille [ 0 ].x1 == 1) {
				point = poche.tab [ 2 ].x1 + 1;
			} else {
				point = poche.tab [ 2 ].x1 - poche.grille [ 0 ].x1;
			}
			PTR0 = ((gdouble)point / percent) * 100.0;
			if (PTR0 <= 88) PTR0 = 88; else PTR0 ++;

			yy = poche.tab [ 0 ].x2 - poche.tab [ 0 ].x1;
			PTR2 = ((gdouble)yy / percent) * 100.0;
			PTR2 ++;
			if (PTR2 >= RECTO_LARGEUR) {
				PTR2 = RECTO_LARGEUR;
			}
			/* Mise a jour PTR1 et PTR3 */
			point = (poche.grille [ 0 ].y2 +poche.grille [ 0 ].y1) - poche.tab [ 1 ].y1;
			t = ((gdouble)point / percent) * 100.0;
			PTR1 = (gint)round (t);

			point = poche.tab [ 1 ].y1 - poche.tab [ 0 ].y1;
			t = ((gdouble)point / percent) * 100.0;
			PTR3 = (gint)round (t);
			}
			break;

		case MOVE_RECTO_DROIT :
			/* Mise a jour PTR2 */
			point = poche.tab [ 3 ].x1 - poche.tab [ 2 ].x1;
			PTR2 = ((gdouble)point / percent) * 100.0;
			PTR2 ++;
			break;

		case MOVE_RECTO_GAUCHE :
			/* Mise a jour PTR0 et PTR2 */
			if (poche.grille [ 0 ].x1 == 1) {
				point = poche.tab [ 2 ].x1 + 1;
			} else {
				point = poche.tab [ 2 ].x1 - poche.grille [ 0 ].x1;
			}
			PTR0 = ((gdouble)point / percent) * 100.0;
			if (PTR0 <= 88) PTR0 = 88; else PTR0 ++;

			yy = poche.tab [ 0 ].x2 - poche.tab [ 0 ].x1;
			PTR2 = ((gdouble)yy / percent) * 100.0;
			PTR2 ++;
			if (PTR2 >= RECTO_LARGEUR) {
				PTR2 = RECTO_LARGEUR;
			}
			break;

		case MOVE_RECTO_HAUT :
			/* Mise a jour PTR3 */
			point = poche.tab [ 1 ].y1 - poche.tab [ 0 ].y1;
			PTR3 = ((gdouble)point / percent) * 100.0;
			PTR3 ++;
			while (PTR1 + PTR3 > RECTO_MAX_HAUTEUR) {
				PTR3--;
			}
			break;

		case MOVE_RECTO_BAS :
			{
			gdouble t;

			/* Mise a jour PTR1 et PTR3 */
			point = (poche.grille [ 0 ].y2 +poche.grille [ 0 ].y1) - poche.tab [ 1 ].y1;
			t = ((gdouble)point / percent) * 100.0;
			PTR1 = (gint)round (t);

			point = poche.tab [ 1 ].y1 - poche.tab [ 0 ].y1;
			t = ((gdouble)point / percent) * 100.0;
			PTR3 = (gint)round (t);
			}
			break;

		case MOVE_VERSO_COIN_HAUT_GAUCHE :
		case MOVE_VERSO_COIN_HAUT_DROIT :
		case MOVE_VERSO_COIN_BAS_GAUCHE :
		case MOVE_VERSO_COIN_BAS_DROIT :
		case MOVE_VERSO :
			{
			gdouble t;

			/* Mise a jour PTV0 et PTV2 */
			if (poche.grille [ 0 ].x1 == 1) {
				point = poche.tab [ 6 ].x1 + 1;
			} else {
				point = poche.tab [ 6 ].x1 - poche.grille [ 0 ].x1;
			}
			PTV0 = ((gdouble)point / percent) * 100.0;
			if (PTV0 <= 71) PTV0 = 71; else PTV0 ++;

			yy = poche.tab [ 4 ].x2 - poche.tab [ 4 ].x1;
			PTV2 = ((gdouble)yy / percent) * 100.0;
			PTV2 ++;
			if (PTV2 >= VERSO_LARGEUR) {
				PTV2 = VERSO_LARGEUR;
			}
			/* Mise a jour PTV1 et PTV3 */
			point = (poche.grille [ 0 ].y2 +poche.grille [ 0 ].y1) - poche.tab [ 5 ].y1;
			t = ((gdouble)point / percent) * 100.0;
			PTV1 = (gint)round (t);

			point = poche.tab [ 5 ].y1 - poche.tab [ 4 ].y1;
			t = ((gdouble)point / percent) * 100.0;
			PTV3 = (gint)round (t);
			}
			break;

		case MOVE_VERSO_DROIT :
			/* Mise a jour PTV2 */
			point = poche.tab [ 7 ].x1 - poche.tab [ 6 ].x1;
			PTV2 = ((gdouble)point / percent) * 100.0;
			PTV2 ++;
			break;

		case MOVE_VERSO_GAUCHE :
			/* Mise a jour PTV0 et PTV2 */
			if (poche.grille [ 0 ].x1 == 1) {
				point = poche.tab [ 6 ].x1 + 1;
			} else {
				point = poche.tab [ 6 ].x1 - poche.grille [ 0 ].x1;
			}
			PTV0 = ((gdouble)point / percent) * 100.0;
			if (PTV0 <= 71) PTV0 = 71; else PTV0 ++;

			yy = poche.tab [ 4 ].x2 - poche.tab [ 4 ].x1;
			PTV2 = ((gdouble)yy / percent) * 100.0;
			PTV2 ++;
			if (PTV2 >= VERSO_LARGEUR) {
				PTV2 = VERSO_LARGEUR;
			}
			break;

		case MOVE_VERSO_HAUT :
			/* Mise a jour PTV3 */
			point = poche.tab [ 5 ].y1 - poche.tab [ 4 ].y1;
			PTV3 = ((gdouble)point / percent) * 100.0;
			PTV3 ++;
			while (PTV1 + PTV3 > VERSO_MAX_HAUTEUR) {
				PTV3--;
			}
			break;

		case MOVE_VERSO_BAS :
			{
			gdouble t;

			/* Mise a jour PTV1 et PTV3 */
			point = (poche.grille [ 0 ].y2 +poche.grille [ 0 ].y1) - poche.tab [ 5 ].y1;
			t = ((gdouble)point / percent) * 100.0;
			PTV1 = (gint)round (t);

			point = poche.tab [ 5 ].y1 - poche.tab [ 4 ].y1;
			t = ((gdouble)point / percent) * 100.0;
			PTV3 = (gint)round (t);
			}
			break;

		}

		if (poche.move != MOVE_NONE && poche.bool_move == TRUE) {
			poche.bool_redraw = TRUE;
			cursor_set_watch ();
			pocheevnt_set_flag (FALSE);
			while (gtk_events_pending()) gtk_main_iteration();
			pochegen_gen_code_postscript ();
			pochegen_affiche_image ();
			pocheevnt_set_flag_buttons_recto ();
			pocheevnt_set_flag_buttons_verso ();
			pocheevnt_set_flag_buttons_preview ();
			pocheevnt_set_flag (TRUE);
			cursor_set_old ();
			poche.move = MOVE_NONE;
			poche.bool_redraw = FALSE;
			poche.bool_move = FALSE;
		}


		/*pochedraw_redraw_image ();*/

		cursor_set_old ();
		poche.move = MOVE_NONE;
		return FALSE;
	}

	if (bool_event_button_press == TRUE) {
		gboolean bool_redraw = FALSE;

		/*pocheevnt_print ();*/

		switch (poche.move) {
		case MOVE_NONE :
			cursor_set_old ();
			break;

		case MOVE_RECTO :
			if (x > oldX) {
				bool_redraw = TRUE;
				poche.tab [ 0 ].x1 += x - oldX;
				poche.tab [ 0 ].x2 += x - oldX;
				poche.tab [ 1 ].x1 += x - oldX;
				poche.tab [ 1 ].x2 += x - oldX;
				poche.tab [ 2 ].x1 += x - oldX;
				poche.tab [ 2 ].x2 += x - oldX;
				poche.tab [ 3 ].x1 += x - oldX;
				poche.tab [ 3 ].x2 += x - oldX;
			} else if ( x < oldX) {
				bool_redraw = TRUE;
				poche.tab [ 0 ].x1 -= oldX - x;
				poche.tab [ 0 ].x2 -= oldX - x;
				poche.tab [ 1 ].x1 -= oldX - x;
				poche.tab [ 1 ].x2 -= oldX - x;
				poche.tab [ 2 ].x1 -= oldX - x;
				poche.tab [ 2 ].x2 -= oldX - x;
				poche.tab [ 3 ].x1 -= oldX - x;
				poche.tab [ 3 ].x2 -= oldX - x;
			}
			if (y > oldY) {
				bool_redraw = TRUE;
				poche.tab [ 0 ].y1 += y - oldY;
				poche.tab [ 0 ].y2 += y - oldY;
				poche.tab [ 1 ].y1 += y - oldY;
				poche.tab [ 1 ].y2 += y - oldY;
				poche.tab [ 2 ].y1 += y - oldY;
				poche.tab [ 2 ].y2 += y - oldY;
				poche.tab [ 3 ].y1 += y - oldY;
				poche.tab [ 3 ].y2 += y - oldY;
			} else if (y < oldY) {
				bool_redraw = TRUE;
				poche.tab [ 0 ].y1 -= oldY - y;
				poche.tab [ 0 ].y2 -= oldY - y;
				poche.tab [ 1 ].y1 -= oldY - y;
				poche.tab [ 1 ].y2 -= oldY - y;
				poche.tab [ 2 ].y1 -= oldY - y;
				poche.tab [ 2 ].y2 -= oldY - y;
				poche.tab [ 3 ].y1 -= oldY - y;
				poche.tab [ 3 ].y2 -= oldY - y;
			}
			/* Verification limite haute */
			while (poche.tab [ 0 ].y1 < poche.grille [ 1 ].y1) {
				poche.tab [ 0 ].y1 ++;
				poche.tab [ 0 ].y2 ++;
				poche.tab [ 1 ].y1 ++;
				poche.tab [ 1 ].y2 ++;
				poche.tab [ 2 ].y1 ++;
				poche.tab [ 2 ].y2 ++;
				poche.tab [ 3 ].y1 ++;
				poche.tab [ 3 ].y2 ++;
			}
			/* Verification limite basse */
			while (poche.tab [ 1 ].y1 > poche.grille [ 2 ].y1) {
				poche.tab [ 0 ].y1 --;
				poche.tab [ 0 ].y2 --;
				poche.tab [ 1 ].y1 --;
				poche.tab [ 1 ].y2 --;
				poche.tab [ 2 ].y1 --;
				poche.tab [ 2 ].y2 --;
				poche.tab [ 3 ].y1 --;
				poche.tab [ 3 ].y2 --;
			}
			/* Verification limite gauche */
			while (poche.tab [ 2 ].x1 < poche.grille [ 3 ].x1) {
				poche.tab [ 0 ].x1 ++;
				poche.tab [ 0 ].x2 ++;
				poche.tab [ 1 ].x1 ++;
				poche.tab [ 1 ].x2 ++;
				poche.tab [ 2 ].x1 ++;
				poche.tab [ 2 ].x2 ++;
				poche.tab [ 3 ].x1 ++;
				poche.tab [ 3 ].x2 ++;
			}
			/* Verification limite droite */
			while (poche.tab [ 3 ].x1 > poche.grille [ 4 ].x1) {
				poche.tab [ 0 ].x1 --;
				poche.tab [ 0 ].x2 --;
				poche.tab [ 1 ].x1 --;
				poche.tab [ 1 ].x2 --;
				poche.tab [ 2 ].x1 --;
				poche.tab [ 2 ].x2 --;
				poche.tab [ 3 ].x1 --;
				poche.tab [ 3 ].x2 --;
			}
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
				/*
				g_print ("bool_redraw = %s\n", bool_redraw ? "TRUE" : "FALSE");
				g_print ("oldX %3d  oldY %3d\n", x,y);
				g_print ("x    %3d  y    %3d\n", x,y);
				*/
			}
			break;

		case MOVE_RECTO_COIN_HAUT_GAUCHE :
			poche.tab [ 2 ].x1 = x;
			poche.tab [ 2 ].x2 = x;
			poche.tab [ 0 ].x1 = x;
			poche.tab [ 1 ].x1 = x;
			if (x < poche.grille [ 3 ].x1) {
				poche.tab [ 2 ].x1 = poche.grille [ 3 ].x1;
				poche.tab [ 2 ].x2 = poche.grille [ 3 ].x1;
				poche.tab [ 0 ].x1 = poche.grille [ 3 ].x1;
				poche.tab [ 1 ].x1 = poche.grille [ 3 ].x1;
			} else if (x > (poche.tab [ 3 ].x1 - poche.largeur_mini)) {
				poche.tab [ 2 ].x1 = (poche.tab [ 3 ].x1 - poche.largeur_mini);
				poche.tab [ 2 ].x2 = (poche.tab [ 3 ].x1 - poche.largeur_mini);
				poche.tab [ 0 ].x1 = (poche.tab [ 3 ].x1 - poche.largeur_mini);
				poche.tab [ 1 ].x1 = (poche.tab [ 3 ].x1 - poche.largeur_mini);
			}
			poche.tab [ 0 ].y1 = y;
			poche.tab [ 0 ].y2 = y;
			poche.tab [ 2 ].y1 = y;
			poche.tab [ 3 ].y1 = y;
			if (y < poche.grille [ 1 ].y1) {
				poche.tab [ 0 ].y1 = poche.grille [ 1 ].y1;
				poche.tab [ 0 ].y2 = poche.grille [ 1 ].y1;
				poche.tab [ 2 ].y1 = poche.grille [ 1 ].y1;
				poche.tab [ 3 ].y1 = poche.grille [ 1 ].y1;
			} else if (y > (poche.tab [ 1 ].y1 - poche.largeur_mini)) {
				poche.tab [ 0 ].y1 = (poche.tab [ 1 ].y1 - poche.largeur_mini);
				poche.tab [ 0 ].y2 = (poche.tab [ 1 ].y1 - poche.largeur_mini);
				poche.tab [ 2 ].y1 = (poche.tab [ 1 ].y1 - poche.largeur_mini);
				poche.tab [ 3 ].y1 = (poche.tab [ 1 ].y1 - poche.largeur_mini);
			}
			bool_redraw = (x != oldX || y != oldY) ? TRUE : FALSE;
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;

		case MOVE_RECTO_COIN_HAUT_DROIT :
			poche.tab [ 3 ].x1 = x;
			poche.tab [ 3 ].x2 = x;
			poche.tab [ 0 ].x2 = x;
			poche.tab [ 1 ].x2 = x;
			if (x > poche.grille [ 4 ].x1) {
				poche.tab [ 3 ].x1 = poche.grille [ 4 ].x1;
				poche.tab [ 3 ].x2 = poche.grille [ 4 ].x1;
				poche.tab [ 0 ].x2 = poche.grille [ 4 ].x1;
				poche.tab [ 1 ].x2 = poche.grille [ 4 ].x1;
			} else if (x < (poche.tab [ 2 ].x1 + poche.largeur_mini)) {
				poche.tab [ 3 ].x1 = (poche.tab [ 2 ].x1 + poche.largeur_mini);
				poche.tab [ 3 ].x2 = (poche.tab [ 2 ].x1 + poche.largeur_mini);
				poche.tab [ 0 ].x2 = (poche.tab [ 2 ].x1 + poche.largeur_mini);
				poche.tab [ 1 ].x2 = (poche.tab [ 2 ].x1 + poche.largeur_mini);
			}
			poche.tab [ 0 ].y1 = y;
			poche.tab [ 0 ].y2 = y;
			poche.tab [ 2 ].y1 = y;
			poche.tab [ 3 ].y1 = y;
			if (y < poche.grille [ 1 ].y1) {
				poche.tab [ 0 ].y1 = poche.grille [ 1 ].y1;
				poche.tab [ 0 ].y2 = poche.grille [ 1 ].y1;
				poche.tab [ 2 ].y1 = poche.grille [ 1 ].y1;
				poche.tab [ 3 ].y1 = poche.grille [ 1 ].y1;
			} else if (y > (poche.tab [ 1 ].y1 - poche.largeur_mini)) {
				poche.tab [ 0 ].y1 = (poche.tab [ 1 ].y1 - poche.largeur_mini);
				poche.tab [ 0 ].y2 = (poche.tab [ 1 ].y1 - poche.largeur_mini);
				poche.tab [ 2 ].y1 = (poche.tab [ 1 ].y1 - poche.largeur_mini);
				poche.tab [ 3 ].y1 = (poche.tab [ 1 ].y1 - poche.largeur_mini);
			}
			bool_redraw = (x != oldX || y != oldY) ? TRUE : FALSE;
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;

		case MOVE_RECTO_COIN_BAS_GAUCHE :
			poche.tab [ 2 ].x1 = x;
			poche.tab [ 2 ].x2 = x;
			poche.tab [ 0 ].x1 = x;
			poche.tab [ 1 ].x1 = x;
			if (x < poche.grille [ 3 ].x1) {
				poche.tab [ 2 ].x1 = poche.grille [ 3 ].x1;
				poche.tab [ 2 ].x2 = poche.grille [ 3 ].x1;
				poche.tab [ 0 ].x1 = poche.grille [ 3 ].x1;
				poche.tab [ 1 ].x1 = poche.grille [ 3 ].x1;
			} else if (x > (poche.tab [ 3 ].x1 - poche.largeur_mini)) {
				poche.tab [ 2 ].x1 = (poche.tab [ 3 ].x1 - poche.largeur_mini);
				poche.tab [ 2 ].x2 = (poche.tab [ 3 ].x1 - poche.largeur_mini);
				poche.tab [ 0 ].x1 = (poche.tab [ 3 ].x1 - poche.largeur_mini);
				poche.tab [ 1 ].x1 = (poche.tab [ 3 ].x1 - poche.largeur_mini);
			}
			poche.tab [ 1 ].y1 = y;
			poche.tab [ 1 ].y2 = y;
			poche.tab [ 2 ].y2 = y;
			poche.tab [ 3 ].y2 = y;
			if (y > poche.grille [ 2 ].y1) {
				poche.tab [ 1 ].y1 = poche.grille [ 2 ].y1;
				poche.tab [ 1 ].y2 = poche.grille [ 2 ].y1;
				poche.tab [ 2 ].y2 = poche.grille [ 2 ].y1;
				poche.tab [ 3 ].y2 = poche.grille [ 2 ].y1;
			} else if (y < (poche.tab [ 0 ].y1 + poche.largeur_mini)) {
				poche.tab [ 1 ].y1 = (poche.tab [ 0 ].y1 + poche.largeur_mini);
				poche.tab [ 1 ].y2 = (poche.tab [ 0 ].y1 + poche.largeur_mini);
				poche.tab [ 2 ].y2 = (poche.tab [ 0 ].y1 + poche.largeur_mini);
				poche.tab [ 3 ].y2 = (poche.tab [ 0 ].y1 + poche.largeur_mini);
			}
			bool_redraw = (x != oldX || y != oldY) ? TRUE : FALSE;
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;

		case MOVE_RECTO_COIN_BAS_DROIT :
			poche.tab [ 3 ].x1 = x;
			poche.tab [ 3 ].x2 = x;
			poche.tab [ 0 ].x2 = x;
			poche.tab [ 1 ].x2 = x;
			if (x > poche.grille [ 4 ].x1) {
				poche.tab [ 3 ].x1 = poche.grille [ 4 ].x1;
				poche.tab [ 3 ].x2 = poche.grille [ 4 ].x1;
				poche.tab [ 0 ].x2 = poche.grille [ 4 ].x1;
				poche.tab [ 1 ].x2 = poche.grille [ 4 ].x1;
			} else if (x < (poche.tab [ 2 ].x1 + poche.largeur_mini)) {
				poche.tab [ 3 ].x1 = (poche.tab [ 2 ].x1 + poche.largeur_mini);
				poche.tab [ 3 ].x2 = (poche.tab [ 2 ].x1 + poche.largeur_mini);
				poche.tab [ 0 ].x2 = (poche.tab [ 2 ].x1 + poche.largeur_mini);
				poche.tab [ 1 ].x2 = (poche.tab [ 2 ].x1 + poche.largeur_mini);
			}
			poche.tab [ 1 ].y1 = y;
			poche.tab [ 1 ].y2 = y;
			poche.tab [ 2 ].y2 = y;
			poche.tab [ 3 ].y2 = y;
			if (y > poche.grille [ 2 ].y1) {
				poche.tab [ 1 ].y1 = poche.grille [ 2 ].y1;
				poche.tab [ 1 ].y2 = poche.grille [ 2 ].y1;
				poche.tab [ 2 ].y2 = poche.grille [ 2 ].y1;
				poche.tab [ 3 ].y2 = poche.grille [ 2 ].y1;
			} else if (y < (poche.tab [ 0 ].y1 + poche.largeur_mini)) {
				poche.tab [ 1 ].y1 = (poche.tab [ 0 ].y1 + poche.largeur_mini);
				poche.tab [ 1 ].y2 = (poche.tab [ 0 ].y1 + poche.largeur_mini);
				poche.tab [ 2 ].y2 = (poche.tab [ 0 ].y1 + poche.largeur_mini);
				poche.tab [ 3 ].y2 = (poche.tab [ 0 ].y1 + poche.largeur_mini);
			}
			bool_redraw = (x != oldX || y != oldY) ? TRUE : FALSE;
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;

		case MOVE_RECTO_GAUCHE :
			poche.tab [ 2 ].x1 = x;
			poche.tab [ 2 ].x2 = x;
			poche.tab [ 0 ].x1 = x;
			poche.tab [ 1 ].x1 = x;
			if (x < poche.grille [ 3 ].x1) {
				poche.tab [ 2 ].x1 = poche.grille [ 3 ].x1;
				poche.tab [ 2 ].x2 = poche.grille [ 3 ].x1;
				poche.tab [ 0 ].x1 = poche.grille [ 3 ].x1;
				poche.tab [ 1 ].x1 = poche.grille [ 3 ].x1;
			} else if (x > (poche.tab [ 3 ].x1 - poche.largeur_mini)) {
				poche.tab [ 2 ].x1 = (poche.tab [ 3 ].x1 - poche.largeur_mini);
				poche.tab [ 2 ].x2 = (poche.tab [ 3 ].x1 - poche.largeur_mini);
				poche.tab [ 0 ].x1 = (poche.tab [ 3 ].x1 - poche.largeur_mini);
				poche.tab [ 1 ].x1 = (poche.tab [ 3 ].x1 - poche.largeur_mini);
			}
			bool_redraw = (x != oldX || y != oldY) ? TRUE : FALSE;
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;

		case MOVE_RECTO_DROIT :
			poche.tab [ 3 ].x1 = x;
			poche.tab [ 3 ].x2 = x;
			poche.tab [ 0 ].x2 = x;
			poche.tab [ 1 ].x2 = x;
			if (x > poche.grille [ 4 ].x1) {
				poche.tab [ 3 ].x1 = poche.grille [ 4 ].x1;
				poche.tab [ 3 ].x2 = poche.grille [ 4 ].x1;
				poche.tab [ 0 ].x2 = poche.grille [ 4 ].x1;
				poche.tab [ 1 ].x2 = poche.grille [ 4 ].x1;
			} else if (x < (poche.tab [ 2 ].x1 + poche.largeur_mini)) {
				poche.tab [ 3 ].x1 = (poche.tab [ 2 ].x1 + poche.largeur_mini);
				poche.tab [ 3 ].x2 = (poche.tab [ 2 ].x1 + poche.largeur_mini);
				poche.tab [ 0 ].x2 = (poche.tab [ 2 ].x1 + poche.largeur_mini);
				poche.tab [ 1 ].x2 = (poche.tab [ 2 ].x1 + poche.largeur_mini);
			}
			bool_redraw = (x != oldX || y != oldY) ? TRUE : FALSE;
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;

		case MOVE_RECTO_HAUT :
			poche.tab [ 0 ].y1 = y;
			poche.tab [ 0 ].y2 = y;
			poche.tab [ 2 ].y1 = y;
			poche.tab [ 3 ].y1 = y;
			if (y < poche.grille [ 1 ].y1) {
				poche.tab [ 0 ].y1 = poche.grille [ 1 ].y1;
				poche.tab [ 0 ].y2 = poche.grille [ 1 ].y1;
				poche.tab [ 2 ].y1 = poche.grille [ 1 ].y1;
				poche.tab [ 3 ].y1 = poche.grille [ 1 ].y1;
			} else if (y > (poche.tab [ 1 ].y1 - poche.largeur_mini)) {
				poche.tab [ 0 ].y1 = (poche.tab [ 1 ].y1 - poche.largeur_mini);
				poche.tab [ 0 ].y2 = (poche.tab [ 1 ].y1 - poche.largeur_mini);
				poche.tab [ 2 ].y1 = (poche.tab [ 1 ].y1 - poche.largeur_mini);
				poche.tab [ 3 ].y1 = (poche.tab [ 1 ].y1 - poche.largeur_mini);
			}
			bool_redraw = (x != oldX || y != oldY) ? TRUE : FALSE;
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;

		case MOVE_RECTO_BAS :
			poche.tab [ 1 ].y1 = y;
			poche.tab [ 1 ].y2 = y;
			poche.tab [ 2 ].y2 = y;
			poche.tab [ 3 ].y2 = y;
			if (y < (poche.tab [ 0 ].y1 + poche.largeur_mini)) {
				poche.tab [ 1 ].y1 = (poche.tab [ 0 ].y1 + poche.largeur_mini);
				poche.tab [ 1 ].y2 = (poche.tab [ 0 ].y1 + poche.largeur_mini);
				poche.tab [ 2 ].y2 = (poche.tab [ 0 ].y1 + poche.largeur_mini);
				poche.tab [ 3 ].y2 = (poche.tab [ 0 ].y1 + poche.largeur_mini);
			} else if (y > poche.grille [ 2 ].y1) {
				poche.tab [ 1 ].y1 = poche.grille [ 2 ].y1;
				poche.tab [ 1 ].y2 = poche.grille [ 2 ].y1;
				poche.tab [ 2 ].y2 = poche.grille [ 2 ].y1;
				poche.tab [ 3 ].y2 = poche.grille [ 2 ].y1;
			}
			bool_redraw = (x != oldX || y != oldY) ? TRUE : FALSE;
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;

		case MOVE_VERSO :
			if (x > oldX) {
				bool_redraw = TRUE;
				poche.tab [ 4 ].x1 += x - oldX;
				poche.tab [ 4 ].x2 += x - oldX;
				poche.tab [ 5 ].x1 += x - oldX;
				poche.tab [ 5 ].x2 += x - oldX;
				poche.tab [ 6 ].x1 += x - oldX;
				poche.tab [ 6 ].x2 += x - oldX;
				poche.tab [ 7 ].x1 += x - oldX;
				poche.tab [ 7 ].x2 += x - oldX;
			} else if ( x < oldX) {
				bool_redraw = TRUE;
				poche.tab [ 4 ].x1 -= oldX - x;
				poche.tab [ 4 ].x2 -= oldX - x;
				poche.tab [ 5 ].x1 -= oldX - x;
				poche.tab [ 5 ].x2 -= oldX - x;
				poche.tab [ 6 ].x1 -= oldX - x;
				poche.tab [ 6 ].x2 -= oldX - x;
				poche.tab [ 7 ].x1 -= oldX - x;
				poche.tab [ 7 ].x2 -= oldX - x;
			}
			if (y > oldY) {
				bool_redraw = TRUE;
				poche.tab [ 4 ].y1 += y - oldY;
				poche.tab [ 4 ].y2 += y - oldY;
				poche.tab [ 5 ].y1 += y - oldY;
				poche.tab [ 5 ].y2 += y - oldY;
				poche.tab [ 6 ].y1 += y - oldY;
				poche.tab [ 6 ].y2 += y - oldY;
				poche.tab [ 7 ].y1 += y - oldY;
				poche.tab [ 7 ].y2 += y - oldY;
			} else if (y < oldY) {
				bool_redraw = TRUE;
				poche.tab [ 4 ].y1 -= oldY - y;
				poche.tab [ 4 ].y2 -= oldY - y;
				poche.tab [ 5 ].y1 -= oldY - y;
				poche.tab [ 5 ].y2 -= oldY - y;
				poche.tab [ 6 ].y1 -= oldY - y;
				poche.tab [ 6 ].y2 -= oldY - y;
				poche.tab [ 7 ].y1 -= oldY - y;
				poche.tab [ 7 ].y2 -= oldY - y;
			}
			/* Verification limite haute */
			while (poche.tab [ 4 ].y1 < poche.grille [ 5 ].y1) {
				poche.tab [ 4 ].y1 ++;
				poche.tab [ 4 ].y2 ++;
				poche.tab [ 5 ].y1 ++;
				poche.tab [ 5 ].y2 ++;
				poche.tab [ 6 ].y1 ++;
				poche.tab [ 6 ].y2 ++;
				poche.tab [ 7 ].y1 ++;
				poche.tab [ 7 ].y2 ++;
			}
			/* Verification limite basse */
			while (poche.tab [ 5 ].y1 > poche.grille [ 6 ].y1) {
				poche.tab [ 4 ].y1 --;
				poche.tab [ 4 ].y2 --;
				poche.tab [ 5 ].y1 --;
				poche.tab [ 5 ].y2 --;
				poche.tab [ 6 ].y1 --;
				poche.tab [ 6 ].y2 --;
				poche.tab [ 7 ].y1 --;
				poche.tab [ 7 ].y2 --;
			}
			/* Verification limite gauche */
			while (poche.tab [ 6 ].x1 < poche.grille [ 7 ].x1) {
				poche.tab [ 4 ].x1 ++;
				poche.tab [ 4 ].x2 ++;
				poche.tab [ 5 ].x1 ++;
				poche.tab [ 5 ].x2 ++;
				poche.tab [ 6 ].x1 ++;
				poche.tab [ 6 ].x2 ++;
				poche.tab [ 7 ].x1 ++;
				poche.tab [ 7 ].x2 ++;
			}
			/* Verification limite droite */
			while (poche.tab [ 7 ].x1 > poche.grille [ 11 ].x1) {
				poche.tab [ 4 ].x1 --;
				poche.tab [ 4 ].x2 --;
				poche.tab [ 5 ].x1 --;
				poche.tab [ 5 ].x2 --;
				poche.tab [ 6 ].x1 --;
				poche.tab [ 6 ].x2 --;
				poche.tab [ 7 ].x1 --;
				poche.tab [ 7 ].x2 --;
			}
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;

		case MOVE_VERSO_COIN_HAUT_GAUCHE :
			poche.tab [ 6 ].x1 = x;
			poche.tab [ 6 ].x2 = x;
			poche.tab [ 4 ].x1 = x;
			poche.tab [ 5 ].x1 = x;
			if (x < poche.grille [ 7 ].x1) {
				poche.tab [ 6 ].x1 = poche.grille [ 7 ].x1;
				poche.tab [ 6 ].x2 = poche.grille [ 7 ].x1;
				poche.tab [ 4 ].x1 = poche.grille [ 7 ].x1;
				poche.tab [ 5 ].x1 = poche.grille [ 7 ].x1;
			} else if (x > (poche.tab [ 7 ].x1 - poche.largeur_mini)) {
				poche.tab [ 6 ].x1 = (poche.tab [ 7 ].x1 - poche.largeur_mini);
				poche.tab [ 6 ].x2 = (poche.tab [ 7 ].x1 - poche.largeur_mini);
				poche.tab [ 4 ].x1 = (poche.tab [ 7 ].x1 - poche.largeur_mini);
				poche.tab [ 5 ].x1 = (poche.tab [ 7 ].x1 - poche.largeur_mini);
			}
			poche.tab [ 4 ].y1 = y;
			poche.tab [ 4 ].y2 = y;
			poche.tab [ 6 ].y1 = y;
			poche.tab [ 7 ].y1 = y;
			if (y < poche.grille [ 5 ].y1) {
				poche.tab [ 4 ].y1 = poche.grille [ 5 ].y1;
				poche.tab [ 4 ].y2 = poche.grille [ 5 ].y1;
				poche.tab [ 6 ].y1 = poche.grille [ 5 ].y1;
				poche.tab [ 7 ].y1 = poche.grille [ 5 ].y1;
			} else if (y > (poche.tab [ 5 ].y1 - poche.largeur_mini)) {
				poche.tab [ 4 ].y1 = (poche.tab [ 5 ].y1 - poche.largeur_mini);
				poche.tab [ 4 ].y2 = (poche.tab [ 5 ].y1 - poche.largeur_mini);
				poche.tab [ 6 ].y1 = (poche.tab [ 5 ].y1 - poche.largeur_mini);
				poche.tab [ 7 ].y1 = (poche.tab [ 5 ].y1 - poche.largeur_mini);
			}
			bool_redraw = (x != oldX || y != oldY) ? TRUE : FALSE;
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;

		case MOVE_VERSO_COIN_HAUT_DROIT :
			poche.tab [ 7 ].x1 = x;
			poche.tab [ 7 ].x2 = x;
			poche.tab [ 4 ].x2 = x;
			poche.tab [ 5 ].x2 = x;
			if (x > poche.grille [ 11 ].x1) {
				poche.tab [ 7 ].x1 = poche.grille [ 11 ].x1;
				poche.tab [ 7 ].x2 = poche.grille [ 11 ].x1;
				poche.tab [ 4 ].x2 = poche.grille [ 11 ].x1;
				poche.tab [ 5 ].x2 = poche.grille [ 11 ].x1;
			} else if (x < (poche.tab [ 6 ].x1 + poche.largeur_mini)) {
				poche.tab [ 7 ].x1 = (poche.tab [ 6 ].x1 + poche.largeur_mini);
				poche.tab [ 7 ].x2 = (poche.tab [ 6 ].x1 + poche.largeur_mini);
				poche.tab [ 4 ].x2 = (poche.tab [ 6 ].x1 + poche.largeur_mini);
				poche.tab [ 5 ].x2 = (poche.tab [ 6 ].x1 + poche.largeur_mini);
			}
			poche.tab [ 4 ].y1 = y;
			poche.tab [ 4 ].y2 = y;
			poche.tab [ 6 ].y1 = y;
			poche.tab [ 7 ].y1 = y;
			if (y < poche.grille [ 5 ].y1) {
				poche.tab [ 4 ].y1 = poche.grille [ 5 ].y1;
				poche.tab [ 4 ].y2 = poche.grille [ 5 ].y1;
				poche.tab [ 6 ].y1 = poche.grille [ 5 ].y1;
				poche.tab [ 7 ].y1 = poche.grille [ 5 ].y1;
			} else if (y > (poche.tab [ 5 ].y1 - poche.largeur_mini)) {
				poche.tab [ 4 ].y1 = (poche.tab [ 5 ].y1 - poche.largeur_mini);
				poche.tab [ 4 ].y2 = (poche.tab [ 5 ].y1 - poche.largeur_mini);
				poche.tab [ 6 ].y1 = (poche.tab [ 5 ].y1 - poche.largeur_mini);
				poche.tab [ 7 ].y1 = (poche.tab [ 5 ].y1 - poche.largeur_mini);
			}
			bool_redraw = (x != oldX || y != oldY) ? TRUE : FALSE;
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;

		case MOVE_VERSO_COIN_BAS_GAUCHE :
			poche.tab [ 6 ].x1 = x;
			poche.tab [ 6 ].x2 = x;
			poche.tab [ 4 ].x1 = x;
			poche.tab [ 5 ].x1 = x;
			if (x < poche.grille [ 7 ].x1) {
				poche.tab [ 6 ].x1 = poche.grille [ 7 ].x1;
				poche.tab [ 6 ].x2 = poche.grille [ 7 ].x1;
				poche.tab [ 4 ].x1 = poche.grille [ 7 ].x1;
				poche.tab [ 5 ].x1 = poche.grille [ 7 ].x1;
			} else if (x > (poche.tab [ 7 ].x1 - poche.largeur_mini)) {
				poche.tab [ 6 ].x1 = (poche.tab [ 7 ].x1 - poche.largeur_mini);
				poche.tab [ 6 ].x2 = (poche.tab [ 7 ].x1 - poche.largeur_mini);
				poche.tab [ 4 ].x1 = (poche.tab [ 7 ].x1 - poche.largeur_mini);
				poche.tab [ 5 ].x1 = (poche.tab [ 7 ].x1 - poche.largeur_mini);
			}
			poche.tab [ 5 ].y1 = y;
			poche.tab [ 5 ].y2 = y;
			poche.tab [ 6 ].y2 = y;
			poche.tab [ 7 ].y2 = y;
			if (y > poche.grille [ 6 ].y1) {
				poche.tab [ 5 ].y1 = poche.grille [ 6 ].y1;
				poche.tab [ 5 ].y2 = poche.grille [ 6 ].y1;
				poche.tab [ 6 ].y2 = poche.grille [ 6 ].y1;
				poche.tab [ 7 ].y2 = poche.grille [ 6 ].y1;
			} else if (y < (poche.tab [ 4 ].y1 + poche.largeur_mini)) {
				poche.tab [ 5 ].y1 = (poche.tab [ 4 ].y1 + poche.largeur_mini);
				poche.tab [ 5 ].y2 = (poche.tab [ 4 ].y1 + poche.largeur_mini);
				poche.tab [ 6 ].y2 = (poche.tab [ 4 ].y1 + poche.largeur_mini);
				poche.tab [ 7 ].y2 = (poche.tab [ 4 ].y1 + poche.largeur_mini);
			}
			bool_redraw = (x != oldX || y != oldY) ? TRUE : FALSE;
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;

		case MOVE_VERSO_COIN_BAS_DROIT :
			poche.tab [ 7 ].x1 = x;
			poche.tab [ 7 ].x2 = x;
			poche.tab [ 4 ].x2 = x;
			poche.tab [ 5 ].x2 = x;
			if (x > poche.grille [ 11 ].x1) {
				poche.tab [ 7 ].x1 = poche.grille [ 11 ].x1;
				poche.tab [ 7 ].x2 = poche.grille [ 11 ].x1;
				poche.tab [ 4 ].x2 = poche.grille [ 11 ].x1;
				poche.tab [ 5 ].x2 = poche.grille [ 11 ].x1;
			} else if (x < (poche.tab [ 6 ].x1 + poche.largeur_mini)) {
				poche.tab [ 7 ].x1 = (poche.tab [ 6 ].x1 + poche.largeur_mini);
				poche.tab [ 7 ].x2 = (poche.tab [ 6 ].x1 + poche.largeur_mini);
				poche.tab [ 4 ].x2 = (poche.tab [ 6 ].x1 + poche.largeur_mini);
				poche.tab [ 5 ].x2 = (poche.tab [ 6 ].x1 + poche.largeur_mini);
			}
			poche.tab [ 5 ].y1 = y;
			poche.tab [ 5 ].y2 = y;
			poche.tab [ 6 ].y2 = y;
			poche.tab [ 7 ].y2 = y;
			if (y > poche.grille [ 6 ].y1) {
				poche.tab [ 5 ].y1 = poche.grille [ 6 ].y1;
				poche.tab [ 5 ].y2 = poche.grille [ 6 ].y1;
				poche.tab [ 6 ].y2 = poche.grille [ 6 ].y1;
				poche.tab [ 7 ].y2 = poche.grille [ 6 ].y1;
			} else if (y < (poche.tab [ 4 ].y1 + poche.largeur_mini)) {
				poche.tab [ 5 ].y1 = (poche.tab [ 4 ].y1 + poche.largeur_mini);
				poche.tab [ 5 ].y2 = (poche.tab [ 4 ].y1 + poche.largeur_mini);
				poche.tab [ 6 ].y2 = (poche.tab [ 4 ].y1 + poche.largeur_mini);
				poche.tab [ 7 ].y2 = (poche.tab [ 4 ].y1 + poche.largeur_mini);
			}
			bool_redraw = (x != oldX || y != oldY) ? TRUE : FALSE;
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;

		case MOVE_VERSO_GAUCHE :
			poche.tab [ 6 ].x1 = x;
			poche.tab [ 6 ].x2 = x;
			poche.tab [ 4 ].x1 = x;
			poche.tab [ 5 ].x1 = x;
			if (x < poche.grille [ 7 ].x1) {
				poche.tab [ 6 ].x1 = poche.grille [ 7 ].x1;
				poche.tab [ 6 ].x2 = poche.grille [ 7 ].x1;
				poche.tab [ 4 ].x1 = poche.grille [ 7 ].x1;
				poche.tab [ 5 ].x1 = poche.grille [ 7 ].x1;
			} else if (x > (poche.tab [ 7 ].x1 - poche.largeur_mini)) {
				poche.tab [ 6 ].x1 = (poche.tab [ 7 ].x1 - poche.largeur_mini);
				poche.tab [ 6 ].x2 = (poche.tab [ 7 ].x1 - poche.largeur_mini);
				poche.tab [ 4 ].x1 = (poche.tab [ 7 ].x1 - poche.largeur_mini);
				poche.tab [ 5 ].x1 = (poche.tab [ 7 ].x1 - poche.largeur_mini);
			}
			bool_redraw = (x != oldX || y != oldY) ? TRUE : FALSE;
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;

		case MOVE_VERSO_DROIT :
			poche.tab [ 7 ].x1 = x;
			poche.tab [ 7 ].x2 = x;
			poche.tab [ 4 ].x2 = x;
			poche.tab [ 5 ].x2 = x;
			if (x > poche.grille [ 11 ].x1) {
				poche.tab [ 7 ].x1 = poche.grille [ 11 ].x1;
				poche.tab [ 7 ].x2 = poche.grille [ 11 ].x1;
				poche.tab [ 4 ].x2 = poche.grille [ 11 ].x1;
				poche.tab [ 5 ].x2 = poche.grille [ 11 ].x1;
			} else if (x < (poche.tab [ 6 ].x1 + poche.largeur_mini)) {
				poche.tab [ 7 ].x1 = (poche.tab [ 6 ].x1 + poche.largeur_mini);
				poche.tab [ 7 ].x2 = (poche.tab [ 6 ].x1 + poche.largeur_mini);
				poche.tab [ 4 ].x2 = (poche.tab [ 6 ].x1 + poche.largeur_mini);
				poche.tab [ 5 ].x2 = (poche.tab [ 6 ].x1 + poche.largeur_mini);
			}
			bool_redraw = (x != oldX || y != oldY) ? TRUE : FALSE;
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;

		case MOVE_VERSO_HAUT :
			poche.tab [ 4 ].y1 = y;
			poche.tab [ 4 ].y2 = y;
			poche.tab [ 6 ].y1 = y;
			poche.tab [ 7 ].y1 = y;
			if (y < poche.grille [ 5 ].y1) {
				poche.tab [ 4 ].y1 = poche.grille [ 5 ].y1;
				poche.tab [ 4 ].y2 = poche.grille [ 5 ].y1;
				poche.tab [ 6 ].y1 = poche.grille [ 5 ].y1;
				poche.tab [ 7 ].y1 = poche.grille [ 5 ].y1;
			} else if (y > (poche.tab [ 5 ].y1 - poche.largeur_mini)) {
				poche.tab [ 4 ].y1 = (poche.tab [ 5 ].y1 - poche.largeur_mini);
				poche.tab [ 4 ].y2 = (poche.tab [ 5 ].y1 - poche.largeur_mini);
				poche.tab [ 6 ].y1 = (poche.tab [ 5 ].y1 - poche.largeur_mini);
				poche.tab [ 7 ].y1 = (poche.tab [ 5 ].y1 - poche.largeur_mini);
			}
			bool_redraw = (x != oldX || y != oldY) ? TRUE : FALSE;
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;

		case MOVE_VERSO_BAS :
			poche.tab [ 5 ].y1 = y;
			poche.tab [ 5 ].y2 = y;
			poche.tab [ 6 ].y2 = y;
			poche.tab [ 7 ].y2 = y;
			if (y < (poche.tab [ 4 ].y1 + poche.largeur_mini)) {
				poche.tab [ 5 ].y1 = (poche.tab [ 4 ].y1 + poche.largeur_mini);
				poche.tab [ 5 ].y2 = (poche.tab [ 4 ].y1 + poche.largeur_mini);
				poche.tab [ 6 ].y2 = (poche.tab [ 4 ].y1 + poche.largeur_mini);
				poche.tab [ 7 ].y2 = (poche.tab [ 4 ].y1 + poche.largeur_mini);
			} else if (y > poche.grille [ 6 ].y1) {
				poche.tab [ 5 ].y1 = poche.grille [ 6 ].y1;
				poche.tab [ 5 ].y2 = poche.grille [ 6 ].y1;
				poche.tab [ 6 ].y2 = poche.grille [ 6 ].y1;
				poche.tab [ 7 ].y2 = poche.grille [ 6 ].y1;
			}
			bool_redraw = (x != oldX || y != oldY) ? TRUE : FALSE;
			if (bool_redraw == TRUE) {
				poche.bool_move = TRUE;
			}
			break;
		}
		if (bool_redraw) {
			poche.bool_with_get_grille_img = FALSE;
			pochedraw_redraw_image ();
		}
		/* les anciennes coordonnees de la souris */
		oldX = x;
		oldY = y;
		return FALSE;
	}

	/* les anciennes coordonnees de la souris */
	oldX = x;
	oldY = y;

	poche.move = MOVE_NONE;

	/* Test si dans le recto */
	if (poche.bool_file_recto_ps == TRUE &&
		x >= (poche.tab [ 0 ].x1 -1) && x <= (poche.tab [ 0 ].x2 +1) &&
		y >= (poche.tab [ 0 ].y1 -1) && y <= (poche.tab [ 1 ].y1 +1)) {

		poche.move = MOVE_RECTO;

		if (x  > (poche.tab [ 0 ].x1 +5) && x < (poche.tab [ 0 ].x2 -5) &&
			y >= (poche.tab [ 0 ].y1 -1) && y <= (poche.tab [ 0 ].y1 +1)) {
			cursor_set_haut ();
			poche.move = MOVE_RECTO_HAUT;
		}
		else if (x  > (poche.tab [ 1 ].x1 +5) && x < (poche.tab [ 1 ].x2 -5) &&
			y >= (poche.tab [ 1 ].y1 -1) && y <= (poche.tab [ 1 ].y1 +1)) {
			cursor_set_bas ();
			poche.move = MOVE_RECTO_BAS;
		}
		else if (y > (poche.tab [ 2 ].y1 +5) && y < (poche.tab [ 2 ].y2 -5) &&
			x >= (poche.tab [ 2 ].x1 -1) && x <= (poche.tab [ 2 ].x1 +1)) {
			cursor_set_gauche ();
			poche.move = MOVE_RECTO_GAUCHE;
		}
		else if (y > (poche.tab [ 3 ].y1 +5) && y < (poche.tab [ 3 ].y2 -5) &&
			x >= (poche.tab [ 3 ].x1 -1) && x <= (poche.tab [ 3 ].x1 +1)) {
			cursor_set_droit ();
			poche.move = MOVE_RECTO_DROIT;
		}
		else if (x >= (poche.tab [ 0 ].x1 -1) && x <= (poche.tab [ 0 ].x1 +5) &&
			y >= (poche.tab [ 0 ].y1 -1) && y <= (poche.tab [ 0 ].y1 +5)) {
			cursor_set_haut_gauche ();
			poche.move = MOVE_RECTO_COIN_HAUT_GAUCHE;
		}
		else if (x >= (poche.tab [ 0 ].x2 -5) && x <= (poche.tab [ 0 ].x2 +1) &&
			y >= (poche.tab [ 0 ].y1 -1) && y <= (poche.tab [ 0 ].y1 +5)) {
			cursor_set_haut_droit ();
			poche.move = MOVE_RECTO_COIN_HAUT_DROIT;
		}
		else if (x >= (poche.tab [ 1 ].x1 -1) && x <= (poche.tab [ 1 ].x1 +5) &&
			y >= (poche.tab [ 1 ].y1 -5) && y <= (poche.tab [ 1 ].y1 +1)) {
			cursor_set_bas_gauche ();
			poche.move = MOVE_RECTO_COIN_BAS_GAUCHE;
		}
		else if (x >= (poche.tab [ 1 ].x2 -5) && x <= (poche.tab [ 1 ].x2 +1) &&
			y >= (poche.tab [ 1 ].y1 -5) && y <= (poche.tab [ 1 ].y1 +1)) {
			cursor_set_bas_droit ();
			poche.move = MOVE_RECTO_COIN_BAS_DROIT;
		}
		else {
			cursor_set_move ();
		}

	}
	/* Test si dans le verso */
	else if (poche.bool_file_verso_ps == TRUE &&
		x >= (poche.tab [ 4 ].x1 -1) && x <= (poche.tab [ 4 ].x2 +1) &&
		y >= (poche.tab [ 4 ].y1 -1) && y <= (poche.tab [ 5 ].y1 +1)) {

		poche.move = MOVE_VERSO;

		if (x  > (poche.tab [ 4 ].x1 +5) && x < (poche.tab [ 4 ].x2 -5) &&
			y >= (poche.tab [ 4 ].y1 -1) && y <= (poche.tab [ 4 ].y1 +1)) {
			cursor_set_haut ();
			poche.move = MOVE_VERSO_HAUT;
		}
		else if (x  > (poche.tab [ 5 ].x1 +5) && x < (poche.tab [ 5 ].x2 -5) &&
			y >= (poche.tab [ 5 ].y1 -1) && y <= (poche.tab [ 5 ].y1 +1)) {
			cursor_set_bas ();
			poche.move = MOVE_VERSO_BAS;
		}
		else if (y > (poche.tab [ 6 ].y1 +5) && y < (poche.tab [ 6 ].y2 -5) &&
			x >= (poche.tab [ 6 ].x1 -1) && x <= (poche.tab [ 6 ].x1 +1)) {
			cursor_set_gauche ();
			poche.move = MOVE_VERSO_GAUCHE;
		}
		else if (y > (poche.tab [ 7 ].y1 +5) && y < (poche.tab [ 7 ].y2 -5) &&
			x >= (poche.tab [ 7 ].x1 -1) && x <= (poche.tab [ 7 ].x1 +1)) {
			cursor_set_droit ();
			poche.move = MOVE_VERSO_DROIT;
		}
		else if (x >= (poche.tab [ 4 ].x1 -1) && x <= (poche.tab [ 4 ].x1 +5) &&
			y >= (poche.tab [ 4 ].y1 -1) && y <= (poche.tab [ 4 ].y1 +5)) {
			cursor_set_haut_gauche ();
			poche.move = MOVE_VERSO_COIN_HAUT_GAUCHE;
		}
		else if (x >= (poche.tab [ 4 ].x2 -5) && x <= (poche.tab [ 4 ].x2 +1) &&
			y >= (poche.tab [ 4 ].y1 -1) && y <= (poche.tab [ 4 ].y1 +5)) {
			cursor_set_haut_droit ();
			poche.move = MOVE_VERSO_COIN_HAUT_DROIT;
		}
		else if (x >= (poche.tab [ 5 ].x1 -1) && x <= (poche.tab [ 5 ].x1 +5) &&
			y >= (poche.tab [ 5 ].y1 -5) && y <= (poche.tab [ 5 ].y1 +1)) {
			cursor_set_bas_gauche ();
			poche.move = MOVE_VERSO_COIN_BAS_GAUCHE;
		}
		else if (x >= (poche.tab [ 5 ].x2 -5) && x <= (poche.tab [ 5 ].x2 +1) &&
			y >= (poche.tab [ 5 ].y1 -5) && y <= (poche.tab [ 5 ].y1 +1)) {
			cursor_set_bas_droit ();
			poche.move = MOVE_VERSO_COIN_BAS_DROIT;
		}
		else {
			cursor_set_move ();
		}
	}
	else {
		cursor_set_old ();
		poche.move = MOVE_NONE;
	}
	return FALSE;
}
// 
// 
void on_eventbox_image_preview_event_after (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	/*
	affiche cadre image
	affiche cadres pochette
	affiche cadre actuel des images
	*/
	gboolean bool = FALSE;
	
	if (FALSE == Config.BoolConfigOk) return;
	if (Config.NotebookGeneral != NOTEBOOK_POCHETTE) return;

	pochedraw_draw_grille_base ();
	if (poche.bool_with_get_grille_img || !bool_dedans) {
		bool = pochedraw_get_grille_img ();
		poche.bool_with_get_grille_img = FALSE;
	}
	pochedraw_draw_grille_img ();
}
// 
// 
void on_image_preview_realize (GtkWidget *widget, gpointer user_data)
{
	poche.Adr_image_preview = widget;

	PTR0 = 88;
	PTR1 = 442;
	PTR2 = 340;
	PTR3 = 340;

	PTV0 = 71;
	PTV1 = 71;
	PTV2 = 452;
	PTV3 = 331;

	poche.move = MOVE_NONE;
	poche.bool_redraw = FALSE;
	poche.bool_move = FALSE;
	poche.bool_file_recto_ps = FALSE;
	poche.bool_file_verso_ps = FALSE;
	poche.bool_with_get_grille_img = TRUE;
}
// 
// 
static void pocheevnt_drag_data_received_file (GtkWidget          *widget,
				     		GdkDragContext     *drag_context,
				     		gint                x,
				     		gint                y,
				    		GtkSelectionData   *data,
				    		guint               info,
				    		guint               time)
{
	if (PrgInit.bool_convert == FALSE) {
		g_print ("NO DRAG N DROP: PACKAGE imagemagick ABSENT !\n");

		wininfo_create (
			_("PACKAGE imagemagick ABSENT"),
			_("Le package 'imagemagick' est absent"),
			  "\n",
			_("de votre systeme !"),
			  "\n\n",
			_("Veuillez l'installer et recommencer."),
			"");

		return;
	}
	dragndrop_list_drag_data (widget, (gchar *)data->data);
}
// 
// 
void on_viewport_image_preview_realize (GtkWidget *widget, gpointer user_data)
{
	poche.Adr_table = NULL;
	poche.Adr_viewport_image_preview = widget;
	poche.bool_destroy_image = FALSE;
	poche.ptr_recto = NULL;
	poche.ptr_verso = NULL;
	poche.glist = NULL;
	pochevent_event.EndTimeout = TRUE;

pocheevnt_table_add_images_init ();

	/* Drag and drop support
	*  SIGNAL : 'drag-data-received'
	*/
	gtk_drag_dest_set (GTK_WIDGET (widget),
			   GTK_DEST_DEFAULT_MOTION |
			   GTK_DEST_DEFAULT_DROP,
			   drag_types, n_drag_types,
			   GDK_ACTION_COPY| GDK_ACTION_MOVE );
	g_signal_connect(G_OBJECT(widget),
			 "drag-data-received",
			 G_CALLBACK(pocheevnt_drag_data_received_file),
			 NULL);
}
// Choix de l'emplacement de stockage des images de la pochette
// 
void on_button_path_image_preview_realize (GtkWidget *widget, gpointer user_data)
{
	poche.Adr_button_path_images = widget;
	gtk_button_set_use_underline (GTK_BUTTON (poche.Adr_button_path_images), FALSE);
	gtk_button_set_label (GTK_BUTTON (poche.Adr_button_path_images), Config.PathStockeImagesPochette);
}
// 
// 
void pocheevnt_save_dest_images (gchar *path)
{
	g_free (poche.Path_pochette);
	poche.Path_pochette = NULL;
	g_free (Config.PathStockeImagesPochette);
	Config.PathStockeImagesPochette = NULL;
	
	poche.Path_pochette = g_strdup (path);
	Config.PathStockeImagesPochette = g_strdup (path);
	
	gtk_button_set_label (GTK_BUTTON (poche.Adr_button_path_images), path);
}
// 
// 
void on_button_path_image_preview_clicked (GtkButton *button, gpointer user_data)
{
	fileselect_create (_PATH_STOCKE_IMAGES_POCHETTE_, Config.PathStockeImagesPochette, pocheevnt_save_dest_images);
}
// 
// 
void on_togglebutton_recto_realize (GtkWidget *widget, gpointer user_data)
{
	poche.Adr_togglebutton_recto = widget;
	poche.bool_radio_recto_actif = TRUE;
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (poche.Adr_togglebutton_recto), TRUE);
}
// 
// 
void on_togglebutton_verso_realize (GtkWidget *widget, gpointer user_data)
{
	poche.Adr_togglebutton_verso = widget;
}
// 
// 
gboolean bool_togglebutton_recto_clicked_reentrance = FALSE;
// 
// 
void on_togglebutton_recto_clicked (GtkButton *button, gpointer user_data)
{
	if (!poche.Adr_togglebutton_recto || !poche.Adr_togglebutton_verso) return;
	if (bool_togglebutton_recto_clicked_reentrance) return;
	bool_togglebutton_recto_clicked_reentrance = TRUE;

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (poche.Adr_togglebutton_recto), TRUE);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (poche.Adr_togglebutton_verso), FALSE);

	poche.bool_radio_recto_actif = TRUE;

	bool_togglebutton_recto_clicked_reentrance = FALSE;
}
// 
// 
void on_togglebutton_verso_clicked (GtkButton *button, gpointer user_data)
{
	if (!poche.Adr_togglebutton_recto || !poche.Adr_togglebutton_verso) return;
	if (bool_togglebutton_recto_clicked_reentrance) return;
	bool_togglebutton_recto_clicked_reentrance = TRUE;

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (poche.Adr_togglebutton_recto), FALSE);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (poche.Adr_togglebutton_verso), TRUE);

	poche.bool_radio_recto_actif = FALSE;

	bool_togglebutton_recto_clicked_reentrance = FALSE;
}

/*
*---------------------------------------------------------------------------
* COMBOBOX
*---------------------------------------------------------------------------
*/

gdouble pocheevnt_get_percent_zoom (void)
{
	gint     nmr = DEFAULT_ZOOM_POCHETTE;	/* par defaut = 60 % */
	gdouble  percent[ 20 ] = { 50.0,  55.0,  60.0,  65.0,  70.0,
				   75.0,  80.0,  85.0,  90.0,  95.0,
				  100.0, 105.0, 110.0, 115.0, 120.0,
				  125.0, 130.0, 135.0, 140.0, 145.0};

	if (poche.Adr_combo_zoom)
		nmr = gtk_combo_box_get_active (GTK_COMBO_BOX (poche.Adr_combo_zoom));

	return ((gdouble)percent [ nmr ]);
}
// 
// 
void on_combobox_zoom_choiximage_realize (GtkWidget *widget, gpointer user_data)
{
	libcombo_alloc (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "  50 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "  55 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "  60 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "  65 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "  70 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "  75 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "  80 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "  85 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "  90 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "  95 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 100 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 105 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 110 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 115 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 120 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 125 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 130 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 135 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 140 %  ");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 145 %  ");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), DEFAULT_ZOOM_POCHETTE);
	poche.Adr_combo_zoom = GTK_COMBO_BOX (widget);
}
// 
// 
void on_combobox_zoom_choiximage_changed (GtkComboBox *combobox, gpointer user_data)
{
	if (NULL == poche.Adr_combo_zoom) return;
	pochetimer_action (PTIMER_DISABLE, PTIMER_DISABLE, PRINTIMAGE, PTIMER_DISABLE, PTIMER_DISABLE);
	/*
	pochegen_affiche_image ();
	*/
}
// 
// 
void pocheevnt_set_flag (gboolean Enable)
{
	/* Image */
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("image_preview")), Enable);
	/* Choix images*/
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("frame59")), Enable);
	/* Notebook */
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("notebook_pochette")), Enable);
	/* Voir / Avec */
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("frame60")), Enable);
	/* Construire */
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("frame92")), Enable);
}
// 
// 
void pocheevnt_set_flag_buttons_preview (void)
{
	if (PrgInit.bool_convert == FALSE) {
		gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("togglebutton_recto")), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("togglebutton_verso")), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("eventbox_combobox_zoom_choiximage")), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_load_choiximage")), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("togglebutton_remove")), FALSE);
	}
	else if (poche.bool_destroy_image == TRUE) {
		gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("togglebutton_recto")), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("togglebutton_verso")), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("eventbox_combobox_zoom_choiximage")), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_load_choiximage")), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("togglebutton_remove")), TRUE);
	}
	else {
		gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("togglebutton_recto")), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("togglebutton_verso")), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("eventbox_combobox_zoom_choiximage")), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_load_choiximage")), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("togglebutton_remove")), TRUE);
	}
}
// 
// 
void on_togglebutton_remove_clicked (GtkButton *button, gpointer user_data)
{
	GLIST_POCHETTE *gl = NULL;
	GList          *list = NULL;

	poche.bool_destroy_image = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (poche.Adr_togglebutton_remove));
	pocheevnt_set_flag_buttons_preview ();

	if (bool_togglebutton_clicked_reentrance == TRUE) return;
	bool_togglebutton_clicked_reentrance = TRUE;

	/* Desactiver tous les boutons sauf user_data */
	if (poche.bool_destroy_image == TRUE) {
		list = g_list_first (poche.glist);
		while (list) {
			if ((gl = (GLIST_POCHETTE *)list->data)) {
				gtk_widget_set_size_request (gl->togglebutton, 95, 95);
				gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gl->togglebutton), FALSE);
			}
			list = g_list_next (list);
		}
	}
	else {
		bool_togglebutton_clicked_reentrance = FALSE;
		bool_togglebutton_recto_clicked_reentrance = FALSE;
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (poche.Adr_togglebutton_recto), FALSE);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (poche.Adr_togglebutton_recto), TRUE);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (poche.Adr_togglebutton_verso), FALSE);
		// pocheevnt_togglebutton_recto_clicked ();
		on_togglebutton_recto_clicked (NULL, NULL);
	}
	bool_togglebutton_clicked_reentrance = FALSE;
}
// 
// 
void on_togglebutton_remove_realize (GtkWidget *widget, gpointer user_data)
{
	poche.Adr_togglebutton_remove = widget;
}

/*
*---------------------------------------------------------------------------
* INITIALISATION
*---------------------------------------------------------------------------
*/

// 
// 
void pocheevnt_init (void)
{
	gchar   *LineCommand = NULL;

	pochedraw_get_grille_img ();

	/* Creation dossiers */
	g_free(poche.Path_pochette);
	poche.Path_pochette = NULL;
	poche.Path_pochette = g_strdup (Config.PathStockeImagesPochette);

	/* Creation des pathnames */
	poche.file_preview_pdf  = NULL;

	poche.Path_pochette_base = libutils_create_temporary_rep (Config.PathnameTMP, PATH_SAVE_POCHETTE_IMG);
	poche.Path_pochette_ps   = libutils_create_temporary_rep (Config.PathnameTMP, PATH_SAVE_POCHETTE_PS);
	poche.Path_pochette_png  = libutils_create_temporary_rep (Config.PathnameTMP, PATH_SAVE_POCHETTE_PNG);
	
	/* Creation des referants aux fichiers */
	poche.file_recto_ps     = g_strdup_printf ("%s/recto.ps", poche.Path_pochette_ps);
	poche.file_verso_ps     = g_strdup_printf ("%s/verso.ps", poche.Path_pochette_ps);
	poche.file_preview_ps   = g_strdup_printf ("%s/preview.ps", poche.Path_pochette_ps);
	poche.file_preview_png  = g_strdup_printf ("%s/preview.png", poche.Path_pochette_ps);

	/* Copie de l'image */
	
	LineCommand = g_strdup_printf ("%s/pixmaps/xcfa/preview.png", PACKAGE_DATA_DIR);
	// LineCommand = g_strdup_printf ("%s", utils_get_pathname ("preview.png"));
	
	conv_copy_src_to_dest (LineCommand, poche.file_preview_png);
	g_free (LineCommand);
	LineCommand = NULL;

	/* Nettoyage de l'affichage et gagne du temps pour la copie de 'preview.png' */
	gdk_window_clear (poche.Adr_image_preview->window);
	
	/* Affiche l'image */
	LineCommand = g_strdup (poche.file_preview_png);
	gtk_image_set_from_file (GTK_IMAGE (poche.Adr_image_preview), LineCommand);
	g_free (LineCommand);
	LineCommand = NULL;
	
	pocheevnt_set_flag_buttons_recto ();
	pocheevnt_set_flag_buttons_verso ();
	pocheevnt_set_flag_buttons_preview ();
	
	poche.bool_with_get_grille_img = TRUE;

	/*
	if (prginit_get_etat () == TRUE && pocheevnt_init_images_xcfa () == TRUE && fileanalyze_linecommand_exist () == FALSE) {
		if (pocheevnt_get_load_images_init_xcfa () == TRUE) {
			// La creation GTK n'est pas permise de puis un thread
	  		// ---------------------------------------------------
			winpulse_create ();
			winpulse_set_init_pulse ();
			winpulse_set_title (_("Chargement des images"));
			winpulse_set_labeltitle (_("Chargement des images"));

			pochevent_event.EndThread = FALSE;
			pochevent_event.AfficheImage = FALSE;
			pochevent_event.AjouteTable = FALSE;
			pochevent_event.timeout = gtk_timeout_add (500, pocheevnt_initialisation_timeout, 0);
			secu_thread_add ();
			pthread_create (&pochevent_event.nmr_tid, NULL ,(void *)pocheevnt_initialisation_thread, (void *)NULL);

			// DEBUG
			// pthread_detach (pochevent_event.nmr_tid);
		}
	}
	*/
}

/*
*---------------------------------------------------------------------------
* CHOIX VIGNETTES IMAGES
*---------------------------------------------------------------------------
*/

void pocheevnt_button_load_choiximage_action (gchar *path)
{
	if (NULL != Config.PathLoadImages) {
		g_free (Config.PathLoadImages);
		Config.PathLoadImages = NULL;
	}
	Config.PathLoadImages = g_strdup (path);
}
// 
// 
void on_button_load_choiximage_clicked (GtkButton *button, gpointer user_data)
{
	fileselect_create (_PATH_IMPORT_IMAGES_, Config.PathLoadImages, pocheevnt_button_load_choiximage_action);
}

/*
*---------------------------------------------------------------------------
* PRINT TAB RECTO-VERSO
*---------------------------------------------------------------------------
*/

// 
// 
void pocheevnt_print_percent (void)
{
}
// 
// 
void pocheevnt_print_tab_recto (void)
{
	return;
	g_print ("\tRECTO-> GAUCHE %3d, BAS %3d, LARGEUR %3d, HAUTEUR %3d\n", PTR0, PTR1, PTR2, PTR3);
}
// 
// 
void pocheevnt_print_tab_verso (void)
{
	return;
	g_print ("\tVERSO-> GAUCHE %3d, BAS %3d, LARGEUR %3d, HAUTEUR %3d\n", PTV0, PTV1, PTV2, PTV3);
}

/*
*---------------------------------------------------------------------------
* BUTTON RECTO
*---------------------------------------------------------------------------
*/

// 
// 
void pocheevnt_set_flag_buttons_recto (void)
{
	gboolean bool_recto = TRUE;
	gboolean bool_move_gauche = TRUE;
	gboolean bool_move_haut = TRUE;
	gboolean bool_move_bas = TRUE;
	gboolean bool_move_droite = TRUE;
	gboolean bool_gauche_moins = TRUE;
	gboolean bool_gauche_plus = TRUE;
	gboolean bool_droite_moins = TRUE;
	gboolean bool_droite_plus = TRUE;
	gboolean bool_haut_vers_haut = TRUE;
	gboolean bool_haut_vers_bas = TRUE;
	gboolean bool_bas_vers_haut = TRUE;
	gboolean bool_bas_vers_bas = TRUE;
	gboolean bool_recto_zoom = TRUE;
	gboolean bool_combo_recto_action = TRUE;

	if (PTR0 <= RECTO_GAUCHE) 		bool_move_gauche = FALSE;
	if (PTR1 + PTR3 >= RECTO_MAX_HAUTEUR) 	bool_move_haut = FALSE;
	if (PTR1 <= RECTO_BAS) 			bool_move_bas = FALSE;
	if (PTR0 + PTR2 >= RECTO_MAX_LARGEUR) 	bool_move_droite = FALSE;
	if (PTR0 <= RECTO_GAUCHE) 		bool_gauche_moins = FALSE;
	if (PTR2 <= RECTO_MIN_LH) 		bool_gauche_plus = FALSE;
	if (PTR2 <= RECTO_MIN_LH) 		bool_droite_moins = FALSE;
	if (PTR0 + PTR2 >= RECTO_MAX_LARGEUR) 	bool_droite_plus = FALSE;
	if (PTR1 + PTR3 >= RECTO_MAX_HAUTEUR) 	bool_haut_vers_haut = FALSE;
	if (PTR3 <= RECTO_MIN_LH) 		bool_haut_vers_bas = FALSE;
	if (PTR3 <= RECTO_MIN_LH) 		bool_bas_vers_haut = FALSE;
	if (PTR1 <= RECTO_BAS) 			bool_bas_vers_bas = FALSE;

	bool_recto = poche.file_recto_ps && libutils_test_file_exist (poche.file_recto_ps);
	if (!bool_recto) {
		bool_recto_zoom = FALSE;
		bool_combo_recto_action = FALSE;
		bool_move_gauche = FALSE;
		bool_move_haut = FALSE;
		bool_move_bas = FALSE;
		bool_move_droite = FALSE;
		bool_gauche_moins = FALSE;
		bool_gauche_plus = FALSE;
		bool_droite_moins = FALSE;
		bool_droite_plus = FALSE;
		bool_haut_vers_haut = FALSE;
		bool_haut_vers_bas = FALSE;
		bool_bas_vers_haut = FALSE;
		bool_bas_vers_bas = FALSE;
	}
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("spinbutton_zoom_recto")), bool_recto_zoom);
}

/*
*---------------------------------------------------------------------------
* BUTTON VERSO
*---------------------------------------------------------------------------
*/

// 
// 
void pocheevnt_set_flag_buttons_verso (void)
{
	gboolean bool_verso = TRUE;
	gboolean bool_verso_zoom = TRUE;
	gboolean bool_combo_verso_action = TRUE;
	gboolean bool_move_gauche = TRUE;
	gboolean bool_move_haut = TRUE;
	gboolean bool_move_bas = TRUE;
	gboolean bool_move_droite = TRUE;
	gboolean bool_gauche_moins = TRUE;
	gboolean bool_gauche_plus = TRUE;
	gboolean bool_droite_moins = TRUE;
	gboolean bool_droite_plus = TRUE;
	gboolean bool_haut_vers_haut = TRUE;
	gboolean bool_haut_vers_bas = TRUE;
	gboolean bool_bas_vers_haut = TRUE;
	gboolean bool_bas_vers_bas = TRUE;

	if (PTV0 <= VERSO_GAUCHE) 		bool_move_gauche = FALSE;
	if (PTV1 + PTV3 >= VERSO_MAX_HAUTEUR) 	bool_move_haut = FALSE;
	if (PTV1 <= VERSO_BAS) 			bool_move_bas = FALSE;
	if (PTV0 + PTV2 >= VERSO_MAX_LARGEUR) 	bool_move_droite = FALSE;
	if (PTV0 <= VERSO_GAUCHE) 		bool_gauche_moins = FALSE;
	if (PTV2 <= VERSO_MIN_LH) 		bool_gauche_plus = FALSE;
	if (PTV2 <= VERSO_MIN_LH) 		bool_droite_moins = FALSE;
	if (PTV0 + PTV2 >= VERSO_MAX_LARGEUR) 	bool_droite_plus = FALSE;
	if (PTV1 + PTV3 >= VERSO_MAX_HAUTEUR) 	bool_haut_vers_haut = FALSE;
	if (PTV3 <= VERSO_MIN_LH) 		bool_haut_vers_bas = FALSE;
	if (PTV3 <= VERSO_MIN_LH) 		bool_bas_vers_haut = FALSE;
	if (PTV1 <= VERSO_BAS) 			bool_bas_vers_bas = FALSE;

	bool_verso = poche.file_verso_ps && libutils_test_file_exist (poche.file_verso_ps);
	if (!bool_verso) {
		bool_verso_zoom = FALSE;
		bool_combo_verso_action = FALSE;
		bool_move_gauche = FALSE;
		bool_move_haut = FALSE;
		bool_move_bas = FALSE;
		bool_move_droite = FALSE;
		bool_gauche_moins = FALSE;
		bool_gauche_plus = FALSE;
		bool_droite_moins = FALSE;
		bool_droite_plus = FALSE;
		bool_haut_vers_haut = FALSE;
		bool_haut_vers_bas = FALSE;
		bool_bas_vers_haut = FALSE;
		bool_bas_vers_bas = FALSE;
	}
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("spinbutton_zoom_verso")), bool_verso_zoom);
}

/*
*---------------------------------------------------------------------------
* SPINBUTTON
*---------------------------------------------------------------------------
*/

// 
// 
gboolean bool_button_press = FALSE;
gboolean bool_button_release = FALSE;
// 
// 
static gint poche_handler_timeout_spinbutton (gpointer data)
{
	if (bool_button_release == TRUE) {
		gtk_timeout_remove (pochevent_event.timeout);
cursor_set_watch ();
pocheevnt_set_flag (FALSE);
		bool_button_press = FALSE;
		bool_button_release = FALSE;
		pochevent_event.EndTimeout = TRUE;
		pochegen_gen_code_postscript ();
		pochegen_affiche_image ();
		pocheevnt_set_flag_buttons_recto ();
		pocheevnt_set_flag_buttons_verso ();
cursor_set_old ();
pocheevnt_set_flag (TRUE);
	}
	return TRUE;
}
// 
// 
gboolean on_spinbutton_zoom_recto_button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	bool_button_press = TRUE;
	return FALSE;
}
// 
// 
gboolean on_spinbutton_zoom_recto_button_release_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	bool_button_press = FALSE;
	bool_button_release = TRUE;
	return FALSE;
}
// 
// 
gboolean on_spinbutton_zoom_verso_button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	bool_button_press = TRUE;
	return (FALSE);
}
// 
// 
gboolean on_spinbutton_zoom_verso_button_release_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	bool_button_press = FALSE;
	bool_button_release = TRUE;
	return (FALSE);
}

/*
*---------------------------------------------------------------------------
* SPINBUTTON RECTO
*---------------------------------------------------------------------------
*/

// 
// 
void on_spinbutton_zoom_recto_value_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
	gint value = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spinbutton));
	gdouble percent = 100.0 - (gdouble)value;
	gdouble taille = 340.0 - 88.0;
	gdouble result;

	taille -= 110.0;

	if (pochevent_event.EndTimeout == TRUE) {
		pochevent_event.EndTimeout = FALSE;
		bool_button_release = FALSE;
		pochevent_event.timeout = gtk_timeout_add (4, poche_handler_timeout_spinbutton, 0);
	}

	result = (gint)((gdouble)percent * (gdouble)taille) / 100.0;

	PTR2 = (gint)(340.0 - (result * 2));
	PTR3 = (gint)(340.0 - (result * 2));

	while (PTR0 + PTR2 > RECTO_MAX_LARGEUR) PTR0 --;
	while (PTR1 + PTR3 > RECTO_MAX_HAUTEUR) PTR1 --;

	pocheevnt_print_tab_recto ();

	if (bool_button_press == FALSE) {
		bool_button_release = TRUE;
	}
}

/*
*---------------------------------------------------------------------------
* SPINBUTTON VERSO
*---------------------------------------------------------------------------
*/

// 
// 
void on_spinbutton_zoom_verso_value_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
	gint value = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spinbutton));
	gdouble percent = 100.0 - (gdouble)value;
	gdouble tailleL = 452.0 - 71.0;
	gdouble tailleH = 331.0 - 71.0;
	gdouble resultL;
	gdouble resultH;

	tailleL -= 180.0;
	tailleH -= 120.0;

	if (pochevent_event.EndTimeout == TRUE) {
		pochevent_event.EndTimeout = FALSE;
		bool_button_release = FALSE;
		pochevent_event.timeout = gtk_timeout_add (4, poche_handler_timeout_spinbutton, 0);
	}

	resultL = (gint)((gdouble)percent * (gdouble)tailleL) / 100.0;
	resultH = (gint)((gdouble)percent * (gdouble)tailleH) / 100.0;

	PTV2 = (gint)(452.0 - (resultL * 2));
	PTV3 = (gint)(331.0 - (resultH * 2));

	while (PTV0 + PTV2 > VERSO_MAX_LARGEUR) PTV0 --;
	while (PTV1 + PTV3 > VERSO_MAX_HAUTEUR) PTV1 --;

	pocheevnt_print_tab_verso ();

	if (bool_button_press == FALSE) {
		bool_button_release = TRUE;
	}
}

/*
*---------------------------------------------------------------------------
* POPUP ACTION
*---------------------------------------------------------------------------
*/

// 
// 
void pocheevnt_action_popup (gboolean is_recto, gint val_action)
{
	if (is_recto) {
		switch (val_action) {
		case 0 :
			PTR0 = RECTO_GAUCHE + ((RECTO_LARGEUR - PTR2) / 2);
			PTR1 = RECTO_BAS + ((RECTO_HAUTEUR - PTR3) / 2);
			break;
		case 1 :
			PTR0 = RECTO_GAUCHE + ((RECTO_LARGEUR - PTR2) / 2);
			break;
		case 2 :
			PTR1 = RECTO_BAS + ((RECTO_HAUTEUR - PTR3) / 2);
			break;
		}
	}
	else {
		switch (val_action) {
		case 0 :
			PTV0 = VERSO_GAUCHE + ((VERSO_LARGEUR - PTV2) / 2);
			PTV1 = VERSO_BAS + ((VERSO_HAUTEUR - PTV3) / 2);
			break;
		case 1 :
			PTV0 = VERSO_GAUCHE + ((VERSO_LARGEUR - PTV2) / 2);
			break;
		case 2 :
			PTV1 = VERSO_BAS + ((VERSO_HAUTEUR - PTV3) / 2);
			break;
		}
	}
	poche.bool_redraw = TRUE;
	cursor_set_watch ();
	pocheevnt_set_flag (FALSE);
	pochegen_gen_code_postscript ();
	pochegen_affiche_image ();
	pocheevnt_set_flag_buttons_recto ();
	pocheevnt_set_flag_buttons_verso ();
	pocheevnt_set_flag_buttons_preview ();
	pocheevnt_set_flag (TRUE);
	cursor_set_old ();
	poche.bool_redraw = FALSE;
	poche.bool_move = FALSE;
}

/*
*---------------------------------------------------------------------------
* TITRE
*---------------------------------------------------------------------------
*/

// 
// 
gchar *pocheevnt_get_entry_titre_ps (void)
{
	if (!poche.Adr_entry_title) return (NULL);
	return ((gchar *)gtk_entry_get_text (GTK_ENTRY (poche.Adr_entry_title)));
}
// 
// 
void on_entry_titre_ps_realize (GtkWidget *widget, gpointer user_data)
{
	poche.Adr_entry_title = widget;
	gtk_entry_set_text (GTK_ENTRY (poche.Adr_entry_title), "*");
	gtk_entry_set_text (GTK_ENTRY (poche.Adr_entry_title), "");
}
// 
// 
void on_entry_titre_ps_changed (GtkEditable *editable, gpointer user_data)
{
	gboolean bool = FALSE;
	gint     num;

	if (!poche.Adr_combobox_entry_title) return;
	bool = *pocheevnt_get_entry_titre_ps () ? TRUE : FALSE;
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("eventbox_combobox_entry_title")), bool);
	num = gtk_combo_box_get_active (GTK_COMBO_BOX (poche.Adr_combobox_entry_title));
	if (num != 3)
		pochetimer_action (PTIMER_ENABLE, GENPOSTSCRIPT, PRINTIMAGE, FLAGSRECTO, FLAGSVERSO);
}
// 
// 
void on_combobox_entry_title_realize (GtkWidget *widget, gpointer user_data)
{
	libcombo_alloc (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Recto");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Verso");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Recto et Verso");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Aucun");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
	poche.Adr_combobox_entry_title = GTK_COMBO_BOX (widget);
	if (poche.Adr_entry_title) {
		gtk_entry_set_text (GTK_ENTRY (poche.Adr_entry_title), "*");
		gtk_entry_set_text (GTK_ENTRY (poche.Adr_entry_title), "");
	}
}
// 
// 
void on_combobox_entry_title_changed (GtkComboBox *combobox, gpointer user_data)
{
	if (!poche.Adr_combobox_entry_title) return;
	if (!poche.Adr_entry_title) return;

	pochetimer_action (PTIMER_DISABLE, GENPOSTSCRIPT, PRINTIMAGE, FLAGSRECTO, FLAGSVERSO);
}

/*
*---------------------------------------------------------------------------
* PIED DE PAGE
*---------------------------------------------------------------------------
*/

// 
// 
gchar *pocheevnt_get_entry_foottext_ps (void)
{
	if (!poche.Adr_entry_foottext) return (NULL);
	return ((gchar *)gtk_entry_get_text (GTK_ENTRY (poche.Adr_entry_foottext)));
}
// 
// 
void on_entry_foottext_ps_realize (GtkWidget *widget, gpointer user_data)
{
	poche.Adr_entry_foottext = widget;
	gtk_entry_set_text (GTK_ENTRY (poche.Adr_entry_foottext), "*");
	gtk_entry_set_text (GTK_ENTRY (poche.Adr_entry_foottext), "");
}
// 
// 
void on_entry_foottext_ps_changed (GtkEditable *editable, gpointer user_data)
{
	gboolean bool = FALSE;
	gint     num;

	if (!poche.Adr_combobox_entry_foottext) return;
	if (!poche.Adr_entry_foottext) return;
	bool = *pocheevnt_get_entry_foottext_ps () ? TRUE : FALSE;
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("eventbox_combobox_foottext_ps")), bool);

	num = gtk_combo_box_get_active (GTK_COMBO_BOX (poche.Adr_combobox_entry_foottext));
	if (num != 3)
		pochetimer_action (PTIMER_ENABLE, GENPOSTSCRIPT, PRINTIMAGE, FLAGSRECTO, FLAGSVERSO);
}
// 
// 
void on_combobox_foottext_ps_realize (GtkWidget *widget, gpointer user_data)
{
	libcombo_alloc (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Recto");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Verso");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Recto et Verso");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Aucun");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
	poche.Adr_combobox_entry_foottext = GTK_COMBO_BOX (widget);
	if (poche.Adr_entry_foottext) {
		gtk_entry_set_text (GTK_ENTRY (poche.Adr_entry_foottext), "*");
		gtk_entry_set_text (GTK_ENTRY (poche.Adr_entry_foottext), "");
	}
}
// 
// 
void on_combobox_foottext_ps_changed (GtkComboBox *combobox, gpointer user_data)
{
	if (!poche.Adr_combobox_entry_foottext) return;
	if (!poche.Adr_entry_foottext) return;

	pochetimer_action (PTIMER_DISABLE, GENPOSTSCRIPT, PRINTIMAGE, FLAGSRECTO, FLAGSVERSO);
}

/*
*---------------------------------------------------------------------------
* TEXTE
*---------------------------------------------------------------------------
*/

// 
// 
void on_combobox_text_recto_realize (GtkWidget *widget, gpointer user_data)
{
	libcombo_alloc (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Auteur - titre - temps");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Auteur - titre");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Auteur - temps");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Auteur");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Titre - temps");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Titre");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Aucun");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 6);
	poche.Adr_combobox_text_recto = GTK_COMBO_BOX (widget);
}
// 
// 
void on_combobox_text_recto_changed (GtkComboBox *combobox, gpointer user_data)
{
	if (!poche.Adr_combobox_text_recto) return;

	pochetimer_action (PTIMER_DISABLE, GENPOSTSCRIPT, PRINTIMAGE, FLAGSRECTO, FLAGSVERSO);
}
// 
// 
void on_combobox_text_verso_realize (GtkWidget *widget, gpointer user_data)
{
	libcombo_alloc (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Auteur - titre - temps");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Auteur - titre");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Auteur - temps");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Auteur");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Titre - temps");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Titre");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Aucun");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 6);
	poche.Adr_combobox_text_verso = GTK_COMBO_BOX (widget);
}
// 
// 
void on_combobox_text_verso_changed (GtkComboBox *combobox, gpointer user_data)
{
	if (!poche.Adr_combobox_text_verso) return;

	pochetimer_action (PTIMER_DISABLE, GENPOSTSCRIPT, PRINTIMAGE, FLAGSRECTO, FLAGSVERSO);
}
// 
// 
void on_combobox_link_fields_realize (GtkWidget *widget, gpointer user_data)
{
	libcombo_alloc (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Recto");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Verso");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Recto et Verso");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Aucun");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
	poche.Adr_combobox_link_fields = GTK_COMBO_BOX (widget);
}
// 
// 
void on_combobox_link_fields_changed (GtkComboBox *combobox, gpointer user_data)
{
	if (!poche.Adr_combobox_link_fields) return;

	pochetimer_action (PTIMER_DISABLE, GENPOSTSCRIPT, PRINTIMAGE, FLAGSRECTO, FLAGSVERSO);
}
// 
// 
void on_button_liste_numerate_realize (GtkWidget *widget, gpointer user_data)
{
	poche.Adr_button_liste_numerate = widget;
}

/*
*---------------------------------------------------------------------------
* NUMEROTATION DES LIGNES DE TEXTE
*---------------------------------------------------------------------------
*/

// 
// 
gint pocheevnt_get_nbr_car_to_del (gchar *Buffer)
{
	gchar *Ptr = Buffer;

	/*
	while (*Ptr && *Ptr == ' ') Ptr ++;
	while (*Ptr && (*Ptr >= '0' && *Ptr <= '9')) Ptr ++;
	while (*Ptr && *Ptr == ' ') Ptr ++;
	return (Ptr - Buffer);
	*/
	/* CORRECTIF DU 15 12 2005 */
	while (*Ptr) {
		if (((*Ptr >= '0') && (*Ptr <= '9')) || (*Ptr == ' ') || (*Ptr == '\t')) Ptr ++;
		else break;
	}
	return (Ptr - Buffer);
}
// 
// 
gboolean pocheevnt_get_bool_numerate_texte (void)
{
	// gchar         *Ptr_Buf = NULL;
	gchar         *Ptr = NULL;
	GtkTextBuffer *Buf = NULL;
	GtkTextIter    Start;
	GtkTextIter    End;
	gint           Total_Line = 0;
	gint           Cpt;
	// gchar         *PtrDummy = NULL;

	// PRINT_FUNC_LF();
	
	Buf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (poche.Adr_textview));
	Total_Line = gtk_text_buffer_get_line_count (Buf);
	for (Cpt = 0; Cpt < Total_Line; Cpt ++) {
		Buf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (poche.Adr_textview));
		gtk_text_buffer_get_iter_at_line_offset (Buf, &Start, Cpt, 0);
		gtk_text_buffer_get_end_iter (Buf, &End);
				
		Ptr = gtk_text_buffer_get_text (Buf, &Start, &End, FALSE);
		// Ptr = g_locale_from_utf8 (PtrDummy, -1, NULL, NULL, NULL);
		// g_free (PtrDummy);
		// PtrDummy = NULL;
		// Ptr = Ptr_Buf = g_locale_from_utf8 (gtk_text_buffer_get_text (Buf, &Start, &End, FALSE), -1, NULL, NULL, NULL);

		while (*Ptr && (*Ptr == ' ' || *Ptr == '\t')) Ptr ++;
		if (*Ptr && (*Ptr >= '0') && (*Ptr <= '9')) return (TRUE);
		
		g_free (Ptr);
		Ptr = NULL;
	}
	return (FALSE);
}
// 
// 
void pocheevnt_button_numerate_texte (void)
{
	gboolean       Bool_Toggle = TRUE;

	GtkTextBuffer *Buf = NULL;
	GtkTextIter    Start;
	GtkTextIter    End;
	gint           Total_Line = 0;
	gint           Cpt;
	gchar         *StrNum = NULL;
	gchar         *Ptr_Buf = NULL;
	gint           Count_Line = 1;
	gint           Count_Num_Del;
	gchar         *PtrDummy = NULL;

	// PRINT_FUNC_LF();
	
	Bool_Toggle = pocheevnt_get_bool_numerate_texte ();

	Buf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (poche.Adr_textview));
	Total_Line = gtk_text_buffer_get_line_count (Buf);
	for (Cpt = 0; Cpt < Total_Line; Cpt ++) {

		/*Bool_Toggle = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (Adr_Checkbutton_Number_Line));*/

		/* SI LE TOGGLE EST EN SELECTION -> NUMEROTATION
		*/
		if (Bool_Toggle == FALSE) {

			Buf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (poche.Adr_textview));
			gtk_text_buffer_get_iter_at_line_offset (Buf, &Start, Cpt, 0);
			gtk_text_buffer_get_end_iter (Buf, &End);
			/*Ptr_Buf = gtk_text_buffer_get_text (Buf, &Start, &End, FALSE);*/

			PtrDummy = gtk_text_buffer_get_text (Buf, &Start, &End, FALSE);
			Ptr_Buf = g_locale_from_utf8 (PtrDummy, -1, NULL, NULL, NULL);
			g_free (PtrDummy);
			PtrDummy = NULL;
			// Ptr_Buf = g_locale_from_utf8 (gtk_text_buffer_get_text (Buf, &Start, &End, FALSE), -1, NULL, NULL, NULL);

			if (Ptr_Buf && *Ptr_Buf >= ' ') {
				gtk_text_buffer_get_iter_at_line (Buf, &Start, Cpt);
				StrNum = g_strdup_printf ("%02d  ", Count_Line);
				gtk_text_buffer_insert (Buf, &Start, StrNum, -1);
				Count_Line ++;
			}
		}
		/* SINON -> SUPPRESSION NUMEROTATION
		*/
		else {
			Buf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (poche.Adr_textview));
			gtk_text_buffer_get_iter_at_line_offset (Buf, &Start, Cpt, 0);
			gtk_text_buffer_get_end_iter (Buf, &End);
			/*Ptr_Buf = gtk_text_buffer_get_text (Buf, &Start, &End, FALSE);*/

			PtrDummy = gtk_text_buffer_get_text (Buf, &Start, &End, FALSE);
			Ptr_Buf = g_locale_from_utf8 (PtrDummy, -1, NULL, NULL, NULL);
			g_free (PtrDummy);
			PtrDummy = NULL;
			// Ptr_Buf = g_locale_from_utf8 (gtk_text_buffer_get_text (Buf, &Start, &End, FALSE), -1, NULL, NULL, NULL);

			if ( (Count_Num_Del = pocheevnt_get_nbr_car_to_del (Ptr_Buf)) > 0) {
				gtk_text_buffer_get_iter_at_line_offset (Buf, &End, Cpt, Count_Num_Del);
				gtk_text_buffer_delete (Buf, &Start, &End);
			}
		}
	}
}
// 
// 
void on_button_liste_numerate_clicked (GtkButton *button, gpointer user_data)
{
	if (!poche.Adr_button_liste_numerate) return;

	// PRINT_FUNC_LF();
	pocheevnt_button_numerate_texte ();
	if (gtk_combo_box_get_active (GTK_COMBO_BOX (poche.Adr_combobox_text_recto)) <= 5 ||
	    gtk_combo_box_get_active (GTK_COMBO_BOX (poche.Adr_combobox_text_verso)) <= 5)
		pochetimer_action (PTIMER_DISABLE, GENPOSTSCRIPT, PRINTIMAGE, FLAGSRECTO, FLAGSVERSO);
}

/*
*---------------------------------------------------------------------------
* TEXTVIEW
*---------------------------------------------------------------------------
*/

// Retourne un pointeur sur le texte du buffer
// 
gchar *pocheevnt_get_etat_textview (void)
{
	GtkTextBuffer *Buf = NULL;
	gchar         *Ptr = NULL;
	GtkTextIter    Start;
	GtkTextIter    End;
	gchar         *PtrDummy = NULL;

	Buf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (poche.Adr_textview));
	gtk_text_buffer_get_bounds (Buf, &Start, &End);

	PtrDummy = gtk_text_buffer_get_text (Buf, &Start, &End, FALSE);
	Ptr = g_locale_from_utf8 (PtrDummy, -1, NULL, NULL, NULL);
	g_free (PtrDummy);
	PtrDummy = NULL;
	// Ptr = g_locale_from_utf8 (gtk_text_buffer_get_text (Buf, &Start, &End, FALSE), -1, NULL, NULL, NULL);

	return (Ptr);
}
// Signal 'changed' in TextView
// 
void pocheevnt_texte_changed_in_textview (GtkTextBuffer *textbuffer, gpointer user_data)
{
	gboolean bool = FALSE;

	if (*pocheevnt_get_etat_textview () != '\0') {
		bool = TRUE;
	}
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("eventbox_combobox_text_recto")), bool);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("eventbox_combobox_text_verso")), bool);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("eventbox_combobox_link_fields")), bool);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_liste_numerate")), bool);

	if (textbuffer) {
		if (gtk_combo_box_get_active (GTK_COMBO_BOX (poche.Adr_combobox_text_recto)) < 6 ||
				gtk_combo_box_get_active (GTK_COMBO_BOX (poche.Adr_combobox_text_verso)) < 6) {
			pochetimer_action (PTIMER_ENABLE, GENPOSTSCRIPT, PRINTIMAGE, FLAGSRECTO, FLAGSVERSO);
		}
	}
}
// 
// 
void pocheevnt_insere_texte (gchar *buffer)
{
	GtkTextBuffer  *Buf = NULL;
	gchar         **Larrbuf = NULL;
	gchar          *Ptr = NULL;
	gint            i;			/* Counter */
	gboolean        bool_file = FALSE;
	gchar          *NewBuf = NULL;
	gchar          *Ptrn = NULL;
	gchar          *ptr_time = NULL;

	Larrbuf = g_strsplit(buffer, "\n", 0);
	/* nouveau buffer */
	Ptrn = NewBuf = g_strnfill (strlen (buffer) +8, '\0');

	for (i=0; Larrbuf[i]; i++) {

		/* delette end cars */
		if ((Ptr = strrchr (Larrbuf[i], 13))) *Ptr = '\0';
		if ((Ptr = strrchr (Larrbuf[i], 10))) *Ptr = '\0';

		if (ptr_time) {
			g_free (ptr_time);
			ptr_time = NULL;
		}
		bool_file = FALSE;
		Ptr = Larrbuf[i];
		if (*Ptr == '/') {
			if (strstr (Larrbuf[i], ".wav")) {
				bool_file = TRUE;
				ptr_time = tags_get_time_wav (Larrbuf[i]);
			}
			else if (strstr (Larrbuf[i], ".mp3")) {
				bool_file = TRUE;
				ptr_time = tags_get_time (Larrbuf[i]);
			}
			else if (strstr (Larrbuf[i], ".flac")) {
				bool_file = TRUE;
				ptr_time = tags_get_time (Larrbuf[i]);
			}
			else if (strstr (Larrbuf[i], ".ogg")) {
				bool_file = TRUE;
				ptr_time = tags_get_time (Larrbuf[i]);
			}
			if (bool_file) {
				/* cherche le debut du nom du fichier pour copie dans le buffer textview */
				Ptr = strrchr (Larrbuf[i], '/');
				Ptr ++;
				while (*Ptr) *Ptrn ++ = *Ptr ++;
				/* Ne pas inclure l'extention */
				Ptrn = strrchr (NewBuf, '.');
				/* Inclure le temps d'ecoute */
				if (NULL != ptr_time) {
					*Ptrn ++ = ' ';
					*Ptrn ++ = '-';
					*Ptrn ++ = ' ';
					Ptr = ptr_time;
					while (*Ptr) *Ptrn ++ = *Ptr ++;
				}
				*Ptrn ++ = '\n';
				Ptr = Ptrn;
				*Ptr ++ = '\0';
				*Ptr ++ = '\0';
				*Ptr ++ = '\0';
				*Ptr ++ = '\0';
				*Ptr ++ = '\0';

				g_free (ptr_time);
				ptr_time = NULL;
			}

			/* Ne pas bloquer l'application
			*  --
			*  Il est egalement possible de passer la fonction
			*  'void pochette_insere_texte (gchar *Texte)' en thread avec un
			*  gtk_timeout_add et un gtk_timeout_remove
			*/
			while (gtk_events_pending()) gtk_main_iteration();
		}
	}


	Buf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (poche.Adr_textview));
	gtk_text_buffer_insert_at_cursor (Buf, NewBuf, -1);

	g_print ("%s", buffer);
	g_strfreev(Larrbuf);
	g_free (NewBuf);
	NewBuf = NULL;
}
// 
// 
void on_textview_text_poche_drag_data_received
                                        (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        GtkSelectionData *data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data)
{
	gchar	*New_Str = NULL;
	gchar	*buffer = (gchar *)data->data;

	/* le DRAG n'est plus utile */
	data->length = 0;
	
	/* conversion */
	New_Str = dragndrop_xcfa_convert_utf8 (buffer);

	/* vers le 'TextView' */
	pocheevnt_insere_texte (New_Str);

	/* the end */
	g_free (New_Str);
	New_Str = NULL;

	if (gtk_combo_box_get_active (GTK_COMBO_BOX (poche.Adr_combobox_text_recto)) <= 5 ||
	    gtk_combo_box_get_active (GTK_COMBO_BOX (poche.Adr_combobox_text_verso)) <= 5)
		pochetimer_action (PTIMER_DISABLE, GENPOSTSCRIPT, PRINTIMAGE, FLAGSRECTO, FLAGSVERSO);
}
// 
// 
void on_textview_text_poche_realize (GtkWidget *widget, gpointer user_data)
{
	poche.Adr_textview = widget;

	/* Signal 'changed' */
	g_signal_connect ((gpointer) gtk_text_view_get_buffer (GTK_TEXT_VIEW (widget)),
				"changed",
				G_CALLBACK (pocheevnt_texte_changed_in_textview),
				NULL);

	pocheevnt_texte_changed_in_textview (NULL,NULL);

	/* Drag and drop support
	*  SIGNAL : 'drag-data-received'
	*/
	/*
	g_signal_connect(G_OBJECT(widget),
			 "drag-data-received",
			 G_CALLBACK(pocheevnt_drag_data_textview),
			 NULL);
	gtk_drag_dest_set (GTK_WIDGET (widget),
			   GTK_DEST_DEFAULT_MOTION |
			   GTK_DEST_DEFAULT_DROP,
			   drag_types, n_drag_types,
			   GDK_ACTION_COPY);
	*/
}

/*
*---------------------------------------------------------------------------
* NAME AUDIO-CD & BUTTON-CLICKED
*---------------------------------------------------------------------------
*/

// 
// 
void on_comboboxentry_cdaudio_realize (GtkWidget *widget, gpointer user_data)
{
	poche.Adr_entry_web_search = widget;
	gtk_entry_set_text (GTK_ENTRY (poche.Adr_entry_web_search), "xcfa GNU/Linux");
}
// 
// 
gchar *pocheevnt_get_comboboxentry_cdaudio (void)
{
	return ((gchar *)gtk_entry_get_text (GTK_ENTRY( poche.Adr_entry_web_search)));
}
// 
// 
void on_button_get_from_web_clicked (GtkButton *button, gpointer user_data)
{
	gchar *ptr = NULL;

	if (PrgInit.bool_convert == FALSE) {

		wininfo_create (
			_("PACKAGE imagemagick ABSENT"),
			_("Le package 'imagemagick' est absent"),
			  "\n",
			_("de votre systeme !"),
			  "\n\n",
			_("Veuillez l'installer et recommencer."),
			"");
			return;
	}

	ptr = pocheevnt_get_comboboxentry_cdaudio ();

	if (*ptr != '\0') {
		pocheweb_get ();
	}
}
// 
// 
void on_button_get_title_cdaudio_clicked (GtkButton *button, gpointer user_data)
{
	gchar *ptr = NULL;
	
	ptr = cdaudio_get_TitleCD ();
	
	if (ptr == NULL || *ptr == '\0') {
		wininfo_create (
			_("Le cd-audio est absent"),
			_("Pour resoudre ce probleme:"),
			  "\n",
			  "-----------------------------------\n",
			_("Allez dans l'onglet 'CD Audio'"),
			  "\n",
			_("Et saisisez un peripherique de lecture valide"),
			  "\n",
			_("Puis revenez ici et recommencez l'operation !"),
			  "");
	}
	else {
		// gint      total_entry;

		// total_entry = pocheevnt_comboboxentry_total ();
		// gtk_combo_box_append_text ( GTK_COMBO_BOX (poche.Adr_comboboxentry_cdaudio), ptr);
		// gtk_combo_box_set_active (GTK_COMBO_BOX (poche.Adr_comboboxentry_cdaudio), total_entry);

		/*
		gtk_combo_box_set_text (GTK_COMBO_BOX (poche.Adr_comboboxentry_cdaudio), ptr);
		gtk_combo_box_append_text (GTK_COMBO_BOX (poche.Adr_comboboxentry_cdaudio), ptr);
		gtk_combo_box_insert_text (GTK_COMBO_BOX (poche.Adr_comboboxentry_cdaudio), 0, ptr);
		*/
		gtk_entry_set_text (GTK_ENTRY (poche.Adr_entry_web_search), ptr);

	}
}
// Texte
// 
void on_button_importation_titre_cd_clicked (GtkButton *button, gpointer user_data)
{
	GtkTextBuffer	*Buf = NULL;
	CD_AUDIO	*Audio = NULL;
	GList		*List = NULL;
	gchar		*ptr = NULL;
	
	ptr = cdaudio_get_TitleCD ();
	
	if (ptr == NULL || *ptr == '\0') {
		wininfo_create (
			_("Le cd-audio est absent"),
			_("Pour resoudre ce probleme:"),
			  "\n",
			  "-----------------------------------\n",
			_("Allez dans l'onglet 'CD Audio'"),
			  "\n",
			_("Selectionnez le peripherique de lecture"),
			  "\n",
			_("Puis revenez ici et recommencez l'operation !"),
			  "");
			return;
	}
	
	Buf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (poche.Adr_textview));

	gtk_text_buffer_insert_at_cursor (Buf, "\n", -1);
	List = g_list_first (EnteteCD.GList_Audio_cd);
	while (List) {
		if ((Audio = (CD_AUDIO *)List->data)) {
			
			gchar *Str = NULL;
			
			
			Str = g_strdup_printf ("%s - %s - %s", EnteteCD.Artiste, Audio->NameSong, Audio->Duree);
			gtk_text_buffer_insert_at_cursor (Buf, Str, -1);
			/*gtk_text_buffer_insert_at_cursor (Buf, Audio->NameSong, -1);*/
			gtk_text_buffer_insert_at_cursor (Buf, "\n", -1);
			g_free (Str);
			Str = NULL;
		}
		List = g_list_next(List);
	}
}

/*
*---------------------------------------------------------------------------
* OPTIONS
*---------------------------------------------------------------------------
*/

// 
// 
gboolean pocheevnt_init_images_xcfa (void)
{
	return (PrgInit.bool_convert);
}
// 
// 
gboolean pocheevnt_get_load_images_init_xcfa (void)
{
	/*return (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (poche.Adr_checkbutton_load_img_init_xcfa)));*/
	// return (Config_User.Bool_init_img_xcfa);
	return (TRUE);
}

/*
*---------------------------------------------------------------------------
* Choix, preview, make fichier PostScript
*---------------------------------------------------------------------------
*/

// 
// 
void on_combobox_generate_ps_pdf_realize (GtkWidget *widget, gpointer user_data)
{
	// libcombo_alloc (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Choix:"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("     Generation fichier PostScript"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("     Generation fichier PDF"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("     Generation fichiers PostScript et PDF"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), Config.PathDestFilePostScript);
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
	poche.Adr_combobox_generate_ps_pdf = GTK_COMBO_BOX (widget);
}
// 
// 
void pocheevnt_save_path (gchar *path)
{
	if (NULL != Config.PathDestFilePostScript) {
		g_free (Config.PathDestFilePostScript);
		Config.PathDestFilePostScript = NULL;
	}
	Config.PathDestFilePostScript = g_strdup (path);
	
	gtk_combo_box_remove_text (GTK_COMBO_BOX (poche.Adr_combobox_generate_ps_pdf), 4);
	gtk_combo_box_append_text (GTK_COMBO_BOX (poche.Adr_combobox_generate_ps_pdf), path);
	
}
// 
// 
void on_combobox_generate_ps_pdf_changed (GtkComboBox *combobox, gpointer user_data)
{
	gint num;

	if (poche.Adr_combobox_generate_ps_pdf == NULL) return;
	num = gtk_combo_box_get_active (GTK_COMBO_BOX (poche.Adr_combobox_generate_ps_pdf));
	g_print("num = %d\n",num);
	if (num > 0 && num < 5) {
		gtk_combo_box_set_active (GTK_COMBO_BOX (poche.Adr_combobox_generate_ps_pdf), 0);
		switch (num) {
		case 1 :
			pochegen_file_postscript ();
			break;
		case 2 :
			pochegen_file_pdf ();
			break;
		case 3 :
			pochegen_file_postscript_pdf ();
			break;
		case 4 :
			fileselect_create (_PATH_DEST_FILE_POSTSCRIPT_, Config.PathDestFilePostScript, pocheevnt_save_path);
			break;
		}
	}
}
// 
// 
void on_button_preview_postscript_clicked (GtkButton *button, gpointer user_data)
{
	gchar     *ptr_name_viewer = NULL;

	if (FALSE == libutils_test_file_exist (poche.file_preview_ps)) {

		wininfo_create (
			_("Fichier PostScript absent"),
			_("La creation d'un fichier PostScript"),
			  "\n",
			_("est necessaire pour avoir acces a"),
			  "\n",
			_("cette option."),
			  "");
		return;
	}
	
	ptr_name_viewer = (gchar *)gtk_entry_get_text (GTK_ENTRY (poche.Adr_entry_postscript));
	pocheexec_viewer_postscript (ptr_name_viewer, poche.file_preview_ps);

}
// 
// 
void on_entry_lecteur_postscript_realize (GtkWidget *widget, gpointer user_data)
{
	poche.Adr_entry_postscript = widget;
	if (NULL == Config.StringNameLecteurPostScript) {
		Config.StringNameLecteurPostScript = g_strdup ("evince");
	}
	else if ('\0' == *Config.StringNameLecteurPostScript) {
		g_free (Config.StringNameLecteurPostScript);
		Config.StringNameLecteurPostScript = NULL;
		Config.StringNameLecteurPostScript = g_strdup ("evince");
	}
	gtk_entry_set_text (GTK_ENTRY (poche.Adr_entry_postscript), Config.StringNameLecteurPostScript);
}
// 
// 
void on_entry_lecteur_postscript_changed (GtkEditable *editable, gpointer user_data)
{
	if (NULL != poche.Adr_entry_postscript) {
		
		gchar	*Ptr = (gchar *)gtk_entry_get_text (GTK_ENTRY (poche.Adr_entry_postscript));
		
		if (TRUE == libutils_find_file (Ptr)) {
			gtk_label_set_markup (GTK_LABEL (GLADE_GET_OBJECT("label_lecteur_postscript")), "<span color=\"forestgreen\"><b>Found</b></span>");
			poche.BoolPostscriptOk = TRUE;
		}
		else {
			gtk_label_set_markup (GTK_LABEL (GLADE_GET_OBJECT("label_lecteur_postscript")), "<span color=\"red\"><b><i>NOT Found</i></b></span>");
			poche.BoolPostscriptOk = FALSE;
		}
		if (NULL != Config.StringNameLecteurPostScript) {
			g_free (Config.StringNameLecteurPostScript);
			Config.StringNameLecteurPostScript = NULL;
		}
		Config.StringNameLecteurPostScript = g_strdup (Ptr);
		
		gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_preview_postscript")), poche.BoolPostscriptOk);
	}
}









