 /*
 *  file    : tags_wav.c
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2011 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */
 
 
#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <glib/gstdio.h>
#include <pthread.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "file.h"
#include "tags.h"



// 
// 
void tagswav_close_file (WAVE *son)
{
	if (NULL != son->file) {
		fclose(son->file);  
		son->file = NULL;
	}
}
// 
// 
void tagswav_init (WAVE *son)
{
	son->RIFF.ChunkID [ 0 ]     = '\0';
	son->RIFF.ChunkSize         = 0;
	son->RIFF.Format [ 0 ]      = '\0';
	son->FMT.Subchunk1ID [ 0 ]  = '\0';
	son->FMT.Subchunk1Size      = 0;
	son->FMT.AudioFormat        = 0;
	son->FMT.NumChannels        = 0;
	son->FMT.SampleRate         = 0;
	son->FMT.ByteRate           = 0;
	son->FMT.Blockalign         = 0;
	son->FMT.BitsPerSample      = 0;
	son->DATA.Subchunk2ID [ 0 ] = '\0';
	son->DATA.Subchunk2Size     = 0;
	son->DATA.data              = NULL;
	son->file                   = NULL;
}
// 
// 
gboolean tagswav_read_file (gchar *wave_file, WAVE *son)
{  
 	unsigned char 	devbuf[ BLOCK_SIZE +10 ];
 	gint		n_read;
	gint		tt_read = 0;
	gint		cpt;
	gboolean	BoolFound = FALSE;
	gchar		Str [ 10 ];
	
	PRINT_FUNC_LF();
	g_print("\t%s\n", wave_file);
	// INIT STRUCTURE
	tagswav_init (son);
	
	// ouverture/lecture du fichier wave_file en mode binaire (rb) : lecture en octets  
	if (NULL == (son->file = fopen(wave_file, "rb"))) { 
		// gestion d'erreurs 
		g_print ("\nERREUR: fichier  %s  introuvable\n", wave_file);  
		return (FALSE);
	}  
  
	// lecture des données du fichier .wav et stockage de celle-ci dans les champs adéquats de la structure WAVE
	n_read = fread(&son->RIFF.ChunkID, 4, 1, son->file);		// RIFF
	n_read = fread(&son->RIFF.ChunkSize, 4, 1, son->file);		// taille du fichier entier en octets (sans compter les 8 octets de ce champ et le champ précédent
	n_read = fread(&son->RIFF.Format, 4, 1, son->file);		// WAVE
	n_read = fread(&son->FMT.Subchunk1ID, 4, 1, son->file);		// 'fmt '
	n_read = fread(&son->FMT.Subchunk1Size, 4, 1, son->file);	// taille en octet des données à suivre
	n_read = fread(&son->FMT.AudioFormat, 2, 1, son->file);		// format de compression (une valeur autre que 1 indique une compression) 
	n_read = fread(&son->FMT.NumChannels, 2, 1, son->file);		// nombre de canaux
	n_read = fread(&son->FMT.SampleRate, 4, 1, son->file);		// fréquence d'échantillonage (nombre d'échantillons par secondes) 
	n_read = fread(&son->FMT.ByteRate, 4, 1, son->file);		// nombre d'octects par secondes
	n_read = fread(&son->FMT.Blockalign, 2, 1, son->file);		// nombre d'octects pour coder un échantillon
	n_read = fread(&son->FMT.BitsPerSample, 2, 1, son->file);	// nombre de bits pour coder un échantillon
	
	// FICHIER WAV ?
	if ((0 != strncmp (son->RIFF.ChunkID, "RIFF", 4)) || (0 != strncmp (son->RIFF.Format, "WAVE", 4)) || (0 != strncmp (son->FMT.Subchunk1ID, "fmt ", 4))) {
		g_print ("%s  n'est pas un fichier wav\n", wave_file);  
		fclose(son->file);  
		son->file = NULL;
		return (FALSE);
	}
	
	// POINTEUR AU DEBUT DU FICHIER
	rewind (son->file);
	do {
		// LECTURE D UN BLOCK
		n_read = fread (devbuf, BLOCK_SIZE, 1, son->file);
		// RECHERCHE DE: data
		for (cpt = 0; cpt < BLOCK_SIZE; cpt ++) {
			if (devbuf [ cpt +0 ] == 'd' && devbuf [ cpt +1 ] == 'a' && devbuf [ cpt +2 ] == 't' && devbuf [ cpt +3 ] == 'a') {
				BoolFound = TRUE;
				break;
			}
		}
		if (TRUE == BoolFound) break;
		// VARIABLE TOTAL OCTECTS LU MOINS 8 AU CAS OU data SOIS COUPE EN FIN DE BLOCK
		tt_read += BLOCK_SIZE;
		tt_read -= 8;
		// POINTEUR AU DEBUT DU FICHIER
		rewind (son->file);
		// POINTEUR DE LECTURE SUR tt_read
		fseek (son->file, tt_read,  SEEK_CUR);
	} while (n_read > 0);
	
	if (TRUE == BoolFound)  {
		rewind (son->file);
		n_read = fseek (son->file, cpt + tt_read, SEEK_CUR);
		n_read = fread(&son->DATA.Subchunk2ID, 4, 1, son->file);
		n_read = fread(&son->DATA.Subchunk2Size, 4, 1, son->file);
	
		g_print ("\tBoolFound DATA = %s\n", BoolFound ? "TRUE" : "FALSE");
			
		Str [ 0 ] = son->RIFF.ChunkID [ 0 ];
		Str [ 1 ] = son->RIFF.ChunkID [ 1 ];
		Str [ 2 ] = son->RIFF.ChunkID [ 2 ];
		Str [ 3 ] = son->RIFF.ChunkID [ 3 ];
		Str [ 4 ] = '\0';
		g_print ("\tChunkID        = %s\n", Str);
		g_print ("\tChunkSize      = %d\n", son->RIFF.ChunkSize);
		
		Str [ 0 ] = son->RIFF.Format [ 0 ];
		Str [ 1 ] = son->RIFF.Format [ 1 ];
		Str [ 2 ] = son->RIFF.Format [ 2 ];
		Str [ 3 ] = son->RIFF.Format [ 3 ];
		Str [ 4 ] = '\0';
		g_print ("\tFormat         = %s\n", Str);
		
		Str [ 0 ] = son->FMT.Subchunk1ID [ 0 ];
		Str [ 1 ] = son->FMT.Subchunk1ID [ 1 ];
		Str [ 2 ] = son->FMT.Subchunk1ID [ 2 ];
		Str [ 3 ] = son->FMT.Subchunk1ID [ 3 ];
		Str [ 4 ] = '\0';
		g_print ("\tSubchunk1ID    = %s\n", Str);
		
		g_print ("\tSubchunk1Size  = %d\n", son->FMT.Subchunk1Size);  
		g_print ("\tAudioFormat    = %d\n", son->FMT.AudioFormat);  
		g_print ("\tNumChannels    = %d\n", son->FMT.NumChannels);  
		g_print ("\tSampleRate     = %d\n", son->FMT.SampleRate);  
		g_print ("\tByteRate       = %d\n", son->FMT.ByteRate);  
		g_print ("\tBlockalign     = %d\n", son->FMT.Blockalign);  
		g_print ("\tBitsPerSample  = %d\n", son->FMT.BitsPerSample);
		
		Str [ 0 ] = son->DATA.Subchunk2ID [ 0 ];
		Str [ 1 ] = son->DATA.Subchunk2ID [ 1 ];
		Str [ 2 ] = son->DATA.Subchunk2ID [ 2 ];
		Str [ 3 ] = son->DATA.Subchunk2ID [ 3 ];
		Str [ 4 ] = '\0';
		g_print ("\tSubchunk2ID    = %s\n", Str);  
		
		g_print ("\tSubchunk2Size  = %d\n", son->DATA.Subchunk2Size);
		g_print ("\n");
 	}
	else if (FALSE == BoolFound)  {
		// fermeture du fichier  
		fclose (son->file);  
 		son->file = NULL;
	}

	return BoolFound;  
}  
// 
// 
INFO_WAV *tagswav_remove_info (INFO_WAV *info)
{
	if (info) {
		if (NULL != info->time)		{ g_free (info->time);		info->time = NULL;	}
		if (NULL != info->hertz)	{ g_free (info->hertz);		info->hertz = NULL;	}
		if (NULL != info->voie)		{ g_free (info->voie);		info->voie = NULL;	}
		if (NULL != info->bits)		{ g_free (info->bits);		info->bits = NULL;	}
		if (NULL != info->NewHertz)	{ g_free (info->NewHertz);	info->NewHertz = NULL;	}
		if (NULL != info->NewVoie)	{ g_free (info->NewVoie);	info->NewVoie = NULL;	}
		if (NULL != info->NewBits)	{ g_free (info->NewBits);	info->NewBits = NULL;	}

		info->tags = (TAGS *)tags_remove (info->tags);

		g_free (info);
		info = NULL;
	}
	return ((INFO_WAV *)NULL);
}
// 
// 
gboolean tagswav_file_is_mono (gchar *namefile)
{
	WAVE	son;
	
	if (TRUE == tagswav_read_file (namefile, &son)) {
		tagswav_close_file (&son);
		return (son.FMT.NumChannels == 1 ? TRUE : FALSE);
	}
	return (FALSE);
}
// 
// 
gboolean tagswav_file_GetBitrate (gchar *namefile, gint *Channels, gint *Hertz, gint *Bits)
{
	WAVE	 	son;
	
	if (TRUE == tagswav_read_file (namefile, &son)) {
		tagswav_close_file (&son);
		if (Channels)	*Channels = son.FMT.NumChannels;
		if (Hertz)	*Hertz    = son.FMT.SampleRate;
		if (Bits)	*Bits     = son.FMT.BitsPerSample;
		return ((son.FMT.NumChannels != 2 || son.FMT.SampleRate != 44100 || son.FMT.BitsPerSample != 16) ? TRUE : FALSE);
	}
	return (FALSE);
}
// 
// 
INFO_WAV *tagswav_get_info (gchar *namefile)
{
	WAVE		son;
	INFO_WAV	*ptrinfo = NULL;
	gint		m;
	gint		s;
	gint		sec;
	gboolean	BoolReadWavFile;
	
	// PRINT_FUNC_LF();
	
	ptrinfo = (INFO_WAV *)g_malloc0 (sizeof (INFO_WAV));
	if (NULL == ptrinfo) {
		g_print ("!---------------------------------------\n");
		PRINT_FUNC_LF();
		g_print ("!---------------------------------------\n");
		g_print ("! PTRINFO EST NULL  :(\n");
		g_print ("!---------------------------------------\n");
		return (NULL);
	}

	BoolReadWavFile = tagswav_read_file (namefile, &son);
	tagswav_close_file (&son);
	
	if (FALSE == BoolReadWavFile) {
		g_free (ptrinfo);
		PRINT("EXIT");
		ptrinfo = NULL;
		return (NULL);
	}
	if (son.DATA.Subchunk2Size == 0 || son.FMT.ByteRate == 0) {
		g_free (ptrinfo);
		ptrinfo = NULL;
		g_print ("! ---\n");
		g_print ("! MAUVAIS ENTETE DU FICHIER: %s\n", namefile);
		g_print ("! ---\n\n");
		return (NULL);
	}
	
	// calcul de la duree
	sec = son.DATA.Subchunk2Size / son.FMT.ByteRate;
	ptrinfo->SecTime              = sec;
	ptrinfo->ValueMark.SecTime    = sec;
	// ptrinfo->ValueMark.ValueMarkA = 0.0;
	// ptrinfo->ValueMark.ValueMarkB = 100.0;
	// ptrinfo->ValueMark.Value      = 0.0;

	s = sec % 60; sec /= 60;
	m = sec % 60; sec /= 60;
	if (sec > 0) ptrinfo->time = g_strdup_printf ("%02d:%02d:%02d", sec, m, s);
	else         ptrinfo->time = g_strdup_printf ("%02d:%02d", m, s);
		
	// mode
	ptrinfo->voie    = g_strdup_printf ("%d", son.FMT.NumChannels);
	ptrinfo->NewVoie = g_strdup_printf ("%d", son.FMT.NumChannels);

	// freq
	ptrinfo->hertz    = g_strdup_printf ("%d", son.FMT.SampleRate);
	ptrinfo->NewHertz = g_strdup_printf ("%d", son.FMT.SampleRate);

	// format
	ptrinfo->bits    = g_strdup_printf ("%d", son.FMT.BitsPerSample);
	ptrinfo->NewBits = g_strdup_printf ("%d", son.FMT.BitsPerSample);
	
	ptrinfo->BoolConv= FALSE;

	ptrinfo->tags = (TAGS *)tags_alloc (FALSE);
	// tags_set (detail->namefile, ptrinfo->tags);
	tags_set (namefile, ptrinfo->tags);
	
	ptrinfo->LevelDbfs.level = -1;
	ptrinfo->LevelDbfs.NewLevel = -1;

	return (ptrinfo);
}
// 
// RETOUR DE LA DUREE D'ECOUTE EN SECONDES
// 		
gint tagswav_get_time_sec (gchar *namefile)
{
	WAVE	son;
	
	// PRINT_FUNC_LF();
	
	if (TRUE == tagswav_read_file (namefile, &son)) {
		tagswav_close_file (&son);
		return (son.DATA.Subchunk2Size / son.FMT.ByteRate);
	}
	return (0);
}
		
		





