 /*
 *  file      : process.c
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2011 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif
#include <gtk/gtk.h>
#include <pthread.h>
#include <glib.h>
#include <glib/gstdio.h>

#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
 
#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "file.h"
#include "process.h"



typedef struct {
	guint	handler_timeout;
	size_t	Size_XCFA_FILE_LOAD;
	GSList	*gslist;
	// GSList	*gslist_remove;
	FILE	*fp;
} VAR_PROCESS;

VAR_PROCESS VarProcess = {
			0,
			-1,
			NULL,
			NULL
			};



// 
// 
void process_debug (gchar *p_trace)
{
	FILE	*fp = NULL;
	
	fp = fopen ("/tmp/xcfa_trace.txt", "a");
	fprintf (fp, "%s\n", p_trace);
	fclose (fp);
}
// 
// 
static gint process_level_timeout_do (gpointer data)
{
#define PROCESS_MAX_CARS 2048
	
	if (VarProcess.Size_XCFA_FILE_LOAD != libutils_get_size_file (XCFA_FILE_LOAD)) {
		VarProcess.Size_XCFA_FILE_LOAD = libutils_get_size_file (XCFA_FILE_LOAD);
		return (TRUE);
	}
		
	// LECTURE DU FICHIER [ XCFA_FILE_LOAD ] ET CONSTRUCTION DU GSLIST
	if (NULL != (VarProcess.fp = fopen (XCFA_FILE_LOAD, "r"))) {

		gchar	buf   [ PROCESS_MAX_CARS +1 ];
		gchar	*ptr = NULL;
		
		while (fgets (buf, PROCESS_MAX_CARS, VarProcess.fp) != NULL) {
			if  ((ptr = strchr (buf, '\n'))) *ptr = '\0';
			VarProcess.gslist = g_slist_append (VarProcess.gslist, g_strdup (buf));
		}
		fclose (VarProcess.fp);
	
		// ANALYSE DE LA LISTE
		fileanalyze_add_file_to_treeview (_PATH_LOAD_FILE_ALL_, VarProcess.gslist);
	}
	
	// DESTRUCTION DE LA LISTE
	VarProcess.gslist = libutils_remove_gslist (VarProcess.gslist);
	
	// DESTRUCTION DU FICHIER [ XCFA_FILE_LOAD ]
	g_unlink (XCFA_FILE_LOAD);
	
	// FIN DU TIMEOUT
	gtk_timeout_remove (VarProcess.handler_timeout);
	
#undef PROCESS_MAX_CARS
	return (TRUE);
}
// 
// 
void process_goto_timeout (void)
{
	if (TRUE == libutils_test_file_exist (XCFA_FILE_LOAD)) {
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_FICHIERS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_in_file")), NOTEBOOK_FICHIERS_CONVERSION);
		g_usleep (20);
		VarProcess.handler_timeout = gtk_timeout_add (400, process_level_timeout_do, 0);
	}
}
// 
// 
gboolean process_exist_file (void)
{
	return (libutils_test_file_exist (XCFA_FILE_LOAD));
}















