 /*
 *  file      : poche_web.c
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2011 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gprintf.h>
#include <glib/gstdio.h>
#include <pthread.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "win_scan.h"
#include "win_info.h"
#include "get_info.h"
#include "poche.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

#define BUFFER_SIZE 1024

gchar *nameindexhtml = NULL;

typedef struct {
	gboolean  EndThread;
	gboolean  EndTimeout;
	gchar    *name;
	guint     timeout;
	pthread_t nmr_tid;
} POCHEWEB_EVENT;

POCHEWEB_EVENT pocheweb_event;

guint pocheweb_tt_glist = 0;

/*
*---------------------------------------------------------------------------
* FONCTIONS
*---------------------------------------------------------------------------
*/

/* Recuperation sur le web du fichier image et sauvegarde
*/
gchar *pocheweb_get_on_web_file_img (gchar *filename)
{
	/*FILE     *index;*/
	gchar    *name_file = NULL;
	/*gchar    *ptr_name = NULL;*/
	gint      num = 0;
	gchar    *LineCommand = NULL;
	gint	  Dummy;


	// PRINT_FUNC_LF();

	/* Si le nom existe deja, en chercher un nouveau */
	/*
	if ( (ptr_name = strrchr (filename, '/')) == NULL) return (NULL);
	ptr_name ++;
	name_file = g_strdup_printf ("%s/%s", poche.Path_pochette, ptr_name);
	if (libutils_test_file_exist (name_file) == TRUE) {
		g_print ("EXISTE DEJA: %s\n", name_file);
		g_free(name_file);
		name_file = NULL;

		num = 1;
		while (TRUE) {
			name_file = g_strdup_printf ("%s/%03d.jpg", poche.Path_pochette, num);
			if (libutils_test_file_exist (name_file) == FALSE) {
				g_print ("NOUVEAU NOM: %s\n", name_file);
				break;
			}
			num ++;
			g_free (name_file);
			name_file = NULL;
		}
	}
	*/
	num = 1;
	while (TRUE) {
		name_file = g_strdup_printf ("%s/%03d.jpg", poche.Path_pochette, num);
		if (libutils_test_file_exist (name_file) == FALSE) {
			/*g_print ("NOUVEAU NOM: %s\n", name_file);*/
			break;
		}
		num ++;
		g_free (name_file);
		name_file = NULL;
	}
	
	LineCommand = g_strdup_printf ("wget --user-agent=\"Mozilla 22.0\" -O %s %s", name_file, filename);
g_print("LINECOMMAND=\n%s\n", LineCommand);
	Dummy = system (LineCommand);
	g_free (LineCommand);
	LineCommand = NULL;

	if (libutils_test_file_exist (name_file) == FALSE) {
		g_free(name_file);
		name_file = NULL;
	}
	if (GetInfo_file_is (name_file) != FILE_IS_IMG) {
		g_unlink (name_file);
		g_free (name_file);
		name_file = NULL;
	}

	return ((gchar *)name_file);
}

/* Le fichier NAME_INDEX_HTML est analyse:
*  Tous les noms de fichiers seront passes en parametre a: pocheget_get_file (char *filename, int cpt)
*  pour recuperation et seront sauvegardes
*/
void pocheweb_analyze_file_html (void)
{
	size_t   cpt = 1;
	size_t   i;
	size_t   lenfile = 0;
	gchar   *buffer = NULL;
	gchar   *result = g_malloc0 (sizeof (char) * (BUFFER_SIZE + 10));
	FILE    *fp;
	gchar   *ptr = NULL;
	gchar   *ptr1 = NULL;
	gchar   *ptr_name = NULL;
	gint     TypeCode = 0;
	size_t	 Dummy;
	
	// PRINT_FUNC_LF();

	nameindexhtml = g_strdup_printf ("%s/index.html", poche.Path_pochette);

	lenfile = libutils_get_size_file (nameindexhtml);
	if (lenfile <= 100) {
		g_print ("ERREUR TAILLE DE %s = %d\n", nameindexhtml, (gint)lenfile);
		g_free (nameindexhtml);
		nameindexhtml = NULL;
		return;
	}
	buffer = g_malloc0 (sizeof (char) * (lenfile + 1024));

	fp = fopen (nameindexhtml, "r");
	Dummy = fread (buffer, 1, lenfile, fp);
	fclose (fp);

	ptr = buffer;
	while (*ptr) ptr ++;

	if (strstr (buffer, "/images?q=tbn:")) {
		TypeCode = 0;
		g_print ("\n");
		PRINT_FUNC_LF();
		g_print ("\tRecup des infos web via: \"/images?q=tbn:\"\n");
		g_print ("\n");
	} else if (strstr (buffer, "M:\",\"http")) {
		TypeCode = 1;
		g_print ("\n");
		PRINT_FUNC_LF();
		g_print ("\tRecup des infos web via: \"M:\",\"http\"\n");
		g_print ("\n");
	} else {
		PRINT_FUNC_LF();
		g_free (buffer);
		buffer = NULL;
		g_free (result);
		result = NULL;
		g_unlink (nameindexhtml);
		g_free (nameindexhtml);
		nameindexhtml = NULL;
		
		return;
	}
	
	ptr = buffer;
	while ((ptr - buffer) < lenfile) {
		/*if ((ptr = strstr (ptr + 1, "/images?q=tbn:"))) {*/
		/*if ((ptr = strstr (ptr + 1, "M:\",\"http"))) {*/
		
		if ((ptr = strstr (ptr + 1, TypeCode == 0 ? "/images?q=tbn:" : "M:\",\"http"))) {
		
			if ((ptr = strstr (ptr, "http:"))) {
				for (i=0; i < BUFFER_SIZE; i++) result [ i ] = '\0';
				ptr1 = ptr;
				
				if (TypeCode == 0) {
					while (*ptr1 != ' ') ptr1 ++;
				}
				else if (TypeCode == 1) {
					while (*ptr1 != '\"') ptr1 ++;
				}
				strncpy (result, ptr, ptr1 - ptr);
				
				// VIRER LE '"' de fin de chaine
				for (ptr1 = result; ptr1 && *ptr1; ptr1 ++)
					if (*ptr1 == '"') {
						*ptr1 = '\0';
						break;
					}
				
				if ((ptr_name = pocheweb_get_on_web_file_img (result))) {
					if (pocheweb_event.name) {
						g_free (pocheweb_event.name);
						pocheweb_event.name = NULL;
					}
					pocheweb_event.name = g_strdup (ptr_name);
					pochedir_make_glist (ptr_name);
				}

				if (WindScan_close_request ()) {
					g_print ("DEMANDE D'ANNULATION DEPUIS: ");
					PRINT_FUNC_LF();
					break;
				}

				cpt ++;
			}
		}
		if ((ptr - buffer) >= lenfile -100) break;
	}
	g_free (buffer);
	buffer = NULL;
	g_free (result);
	result = NULL;
	g_unlink (nameindexhtml);
	g_free (nameindexhtml);
	nameindexhtml = NULL;
}

/* Recuperation du fichier *.html et sauvegarde
*/
gboolean pocheweb_recup_file_html (gchar *cd_name)
{
	/*FILE      *index;*/
	gchar     *name = NULL;
	gchar     *ptrname = NULL;
	gboolean   bool_ret = FALSE;
	gchar     *PtrNew = NULL;
	gchar     *Ptr = NULL;
	gchar     *LineCommand = NULL;
	gint	  Dummy;

	PRINT_FUNC_LF();

	/* Construction du path	*/
	Ptr = PtrNew = g_strdup_printf ("http://images.google.com/images?q=%s", cd_name);
	/* Chaine de transformation du nom */
	ptrname = name = g_strnfill (1024, '\0');
/*
http://images.google.com/images?q=Dire   Straits   Brothers   In   Arms+Dire   Straits   Brothers   in   arms
http://images.google.com/images?q=Dire%20Straits%20Brothers%20In%20Arms+Dire%20Straits%20Brothers%20in%20arms
*/

	while (*Ptr) {
		if (*Ptr == ' ') {
			*ptrname ++ = '%';
			*ptrname ++ = '2';
			*ptrname ++ = '0';
			Ptr ++;
		}
		else {
			*ptrname ++ = *Ptr ++;
		}
	}

	g_free (PtrNew);
	PtrNew = Ptr = NULL;
	
/*g_print ("\n---------NAME = %s\n\n", name);*/

	nameindexhtml = g_strdup_printf ("%s/index.html", poche.Path_pochette);
	LineCommand = g_strdup_printf ("wget --user-agent=\"Mozilla 22.0\" -O %s %s", nameindexhtml, name);
g_print("LineCommand=%s\n", LineCommand);
	Dummy = system (LineCommand);
	g_free (LineCommand);
	LineCommand = NULL;

	bool_ret = (libutils_test_file_exist (nameindexhtml) && libutils_get_size_file (nameindexhtml) > 0);

	g_free (name);
	name = NULL;

	return (bool_ret);
}

static void pocheweb_thread (void *arg)
{
	gchar *ptr_cdname = NULL;

	// PRINT_FUNC_LF();

	ptr_cdname = pocheevnt_get_comboboxentry_cdaudio ();
	
	// g_print ("PTR_CDNAME = %s\n", ptr_cdname);
	if (pocheweb_recup_file_html (ptr_cdname) == TRUE) {
		pocheweb_analyze_file_html ();
	}

	pocheweb_event.EndTimeout = TRUE;
	pocheweb_event.EndThread = TRUE;

	pthread_exit(0);
}

gboolean pocheweb_bool_file_add (void)
{
	return (pocheweb_tt_glist < g_list_length (poche.glist) ? TRUE : FALSE);
}

static gint pocheweb_timeout (gpointer data)
{
	if (pocheweb_event.name) {
		gchar	*Str = g_strdup_printf ("<b><i>%s</i></b>", pocheweb_event.name);
		WindScan_set_label (Str);
		g_free (pocheweb_event.name);
		pocheweb_event.name = NULL;
		g_free (Str);
		Str = NULL;
	}
	else if (pocheweb_event.EndThread == TRUE) {
		pocheevnt_table_add_images ();
		pocheevnt_set_flag_buttons_recto ();
		pocheevnt_set_flag_buttons_verso ();
		gtk_timeout_remove (pocheweb_event.timeout);
		
		WindScan_close ();

		if (pocheweb_bool_file_add () == FALSE) {
			wininfo_create (
				_("Aucun fichier trouve !"),
				_("Pour resoudre ce probleme:"),
				  "\n",
				  "-----------------------------------\n",
				_("Modifiez la chaine de recherche et"),
				  "\n",
				_("recommencez."),
			  	  "");
		}
	}
	return (TRUE);
}

void  pocheweb_get (void)
{
	// PRINT_FUNC_LF();

	pocheweb_tt_glist = g_list_length (poche.glist);
	WindScan_open ("Recherche des fichiers images", WINDSCAN_PULSE);
	WindScan_set_label ("<b><i>Recherche des fichiers images ...</i></b>");
	pocheweb_event.name = g_strdup (_("[Recherche des fichiers images]"));
	pocheweb_event.name = NULL;
	pocheweb_event.EndThread = FALSE;
	pocheweb_event.EndTimeout = FALSE;
	pocheweb_event.timeout = gtk_timeout_add (10, pocheweb_timeout, 0);
	pthread_create (&pocheweb_event.nmr_tid, NULL ,(void *)pocheweb_thread, (void *)NULL);
}








