 /*
 *  file      : file_trash.h
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2011 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <glib/gstdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <pthread.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "win_scan.h"
#include "file.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/
typedef struct {

	gboolean         BoolTrashIsOk;
	gboolean         Bool_kde_full_session;
	
	pthread_t        nmr_tid;
	guint            handler_timeout;
	gboolean         bool_thread_end;
	double           total_percent;
	
	gint             nbr_trash;
	gint             ElementActif;
	
	gboolean         BoolEtat;
	gboolean         bool_pass_conv;
	gint             pass_conv;
	
	gboolean         bool_set_end_of_user;
	
	gchar            PathNameTrash [ 1024 ];
	
} VAR_FILE_TRASH;

VAR_FILE_TRASH var_filetrash = { FALSE, FALSE };



/*
mv ./11\ Track_11.wav /home/cat/.Trash/11\ Track_11.wav

Sous Ubuntu
	$HOME/.Trash
Kubuntu et Xubuntu
	$HOME/.local/share/Trash/files

*/



/*  #include <gio/gio.h>
 *  
 *  gboolean g_file_trash (GFile *file, GCancellable *cancellable, GError **error);
 *  
 *  
 *  
void filetrash_test (gchar *Name)
{
	GError *error;
	g_file_trash ((GFile *)Name, NULL, &error);
}
 *  
 *  
 */
 


// 
// 
gboolean filetrash_test_desktop_is_kde (void)
{
	FILE		*fp;
#define MAX_CARS_KDE 255
	gchar		buf   [ MAX_CARS_KDE +1 ];
	gboolean	BoolRet = FALSE;
	gint		Dummy;
	
	/*
	KDE_FULL_SESSION
	*/
	Dummy = system ("env | grep \"KDE_FULL_SESSION\" > /tmp/tst_kde_full_session.txt");
	if ((fp = fopen ("/tmp/tst_kde_full_session.txt", "r")) != NULL) {
		while (fgets (buf, MAX_CARS_KDE, fp) != NULL) {
			if (strcmp (buf, "KDE_FULL_SESSION") == 0) {
				if (strcmp (buf, "true") == 0 || strcmp (buf, "TRUE") == 0) {
					BoolRet = TRUE;
					break;
				}
			}
		}
		fclose (fp);
	}
	g_unlink ("/tmp/tst_kde_full_session.txt");
	return (BoolRet);	
}
// 
// 
gboolean filetrash_move_to_trash (gchar *Name)
{
	gchar	*NameDest = NULL;
	gchar	 *Ptr = NULL;
	gchar	*LineCommand = NULL;
	gint	Dummy;
	
	/*PRINT_FUNC_LF();*/
	
	if ((Ptr = strrchr (Name, '/')))
		Ptr ++;
	else	Ptr = Name;
	
	NameDest = g_strdup_printf ("%s/%s", filetrash_get_trash (), Ptr);
	
	LineCommand = g_strdup_printf ("mv -f \"%s\" \"%s\"", Name, NameDest);
	g_print ("To Trash:\n\t%s\n", LineCommand);
	Dummy = system (LineCommand);
	
	g_free (LineCommand);
	LineCommand = NULL;
	
	g_free (NameDest);
	NameDest = NULL;
	
	return (TRUE);
}
// 
// 
gchar *filetrash_get_trash (void)
{
	if (var_filetrash.Bool_kde_full_session == TRUE)
		g_sprintf (var_filetrash.PathNameTrash, "%s/.local/share/Trash/files", getenv ("HOME"));
	else	g_sprintf (var_filetrash.PathNameTrash, "%s/.Trash", getenv ("HOME"));

	return ((gchar *)var_filetrash.PathNameTrash);
}
// 
// 
void filetrash_test_trash_is_ok (void)
{
	gboolean      BoolExistTrashOLD;
	gboolean      BoolExistTrashNEW;
	gchar        *Path = NULL;
	gchar        *StrTrash = NULL;
	gint          Dummy;
	
	g_print ("\n[ Trash ]\n");
	
	if (var_filetrash.BoolTrashIsOk == TRUE) return;
	var_filetrash.BoolTrashIsOk = TRUE;
	var_filetrash.Bool_kde_full_session = filetrash_test_desktop_is_kde ();
	
	g_print ("KDE SESSION : %s\n", var_filetrash.Bool_kde_full_session ? "TRUE" : "FALSE");

	Path = g_strdup_printf ("%s/.Trash", getenv ("HOME"));
	BoolExistTrashOLD = libutils_test_dir_exist (Path);
	if (BoolExistTrashOLD == TRUE)
		g_print ("EXIST ......: %s\n", Path);
	else	g_print ("NOT EXIST ..: %s\n", Path);
	g_free (Path);
	Path = NULL;
	
	Path = g_strdup_printf ("%s/.local/share/Trash/files", getenv ("HOME"));
	BoolExistTrashNEW = libutils_test_dir_exist (Path);
	if (BoolExistTrashNEW == TRUE)
		g_print ("EXIST ......: %s\n", Path);
	else	g_print ("NOT EXIST ..: %s\n", Path);
	g_free (Path);
	Path = NULL;
	
	// SI SESSION KDE
	if (var_filetrash.Bool_kde_full_session == TRUE) {
		if (BoolExistTrashNEW == FALSE) {
			StrTrash = g_strdup_printf ("mkdir -p %s", filetrash_get_trash ());
			Dummy = system (StrTrash);
			g_free (StrTrash);
			StrTrash = NULL;
			BoolExistTrashNEW = TRUE;
		}
	}
	// SI PAS SESSION KDE
	else {
		if (BoolExistTrashNEW == TRUE) {
			var_filetrash.Bool_kde_full_session = TRUE;
		}
		else if (BoolExistTrashOLD == FALSE) {
			var_filetrash.Bool_kde_full_session = TRUE;
			StrTrash = g_strdup_printf ("mkdir -p %s", filetrash_get_trash ());
			Dummy = system (StrTrash);
			g_free (StrTrash);
			StrTrash = NULL;
			BoolExistTrashNEW = TRUE;
		}
		else {
			
		}
	}
	
	g_print ("---\nUSE ........: %s\n---\n\n", filetrash_get_trash ());
}
// 
// 
static void filetrash_thread (void *arg)
{
	GList     *list = NULL;
	DETAIL    *detail = NULL;

	var_filetrash.bool_thread_end = FALSE;
	var_filetrash.bool_pass_conv = TRUE;
	list = g_list_first (entetefile);
	while (list) {
		if (NULL != (detail = (DETAIL *)list->data)) {
			if (detail->EtatTrash == FILE_TRASH_VERIF_OK) {

				var_filetrash.ElementActif ++;
				var_filetrash.BoolEtat = TRUE;

				if (filetrash_move_to_trash (detail->namefile) == TRUE) {
					detail->BoolRemove = TRUE;
				}
			}
		}
		list = g_list_next (list);
	}
	var_filetrash.bool_pass_conv = FALSE;
	var_filetrash.bool_thread_end = TRUE;
	
	pthread_exit(0);
}
// 
// 
static gint filetrash_timeout (gpointer data)
{
	// if (TRUE == WindScan_close_request (void)) {
	// 	var_filetrash.bool_thread_end = TRUE;
	// }
	
	if (var_filetrash.bool_pass_conv == TRUE) {

		gchar *str = NULL;
    		gchar *spinner="|/-\\";
		gchar  foo [ 2 ];
		
		foo [ 0 ] = spinner[var_filetrash.pass_conv++%4];
		foo [ 1 ] = '\0';
		
		str = g_strdup_printf ("<b>En cours: %d / %d   %s</b>",
					var_filetrash.ElementActif,
					var_filetrash.nbr_trash,
					foo
					);
		WindScan_set_label (str);
		g_free (str);
		str = NULL;
	}
	
	if (var_filetrash.BoolEtat == TRUE) {
		
		gchar	*Str = NULL;
		
		var_filetrash.total_percent = (double)((double)var_filetrash.ElementActif / (double)var_filetrash.nbr_trash);
		Str = g_strdup_printf ("%d%%", (int)(var_filetrash.total_percent * 100));
		WindScan_set_progress (Str, var_filetrash.total_percent);
		g_free (Str);
		Str = NULL;
		var_filetrash.BoolEtat = FALSE;
		return (TRUE);
	}
	
	if (var_filetrash.bool_thread_end == TRUE) {

		WindScan_close ();
		
		fileaction_set_end (TYPE_TRASH);
		gtk_timeout_remove (var_filetrash.handler_timeout);
		on_file_button_del_file_clicked (NULL, NULL);
	}
	return (TRUE);
}
// 
// 
void filetrash_action (void)
{
	// PRINT_FUNC_LF();
	
	var_filetrash.bool_thread_end = FALSE;
	var_filetrash.ElementActif     = 0;
	var_filetrash.BoolEtat        = FALSE;
	var_filetrash.bool_pass_conv   = FALSE;
	
	WindScan_open (_("Trash"), WINDSCAN_PULSE);
	WindScan_set_label (_("<b><i>Trash files ...</i></b>"));
		
	pthread_create (&var_filetrash.nmr_tid, NULL ,(void *)filetrash_thread, (void *)NULL);
	var_filetrash.handler_timeout = gtk_timeout_add (100, filetrash_timeout, 0);
}
// 
// 
gboolean filetrash_ok (void)
{
	GList     *list = NULL;
	DETAIL    *detail = NULL;
	gboolean   BoolTrash = FALSE;
		
	var_filetrash.nbr_trash = 0;
	
	list = g_list_first (entetefile);
	while (list) {
		if (NULL != (detail = (DETAIL *)list->data)) {
			if (detail->EtatTrash != FILE_TRASH_NONE) {
				BoolTrash = TRUE;
				var_filetrash.nbr_trash ++;
			}
		}
		list = g_list_next (list);
	}
	return (BoolTrash);
}







