 /*
 *  file      : file_mp3ogg.c
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2011 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */



#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <sys/wait.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "configuser.h"
#include "dragNdrop.h"
#include "fileselect.h"
#include "tags.h"
#include "file.h"
#include "statusbar.h"




VAR_FILE_MP3OGG var_file_mp3ogg;

enum
{
	COLUMN_FILEMP3OGG_TYPE,
	COLUMN_FILEMP3OGG_BITRATE,
	COLUMN_FILEMP3OGG_NEWBITRATE,
	COLUMN_FILEMP3OGG_SIZE,
	COLUMN_FILEMP3OGG_TIME,
	COLUMN_FILEMP3OGG_NAME,
	
	COLUMN_FILEMP3OGG_POINTER_STRUCT,

	COLUMN_FILE_NUM
};
enum
{
	NUM_TREE_FILEMP3OGG_Type = 0,
	NUM_TREE_FILEMP3OGG_Bitrate,
	NUM_TREE_FILEMP3OGG_NOUVEAUBITRATE,
	NUM_TREE_FILEMP3OGG_Size,
	NUM_TREE_FILEMP3OGG_Time,
	NUM_TREE_FILEMP3OGG_Nom,

	NUM_TREE_FILEMP3OGG_ALL_COLUMN
};


gint		BitrateLameIndice = 0;		// abr .. vbr_new
gint		TabBitrateLame[4] = {0,0,0,0};	// [ abr | cbr | vbr | vbr_new ]
gint		TabModeLame[4] = {0,0,0,0};	// [ ModeAbr | ModeCbr | ModeVbr | ModeVbrNew ]

gint		BitrateOggenc = 0;		// 
gint		ManagedOggenc = 0;		// 
gint		DownmixOggenc = 0;		// 




// 
// 
gchar *FileMp3Ogg_get_param_lame_affiche (gint abr_cbr_vbr, gint bitrate, gint mode)
{
	gchar *str_abr [] = {
	"ABR: -b 32",
	"ABR: -b 40",
	"ABR: -b 48",
	"ABR: -b 56",
	"ABR: -b 64",
	"ABR: -b 80",
	"ABR: -b 96",
	"ABR: -b 112",
	"ABR: -b 128",
	"ABR: -b 160",
	"ABR: -b 192",
	"ABR: -b 224",
	"ABR: -b 256",
	"ABR: -b 320"
	};
	gchar *str_cbr [] = {
	"CBR: -b 32",
	"CBR: -b 40",
	"CBR: -b 48",
	"CBR: -b 56",
	"CBR: -b 64",
	"CBR: -b 80",
	"CBR: -b 96",
	"CBR: -b 112",
	"CBR: -b 128",
	"CBR: -b 160",
	"CBR: -b 192",
	"CBR: -b 224",
	"CBR: -b 256",
	"CBR: -b 320",
	"CBR: --preset insane"
	};
	gchar *str_vbr [] = {
	"VBR: --preset medium",
	"VBR: --preset standard",
	"VBR: --preset extreme",
	"VBR: --preset fast standard",
	"VBR: --preset fast extreme",
	"VBR: -V0",
	"VBR: -V1",
	"VBR: -V2",
	"VBR: -V3",
	"VBR: -V4",
	"VBR: -V5",
	"VBR: -V6",
	"VBR: -V7",
	"VBR: -V8",
	"VBR: -V9"
	};
	gchar *str_vbr_new [] = {
	"VBR NEW",
	"VBR NEW: --preset medium",
	"VBR NEW: --preset standard",
	"VBR NEW: --preset extreme",
	"VBR NEW: --preset fast standard",
	"VBR NEW: --preset fast extreme",
	"VBR NEW: -V0",
	"VBR NEW: -V1",
	"VBR NEW: -V2",
	"VBR NEW: -V3",
	"VBR NEW: -V4",
	"VBR NEW: -V5",
	"VBR NEW: -V6",
	"VBR NEW: -V7",
	"VBR NEW: -V8",
	"VBR NEW: -V9"
	};

	gchar *str_val_mode[] = {
	"Defaut",		/* 	*/
	"Stereo",		/* -m s	*/
	"Join Stereo",		/* -m j	*/
	"Forced Join Stereo",	/* -m f	*/
	"Duo Channels",		/* -m d	*/
	"Mono"			/* -m m	*/
	};

	gchar *PtrStrLame = NULL;
	gchar *PtrOne = NULL;
	
	if (abr_cbr_vbr < 0) return ((gchar *)g_strdup (""));
	if (bitrate < 0) return ((gchar *)g_strdup (""));

	switch (abr_cbr_vbr) {

	/* ABR */
	case 0 :
		if (bitrate > 13) bitrate = 0;
		PtrOne = g_strdup (str_abr [ bitrate ]);
		break;

	/* CBR */
	case 1 :
		if (bitrate > 14) bitrate = 0;
		PtrOne = g_strdup (str_cbr [ bitrate ]);
		break;

	/* VBR */
	case 2 :
		if (bitrate > 14) bitrate = 0;
		PtrOne = g_strdup (str_vbr [ bitrate ]);
		break;

	/* VBR_NEW */
	case 3 :
		if (bitrate > 15) bitrate = 0;
		PtrOne = g_strdup (str_vbr_new [ bitrate ]);
		break;
	default:
		return ((gchar *)g_strdup (""));
	}
	
	if (mode < 0) mode = 0;
	PtrStrLame = g_strdup_printf ("%s %s", PtrOne, str_val_mode[ mode ]);
	g_free (PtrOne);
	PtrOne = NULL;
		
	return ((gchar *)PtrStrLame);
}
// 
// 
gchar *FileMp3Ogg_get_param_oggenc_affiche (gint bitrate, gint managed, gint downmix)
{
	gchar *val[] = {
	"--bitrate=45",
	"--bitrate=64",
	"--bitrate=80",
	"--bitrate=96",
	"--bitrate=112",
	"--bitrate=128",
	"--bitrate=160",
	"--bitrate=192",
	"--bitrate=224",
	"--bitrate=256",
	"--bitrate=320",
	"--quality=-1",
	"--quality=0",
	"--quality=1",
	"--quality=2",
	"--quality=3",
	"--quality=4",
	"--quality=5",
	"--quality=6",
	"--quality=7",
	"--quality=8",
	"--quality=9",
	"--quality=10"
	};
	
	gchar StrOggenc[ 1000 ];

	if (bitrate < 0 || bitrate > 22) return ((gchar *)g_strdup (""));
	
	strcpy (StrOggenc, (gchar *)val[ bitrate ]);

	if (bitrate < 11) {
		if (managed == 0) {
			strcat (StrOggenc, " ");
			strcat (StrOggenc, "--managed");
		}
	}
	if (bitrate < 9) {
		if (downmix == 0) {
			strcat (StrOggenc, " ");
			strcat (StrOggenc, "--downmix");
		}
	}

	return ((gchar *)g_strdup (StrOggenc));
}
// MISE A JOUR DES PARAMETRES EN TENANT COMPTE DU FLAG: detail->TypeMp3Ogg.BoolChanged == TRUE
// 
void FileMp3Ogg_change_parameters (void)
{
	GtkTreeIter	iter;
	DETAIL		*detail = NULL;
	gboolean	valid;
	gchar		*PtrBitrate = NULL;

	valid = gtk_tree_model_get_iter_first (var_file_mp3ogg.Adr_Tree_Model, &iter);
	while (valid) {
	
		PtrBitrate = NULL;

		gtk_tree_model_get (var_file_mp3ogg.Adr_Tree_Model, &iter, COLUMN_FILEMP3OGG_POINTER_STRUCT, &detail, -1);
		if (NULL != detail && TRUE == detail->TypeMp3Ogg.BoolChanged) {
			if (FILE_IS_OGG == detail->type_infosong_file_is) {
				
				INFO_OGG *info = (INFO_OGG *)detail->info;
				
				detail->info = (INFO_OGG *)tagsogg_remove_info (info);
				info = (INFO_OGG *)detail->info;
				detail->info = (INFO_OGG *)tagsogg_get_info (detail);
				info = (INFO_OGG *)detail->info;
				PtrBitrate = info->Nominal_bitrate;
			}
			else if (FILE_IS_MP3 == detail->type_infosong_file_is) {
				
				INFO_MP3 *info = (INFO_MP3 *)detail->info;
				
				detail->info = (INFO_MP3 *)tagsmp3_remove_info (info);
				info = (INFO_MP3 *)detail->info;
				detail->info = (INFO_MP3 *)tagsmp3_get_info (detail);
				info = (INFO_MP3 *)detail->info;
				PtrBitrate = info->bitrate;
			}
			if (NULL != PtrBitrate) {
				gtk_list_store_set (var_file_mp3ogg.Adr_List_Store, &iter, COLUMN_FILEMP3OGG_BITRATE, PtrBitrate, -1);
				gtk_list_store_set (var_file_mp3ogg.Adr_List_Store, &iter, COLUMN_FILEMP3OGG_NEWBITRATE, "", -1);
				gtk_list_store_set (var_file_mp3ogg.Adr_List_Store, &iter, COLUMN_FILEMP3OGG_SIZE, file_get_size (detail), -1);
				gtk_list_store_set (var_file_mp3ogg.Adr_List_Store, &iter, COLUMN_FILEMP3OGG_TIME, file_get_time (detail), -1);
				
				detail->TypeMp3Ogg.type        = -1;
				detail->TypeMp3Ogg.debit [ 0 ] =
				detail->TypeMp3Ogg.debit [ 1 ] =
				detail->TypeMp3Ogg.debit [ 2 ] =
				detail->TypeMp3Ogg.debit [ 3 ] = -1;
					
				detail->TypeMp3Ogg.mode [ 0 ]  =
				detail->TypeMp3Ogg.mode [ 1 ]  =
				detail->TypeMp3Ogg.mode [ 2 ]  =
				detail->TypeMp3Ogg.mode [ 3 ]  = -1;
				
				detail->TypeMp3Ogg.BoolChanged = FALSE;
			}
			valid = gtk_tree_model_iter_next (var_file_mp3ogg.Adr_Tree_Model, &iter);
		}
	}
}
// 
// 
gboolean FileMp3Ogg_is_modified (void)
{
	GtkTreeIter	iter;
	GtkTreeModel	*model = NULL;
	GList		*list = NULL;
	GtkTreePath	*path;
	DETAIL		*detail = NULL;

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file_mp3ogg.Adr_TreeView));
	list = gtk_tree_selection_get_selected_rows (var_file_mp3ogg.Adr_Line_Selected, &model);
	list = g_list_first (list);
	while (list) {
		if (NULL != (path = list->data)) {
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file_mp3ogg.Adr_Tree_Model, &iter, COLUMN_FILEMP3OGG_POINTER_STRUCT, &detail, -1);
			if (NULL != detail &&  TRUE == detail->TypeMp3Ogg.BoolChanged) return (TRUE);
		}
		list = g_list_next (list);
	}
	return (FALSE);
}
// 
// 
gboolean FileMp3Ogg_is_selected_FILE (TYPE_FILE_IS TypeFileIs)
{
	GtkTreeIter	iter;
	GtkTreeModel	*model = NULL;
	GList		*list = NULL;
	GtkTreePath	*path;
	DETAIL		*detail = NULL;

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file_mp3ogg.Adr_TreeView));
	list = gtk_tree_selection_get_selected_rows (var_file_mp3ogg.Adr_Line_Selected, &model);
	list = g_list_first (list);
	while (list) {
		if (NULL != (path = list->data)) {
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file_mp3ogg.Adr_Tree_Model, &iter, COLUMN_FILEMP3OGG_POINTER_STRUCT, &detail, -1);
			if (NULL != detail &&  TypeFileIs == detail->type_infosong_file_is) return (TRUE);
		}
		list = g_list_next (list);
	}
	return (FALSE);
}
// ACTIVE OU DESACTIVE LES ACTIONS
// 
void FileMp3Ogg_set_flag_buttons (void)
{
	gboolean      BoolButtonsAudio [ 5 ] = { FALSE, FALSE, FALSE, FALSE, FALSE };

	// APPLIQUE
	BoolButtonsAudio [ 0 ] = 
	// EFFACE
	BoolButtonsAudio [ 1 ] = FileMp3Ogg_is_modified ();
	// COMBOBOX LAME
	BoolButtonsAudio [ 3 ] = FileMp3Ogg_is_selected_FILE (FILE_IS_MP3);
	// COMBOBOX OGGENC
	BoolButtonsAudio [ 4 ] = FileMp3Ogg_is_selected_FILE (FILE_IS_OGG);
	// SUPPRESSION DE L ENTREE
	BoolButtonsAudio [ 2 ] = BoolButtonsAudio [ 3 ] | BoolButtonsAudio [ 4 ];
	
	// ACTION
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_applique_file_mp3ogg")),			BoolButtonsAudio [ 0 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_efface_bitrate_mp3ogg")),		BoolButtonsAudio [ 1 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_del_file")),				BoolButtonsAudio [ 2 ]);
	// COMBOBOX LAME
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("eventbox_combobox_lame_abr_cbr_vbr_mp3ogg")),	BoolButtonsAudio [ 3 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("eventbox_combobox_lame_type_bitrate_mp3ogg")),	BoolButtonsAudio [ 3 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("eventbox_combobox_lame_mode_mp3ogg")),		BoolButtonsAudio [ 3 ]);
	// COMBOBOX OGGENC
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("eventbox_combobox_oggenc_bitrate_mp3ogg")),	BoolButtonsAudio [ 4 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("eventbox_combobox_oggenc_managed_mp3ogg")),	BoolButtonsAudio [ 4 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("eventbox_combobox_oggenc_downmix_m3ogg")),	BoolButtonsAudio [ 4 ]);
}
// MARQUER LES LIGNES POUR LA DESTRUCTION
// 
gboolean FileMp3Ogg_del_file_clicked (void)
{
	GtkTreeIter	iter;
	GtkTreeModel	*model = NULL;
	GList		*BeginList = NULL;
	GList		*list = NULL;
	GtkTreePath	*path;
	DETAIL		*detail = NULL;
	gboolean	 BoolPrint = FALSE;

	// RECUP. LIGNES EN SELECTION POUR DESTRUCTION
	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file_mp3ogg.Adr_TreeView));
	if ((BeginList = gtk_tree_selection_get_selected_rows (var_file_mp3ogg.Adr_Line_Selected, &model))) {
		BoolPrint = TRUE;
		list = g_list_first (BeginList);
		while (list) {
			if ((path = list->data)) {
				gtk_tree_model_get_iter (model, &iter, path);				
				gtk_tree_model_get (var_file_mp3ogg.Adr_Tree_Model, &iter, COLUMN_FILEMP3OGG_POINTER_STRUCT, &detail, -1);
				// MARQUER LA LIGNE DU GLIST A DETRUIRE AVANT LE REAFFICHAGE
				if (NULL != detail) detail->BoolRemove = TRUE;
			}
			list = g_list_next (list);
		}
		gtk_tree_selection_unselect_all (var_file_mp3ogg.Adr_Line_Selected);
	}
	return (BoolPrint);
}
// UPDATE NEW BITRATE
// 
void FileMp3Ogg_update_newbitrate (TYPE_FILE_IS p_TypeFileIs)
{
	GtkTreeModel		*model = NULL;
	GList			*list = NULL;
	GtkTreePath		*path;
	DETAIL			*detail = NULL;
	GtkTreeIter		 iter;
	gchar			*Str = NULL;

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file_mp3ogg.Adr_TreeView));
	list = g_list_first (gtk_tree_selection_get_selected_rows (var_file_mp3ogg.Adr_Line_Selected, &model));
	while (list) {
		if ((path = list->data)) {
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file_mp3ogg.Adr_Tree_Model, &iter, COLUMN_FILEMP3OGG_POINTER_STRUCT, &detail, -1);
			
			if (NULL == detail) {
				list = g_list_next(list);
				continue;
			}
			// FILE_IS_MP3
			if (FILE_IS_MP3 == p_TypeFileIs && FILE_IS_MP3 == detail->type_infosong_file_is) {
				detail->TypeMp3Ogg.type                        = BitrateLameIndice;
				detail->TypeMp3Ogg.debit [ BitrateLameIndice ] = TabBitrateLame[ BitrateLameIndice ];
				detail->TypeMp3Ogg.mode [ BitrateLameIndice ]  = TabModeLame[ BitrateLameIndice ];
				Str = FileMp3Ogg_get_param_lame_affiche (detail->TypeMp3Ogg.type,
								   detail->TypeMp3Ogg.debit [ BitrateLameIndice ],
								   detail->TypeMp3Ogg.mode [ BitrateLameIndice ]);
				gtk_list_store_set (var_file_mp3ogg.Adr_List_Store, &iter, COLUMN_FILEMP3OGG_NEWBITRATE, Str, -1);
				g_free (Str);
				Str = NULL;
				detail->TypeMp3Ogg.BoolChanged = TRUE;
			}
			// FILE_IS_OGG
			else if (FILE_IS_OGG == p_TypeFileIs && FILE_IS_OGG == detail->type_infosong_file_is) {
				detail->TypeMp3Ogg.type        = BitrateOggenc;
				detail->TypeMp3Ogg.debit [ 0 ] = ManagedOggenc;
				detail->TypeMp3Ogg.mode [ 0 ]  = DownmixOggenc;
				Str = FileMp3Ogg_get_param_oggenc_affiche (BitrateOggenc,
								     ManagedOggenc,
								     DownmixOggenc);
				gtk_list_store_set (var_file_mp3ogg.Adr_List_Store, &iter, COLUMN_FILEMP3OGG_NEWBITRATE, Str, -1);
				g_free (Str);
				Str = NULL;
				detail->TypeMp3Ogg.BoolChanged = TRUE;
			}
		}

		list = g_list_next(list);
	}
	FileMp3Ogg_set_flag_buttons ();
}
// 
// 
void FileMp3Ogg_affiche_glist (void)
{
	DETAIL		*detail = NULL;
	GList		*List = NULL;
	GList		*FreegList = NULL;
	GtkTreeIter	iter;
	GtkAdjustment	*Adj = NULL;
	gdouble		AdjValue;
	gint		*TabInt = NULL;		// TABLEAU DES LIGNES EN SELECTION
	gint		Cpt = 0;		// INDICE DANS LE TABLEAU
	gint		Line = 0;		// LIGNE EN COURS
	INFO_MP3	*info_mp3 = NULL;
	INFO_OGG	*info_ogg = NULL;
	gchar		*StrInfo = NULL;
	gchar		*PtrBitrate = NULL;
	gchar		*NameDest = NULL;

	
	// LIBERATION LIGNE(S) DU GLIST SI NECESSARE
	// 
	List = g_list_first (entetefile);
	while (List) {
		if ((detail = (DETAIL *)List->data) && TRUE == detail->BoolRemove) {
			FreegList = List;
			FreegList->data = NULL;
			List = g_list_next (List);
			entetefile = g_list_remove_link (entetefile, FreegList);
			List = g_list_first (entetefile);
			continue;
		}
		List = g_list_next (List);
	}
	
	// RECUP SELECTION
	// 
	TabInt = libutils_get_tab_selected_line (var_file_mp3ogg.Adr_Line_Selected, var_file_mp3ogg.Adr_Tree_Model);

	// DELETE TREEVIEW
	// 
	gtk_list_store_clear (GTK_LIST_STORE (var_file_mp3ogg.Adr_List_Store));
	
	// COORDONNEES POUR UN REAJUSTEMENT VISUEL DE LA PAGE
	// 
	Adj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (var_file_mp3ogg.Adr_scroll));
	AdjValue = gtk_adjustment_get_value (Adj);
	
	// AFFICHAGE DE LA LISTE
	// 
	Cpt = 0;
	Line = 0;
	List = g_list_first (entetefile);
	while (List) {
		if (NULL != ((detail = (DETAIL *)List->data)) && FALSE == detail->BoolRemove) {
			
			if (FILE_IS_MP3 == detail->type_infosong_file_is) {
				if (NULL != (info_mp3 = (INFO_MP3 *)detail->info)) PtrBitrate = info_mp3->bitrate;
			}
			else if (FILE_IS_OGG == detail->type_infosong_file_is) {
				if (NULL != (info_ogg = (INFO_OGG *)detail->info)) PtrBitrate = info_ogg->Nominal_bitrate;
			}
			else {
				List = g_list_next (List);
				Line ++;
				continue;
			}
			if (NULL == info_mp3 && NULL == info_ogg) {
				List = g_list_next (List);
				Line ++;
				continue;
			}
			
			if (detail->type_infosong_file_is == FILE_IS_MP3) {
				StrInfo = FileMp3Ogg_get_param_lame_affiche (detail->TypeMp3Ogg.type,
								       detail->TypeMp3Ogg.debit [ detail->TypeMp3Ogg.type ],
								       detail->TypeMp3Ogg.mode [ detail->TypeMp3Ogg.type ]);
			}
			else {
				StrInfo = FileMp3Ogg_get_param_oggenc_affiche (detail->TypeMp3Ogg.type,
									 detail->TypeMp3Ogg.debit [ 0 ],
									 detail->TypeMp3Ogg.mode [ 0 ]);
			}
			
			NameDest = libutils_get_name_without_ext (detail->namefile);
			
			gtk_list_store_append (var_file_mp3ogg.Adr_List_Store, &iter);
			gtk_list_store_set (var_file_mp3ogg.Adr_List_Store, &iter,
						COLUMN_FILEMP3OGG_TYPE,			tags_get_str_type_file_is (detail->type_infosong_file_is),
						COLUMN_FILEMP3OGG_BITRATE,		PtrBitrate,
						COLUMN_FILEMP3OGG_NEWBITRATE,		detail->TypeMp3Ogg.BoolChanged == TRUE ? StrInfo : "",
						COLUMN_FILEMP3OGG_SIZE,			file_get_size (detail),
						COLUMN_FILEMP3OGG_TIME,			file_get_time (detail),
						COLUMN_FILEMP3OGG_NAME,			NameDest,
						COLUMN_FILEMP3OGG_POINTER_STRUCT,	detail,
						-1);
			
			g_free (NameDest);	NameDest = NULL;
			g_free (StrInfo);	StrInfo = NULL;
			
			// AFFICHE LES EVENTUELLES LIGNES EN SELECTION
			// 
			if (NULL != TabInt) {
				if (Line == *(TabInt + Cpt)) {
					gtk_tree_selection_select_iter (var_file_mp3ogg.Adr_Line_Selected, &iter);
					Cpt ++;
				}
				Line ++;
			}
		}
		List = g_list_next (List);
	}
	
	// SUPPRESSON TABLEAU DES EVENTUELLES LIGNES EN SELECTION
	// 
	if (NULL != TabInt) {
		g_free (TabInt);
		TabInt = NULL;
	}
	else {
		if (gtk_tree_model_get_iter_first (var_file_mp3ogg.Adr_Tree_Model, &iter))
			gtk_tree_selection_select_iter (var_file_mp3ogg.Adr_Line_Selected, &iter);
	}

	// REAJUSTEMENT DE LA LISTE
	// 
	gtk_adjustment_set_value (Adj, AdjValue);
	gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW (var_file_mp3ogg.Adr_scroll), Adj);

	FileMp3Ogg_set_flag_buttons ();
}
// 
// 
void on_filemp3ogg_button_efface_bitrate_clicked (GtkButton *button, gpointer user_data)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *BeginList = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;

	// CHERCHE LES ELEMENTS A DETRUIRE
	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file_mp3ogg.Adr_TreeView));
	BeginList = gtk_tree_selection_get_selected_rows (var_file_mp3ogg.Adr_Line_Selected, &model);
	list = g_list_first (BeginList);
	while (list) {
		if (NULL != (path = list->data)) {
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file_mp3ogg.Adr_Tree_Model, &iter, COLUMN_FILEMP3OGG_POINTER_STRUCT, &detail, -1);
			if (NULL != detail) {
				if (detail->type_infosong_file_is == FILE_IS_MP3 || detail->type_infosong_file_is == FILE_IS_OGG) {
					detail->TypeMp3Ogg.type        = -1;
					detail->TypeMp3Ogg.debit [ 0 ] =
					detail->TypeMp3Ogg.debit [ 1 ] =
					detail->TypeMp3Ogg.debit [ 2 ] =
					detail->TypeMp3Ogg.debit [ 3 ] = -1;
					
					detail->TypeMp3Ogg.mode [ 0 ]  =
					detail->TypeMp3Ogg.mode [ 1 ]  =
					detail->TypeMp3Ogg.mode [ 2 ]  =
					detail->TypeMp3Ogg.mode [ 3 ]  = -1;
					
					detail->TypeMp3Ogg.BoolChanged = FALSE;
				}
				gtk_list_store_set (var_file_mp3ogg.Adr_List_Store, &iter, COLUMN_FILEMP3OGG_NEWBITRATE, "", -1);
			}
		}
		list = g_list_next (list);
	}
	FileMp3Ogg_set_flag_buttons ();
}
// 
// 
DETAIL *FileMp3Ogg_get (TYPE_FILE_IS p_TypeFileIs, gint *p_type, gint *p_debit, gint *p_mode)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *begin_list = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;

	*p_type  =  0;
	*p_debit =  0;
	*p_mode  =  0;
	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file_mp3ogg.Adr_TreeView));
	if (NULL != (begin_list = gtk_tree_selection_get_selected_rows (var_file_mp3ogg.Adr_Line_Selected, &model))) {
		list = g_list_first (begin_list);
		while (list) {
			if (NULL != (path = list->data)) {
				gtk_tree_model_get_iter (model, &iter, path);
				gtk_tree_model_get (var_file_mp3ogg.Adr_Tree_Model, &iter, COLUMN_FILEMP3OGG_POINTER_STRUCT, &detail, -1);
				if (NULL != detail){
					if (p_TypeFileIs == detail->type_infosong_file_is && FILE_IS_MP3 == p_TypeFileIs) {
						*p_type  =  detail->TypeMp3Ogg.type;
						*p_debit =  detail->TypeMp3Ogg.debit [ detail->TypeMp3Ogg.type ];
						*p_mode  =  detail->TypeMp3Ogg.mode [ detail->TypeMp3Ogg.type ];
						break;
					}
					else if (p_TypeFileIs == detail->type_infosong_file_is && FILE_IS_OGG == p_TypeFileIs) {
						*p_type  =  detail->TypeMp3Ogg.type;
						*p_debit =  detail->TypeMp3Ogg.debit [ 0 ];
						*p_mode  =  detail->TypeMp3Ogg.mode [ 0 ];
						break;
					}
					else detail = NULL;
				}
			}
			list = g_list_next (list);
		}
	}
	// g_print("FileMp3Ogg_get ->   ");
	// if (NULL != detail) g_print("detail->TypeMp3Ogg.BoolChanged=%s  ", detail->TypeMp3Ogg.BoolChanged ? "TRUE" : "FALSE");
	// g_print("type=%d  debit=%d  mode=%d\n", *p_type,*p_debit,*p_mode);
	// if (*p_type < 0)	*p_type  = 0;
	// if (*p_debit < 0)	*p_debit = 0;
	// if (*p_mode < 0)	*p_mode  = 0;
	
	return ((DETAIL *)detail);
}
// 
// 
void on_combobox_lame_abr_cbr_vbr_mp3ogg_realize (GtkWidget *widget, gpointer user_data)
{
	var_file_mp3ogg.Adr_Widget_Lame_abr_cbr_vbr = GTK_COMBO_BOX (widget);
	// libcombo_alloc (GTK_COMBO_BOX (widget));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "ABR");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "CBR");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "VBR");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "VBR-NEW");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
}
// 
// 
void on_combobox_lame_abr_cbr_vbr_mp3ogg_changed (GtkComboBox *combobox, gpointer user_data)
{
	gint	ind;
	
	if (NULL == var_file_mp3ogg.Adr_Widget_Lame_bitrate) return;
	if (NULL == var_file_mp3ogg.Adr_Widget_Lame_abr_cbr_vbr) return;
	if ((ind = gtk_combo_box_get_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_abr_cbr_vbr))) < 0) return;
	BitrateLameIndice = ind;
	
	switch (BitrateLameIndice) {
	// ABR 0 .. 13
	case 0 :
		libcombo_alloc (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate));
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), " 32");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), " 40");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), " 48");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), " 56");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), " 64");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), " 80");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), " 96");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "112");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "128");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "160");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "192");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "224");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "256");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "320");
		break;
	// CBR 0 .. 14
	case 1 :
		libcombo_alloc (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate));
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), " 32");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), " 40");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), " 48");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), " 56");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), " 64");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), " 80");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), " 96");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "112");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), _("128 -defaut"));
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "160");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "192");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "224");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "256");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "320");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "preset insane");
		break;
	// VBR 0 .. 14
	case 2 :
		libcombo_alloc (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate));
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "preset medium");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "preset standard");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "preset extreme");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "preset fast standard");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "preset fast extreme");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), _("V0 -meilleure qualite"));
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "V1");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "V2");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "V3");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), _("V4 -defaut"));
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "V5");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "V6");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "V7");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "V8");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), _("V9 -moins bonne qualite"));
		break;
	// VBR_NEW 0 .. 14
	case 3 :
		libcombo_alloc (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate));
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), " ");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "preset medium");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "preset standard");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "preset extreme");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "preset fast standard");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "preset fast extreme");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "V0");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "V1");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "V2");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "V3");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), _("V4 -defaut"));
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "V5");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "V6");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "V7");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "V8");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), "V9");
		break;
	}
	gtk_combo_box_set_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), TabBitrateLame[ BitrateLameIndice ]);
	if (NULL != var_file_mp3ogg.Adr_Widget_Lame_Mode)
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_Mode), TabModeLame[ BitrateLameIndice ]);
	
	FileMp3Ogg_update_newbitrate (FILE_IS_MP3);
}
// 
// 
void on_combobox_lame_type_bitrate_mp3ogg_realize (GtkWidget *widget, gpointer user_data)
{
	var_file_mp3ogg.Adr_Widget_Lame_bitrate = GTK_COMBO_BOX (widget);
	on_combobox_lame_abr_cbr_vbr_mp3ogg_changed (NULL,NULL);
}
// 
// 
void on_combobox_lame_type_bitrate_mp3ogg_changed (GtkComboBox *combobox, gpointer user_data)
{
	gint	ind;
	
	if (var_file_mp3ogg.Adr_Widget_Lame_abr_cbr_vbr == NULL || var_file_mp3ogg.Adr_Widget_Lame_bitrate == NULL) return;
	if ((ind = gtk_combo_box_get_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate))) < 0) return;
	TabBitrateLame[ BitrateLameIndice ] = ind;
	FileMp3Ogg_update_newbitrate (FILE_IS_MP3);
}
// 
// 
void on_combobox_lame_mode_mp3ogg_realize (GtkWidget *widget, gpointer user_data)
{
	var_file_mp3ogg.Adr_Widget_Lame_Mode = GTK_COMBO_BOX (widget);
	libcombo_alloc (GTK_COMBO_BOX (widget));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Defaut"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Stereo");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Join Stereo");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Forced Join Stereo");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Duo Channels");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Mono");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), TabModeLame[ BitrateLameIndice ]);
}
// 
// 
void on_combobox_lame_mode_mp3ogg_changed (GtkComboBox *combobox, gpointer user_data)
{
	gint	ind;
	
	if (var_file_mp3ogg.Adr_Widget_Lame_Mode == NULL) return;
	if ((ind = gtk_combo_box_get_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_Mode))) < 0) return;
	TabModeLame[ BitrateLameIndice ] = ind;
	FileMp3Ogg_update_newbitrate (FILE_IS_MP3);
}
// 
// 
void on_combobox_oggenc_bitrate_mp3ogg_realize (GtkWidget *widget, gpointer user_data)
{
	libcombo_alloc (GTK_COMBO_BOX (widget));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 45  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 64  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 80  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 96  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "112  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "128  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "160  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "192  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "224  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "256  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "320  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite -1 -Moins bonne qualite"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  0"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  1"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  2"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  3 -Defaut"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  4"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  5"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  6"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  7"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  8"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  9"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  10 -Meilleure qualite"));
	var_file_mp3ogg.Adr_Widget_Oggenc_bitrate = GTK_COMBO_BOX (widget);
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), BitrateOggenc);
}
// 
// 
void on_combobox_oggenc_bitrate_mp3ogg_changed (GtkComboBox *combobox, gpointer user_data)
{
	if (var_file_mp3ogg.Adr_Widget_Oggenc_bitrate == NULL) return;
	
	gtk_widget_set_sensitive (
		GTK_WIDGET (GLADE_GET_OBJECT("combobox_oggenc_managed_mp3ogg")),
		gtk_combo_box_get_active (var_file_mp3ogg.Adr_Widget_Oggenc_bitrate) < 11 ? TRUE : FALSE);
	gtk_widget_set_sensitive (
		GTK_WIDGET (GLADE_GET_OBJECT("combobox_oggenc_downmix_m3ogg")),
		gtk_combo_box_get_active (var_file_mp3ogg.Adr_Widget_Oggenc_bitrate) < 9 ? TRUE : FALSE);
	
	if (NULL != var_file_mp3ogg.Adr_Widget_Oggenc_bitrate)
		BitrateOggenc = gtk_combo_box_get_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Oggenc_bitrate));
	if (NULL != var_file_mp3ogg.Adr_Widget_Oggenc_managed)
		ManagedOggenc = gtk_combo_box_get_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Oggenc_managed));
	if (NULL != var_file_mp3ogg.Adr_Widget_Oggenc_downmix)
		DownmixOggenc = gtk_combo_box_get_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Oggenc_downmix));
	
	FileMp3Ogg_update_newbitrate (FILE_IS_OGG);
}
// 
// 
void on_combobox_oggenc_managed_mp3ogg_realize (GtkWidget *widget, gpointer user_data)
{
	libcombo_alloc (GTK_COMBO_BOX (widget));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Oui"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Non"));
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), ManagedOggenc);
	var_file_mp3ogg.Adr_Widget_Oggenc_managed = GTK_COMBO_BOX (widget);
}
// 
// 
void on_combobox_oggenc_managed_mp3ogg_changed (GtkComboBox *combobox, gpointer user_data)
{
	if (NULL != var_file_mp3ogg.Adr_Widget_Oggenc_bitrate)
		BitrateOggenc = gtk_combo_box_get_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Oggenc_bitrate));
	if (NULL != var_file_mp3ogg.Adr_Widget_Oggenc_managed)
		ManagedOggenc = gtk_combo_box_get_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Oggenc_managed));
	if (NULL != var_file_mp3ogg.Adr_Widget_Oggenc_downmix)
		DownmixOggenc = gtk_combo_box_get_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Oggenc_downmix));
	
	FileMp3Ogg_update_newbitrate (FILE_IS_OGG);
}
// 
// 
void on_combobox_oggenc_downmix_m3ogg_realize (GtkWidget *widget, gpointer user_data)
{
	libcombo_alloc (GTK_COMBO_BOX (widget));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Mono force"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Stereo"));
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), DownmixOggenc);
	var_file_mp3ogg.Adr_Widget_Oggenc_downmix = GTK_COMBO_BOX (widget);
}
// 
// 
void on_combobox_oggenc_downmix_m3ogg_changed (GtkComboBox *combobox, gpointer user_data)
{
	if (NULL != var_file_mp3ogg.Adr_Widget_Oggenc_bitrate)
		BitrateOggenc = gtk_combo_box_get_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Oggenc_bitrate));
	if (NULL != var_file_mp3ogg.Adr_Widget_Oggenc_managed)
		ManagedOggenc = gtk_combo_box_get_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Oggenc_managed));
	if (NULL != var_file_mp3ogg.Adr_Widget_Oggenc_downmix)
		DownmixOggenc = gtk_combo_box_get_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Oggenc_downmix));
	
	FileMp3Ogg_update_newbitrate (FILE_IS_OGG);
}
// 
// 
void FileMp3Ogg_changed_selection_row (GtkTreeSelection *selection, gpointer data)
{
	DETAIL	*detail = NULL;
	gint	 type, debit, mode;
	
	var_file_mp3ogg.Adr_Line_Selected = selection;
	
	if (NULL != (detail = FileMp3Ogg_get (FILE_IS_MP3, &type, &debit, &mode))) {
		if (type > -1 && debit > -1 && mode > -1) {
			BitrateLameIndice                   = type;
			TabBitrateLame[ BitrateLameIndice ] = debit;
			TabModeLame[ BitrateLameIndice ]    = mode;
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_abr_cbr_vbr), type);
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_bitrate), debit);
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Lame_Mode), mode);
		}
	}
	else if (NULL != (detail = FileMp3Ogg_get (FILE_IS_OGG, &type, &debit, &mode))) {
		if (type > -1 && debit > -1 && mode > -1) {
			BitrateOggenc = type;
			ManagedOggenc = debit;
			DownmixOggenc = mode;
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Oggenc_bitrate), type);
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Oggenc_managed), debit);
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_file_mp3ogg.Adr_Widget_Oggenc_downmix), mode);
		}
	}
	FileMp3Ogg_set_flag_buttons ();
}
// 
// 
gboolean FileMp3Ogg_key_press_event (GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
	if (keys.BoolGDK_Control_A == TRUE) {
		gtk_tree_selection_unselect_all (var_file_mp3ogg.Adr_Line_Selected);
		gtk_tree_selection_select_all (var_file_mp3ogg.Adr_Line_Selected);
	}
	if (event->keyval == GDK_Delete) {
		GtkTreeIter   iter;
		if (gtk_tree_model_get_iter_first (var_file_mp3ogg.Adr_Tree_Model, &iter)) {
			on_file_button_del_file_clicked (NULL, NULL);
			return (FALSE);
		}
	}
	return (TRUE);
}
// AFFICHAGE DU NOM COMPLET DU FICHIER SI SURVOL PAR LE CURSEUR SOURIS DU CHAMPS 'Nom'
// 
gboolean FileMp3Ogg_event (GtkWidget *treeview, GdkEvent *event, gpointer user_data)
{
	gint                x, y;
	GdkModifierType     state;
	GtkTreePath        *path;
	GtkTreeViewColumn  *column;
	GtkTreeViewColumn  *ColumnDum;
	GtkTreeIter         iter;
	GtkTreeModel       *model = (GtkTreeModel *)user_data;
	DETAIL             *detail = NULL;
	gint                Pos_X = 0, Pos_Y = 0;
	gint                i;
	gboolean            BoolSelectColNom = FALSE;
	
	// SI PAS DANS LE TREEVIEW
	gdk_window_get_pointer (((GdkEventButton*)event)->window, &x, &y, &state);
	if (FALSE == gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW(treeview),
					   x, y,
					   &path, &column, &Pos_X, &Pos_Y)) {
		StatusBar_set_mess( NOTEBOOK_FICHIERS, _STATUSBAR_SIMPLE_, "" );
		return (FALSE);
	}
	
	// RECUPERATION DE LA STRUCTURE POINTEE PAR LE CURSEUR SOURIS
	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (var_file_mp3ogg.Adr_Tree_Model, &iter, COLUMN_FILEMP3OGG_POINTER_STRUCT, &detail, -1);
	if (NULL == detail) return (FALSE);
	
	// DANS TOUS LES CAS, EFFACE LA BARRE DE TACHE
	StatusBar_set_mess( NOTEBOOK_FICHIERS, _STATUSBAR_SIMPLE_, "" );

	/* IDEE POUR REMPLACER LES COMPARAISON PAR NOMS. EXEMPLES:
	 * 	PLAY	= 0
	 * 	TRASH	= 1
	 *	TYPE	= 2
	 * 	etc ...
	 * NOTA:
	 * 	CET ALGO PERMET DE RENOMMER AISEMENT LES ENTETES DE COLONNES DANS TOUTES LES LANGUES: FR, EN, DE, ...
	 */
	for (i = 0; i < NUM_TREE_FILEMP3OGG_ALL_COLUMN; i ++) {
		ColumnDum = gtk_tree_view_get_column (GTK_TREE_VIEW(treeview), i);
		if (ColumnDum == column) {
			switch ( i ) {
			case NUM_TREE_FILEMP3OGG_Nom :		BoolSelectColNom		= TRUE;	break;
			default: 
				StatusBar_set_mess( NOTEBOOK_FICHIERS, _STATUSBAR_SIMPLE_, "");
				StatusBar_puts();
				return (FALSE);
			}
			/* La colonne est trouvee ... sortie de la boucle */
			break;
		}
	}
	if (BoolSelectColNom) {
		StatusBar_set_mess( NOTEBOOK_FICHIERS, _STATUSBAR_SIMPLE_, detail->namefile);
	}
	
	StatusBar_puts( );
	
	return (FALSE);
}
// 
// 
static void FileMp3Ogg_drag_data_received (GtkWidget	   *widget,
					GdkDragContext     *drag_context,
					gint                x,
					gint                y,
					GtkSelectionData   *data,
					guint               info,
					guint               time)
{
        /* Une copie ne peut aller vers elle meme !!! */
	if (gtk_drag_get_source_widget(drag_context) != widget) {
		dragndrop_list_drag_data (widget, (gchar *)data->data);
	}
}
// 
// 
static void FileMp3Ogg_drag_data_drop (GtkWidget *widget,
					GdkDragContext *dc,
					GtkSelectionData *selection_data,
					guint info,
					guint t,
					gpointer data)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *begin_list = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;
	gchar            *text = NULL;

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(widget));
	begin_list = gtk_tree_selection_get_selected_rows (var_file_mp3ogg.Adr_Line_Selected, &model);
	list = g_list_first (begin_list);
	while (list) {
		if ((path = list->data)) {
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file_mp3ogg.Adr_Tree_Model, &iter, COLUMN_FILEMP3OGG_POINTER_STRUCT, &detail, -1);
			/*g_print ("detail->namefile = %s\n", detail->namefile);*/
			text = g_strdup (detail->namefile);
			gtk_selection_data_set (selection_data,
						GDK_SELECTION_TYPE_STRING,
						8,	/* 8 bits per character. */
						(const guchar *)text,
						strlen(text)
						);
			g_free (text);
			text = NULL;
		}
		list = g_list_next (list);
	}
}
// 
// 
gboolean FileMp3Ogg_event_click_mouse (GtkWidget *treeview, GdkEventButton *event, gpointer data)
{
	return (FALSE);
}
// 
// 
static void FileMp3Ogg_add_columns_scrolledwindow (GtkTreeView *treeview)
{
	GtkCellRenderer   *renderer;
	GtkTreeViewColumn *column;
	GtkTreeModel      *model = gtk_tree_view_get_model (treeview);
	
	// SIGNAL : 'event'
	g_signal_connect(G_OBJECT(treeview),
			 "event",
                    	 (GCallback) FileMp3Ogg_event,
			 model);

	// SIGNAL : 'Gestion click click'
	g_signal_connect(G_OBJECT(treeview),
			 "button-press-event",
                    	 (GCallback) FileMp3Ogg_event_click_mouse,
			 model);
	
	// SIGNAL : Ligne actuellement selectionnee 'changed'
	var_file_mp3ogg.Adr_Line_Selected = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
	g_signal_connect(G_OBJECT(var_file_mp3ogg.Adr_Line_Selected),
			 "changed",
                   	 G_CALLBACK(FileMp3Ogg_changed_selection_row),
                   	 "1");
	
	// SIGNAL 'key-press-event'
	g_signal_connect(G_OBJECT(treeview),
			 "key-press-event",
                    	 (GCallback) FileMp3Ogg_key_press_event,
			 model);
	
	// Drag and drop support
	// SIGNAL : 'drag-data-received'
	gtk_drag_dest_set (GTK_WIDGET (treeview),
			   GTK_DEST_DEFAULT_MOTION |
			   GTK_DEST_DEFAULT_DROP,
			   drag_types, n_drag_types,
			   GDK_ACTION_COPY| GDK_ACTION_MOVE );
	g_signal_connect(G_OBJECT(treeview),
			 "drag-data-received",
			 G_CALLBACK(FileMp3Ogg_drag_data_received),
			 NULL);

	gtk_drag_source_set(
			GTK_WIDGET(treeview),
			GDK_BUTTON1_MASK | GDK_BUTTON2_MASK | GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_DROP,
			drag_types, n_drag_types,
			GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_DEFAULT
			);

	g_signal_connect(G_OBJECT(treeview),
      			"drag-data-get",
			 G_CALLBACK(FileMp3Ogg_drag_data_drop),
			 treeview);
	
	// COLUMN_FILEMP3OGG_PLAY 
	// var_file_mp3ogg.Adr_ColumnFileMp3OggPlay =
	
	// COLUMN_FILEMP3OGG_TYPE
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file_mp3ogg.Adr_ColumnFileMp3OggType =
	column = gtk_tree_view_column_new_with_attributes (_("Type"),
						     renderer,
						     "text", COLUMN_FILEMP3OGG_TYPE,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 90);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	/* TRIS */
	gtk_tree_view_column_set_sort_column_id (column, COLUMN_FILEMP3OGG_TYPE);
	gtk_tree_view_append_column (treeview, column);
	
	// COLUMN_FILEMP3OGG_BITRATE
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file_mp3ogg.Adr_ColumnFileMp3OggBitrate =
	column = gtk_tree_view_column_new_with_attributes (_("Bitrate"),
						     renderer,
						     "text", COLUMN_FILEMP3OGG_BITRATE,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 90);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	// TRIS
	gtk_tree_view_column_set_sort_column_id (column, COLUMN_FILEMP3OGG_BITRATE);
	gtk_tree_view_append_column (treeview, column);
	
	// COLUMN_FILEMP3OGG_NEWBITRATE
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file_mp3ogg.Adr_ColumnFileMp3OggNewBitrate =
	column = gtk_tree_view_column_new_with_attributes (_("Nouveau bitrate"),
						     renderer,
						     "markup", COLUMN_FILEMP3OGG_NEWBITRATE,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 350);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	
	// COLUMN_FILEMP3OGG_SIZE
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file_mp3ogg.Adr_ColumnFileMp3OggSize =
	column = gtk_tree_view_column_new_with_attributes (_("Taille"),
						     renderer,
						     "text", COLUMN_FILEMP3OGG_SIZE,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 90);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	
	// COLUMN_FILEMP3OGG_TIME
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file_mp3ogg.Adr_ColumnFileMp3OggTime =
	column = gtk_tree_view_column_new_with_attributes (_("Temps"),
						     renderer,
						     "text", COLUMN_FILEMP3OGG_TIME,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 90);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	
	// COLUMN_FILEMP3OGG_NAME
	var_file_mp3ogg.Renderer =
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_file_mp3ogg.Adr_ColumnFileMp3OggName =
	column = gtk_tree_view_column_new_with_attributes (_("Nom"),
						     renderer,
						     "markup", COLUMN_FILEMP3OGG_NAME,
						     NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 90);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
}
// 
// 
void on_scrolledwindow_file_mp3ogg_realize (GtkWidget *widget, gpointer user_data)
{
	GtkListStore *store;
	GtkTreeModel *model;
	GtkWidget    *treeview;

	var_file_mp3ogg.Adr_scroll = widget;

	var_file_mp3ogg.Pixbuf_NotInstall		= libutils_init_pixbufs ("xcfa/not_install.png");
	
	var_file_mp3ogg.Adr_List_Store = store =
	gtk_list_store_new (	COLUMN_FILE_NUM,	/* TOTAL NUMBER			*/
				G_TYPE_STRING,		/* COLUMN_FILEMP3OGG_TYPE	*/
				G_TYPE_STRING,		/* COLUMN_FILEMP3OGG_BITRATE	*/
				G_TYPE_STRING,		/* COLUMN_FILEMP3OGG_NEWBITRATE	*/
				G_TYPE_STRING,		/* COLUMN_FILEMP3OGG_SIZE	*/
				G_TYPE_STRING,		/* COLUMN_FILEMP3OGG_TIME	*/
				G_TYPE_STRING,		/* COLUMN_FILEMP3OGG_NAME	*/
				G_TYPE_POINTER          /* COLUMN_FILEMP3OGG_POINTER_STRUCT	*/
			   );
	var_file_mp3ogg.Adr_Tree_Model = model = GTK_TREE_MODEL (store);
	var_file_mp3ogg.Adr_TreeView =
	treeview = gtk_tree_view_new_with_model (model);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);
	gtk_tree_selection_set_mode (gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview)), GTK_SELECTION_MULTIPLE);	// GTK_SELECTION_BROWSE MULTIPLE
	g_object_unref (model);
	gtk_container_add (GTK_CONTAINER (widget), treeview);
	FileMp3Ogg_add_columns_scrolledwindow (GTK_TREE_VIEW (treeview));
	gtk_widget_show_all (widget);
}

