 /*
 *  file      : cd_expander.c
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2011 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */



#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <stdlib.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "file.h"
#include "cd_audio.h"
#include "configuser.h"
#include "parse.h"




gboolean Bool_Changed_Ok = TRUE;



// 
// 
void cdexpander_set_sensitive_notebook (void)
{
	CD_AUDIO	*Audio = NULL;
	
	if (NULL == var_cd.Adr_notebook) return;
	Audio = cdaudio_get_line_selected ();
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("table_tags_expanderCD")), Audio ? TRUE : FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("vbox_titres_expanderCD")), Audio ? TRUE : FALSE);
}
// 
// 
void cdexpander_set_entry_tag_titre_album (void)
{
	CD_AUDIO            *Audio = NULL;
	
	if (NULL == var_cd.Adr_entry_tag_titre_album) return;
	if (NULL != (Audio = cdaudio_get_line_selected ())) {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_album), Audio->tags->Album);
		Bool_Changed_Ok = TRUE;
	}
	else {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_album), "");
		Bool_Changed_Ok = TRUE;
	}
}
// 
// 
void cdexpander_set_entry_tag_nom_artiste (void)
{
	CD_AUDIO            *Audio = NULL;
	
	if (NULL == var_cd.Adr_entry_tag_nom_artiste) return;
	if (NULL != (Audio = cdaudio_get_line_selected ())) {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_nom_artiste), Audio->tags->Artist);
		Bool_Changed_Ok = TRUE;
	}
	else {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_nom_artiste), "");
		Bool_Changed_Ok = TRUE;
	}
}
// 
// 
void cdexpander_set_spinbutton_tag_piste (void)
{
	CD_AUDIO        *Audio = NULL;
	
	if (NULL != (Audio = cdaudio_get_line_selected ()) && NULL != var_cd.Adr_spinbutton_tag_piste) {
		Bool_Changed_Ok = FALSE;
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (var_cd.Adr_spinbutton_tag_piste), (gdouble)Audio->tags->IntNumber);
		Bool_Changed_Ok = TRUE;
	}
}
// 
// 
void cdexpander_set_spinbutton_tag_annee (void)
{
	CD_AUDIO        *Audio = NULL;
	
	if (NULL != (Audio = cdaudio_get_line_selected ()) && NULL != var_cd.Adr_spinbutton_tag_annee) {
		Bool_Changed_Ok = FALSE;
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (var_cd.Adr_spinbutton_tag_annee), (gdouble)Audio->tags->IntYear);
		Bool_Changed_Ok = TRUE;
	}
}
// 
// 
gint cdexpander_get_spinbutton_tag_annee (void)
{
	if (NULL != var_cd.Adr_spinbutton_tag_annee) {
		return (gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(var_cd.Adr_spinbutton_tag_annee)));
	}
	return (0);
}
// 
// 
void cdexpander_set_entry_tag_titre_chanson (void)
{
	CD_AUDIO            *Audio = NULL;
	
	if (NULL != (Audio = cdaudio_get_line_selected ()) && NULL != var_cd.Adr_entry_tag_titre_chanson) {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_chanson), Audio->tags->Title);
		Bool_Changed_Ok = TRUE;		
	}
	else {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_chanson), "");
		Bool_Changed_Ok = TRUE;
	}
}
// 
// 
void cdexpander_set_new_genre (void)
{
	CD_AUDIO            *Audio = NULL;

	if (NULL != (Audio = cdaudio_get_line_selected ()) && NULL != var_cd.Adr_combobox_tag_genre_cd) {
		Bool_Changed_Ok = FALSE;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_cd.Adr_combobox_tag_genre_cd), tags_get_elements_combobox (Audio->tags->IntGenre));
		Bool_Changed_Ok = TRUE;
	}
}
// 
// 
void cdexpander_set_entry_new_titre_cdaudio (gchar *p_str)
{
	if (NULL != var_cd.Adr_entry_new_titre_cdaudio && NULL != p_str) {
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio), p_str);
	}
}
// 
// 
void cdexpander_set_entry_tag_commentaire (void)
{
	CD_AUDIO            *Audio = NULL;
	
	if (NULL != (Audio = cdaudio_get_line_selected ()) && NULL != var_cd.Adr_entry_tag_commentaire) {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_commentaire), Audio->tags->Comment);
		Bool_Changed_Ok = TRUE;		
	}
	else {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_commentaire), "");
		Bool_Changed_Ok = TRUE;
	}
}
// 
// 
void cdexpander_set_entry_tag_titre_fichier_m3u (void)
{
	if (FALSE == Bool_Changed_Ok) return;
	if (NULL != var_cd.Adr_entry_tag_titre_fichier) {
		Bool_Changed_Ok = FALSE;
		// m3u
		// xspf
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_fichier), Config.StringNameFile_m3u_xspf ? Config.StringNameFile_m3u_xspf : "");
		Bool_Changed_Ok = TRUE;		
	}
}
// 
// 
void on_entry_tag_titre_chanson_changed (GtkEditable *editable, gpointer user_data)
{
	gchar        *ptr_template = NULL;
	CD_AUDIO     *Audio = NULL;
	gchar        *str = NULL;
	gchar        *ptr = NULL;
	
	if (!var_cd.Adr_entry_tag_titre_chanson) return;
	ptr_template = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_chanson));
	
	/* Suppression du caracteres '/' interdit si il existe */
	str = g_strdup (ptr_template);
	if (strchr (str, '/')) {
		while ((ptr = strchr (str, '/'))) {
			strcpy (ptr, ptr+1);
		}
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_chanson), str);
	}
	g_free (str);
	str = NULL;

	if (FALSE == Bool_Changed_Ok) return;
	if (NULL != (Audio = cdaudio_get_line_selected ())) {
		g_free (Audio->tags->Title);
		Audio->tags->Title = NULL;
		Audio->tags->Title = g_strdup (ptr_template);
	}
	cdaudio_set_titre_chanson ();
}
// 
// 
void on_entry_tag_titre_album_changed (GtkEditable *editable, gpointer user_data)
{
	gint          Num_cell = 0;
	gboolean      valid;
	GtkTreeIter   iter;
	GList        *List = NULL;
	gchar        *ptr_template = NULL;
	CD_AUDIO     *Audio = NULL;
	
	if (NULL == var_cd.Adr_entry_tag_titre_album) return;
	if (FALSE == Bool_Changed_Ok) return;
	ptr_template = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_album));

	valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
	while (valid) {
		List = g_list_nth (EnteteCD.GList_Audio_cd, Num_cell);
		if (NULL != (Audio = (CD_AUDIO *)List->data)) {
			g_free (Audio->tags->Album);
			Audio->tags->Album = NULL;
			Audio->tags->Album = g_strdup (ptr_template);
		}
		valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
		Num_cell ++;
	}

	cdaudio_set_titre_chanson ();
}
// 
// 
void on_entry_tag_nom_artiste_changed (GtkEditable *editable, gpointer user_data)
{
	gint          Num_cell = 0;
	gboolean      valid;
	GtkTreeIter   iter;
	GList        *List = NULL;
	gchar        *ptr_template = NULL;
	CD_AUDIO     *Audio = NULL;
	
	if (NULL == var_cd.Adr_entry_tag_nom_artiste) return;
	if (FALSE == Bool_Changed_Ok) return;
	ptr_template = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_tag_nom_artiste));
	
	if (TRUE == EnteteCD.BoolMultiArtiste) {
		if ((Audio = cdaudio_get_line_selected ())) {
			g_free (Audio->tags->Artist);
			Audio->tags->Artist = NULL;
			Audio->tags->Artist = g_strdup (ptr_template);
		}
	}
	else {
		valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
		while (valid) {
			List = g_list_nth (EnteteCD.GList_Audio_cd, Num_cell);
			if (NULL != (Audio = (CD_AUDIO *)List->data)) {
				g_free (Audio->tags->Artist);
				Audio->tags->Artist = NULL;
				Audio->tags->Artist = g_strdup (ptr_template);
			}
			valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
			Num_cell ++;
		}
	}
	cdaudio_set_titre_chanson ();
}
// 
// 
void on_button_copy_commentaire_clicked (GtkButton *button, gpointer user_data)
{
	gchar        *ptr_template = NULL;
	
	ptr_template = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_tag_commentaire));
	if (NULL != EnteteCD.StrMemoTagComment) {
		g_free (EnteteCD.StrMemoTagComment);
		EnteteCD.StrMemoTagComment = NULL;
	}
	EnteteCD.StrMemoTagComment = g_strdup (ptr_template);
	
	cdaudio_set_flag_buttons ();
}
// 
// 
void on_button_paste_comment_clicked (GtkButton *button, gpointer user_data)
{
	gint          Num_cell = 0;
	gboolean      valid;
	GtkTreeIter   iter;
	GList        *List = NULL;
	CD_AUDIO     *Audio = NULL;
	
	valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
	while (valid) {
		List = g_list_nth (EnteteCD.GList_Audio_cd, Num_cell);
		if (NULL != (Audio = (CD_AUDIO *)List->data)) {
			g_free (Audio->tags->Comment);
			Audio->tags->Comment = NULL;
			Audio->tags->Comment = g_strdup (EnteteCD.StrMemoTagComment);
		}
		valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
		Num_cell ++;
	}
	gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_commentaire), EnteteCD.StrMemoTagComment);
	cdaudio_set_titre_chanson ();
}
// 
// 
void on_entry_tag_commentaire_changed (GtkEditable *editable, gpointer user_data)
{
	gint          Num_cell = 0;
	gboolean      valid;
	GtkTreeIter   iter;
	GList        *List = NULL;
	gchar        *ptr_template = NULL;
	CD_AUDIO     *Audio = NULL;
	
	if (NULL == var_cd.Adr_entry_tag_commentaire) return;
	if (FALSE == Bool_Changed_Ok) return;
	ptr_template = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_tag_commentaire));
		
	if (TRUE == EnteteCD.BoolMultiArtiste) {
		if (NULL != (Audio = cdaudio_get_line_selected ())) {
			g_free (Audio->tags->Comment);
			Audio->tags->Comment = NULL;
			Audio->tags->Comment = g_strdup (ptr_template);
		}
	}
	else {
		valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
		while (valid) {
			List = g_list_nth (EnteteCD.GList_Audio_cd, Num_cell);
			if (NULL != (Audio = (CD_AUDIO *)List->data)) {
				g_free (Audio->tags->Comment);
				Audio->tags->Comment = NULL;
				Audio->tags->Comment = g_strdup (ptr_template);
			}
			valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
			Num_cell ++;
		}
	}
	cdaudio_set_titre_chanson ();
}
// 
// 
void on_spinbutton_tag_annee_value_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
	gint          Num_cell = 0;
	gboolean      valid;
	GtkTreeIter   iter;
	GList        *List = NULL;
	CD_AUDIO     *Audio = NULL;
	gint          Value;
	
	if (NULL == var_cd.Adr_spinbutton_tag_annee) return;
	Value = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(var_cd.Adr_spinbutton_tag_annee));
	
	if (TRUE == EnteteCD.BoolMultiArtiste) {
		if (NULL != (Audio = cdaudio_get_line_selected ())) {
			g_free (Audio->tags->Year);
			Audio->tags->Year = NULL;
			Audio->tags->Year = g_strdup_printf ("%d", Value);
			Audio->tags->IntYear = Value;
		}
	}
	else {
		valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
		while (valid) {
			List = g_list_nth (EnteteCD.GList_Audio_cd, Num_cell);
			if (NULL != (Audio = (CD_AUDIO *)List->data)) {
				g_free (Audio->tags->Year);
				Audio->tags->Year = NULL;
				Audio->tags->Year = g_strdup_printf ("%d", Value);
				Audio->tags->IntYear = Value;
			}
			valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
			Num_cell ++;
		}
	}
	cdaudio_set_titre_chanson ();
}
// 
// 
void on_spinbutton_tag_piste_value_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
	CD_AUDIO     *Audio = NULL;
	gint          Value;
	
	if (NULL == var_cd.Adr_spinbutton_tag_piste) return;
	Value = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(var_cd.Adr_spinbutton_tag_piste));
	
		if (NULL != (Audio = cdaudio_get_line_selected ())) {
			g_free (Audio->tags->Number);
			Audio->tags->Number = NULL;
			Audio->tags->Number = g_strdup_printf ("%d", Value);
			Audio->tags->IntNumber = Value;
		}
	cdaudio_set_titre_chanson ();
}
// 
// 
void on_entry_tag_titre_fichier_m3u_changed (GtkEditable *editable, gpointer user_data)
{
	if (FALSE == Bool_Changed_Ok) return;
	if (NULL != var_cd.Adr_entry_tag_titre_fichier) {
		g_free (Config.StringNameFile_m3u_xspf);
		Config.StringNameFile_m3u_xspf = NULL;
		Config.StringNameFile_m3u_xspf = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_fichier)));
		
		if (NULL == strstr (gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio)), "%f")) {

			gchar *Str = NULL;
		
			Str = g_strdup_printf ("%s %%f", gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio)));
			gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio), Str);
			g_free (Str);
			Str = NULL;
		}
	}
}
// 
// 
void on_combobox_tag_genre_cd_changed (GtkComboBox *combobox, gpointer user_data)
{
	gint          Num_cell = 0;
	gboolean      valid;
	GtkTreeIter   iter;
	GList        *List = NULL;
	gchar        *ptr_template = NULL;
	CD_AUDIO     *Audio = NULL;
	gint          IntGenre;
	
	if (NULL == var_cd.Adr_combobox_tag_genre_cd) return;
	
	IntGenre = gtk_combo_box_get_active (var_cd.Adr_combobox_tag_genre_cd);
	ptr_template = (gchar *)gtk_combo_box_get_active_text (var_cd.Adr_combobox_tag_genre_cd);

	if (TRUE == EnteteCD.BoolMultiArtiste) {
		if (NULL != (Audio = cdaudio_get_line_selected ())) {
			g_free (Audio->tags->Genre);
			Audio->tags->Genre = NULL;
			Audio->tags->Genre = g_strdup (ptr_template);
			Audio->tags->IntGenre = tags_get_num_combobox (IntGenre);
		}
	}
	else {
		valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
		while (valid) {
			List = g_list_nth (EnteteCD.GList_Audio_cd, Num_cell);
			if (NULL != (Audio = (CD_AUDIO *)List->data)) {
				g_free (Audio->tags->Genre);
				Audio->tags->Genre = NULL;
				Audio->tags->Genre = g_strdup (ptr_template);
				Audio->tags->IntGenre = tags_get_num_combobox (IntGenre);
			}
			valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
			Num_cell ++;
		}
	}
	cdaudio_set_titre_chanson ();
}
// 
// 
gboolean cdexpander_bool_entree_cd_verif_car = TRUE;
// 
// 
void on_entry_new_titre_cdaudio_changed (GtkEditable *editable, gpointer user_data)
{
	if (cdexpander_bool_entree_cd_verif_car == FALSE) return;
	
	if (NULL != var_cd.Adr_entry_new_titre_cdaudio) {
		gchar	*StrVerif = NULL;
		gchar	*ptr = NULL;
		
		// SUPPRESSION DE LA LIGNE SAISIE PAR L UTILISTATEUR
		if (NULL != Config.Templates_title_cdaudio) {
			g_free (Config.Templates_title_cdaudio);
			Config.Templates_title_cdaudio = NULL;
		}
		
		// LA CARACTERE / EST INTERDIT
		StrVerif = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio)));
		if (strchr (StrVerif, '/')) {
			cdexpander_bool_entree_cd_verif_car = FALSE;
			while ((ptr = strchr (StrVerif, '/'))) {
				strcpy (ptr, ptr+1);
			}
			gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio), StrVerif);
			cdexpander_bool_entree_cd_verif_car = TRUE;
		}
		// STOCKAGE DE LA LIGNE SAISIE PAR L UTILISTATEUR
		Config.Templates_title_cdaudio = g_strdup (StrVerif);
		
		g_free (StrVerif);
		StrVerif = NULL;
		
		Parse_entry (PARSE_TYPE_TITLE_CD);

		cdaudio_set_titre_chanson ();
	}
}
// 
// 
void on_expander_cd_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_Expander = widget;
	gtk_expander_set_expanded (GTK_EXPANDER (var_cd.Adr_Expander), Config.BoolEtatExpanderCd);
}
// 
// 
void on_notebook_expander_cd_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_notebook = widget;
}
// 
// 
void on_entry_tag_titre_chanson_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_entry_tag_titre_chanson = widget;
}
// 
// 
void on_entry_tag_titre_album_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_entry_tag_titre_album = widget;
}
// 
// 
void on_entry_tag_nom_artiste_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_entry_tag_nom_artiste = widget;
}
// 
// 
void on_entry_tag_commentaire_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_entry_tag_commentaire = widget;
}
// 
// 
void on_spinbutton_tag_annee_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_spinbutton_tag_annee = widget;
}
// 
// 
void on_spinbutton_tag_piste_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_spinbutton_tag_piste = widget;
}
// 
// 
void on_entry_tag_titre_fichier_m3u_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_entry_tag_titre_fichier = widget;
}
// 
// 
void on_combobox_tag_genre_cd_realize (GtkWidget *widget, gpointer user_data)
{
	libcombo_alloc (GTK_COMBO_BOX (widget));
	
	tags_set_elements_combobox (widget);
	// tags_set_elements_comboboxCD (widget);
	gtk_combo_box_set_wrap_width (GTK_COMBO_BOX (widget), 4);
	
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
	var_cd.Adr_combobox_tag_genre_cd = GTK_COMBO_BOX (widget);
}
// 
// 
void on_entry_new_titre_cdaudio_realize (GtkWidget *widget, gpointer user_data)
{
	var_cd.Adr_entry_new_titre_cdaudio = widget;
	if (NULL == Config.Templates_title_cdaudio) {
		Config.Templates_title_cdaudio = g_strdup ("%c %d");
	}
	gtk_entry_set_text (GTK_ENTRY (widget), Config.Templates_title_cdaudio);
	var_cd.Bool_create_file_m3u = FALSE;
	var_cd.Pathname_m3u = NULL;
}
// 
// 
void on_checkbutton_creation_fichier_unique_cue_clicked (GtkButton *button, gpointer user_data)
{
	if (FALSE == gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (button)))
		gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (GLADE_GET_OBJECT("checkbutton_creation_fichier_cue")), FALSE);
}
// 
// 
void on_combobox_choice_file_cue_realize (GtkWidget *widget, gpointer user_data)
{
	libcombo_alloc (GTK_COMBO_BOX (widget));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "WAV");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "FLAC");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "OGG");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "MPC");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
}


