 /*
 * file      : win_info.c
 * project   : BaseBuild
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2011 by Claude Bulin
 *
 * BaseBuild - Creation d'une base de programmation en langage C de type GNU avec les autotools
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif


#include <gtk/gtk.h>
#include <string.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "win_info.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/
/*

typedef struct {

	gchar    *title;
	GString  *text;
	
} WININFO;

WININFO wininfo;


// QUIT WITH delete_event
// 
gboolean wininfo_on_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	GtkWidget *AdrWin = GTK_WIDGET(user_data);
	
	gtk_widget_destroy (AdrWin);
	return FALSE;
}
// QUIT WITH destroy_event
// 
gboolean wininfo_on_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	GtkWidget *AdrWin = GTK_WIDGET(user_data);
	
	gtk_widget_destroy (AdrWin);
	return FALSE;
}
// QUIT WITH button
//
void wininfo_on_ok_button_clicked (GtkButton *button, gpointer user_data)
{
	GtkWidget *AdrWin = GTK_WIDGET(user_data);
	
	gtk_widget_destroy (AdrWin);
}
// CREATION DE LA FENETRE
// 
void wininfo_create_window (void)
{
	GtkWidget *dialog;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *label_text;
	GtkWidget *dialog_action_area1;
	GtkWidget *ok_button;

	// PRINT_FUNC_LF();

	dialog = gtk_dialog_new ();

	gtk_window_set_title (GTK_WINDOW (dialog), wininfo.title);
	gtk_window_set_transient_for (GTK_WINDOW(WindMain), GTK_WINDOW(dialog));
	gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
	gtk_window_set_resizable (GTK_WINDOW (dialog), FALSE);
	gtk_window_set_type_hint (GTK_WINDOW (dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

	dialog_vbox1 = GTK_DIALOG (dialog)->vbox;
	gtk_widget_show (dialog_vbox1);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

	label_text = gtk_label_new (NULL);
	gtk_label_set_use_markup (GTK_LABEL (label_text), TRUE);
	gtk_label_set_markup (GTK_LABEL (label_text), wininfo.text->str);
	gtk_widget_show (label_text);
	gtk_box_pack_start (GTK_BOX (vbox1), label_text, FALSE, FALSE, 0);

	dialog_action_area1 = GTK_DIALOG (dialog)->action_area;
	gtk_widget_show (dialog_action_area1);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_SPREAD);
	
	ok_button = gtk_button_new_from_stock ("gtk-ok");
	gtk_widget_show (ok_button);
	gtk_dialog_add_action_widget (GTK_DIALOG (dialog), ok_button, GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (ok_button);

	g_signal_connect ((gpointer) dialog, "delete_event",
			G_CALLBACK (wininfo_on_delete_event),
			(gpointer)dialog);
	g_signal_connect ((gpointer) dialog, "destroy_event",
			G_CALLBACK (wininfo_on_destroy_event),
			(gpointer)dialog);
	g_signal_connect ((gpointer) ok_button, "clicked",
			G_CALLBACK (wininfo_on_ok_button_clicked),
			(gpointer)dialog);

	// Store pointers to all widgets, for use by lookup_widget().

	GLADE_HOOKUP_OBJECT_NO_REF (dialog, dialog, "dialog");
	GLADE_HOOKUP_OBJECT_NO_REF (dialog, dialog_vbox1, "dialog_vbox1");
	GLADE_HOOKUP_OBJECT (dialog, vbox1, "vbox1");
	GLADE_HOOKUP_OBJECT (dialog, label_text, "label_text");
	GLADE_HOOKUP_OBJECT_NO_REF (dialog, dialog_action_area1, "dialog_action_area1");
	// GLADE_HOOKUP_OBJECT (dialog, ok_button, "ok_button");

	libutils_set_default_icone_to_win (dialog);
	
	gtk_widget_show (dialog);
}
// DEMANDE DE CREATION DE LA FENETRE
// 
void wininfo_create (gchar *title, ...)
{
	va_list    Arguments;
	gchar     *PtrArg = NULL;
	
	wininfo.title = g_strdup (title);				// Stokage du titre
	wininfo.text  = g_string_new (NULL);				//  Creation du GString
	
	g_string_sprintfa (wininfo.text, "\n<b>   %s</b>\n\n", title);	//  Titre -> en-tete en gras
	
	va_start (Arguments, title);					//  Debut des arguments
	while ( *(PtrArg = va_arg (Arguments, gchar *)) != '\0') {	//  TANSQUE message ALORS
		g_string_sprintfa (wininfo.text, "%s", &PtrArg[0]);	//  	message.stock
	}								//  FIN_TANSQUE
	va_end (Arguments);						//  Fin des arguments
	
	wininfo_create_window ();					//  Creation fenetre
	
	g_free (wininfo.title);						//  Suppression des informations
	wininfo.title = NULL;						//  de la structure
	g_string_free (wininfo.text, TRUE);
	wininfo.text = NULL;
}
*/


typedef struct {

	GtkWidget	*AdrWin;
	gboolean	IsShow;
	
} VAR_WININFO;

VAR_WININFO	VarWinInfo = { NULL, FALSE };

// QUITTER
// 
void on_button_quitter_wininfo_clicked (GtkButton *button, gpointer user_data)
{
	VarWinInfo.IsShow = FALSE;
	gtk_widget_hide (VarWinInfo.AdrWin);
}
// WIN-READER OPEN
// 
void wininfo_create (gchar *title, ...)
{
	gchar		*StrTitle = NULL;
	va_list		Arguments;
	gchar		*PtrArg = NULL;
	GString		*StrTxt = NULL;
	
	if (TRUE == VarWinInfo.IsShow) {
		gdk_window_raise (VarWinInfo.AdrWin->window);
	}
	else {		
		if (NULL == VarWinInfo.AdrWin) {
			VarWinInfo.AdrWin = GTK_WIDGET (GLADE_GET_OBJECT("wind_info"));
			gtk_builder_connect_signals (GtkXcfaProjet, NULL);
		}
		gtk_window_set_transient_for (GTK_WINDOW(VarWinInfo.AdrWin), GTK_WINDOW(WindMain));
		gtk_window_set_modal (GTK_WINDOW (VarWinInfo.AdrWin), TRUE);
		libutils_set_default_icone_to_win (VarWinInfo.AdrWin);
		
		StrTitle = g_strdup_printf ("\n          <span font_desc=\"Courier bold 14\"><b>%s</b></span>          \n", title);
		gtk_label_set_markup (GTK_LABEL (GLADE_GET_OBJECT("label_titre_wininfo")), StrTitle);
		g_free (StrTitle);	StrTitle = NULL;
	
		StrTxt = g_string_new (NULL);					//  Creation du GString
		va_start (Arguments, title);					//  Debut des arguments
		while ( *(PtrArg = va_arg (Arguments, gchar *)) != '\0') {	//  TANSQUE message ALORS
			g_string_sprintfa (StrTxt, "%s", &PtrArg[0]);		//  	message.stock
		}								//  FIN_TANSQUE
		va_end (Arguments);						//  Fin des arguments
		g_string_sprintfa (StrTxt, "\n\n");
		
		gtk_label_set_markup (GTK_LABEL (GLADE_GET_OBJECT("label_texte_wininfo")), StrTxt->str);
		g_string_free (StrTxt, TRUE);
		
		gtk_window_set_title (GTK_WINDOW(VarWinInfo.AdrWin), title);
		
		gtk_widget_show (VarWinInfo.AdrWin);
	}
	VarWinInfo.IsShow = TRUE;
}










