 /*
 * file      : poche.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2011 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */

/*
 *  poche.h             prototypes
 *  poche_code.c        code postscript
 *  poche_dir.c         chargement des images depuis un support magnetique
 *  poche_draw.c	dessin de la pochette
 *  poche_evnt.c        gestionnaire d'evenements
 *  poche_exec.c        execution de programmes tiers
 *  poche_gen.c         generation de code postscript
 *  poche_timer.c       gestion du reaffichage
 *  poche_web.c         cherche les images sur la toile
 */


#ifndef poche_h
#define poche_h 1

/*
*---------------------------------------------------------------------------
* GLOBALES
*---------------------------------------------------------------------------
*/

#define PTR0 poche.tab_recto [ 0 ]
#define PTR1 poche.tab_recto [ 1 ]
#define PTR2 poche.tab_recto [ 2 ]
#define PTR3 poche.tab_recto [ 3 ]

#define PTV0 poche.tab_verso [ 0 ]
#define PTV1 poche.tab_verso [ 1 ]
#define PTV2 poche.tab_verso [ 2 ]
#define PTV3 poche.tab_verso [ 3 ]

typedef enum {

	RECTO_GAUCHE  = 88,
	RECTO_BAS     = 442,
	RECTO_LARGEUR = 340,
	RECTO_HAUTEUR = 340,
	RECTO_MIN_LH  = 56,
	RECTO_MAX_HAUTEUR = RECTO_BAS + RECTO_HAUTEUR,
	RECTO_MAX_LARGEUR = RECTO_GAUCHE + RECTO_LARGEUR,

	VERSO_GAUCHE  = 71,
	VERSO_BAS     = 71,
	VERSO_LARGEUR = 452,
	VERSO_HAUTEUR = 331,
	VERSO_MIN_LH  = 56,
	VERSO_MAX_HAUTEUR = VERSO_BAS + VERSO_HAUTEUR,
	VERSO_MAX_LARGEUR = VERSO_GAUCHE + VERSO_LARGEUR

} VAL;

typedef enum {
	MOVE_NONE = 0,

	MOVE_RECTO,
	MOVE_RECTO_GAUCHE,
	MOVE_RECTO_DROIT,
	MOVE_RECTO_HAUT,
	MOVE_RECTO_BAS,
	MOVE_RECTO_COIN_HAUT_GAUCHE,
	MOVE_RECTO_COIN_HAUT_DROIT,
	MOVE_RECTO_COIN_BAS_GAUCHE,
	MOVE_RECTO_COIN_BAS_DROIT,

	MOVE_VERSO,
	MOVE_VERSO_GAUCHE,
	MOVE_VERSO_DROIT,
	MOVE_VERSO_HAUT,
	MOVE_VERSO_BAS,
	MOVE_VERSO_COIN_HAUT_GAUCHE,
	MOVE_VERSO_COIN_HAUT_DROIT,
	MOVE_VERSO_COIN_BAS_GAUCHE,
	MOVE_VERSO_COIN_BAS_DROIT

} MOVE;

typedef struct {
	gint x1;
	gint y1;
	gint x2;
	gint y2;
} TAB;

typedef struct {						//  UNE STRUCTURE PAR FICHIER IMAGE
	gchar     *name_img;					//  Nom du fichier image original
	gchar     *name_png;					//  Nom du fichier PNG
	GtkWidget *togglebutton;				//  Adresse du bouton
	GtkWidget *image;					//  Adresse de l'image
	GtkWidget *label;					//  Adresse du label
} GLIST_POCHETTE;

typedef struct {						//  VARIABLES DE LA STRUCTURE POCHETTE
	GtkWidget      *Adr_image_preview;			//  Adresse de l'image-preview
	GtkWidget      *Adr_viewport_image_preview;		//  Adresse du viewport image-preview
	GtkWidget      *Adr_table;				//  Adresse de la table
	GtkWidget      *Adr_button_path_images;			//  Adresse bouton destination des images
	GtkWidget      *Adr_togglebutton_recto;			//  Adresse bouton recto
	GtkWidget      *Adr_togglebutton_verso;			//  Adresse bouton verso
	GtkWidget      *Adr_togglebutton_remove;		//  Adresse bouton remove image
	GtkComboBox    *Adr_combo_zoom;				//  Adresse combo zoom preview

	GList          *glist;					//  Contient les structures GLIST_POCHETTE
	gboolean        bool_radio_recto_actif; 		//  TRUE = recto else FALSE = verso
	GLIST_POCHETTE *ptr_recto;				//  Pointe sur le recto dans le GList
	GLIST_POCHETTE *ptr_verso;				//  Pointe sur le verso dans le GList

	GtkWidget      *Adr_entry_title;			//  Adresse titre pochette
	GtkComboBox    *Adr_combobox_entry_title;		//  Adresse combo titre pochette
	GtkWidget      *Adr_entry_foottext;			//  Adresse pied de page pochette
	GtkComboBox    *Adr_combobox_entry_foottext;		//  Adresse combo pied de page pochette

	GtkComboBox    *Adr_combobox_text_recto;		//  Adresse combo texte recto
	GtkComboBox    *Adr_combobox_text_verso;		//  Adresse combo texte verso
	GtkComboBox    *Adr_combobox_link_fields;		//  Adresse combo liens champs
	GtkWidget      *Adr_button_liste_numerate;		//  Adresse button numeration
	GtkWidget      *Adr_textview;				//  Adresse textview

	GtkWidget      *Adr_entry_web_search;			//  Adresse recherche sur le web

	GtkComboBox    *Adr_combobox_generate_ps_pdf;		//  Adresse combobox generate ps pdf
	GtkWidget	*Adr_entry_postscript;
	gboolean	BoolPostscriptOk;
	
	gint            tab_recto [ 4 ];			//  Coordonnees image recto
	gint            tab_verso [ 4 ];			//  Coordonnees image verso
	gchar           coord_recto [ 40 ];			//  Coordonnees recto image pochette
	gchar           coord_verso [ 40 ];			//  Coordonnees verso image pochette

	gchar          *Path_pochette_base;			//  PATH_SAVE_POCHETTE_IMG
	gchar          *Path_pochette;				//  PATH_SAVE_POCHETTE_IMG
	gchar          *Path_pochette_ps;			//  PATH_SAVE_POCHETTE_PS
	gchar          *Path_pochette_png;			//  PATH_SAVE_POCHETTE_PNG
	gchar          *file_preview_ps;			//  /PATH_SAVE_POCHETTE_PS/preview.ps
	gchar          *file_preview_pdf;			//  /PATH_SAVE_POCHETTE_PS/preview.pdf
	gchar          *file_preview_png;			//  /PATH_SAVE_POCHETTE_PS/preview.png
	gchar          *file_recto_ps;				//  /PATH_SAVE_POCHETTE_PS/recto.ps
	gchar          *file_verso_ps;				//  /PATH_SAVE_POCHETTE_PS/verso.ps
	gboolean        bool_file_recto_ps;			//  TRUE if exist else FALSE
	gboolean        bool_file_verso_ps;			//  TRUE if exist else FALSE

	gboolean        bool_destroy_image;			//  TRUE if remove image else FALSE

	TAB             grille [ 12 ];				//  Grille principale de l'image
	TAB             tab [ 8 ];				//  Grilles retcto/verso des images
	gint            largeur_mini;				//  Largeur minimum en point
	MOVE            move;					//  Etat du curseur dans la zone de dessin
	gboolean        bool_move;				//  TRUE si le dessin a bouge
	gboolean        bool_with_get_grille_img;		// 
	gboolean        bool_redraw;				//  TRUE si reaffichage

} VAR_POCHETTE;


/*
*---------------------------------------------------------------------------
* POCHE_EVNT
*---------------------------------------------------------------------------
*/
extern VAR_POCHETTE poche;

/* Evenements popup sur image */
void pocheevnt_action_popup (gboolean is_recto, gint val_action);
/* Evenements dessin pochette */
gboolean  pocheevnt_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
/* pochette */
void      pocheevnt_init (void);
gboolean  pocheevnt_init_images_xcfa (void);
void      pocheevnt_set_flag (gboolean Enable);
void      pocheevnt_remove (void);
void      pocheevnt_table_add_images (void);
void      pocheevnt_add_elements_combobox_preview (void);
gdouble   pocheevnt_get_percent_zoom (void);
void      pocheevnt_set_flag_buttons_recto (void);
void      pocheevnt_set_flag_buttons_verso (void);
/* name-volume & get-web */
gchar    *pocheevnt_get_comboboxentry_cdaudio (void);
void      pocheevnt_set_flag_buttons_preview (void);
/* Titre */
gchar    *pocheevnt_get_entry_titre_ps (void);
/* Pied de page */
gchar    *pocheevnt_get_entry_foottext_ps (void);
/* Options */
gboolean  pocheevnt_get_load_images_init_xcfa (void);

/*
*---------------------------------------------------------------------------
* POCHE_WEB
*---------------------------------------------------------------------------
*/
void     pocheweb_get (void);

/*
*---------------------------------------------------------------------------
* POCHE_CODE
*---------------------------------------------------------------------------
*/
extern gchar *code_entete_ps [];	//  Production de l'entete
extern gchar *code_xcfa_ps [];		//  Production de code 'xcfa'
extern gchar *code_convert_ps [];	//  Production de code 'convert'

/*
*---------------------------------------------------------------------------
* POCHE_GEN
*---------------------------------------------------------------------------
*/
void pochegen_affiche_image (void);
void pochegen_gen_code_postscript (void);
void pochegen_file_postscript (void);
void pochegen_file_pdf (void);
void pochegen_file_postscript_pdf (void);

/*
*---------------------------------------------------------------------------
* POCHE_DIR
*---------------------------------------------------------------------------
*/
void	 pochedir_make_glist (gchar *filename);
void	 pochedir_add_img_file (GSList *p_list);

/*
*---------------------------------------------------------------------------
* POCHE_TIMER
*---------------------------------------------------------------------------
*/
typedef enum {
	PTIMER_ENABLE = 0,	// 
	PTIMER_DISABLE,		// 
	GENPOSTSCRIPT,		// 
	PRINTIMAGE,		// 
	FLAGSRECTO,		// 
	FLAGSVERSO		// 
} PTIMER_ACTION;

void     pochetimer_enable (void);
void     pochetimer_action (PTIMER_ACTION TimerEnable, PTIMER_ACTION GenPostScript, PTIMER_ACTION PrintImage, PTIMER_ACTION FlagsRecto, PTIMER_ACTION FlagsVerso);

/*
*---------------------------------------------------------------------------
* POCHE_EXEC
*---------------------------------------------------------------------------
*/
void     pocheexec_viewer_postscript (gchar *ProgName, gchar *PtrDest);
void     pocheexec_convert_to_png (gchar *Source, gchar *Destination, gchar *dimension);
void     pocheexec_convert_to_postscript (gchar *Source, gchar *Destination);
void     pocheexec_make_pdf_file (gchar *source, gchar *destination);

/*
*---------------------------------------------------------------------------
* POCHE_DRAW
*---------------------------------------------------------------------------
*/
void     pochedraw_redraw_image (void);
void     pochedraw_draw_grille_base (void);
gboolean pochedraw_get_grille_img (void);
void     pochedraw_draw_grille_img (void);

#endif
