 /*
 * file      : web.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */

 
 
#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <pthread.h>
#include <stdlib.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "win_info.h"
#include "extra.h"
#include "cdtoc.h"
#include "configuser.h"
#include "web.h"



typedef struct {
	gchar *Navigateur;
	gchar *NameNavi;
	gchar *TemporaryRep;
} VAR_WEB ;

VAR_WEB VarWeb = { NULL, NULL, NULL };




// 
// 
void web_remove (void)
{
	if (VarWeb.Navigateur != NULL) {
		g_free (VarWeb.Navigateur);
		VarWeb.Navigateur = NULL;
	}
	
	if (VarWeb.NameNavi != NULL) {
		g_free (VarWeb.NameNavi);
		VarWeb.NameNavi = NULL;
	}
}
// Appelle un navigateur pour aller sur le site d'XCFA et cela en thread
// 
void web_call_navigator (void)
{
	pid_t  pid;

	pid = fork ();
	if (pid == 0) {
		/*
		kfmclient newTab http://www.xcfa.tuxfamily.org &
		*/
		if (strcmp (VarWeb.Navigateur, "konqueror") == 0) {
			execlp ("kfmclient",
				"kfmclient",
				"newTab",
				VarWeb.NameNavi,
				NULL);
		}
		if (strcmp (VarWeb.Navigateur, "opera") == 0) {
			execlp (VarWeb.Navigateur,
				VarWeb.Navigateur,
				VarWeb.NameNavi,
				NULL);
		}
		else {
			/*
			-new-window URL
				Open URL in a new window in an already running Firefox  process.
				-new-tab URL Open URL in a new tab in an already running Firefox process.
			EXEMPLE:
				firefox -new-window -new-tab http:/www.google.fr
			*/
			// g_print("%s -new-window -new-tab %s\n", VarWeb.Navigateur,VarWeb.NameNavi);
			execlp (VarWeb.Navigateur,
				VarWeb.Navigateur,
				"-new-window",
				"-new-tab",
				VarWeb.NameNavi,
				NULL);
		}
		_exit (0);
	}
}
// 
// 
static void web_thread (void *arg)
{
	web_call_navigator ();
	pthread_exit(0);
}
// Fonction commune d'appel a un navigateur pour aller sur le site d'XCFA
// 
void web_goto_url (gchar *str_web)
{
	pthread_t   nmr_tid;
 	
	// PRINT_FUNC_LF();
	
	if (FALSE == extra_get_navigateur_is_ok ()) {
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_PRGEXTERNES);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_app_externes")), NOTEBOOK_OPTIONS_EXTRA);
		
		wininfo_create (
			_("PAS de navigateur present"),
			_("L'acces au web est impossible car aucun navigateur"),
			  "\n",
			_("n'est present dans votre configuration."),
			  "\n\n",
			_("Veuillez installez un navigateur."),
			  "");
		return;
	}

	if (cddb_test_access_web () == FALSE) {
		
		wininfo_create (
			_("La liaison internet est absente"),
			_("Vous devez ouvrir l'acces internet"),
			  "");
		return;
	}
	
	web_remove ();
	VarWeb.Navigateur = g_strdup (extra_get_name_navigateur ());
	VarWeb.NameNavi   = g_strdup (str_web);
	
	pthread_create (&nmr_tid, NULL ,(void *)web_thread, (void *)NULL);
}
// 
// 
void web_make_file (gchar *StrMakeManFile)
{
	pid_t	pid;
	gint	Dummy = 0;
	
	// PRINT_FUNC_LF();
	
	pid = fork ();
	if (pid == 0) {
		Dummy = system (StrMakeManFile);
		_exit (0);
	}
}
// 
// 
void web_goto_manpage (gchar *NameManPage)
{
	pthread_t	 nmr_tid;
	gchar		*LineCommand = NULL;
 	
	// PRINT_FUNC_LF();

	if (FALSE == extra_get_navigateur_is_ok ()) {
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_PRGEXTERNES);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_app_externes")), NOTEBOOK_OPTIONS_EXTRA);
		
		wininfo_create (
			_("PAS de navigateur present"),
			  "\n",
			_("   L'acces au web est impossible car aucun navigateur"),
			  "        \n",
			_("   n'est present dans votre configuration."),
			  "\n\n",
			_("   Veuillez installez un navigateur."),
			  "\n",
			  "");
		return;
	}

	if (libutils_find_file (NameManPage) == FALSE) {
		g_print("The application is missing, you must install [ %s ]\n", NameManPage);
		return;
	}
	
	if (libutils_find_file ("txt2html") == FALSE) {
		// g_print("The application is missing, you must install [ txt2html ]\n");
		wininfo_create (
			_("txt2html absent"),
			  "\n",
			_("   txt2html est absent de votre configuration."),
			  "\n\n",
			_("   Veuillez l'installer."),
			  "\n",
			  "");
		return;
	}
	
	// INIT DOSSIER TEMPORAIRE
	if (NULL == VarWeb.TemporaryRep)  {
		VarWeb.TemporaryRep  = libutils_create_temporary_rep (Config.PathnameTMP, PATH_MANPAGE);
	}
	
	// INIT var
	web_remove ();
	VarWeb.Navigateur = g_strdup (extra_get_name_navigateur ());
	VarWeb.NameNavi   = g_strdup_printf ("%s/%s.html", VarWeb.TemporaryRep, NameManPage);
	
	// IF VarWeb.NameNavi NOT EXIST
	if (FALSE == libutils_test_file_exist (VarWeb.NameNavi)) {	
		LineCommand = g_strdup_printf ("man %s | txt2html > %s/%s.html", NameManPage, VarWeb.TemporaryRep, NameManPage);
		web_make_file (LineCommand);
		g_free (LineCommand);
		LineCommand = NULL;
		sleep(20);
	}
		
	pthread_create (&nmr_tid, NULL ,(void *)web_thread, (void *)NULL);
}
// 
// 
void web_remove_temporary_rep (void)
{
	web_remove ();
	// DELETTE TEMPORAY REP
	if (NULL != VarWeb.TemporaryRep)  {
		VarWeb.TemporaryRep  = libutils_remove_temporary_rep (VarWeb.TemporaryRep);
	}
}
// 
// 
void on_button_WebInformations_clicked (GtkButton *button, gpointer user_data)
{
	if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_WebCdparanoia_homepage")))) {
		web_goto_url ("http://www.xiph.org/paranoia/");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_WebCdparanoia_manpage")))) {
		web_goto_manpage ("cdparanoia");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_WebLame_homepage")))) {
		web_goto_url ("http://lame.sourceforge.net/index.php");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_WebLame_wikimp3")))) {
		web_goto_url ("http://fr.wikipedia.org/wiki/Mp3");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_WebLame_wikilame")))) {
		web_goto_url ("http://fr.wikipedia.org/wiki/LAME");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_WebLame_manpage")))) {
		web_goto_manpage ("lame");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_WebOggenc_wiki")))) {
		web_goto_url ("http://fr.wikipedia.org/wiki/Ogg_Vorbis");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_WebOggenc_manpage")))) {
		web_goto_manpage ("oggenc");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_WebFlac_homepage")))) {
		web_goto_url ("http://flac.sourceforge.net/");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_WebFlac_framasoft")))) {
		web_goto_url ("http://www.framasoft.net/article1510.html");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_WebFlac_manpage")))) {
		web_goto_manpage ("flac");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_WebMac_wiki")))) {
		web_goto_url ("http://en.wikipedia.org/wiki/Monkey's_audio");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_WavPack_wiki")))) {
		web_goto_url ("http://fr.wikipedia.org/wiki/WavPack");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_WavPack_manpage")))) {
		web_goto_manpage ("wavpack");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_WebMusepack_homepage")))) {
		web_goto_url ("http://www.musepack.net/");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_WebMusepack_framasoft")))) {
		web_goto_url ("http://www.framasoft.net/article2094.html");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_faac_homepage")))) {
		web_goto_url ("http://www.audiocoding.com/faac.html");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_faac_web_info")))) {
		web_goto_url ("http://freshmeat.net/projects/faac/");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_aacplusenc_homepage")))) {
		web_goto_url ("http://teknoraver.net/software/mp4tools/");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_faac_manpage")))) {
		web_goto_manpage ("faac");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_aacplusenc_web_info")))) {
		web_goto_url ("http://en.wikipedia.org/wiki/Aacplus");
	} else if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (GLADE_GET_OBJECT("button_aacplusenc_manpage")))) {
		web_goto_manpage ("aacplusenc");
	}
}
// 
// 
void on_linkbutton_xcfa_install_all_clicked (GtkLinkButton *link_button, gpointer user_data)
{
	g_print("%s\n", gtk_link_button_get_uri (link_button));
	web_goto_url ((gchar *)gtk_link_button_get_uri (link_button));
}

