 /*
 * file      : split_selector.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <stdio.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "alsa_play.h"
#include "split.h"


/* TODO : INSERER DANS LES STRUCTURE LE POINT 
*/

extern VAR_SPLIT VarSplit;




void DEBUG_PRINT_SplitSelector (void)
{
	gint	IndiceSrc;
	
	g_print ("\n");
	for (IndiceSrc = 0; IndiceSrc < MAX_SELECTEURS_SPLIT; IndiceSrc ++) {
		if (-1 != VarSplit.Selecteur [ IndiceSrc ] . Nmr) {
			g_print ("[ %2d ]  Begin = %6d   End = %6d\t",
					IndiceSrc,
					(gint)VarSplit.Selecteur [ IndiceSrc ] . Begin,
					(gint)VarSplit.Selecteur [ IndiceSrc ] . End
					);
			g_print ("PercentBegin = %2.6f   PercentEnd = %2.6f\n",
					VarSplit.Selecteur [ IndiceSrc ] . PercentBegin,
					VarSplit.Selecteur [ IndiceSrc ] . PercentEnd
					);
		}
	}
}
// 
// 
void SplitSelector_init (void)
{
	gint	Cpt;
	
	// PRINT_FUNC_LF();
	
	VarSplit.BoolPlay = FALSE;
	VarSplit.SelecteurActif = 0;
	VarSplit.NbrSelecteurs = 0;
	VarSplit.PercentActivePlay = 0.0;
	VarSplit.BoolBlankWithCue = FALSE;
	for (Cpt = 0; Cpt < MAX_SELECTEURS_SPLIT; Cpt ++) {
		VarSplit.Selecteur [ Cpt ] . Nmr = -1;
		VarSplit.Selecteur [ Cpt ] . Begin = -1;
		VarSplit.Selecteur [ Cpt ] . End = -1;
		VarSplit.Selecteur [ Cpt ] . PercentBegin =
		VarSplit.Selecteur [ Cpt ] . PercentEnd = 0.0;
	}
}
// 
// button_actualise_split
/*
void on_button_actualise_split_clicked (GtkButton *button, gpointer user_data)
{
	gint IndicePoints;
	
	PRINT_FUNC_LF();
	
	// INIT STRUCTURES: Selecteur
	SplitSelector_init ();
	
	SplitSpectre_search_blank_pass (VarSplit.nTotalChunckSize / 2352);
	
	for (IndicePoints = 0; IndicePoints < MAX_SELECTEURS_SPLIT; IndicePoints ++) {
		if (-1 != VarSplit.Selecteur [ IndicePoints ] . Nmr) {
			VarSplit.NbrSelecteurs ++;
		}
	}
	
	SplitSelector_get_pos ();
	
	split_set_flag_buttons ();
	split_set_time ();
	gtk_widget_queue_draw (VarSplit.AdrWidgetSpectre);
}
*/
// SELECTEUR: IL N EN RESTERA QU UN  ;-)
// 
void on_button_del_cut_split_clicked (GtkButton *button, gpointer user_data)
{
	if (VarSplit.NbrSelecteurs > 1) {
		
		PRINT_FUNC_LF();
		
		DEBUG_PRINT_SplitSelector ();
		
		// INIT STRUCTURES: Selecteur ET Points50DB
		SplitSelector_init ();
		VarSplit.SelecteurActif = 0;
		VarSplit.NbrSelecteurs = 1;
		VarSplit.Selecteur [ 0 ] . Nmr = 0;
		VarSplit.Selecteur [ 0 ] . Begin = 0;
		VarSplit.Selecteur [ 0 ] . End = VarSplit.SpectreW;
		VarSplit.Selecteur [ 0 ] . PercentBegin =
		VarSplit.Selecteur [ 0 ] . PercentEnd = 0.0;
		VarSplit.Selecteur [ 0 ] . PercentBegin = ((gdouble)VarSplit.Selecteur [ 0 ] . Begin / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
		VarSplit.Selecteur [ 0 ] . PercentEnd   = ((gdouble)VarSplit.Selecteur [ 0 ] . End / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
		
		gtk_widget_queue_draw (VarSplit.AdrWidgetSpectre);
		
		DEBUG_PRINT_SplitSelector ();
		split_set_flag_buttons ();
	}
}
// DESTRUCTION DU SELCTEUR ACTIF
// 
void SplitSelector_cut (void)
{
#define	        MESS_ERR_CUT "<span color=\"red\">Suppression pendant la lecture impossible</span>"
	if (0 == VarSplit.NbrSelecteurs) {
		PRINT("\tAUCUN SELECTEUR  !!!");
	}
	else if (VarSplit.NbrSelecteurs == 1) {
		PRINT("\tLE SELECTEUR RESTANT EST OBLIGATOIRE : Il n'en restera qu'un  ;-)");
	}
	else if (VarSplit.NbrSelecteurs > 1) {
		
		if (TRUE == AlsaPlay_is_play ()) {
			main_puts_statusbar_global (_(MESS_ERR_CUT));
		}
		else {
			gint	Zone = 0;
		
			// PRINT_FUNC_LF();
			// g_print("\tSUPPRESSION DU SELECTEUR ACTIF: %d\n", VarSplit.SelecteurActif);
			// 
			// g_memmove (dest, src, len)
			// 
			// DEPLACER LES BUFFERS VERS L AVANT EN COMMENCANT PAR LA FIN
			for (Zone = VarSplit.SelecteurActif +1; Zone < VarSplit.NbrSelecteurs; Zone ++) {
				g_memmove(&VarSplit.Selecteur [ Zone -1 ], &VarSplit.Selecteur [ Zone ], sizeof(SELECTEUR));
			}

			VarSplit.NbrSelecteurs --;
			if (VarSplit.SelecteurActif >= VarSplit.NbrSelecteurs -1 && VarSplit.SelecteurActif > 0) VarSplit.SelecteurActif --;
			
			VarSplit.Selecteur [ VarSplit.NbrSelecteurs ] . Nmr = -1;
			VarSplit.Selecteur [ VarSplit.NbrSelecteurs ] . Begin = -1;
			VarSplit.Selecteur [ VarSplit.NbrSelecteurs ] . End = -1;
			VarSplit.Selecteur [ VarSplit.NbrSelecteurs ] . PercentBegin =
			VarSplit.Selecteur [ VarSplit.NbrSelecteurs ] . PercentEnd = 0.0;
			
			gtk_widget_queue_draw (VarSplit.AdrWidgetSpectre);
			split_set_flag_buttons ();
		}
	}
}
// 
// 
gint SplitSelector_get_diff_sec (gdouble p_PercentBegin, gdouble p_PercentEnd)
{
	gint		Len = -1;
	gdouble		TimeSongSec;
	gint		sec_begin;
	gint		sec_end;
	
	// ACQUISITION DUREE TOTALE DU FICHIER EN SECONDES
	TimeSongSec = VarSplit.Tags->SecTime;
	
	sec_begin = (gint) (((gdouble)TimeSongSec * (gdouble)p_PercentBegin) / 100.0);
	sec_end   = (gint) (((gdouble)TimeSongSec * (gdouble)p_PercentEnd) / 100.0);
	
	// Len = (sec_end % 60) - (sec_begin % 60);
	Len = (sec_end ) - (sec_begin );
	return (Len);
}
// 
// 
gint SplitSelector_get_PosSelecteurActif (gint p_CursorX)
{
	gint	PosSelecteurActif = -1;
	
	for (PosSelecteurActif = 0; PosSelecteurActif < VarSplit.NbrSelecteurs ; PosSelecteurActif ++) {
		if (p_CursorX > SplitSelector_get_pos_begin (PosSelecteurActif) && p_CursorX < SplitSelector_get_pos_end (PosSelecteurActif)) {
			return (PosSelecteurActif);
		}
	}
	return (-1);
}
// DOUBLE CLICK : GENERATION D UN NOUVEL INDEX
// 
// @Dzef: TODO
//	- Pour ajouter manuellement un marqueur de début, j'ajoute, par défaut, au même endroit celui de sortie de la plage précédente.
//	- En mode lecture un double clic sur le bandeau des index place un sélecteur à la position de la tête de lecture ?
//	- En mode pause un double clic sur le bandeau des index place un sélecteur à l'endroit où on a cliqué ?
// 	- La règle  étant que 2 plages ne doivent pas pouvoir se chevaucher.
// 
void SplitSelector_add (gint p_CursorX)
{
	gint			IndiceDest = 0;
	gint			IndiceSrc = 0;
	gint			CursorX = p_CursorX;
	gint			Cpt; 	
	gdouble			PercentCursorX;
	gint			Len;

	// PRINT_FUNC_LF();
		
	DEBUG_PRINT_SplitSelector ();
	// 
	// CAS 1 : CursorX < BEGIN_MIN
	// 
	if (CursorX < SplitSelector_get_pos_begin (0)) {
		
		PRINT("CAS 1 : CursorX < BEGIN_MIN");
		// 
		// --
		// 
		PercentCursorX = ((gdouble)CursorX / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
		Len = SplitSelector_get_diff_sec (0.0, PercentCursorX);
		if (Len < 5) {
			main_puts_statusbar_global (_("<span color=\"red\">Temps inferieur a 5 secondes entre marqueur et curseur !</span>"));
			return;
		}
		
		Len = SplitSelector_get_diff_sec (PercentCursorX, VarSplit.Selecteur [ 0 ] . PercentBegin);
		if (Len < 5) {
			main_puts_statusbar_global (_("<span color=\"red\">Temps inferieur a 5 secondes entre marqueur et curseur !</span>"));
			return;
		}
		
		// 
		// g_memmove (dest, src, len)
		// 
		// DEPLACER LES BUFFERS VERS L AVANT EN COMMENCANT PAR LA FIN
		if (VarSplit.NbrSelecteurs < MAX_SELECTEURS_SPLIT) {
			for (IndiceDest = VarSplit.NbrSelecteurs; IndiceDest > 0; IndiceDest --) {
				IndiceSrc = IndiceDest -1;
				g_print ("\tg_memmove(%d, %d, %lu);\n", IndiceDest, IndiceSrc, sizeof(SELECTEUR));
				g_memmove(&VarSplit.Selecteur [ IndiceDest ], &VarSplit.Selecteur [ IndiceSrc ], sizeof(SELECTEUR));
			}
		}
		
		// VALIDER LA NOUVELLE SELECTION ACTIVE
		VarSplit.SelecteurActif = 0;
		g_print ("VarSplit.SelecteurActif = %d\n",VarSplit.SelecteurActif);
		
		// AJOUTER UN SELECTEUR
		VarSplit.NbrSelecteurs ++;
		g_print ("VarSplit.NbrSelecteurs = %d\n",VarSplit.NbrSelecteurs);
		
		// REINDEXER LA NUMEROTATION
		for (IndiceSrc = 0; IndiceSrc < VarSplit.NbrSelecteurs; IndiceSrc ++) {
			VarSplit.Selecteur [ IndiceSrc ] . Nmr = IndiceSrc;
			g_print ("VarSplit.Selecteur [ %d ] . Nmr = %d\n",IndiceSrc, VarSplit.Selecteur [ IndiceSrc ] . Nmr);
		}
		g_print ("VarSplit.Selecteur [ %d ] . Nmr = %d\n",IndiceSrc, VarSplit.Selecteur [ IndiceSrc ] . Nmr);
		
		VarSplit.Selecteur [ VarSplit.SelecteurActif ] . Begin        = CursorX;
		VarSplit.Selecteur [ VarSplit.SelecteurActif ] . PercentBegin = ((gdouble)CursorX / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
		
		VarSplit.Selecteur [ VarSplit.SelecteurActif ] . End        = VarSplit.Selecteur [ VarSplit.SelecteurActif +1 ] . Begin;
		VarSplit.Selecteur [ VarSplit.SelecteurActif ] . PercentEnd = VarSplit.Selecteur [ VarSplit.SelecteurActif +1 ] . PercentBegin;
	}
	// 
	// CAS 2 : CursorX > END_MAX
	// 
	else if (CursorX > SplitSelector_get_pos_end (VarSplit.NbrSelecteurs -1)) {
		
		PRINT("CAS 2 : CursorX > END_MAX");
		// 
		// --
		// 
		PercentCursorX = ((gdouble)CursorX / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
		Len = SplitSelector_get_diff_sec (VarSplit.Selecteur [ 0 ] . PercentEnd, PercentCursorX);
		if (Len < 5) {
			main_puts_statusbar_global (_("<span color=\"red\">Temps inferieur a 5 secondes entre marqueur et curseur !</span>"));
			return;
		}
		
		Len = SplitSelector_get_diff_sec (PercentCursorX, 100.0);
		if (Len < 5) {
			main_puts_statusbar_global (_("<span color=\"red\">Temps inferieur a 5 secondes entre marqueur et curseur !</span>"));
			return;
		}
		
		// 
		// g_memmove (dest, src, len)
		// 
		// DEPLACER LES BUFFERS VERS L AVANT EN COMMENCANT PAR LA FIN
		if (VarSplit.NbrSelecteurs < MAX_SELECTEURS_SPLIT) {
			for (IndiceDest = VarSplit.NbrSelecteurs; IndiceDest > VarSplit.NbrSelecteurs -1; IndiceDest --) {
				IndiceSrc = IndiceDest -1;
				g_print ("\tg_memmove(%d, %d, %lu);\n", IndiceDest, IndiceSrc, sizeof(SELECTEUR));
				g_memmove(&VarSplit.Selecteur [ IndiceDest ], &VarSplit.Selecteur [ IndiceSrc ], sizeof(SELECTEUR));
			}
		}
		
		// VALIDER LA NOUVELLE SELECTION ACTIVE
		VarSplit.SelecteurActif = VarSplit.NbrSelecteurs;
		g_print ("VarSplit.SelecteurActif = %d\n",VarSplit.SelecteurActif);
		
		// AJOUTER UN SELECTEUR
		VarSplit.NbrSelecteurs ++;
		g_print ("VarSplit.NbrSelecteurs = %d\n",VarSplit.NbrSelecteurs);
		
		// REINDEXER LA NUMEROTATION
		for (IndiceSrc = 0; IndiceSrc < VarSplit.NbrSelecteurs; IndiceSrc ++) {
			VarSplit.Selecteur [ IndiceSrc ] . Nmr = IndiceSrc;
			g_print ("VarSplit.Selecteur [ %d ] . Nmr = %d\n",IndiceSrc, VarSplit.Selecteur [ IndiceSrc ] . Nmr);
		}
		g_print ("VarSplit.Selecteur [ %d ] . Nmr = %d\n",IndiceSrc, VarSplit.Selecteur [ IndiceSrc ] . Nmr);
		
		VarSplit.Selecteur [ VarSplit.SelecteurActif ] . Begin        = CursorX;
		VarSplit.Selecteur [ VarSplit.SelecteurActif ] . PercentBegin = ((gdouble)CursorX / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;

		VarSplit.Selecteur [ VarSplit.SelecteurActif ] . End        = VarSplit.SpectreW ;
		VarSplit.Selecteur [ VarSplit.SelecteurActif ] . PercentEnd = ((gdouble)VarSplit.SpectreW  / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
	}
	else {
		for (Cpt = 0; Cpt <= VarSplit.NbrSelecteurs; Cpt ++) {
			// 
			// CAS 3 : CursorX IN BEGIN .. END
			// 
			if (CursorX > SplitSelector_get_pos_begin (Cpt) && CursorX < SplitSelector_get_pos_end (Cpt)) {
				PRINT("CAS 3 : CursorX IN BEGIN .. END");
				// 
				// --
				// 
				PercentCursorX = ((gdouble)CursorX / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
				Len = SplitSelector_get_diff_sec (VarSplit.Selecteur [ Cpt ] . PercentBegin, PercentCursorX);
				if (Len < 5) {
					main_puts_statusbar_global (_("<span color=\"red\">Temps inferieur a 5 secondes entre marqueur et curseur !</span>"));
					return;
				}
				
				Len = SplitSelector_get_diff_sec (PercentCursorX, VarSplit.Selecteur [ Cpt ] . PercentEnd);
				if (Len < 5) {
					main_puts_statusbar_global (_("<span color=\"red\">Temps inferieur a 5 secondes entre marqueur et curseur !</span>"));
					return;
				}
		
				// 
				// g_memmove (dest, src, len)
				// 
				// DEPLACER LES BUFFERS VERS L AVANT
				if (VarSplit.NbrSelecteurs < MAX_SELECTEURS_SPLIT) {
					for (IndiceDest = VarSplit.NbrSelecteurs; IndiceDest > Cpt; IndiceDest --) {
						IndiceSrc = IndiceDest -1;
						g_print ("\tg_memmove(%d, %d, %lu);\n", IndiceDest, IndiceSrc, sizeof(SELECTEUR));
						g_memmove(&VarSplit.Selecteur [ IndiceDest ], &VarSplit.Selecteur [ IndiceSrc ], sizeof(SELECTEUR));
					}
				}
				
				// VALIDER LA NOUVELLE SELECTION ACTIVE
				VarSplit.SelecteurActif = Cpt +1;
				g_print ("VarSplit.SelecteurActif = %d\n",VarSplit.SelecteurActif);
				
				// AJOUTER UN SELECTEUR
				VarSplit.NbrSelecteurs ++;
				g_print ("VarSplit.NbrSelecteurs = %d\n",VarSplit.NbrSelecteurs);
				
				// REINDEXER LA NUMEROTATION
				for (IndiceSrc = 0; IndiceSrc < VarSplit.NbrSelecteurs; IndiceSrc ++) {
					VarSplit.Selecteur [ IndiceSrc ] . Nmr = IndiceSrc;
					g_print ("VarSplit.Selecteur [ %d ] . Nmr = %d\n",IndiceSrc, VarSplit.Selecteur [ IndiceSrc ] . Nmr);
				}
				g_print ("VarSplit.Selecteur [ %d ] . Nmr = %d\n",IndiceSrc, VarSplit.Selecteur [ IndiceSrc ] . Nmr);
				
				/*
				RESLOLU @Dzef
				VarSplit.Selecteur [ VarSplit.SelecteurActif ] . Begin         = CursorX;
				VarSplit.Selecteur [ VarSplit.SelecteurActif ] . PercentBegin  = ((gdouble)CursorX / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
				if (CursorX + 50 < VarSplit.SpectreW)
					CursorX += 50;
				else	CursorX = VarSplit.SpectreW;
				VarSplit.Selecteur [ VarSplit.SelecteurActif ] . End           = CursorX;
				VarSplit.Selecteur [ VarSplit.SelecteurActif ] . PercentEnd    = ((gdouble)CursorX / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
				*/
				// end 0  = end -1
				VarSplit.Selecteur [ VarSplit.SelecteurActif ] . End           = VarSplit.Selecteur [ VarSplit.SelecteurActif -1 ] . End;
				VarSplit.Selecteur [ VarSplit.SelecteurActif ] . PercentEnd    = VarSplit.Selecteur [ VarSplit.SelecteurActif -1 ] . PercentEnd;
				
				// end -1 = cursorX
				VarSplit.Selecteur [ VarSplit.SelecteurActif -1 ] . End           = CursorX;
				VarSplit.Selecteur [ VarSplit.SelecteurActif -1 ] . PercentEnd    = ((gdouble)CursorX / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
				
				// Begin  = cursorX
				VarSplit.Selecteur [ VarSplit.SelecteurActif ] . Begin         = CursorX;
				VarSplit.Selecteur [ VarSplit.SelecteurActif ] . PercentBegin  = ((gdouble)CursorX / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
				break;
			}
			// 
			// CAS 4 : CursorX IN END .. BEGIN
			// 
			else if (CursorX > SplitSelector_get_pos_end (Cpt) && CursorX < SplitSelector_get_pos_begin (Cpt +1)) {
				PRINT("CAS 4 : CursorX IN END .. BEGIN");
				// 
				// --
				// 
				PercentCursorX = ((gdouble)CursorX / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
				Len = SplitSelector_get_diff_sec (VarSplit.Selecteur [ Cpt ] . PercentEnd, PercentCursorX);
				if (Len < 5) {
					main_puts_statusbar_global (_("<span color=\"red\">Temps inferieur a 5 secondes entre marqueur et curseur !</span>"));
					return;
				}
				
				Len = SplitSelector_get_diff_sec (PercentCursorX, VarSplit.Selecteur [ Cpt +1 ] . PercentBegin);
				if (Len < 5) {
					main_puts_statusbar_global (_("<span color=\"red\">Temps inferieur a 5 secondes entre marqueur et curseur !</span>"));
					return;
				}
		
				// 
				// g_memmove (dest, src, len)
				// 
				// DEPLACER LES BUFFERS VERS L AVANT
				if (VarSplit.NbrSelecteurs < MAX_SELECTEURS_SPLIT) {
					for (IndiceDest = VarSplit.NbrSelecteurs; IndiceDest > Cpt; IndiceDest --) {
						IndiceSrc = IndiceDest -1;
						g_print ("\tg_memmove(%d, %d, %lu);\n", IndiceDest, IndiceSrc, sizeof(SELECTEUR));
						g_memmove(&VarSplit.Selecteur [ IndiceDest ], &VarSplit.Selecteur [ IndiceSrc ], sizeof(SELECTEUR));
					}
				}
				
				// VALIDER LA NOUVELLE SELECTION ACTIVE
				VarSplit.SelecteurActif = Cpt +1;
				g_print ("VarSplit.SelecteurActif = %d\n",VarSplit.SelecteurActif);
				
				// AJOUTER UN SELECTEUR
				VarSplit.NbrSelecteurs ++;
				g_print ("VarSplit.NbrSelecteurs = %d\n",VarSplit.NbrSelecteurs);
				
				// REINDEXER LA NUMEROTATION
				for (IndiceSrc = 0; IndiceSrc < VarSplit.NbrSelecteurs; IndiceSrc ++) {
					VarSplit.Selecteur [ IndiceSrc ] . Nmr = IndiceSrc;
					g_print ("VarSplit.Selecteur [ %d ] . Nmr = %d\n",IndiceSrc, VarSplit.Selecteur [ IndiceSrc ] . Nmr);
				}
				g_print ("VarSplit.Selecteur [ %d ] . Nmr = %d\n",IndiceSrc, VarSplit.Selecteur [ IndiceSrc ] . Nmr);
				
				VarSplit.Selecteur [ VarSplit.SelecteurActif ] . Begin         = CursorX;
				VarSplit.Selecteur [ VarSplit.SelecteurActif ] . PercentBegin  = ((gdouble)CursorX / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
				
				VarSplit.Selecteur [ VarSplit.SelecteurActif ] . End           = VarSplit.Selecteur [ VarSplit.SelecteurActif +1 ] . Begin;
				VarSplit.Selecteur [ VarSplit.SelecteurActif ] . PercentEnd    = VarSplit.Selecteur [ VarSplit.SelecteurActif +1 ] . PercentBegin;
				
				break;
			}
		}
	}	
	gtk_widget_queue_draw (VarSplit.AdrWidgetSpectre);
}
// 
// TRANSFORME 4 SECONDES EN PIXELS ET RETOUR
// 
gint SplitSelector_get_4_secondes_to_int (void)
{	
	gint		Cpt;
	gint		sec;
	gdouble		dsec;
	gdouble		TimeSongSec;
	gdouble		Percent = 0.0;
	gint		H, M, S, C;
	// gchar		*Str = NULL;
	gint		hundr;
	gint		Len = -1;
	
	if (NULL == VarSplit.Tags || VarSplit.NbrSelecteurs <= 0) {
		return (-1);
	}
	
	// PRINT_FUNC_LF();
	
	// ACQUISITION DUREE TOTALE DU FICHIER EN SECONDES
	TimeSongSec = VarSplit.Tags->SecTime;
	
	for (Cpt = 0; ; Cpt ++) {
		
		sec = (gint) (((gdouble)TimeSongSec * (gdouble)Percent) / 100.0);
		dsec  = ((gdouble)TimeSongSec *(gdouble)Percent) / 100.0;
		hundr = ((gdouble)dsec - (gdouble)sec) * 100.0;
		H = (sec / 60) / 60;
		M = (sec / 60) % 60;
		S = sec % 60;
		C = hundr;
		if (H == 0 && M == 0 && S == 5) {
			Len = (gint)(((gdouble)VarSplit.AdrWidgetSpectre->allocation.width * Percent) / 100.0);
			break;
		}
		if (Cpt > 100000 && S == 0) break;
		Percent += 0.001;
	}
	return (Len);
}
// 
// TRANSFORME 4 SECONDES EN PIXELS ET RETOUR
// 
gdouble SplitSelector_get_percent_for_x_secondes (gint p_secondes)
{	
	gint		Cpt;
	gint		sec;
	gdouble		dsec;
	gdouble		TimeSongSec;
	gdouble		Percent = 0.0;
	gint		H, M, S, C;
	gint		hundr;
	
	if (NULL == VarSplit.Tags || VarSplit.NbrSelecteurs <= 0) {
		return (-1);
	}
	
	// PRINT_FUNC_LF();
	
	// ACQUISITION DUREE TOTALE DU FICHIER EN SECONDES
	TimeSongSec = VarSplit.Tags->SecTime;
	
	for (Cpt = 0; ; Cpt ++) {
		
		sec = (gint) (((gdouble)TimeSongSec * (gdouble)Percent) / 100.0);
		dsec  = ((gdouble)TimeSongSec *(gdouble)Percent) / 100.0;
		hundr = ((gdouble)dsec - (gdouble)sec) * 100.0;
		H = (sec / 60) / 60;
		M = (sec / 60) % 60;
		S = sec % 60;
		C = hundr;
		if (H == 0 && M == 0 && S == p_secondes) {
			return (Percent);
		}
		if (Cpt > 100000 && S == 0) break;
		Percent += 0.001;
	}
	return (Percent);
}
// 
// 
void SplitSelector_get_pos (void)
{
	gint	Cpt;
	
	for (Cpt = 0; Cpt < MAX_SELECTEURS_SPLIT; Cpt ++) {
		VarSplit.Selecteur [ Cpt ] . Begin = (gint)(((gdouble)VarSplit.AdrWidgetSpectre->allocation.width * VarSplit.Selecteur [ Cpt ] . PercentBegin) / 100.0);
		VarSplit.Selecteur [ Cpt ] . End   = (gint)(((gdouble)VarSplit.AdrWidgetSpectre->allocation.width * VarSplit.Selecteur [ Cpt ] . PercentEnd) / 100.0);
	}
}
// 
// TODO : 4 SECONDES EST LA DUREE MINIMUM POUR UNE PLAGE
// 
void SplitSelector_set_pos_begin (gint p_begin)
{
	gint	TimeForSec = SplitSelector_get_4_secondes_to_int ();
	/*gint	Len;
	gint	PosSelecteurActif;
	
	// PRINT_FUNC_LF();
	
	if (-1 != (PosSelecteurActif = SplitSelector_get_PosSelecteurActif (p_begin))) {
		Len = SplitSelector_get_diff_sec (VarSplit.Selecteur [ PosSelecteurActif ] . PercentBegin, VarSplit.Selecteur [ PosSelecteurActif ] . PercentEnd);
		g_print("PosSelecteurActif = %d  Len = %d\n", PosSelecteurActif, Len);
		if (Len < 5) {
			main_puts_statusbar_global (_("Le temps entre deux marqueurs doit etre superieur a 5 secondes"));
			// return;
		}
	}*/

	if (-1 == TimeForSec) return;	
	if (p_begin < 0) p_begin = 0;
	if (p_begin > VarSplit.SpectreW) p_begin = VarSplit.SpectreW;
	if (p_begin + TimeForSec >= VarSplit.SpectreW) return;
	
	if (VarSplit.SelecteurActif > 0) {

		// VERS LE PRECEDENT

		if (p_begin < VarSplit.Selecteur [ VarSplit.SelecteurActif -1 ] . Begin + TimeForSec) {
			p_begin = VarSplit.Selecteur [ VarSplit.SelecteurActif -1 ] . Begin + TimeForSec;
			VarSplit.Selecteur [ VarSplit.SelecteurActif -1 ] . PercentEnd =
					((gdouble)p_begin / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
		}
		if (p_begin < VarSplit.Selecteur [ VarSplit.SelecteurActif -1 ] . End) {
			VarSplit.Selecteur [ VarSplit.SelecteurActif -1 ] . PercentEnd =
					((gdouble)p_begin / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
		}
		
	}
		// VERS LE SUIVANT
		
		if (VarSplit.SelecteurActif  < VarSplit.NbrSelecteurs -1 &&
		    p_begin > VarSplit.Selecteur [ VarSplit.SelecteurActif +1 ] . Begin - TimeForSec) {
			
			p_begin = VarSplit.Selecteur [ VarSplit.SelecteurActif +1 ] . Begin - TimeForSec;
		}
		
		if (p_begin > VarSplit.Selecteur [ VarSplit.SelecteurActif ] . End - TimeForSec) {
			VarSplit.Selecteur [ VarSplit.SelecteurActif ] .        End = p_begin + TimeForSec;
			VarSplit.Selecteur [ VarSplit.SelecteurActif ] . PercentEnd =
					((gdouble)(p_begin + TimeForSec) / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
		}
		
	
	VarSplit.Selecteur [ VarSplit.SelecteurActif  ] . PercentBegin =
			((gdouble)p_begin / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
		
	SplitSelector_get_pos ();
}
// 
// TODO : 4 SECONDES EST LA DUREE MINIMUM POUR UNE PLAGE
// 
void SplitSelector_set_pos_end (gint p_end)
{
	gint	TimeForSec = SplitSelector_get_4_secondes_to_int ();
	/*gint	Len;
	gint	PosSelecteurActif;
	
	// PRINT_FUNC_LF();
	
	if (-1 != (PosSelecteurActif = SplitSelector_get_PosSelecteurActif (p_end))) {
		Len = SplitSelector_get_diff_sec (VarSplit.Selecteur [ PosSelecteurActif ] . PercentBegin, VarSplit.Selecteur [ PosSelecteurActif ] . PercentEnd);
		g_print("PosSelecteurActif = %d  Len = %d\n", PosSelecteurActif, Len);
		if (Len < 5) {
			main_puts_statusbar_global (_("Le temps entre deux marqueurs doit etre superieur a 5 secondes"));
			return;
		}
	}*/
	
	if (-1 == TimeForSec) return;
	if (p_end < 0) p_end = 0;
	if (p_end > VarSplit.SpectreW) p_end = VarSplit.SpectreW;
	
	// LE SELECTEUR DE FIN DOIT BUTTER SUR LE SELECTEUR SUIVANT
	if (VarSplit.NbrSelecteurs -1 > VarSplit.SelecteurActif) {
		if (p_end > VarSplit.Selecteur [ VarSplit.SelecteurActif +1 ] . Begin) {
			p_end = VarSplit.Selecteur [ VarSplit.SelecteurActif +1 ] . Begin;
		}
	}
	
	// BUTTEE SUR SELECTEUR DE DEBUT
	// CHEVAUCHEMENT D INDEX INTERDIT ! PREVOIR ESPACE DE 4 SECONDES
	if (p_end < VarSplit.Selecteur [ VarSplit.SelecteurActif ] . Begin + TimeForSec)
		p_end = VarSplit.Selecteur [ VarSplit.SelecteurActif ] . Begin + TimeForSec;	
	
	VarSplit.Selecteur [ VarSplit.SelecteurActif ] . End = p_end;
	VarSplit.Selecteur [ VarSplit.SelecteurActif ] . PercentEnd = ((gdouble)VarSplit.Selecteur [ VarSplit.SelecteurActif ] . End / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
}
// 
// 
gint SplitSelector_get_pos_begin (gint p_Sel)
{
	SplitSpectre_get_pos_widget ();
	SplitSelector_get_pos ();

	return (VarSplit.Selecteur [ p_Sel ] . Begin);
}
// 
// 
gint SplitSelector_get_pos_end (gint p_Sel)
{
	SplitSpectre_get_pos_widget ();
	SplitSelector_get_pos ();

	return (VarSplit.Selecteur [ p_Sel ] . End);
}
// 
// 
gdouble SplitSelector_get_percent_begin (gint p_Sel)
{
	SplitSpectre_get_pos_widget ();
	SplitSelector_get_pos ();

	return (VarSplit.Selecteur [ p_Sel ] . PercentBegin);
}
// 
// 
gdouble SplitSelector_get_percent_end (gint p_Sel)
{
	SplitSpectre_get_pos_widget ();
	SplitSelector_get_pos ();

	return (VarSplit.Selecteur [ p_Sel ] . PercentEnd);
}

// 
// 
gint SplitSelector_get_pos_play (void)
{
	return ((gint)(((gdouble)VarSplit.AdrWidgetSpectre->allocation.width * VarSplit.PercentActivePlay) / 100.0));
}
// 
// 
gboolean SplitSelector_cursor_in_box_play (gint p_cursor_x, gint p_cursor_y)
{
	if (VarSplit.PercentActivePlay >= 0.0) {
		
		gint	SelPlay = SplitSelector_get_pos_play ();
		
		if (p_cursor_x > SelPlay -6 && p_cursor_x < SelPlay +7)
			if (p_cursor_y > VarSplit.ImgY + VarSplit.ImgH -12 && p_cursor_y < VarSplit.ImgY + VarSplit.ImgH)
				return (TRUE);
	}
	return (FALSE);
}
// 
// 
gboolean SplitSelector_cursor_in_line_play (gint p_cursor_x, gint p_cursor_y)
{
	if (VarSplit.PercentActivePlay >= 0.0) {
		
		gint	SelPlay = SplitSelector_get_pos_play ();
		
		if (p_cursor_x    == SelPlay ||
		    p_cursor_x +1 == SelPlay ||
		    p_cursor_x -1 == SelPlay) {
			if (p_cursor_y > VarSplit.ImgY && p_cursor_y < VarSplit.ImgY + VarSplit.ImgH)
				return (TRUE);
		}
	}
	return (FALSE);
}
// 
// 
void SplitSelector_set_pos_play (gint p_play)
{
	if (p_play < 0) p_play = 0;
	if (p_play > VarSplit.SpectreW) p_play = VarSplit.SpectreW;
	
	VarSplit.PercentActivePlay = ((gdouble)p_play / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
}





































