 /*
 * file      : split_cue.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "tags.h"
#include "conv.h"
#include "configuser.h"
#include "win_scan.h"
#include "win_info.h"
#include "prg_init.h"
#include "split.h"



typedef struct {
	gchar		*OldRep;
	gchar		*TmpRep;

} VAR_SPLITCUE;

VAR_SPLITCUE VarSplitCue;



extern VAR_SPLIT VarSplit;


// 
// 
// 
// 
float SplitCue_get_time_in_sec (gchar *p_str)
{
	gchar		*Ptr = NULL;
	guint		 Min, Sec, Hundr;
	float		 SecondesTempsActuel = 0;

	// MINUTES
	if ((Ptr = strchr (p_str, ':')) != NULL) {
		while (*Ptr != ' ') Ptr --;
		if (*Ptr == ' ') Ptr ++;
		Min = atoi (Ptr);

		// SECONDES
		if ((Ptr = strchr (p_str, ':')) != NULL) {
			Ptr ++;
			Sec = atoi (Ptr);

			// CENTIEMES
			if ((Ptr = strrchr (p_str, ':')) != NULL) {
				Ptr ++;
				Hundr = atoi (Ptr);
				
				// Temps Total en secondes
				SecondesTempsActuel = ((float)Min * 60.0) + (float)Sec + ((float)Hundr / 100.0);
			}
		}
	}
	
	return (SecondesTempsActuel);
}
// 
// TEST LA COHERENCE DU FICHIER CUE
// LECTURE DES INFOS DU FICHIER
// RETOURNE LE NOM DU FICHIER DE MUSIQUE ASSOCIE
// 
gchar *SplitCue_read_cue_file (gchar *p_pathname)
{
	FILE		*fp;
#define MAX_CARS_SPLIT_CUE_FILE 255
	gchar		buf   [ MAX_CARS_SPLIT_CUE_FILE + 4 ];
	gchar		*PathNameSong = NULL;
	gchar		*StrNameSong = NULL;
	gchar		*Ptr = NULL;
	gchar		*Path = NULL;
	gint		IndicePoints = -1;
	gint		FileTimeSec;
	gboolean	BoolResultOk;
	
	// 
	// TEST LA COHERENCE DU FICHIER CUE
	// 
	
	if (NULL == (fp = fopen (p_pathname, "r"))) {
		wininfo_create (
			_("Erreur de lecture !"),
			  "");
		return (NULL);
	}
	
	// PERFORMER "Rita Mitsouko / Rita Mitsouko"
	// TITLE "Rita Mitsouko / Rita Mitsouko"
	// FILE "XCFA_CUE.wav" WAVE
	// 
	// PERFORMER "José de Divina"
	// TITLE "Ibiza World Tour @ Space"
	// FILE "Ibiza1.mp3" WAVE
	// 
	// REM GENRE Jazz
	// REM DATE 1966
	// REM DISCID 120F4902
	// REM COMMENT "ExactAudioCopy v0.95b4"
	// PERFORMER "John Coltrane"
	// TITLE "Live in Japan (CD1)"
	// FILE "un.flac" WAVE

	// REM Cue file written by K3b 1.0.5
	// PERFORMER "Rita Mitsouko"
	// TITLE "Rita Mitsouko"
	// FILE "01 - Restez Avec Moi.wav" WAVE
	
	while (fgets (buf, MAX_CARS_SPLIT_CUE_FILE, fp) != NULL) {
		
		// Si debut de ligne ok
		if (NULL != (Ptr = strstr (buf, "FILE \""))) {

			// StrNameSong contiendra le nom du fichier delimite par les signes "
			Ptr = strchr (buf, '"');
			Ptr ++;
			StrNameSong = g_strdup (Ptr);
			if ((Ptr = strrchr (StrNameSong, '"')) == NULL) {
				fclose (fp);
				g_free (StrNameSong);	StrNameSong = NULL;
				return (NULL);
			}
			*Ptr = '\0';
			
			// Path contiendra le chemin
			Path = g_strdup (p_pathname);
			if ((Ptr = strrchr (Path, '/')) != NULL) {
				*Ptr = '\0';
			}
			
			// PathNameSong contiendra: chemin + nom du fichier musical
			PathNameSong = g_strdup_printf ("%s/%s", Path, StrNameSong);
			g_free (Path);		Path = NULL;
			g_free (StrNameSong);	StrNameSong = NULL;
			break;
		}
	}
	fclose (fp);
	
	// LES TESTS
	if (NULL == PathNameSong) {
		wininfo_create (
			_("Erreur"),
			_("Aucun fichier de musique associe au cue-file !"),
			  "");
		return (NULL);
	}
	if (FALSE == FileIs_g_str_has_suffix (PathNameSong, ".WAV")) {
		g_print ("====\n%s\n----\n%s\t%s\n\t\tFILE NOT IN: .wav\n====\n", p_pathname, buf, PathNameSong);
		wininfo_create (
			_("Erreur"),
			_("Pas de fichier WAV dans le cue-file !"),
			  "");
		g_free (PathNameSong);	PathNameSong = NULL;
		return (NULL);
	}
	if (FALSE == libutils_test_file_exist (PathNameSong)) {
		PRINT("AUCUN FICHIER DE MUSIQUE ASSOCIE DANS LE DOSSIER");
		wininfo_create (
			_("Erreur"),
			_("Aucun fichier de musique associe dans le dossier"),
			  "\n",
			_("du cue-file"),
			  "");
		return (NULL);
	}
	
	// 
	// LECTURE DES INFOS DU FICHIER
	// 
	
	FileTimeSec = tagswav_get_time_sec (PathNameSong);
	
	fp = fopen (p_pathname, "r");
	while (fgets (buf, MAX_CARS_SPLIT_CUE_FILE, fp) != NULL) {
		
		if (strstr (buf, "TRACK ")) {
			// g_print("TRACK ->%s", buf);
		}
		
		// DEBUT
		
		else if (strstr (buf, "INDEX 01")) {
			IndicePoints ++;
			VarSplit.Selecteur [ IndicePoints ] . Nmr             = IndicePoints;
			VarSplit.Selecteur [ IndicePoints ] . Begin           = SplitCue_get_time_in_sec (buf);
			VarSplit.Selecteur [ IndicePoints ] . PercentBegin    = ((gdouble)VarSplit.Selecteur [ IndicePoints ] . Begin / (gdouble)FileTimeSec) * 100.0;
		} 
		
		// FIN
		
		else if (strstr (buf, "INDEX 00")) {
			VarSplit.Selecteur [ IndicePoints ] . Nmr             = IndicePoints;
			VarSplit.Selecteur [ IndicePoints ] . End             = SplitCue_get_time_in_sec (buf);
			VarSplit.Selecteur [ IndicePoints ] . PercentEnd      = ((gdouble)VarSplit.Selecteur [ IndicePoints ] . End / (gdouble)FileTimeSec) * 100.0;
		}
		
		else if (strstr (buf, "TITLE ")) {
			// g_print("TITLE ->%s", buf);
		} 
		
	}
	fclose (fp);
	
	// AJUSTER LE DEBUT
	VarSplit.Selecteur [ 0 ] . Begin         = 1;
	
	// AJUSTER LA FIN
	VarSplit.Selecteur [ IndicePoints ] . PercentEnd    = 99.99;
	VarSplit.Selecteur [ IndicePoints ] . End           = FileTimeSec;
	
	// TESTER LA COHERENCE DES DATAS
	BoolResultOk = TRUE;
	g_print ("\n");
	for (IndicePoints = 0; VarSplit.Selecteur [ IndicePoints ] . Nmr != -1; IndicePoints ++) {
		g_print ("[ %2d ]   TIME = %05d  BEGIN = %5d  END = %5d  PERCENTBEGIN = %f  PERCENTEND = %f\n",
			VarSplit.Selecteur [ IndicePoints ] . Nmr,
			FileTimeSec,
			(gint)VarSplit.Selecteur [ IndicePoints ] . Begin,
			(gint)VarSplit.Selecteur [ IndicePoints ] . End,
			VarSplit.Selecteur [ IndicePoints ] . PercentBegin,
			VarSplit.Selecteur [ IndicePoints ] . PercentEnd
			);
		if ((gint)VarSplit.Selecteur [ IndicePoints ] . Begin > (gint)VarSplit.Selecteur [ IndicePoints ] . End) {
			BoolResultOk = FALSE;
			g_print ("\t--- ERREUR [ 1 ] DE DATAS DANS LE FICHIER CUE !!! ---\n");
		}
		if (VarSplit.Selecteur [ IndicePoints +1 ] . Nmr != -1) {
			if ((gint)VarSplit.Selecteur [ IndicePoints ] . End > (gint)VarSplit.Selecteur [ IndicePoints +1 ] . Begin) {
				BoolResultOk = FALSE;
				g_print ("\t--- [ 2 ] ERREUR DE DATAS DANS LE FICHIER CUE !!! ---\n");
			}
		}
	}
	g_print ("\n");
	
	// ERREUR DE DATAS DANS LE FICHIER CUE !!!
	if (FALSE == BoolResultOk) {
		if (NULL != PathNameSong) {
			g_free (PathNameSong);
			PathNameSong = NULL;
			
			wininfo_create (
				_("Erreur de donnees dans le fichier CUE"),
				_("La solution est d'importer le fichier de"),
				  "\n",
				_("musique qui sera reconnu et pre-decoupe"),
				  "\n",
				_("dans le module Split."),
				  "\n\n",
				_("Il ne restera qu'a ajuster les plages pour"),
				  "\n",
				_("generer un nouveau cue-file ou des decoupes"),
				  "\n",
				_("correspondant aux plages."),
				  "");
		}
	}
	
	// 
	// RETOURNE LE NOM DU FICHIER DE MUSIQUE ASSOCIE
	// 
	return ((gchar *)PathNameSong);
}
// 
// 
// 
void on_button_gen_cue_split_clicked (GtkButton *button, gpointer user_data)
{
	gint		IndicePoints;
	gdouble		Percent;
	gint		H, M, S, C;
	gint		sec;
	gdouble		dsec;
	gdouble		TimeSongSec;
	gint		hundr;
	gchar		*Ptr = NULL;
	gchar		*PathNameFileCue = NULL;
	gchar		*NameFileWav = NULL;
	gchar		*PathFileCue = NULL;
	gchar		*NameFileCue = NULL;
	gint		NumFileCue;
	FILE		*fp;
	
	PRINT_FUNC_LF();
	TimeSongSec = VarSplit.Tags->SecTime;

	for (IndicePoints = 0; VarSplit.Selecteur [ IndicePoints ] . Nmr != -1; IndicePoints ++) {
		
		Percent = VarSplit.Selecteur [ IndicePoints ] . PercentBegin;
		sec = (gint) (((gdouble)TimeSongSec * (gdouble)Percent) / 100.0);
		dsec  = ((gdouble)TimeSongSec *(gdouble)Percent) / 100.0;
		hundr = ((gdouble)dsec - (gdouble)sec) * 100.0;
		H = (sec / 60) / 60;
		M = (sec / 60) % 60;
		S = sec % 60;
		C = hundr;
		
		g_print ("[ %02d ] ", IndicePoints);
		g_print ("%02d:%02d:%02d   ", M, S, C);
		
		Percent = VarSplit.Selecteur [ IndicePoints ] . PercentEnd;
		sec = (gint) (((gdouble)TimeSongSec * (gdouble)Percent) / 100.0);
		dsec  = ((gdouble)TimeSongSec *(gdouble)Percent) / 100.0;
		hundr = ((gdouble)dsec - (gdouble)sec) * 100.0;
		H = (sec / 60) / 60;
		M = (sec / 60) % 60;
		S = sec % 60;
		C = hundr;
		
		g_print ("%02d:%02d:%02d", M, S, C);
		g_print ("\n");
	}
	
	g_print ("\n");
	
	// NOM DU CUE
	/*PathNameFileCue = g_strdup (VarSplit.PathNameFile);
	Ptr = strrchr (PathNameFileCue, '.');
	Ptr ++;
	*Ptr ++ = 'c';
	*Ptr ++ = 'u';
	*Ptr ++ = 'e';
	*Ptr ++ = '\0';*/
	Ptr = strrchr (VarSplit.PathNameFileReal, '/');
	PathNameFileCue = g_strdup_printf ("%s%s", Config.PathDestinationSplit, Ptr);
	Ptr = strrchr (PathNameFileCue, '.');
	Ptr ++;
	*Ptr ++ = 'c';
	*Ptr ++ = 'u';
	*Ptr ++ = 'e';
	*Ptr ++ = '\0';
	
	// NOM DU WAV
	Ptr = strrchr (VarSplit.PathNameFile, '/');
	Ptr ++;
	NameFileWav = g_strdup (Ptr);
	
	// DEBUG
	g_print ("PathNameFileCue = %s\n", PathNameFileCue);
	g_print ("NameFileWav     = %s\n", NameFileWav);
	
	// CHANGER LE NOM DU FICHIER CUE SI IL EXIST
	if (TRUE == libutils_test_file_exist (PathNameFileCue)) {
		PRINT("PathNameFileCue  EXIST");
		
		// PATH CUE FILE
		PathFileCue = g_strdup (PathNameFileCue);
		Ptr = strrchr (PathFileCue, '/');
		Ptr ++;
		*Ptr = '\0';
		
		// NAME CUE FILE
		Ptr = strrchr (PathNameFileCue, '/');
		Ptr ++;
		NameFileCue = g_strdup (Ptr);
		NumFileCue = 1;
		while (TRUE == libutils_test_file_exist (PathNameFileCue)) {
			g_free (PathNameFileCue);	PathNameFileCue = NULL;
			PathNameFileCue = g_strdup_printf ("%s%02d_%s", PathFileCue, NumFileCue, NameFileCue);
			NumFileCue ++;
		}
		g_free (PathFileCue);		PathFileCue = NULL;
		g_free (NameFileCue);		NameFileCue = NULL;
		g_print ("NOUVEAU PathNameFileCue = %s\n", PathNameFileCue);
	}	
	
	fp = fopen (PathNameFileCue, "w");
	
	// PRODUCTION DU FICHIER CUE
	g_print ("\n");
	fprintf (fp,   "REM Cue file written by Xcfa\n\n");
	fprintf (fp,   "PERFORMER \"%s\"\n", "CHANTEUR");
	fprintf (fp,   "TITLE \"%s\"\n", "TITRE DISQUE");
	fprintf (fp,   "FILE \"%s\" WAVE\n", NameFileWav);
	
	// DUREE TOTALE EXPRIMEE EN SECONDES
	TimeSongSec = VarSplit.Tags->SecTime;
	
	for (IndicePoints = 0; VarSplit.Selecteur [ IndicePoints ] . Nmr != -1; IndicePoints ++) {
		
		fprintf (fp,   "  TRACK %02d AUDIO\n", IndicePoints +1);
		fprintf (fp,   "    PERFORMER \"\"\n");
		fprintf (fp,   "    TITLE \"Track_%02d\"\n", IndicePoints +1);
		if (IndicePoints > 0) {
			
			// INDEX DE FIN
			
			Percent = VarSplit.Selecteur [ IndicePoints -1 ] . PercentEnd;
			sec = (gint) (((gdouble)TimeSongSec * (gdouble)Percent) / 100.0);
			dsec  = ((gdouble)TimeSongSec *(gdouble)Percent) / 100.0;
			hundr = ((gdouble)dsec - (gdouble)sec) * 100.0;
			H = (sec / 60) / 60;
			M = (sec / 60) % 60;
			S = sec % 60;
			C = hundr;
			
			fprintf (fp,   "    INDEX 00 %02d:%02d:%02d\n", M, S, C);
		}
		
		// INDEX DE DEBUT
		
		Percent = VarSplit.Selecteur [ IndicePoints ] . PercentBegin;
		sec = (gint) (((gdouble)TimeSongSec * (gdouble)Percent) / 100.0);
		dsec  = ((gdouble)TimeSongSec *(gdouble)Percent) / 100.0;
		hundr = ((gdouble)dsec - (gdouble)sec) * 100.0;
		H = (sec / 60) / 60;
		M = (sec / 60) % 60;
		S = sec % 60;
		C = hundr;
		
		fprintf (fp,   "    INDEX 01 %02d:%02d:%02d\n", M, S, C);
	}
	fprintf (fp,   "\n");
	
	fclose (fp);
	
	g_free (PathNameFileCue);	PathNameFileCue = NULL;
	g_free (NameFileWav);		NameFileWav = NULL;
}


/*
	CUE/
		jazz
		jazz.cue
	
	// DEBUT 
	$ wavsplit --Hours ./jazz.wav 0:00:00 0:03:00

	CUE/
		jazz
		jazz.cue
		jazz/
			01.wav
			02.wav <--- Result
			03.wav
	
	// MILIEU
	$ wavsplit --Hours ./jazz.wav 0:03:03 0:06:05
	
	CUE/
		jazz
		jazz.cue
		jazz/
			01.wav
			02.wav  <--- Result
			03.wav
	
	// FIN
	$ wavsplit --Hours ./jazz.wav  0:12:49 0:15:42

	CUE/
		jazz
		jazz.cue
		jazz/
			01.wav
			02.wav <--- Result
			03.wav
*/
// 
// 
// 
void SplitCue_thread (void)
{
	gchar	*Src = NULL;
	gchar	*Dest = NULL;
	gchar	*TmpWav = NULL;
	gint	pos = 0;
	gint	H, M, S, C, hundr;
	gint	sec;
	gdouble	dsec;
	gdouble	Percent;
	gdouble	TimeSongSec;
	gint	Plage;
	gchar	*BeginTime = NULL;
	gchar	*EndTime = NULL;
	
	PRINT_FUNC_LF();
	conv.bool_thread_conv = TRUE;
	
	// COPIE DU FICHIER ORIGINAL VERS LE DOSSIER TEMPRAIRE
	Src  = g_strdup (VarSplit.PathNameFile);
	TmpWav = g_strdup_printf ("%s/xcfa.wav", VarSplitCue.TmpRep);
	conv_copy_src_to_dest (Src, TmpWav);
	g_free (Src);	Src  = NULL;
	
	// DUREE TOTALE EXPRIMEE EN SECONDES
	TimeSongSec = VarSplit.Tags->SecTime;
	
	for (Plage = 0; VarSplit.Selecteur [ Plage ] . Nmr != -1; Plage ++) {
		
		if (TRUE == WindScan_close_request ()) {
			break;
		}
		
		// VALEUR DEBUT DE LA PLAGE
		Percent = VarSplit.Selecteur [ Plage ] . PercentBegin;
		sec = (gint) (((gdouble)TimeSongSec * (gdouble)Percent) / 100.0);
		dsec  = ((gdouble)TimeSongSec * (gdouble)Percent) / 100.0;
		hundr = ((gdouble)dsec - (gdouble)sec) * 100.0;
		H = (sec / 60) / 60;
		M = (sec / 60) % 60;
		S = sec % 60;
		C = hundr;
		BeginTime = g_strdup_printf ("%02d:%02d:%02d:%02d", H,M,S,C);
		
		// VALEUR FIN DE LA PLAGE
		Percent = VarSplit.Selecteur [ Plage ] . PercentEnd;
		sec = (gint) (((gdouble)TimeSongSec * (gdouble)Percent) / 100.0);
		dsec  = ((gdouble)TimeSongSec *(gdouble)Percent) / 100.0;
		hundr = ((gdouble)dsec - (gdouble)sec) * 100.0;
		H = (sec / 60) / 60;
		M = (sec / 60) % 60;
		S = sec % 60;
		C = hundr;
		EndTime   = g_strdup_printf ("%02d:%02d:%02d:%02d", H,M,S,C);
		
		// $ wavsplit --Hours ./xcfa.wav BeginTime EndTime
		
		// EXTRACTION AVEC WAVSPLIT
		pos = filelc_get_command_line_nice ();
		conv.ArgConv [ pos++ ] = g_strdup ("wavsplit");
		conv.ArgConv [ pos++ ] = g_strdup (TmpWav);
		conv.ArgConv [ pos++ ] = g_strdup ("--Hours");
		conv.ArgConv [ pos++ ] = g_strdup (BeginTime);
		conv.ArgConv [ pos++ ] = g_strdup (EndTime);
		conv.ArgConv [ pos++ ] = NULL;
		
		// g_print ("BeginTime = %s    EndTime = %s\n", BeginTime, EndTime);
		conv_to_convert (FALSE, WAVSPLIT_EXTRACT, "WAVSPLIT_EXTRACT");
		filelc_get_command_line_remove ();
		g_free (BeginTime);	BeginTime = NULL;
		g_free (EndTime);	EndTime = NULL;
		
		// COPIE DE L EXTRACTION VERS LA DESTINATION
		Src  = g_strdup_printf ("%s/xcfa/02.wav", VarSplitCue.TmpRep);
		Dest = g_strdup_printf ("%s/%02d_xcfa_split.wav", Config.PathDestinationSplit, Plage +1);
		conv_copy_src_to_dest (Src, Dest);
		g_free (Src);	Src  = NULL;
		g_free (Dest);	Dest = NULL;
	}
		
	g_free (TmpWav);	TmpWav = NULL;
	
	PRINT("FIN THREAD SPLIT EXTRACT");
	conv.bool_thread_conv = FALSE;
	pthread_exit(0);
}
// 
// 
// 
static gint SplitCue_timeout (gpointer data)
{
	if (TRUE == conv.bool_thread_conv) {
	
	}
	else {
		// SE PLACER DANS LE DOSSIER D ORIGINE
		g_chdir (VarSplitCue.OldRep);
		g_free (VarSplitCue.OldRep);	VarSplitCue.OldRep = NULL;
		
		// REMOVE DOSSIER TEMPORAIRE
		if (NULL != VarSplitCue.TmpRep)  {
			VarSplitCue.TmpRep  = libutils_remove_temporary_rep (VarSplitCue.TmpRep);
		}
		
		PRINT("FIN TIMEOUT SPLIT EXTRACT");
		gtk_timeout_remove (conv.handler_timeout_conv);
		
		WindScan_close ();
	}
	return (TRUE);
}
// 
// 
// 
void on_button_action_split_clicked (GtkButton *button, gpointer user_data)
{
	pthread_t  nmr_tid;
	
	PRINT_FUNC_LF();
	
	if (FALSE == PrgInit.bool_wavsplit) {
		wininfo_create (
			_("wavsplit absent"),
			_("wavsplit est absent de votre configuration."),
			  "\n\n",
			_("Veuillez l'installer."),
			  "");
		return;
	}
	
	WindScan_open ("Split file", WINDSCAN_PULSE);
	WindScan_set_label ("<b><i>Split file ...</i></b>");
	conv_reset_struct (WindScan_close_request);
	
	// NOUVEAU DOSSIER AND GOTO
	VarSplitCue.OldRep = g_get_current_dir ();
	if (NULL == VarSplitCue.TmpRep)  {
		VarSplitCue.TmpRep  = libutils_create_temporary_rep (Config.PathnameTMP, PATH_TMP_XCFA_WAVSPLIT);
	}
	// SE PLACER DANS LE DOSSIER TEMPORAIRE
	g_chdir (VarSplitCue.TmpRep);

	conv.bool_thread_conv = TRUE;
	PRINT("DEBUT THREAD SPLIT EXTRACT");
	pthread_create (&nmr_tid, NULL ,(void *)SplitCue_thread, (void *)NULL);
	PRINT("DEBUT TIMEOUT SPLIT EXTRACT");
	conv.handler_timeout_conv = gtk_timeout_add (300, SplitCue_timeout, 0);
}

























