 /*
 * file      : split.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef split_h
#define split_h 1

#define FOND_BLANC \
	gdk_color.red = 65535; \
	gdk_color.green = 65535; \
	gdk_color.blue = 65535; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_window_set_background (VarSplit.AdrWidgetSpectre->window, &gdk_color);

#define FOND_NOIR \
	gdk_color.red = 0; \
	gdk_color.green = 0; \
	gdk_color.blue = 0; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_window_set_background (VarSplit.AdrWidgetSpectre, &gdk_color);

#define FOND_BLEU \
	gdk_color.red = 0; \
	gdk_color.green = 0; \
	gdk_color.blue = 65535; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_window_set_background (VarSplit.AdrWidgetSpectre->window, &gdk_color);

#define CRAYON_NOIR \
	gdk_color.red = 0; \
	gdk_color.green = 0; \
	gdk_color.blue = 0; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_gc_set_foreground (gc, &gdk_color);

#define CRAYON_GRIS \
	gdk_color.red = 21845; \
	gdk_color.green = 21845; \
	gdk_color.blue = 21845; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_gc_set_foreground (gc, &gdk_color);

#define CRAYON_GRIS_CLAIR \
	gdk_color.red = 30767; \
	gdk_color.green = 30767; \
	gdk_color.blue = 30767; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_gc_set_foreground (gc, &gdk_color);

#define CRAYON_BLANC \
	gdk_color.red = 65535; \
	gdk_color.green = 65535; \
	gdk_color.blue = 65535; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_gc_set_foreground (gc, &gdk_color);

#define CRAYON_BLEU \
	gdk_color.red = 0; \
	gdk_color.green = 0; \
	gdk_color.blue = 65535; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_gc_set_foreground (gc, &gdk_color);

#define CRAYON_BLEU_CLAIR \
	gdk_color.red = 0; \
	gdk_color.green = 32000; \
	gdk_color.blue = 65535; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_gc_set_foreground (gc, &gdk_color);

#define CRAYON_BLEU_CLAIR_PLUS \
	gdk_color.red = 0; \
	gdk_color.green = 47000; \
	gdk_color.blue = 65535; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_gc_set_foreground (gc, &gdk_color);

#define CRAYON_ROUGE \
	gdk_color.red = 65535; \
	gdk_color.green = 0; \
	gdk_color.blue = 0; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_gc_set_foreground (gc, &gdk_color);

#define CRAYON_VERT \
	gdk_color.red = 0; \
	gdk_color.green = 65500; \
	gdk_color.blue = 0; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_gc_set_foreground (gc, &gdk_color);

#define CRAYON_JAUNE \
	gdk_color.red = 65535; \
	gdk_color.green = 65535; \
	gdk_color.blue = 0; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_gc_set_foreground (gc, &gdk_color);

#define CRAYON_ORANGE \
	gdk_color.red = 0xffff; \
	gdk_color.green = 0x9999; \
	gdk_color.blue = 0; \
	gdk_color_alloc (colormap, &gdk_color); \
	gdk_gc_set_foreground (gc, &gdk_color);



#include "file.h"

typedef struct {								// DEFINITION D'UN POINT POUR LA LECTURE DU FICHIER WAV
	float		Max;							// Partie haute
	float		Min;							// Partie basse
} POINTS_FILE;


typedef struct {								// SPECIFICATION D'UN SELECTEUR
	gint	Nmr;								// 
	float	Begin;								// 
	float	End;								// 
	float	PercentBegin;							// 
	float	PercentEnd;							// 
} SELECTEUR;

typedef enum {
	_CURSOR_IS_NONE_ = 0,
	_CURSOR_IS_LEFT_,
	_CURSOR_IS_RIGHT_,
	_CURSOR_IS_HAND_
} TYPE_CURSOR;

/*
From Dzef:
Salut la bande,
Ouaip, 99 me semble être le bon choix : c'est le nombre de plages maximum
que l'on puisse trouver car c'est le nombre maximum que peuvent afficher les
afficheurs standards des players de salon...
Les CDs de 99 plages existent, c'est par exemple assez fréquent dans les
disques de bruitage...
*/
#define	MAX_SELECTEURS_SPLIT	100
#define	SPLIT_FILE_TMP_WAV	"/tmp/split_wav2sox.wav"
#define	SPLIT_FILE_TMP_WAV_SOX	"/tmp/split_wav2wavsox.wav"


typedef struct {
	GtkWidget		*AdrWidgetSpectre;				// Adr Widget Spectre
	GtkWidget		*AdrWidgetSpectreChrono;			// Adr Widget Spectre Chrono
	
	GtkButton		*Adr_button_destination;			// Adr du widget de la destinations des decoupes
	
	gint			ImgX, ImgY, ImgW, ImgH;				// Coordonnees reelle de l'image
	gint			ChronoX, ChronoY, ChronoW, ChronoH;		// Coordonnees de la partie chrono
	gint			SpectreTopX, SpectreTopY, SpectreTopW, SpectreTopH;
	gint			SpectreX, SpectreY, SpectreW, SpectreH;		// Coordonnees du Spectre
	
	gint			NbrSelecteurs;					// Nombre total de selecteurs
	SELECTEUR		Selecteur [ MAX_SELECTEURS_SPLIT +2 ];		// Tableau des selecteurs
	gint			SelecteurActif;					// Le selecteur actif si NbrSelecteurs > -1
	
	gboolean		BoolReadFileSpectre;				// TRUE = BoolReadFileSpectre else NONE
	
	gint			NbrZoom;
	gint			InitwidthZoom;
	
	gdouble			TimeSongSec;					// Duree totale du fichier en secondes
	
	void			(*FuncExternBegin) (gdouble Percent);		// Rappel modif pointeur DEBUT
	void			(*FuncExternEnd) (gdouble Percent);		// Rappel modif pointeur FIN
	void			(*FuncExternWaitPlay) (void);			// Rappel selection d'ecoute
	void			(*FuncExternStopPlay) (void);			// Rappel fin d'ecoute
	
	gdouble			PercentActivePlay;				// Pointeur de lecture audio
	
	gboolean		BoolEventButtonPressSpectre;			// 
	
	POINTS_FILE		*Tab;						// Tableau des amplitudes du fichier actif
	glong			TotalAllocation;				// Longeur du tableau Tab
	gint			MaxPointsInTab;					// 
	GdkPoint		*MaxScale_0;					// 
	GdkPoint		*MinScale_0;					// 
	GdkPoint		*MaxScale_1;					// 
	GdkPoint		*MinScale_1;					// 
	GdkPoint		*MaxScale_2;					// 
	GdkPoint		*MinScale_2;					// 
	
	glong			TotalAllocationTabScreen;			// Longeur du tableau TabScreen
	gshort			nBitsPerSample;					// 8 16 24 et 32
	gint			nTotalChunckSize;				// Taille des données
	
	gchar			*PathNameFile;					// Nom complet du fichier
	gchar			*PathNameFileReal;				// Nom reel du fichier
	TYPE_FILE_IS		TypeFileIs;					// WAV,  MP3, OGG, FLAC, SHN, WAVPACK
	INFO_WAV		*Tags;						// 
	
	gboolean		BoolInThread;
	guint			HandlerTimeoutDo;
	
	TYPE_CURSOR		TypeCursorSpectre;				// NONE | LEFT | RIGHT
	
	gboolean		BoolPlay;					// FALSE -> TRUE -> FALSE
	
	gboolean		BoolQueueDrawSpectre;				// 
	gboolean		BoolQueueDrawChrono;				// 
	
	gboolean		BoolBlankWithCue;				// 
	
} VAR_SPLIT;

gboolean	SplitSpectre_read_file_spectre (gchar *PathNameFile);
void		SplitSpectre_draw_lines (void);
void		SplitSpectre_realize (GtkWidget *widget);
void		split_draw (void);
void		SplitSpectre_get_pos_widget (void);
void		SplitSpectre_draw_chrono (void);
void		SplitSpectre_draw_top (void);
gint		SplitSpectre_get_with_scrollwindow (void);
void		SplitSpectre_remove (void);

void		split_file_load_continue (gchar *p_PathNameFile);
void		split_load_from_dnd (GSList *p_list);
void		split_set_name_file (void);
void		split_play (void);
void		split_set_stop (void);
void		split_from_popup (gint p_choice);
void		split_set_flag_buttons (void);

void		SplitSelector_init (void);
void		SplitSelector_cut (void);
void		SplitSelector_add (gint p_CursorX);
void		SplitSelector_set_pos_begin (gint p_begin);
void		SplitSelector_set_pos_end (gint p_end);
void		SplitSelector_get_pos (void);
gint		SplitSelector_get_pos_begin (gint p_Sel);
gint		SplitSelector_get_pos_end (gint p_Sel);
gdouble		SplitSelector_get_percent_begin (gint p_Sel);
gdouble		SplitSelector_get_percent_end (gint p_Sel);
gint		SplitSelector_get_4_secondes_to_int (void);
gdouble		SplitSelector_get_percent_for_x_secondes (gint p_secondes);
gboolean	SplitSelector_cursor_in_box_play (gint p_cursor_x, gint p_cursor_y);
gboolean	SplitSelector_cursor_in_line_play (gint p_cursor_x, gint p_cursor_y);
gint		SplitSelector_get_pos_play (void);
void		SplitSelector_set_pos_play (gint p_play);
gint		SplitSelector_get_diff_sec (gdouble p_PercentBegin, gdouble p_PercentEnd);

gchar		*SplitCue_read_cue_file (gchar *p_pathname);

void		SplitConv_to (gchar *p_PathNameFile);


#endif


